(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45599,       1310]
NotebookOptionsPosition[     44890,       1285]
NotebookOutlinePosition[     45276,       1302]
CellTagsIndexPosition[     45233,       1299]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}]], "Input",
 CellChangeTimes->{{3.51740381790625*^9, 3.51740382528125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"General", "::", "\"\<spell1\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f0", "=", "440."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nharm", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sr", "=", "100000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rd1", ":=", 
  RowBox[{"Random", "[", 
   RowBox[{"Real", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".5"}], ",", ".5"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"rd2", ":=", 
  RowBox[{"Random", "[", 
   RowBox[{"Real", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.8"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tauSude", "=", "5."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kASude", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tauLiche", "=", "10."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KALiche", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sude1", "[", "i_", "]"}], ":=", 
   RowBox[{"kASude", "*", "0.5", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "i"]}], ")"}], "*", 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "i"}], "*", "tauSude"}], "nharm"], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S1", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"sude1", "/@", 
      RowBox[{"Range", "[", "nharm", "]"}]}], ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"liche1", "[", "i_", "]"}], ":=", 
   RowBox[{"KALiche", "*", "0.5", "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "i"]}], ")"}], "*", 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "i"}], "*", "tauLiche"}], "nharm"], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L1", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"liche1", "/@", 
      RowBox[{"Range", "[", "nharm", "]"}]}], ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"S1", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"PointSize", "[", "0.02", "]"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"L1", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"PointSize", "[", "0.02", "]"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.444578213962*^9, 3.444578235079*^9}, {3.444578298962*^9,
    3.4445783097469997`*^9}, {3.444578908076*^9, 3.4445789085369997`*^9}, {
   3.444583546733*^9, 3.444583547396*^9}, {3.4445924328120003`*^9, 
   3.444592446035*^9}, 3.44459257999*^9, {3.444592636256*^9, 
   3.444592636523*^9}, {3.444594029727*^9, 3.444594037302*^9}, {
   3.4445948059960003`*^9, 3.4445948166*^9}, {3.4446308316506104`*^9, 
   3.4446308327270107`*^9}, {3.4446308787214108`*^9, 3.44463087889301*^9}, {
   3.4446311893422103`*^9, 3.4446311894514103`*^9}, {3.4446371096355934`*^9, 
   3.4446371098699684`*^9}, {3.4448419343825097`*^9, 
   3.4448419445015097`*^9}, {3.4448445502035093`*^9, 
   3.4448445516715097`*^9}, {3.4448512891545095`*^9, 
   3.4448512902245097`*^9}, {3.4448514554765096`*^9, 
   3.4448514558955097`*^9}, {3.4448520736165094`*^9, 3.44485207374751*^9}, {
   3.4448521385755095`*^9, 3.4448521607515097`*^9}, {3.4448522170095096`*^9, 
   3.44485224844051*^9}, {3.4448523174655094`*^9, 3.4448523221915092`*^9}, {
   3.444931636362975*^9, 3.4449316596381755`*^9}, {3.4449321647781754`*^9, 
   3.444932169411375*^9}, {3.4449323450517755`*^9, 3.4449323566787753`*^9}, {
   3.4449326267903757`*^9, 3.4449326565551753`*^9}, {3.4452775155279055`*^9, 
   3.4452775180707054`*^9}, {3.4452775860559053`*^9, 3.445277586664305*^9}, {
   3.445277658379305*^9, 3.445277680406505*^9}, {3.445277760090705*^9, 
   3.4452777618847055`*^9}, 3.445278990031905*^9, {3.4452791825511055`*^9, 
   3.445279186591505*^9}, {3.517403835390625*^9, 3.517403844625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tonL", "[", 
    RowBox[{"k_", ",", "t_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", "*", "f0", "*", "2", "*", "Pi", "*", "#", "*", "t"}], 
        "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"nharm", "+", "1"}], "]"}]}], ")"}], ".", "L1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tonS", "[", 
    RowBox[{"k_", ",", "t_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", "*", "f0", "*", "2", "*", "Pi", "*", "#", "*", "t"}], 
        "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"nharm", "+", "1"}], "]"}]}], ")"}], ".", "S1"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.444578773156*^9, 3.444578788574*^9}, {3.44458353625*^9, 
  3.444583539034*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pyth1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["2187", "2048"], ",", 
     FractionBox["9", "8"], ",", 
     FractionBox["32", "27"], ",", 
     FractionBox["81", "64"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["729", "512"], ",", 
     FractionBox["3", "2"], ",", 
     FractionBox["128", "81"], ",", 
     FractionBox["27", "16"], ",", 
     FractionBox["16", "9"], ",", 
     FractionBox["243", "128"], ",", "2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"temper", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RadicalBox[
      SuperscriptBox["2.", "i"], "12"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fPyth", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"1.", "*", 
     RowBox[{"pyth1", "[", 
      RowBox[{"[", "k", "]"}], "]"}]}], "/;", 
    RowBox[{"1", "\[LessEqual]", "k", "\[LessEqual]", "12"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fPyth", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"2.", "*", 
     RowBox[{"fPyth", "[", 
      RowBox[{"k", "-", "12"}], "]"}]}], "/;", 
    RowBox[{"k", ">", "12"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fPyth", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"0.5", "*", 
     RowBox[{"fPyth", "[", 
      RowBox[{"k", "+", "12"}], "]"}]}], "/;", 
    RowBox[{"k", "<", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTemper", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"1.", "*", 
     RowBox[{"temper", "[", 
      RowBox[{"[", "k", "]"}], "]"}]}], "/;", 
    RowBox[{"1", "\[LessEqual]", "k", "\[LessEqual]", "12"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTemper", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"2.", "*", 
     RowBox[{"fTemper", "[", 
      RowBox[{"k", "-", "12"}], "]"}]}], "/;", 
    RowBox[{"k", ">", "12"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTemper", "[", "k_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"0.5", "*", 
     RowBox[{"fTemper", "[", 
      RowBox[{"k", "+", "12"}], "]"}]}], "/;", 
    RowBox[{"k", "<", "1"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.444578113352*^9, 3.44457813291*^9}, 3.444586347208*^9, {
   3.4446371872605934`*^9, 3.4446371935418434`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fceprot", "[", 
    RowBox[{"list_", ",", "doba_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"length", ",", "pom"}], "}"}], ",", 
     RowBox[{
      RowBox[{"length", "=", 
       RowBox[{"Round", "[", 
        RowBox[{"doba", "*", "sr"}], "]"}]}], ";", 
      RowBox[{"pom", "=", 
       RowBox[{"NestWhile", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", "list", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], "<", "length"}], "&"}]}], 
        "]"}]}], ";", 
      RowBox[{"Take", "[", 
       RowBox[{"pom", ",", "length"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4445838329779997`*^9, 3.444583834567*^9}, 
   3.4445841179300003`*^9, 3.4448421114755096`*^9, {3.44485199555851*^9, 
   3.44485202522351*^9}, 3.444931969391775*^9, {3.4449325905203753`*^9, 
   3.4449326168219757`*^9}, {3.445274847917905*^9, 3.4452748617395053`*^9}}],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"k0", "=", 
    RowBox[{"-", "56"}]}], ";"}],
  FontColor->RGBColor[0.6, 0.4, 0.2]], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"k01", "=", "70"}], ";"}],
  FontColor->RGBColor[0.6, 0.4, 0.2]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<f do k01= \>\"", ",", "k0", ",", "\"\<   \>\"", ",", 
    RowBox[{"f0", "*", 
     RowBox[{"fPyth", "[", "k0", "]"}]}], ",", " ", 
    "\"\< a odpovidajici perioda T= \>\"", ",", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"f0", "*", 
       RowBox[{"fPyth", "[", "k0", "]"}]}], ")"}], 
     RowBox[{"-", "1"}]], ",", "\"\< s\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<f do k01= \>\"", ",", "k01", ",", "\"\<   \>\"", ",", 
   RowBox[{"f0", "*", 
    RowBox[{"fPyth", "[", "k01", "]"}]}], ",", " ", 
   "\"\< a odpovidajici perioda T= \>\"", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"f0", "*", 
      RowBox[{"fPyth", "[", "k01", "]"}]}], ")"}], 
    RowBox[{"-", "1"}]], ",", "\"\< s\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fPyth", "/@", 
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fTemper", "/@", 
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"%", "-", "%%"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aK", "[", "k_", "]"}], ":=", 
   RowBox[{"0.01", "+", 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["8",
          FontColor->RGBColor[0.6, 0.4, 0.2]], "."}]], "*", 
       RowBox[{"(", 
        RowBox[{"k0", "-", "k"}], ")"}]}], 
      RowBox[{"(", 
       RowBox[{"k01", "-", "k0"}], ")"}]], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"aK", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "k0", ",", "k01"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4448411069543095`*^9, 3.4448411131163096`*^9}, {
   3.44484359825651*^9, 3.4448436039155097`*^9}, {3.4452789601423054`*^9, 
   3.4452789744787054`*^9}, 3.4452791009479055`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kT", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PsampleS", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "T", ",", "t", ",", "tau"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"f0", "*", 
        RowBox[{"fPyth", "[", "k", "]"}]}]}], ";", 
      RowBox[{"T", "=", 
       FractionBox["1.", "f"]}], ";", 
      RowBox[{"tau", "=", 
       FractionBox["1.", "sr"]}], ";", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"tonS", "[", 
         RowBox[{
          RowBox[{"fPyth", "[", "k", "]"}], ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"kT", "*", "T"}], ",", "tau"}], "}"}]}], "]"}]}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PsampleL", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "T", ",", "t", ",", "tau"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"f0", "*", 
        RowBox[{"fPyth", "[", "k", "]"}]}]}], ";", 
      RowBox[{"T", "=", 
       FractionBox["1.", "f"]}], ";", 
      RowBox[{"tau", "=", 
       FractionBox["1.", "sr"]}], ";", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"tonL", "[", 
         RowBox[{
          RowBox[{"fPyth", "[", "k", "]"}], ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"kT", "*", "T"}], ",", "tau"}], "}"}]}], "]"}]}]}], "]"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"PtonyS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"aK", "[", "k", "]"}], "*", 
      RowBox[{"PsampleS", "[", "k", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"PtonyL", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"aK", "[", "k", "]"}], "*", 
      RowBox[{"PsampleL", "[", "k", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"PtonyS", "[", 
     RowBox[{"[", "10", "]"}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PointSize", "[", "0.01", "]"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.444578816263*^9, 3.444578824208*^9}, 3.444578934374*^9, 
   3.444579031756*^9, {3.444579108674*^9, 3.444579124451*^9}, {
   3.4445791600360003`*^9, 3.444579172145*^9}, {3.4445793601099997`*^9, 
   3.444579401965*^9}, {3.4445794588120003`*^9, 3.444579631231*^9}, {
   3.4445796614110003`*^9, 3.444579713314*^9}, {3.444579779741*^9, 
   3.444579851657*^9}, {3.4445800345439997`*^9, 3.444580069633*^9}, {
   3.444580101058*^9, 3.444580122816*^9}, 3.444580202861*^9, {
   3.4445814747279997`*^9, 3.444581497321*^9}, 3.444581893491*^9, {
   3.444581929079*^9, 3.444582051874*^9}, {3.444582173138*^9, 
   3.444582177929*^9}, {3.444582219308*^9, 3.444582381163*^9}, {
   3.444582418127*^9, 3.444582538888*^9}, {3.444582584007*^9, 
   3.444582597573*^9}, 3.444582656568*^9, 3.444583060666*^9, {
   3.444583195208*^9, 3.44458323865*^9}, {3.444583278568*^9, 
   3.444583279799*^9}, {3.444583586458*^9, 3.444583586822*^9}, {
   3.444583635844*^9, 3.4445836364449997`*^9}, {3.4445836699700003`*^9, 
   3.444583698965*^9}, {3.444585513722*^9, 3.44458564942*^9}, {
   3.44458646713*^9, 3.444586473476*^9}, {3.444586509058*^9, 
   3.444586509566*^9}, {3.444586684532*^9, 3.444586695832*^9}, 
   3.444587674045*^9, {3.4445905049519997`*^9, 3.444590510391*^9}, {
   3.4445905998719997`*^9, 3.4445906098129997`*^9}, {3.44484111717231*^9, 
   3.4448411251283092`*^9}, {3.445274774785105*^9, 3.4452747983411055`*^9}, {
   3.445275771327505*^9, 3.4452757986431055`*^9}, {3.4452775731079054`*^9, 
   3.445277574621105*^9}, 3.4452776907961054`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TsampleS", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "T", ",", "t", ",", "tau"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"f0", "*", 
        RowBox[{"fTemper", "[", "k", "]"}]}]}], ";", 
      RowBox[{"T", "=", 
       FractionBox["1.", "f"]}], ";", 
      RowBox[{"tau", "=", 
       FractionBox["1.", "sr"]}], ";", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"tonS", "[", 
         RowBox[{
          RowBox[{"fTemper", "[", "k", "]"}], ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"kT", "*", "T"}], ",", "tau"}], "}"}]}], "]"}]}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TsampleL", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "T", ",", "t", ",", "tau"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"f0", "*", 
        RowBox[{"fTemper", "[", "k", "]"}]}]}], ";", 
      RowBox[{"T", "=", 
       FractionBox["1.", "f"]}], ";", 
      RowBox[{"tau", "=", 
       FractionBox["1.", "sr"]}], ";", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"tonL", "[", 
         RowBox[{
          RowBox[{"fTemper", "[", "k", "]"}], ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"kT", "*", "T"}], ",", "tau"}], "}"}]}], "]"}]}]}], "]"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"TtonyS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"aK", "[", "k", "]"}], "*", 
      RowBox[{"TsampleS", "[", "k", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"TtonyL", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"aK", "[", "k", "]"}], "*", 
      RowBox[{"TsampleL", "[", "k", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "k0", ",", "k01"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"NullTony", "=", 
   RowBox[{"0.", "*", 
    RowBox[{"Range", "[", "1000", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4448439192995095`*^9, {3.4452748085279055`*^9, 3.445274818745905*^9}, {
   3.445275810842305*^9, 3.445275818876305*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PCohrajL", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "a_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"k0", "\[LessEqual]", "k", "\[LessEqual]", "k01"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"PtonyL", "[", 
         RowBox[{"[", 
          RowBox[{"k", "-", "k0", "+", "1"}], "]"}], "]"}]}], ",", "long"}], 
      "]"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{"NullTony", ",", "long"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PCohrajS", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "a_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"k0", "\[LessEqual]", "k", "\[LessEqual]", "k01"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"PtonyS", "[", 
         RowBox[{"[", 
          RowBox[{"k", "-", "k0", "+", "1"}], "]"}], "]"}]}], ",", "long"}], 
      "]"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{"NullTony", ",", "long"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PCohraj", "[", "co_", "]"}], ":=", 
   RowBox[{
    RowBox[{"PCohrajS", "[", "co", "]"}], "+", 
    RowBox[{"PCohrajL", "[", "co", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TCohrajL", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "a_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"k0", "\[LessEqual]", "k", "\[LessEqual]", "k01"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"TtonyL", "[", 
         RowBox[{"[", 
          RowBox[{"k", "-", "k0", "+", "1"}], "]"}], "]"}]}], ",", "long"}], 
      "]"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{"NullTony", ",", "long"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TCohrajS", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "a_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"k0", "\[LessEqual]", "k", "\[LessEqual]", "k01"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"TtonyS", "[", 
         RowBox[{"[", 
          RowBox[{"k", "-", "k0", "+", "1"}], "]"}], "]"}]}], ",", "long"}], 
      "]"}], ",", 
     RowBox[{"fceprot", "[", 
      RowBox[{"NullTony", ",", "long"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TCohraj", "[", "co_", "]"}], ":=", 
    RowBox[{
     RowBox[{"TCohrajS", "[", "co", "]"}], "+", 
     RowBox[{"TCohrajL", "[", "co", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.444588756381*^9, 3.4445887636949997`*^9}, {
   3.444588795954*^9, 3.444589079701*^9}, {3.4445891296359997`*^9, 
   3.4445891357799997`*^9}, 3.444589423363*^9, 3.444590344578*^9, {
   3.44459278788*^9, 3.4445927921809998`*^9}, {3.4448417842485094`*^9, 
   3.4448417859955096`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "rejstrik1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rejstrik1", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"zakl_", ",", "rej_", ",", "interval_"}], "}"}], ",", 
     RowBox[{"co", ":", 
      RowBox[{"{", 
       RowBox[{"k_", ",", "a_", ",", "long_"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fzakl", ",", "frej", ",", "ki", ",", "ai"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"fzakl", "[", 
        RowBox[{"ki_", ",", "ai_"}], "]"}], ":=", 
       RowBox[{"zakl", "[", 
        RowBox[{"{", 
         RowBox[{"ki", ",", "ai", ",", "long"}], "}"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"frej", "[", 
        RowBox[{"ki_", ",", "ai_"}], "]"}], ":=", 
       RowBox[{"rej", "[", 
        RowBox[{"{", 
         RowBox[{"ki", ",", "ai", ",", "long"}], "}"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"fzakl", "[", 
        RowBox[{"k", ",", 
         RowBox[{"2", "*", "a"}]}], "]"}], "+", 
       RowBox[{"frej", "[", 
        RowBox[{
         RowBox[{"k", "+", "12", "+", "interval"}], ",", "a"}], "]"}], "+", 
       RowBox[{"frej", "[", 
        RowBox[{
         RowBox[{"k", "+", "24", "+", "interval"}], ",", 
         RowBox[{"a", "*", "0.2"}]}], "]"}], "+", 
       RowBox[{"frej", "[", 
        RowBox[{
         RowBox[{"k", "+", "36"}], ",", 
         RowBox[{"a", "*", "0.1"}]}], "]"}], "+", 
       RowBox[{"frej", "[", 
        RowBox[{
         RowBox[{"k", "+", "48"}], ",", 
         RowBox[{"a", "*", "0.05"}]}], "]"}], "+", 
       RowBox[{"frej", "[", 
        RowBox[{
         RowBox[{"k", "-", "12"}], ",", 
         RowBox[{"a", "*", "0.4"}]}], "]"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kvinta", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"rejstrik1", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TCohrajS", ",", "PCohrajS", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "long"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kvintaTry", "[", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "long_"}], "}"}], "]"}], ":=", 
   RowBox[{"rejstrik1", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TCohrajS", ",", "PCohrajL", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "long"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"kvinta", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "20"}], ",", ".2"}], "}"}], "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.44483952979591*^9, {3.44484096100231*^9, 3.4448409713295097`*^9}, 
   3.44484120258311*^9, {3.4448510829985094`*^9, 3.4448510864045095`*^9}, {
   3.44485339431351*^9, 3.44485343004451*^9}, {3.4448540419835095`*^9, 
   3.4448540455275097`*^9}, {3.4448541895055094`*^9, 
   3.4448541924795094`*^9}, {3.4448560237465096`*^9, 
   3.4448560551375093`*^9}, {3.4448562953575096`*^9, 
   3.4448562996285095`*^9}, {3.4448564845215096`*^9, 
   3.4448565001265097`*^9}, {3.44485659057251*^9, 3.4448566528095093`*^9}, {
   3.44485668958451*^9, 3.4448566940175095`*^9}, 3.4448567583575096`*^9, {
   3.4448568069565096`*^9, 3.44485684717651*^9}, 3.4448579683885098`*^9, 
   3.44485800003951*^9, {3.445275890480305*^9, 3.445276028680705*^9}, {
   3.445276060910305*^9, 3.445276071159505*^9}, {3.445277096636305*^9, 
   3.4452771136559052`*^9}, {3.445277169347705*^9, 3.4452771717033052`*^9}}],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{"osminka", "=", ".6"}], ";"}],
  FontColor->RGBColor[0.6, 0.4, 0.2]], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"takt", "=", "4"}], ";"}],
  FontColor->RGBColor[0.6, 0.4, 0.2]], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"ntaktu", "=", "20"}], ";"}],
  FontColor->RGBColor[0.6, 0.4, 0.2]], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"pLayrAnge", "=", "5"}], ";"}],
   FontColor->RGBColor[0.6, 0.4, 0.2]], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zahraj", "[", "cohraj_", "]"}], ":=", 
   RowBox[{"EmitSound", "[", 
    RowBox[{"ListPlay", "[", 
     RowBox[{"cohraj", ",", 
      RowBox[{"SampleRate", "\[Rule]", "sr"}], ",", 
      RowBox[{"PlayRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1."}], "pLayrAnge"}], ",", 
         RowBox[{"1.", "pLayrAnge"}]}], "}"}]}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"omez", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "makacka", ",", "gen", ",", "i", ",", "imin", ",", "imax", ",", 
       "tonyztoniny"}], "}"}], ",", 
     RowBox[{
      RowBox[{"makacka", "=", 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "7", ",", "8", ",", "9", ",", "12"}], 
         "}"}],
        FontColor->RGBColor[0.6, 0.4, 0.2]]}], ";", 
      RowBox[{
       RowBox[{"gen", "[", "i_", "]"}], ":=", 
       RowBox[{"makacka", "+", 
        RowBox[{"i", "*", "12"}]}]}], ";", 
      RowBox[{"imin", "=", 
       RowBox[{"Round", "[", 
        FractionBox["k0", "12"], "]"}]}], ";", 
      RowBox[{"imax", "=", 
       RowBox[{"Round", "[", 
        RowBox[{
         FractionBox["k01", "12"], "-", "1"}], "]"}]}], ";", 
      RowBox[{"tonyztoniny", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"gen", "[", "i", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "imin", ",", "imax"}], "}"}]}], "]"}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"Sort", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{"k", "-", 
              RowBox[{"tonyztoniny", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"tonyztoniny", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "tonyztoniny", "]"}]}], "}"}]}], "]"}], 
        "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nmax", "=", 
   RowBox[{"ntaktu", "*", "takt", "*", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmel", "[", 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n_", ",", "a_", ",", "b_", ",", "c_", ",", "d_", ",", "sh_"}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"offset_", ",", "rozsah_"}], "}"}]}],
     FontColor->RGBColor[1, 0, 1]], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "kk", ",", "p"}], "}"}], ",", 
     RowBox[{
      RowBox[{"kk", "=", 
       RowBox[{"24.", "*", 
        FractionBox["Pi", "nmax"]}]}], ";", 
      RowBox[{"t", "=", "n"}], ";", 
      RowBox[{"p", "=", 
       RowBox[{
        RowBox[{"rozsah", "*", "12", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "1.4"], 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"kk", "*", "t"}], "+", "sh"}], "]"}]}], "+", "0.67", 
           "+", 
           RowBox[{"Sin", "[", 
            RowBox[{"0.8", "kk", "*", "t"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"b", "*", "kk", "*", "t"}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "*", "Pi", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"0.2", "*", "kk", "*", 
             SqrtBox[
              RowBox[{"t", "*", ".1"}]]}], "]"}], "*", "kk", "*", "t"}], 
          "]"}]}]}]}], ";", 
      RowBox[{"omez", "[", 
       RowBox[{
        RowBox[{"p", "*", "rozsah"}], "+", "offset"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mymel1", "[", "n_", "]"}], ":=", 
  RowBox[{"fmel", "[", 
   RowBox[{
    StyleBox[
     RowBox[{"{", 
      RowBox[{"n", ",", ".1", ",", "1.4", ",", "2.3", ",", "0.5", ",", "0"}], 
      "}"}],
     FontColor->RGBColor[0.6, 0.4, 0.2]], ",", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"8", ",", "0.5"}], "}"}],
     FontColor->RGBColor[0.6, 0.4, 0.2]]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnv", ":=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{
      StyleBox[".399",
       FontColor->RGBColor[0.6, 0.4, 0.2]], "*", 
      RowBox[{"Random", "[", "]"}]}], ",", 
     RowBox[{
      RowBox[{"3", "*", 
       RowBox[{"Random", "[", "]"}]}], "+", 
      StyleBox["0.7",
       FontColor->RGBColor[0.6, 0.4, 0.2]]}], ",", "0", ",", "Pi"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mymel2", "[", "n_", "]"}], ":=", 
  RowBox[{"fmel", "[", 
   RowBox[{
    RowBox[{
     StyleBox[
      RowBox[{"{", 
       RowBox[{
       "n", ",", "1", ",", "1.2085", ",", "2.7", ",", "0.42", ",", "0.8"}], 
       "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], "+", "rnv"}], ",", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", ".7"}], "}"}],
     FontColor->RGBColor[0.6, 0.4, 0.2]]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mymel3", "[", "n_", "]"}], ":=", 
  RowBox[{"fmel", "[", 
   RowBox[{
    RowBox[{
     StyleBox[
      RowBox[{"{", 
       RowBox[{
       "n", ",", "1", ",", ".8085", ",", "2.7", ",", "0.8", ",", "0"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], "+", "rnv"}], ",", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "29"}], ",", "0.7"}], "}"}],
     FontColor->RGBColor[0.6, 0.4, 0.2]]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mymel2", "[", "n", "]"}], ",", 
       RowBox[{"mymel1", "[", "n", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "nmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Hue", "[", "0.63", "]"}]}], "}"}]}]}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zakltaktycaste", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"{", 
     StyleBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}]}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zakltaktycaste2", "=", 
   RowBox[{"{", 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "0", ",", "8"}], "}"}]}],
     FontColor->RGBColor[0.6, 0.4, 0.2]], 
    StyleBox["}",
     FontColor->RGBColor[0.6, 0.4, 0.2]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nzt", "=", 
   RowBox[{"Length", "[", "zakltaktycaste", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nzt2", "=", 
   RowBox[{"Length", "[", "zakltaktycaste2", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"takt", ":=", 
   RowBox[{"Part", "[", 
    RowBox[{"zakltaktycaste", ",", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "nzt"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"takt2", ":=", 
   RowBox[{"Part", "[", 
    RowBox[{"zakltaktycaste2", ",", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "nzt2"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ftakt", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "takty_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "+", "1"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{"takty", ",", "takt"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ftakt2", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "takty_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "+", "1"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{"takty", ",", "takt2"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delky1", "=", 
   RowBox[{
    RowBox[{"NestWhile", "[", 
     RowBox[{"ftakt", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}],
         FontColor->RGBColor[0.6, 0.4, 0.2]]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"ntaktu", "-", "1"}]}], "&"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delky2", "=", 
   RowBox[{
    RowBox[{"NestWhile", "[", 
     RowBox[{"ftakt", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"ntaktu", "-", "1"}]}], "&"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delky3", "=", 
   RowBox[{
    RowBox[{"NestWhile", "[", 
     RowBox[{"ftakt2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
        RowBox[{"ntaktu", "-", "1"}]}], "&"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "tn", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn1", "[", "1", "]"}], "=", 
   RowBox[{"delky1", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn1", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"tn1", "[", "n", "]"}], "=", 
    RowBox[{
     RowBox[{"tn1", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"delky1", "[", 
      RowBox[{"[", "n", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn2", "[", "1", "]"}], "=", 
   RowBox[{"delky2", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn2", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"tn2", "[", "n", "]"}], "=", 
    RowBox[{
     RowBox[{"tn2", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"delky2", "[", 
      RowBox[{"[", "n", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn3", "[", "1", "]"}], "=", 
   RowBox[{"delky3", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tn3", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"tn3", "[", "n", "]"}], "=", 
    RowBox[{
     RowBox[{"tn3", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"delky3", "[", 
      RowBox[{"[", "n", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mymel1", "[", 
        RowBox[{"tn1", "[", "#", "]"}], "]"}], ",", 
       RowBox[{"delky1", "[", 
        RowBox[{"[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "delky1", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dm2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mymel2", "[", 
        RowBox[{"tn2", "[", "#", "]"}], "]"}], ",", 
       RowBox[{"delky2", "[", 
        RowBox[{"[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "delky2", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dm3", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"mymel3", "[", 
         RowBox[{"tn3", "[", "#", "]"}], "]"}], ",", 
        RowBox[{"delky3", "[", 
         RowBox[{"[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"Length", "[", "delky3", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"pom1", "=", 
   RowBox[{"dm1", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"osminka", "*", "b"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom12", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"kvinta", "/@", "pom1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom2", "=", 
   RowBox[{"dm2", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"osminka", "*", "b"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom22", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"kvintaTry", "/@", "pom2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom3", "=", 
   RowBox[{"dm3", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"osminka", "*", "b"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom32", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"kvintaTry", "/@", "pom3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mn", "=", 
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"Length", "[", "pom12", "]"}], ",", 
     RowBox[{"Length", "[", "pom22", "]"}], ",", 
     RowBox[{"Length", "[", "pom32", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pooom", "=", 
   RowBox[{
    RowBox[{"1.6", "*", 
     RowBox[{"Take", "[", 
      RowBox[{"pom12", ",", "mn"}], "]"}]}], "+", 
    RowBox[{"1", "*", 
     RowBox[{"Take", "[", 
      RowBox[{"pom22", ",", "mn"}], "]"}]}], "+", 
    RowBox[{"1", "*", 
     RowBox[{"Take", "[", 
      RowBox[{"pom32", ",", "mn"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"zahraj", "[", "pooom", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4448401058571095`*^9, 3.4448401088679094`*^9}, 
   3.4448403125415096`*^9, 3.4448412109759097`*^9, {3.44484286198551*^9, 
   3.4448428631725097`*^9}, {3.4448430188925095`*^9, 
   3.4448430200235095`*^9}, {3.4448439822645097`*^9, 
   3.4448440063245096`*^9}, {3.4448440520735097`*^9, 3.4448441601725097`*^9}, 
   3.44484428178251*^9, {3.4448445015785093`*^9, 3.4448445050855093`*^9}, {
   3.4448445588625097`*^9, 3.4448445600695095`*^9}, {3.4448446103835096`*^9, 
   3.4448446151995096`*^9}, 3.44484471841951*^9, {3.4448447560355096`*^9, 
   3.4448447573875093`*^9}, {3.4448448242715096`*^9, 3.44484482654451*^9}, {
   3.4448448794795094`*^9, 3.4448449989415092`*^9}, 3.4448455167375097`*^9, {
   3.4448508029155097`*^9, 3.4448508535785093`*^9}, {3.4448509458395095`*^9, 
   3.44485095187951*^9}, {3.44485099537251*^9, 3.4448510230685096`*^9}, {
   3.4448511068995094`*^9, 3.4448511082255096`*^9}, {3.4448511425575094`*^9, 
   3.4448511557155094`*^9}, {3.4448524926995096`*^9, 3.44485252059851*^9}, {
   3.4448526406845093`*^9, 3.44485264416451*^9}, {3.4448527058365097`*^9, 
   3.4448528454675093`*^9}, {3.4448534854425097`*^9, 
   3.4448535049605093`*^9}, {3.4448535795675097`*^9, 
   3.4448535925165095`*^9}, {3.4448538543065095`*^9, 
   3.4448539032415094`*^9}, {3.4448539588735094`*^9, 
   3.4448539889285097`*^9}, {3.4448540342325096`*^9, 3.44485403501151*^9}, {
   3.4448541508455095`*^9, 3.4448541707995095`*^9}, {3.4448543307465096`*^9, 
   3.4448543662115097`*^9}, {3.4448546554275093`*^9, 
   3.4448546637245097`*^9}, {3.4448547554215097`*^9, 
   3.4448547581565094`*^9}, {3.4448548256925097`*^9, 
   3.4448548331935096`*^9}, {3.4448549434305096`*^9, 
   3.4448549451585093`*^9}, {3.4448550772305098`*^9, 
   3.4448551301415095`*^9}, {3.4448551765895095`*^9, 
   3.4448553119415092`*^9}, {3.4448553509725094`*^9, 3.44485547954451*^9}, {
   3.4448556727435093`*^9, 3.4448557014915094`*^9}, {3.4448558918245096`*^9, 
   3.44485595997351*^9}, {3.44485606194051*^9, 3.4448560624315095`*^9}, {
   3.4448561731235094`*^9, 3.4448562185455093`*^9}, {3.4448562855675097`*^9, 
   3.4448563477555094`*^9}, {3.4448569819355097`*^9, 
   3.4448570364945097`*^9}, {3.4448571205545096`*^9, 
   3.4448571360315094`*^9}, {3.4448572562515097`*^9, 
   3.4448572703385096`*^9}, {3.4448580205245094`*^9, 3.44485808516951*^9}, {
   3.4448582581325097`*^9, 3.4448582787415094`*^9}, 3.4449316797621756`*^9, {
   3.4449317165313754`*^9, 3.4449317504457755`*^9}, {3.444932878336375*^9, 
   3.4449329245747757`*^9}, {3.4449330698513756`*^9, 
   3.4449330845777755`*^9}, {3.4449332038291755`*^9, 3.444933235559575*^9}, {
   3.4449335950305758`*^9, 3.4449337458825755`*^9}, {3.4449338813695755`*^9, 
   3.444933915199375*^9}, {3.4449340652345753`*^9, 3.4449340692125754`*^9}, {
   3.4452763454809055`*^9, 3.4452765513229055`*^9}, {3.4452767358663054`*^9, 
   3.445276736615105*^9}, {3.4452767692659054`*^9, 3.445276770264305*^9}, {
   3.445276812091905*^9, 3.4452768827125053`*^9}, {3.4452769148635054`*^9, 
   3.4452769158775053`*^9}, {3.445276983629105*^9, 3.445277052971505*^9}, {
   3.4452772167877054`*^9, 3.445277223355305*^9}, {3.445277277566705*^9, 
   3.4452773290299053`*^9}, {3.4452773927709055`*^9, 3.445277480801905*^9}, {
   3.445278725824705*^9, 3.4452787440455055`*^9}, 3.4452787775075054`*^9, {
   3.4452788163861055`*^9, 3.445278816854105*^9}, {3.4452788617665052`*^9, 
   3.4452788623593054`*^9}, {3.5174037065625*^9, 3.517403709171875*^9}, {
   3.517403776296875*^9, 3.51740378825*^9}, {3.517404014953125*^9, 
   3.517404020984375*^9}}]
},
WindowSize->{1013, 807},
WindowMargins->{{0, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 144, 3, 35, "Input"],
Cell[692, 25, 4255, 106, 402, "Input"],
Cell[4950, 133, 950, 30, 80, "Input"],
Cell[5903, 165, 2485, 77, 223, "Input"],
Cell[8391, 244, 1072, 28, 58, "Input"],
Cell[9466, 274, 2803, 84, 307, "Input"],
Cell[12272, 360, 4038, 100, 246, "Input"],
Cell[16313, 462, 2386, 73, 224, "Input"],
Cell[18702, 537, 3135, 91, 278, "Input"],
Cell[21840, 630, 3624, 96, 212, "Input"],
Cell[25467, 728, 19419, 555, 1288, "Input"]
}
]
*)

(* End of internal cache information *)
