(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115327,       2853]
NotebookOptionsPosition[    113305,       2798]
NotebookOutlinePosition[    113707,       2815]
CellTagsIndexPosition[    113664,       2812]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "ciste", " ", "kvuli", " ", "opakovanemu", " ", "spousteni", " ", 
    "notebooku"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"zakladni", " ", "konstanty"}], ",", " ", 
    RowBox[{"asi", " ", "muzou", " ", "byt", " ", "fixne"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "=", "9.81"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"km", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kW", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ah", "=", "3600."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"konstanty", " ", "ve", " ", "vypoctu"}], ",", " ", 
     RowBox[{"budou", " ", "je", " ", "zadavat"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mRed", "=", 
     StyleBox["15000",
      FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"ShydrOdpor", "=", "4"}], ";"}],
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dchar", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cx", "=", "0.65"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ramenoValivehoOdporu", "=", 
     RowBox[{"2.5", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rKola", "=", 
     RowBox[{"300", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"teplota", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aTry", "=", "0.15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aplus", "=", "aTry"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aminus", "=", 
     RowBox[{"-", "aTry"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "hustota", " ", "vzduchu", " ", "v", " ", "zavislosti", " ", "na", " ", 
     "teplote"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ro", "[", "T_", "]"}], ":=", 
     FractionBox["341.", "T"]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.527611809703125*^9, 3.527611813859375*^9}, {
   3.527612806046875*^9, 3.5276128068125*^9}, {3.528215208453125*^9, 
   3.528215211609375*^9}, {3.528215431046875*^9, 3.528215436375*^9}, {
   3.530123183421875*^9, 3.53012318765625*^9}, {3.53012325025*^9, 
   3.53012325209375*^9}, {3.5301233410625*^9, 3.530123344828125*^9}, 
   3.53029285703125*^9, {3.5302930996875*^9, 3.530293100640625*^9}, {
   3.53029372721875*^9, 3.5302937358125*^9}, {3.530294647*^9, 
   3.530294648765625*^9}, {3.53029600703125*^9, 3.53029601315625*^9}, 
   3.530297316234375*^9, {3.530298004046875*^9, 3.53029802640625*^9}, {
   3.7541887149375*^9, 3.75418871571875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"zadavani", " ", "\"\<jak kde chteji jet rychle\>\""}], ",", " ", 
    RowBox[{
     RowBox[{
     "cil", " ", "je", " ", "mit", " ", "funkci", " ", "pozadovanarychlost"}],
      "=", 
     RowBox[{"vz", "=", 
      RowBox[{"f", 
       RowBox[{"(", 
        RowBox[{"x", "=", "poloha"}], ")"}]}]}]}], ",", " ", 
    RowBox[{
    "budou", " ", "zadavat", " ", "v", " ", "Excelu", " ", "asi", " ", "dva", 
     " ", "sloupecky"}], ",", " ", 
    RowBox[{"polohu", " ", "znacime", " ", "x"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"vmax", "=", 
     FractionBox[
      StyleBox["35.5",
       FontColor->RGBColor[1, 0, 0]], "3.6"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datRychlost", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"600", ",", "0.3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1500", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3700", ",", "0.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3800", ",", "0.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8500", ",", "0.9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11000", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"13000", ",", "0.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"14500", ",", "0.3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"25000", ",", "0.3"}], "}"}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"b", "*", "vmax"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vz", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"datRychlost", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "0"}]}], "]"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"vz", " ", "je", " ", "tady", " ", "funkce", " ", "polohy"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"tedy", " ", "vz"}], "=", 
      RowBox[{"vz", 
       RowBox[{"(", "x", ")"}]}]}], ",", " ", 
     RowBox[{"zobrazeni", " ", "o", " ", "kousek", " ", "niz"}], ",", " ", 
     RowBox[{"je", " ", "po", " ", "usecich", " ", "konstantni"}], ",", " ", 
     RowBox[{
      RowBox[{"to", " ", "dela", " ", "InterpolationOrder"}], "\[Rule]", 
      "0"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.5276099630625*^9, 3.5276099959375*^9}, {
   3.527610147609375*^9, 3.527610223578125*^9}, {3.527610277296875*^9, 
   3.52761028278125*^9}, {3.5276105716875*^9, 3.527610632140625*^9}, {
   3.527611833859375*^9, 3.527611868546875*^9}, {3.527611907578125*^9, 
   3.527611924796875*^9}, 3.528214380046875*^9, 3.528215136078125*^9, 
   3.528215226484375*^9, 3.528215794171875*^9, 3.528216415984375*^9, {
   3.528216566765625*^9, 3.52821656703125*^9}, 3.53026039428125*^9, {
   3.530261008515625*^9, 3.530261008734375*^9}, 3.53026118046875*^9, 
   3.530292264078125*^9, 3.530292663625*^9, {3.530294834375*^9, 
   3.53029483490625*^9}, {3.53029704121875*^9, 3.5302970424375*^9}, {
   3.5302973746875*^9, 3.530297375625*^9}, {3.530297461984375*^9, 
   3.530297491015625*^9}, 3.53029791253125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"zdavani", " ", "nadmorske", " ", "vysky"}], ",", " ", 
    RowBox[{"vysku", " ", "znacim", " ", "h"}], ",", " ", 
    RowBox[{"zde", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", "poloha"}], ",", 
       RowBox[{"h", "=", "vyska"}]}], "}"}]}], ",", " ", 
    RowBox[{"polohu", " ", "znacime", " ", "x"}], ",", " ", 
    RowBox[{"vysku", " ", "h"}], ",", " ", 
    RowBox[{
    "budou", " ", "zadavat", " ", "v", " ", "Excelu", " ", "asi", " ", "dva", 
     " ", "sloupecky"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datVyska", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"500", ",", "250"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "220"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3000", ",", "280"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3200", ",", "270"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5000", ",", "400"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8000", ",", "420"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9000", ",", "270"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11000", ",", "400"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12500", ",", "380"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15000", ",", "400"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"25000", ",", "400"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"datVyska", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"h", " ", "je", " ", "tady", " ", "funkce", " ", "polohy"}], ",",
      " ", 
     RowBox[{
      RowBox[{"tedy", " ", "h"}], "=", 
      RowBox[{"h", 
       RowBox[{"(", "x", ")"}]}]}], ",", " ", 
     RowBox[{"zobrazeni", " ", "o", " ", "kousek", " ", "niz"}], ",", " ", 
     RowBox[{"je", " ", "po", " ", "usecich", " ", "primkova"}], ",", " ", 
     RowBox[{
      RowBox[{"to", " ", "dela", " ", "InterpolationOrder"}], "\[Rule]", 
      "1"}]}], "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5276102069375*^9, 3.5276103148125*^9}, {
  3.52761053234375*^9, 3.527610539578125*^9}, {3.527610639375*^9, 
  3.527610665078125*^9}, {3.527611886671875*^9, 3.527611897234375*^9}, {
  3.527611944921875*^9, 3.527611967515625*^9}, {3.528215675421875*^9, 
  3.528215677921875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"kvuli", " ", "numerickym", " ", "metodam"}], ",", " ", 
    RowBox[{"ktere", " ", "pocitaji", " ", "\"\<dopredu\>\""}], ",", " ", 
    RowBox[{"beru", " ", "ze", " ", "posledni", " ", "bod", "  ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"posledni", " ", "polohu"}], ",", " ", "x"}], ")"}], " ", "je",
      " ", "dodany", " ", "jen", " ", "formalne"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "xmax", " ", "se", " ", "bere", " ", "z", " ", "predposlednich", " ", 
       "zadanych", " ", "bodu"}], "..."}], " ", "neni", " ", "to", " ", "moc",
      " ", "chytre"}], ",", " ", 
    RowBox[{
    "udelej", " ", "to", " ", "jakkoli", " ", "nebo", " ", "matlabi", " ", 
     "ODE", " ", "nebude", " ", "chodit", " ", "dal", " ", "a", " ", "muze", 
     " ", "se", " ", "vzit", " ", "zadany", " ", "konec"}], ",", " ", 
    RowBox[{"vymyslis", " ", "to", " ", "lip"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"xmax", "=", 
    RowBox[{
     RowBox[{"Union", "@", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"-", "2"}], "}"}]}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"datRychlost", ",", "datVyska"}], "}"}]}], "]"}]}], "//", 
     "Last"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.527610330328125*^9, 3.527610461046875*^9}, {
  3.52761072034375*^9, 3.527610744609375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"je", " ", "videt"}], ",", " ", 
     RowBox[{"jaky", " ", "jsem", " ", "udelal", " ", 
      RowBox[{"trik", ":", " ", 
       RowBox[{
       "pozadovanou", " ", "rychlost", " ", "mam", " ", "jako", " ", 
        "interpolaci", "  ", "nulteho", " ", "radu"}]}]}], ",", " ", 
     RowBox[{
     "tedy", " ", "jako", " ", "konstantni", " ", "po", " ", "usecich"}], ",",
      " ", 
     RowBox[{
     "kdezto", " ", "nadmorskou", " ", "vysku", " ", "jako", " ", 
      "interpolaci", " ", "prvniho", " ", "radu"}], ",", " ", 
     RowBox[{"takze", " ", "to", " ", "dela", " ", "kopce"}], ",", " ", 
     RowBox[{"je", " ", "celkem", " ", "jedno"}], ",", " ", 
     RowBox[{"jak", " ", "to", " ", "v", " ", "Simulinku", " ", "udelas"}], 
     ",", " ", 
     RowBox[{
     "ale", " ", "asi", " ", "to", " ", "umi", " ", "interpolace", " ", 
      "uplne", " ", 
      RowBox[{"stejne", ":", "-"}]}]}], ")"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plzad", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"vz", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<x [m]\>\"", ",", 
          "\"\<v [m.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plh", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"h", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x [m]\>\"", ",", "\"\<h [m]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.527610544859375*^9, 3.527610556015625*^9}, {
  3.5276107563125*^9, 3.5276109095*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "pomocna", " ", "funkce", " ", "pro", " ", "vypocet", " ", 
        "kinematiky"}], ",", " ", 
       RowBox[{
       "jde", " ", "jen", " ", "o", " ", "udelani", " ", 
        "\"\<hladkeho If:-)\>\""}], ",", " ", 
       RowBox[{"v", " ", "podstate", " ", "jde", " ", "o", " ", "to"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"aby", " ", "je"}], "-", 
        RowBox[{"li", " ", "rychlost", " ", 
         RowBox[{"(", "v", ")"}], " ", "mensi"}]}], ",", " ", 
       RowBox[{"nez", " ", "rychlost", " ", "pozadovana", " ", 
        RowBox[{"(", "vzadana", ")"}]}], ",", " ", 
       RowBox[{
        RowBox[{"je", " ", "zrychleni", " ", "az"}], " ", "=", "aplus"}], ",",
        " ", 
       RowBox[{
        RowBox[{"v", " ", "opacnem", " ", "az"}], " ", "=", "aminus"}], ",", 
       " ", 
       RowBox[{"tedy", " ", "vlastne", " ", 
        RowBox[{"regulator", ":", "-"}]}]}], ")"}], " ", "klidne", " ", "to", 
     " ", "udelej", " ", "ifem"}], ",", " ", 
    RowBox[{
    "nebo", " ", "jak", " ", "se", " ", "to", " ", "bude", " ", "libit", " ", 
     "ODE"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "vyr", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vyr", "[", "x_", "]"}], ":=", 
     RowBox[{"c", "+", 
      RowBox[{"b", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"resbc", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"vyr", "[", "1", "]"}], "\[Equal]", "aplus"}], ",", 
         RowBox[{
          RowBox[{"vyr", "[", 
           RowBox[{"-", "1"}], "]"}], "\[Equal]", "aminus"}]}], "}"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ka", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"az", "[", 
      RowBox[{"v_", ",", "vzadana_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"c", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"ka", "*", 
          RowBox[{"(", 
           RowBox[{"vzadana", "-", "v"}], ")"}]}], "]"}]}]}], "/.", 
      "resbc"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.527610966546875*^9, 3.527611118953125*^9}, {
  3.527611151125*^9, 3.527611181234375*^9}, {3.52761121834375*^9, 
  3.527611250625*^9}, {3.530122476*^9, 3.530122483796875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "jenom", " ", "ukazka", " ", "jak", " ", "to", " ", "vypada"}], 
        "..."}], " ", "celej", " ", "spas", " ", "delame"}], ",", " ", 
      RowBox[{
      "protoze", " ", "skokova", " ", "zmena", " ", "rychlosti", " ", "je", 
       " ", "nefyzikalni", " ", "a", " ", "tedy", " ", "se", " ", "musi", " ",
        "nutne", " ", "pridat", " ", "nejake", " ", "fyzikalne", " ", "mozne",
        " ", "pravidlo"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
        "jak", " ", "menit", " ", "rychlost", " ", "podle", " ", 
         "nefyzikalniho", " ", 
         RowBox[{"pozadavku", ".", " ", "Zde"}], " ", "je", " ", "to", " ", 
         "reseno", " ", "zavedenim", " ", "max", " ", "kladneho", " ", "a", 
         " ", "max", " ", "zaporneho", " ", "zrychleni"}], "..."}], " ", 
       "ale", " ", "to", " ", "neni", " ", "uplne", " ", "mimo"}], ",", " ", 
      RowBox[{
      "koukali", " ", "jsme", " ", "se", " ", "Zdenkem", " ", "Mullerem", " ",
        "a", " ", "Honzou", " ", "Spetlikem", " ", "na", " ", "busy", " ", 
       "ve", " ", "Svedsku", " ", "a", " ", "nakonec", " ", 
       RowBox[{"souhlasili", ":", "-"}]}]}], ")"}], ",", " ", 
    RowBox[{
     RowBox[{"ukazano", " ", "pro", " ", "vzadana"}], "=", 
     RowBox[{"50", 
      SuperscriptBox["ms", 
       RowBox[{"-", "1"}]]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "50"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "40", ",", "60"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<v [m.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\"", ",", 
        "\"\<a [m.\!\(\*SuperscriptBox[\(s\), \(-2\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.527611193390625*^9, 3.527611214546875*^9}, {
   3.5276112604375*^9, 3.52761140021875*^9}, {3.527646432171875*^9, 
   3.52764645709375*^9}, {3.530122245078125*^9, 3.530122267546875*^9}, {
   3.530158011*^9, 3.5301580145625*^9}, 3.53019211853125*^9, 
   3.53026011784375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"podstata", " ", 
      RowBox[{"triku", ":", "-"}]}], ")"}], " ", "prijali", " ", "jsme", " ", 
    "ze", " ", "zrychleni", " ", "je", " ", "funkci", " ", "aktualni", " ", 
    "a", " ", "pozadovane", " ", "rychlosti", " ", "a", " ", "napsali", " ", 
    "jsme", " ", "kinematicke", " ", "rovnice"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"rceRychlost", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"v", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"az", "[", 
        RowBox[{
         RowBox[{"v", "[", "t", "]"}], ",", 
         RowBox[{"vz", "[", 
          RowBox[{"x", "[", "t", "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"v", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"v", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.52761144234375*^9, 3.527611501515625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"potrebujeme", " ", "konec", " ", "casoveho", " ", "intervalu"}], 
    ",", " ", 
    RowBox[{
    "vypocitame", " ", "ho", " ", 
     "\"\<jako kdybychom jeli skutecne pozadovanou rychlosti\>\""}], ",", " ", 
    RowBox[{"o", " ", "kod", " ", "nejde"}], ",", " ", 
    RowBox[{
    "je", " ", "to", " ", "vlastne", " ", "po", " ", "usecich", " ", 
     "vypocitane", " ", "\"\<t=x/v\>\"", " ", "a", " ", "secteno"}]}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"tmax", "=", 
    RowBox[{"Plus", "@@", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Partition", "[", 
         RowBox[{"datRychlost", ",", "2", ",", "1"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "v1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "v2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
         FractionBox[
          RowBox[{"x2", "-", "x1"}], "v1"]}]}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{
  3.527611690796875*^9, {3.527611765328125*^9, 3.52761176959375*^9}, {
   3.527612056875*^9, 3.527612108453125*^9}, {3.527612198171875*^9, 
   3.527612232265625*^9}, {3.528214424625*^9, 3.52821442878125*^9}, 
   3.5282149918125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"jen", " ", "vyreseni", " ", "kinematickych", " ", "difosek"}], 
    ",", 
    RowBox[{"MaxStepSize", "\[Rule]", 
     RowBox[{"0.0001", "tmax", " ", "je", " ", "jen", " ", "aby", " ", 
      RowBox[{"num", ".", " ", "metoda"}], " ", "nelezla", " ", "z", " ", 
      "oboru", " ", "iksu"}]}], ",", " ", 
    RowBox[{
    "kde", " ", "je", " ", "definovana", " ", "pozadovana", " ", "rychlost", 
     " ", "vz"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"res", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{"rceRychlost", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], ",", 
         RowBox[{"v", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"SolveDelayed", "\[Rule]", "True"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        RowBox[{"0.0001", "tmax"}]}], ",", 
       RowBox[{"MaxSteps", "\[Rule]", 
        SuperscriptBox["10", "6"]}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.52760734290625*^9, 3.527607362125*^9}, {
   3.527607477265625*^9, 3.52760747771875*^9}, {3.5276075321875*^9, 
   3.527607588296875*^9}, {3.52760763478125*^9, 3.52760767834375*^9}, {
   3.52760771615625*^9, 3.527607773140625*^9}, {3.52760780409375*^9, 
   3.527607885515625*^9}, {3.527607981171875*^9, 3.527608035171875*^9}, {
   3.527608122265625*^9, 3.52760813353125*^9}, {3.527608177515625*^9, 
   3.527608186*^9}, {3.527608505640625*^9, 3.52760851921875*^9}, 
   3.527608550078125*^9, {3.527608977953125*^9, 3.5276089925625*^9}, {
   3.527609121609375*^9, 3.52760913578125*^9}, {3.52760948896875*^9, 
   3.527609508640625*^9}, {3.527609547203125*^9, 3.527609548078125*^9}, {
   3.527609605296875*^9, 3.52760962540625*^9}, {3.52760966090625*^9, 
   3.5276097591875*^9}, {3.527609810515625*^9, 3.5276098780625*^9}, {
   3.527609931671875*^9, 3.52760995628125*^9}, {3.527610181359375*^9, 
   3.527610197984375*^9}, 3.5276103271875*^9, 3.527610489203125*^9, {
   3.5276109248125*^9, 3.52761092684375*^9}, {3.5276109620625*^9, 
   3.52761096396875*^9}, 3.527611189140625*^9, 3.52761143596875*^9, 
   3.527611512515625*^9, {3.527612267796875*^9, 3.527612280984375*^9}, 
   3.52821446678125*^9, {3.52821450125*^9, 3.5282146246875*^9}, {
   3.5282146634375*^9, 3.528214685203125*^9}, {3.528214847015625*^9, 
   3.528214955859375*^9}, {3.52821500328125*^9, 3.528215062328125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"vypocteme", ",", " ", 
    RowBox[{"jak", " ", "dlouho", " ", "jsme", " ", "jeli"}], ",", " ", 
    RowBox[{"kdyz", " ", "jsme", " ", "jeli"}], ",", " ", 
    RowBox[{"jak", " ", "jsme", " ", "jeli"}], ",", " ", 
    RowBox[{"abychom", " ", "dojeli", " ", "do", " ", "xmax"}], ",", 
    RowBox[{
    "tedy", " ", "s", " ", "danou", " ", "zavislosti", " ", "zrychleni", " ", 
     "na", " ", "rychlosti", " ", "pozadovane", " ", "a", " ", "rychlosti", 
     " ", "skutecne", " ", "z", " ", "kinematickych", " ", "difosek"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"tm", "=", 
    RowBox[{"t", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xmax", "==", 
         RowBox[{"x", "[", "t", "]"}]}], "/.", "res"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"tmax", "-", "100"}]}], "}"}]}], "]"}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.52761230096875*^9, 3.527612382203125*^9}, {
  3.527646508265625*^9, 3.52764652084375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "ukazka", " ", "jaka", " ", "byla", " ", "pozadovana", " ", "a", " ", 
      "skutecna", " ", "rychlost", " ", "v", " ", "terminech"}], ",", " ", 
     RowBox[{
     "jak", " ", "je", " ", "zadavali", " ", "a", " ", "asi", " ", "budou", 
      " ", "takovy", " ", "grafy", " ", "chtit"}], ",", " ", 
     RowBox[{"asi", " ", "i", " ", "dost", " ", 
      RowBox[{"jinych", ":", "-"}]}]}], ")"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plvysa", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"v", "[", "t", "]"}]}], "}"}], "/.", "res"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.8"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<x [m]\>\"", ",", 
          "\"\<v [m.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"plzad", ",", "plvysa", ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "xmax"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
     "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.527612526625*^9, 3.527612599671875*^9}, 
   3.528215317890625*^9, 3.52821625915625*^9, 3.530108278625*^9, {
   3.5301092379375*^9, 3.530109240796875*^9}, {3.530113525078125*^9, 
   3.530113545765625*^9}, {3.53012337034375*^9, 3.53012338215625*^9}, 
   3.530158892578125*^9, 3.53015898434375*^9, 3.530159026859375*^9, 
   3.53019223740625*^9, 3.53029340053125*^9}],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vypocet", " ", "vykonu", " ", 
     RowBox[{"(", 
      RowBox[{"po", " ", "rade"}], ")"}], " ", "vykonu", " ", "odporu", " ", 
     "vzduchu"}], ",", " ", 
    RowBox[{"potrebneho", " ", "na", " ", "jizdu", " ", "do", " ", "kopce"}], 
    ",", " ", 
    RowBox[{"vykonu", " ", "pro", " ", "zrychleni"}], ",", " ", 
    RowBox[{
    "vykonu", " ", "treni", " ", "kolecek", " ", "a", " ", "z", " ", "toho", 
     " ", "vyjadreneho", " ", "celkoveho", " ", "mechanickeho", " ", "vykonu",
      " ", "potrebneho", " ", "na", " ", "to", " ", "aby", " ", "to", " ", 
     "jelo"}], ",", " ", 
    RowBox[{"jak", " ", "vypocitala", " ", "kinematika"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PDrug", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"ro", "[", "teplota", "]"}], "*", 
       SuperscriptBox[
        RowBox[{"v", "[", "t", "]"}], "2"], "*", "ShydrOdpor", "*", "cx", "*", 
       RowBox[{"v", "[", "t", "]"}]}], "/.", "res"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Pstoupani", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"mRed", "*", "g", "*", 
       RowBox[{
        RowBox[{"h", "'"}], "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}], "*", 
       RowBox[{"v", "[", "t", "]"}]}], "/.", "res"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Psetrvacny", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"mRed", "*", 
       RowBox[{
        RowBox[{"v", "'"}], "[", "t", "]"}], "*", 
       RowBox[{"v", "[", "t", "]"}]}], "/.", "res"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ptreci", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"mRed", "*", "g", "*", 
       FractionBox["ramenoValivehoOdporu", "rKola"], "*", 
       FractionBox["1", 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"h", "'"}], "[", 
            RowBox[{"x", "[", "t", "]"}], "]"}], "2"]}]]], "*", 
       RowBox[{"v", "[", "t", "]"}]}], "/.", "res"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"0.001", "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PDrug", "[", "t", "]"}], ",", 
          RowBox[{"Pstoupani", "[", "t", "]"}], ",", 
          RowBox[{"Psetrvacny", "[", "t", "]"}], ",", 
          RowBox[{"Ptreci", "[", "t", "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<P [kW]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Psum", "[", "t_", "]"}], "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PDrug", "[", "t", "]"}], ",", 
        RowBox[{"Pstoupani", "[", "t", "]"}], ",", 
        RowBox[{"Psetrvacny", "[", "t", "]"}], ",", 
        RowBox[{"Ptreci", "[", "t", "]"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Psum", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<P [W\>\""}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.525079515140625*^9, 3.52507978640625*^9}, {
   3.5250798193125*^9, 3.525079889390625*^9}, {3.525079921984375*^9, 
   3.5250800965625*^9}, {3.525080131375*^9, 3.525080141328125*^9}, {
   3.52508017571875*^9, 3.525080282671875*^9}, {3.5250803178125*^9, 
   3.5250804159375*^9}, {3.525080452578125*^9, 3.525080563703125*^9}, {
   3.525080729609375*^9, 3.525080730109375*^9}, {3.5250808965*^9, 
   3.525081366390625*^9}, {3.525081399921875*^9, 3.525081417171875*^9}, {
   3.52508146109375*^9, 3.525081464328125*^9}, {3.525081546890625*^9, 
   3.52508155175*^9}, 3.525098541921875*^9, {3.52509939359375*^9, 
   3.52509943878125*^9}, {3.525099478921875*^9, 3.52509948221875*^9}, {
   3.525101439296875*^9, 3.525101593453125*^9}, {3.525101629171875*^9, 
   3.52510167540625*^9}, {3.52510179546875*^9, 3.525101798609375*^9}, {
   3.52510198496875*^9, 3.5251020280625*^9}, 3.525102426234375*^9, {
   3.525103099125*^9, 3.52510310503125*^9}, {3.525104776640625*^9, 
   3.52510477984375*^9}, {3.52514644634375*^9, 3.52514649328125*^9}, {
   3.5251465629375*^9, 3.52514667621875*^9}, {3.525146735859375*^9, 
   3.5251467378125*^9}, 3.525146771140625*^9, {3.525146838828125*^9, 
   3.525146841*^9}, {3.525146871390625*^9, 3.52514698675*^9}, {
   3.525147110890625*^9, 3.525147127390625*^9}, {3.525147251375*^9, 
   3.525147255609375*^9}, {3.525260834140625*^9, 3.52526085625*^9}, {
   3.5252609489375*^9, 3.5252609628125*^9}, 3.52526843365625*^9, 
   3.525268471296875*^9, 3.5252685029375*^9, {3.525268784921875*^9, 
   3.5252688025*^9}, {3.525269188265625*^9, 3.525269290625*^9}, {
   3.5252707503125*^9, 3.5252708299375*^9}, {3.525270939*^9, 
   3.5252709658125*^9}, {3.5252710870625*^9, 3.52527114890625*^9}, {
   3.525271179875*^9, 3.525271181078125*^9}, {3.525271229984375*^9, 
   3.5252712879375*^9}, {3.5252713621875*^9, 3.52527136784375*^9}, {
   3.525271470171875*^9, 3.52527150959375*^9}, {3.5252716285625*^9, 
   3.525271763609375*^9}, 3.525271883015625*^9, {3.525271918859375*^9, 
   3.525271920921875*^9}, {3.525272099796875*^9, 3.525272116703125*^9}, {
   3.52527215*^9, 3.525272174140625*^9}, 3.52648293465625*^9, {
   3.526486977671875*^9, 3.526487055921875*^9}, {3.526487116703125*^9, 
   3.5264871231875*^9}, {3.526488637859375*^9, 3.526488649625*^9}, 
   3.52649403478125*^9, 3.526569621171875*^9, 3.5265697389375*^9, {
   3.526738964140625*^9, 3.526738990015625*^9}, 3.527084884703125*^9, 
   3.527084925125*^9, {3.527084960609375*^9, 3.527084986234375*^9}, {
   3.527085070953125*^9, 3.52708511609375*^9}, {3.5270851498125*^9, 
   3.527085174546875*^9}, {3.527143534359375*^9, 3.52714353515625*^9}, {
   3.527143574484375*^9, 3.527143574796875*^9}, {3.527166920984375*^9, 
   3.527166941171875*^9}, 3.52716697240625*^9, {3.527167016125*^9, 
   3.527167019453125*^9}, {3.527606928890625*^9, 3.527606929125*^9}, 
   3.52760699909375*^9, 3.527607040234375*^9, 3.527607079125*^9, {
   3.5276071228125*^9, 3.527607149234375*^9}, {3.527607185921875*^9, 
   3.527607189375*^9}, 3.527607234328125*^9, 3.52760727984375*^9, {
   3.527610523171875*^9, 3.527610524359375*^9}, 3.5276122953125*^9, {
   3.527612507390625*^9, 3.527612518984375*^9}, {3.527612634984375*^9, 
   3.527612785078125*^9}, 3.528215484765625*^9, 3.52821639228125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plvys1", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"h", "[", 
          RowBox[{"x", "[", "t", "]"}], "]"}]}], "}"}], "/.", "res"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.8"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<x [m]\>\"", ",", "\"\<h [m]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Black", ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.528215534203125*^9, 3.528215570546875*^9}, {
   3.5282156194375*^9, 3.5282156298125*^9}, {3.52821570425*^9, 
   3.528215707484375*^9}, {3.528216242515625*^9, 3.52821624496875*^9}, 
   3.530103236703125*^9, 3.53010923215625*^9, {3.53012338928125*^9, 
   3.530123400203125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{" ", 
         RowBox[{
          RowBox[{
          "Jelikoz", " ", "mame", " ", "pocitat", " ", "i", " ", "skutecny", 
           " ", "prubeh", " ", "drahy"}], ",", " ", 
          RowBox[{
          "kdyz", " ", "nemame", " ", "dost", " ", "vykonu", " ", "abychom", 
           " ", "splnili", " ", "idealni", " ", "prubeh", " ", "a", " ", 
           "chceme", " ", "vyuzit", " ", "co", " ", "jsme", " ", "uz", " ", 
           "naprogramovali"}], ",", " ", 
          RowBox[{"udelame", " ", "si", " ", "funkci", " ", 
           RowBox[{"psum", "[", 
            RowBox[{"x", ",", "v"}], "]"}]}], ",", " ", 
          RowBox[{
          "coz", " ", "je", " ", "mechanicky", " ", "vykon", " ", 
           "potrebny"}], ",", " ", 
          RowBox[{
          "kdyz", " ", "v", " ", "nasem", " ", "bude", " ", "zadanym", " ", 
           "terrainem", " ", "jedeme", " ", "v", " ", "miste", " ", "x", " ", 
           "rychlosti", " ", "v", " ", "se", " ", "zrychlenim", " ", "a"}], 
          ",", " ", 
          RowBox[{"nezavisle", " ", "na", " ", "case", " ", 
           RowBox[{"t", " ", ":", "-"}]}]}], ")"}], " ", 
        "\[IndentingNewLine]", "Jednotlive", " ", "vykony", " ", "znaceny", 
        " ", "stejne"}], ",", " ", 
       RowBox[{"ale", " ", "s", " ", "malym", " ", "pocatecnim", " ", 
        RowBox[{"pismenem", ".", "\[IndentingNewLine]", "Dynamiku"}], " ", 
        "pri", " ", "reseni", " ", "budeme", " ", "proste", " ", "psat", " ", 
        "pomoci", " ", "vykonu", " ", "a", " ", "ne", " ", "sil"}], ",", " ", 
       RowBox[{
       "jen", " ", "budeme", " ", "muset", " ", "zacinat", " ", "s", " ", 
        "nenulovou", " ", "rychlosti"}], ",", " ", 
       RowBox[{"nebo", " ", "by", " ", "sily", " ", "byly", " ", 
        RowBox[{"nekonecne", ".", " ", "Ale"}], " ", "to", " ", "nejak", " ", 
        RowBox[{"obelstime", ":", "-"}]}]}], ")"}], "\[IndentingNewLine]", 
     RowBox[{"psetrvacny", "[", 
      RowBox[{"x", ",", "v"}], "]"}], " ", "znamena", " ", "pozadavek", " ", 
     "na", " ", "zrychleni"}], ",", " ", 
    RowBox[{"nikoli", " ", "skutecny", " ", "setrvacny", " ", 
     RowBox[{"vykon", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"pDrug", "[", "v_", "]"}], ":=", 
     RowBox[{"0.5", "*", 
      RowBox[{"ro", "[", "teplota", "]"}], "*", 
      SuperscriptBox["v", "2"], "*", "ShydrOdpor", "*", "cx", "*", "v"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pstoupani", "[", 
      RowBox[{"x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"mRed", "*", "g", "*", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "x", "]"}], "*", "v"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"pouziti", " ", 
      RowBox[{"az", "[", 
       RowBox[{"v", ",", 
        RowBox[{"vz", "[", "x", "]"}]}], "]"}], " ", "je", " ", "dulezite", 
      " ", "pro", " ", "dalsi", " ", "vsechna", " ", 
      RowBox[{"reseni", ":", " ", 
       RowBox[{
       "je", " ", "to", " ", "vlastne", " ", "P", " ", "regulator", " ", 
        "zajistujici"}]}]}], ",", " ", 
     RowBox[{
     "ze", " ", "dojedeme", " ", "na", " ", "zadanou", " ", "rychlost", " ", 
      RowBox[{"(", 
       RowBox[{"bude", "-", 
        RowBox[{"li", " ", "dost", " ", "casu"}]}], ")"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"psetrvacny", "[", 
      RowBox[{"x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"mRed", "*", 
      RowBox[{"az", "[", 
       RowBox[{"v", ",", 
        RowBox[{"vz", "[", "x", "]"}]}], "]"}], "*", "v"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ptreci", "[", 
      RowBox[{"x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"mRed", "*", "g", "*", 
      FractionBox["ramenoValivehoOdporu", "rKola"], "*", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{
           RowBox[{"h", "'"}], "[", "x", "]"}], "2"]}]]], "*", "v"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"psum", "[", 
      RowBox[{"x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"pDrug", "[", "v", "]"}], "+", 
      RowBox[{"pstoupani", "[", 
       RowBox[{"x", ",", "v"}], "]"}], "+", 
      RowBox[{"psetrvacny", "[", 
       RowBox[{"x", ",", "v"}], "]"}], "+", 
      RowBox[{"ptreci", "[", 
       RowBox[{"x", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"jen", " ", "kontroly"}], ",", " ", 
     RowBox[{
     "ze", " ", "to", " ", "funguje", " ", "a", " ", "jak", " ", "to", " ", 
      "funguje"}], ",", " ", 
     RowBox[{"v", " ", "Simulinku", " ", "to", " ", "nebude"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"pstoupani", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"v", "[", "t", "]"}]}], "]"}], "/.", "res"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<x [m]\>\"", ",", "\"\<P [W]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ptreci", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"v", "[", "t", "]"}]}], "]"}], "/.", "res"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<x [m]\>\"", ",", "\"\<P [W]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"psetrvacny", "[", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], ",", 
           RowBox[{"v", "[", "t", "]"}]}], "]"}]}], "}"}], "/.", "res"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<x [m]\>\"", ",", "\"\<P [W]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plvys", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"Psum", "[", "t", "]"}]}], "}"}], "/.", "res"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.8"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x [m]\>\"", ",", "\"\<P [W]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"psum", "[", 
           RowBox[{
            RowBox[{"x", "[", "t", "]"}], ",", 
            RowBox[{"v", "[", "t", "]"}]}], "]"}]}], "}"}], "/.", "res"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x [m]\>\"", ",", "\"\<P [W]\>\""}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.5"}]}], "]"}], ",", "plvys"}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.53010196525*^9, 3.530102074453125*^9}, {
   3.530102120609375*^9, 3.530102318578125*^9}, 3.53010237121875*^9, {
   3.5301024105625*^9, 3.530102411171875*^9}, {3.53010251846875*^9, 
   3.530102559375*^9}, {3.53010265728125*^9, 3.530102825515625*^9}, {
   3.530102855828125*^9, 3.5301029965625*^9}, {3.53010304271875*^9, 
   3.53010307278125*^9}, {3.530103109703125*^9, 3.530103217234375*^9}, {
   3.530103281171875*^9, 3.530103305609375*^9}, {3.530103340859375*^9, 
   3.53010334759375*^9}, {3.530103439765625*^9, 3.530103589375*^9}, {
   3.530103631328125*^9, 3.5301036741875*^9}, {3.530103709703125*^9, 
   3.530103795296875*^9}, 3.530103894296875*^9, {3.530105118296875*^9, 
   3.530105120671875*^9}, {3.530105250625*^9, 3.53010525634375*^9}, {
   3.530106563203125*^9, 3.53010659896875*^9}, {3.53010754059375*^9, 
   3.53010754090625*^9}, {3.530108003265625*^9, 3.5301080175*^9}, {
   3.530108073390625*^9, 3.530108175671875*^9}, {3.530114619453125*^9, 
   3.530114684359375*^9}, 3.530116329359375*^9, {3.530123417484375*^9, 
   3.53012342621875*^9}, {3.5301234603125*^9, 3.5301234849375*^9}, {
   3.53012353575*^9, 3.530123557109375*^9}, {3.530153569703125*^9, 
   3.53015358565625*^9}, {3.530155472015625*^9, 3.530155523984375*^9}, {
   3.530157284*^9, 3.530157306046875*^9}, 3.5301589954375*^9, 
   3.530293393296875*^9, 3.53029405196875*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
     "Tu", " ", "dynamiku", " ", "pohybu", " ", "si", " ", "radeji", " ", 
      "nacvicim", " ", "pomoci", " ", "NDSolve"}], ",", " ", 
     RowBox[{"kde", " ", "to", " ", "vic", " ", "umim"}], ",", " ", 
     RowBox[{
     "abych", " ", "to", " ", "pak", " ", "do", " ", "stavoveho", " ", 
      "modelu", " ", "napsal", " ", "a", " ", "vedel"}], ",", " ", 
     RowBox[{
     "ze", " ", "delam", " ", "chybu", " ", "tam", " ", "v", " ", 
      "programovani", " ", "a", " ", "ne", " ", "ve", " ", 
      RowBox[{"fyzice", ":", "-"}]}]}], ")"}], "\[IndentingNewLine]", "v00", 
   " ", "je", " ", "minimalni", " ", "pocatecni", " ", "rychlost", " ", 
   "abychom", " ", "nedelili", " ", "nulou", " ", "pri", " ", "vypoctu", " ", 
   RowBox[{
    RowBox[{"v", "'"}], "[", "t", "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.530103902203125*^9, 3.530103964328125*^9}, {
  3.530104405609375*^9, 3.53010441840625*^9}, {3.5301044505625*^9, 
  3.530104490328125*^9}, {3.530153614390625*^9, 3.53015361621875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Ukazka", " ", "toho"}], ",", " ", 
    RowBox[{
     RowBox[{
     "jak", " ", "zavedena", " ", "kinematika", " ", "drzi", " ", "a", " ", 
      "nedrzi", " ", "rychlost"}], "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Ve", " ", "skutecnosti", " ", "pomerne", " ", "delikatni", " ", "a", " ",
      "nesamozrejmy", " ", 
     RowBox[{"trik", ":", " ", "tim"}]}], ",", " ", 
    RowBox[{
    "ze", " ", "je", " ", "pomoci", " ", "Tanh", " ", "zavedeno", " ", 
     "zrychleni", " ", "a", " ", "setrvacny", " ", "vykon", " ", "jako", " ", 
     "funkce", " ", "v", " ", "konecnem", " ", "dusledku", " ", "realizujici",
      " ", "regulator", " ", "na", " ", "zadanou", " ", "hodnotu"}], ",", " ", 
    RowBox[{"muzeme", " ", "simulovat", " ", "fakt"}], ",", " ", 
    RowBox[{"ze", " ", "dame", " ", "jiny", " ", "vykon"}], ",", " ", 
    RowBox[{
     RowBox[{"napr", ".", " ", "mensi"}], " ", "nez", " ", "vykon", " ", 
     "zajistujici", " ", "dany", " ", "profil", " ", "trasy", " ", "a", " ", 
     "rychlosti", " ", "na", " ", "ni"}], ",", " ", 
    RowBox[{"presto", " ", "funkce", " ", 
     RowBox[{"psum", "[", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"v", "[", "t", "]"}]}], "]"}], " ", "obcas", " ", "alespon", 
     " ", "aplikovana", " ", "zaruci", " ", "snahu", " ", "o", " ", "zmineny",
      " ", 
     RowBox[{"profil", ".", " ", "Snad"}], " ", "to", " ", "bude", " ", 
     "fungovat"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.5301145778125*^9, 3.530114605359375*^9}, {
  3.530114703890625*^9, 3.53011495228125*^9}, {3.53011503815625*^9, 
  3.530115043984375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Vykon", " ", "ktery", " ", "dodavam"}], ",", " ", 
    RowBox[{
    "zmenseny", " ", "o", " ", "pZtraty", " ", "zpusobuje", " ", 
     "zrychleni"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"pZtraty", "[", 
      RowBox[{"x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"ptreci", "[", 
       RowBox[{"x", ",", "v"}], "]"}], "+", 
      RowBox[{"pstoupani", "[", 
       RowBox[{"x", ",", "v"}], "]"}], "+", 
      RowBox[{"pDrug", "[", "v", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zrychleni", "[", 
      RowBox[{"pzrychlujici_", ",", "x_", ",", "v_"}], "]"}], ":=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"mRed", "*", "v"}]], "*", 
      RowBox[{"(", 
       RowBox[{"pzrychlujici", "-", 
        RowBox[{"pZtraty", "[", 
         RowBox[{"x", ",", "v"}], "]"}]}], ")"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5301153179375*^9, 3.5301153965*^9}, {3.53011549525*^9, 
   3.5301157316875*^9}, 3.530115838359375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Tedy", " ", "bude", " ", "ve", " ", "vysledku", " ", "pzychlujici", " ", 
     "bud", " ", "spravny", " ", 
     RowBox[{"(", 
      RowBox[{"pokud", " ", "na", " ", "to", " ", "mam"}], ")"}], " ", "a", 
     " ", "nebo", " ", "jiny", " ", "vykon"}], ";", " ", 
    RowBox[{"konstrukce", " ", 
     RowBox[{"psum", "[", 
      RowBox[{"x", ",", "t"}], "]"}], " ", "ale", " ", "zajisti", " ", 
     "snahu", " ", "o", " ", "dosazeni", " ", "zadane", " ", "rychlosti", " ",
      "v", " ", "danem", " ", "miste"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kPStiham", "=", "0.93"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"v", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"zrychleni", "[", 
         RowBox[{
          RowBox[{"kPStiham", "*", 
           RowBox[{"psum", "[", 
            RowBox[{
             RowBox[{"x", "[", "t", "]"}], ",", 
             RowBox[{"v", "[", "t", "]"}]}], "]"}]}], ",", 
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"v", "[", "t", "]"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"v", "[", "t", "]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "/.", "res"}], "/.", 
      RowBox[{"t", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v00", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v0", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"v00", "+", 
        RowBox[{"v", "[", "t", "]"}]}], "/.", "res"}], "/.", 
      RowBox[{"t", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"resDyn", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"rce", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
           RowBox[{
            RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"v", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
       RowBox[{"MaxSteps", "\[Rule]", 
        SuperscriptBox["10", "6"]}], ",", 
       RowBox[{"SolveDelayed", "\[Rule]", "True"}], ",", 
       RowBox[{"StartingStepSize", "\[Rule]", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        RowBox[{
         SuperscriptBox["10", 
          RowBox[{"-", "4"}]], "tm"}]}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plvysb", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"v", "[", "t", "]"}]}], "}"}], "/.", 
        RowBox[{"resDyn", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tm"}], "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "0.8"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<x [m]\>\"", ",", 
          "\"\<v [m.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Magenta", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"plvysb", ",", "plzad", ",", "plvysa", ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5301157503125*^9, 3.530115805109375*^9}, {
   3.530115864328125*^9, 3.53011586846875*^9}, {3.53011596084375*^9, 
   3.530116075578125*^9}, {3.53011629215625*^9, 3.530116308625*^9}, {
   3.530119335984375*^9, 3.530119342625*^9}, 3.530119875*^9, 
   3.530123638140625*^9, {3.53015498375*^9, 3.53015498478125*^9}, {
   3.530292441671875*^9, 3.5302924675*^9}, {3.5302925046875*^9, 
   3.530292563484375*^9}, {3.530292732109375*^9, 3.53029273690625*^9}, 
   3.53029321759375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"budou", " ", "zadavat"}], ",", " ", 
    RowBox[{"ale", " ", "ne", " ", "moc", " ", "casto"}], ",", " ", 
    RowBox[{
    "jen", " ", "kdyby", " ", "se", " ", "neco", " ", "menilo", " ", "na", 
     " ", "buse"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"c1Aku", "=", 
     RowBox[{"42", "Ah"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uNom1Aku", "=", "12.4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cSupCap", "=", "17.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RiSupCap", "=", "0.065"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UmaxSupCap", "=", "680."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nAku", "=", "24"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "mineno", " ", "serione", " ", "v", " ", "jedne", " ", "z", " ", 
     "nParalenichAku", " ", "vetvi"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PFCmax", "=", 
     RowBox[{
      StyleBox["50",
       FontColor->GrayLevel[0]], "kW"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nParalenichAku", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PdobMax", "=", 
     RowBox[{"15", "kW"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Post", "=", "500."}], ";", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "budou", " ", "mozna", " ", "chtit", " ", "zadavat", " ", "jako", " ", 
       "funkci"}], ",", " ", 
      RowBox[{"zatim", " ", "neekli"}]}], "*)"}], 
    "\[IndentingNewLine]"}]}]}]], "Input",
 CellChangeTimes->{
  3.527612854265625*^9, {3.52761289865625*^9, 3.527612998203125*^9}, {
   3.527613093203125*^9, 3.52761310665625*^9}, 3.52761326671875*^9, {
   3.527613339546875*^9, 3.527613344375*^9}, {3.527614554*^9, 
   3.527614598609375*^9}, {3.52767343315625*^9, 3.52767343378125*^9}, {
   3.527673520515625*^9, 3.527673547625*^9}, {3.528207746734375*^9, 
   3.528207757296875*^9}, {3.528216313296875*^9, 3.528216313703125*^9}, {
   3.528216352984375*^9, 3.528216353453125*^9}, {3.5282163875625*^9, 
   3.528216387859375*^9}, {3.530292573609375*^9, 3.53029257403125*^9}, 
   3.530292806296875*^9, 3.5302929751875*^9, 3.53029628328125*^9, {
   3.530296410859375*^9, 3.530296424171875*^9}, 3.5302976300625*^9, {
   3.53029771146875*^9, 3.53029773946875*^9}, {3.530339868015625*^9, 
   3.530339871375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "celkovy", " ", "maximalni", " ", "naboj", " ", "ve", " ", "vsech", " ", 
    "aku"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Qmax", "=", 
    RowBox[{"nParalenichAku", "*", "c1Aku"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.527613038234375*^9, 3.527613065140625*^9}, {
  3.527613130265625*^9, 3.527613190109375*^9}, {3.5276148021875*^9, 
  3.527614806546875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"definice", " ", "rizeni", " ", 
    RowBox[{"FC", ".", " ", "Asi"}], " ", "to", " ", "nejlip", " ", "povi", 
    " ", "posledni", " ", "Plot"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"UFCStart", "=", 
     RowBox[{"0.9", "*", "UmaxSupCap"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PFCmin", "=", 
     RowBox[{"0.2", "PFCmax"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UFCmax", "=", 
     RowBox[{"0.6", "UmaxSupCap"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"datUcPfc", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "500"}], ",", "PFCmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"UFCmax", ",", "PFCmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"UFCStart", ",", "PFCmin"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"UFCStart", "+", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pFC", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"datUcPfc", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pFC", "[", "uc", "]"}], ",", "PFCmax", ",", "PFCmin"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"uc", ",", "0", ",", "UmaxSupCap"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Black"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"Opacity", "[", "0.3", "]"}]}], "}"}], ",", "Red"}], 
       "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<uc (V)\>\"", ",", "\"\<PFC (W)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<Strategie FC\>\""}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"UFCmax", ",", "\"\<UFCmax\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"UFCStart", ",", "\"\<UFCStart\>\""}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"PFCmax", ",", "\"\<PFCmax\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"PFCmin", ",", "\"\<PFCmin\>\""}], "}"}]}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "UFCmax", "}"}], ",", "None"}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.527613440484375*^9, 3.5276134554375*^9}, 
   3.527613811125*^9, {3.52761433090625*^9, 3.52761435359375*^9}, {
   3.5276723835*^9, 3.52767238621875*^9}, 3.530193619359375*^9, 
   3.5302929220625*^9, 3.530294522609375*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"pro", " ", "vypocty", " ", 
     RowBox[{"el", ".", " ", "obvodu"}], " ", "potrebujeme", " ", "znat", " ",
      "zavislost", " ", "vnitrniho", " ", "odporu", " ", "aku", "*"}], ",", 
    " ", 
    RowBox[{"funkce", " ", 
     RowBox[{"Ri1Aku", "[", "q_", "]"}], " ", "a", " ", 
     RowBox[{"U1Aku", "[", "q_", "]"}], " ", "jsou", " ", "tady", " ", "jen", 
     " ", "vymyslene"}], ",", " ", 
    RowBox[{
    "abych", " ", "mohl", " ", "neco", " ", "delat", " ", "nez", " ", "mi", 
     " ", "to", " ", "posle", " ", "v", " ", "yrobce"}], " ", ",", " ", 
    RowBox[{
    "nebo", " ", "nez", " ", "to", " ", "nejak", " ", "dostanu", " ", "z", 
     " ", "grafu"}], ",", " ", 
    RowBox[{
    "muzou", " ", "to", " ", "byt", " ", "i", " ", "treba", " ", 
     "interpolacni", " ", "funkce", " ", "nebo", " ", "podobny", " ", 
     "hnusy"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Ri1Aku", "[", "q_", "]"}], ":=", 
     RowBox[{"0.015", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "2.5"}], "*", 
        FractionBox[
         RowBox[{"q", "-", "Qmax"}], "Qmax"]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiAku", "[", "q_", "]"}], ":=", 
     RowBox[{
      FractionBox["nAku", "nParalenichAku"], "*", 
      RowBox[{"Ri1Aku", "[", "q", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"RiAku", "[", "q", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"q", ",", "0", ",", "Qmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"U1Aku", "[", "q_", "]"}], ":=", 
      RowBox[{"12.4", "*", 
       RowBox[{"(", 
        RowBox[{"Tanh", "[", 
         RowBox[{"4.5", "*", 
          FractionBox["q", "Qmax"]}], "]"}], ")"}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Musim", " ", "jeste", " ", "opravit"}], ",", " ", 
     RowBox[{
     "proklad", " ", "jsem", " ", "asi", " ", "udelal", " ", "pro", " ", 
      "trosku", " ", "jine", " ", "Qmax"}], ",", " ", 
     RowBox[{
     "ale", " ", "mozna", " ", "je", " ", "to", " ", "v", " ", "poho"}], ",", 
     " ", 
     RowBox[{"zatim", " ", "to", " ", "tam", " ", "dej"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"U1Aku", "[", "q_", "]"}], ":=", 
     RowBox[{"11.85", "\[InvisibleSpace]", "+", 
      RowBox[{"0.19", "*", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"0.00014", "*", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "144000"}], "+", 
           FractionBox["q", "nParalenichAku"]}], ")"}]}]]}], "+", 
      FractionBox[
       RowBox[{"1.483", "*", " ", 
        FractionBox["q", "nParalenichAku"]}], 
       RowBox[{"10873", "+", 
        FractionBox["q", "nParalenichAku"]}]]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UAku", "[", "q_", "]"}], ":=", 
     RowBox[{"nAku", "*", 
      RowBox[{"U1Aku", "[", "q", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"UAku", "[", "q", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"q", ",", "0", ",", "Qmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.526483210265625*^9, 3.52648345928125*^9}, {
   3.526483573484375*^9, 3.52648360209375*^9}, {3.526483765578125*^9, 
   3.5264838073125*^9}, {3.526483841109375*^9, 3.526483934984375*^9}, {
   3.526483981359375*^9, 3.526483984765625*^9}, {3.526484027765625*^9, 
   3.526484177828125*^9}, {3.52648421425*^9, 3.526484339921875*^9}, {
   3.52648438903125*^9, 3.5264844138125*^9}, {3.52648444384375*^9, 
   3.52648456028125*^9}, {3.526484593765625*^9, 3.526484703578125*^9}, {
   3.52648505596875*^9, 3.526485161984375*^9}, {3.526486515671875*^9, 
   3.52648652925*^9}, {3.52648656078125*^9, 3.526486576453125*^9}, {
   3.5264874526875*^9, 3.526487453171875*^9}, {3.526493930328125*^9, 
   3.5264939658125*^9}, {3.526494081421875*^9, 3.5264940888125*^9}, {
   3.526494167296875*^9, 3.526494192890625*^9}, {3.52656942171875*^9, 
   3.526569457078125*^9}, 3.526569664203125*^9, {3.526569702359375*^9, 
   3.52656970309375*^9}, {3.526569758265625*^9, 3.526569809609375*^9}, {
   3.52656984625*^9, 3.526569846890625*^9}, {3.52673915090625*^9, 
   3.52673917090625*^9}, {3.526739204390625*^9, 3.52673939240625*^9}, 
   3.52673958196875*^9, 3.52673962303125*^9, {3.526739693265625*^9, 
   3.526739723328125*^9}, {3.52699209659375*^9, 3.52699209765625*^9}, {
   3.5269943966875*^9, 3.52699440203125*^9}, {3.526996564578125*^9, 
   3.526996575578125*^9}, {3.527083035859375*^9, 3.52708303615625*^9}, {
   3.52708362346875*^9, 3.52708362603125*^9}, {3.5270870775625*^9, 
   3.527087100265625*^9}, {3.527088965515625*^9, 3.527088972015625*^9}, {
   3.527089348796875*^9, 3.527089377125*^9}, 3.527089440984375*^9, 
   3.527089805453125*^9, {3.527140014015625*^9, 3.527140015484375*^9}, 
   3.5271432843125*^9, 3.52714334865625*^9, {3.527143390265625*^9, 
   3.52714339234375*^9}, 3.527143596546875*^9, {3.527143634828125*^9, 
   3.527143641984375*^9}, {3.52714368028125*^9, 3.527143707171875*^9}, 
   3.527143738375*^9, 3.52760683803125*^9, 3.527606988140625*^9, 
   3.527609463875*^9, {3.5276127980625*^9, 3.52761279940625*^9}, 
   3.5276128501875*^9, {3.527612895671875*^9, 3.527612921859375*^9}, {
   3.5276129939375*^9, 3.5276130350625*^9}, 3.527613410015625*^9, 
   3.527614373625*^9, {3.52761440409375*^9, 3.527614522171875*^9}, {
   3.527614617875*^9, 3.527614690546875*^9}, {3.52761473*^9, 
   3.527614750921875*^9}, {3.527614939375*^9, 3.527615040390625*^9}, 
   3.527670045078125*^9, 3.52767009990625*^9, 3.528212531078125*^9, 
   3.5282126135625*^9, {3.5282130549375*^9, 3.528213055484375*^9}, {
   3.5282139220625*^9, 3.5282139221875*^9}, 3.52821431046875*^9, 
   3.52821435278125*^9, 3.528216502890625*^9, {3.528216545265625*^9, 
   3.528216548796875*^9}, {3.53015770209375*^9, 3.530157723078125*^9}, {
   3.530157841015625*^9, 3.53015784590625*^9}, {3.5301580306875*^9, 
   3.5301580578125*^9}, {3.530158094125*^9, 3.530158125984375*^9}, {
   3.53015817265625*^9, 3.530158173015625*^9}, {3.53015827534375*^9, 
   3.53015836171875*^9}, {3.530158431140625*^9, 3.530158445234375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"napeti", " ", "prechodu", " ", "diody"}], ",", " ", 
    RowBox[{"zada", " ", "se", " ", "jednou"}], ",", " ", 
    RowBox[{
    "dioda", " ", "se", " ", "v", " ", "dalsim", " ", "reprezentuje", " ", 
     "bud", " ", "zdrojem", " ", "napeti"}], ",", " ", 
    RowBox[{"nebo", " ", "vypnuty", " ", "vypinac"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"udd", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.52709018184375*^9, 3.52709024709375*^9}, {
   3.527090306421875*^9, 3.527090711796875*^9}, 3.527091068828125*^9, {
   3.527092445390625*^9, 3.527092450421875*^9}, 3.527139137734375*^9, {
   3.52761342259375*^9, 3.52761342740625*^9}, 3.52761437784375*^9, 
   3.527614413359375*^9, {3.527615066484375*^9, 3.52761508415625*^9}, {
   3.52761519815625*^9, 3.52761524240625*^9}, {3.52767022959375*^9, 
   3.527670264546875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"uvazovane", " ", "zapojeni", " ", "podle", " ", 
     RowBox[{"obr", ".", " ", "1"}]}], ",", " ", 
    RowBox[{"tak", " ", "jak", " ", "je", " ", "to", " ", 
     RowBox[{"zapojeno", ".", " ", "funkce"}], " ", "dqduc", " ", "si", " ", 
     "bere", " ", "list", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"naboj", " ", "aku"}], ",", " ", 
        RowBox[{"napeti", " ", "na", " ", "kondu"}], ",", " ", 
        RowBox[{"dobijeci", " ", "vykon", " ", "aku"}], ",", 
        RowBox[{"vykon", " ", "ze", " ", "sbernice"}]}], "}"}], ".", " ", 
      "funkce"}], " ", "vraci", " ", 
     RowBox[{"{", 
      RowBox[{"dq", ",", "duc"}], "}"}]}], ",", " ", 
    RowBox[{"coz", " ", "nejsou", " ", "diferencilay"}], ",", " ", 
    RowBox[{
    "ale", " ", "derivace", " ", "naboje", " ", "a", " ", "kondu", " ", 
     "podle", " ", "casu"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "jelikoz", " ", "diodu", " ", "uvazujeme", " ", "jako", " ", "zdroj", " ",
      "napeti", " ", "a", " ", "vypinac"}], ",", " ", 
    RowBox[{"mame", " ", "dve", " ", "nahradni", " ", "schemata"}], ",", " ", 
    RowBox[{"pro", " ", "stav", " ", "\"\<rozpojeno\>\"", "  ", 
     RowBox[{"obr", ".", " ", "2"}], " ", "a", " ", "pro", " ", "stav", " ", 
     "\"\<spojeno\>\"", " ", 
     RowBox[{"obr", ".", " ", "3"}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "je", " ", "to", " ", 
    "\"\<trochu spatne, vykon pocitame z napeti bez ubytku na risc, uvazujeme \
ho ve stavu se spojenou diodou maly\>\""}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "tahle", " ", "cast", " ", "je", " ", "ciste", " ", "o", " ", 
     "elektrice"}], ",", " ", 
    RowBox[{
    "takze", " ", "se", " ", "jinou", " ", "dynamikou", " ", "nemeni"}]}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.52767030771875*^9, 3.52767033865625*^9}, {
  3.527670876078125*^9, 3.527670995515625*^9}, {3.527671027734375*^9, 
  3.527671049375*^9}, {3.527671094015625*^9, 3.527671177625*^9}, {
  3.528214211109375*^9, 3.528214272828125*^9}, {3.530116774921875*^9, 
  3.530116801859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "dqduc", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dqduc", "[", 
     RowBox[{"{", 
      RowBox[{"q_", ",", "uc_", ",", "pdob_", ",", "psbernice_"}], "}"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "id", ",", "deruc", ",", "derq", ",", "isbernice", ",", "ic", ",", 
        "riq", ",", "uAq", ",", "uq", ",", "idob", ",", "idrozpojeno", ",", 
        "derqRozp", ",", "derucrozp", ",", "idspojeno", ",", "iAspojeno", ",",
         "derqSpoj", ",", "derucSpoj", ",", "spojeno", ",", "dq", ",", "duc", 
        ",", 
        RowBox[{"risc", "=", "RiSupCap"}], ",", "icspoj"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "ze", " ", "zadaneho", " ", "vykonu", " ", "ze", " ", "sbernice", " ", 
        "vypoctu", " ", "proud", " ", "isbernice"}], "*)"}], 
      RowBox[{
       RowBox[{"isbernice", "=", 
        FractionBox[
         RowBox[{"uc", "-", 
          SqrtBox[
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "psbernice", " ", "risc"}], "+", 
            SuperscriptBox["uc", "2"]}]]}], 
         RowBox[{"2", " ", "risc"}]]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "napoctu", " ", "si", " ", "parametry", " ", "nahradniho", " ", 
         "schematu", " ", "akumulatoru"}], "*)"}], 
       RowBox[{"uq", "=", 
        RowBox[{"UAku", "[", "q", "]"}]}], ";", 
       RowBox[{"riq", "=", 
        RowBox[{"RiAku", "[", "q", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "vypocteme", " ", "dobijeci", " ", "proud", " ", "idrozpojeno", " ", 
         "z", " ", 
         RowBox[{"podminky", ":", 
          RowBox[{"pdob", "==", 
           RowBox[{"idrozpojeno", "\[Times]", 
            RowBox[{"(", 
             RowBox[{"uq", "+", 
              RowBox[{"riq", "\[Times]", "idrozpojeno"}]}], ")"}]}]}]}]}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"idrozpojeno", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "uq"}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", "pdob", " ", "riq"}], "+", 
            SuperscriptBox["uq", "2"]}]]}], 
         RowBox[{"2", " ", "riq"}]]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "vypocteme", " ", "derivaci", " ", "naboje", " ", "v", " ", 
         "akumulatoru", " ", "a", " ", "derivaci", " ", "napeti", " ", "na", 
         " ", "kondenzatoru"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"derqRozp", "=", "idrozpojeno"}], ";", 
       RowBox[{"derucrozp", "=", 
        RowBox[{
         FractionBox[
          RowBox[{"-", "1"}], "cSupCap"], "*", "isbernice"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{
          "pro", " ", "stav", " ", "spojeno", " ", "jsou", " ", "rovnice", 
           " ", "kupodivu", " ", 
           RowBox[{"jednodussi", ":", "-"}]}], ")"}], ",", " ", 
         RowBox[{
          RowBox[{
          "dobijeci", " ", "proud", " ", "spocteme", " ", "z", " ", 
           "podminky", " ", "pdob"}], "\[Equal]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"udd", "+", "uc"}], ")"}], "*", "idspojeno"}]}]}], "*)"}],
        "\[IndentingNewLine]", 
       RowBox[{"idspojeno", "=", 
        FractionBox["pdob", 
         RowBox[{"uc", "+", "udd"}]]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"iAspojeno", " ", "napeti", " ", "na", " ", "riq"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"iAspojeno", "=", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "idspojeno"}], " ", "risc"}], "+", 
          RowBox[{"isbernice", " ", "risc"}], "-", "uc", "-", "udd", "+", 
          "uq"}], 
         RowBox[{"riq", "+", "risc"}]]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"derivace", " ", "naboje"}], ",", " ", 
         RowBox[{
         "minus", " ", "protoze", " ", "proud", " ", "tece", " ", 
          "\"\<ven\>\""}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"derqSpoj", "=", 
        RowBox[{"-", "iAspojeno"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "do", " ", "kondu", " ", "tece", " ", "proud", " ", "iAspojeno"}], 
         "+", "idspojeno", "-", 
         RowBox[{
         "isbernice", " ", "a", " ", "odtud", " ", "derivace", " ", "napeti", 
          " ", "kondu", " ", "ve", " ", "stavu", " ", "\"\<spojeno\>\""}]}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"icspoj", "=", 
        RowBox[{"(", 
         RowBox[{"iAspojeno", "+", "idspojeno", "-", "isbernice"}], ")"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"derucSpoj", "=", 
        RowBox[{
         FractionBox["1", "cSupCap"], "*", "icspoj"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "tady", " ", "je", " ", "uz", " ", "jen", " ", "reseno", " ", 
          "vetveni"}], ",", " ", 
         RowBox[{
         "podminka", " ", "spojeni", " ", "je", " ", "na", " ", "diode", " ", 
          "vetsi", " ", "nez", " ", "udd"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"spojeno", "=", 
        RowBox[{"uq", ">", 
         RowBox[{"uc", "+", "udd"}]}]}], ";", 
       RowBox[{"dq", "=", 
        RowBox[{"If", "[", 
         RowBox[{"spojeno", ",", "derqSpoj", ",", "derqRozp"}], "]"}]}], ";", 
       RowBox[{"duc", "=", 
        RowBox[{"If", "[", 
         RowBox[{"spojeno", ",", "derucSpoj", ",", "derucrozp"}], "]"}]}], 
       ";", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "duc"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"zkouska", " ", "jak", " ", "to", " ", "funguje"}], "*)"}]}], "\n", 
 RowBox[{"dqduc", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0.6", "Qmax"}], ",", "290", ",", "15000.", ",", "20000"}], "}"}],
   "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.52673974684375*^9, 3.526739828109375*^9}, 
   3.526740973921875*^9, 3.526742918796875*^9, 3.5269919241875*^9, 
   3.52709226915625*^9, {3.527671549796875*^9, 3.5276715620625*^9}, {
   3.52767161796875*^9, 3.5276718751875*^9}, {3.527671920546875*^9, 
   3.527671956640625*^9}, {3.527672114890625*^9, 3.5276721165625*^9}, 
   3.5276722100625*^9, {3.527672241828125*^9, 3.527672275515625*^9}, 
   3.52767240953125*^9, {3.527672810265625*^9, 3.52767285053125*^9}, {
   3.527673047265625*^9, 3.527673127046875*^9}, {3.527673160046875*^9, 
   3.5276732005625*^9}, {3.527673245125*^9, 3.527673368671875*^9}, {
   3.527673472375*^9, 3.527673483796875*^9}, {3.528208650234375*^9, 
   3.528208680296875*^9}, {3.52820873228125*^9, 3.5282087458125*^9}, 
   3.528210162609375*^9, {3.5282122139375*^9, 3.5282123296875*^9}, {
   3.5282123833125*^9, 3.5282125034375*^9}, {3.528212565078125*^9, 
   3.528212566140625*^9}, {3.528212663890625*^9, 3.528212686984375*^9}, {
   3.52821273503125*^9, 3.52821273765625*^9}, {3.528212794671875*^9, 
   3.528212966390625*^9}, {3.52821300465625*^9, 3.528213026625*^9}, {
   3.528213096578125*^9, 3.52821310378125*^9}, {3.528213816421875*^9, 
   3.52821382203125*^9}, {3.528213897453125*^9, 3.528213900796875*^9}, 
   3.528213946515625*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"definice", " ", "ucinnosti", " ", "palivoveho", " ", "clanku"}], 
    ",", " ", 
    RowBox[{"bude", " ", "jina"}], ",", " ", 
    RowBox[{
    "mozna", " ", "i", " ", "jako", " ", "interpolace", " ", "z", " ", 
     "tabulaky"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Tady", " ", "se", " ", "taky", " ", "nic", " ", "nemeni"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Eta]FC", "[", "pfc_", "]"}], ":=", "0.5"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Eta]FC", "[", "pfc", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"pfc", ",", "0", ",", "PFCmax"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<PFC (W)\>\"", ",", "\"\<\[Eta]PFC (-)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesOrigin", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "definice", " ", "icinnosti", " ", "menice", " ", "pro", " ", "dobijeni",
       " ", "baterii"}], ",", " ", 
     RowBox[{"bude", " ", "jina"}], ",", " ", 
     RowBox[{
     "mozna", " ", "i", " ", "jako", " ", "interpolace", " ", "z", " ", 
      "tabulaky"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Eta]dob", "[", "pdob_", "]"}], ":=", "0.95"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Eta]dob", "[", "pfc", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"pfc", ",", "0", ",", "PdobMax"}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Pdob (W)\>\"", ",", "\"\<\[Eta]dob (-)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesOrigin", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"definice", " ", "ucinnosti", " ", "soustavy", " ", "motor"}], 
      "+", "menic"}], ",", " ", 
     RowBox[{
     "Pmech", " ", "max", " ", "zavedeno", " ", "jen", " ", "aby", " ", "se", 
      " ", "mi", " ", "to", " ", "lip", " ", "psalo"}], ",", " ", 
     RowBox[{"If", " ", "rika"}], ",", " ", 
     RowBox[{
     "ze", " ", "muze", " ", "byt", " ", "jina", " ", "pro", " ", 
      "rekuperaci", " ", "a", " ", "jina", " ", "pro", " ", "smer", " ", 
      "vykonu", " ", "ven"}], ",", " ", 
     RowBox[{"bude", " ", "jina"}], ",", " ", 
     RowBox[{
     "mozna", " ", "i", " ", "jako", " ", "interpolace", " ", "z", " ", 
      "tabulaky"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Eta]M", "[", "pmech_", "]"}], ":=", "0.9"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"strategie", " ", "dobijeni", " ", "akumulatoru"}], ",", " ", 
     RowBox[{"tady", " ", "se", " ", "dobiji", " ", "stale"}], ",", " ", 
     RowBox[{"pokud", " ", "neni", " ", "aku", " ", "plna"}], ",", " ", 
     RowBox[{"mozna", " ", "bude", " ", "trochu", " ", "jina"}], ",", " ", 
     RowBox[{
     "ale", " ", "nemela", " ", "by", " ", "byt", " ", "fci", " ", "vice", 
      " ", "promennych"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Pdob", "[", 
      RowBox[{"q_", ",", "uc_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "udobMax", "}"}], ",", 
       RowBox[{
        RowBox[{"udobMax", "=", 
         RowBox[{"UAku", "[", "Qmax", "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"q", "<", "Qmax"}], ",", 
            RowBox[{"uc", ">", "udobMax"}]}], "]"}], ",", "PdobMax", ",", 
          "0"}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.52699436940625*^9, 3.526994795640625*^9}, {
   3.526994923421875*^9, 3.52699501890625*^9}, {3.526995055859375*^9, 
   3.526995179578125*^9}, {3.526995499078125*^9, 3.526995526734375*^9}, {
   3.526995621703125*^9, 3.52699563059375*^9}, {3.52699567946875*^9, 
   3.526995702328125*^9}, {3.52699598746875*^9, 3.52699598909375*^9}, {
   3.52699606034375*^9, 3.526996151921875*^9}, {3.52699630253125*^9, 
   3.526996303515625*^9}, {3.526996397578125*^9, 3.526996464515625*^9}, 
   3.527081328625*^9, 3.5270828721875*^9, {3.52708293865625*^9, 
   3.527082945875*^9}, {3.5270867211875*^9, 3.52708673721875*^9}, {
   3.5270889539375*^9, 3.52708895534375*^9}, {3.5276734175*^9, 
   3.5276734185*^9}, 3.527673505421875*^9, {3.527674162734375*^9, 
   3.5276744093125*^9}, {3.53011684646875*^9, 3.53011687096875*^9}, {
   3.5301935824375*^9, 3.5301935964375*^9}, {3.530290564078125*^9, 
   3.530290585421875*^9}, {3.5302908266875*^9, 3.530290827046875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "definice", " ", "vykonu", " ", "a", " ", "zapojeni", " ", "podle", " ", 
    RowBox[{"obr", ".", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "funkce", " ", "derstav", " ", "si", " ", "bere", " ", "dvojici", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t", "=", "cas"}], ",", 
         RowBox[{"stavovy", " ", "vektor"}]}], "}"}], " ", "a", " ", "vraci", 
       " ", "derivaci", " ", "stavoveho", " ", "vektoru", " ", "podle", " ", 
       "casu"}], ",", " ", 
      RowBox[{"q", " ", "naboj", " ", "v", " ", "aku"}], ",", " ", 
      RowBox[{"uc", " ", "napeti", " ", "kondenzatoru"}], ",", " ", 
      RowBox[{"dalsi", " ", "promenne", " ", "jsou", " ", 
       RowBox[{"energie", ":", " ", 
        RowBox[{"Wsb", " ", "energie", " ", "do", " ", "sbernice", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"spojena", " ", "s", " ", "kondem"}], ",", " ", 
           RowBox[{"vykon", " ", "psbernice"}]}], ")"}]}]}]}]}], ")"}], ",", 
    RowBox[{
    "Wdob", " ", "energie", " ", "na", " ", "dobijeni", " ", "aku", " ", 
     RowBox[{"(", 
      RowBox[{"vystup", " ", "z", " ", "menice", " ", "do", " ", "aku"}], 
      ")"}]}], ",", " ", 
    RowBox[{
    "Wfc", " ", "energie", " ", "z", " ", "palivoveho", " ", "clanku"}], ",", 
    " ", 
    RowBox[{"Wzmar", " ", "energie", " ", "marena", " ", "v", " ", "odporu"}],
     ",", " ", 
    RowBox[{"kdyz", " ", "bych", " ", "mohl", " ", "rekuperovat"}], ",", " ", 
    RowBox[{
    "ale", " ", "baterka", " ", "a", " ", "kond", " ", "vic", " ", 
     "nepoberou"}], ",", " ", 
    RowBox[{
     RowBox[{
     "Wpoh", " ", "je", " ", "energie", " ", "do", " ", "soustavy", " ", 
      "motor"}], "+", "menic"}], ",", 
    RowBox[{
    "Wdobat", " ", "je", " ", "energie", " ", "do", " ", "nabijeciho", " ", 
     "menice"}], ",", " ", 
    RowBox[{
    "Wost", " ", "energie", " ", "spotrbovana", " ", "na", " ", "ostatni", 
     " ", "spotrebu", " ", 
     RowBox[{"(", 
      RowBox[{"vse", " ", "krome", " ", "pohonu"}], ")"}]}], ",", " ", 
    RowBox[{
    "Wmech", " ", "je", " ", "energie", " ", "mechanicka", " ", "pohonu"}], 
    ",", " ", 
    RowBox[{
    "WdoFC", " ", "je", " ", "primarni", " ", "energie", " ", "vstoupivsi", 
     " ", "do", " ", "palivoveho", " ", "clanku"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "Tahle", " ", "funkce", " ", "sse", " ", "samosebou", " ", "zmeni", " ",
        "znacne"}], "..."}], " ", "v", " ", "parametrech", " ", "pribude", 
     " ", "poloha", " ", "x", " ", "a", " ", "rychlost", " ", "v"}], ",", " ", 
    RowBox[{
    "ty", " ", "se", " ", "budou", " ", "pocitat", " ", "z", " ", 
     "dynamiky"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.530116908140625*^9, 3.5301169628125*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "nejprve", " ", "ovsem", " ", "zkusime", " ", "nechat", " ", "soucasny", 
    " ", "stav"}], ",", " ", 
   RowBox[{
   "kdy", " ", "vykon", " ", "zatim", " ", "staci", " ", "a", " ", "jen", " ",
     "si", " ", "vypocitame", " ", "kinematiku"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.530117363171875*^9, 3.530117422046875*^9}, 
   3.530193905328125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Pozor", " ", "na", " ", "Pmech"}], ",", " ", 
    RowBox[{"mel", " ", "by", " ", "byt", " ", 
     RowBox[{"fci", "[", 
      RowBox[{"x", ",", "v"}], "]"}], " ", "a", " ", "nikoli", " ", 
     RowBox[{"fci", "[", "t", "]"}], " ", "jako", " ", 
     RowBox[{"Psum", "[", "t", "]"}]}], ",", " ", 
    RowBox[{
    "ale", " ", "kvuli", " ", "ladeni", " ", "zatim", " ", "je", " ", 
     "tak"}]}], "*)"}], "\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "zadani", " ", "bezrozmerneho", " ", "stavu", " ", "napeti", " ", "na", 
     " ", "kondu", " ", "a", " ", "stavu", " ", "nabiti", " ", "aku"}], ",", 
    " ", 
    RowBox[{"budou", " ", "zadavat"}], ",", " ", "novim", ",", " ", 
    RowBox[{"jestli", " ", "budou", " ", "chtit", " ", "takhle"}], ",", " ", 
    RowBox[{"nebo", " ", "zadavat", " ", "uc0", " ", "primo"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"socuc0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"soc0", "=", "1"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.530118382703125*^9, 3.530118432625*^9}, 
   3.530119201453125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vypocteni", " ", "startovaciho", " ", "stavu"}], ",", " ", 
    RowBox[{
    "energie", " ", "na", " ", "zacatku", " ", "brany", " ", "nuklove"}], ",",
     " ", 
    RowBox[{"kvuli", " ", "testovani", " ", "derstav", " ", "presunuto"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"uc0", "=", 
     RowBox[{"socuc0", "*", "UmaxSupCap"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q0", "=", 
     RowBox[{"Qmax", "*", "soc0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stavStart", "=", 
     RowBox[{"{", 
      RowBox[{
      "x0", ",", "v0", ",", "q0", ",", "uc0", ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.527142110265625*^9, 3.527142295734375*^9}, {
   3.52714236509375*^9, 3.5271423906875*^9}, {3.527142541171875*^9, 
   3.527142578140625*^9}, {3.527142637078125*^9, 3.5271426974375*^9}, {
   3.52714275875*^9, 3.52714278984375*^9}, {3.527143170328125*^9, 
   3.527143170546875*^9}, {3.527143325390625*^9, 3.527143325734375*^9}, {
   3.527143992234375*^9, 3.527143993078125*^9}, {3.52760691278125*^9, 
   3.527606913859375*^9}, 3.527606954515625*^9, {3.527615122234375*^9, 
   3.527615147265625*^9}, {3.52761525190625*^9, 3.527615265421875*^9}, 
   3.52767668796875*^9, {3.52767672078125*^9, 3.52767674665625*^9}, {
   3.527676853296875*^9, 3.5276768721875*^9}, {3.530118468453125*^9, 
   3.530118474515625*^9}, {3.530118671265625*^9, 3.5301186799375*^9}, {
   3.53011873128125*^9, 3.530118745*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Pridavame", " ", "vykonova", " ", "omezeni"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PrikonPohonMax", "=", 
     RowBox[{"250", "*", 
      SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "naboj", " ", "v", " ", "baterkach", " ", "kdy", " ", "jeste", " ", "se", 
     " ", "snazim", " ", "pozadovany", " ", "vykon", " ", "vytahnout", " ", 
     "z", " ", "baterek"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Qmin", "=", 
     RowBox[{"0.1", "Qmax"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "u", " ", "maximalniho", " ", "vykonu", " ", "mozneho", " ", "bych", " ",
       "jiz", " ", "nemel", " ", "cerpat"}], ",", " ", 
     RowBox[{
     "v", " ", "dalsim", " ", "kdoku", " ", "dostanu", " ", "komplexni", " ", 
      "cisla"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"KmaxVykon", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"PrikonPohonMax", " ", "budou", " ", "zadavat"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "derstav", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"derstav", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", 
        RowBox[{"{", 
         RowBox[{
         "x_", ",", "v_", ",", "q_", ",", "uc_", ",", "Wsb_", ",", "Wdob_", 
          ",", "Wfc_", ",", "Wzmar_", ",", "Wpoh_", ",", "Wdobat_", ",", 
          "Wost_", ",", "Wmech_", ",", "WdoFC_"}], "}"}]}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "Pmech", ",", "pdob", ",", "ppoh", ",", "pdobaterii", ",", "pdoFC", 
         ",", "podminakaMareni", ",", "pDany", ",", "pfc", ",", "psbernice", 
         ",", "pmarim", ",", "podminkaSamaSbernice", ",", "aZrychleni", ",", 
         "pMechSkutecny", ",", "taut", ",", "uq", ",", "riq", ",", "risc", 
         ",", "PelMax", ",", "PmechPozadovany", ",", "PelPohonPozadovany", 
         ",", "PmaxMuzu"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"abychom", " ", "zjistili"}], ",", " ", 
         RowBox[{
         "jestli", " ", "system", " ", "\"\<stiha\>\"", " ", "dodavat", " ", 
          "potrebny", " ", "vykon", " ", "na", " ", "jizdu", " ", "podle", 
          " ", "harmonogramu"}], ",", " ", 
         RowBox[{
         "napocteme", " ", "maximalni", " ", "dostupny", " ", "elektricky", 
          " ", "vykon", " ", "z", " ", "vykonoveho", " ", "prizpusobeni"}]}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"uq", "=", 
         RowBox[{"UAku", "[", "q", "]"}]}], ";", 
        RowBox[{"riq", "=", 
         RowBox[{"RiAku", "[", "q", "]"}]}], ";", 
        RowBox[{"risc", "=", "RiSupCap"}], ";", "\[IndentingNewLine]", 
        RowBox[{"PelMax", "=", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"uc", ">", 
             RowBox[{"uq", "-", "udd"}]}], ",", 
            RowBox[{"KmaxVykon", "*", 
             FractionBox[
              SuperscriptBox["uc", "2"], 
              RowBox[{"4", "*", "risc"}]]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"q", ">", "Qmin"}], ",", 
              RowBox[{"KmaxVykon", "*", 
               FractionBox[
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"uq", "-", "udd"}], ")"}], "2"], 
                RowBox[{"4", "*", "riq"}]]}], ",", "0"}], "]"}]}], "]"}], "+", 
          RowBox[{"pFC", "[", "uc", "]"}], "-", "Post"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "spoctu", " ", "pozadovany", " ", "mechanicky", " ", "a", " ", 
          "elektricky", " ", "vykon", " ", "\"\<aby to jelo jak chci\>\""}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"PmechPozadovany", "=", 
         RowBox[{"psum", "[", 
          RowBox[{"x", ",", "v"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"PelPohonPozadovany", "=", 
         FractionBox["PmechPozadovany", 
          RowBox[{"\[Eta]M", "[", "PmechPozadovany", "]"}]]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "dobijeni", " ", "ma", " ", "svuj", " ", "vlastni", " ", "If", " ", 
           "ve", " ", "sve", " ", "definici"}], ",", " ", 
          RowBox[{
          "v", " ", "tomto", " ", "priblizeni", " ", "ho", " ", "pocitam", 
           " ", "uz", " ", "bez", " ", "ifu"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"pdob", "=", 
         RowBox[{"Pdob", "[", 
          RowBox[{"q", ",", "uc"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pdobaterii", "=", 
         FractionBox["pdob", 
          RowBox[{"\[Eta]dob", "[", "pdob", "]"}]]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "situace", " ", "kdy", " ", "pohon", " ", "i", " ", "baterky", " ", 
          "stihaji"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"PmaxMuzu", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"PelMax", ",", "PrikonPohonMax"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"PelPohonPozadovany", "\[LessEqual]", "PmaxMuzu"}], ",", 
          RowBox[{
           RowBox[{"pMechSkutecny", "=", "PmechPozadovany"}], ";", 
           RowBox[{"ppoh", "=", "PelPohonPozadovany"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"situace", " ", "kdy", " ", "nestihame"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"PmaxMuzu", "<", "PelPohonPozadovany"}], ",", 
          RowBox[{
           RowBox[{"pMechSkutecny", "=", 
            RowBox[{"PmaxMuzu", "*", 
             RowBox[{"\[Eta]M", "[", "PmaxMuzu", "]"}]}]}], ";", 
           RowBox[{"ppoh", "=", 
            FractionBox["pMechSkutecny", 
             RowBox[{"\[Eta]M", "[", "pMechSkutecny", "]"}]]}]}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "pDany", " ", "je", " ", "vysledny", " ", "vykon", " ", 
           "sbernice"}], ",", " ", 
          RowBox[{
          "kdyby", " ", "psbernice", " ", "byla", " ", "0", " ", "a", " ", 
           "pfc", " ", "0"}], ",", " ", 
          RowBox[{
          "tedy", " ", "kdyby", " ", "se", " ", "nemenilo", " ", "napeti", 
           " ", "na", " ", "kondu", " ", "a", " ", "palivovy", " ", "clanek", 
           " ", "nejel"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"pDany", "=", 
         RowBox[{"Post", "+", "ppoh", "+", "pdobaterii"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"kdyby", " ", "toto", " ", "vychazelo", " ", "zaporne"}], 
          ",", " ", 
          RowBox[{"znamena", " ", "to"}], ",", " ", 
          RowBox[{"ze", " ", "mam", " ", "prebytek", " ", "vykonu"}], ",", 
          " ", 
          RowBox[{"ktery", " ", "nemam", " ", "kam", " ", "udat"}], ",", " ", 
          RowBox[{"podminkaMareni", " ", "mi", " ", "rika"}], ",", " ", 
          RowBox[{"jestli", " ", "takovy", " ", "stav", " ", "mam"}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"podminakaMareni", "=", 
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{"pDany", "\[LessEqual]", "0"}], ",", 
           RowBox[{"uc", "\[GreaterEqual]", "UmaxSupCap"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"plati", "-", 
           RowBox[{"li", " ", "podminakaMareni"}]}], ",", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"nastavim", " ", "pfc"}], "=", "0"}], ";", 
           RowBox[{"psbernice", "=", "0"}], ";", 
           RowBox[{"pmarim", "=", "pDany"}]}], ",", " ", 
          RowBox[{"pokud", " ", "neplati"}], ",", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"nastavim", " ", "pmarim"}], "=", "0"}], ";", 
           RowBox[{"pfc", "=", 
            RowBox[{"pFC", "[", "uc", "]"}]}], ";", 
           RowBox[{"psbernice", "=", 
            RowBox[{"pDany", "-", "pfc"}]}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"podminakaMareni", ",", 
          RowBox[{
           RowBox[{"pfc", "=", "0"}], ";", 
           RowBox[{"psbernice", "=", "0"}], ";", 
           RowBox[{"pmarim", "=", "pDany"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"pmarim", "=", "0"}], ";", 
           RowBox[{"pfc", "=", 
            RowBox[{"pFC", "[", "uc", "]"}]}], ";", 
           RowBox[{"psbernice", "=", 
            RowBox[{"pDany", "-", "pfc"}]}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "z", " ", "vysledneho", " ", "nastaveneho", " ", "pfc", " ", 
          "vypoctu", " ", "pdoFC"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"pdoFC", ":=", 
         FractionBox["pfc", 
          RowBox[{"\[Eta]FC", "[", "pfc", "]"}]]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aZrychleni", "=", 
         RowBox[{"zrychleni", "[", 
          RowBox[{"pMechSkutecny", ",", "x", ",", "v"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"vektor", ",", " ", 
          RowBox[{"ktery", " ", "funkce", " ", "vraci"}], ",", " ", 
          RowBox[{"tedy", " ", "vypoctene", " ", "derivace", " ", "naboje"}], 
          ",", " ", 
          RowBox[{
          "derivace", " ", "uc", " ", "a", " ", "po", " ", "rade", " ", 
           "vypoctene", " ", "prislusne", " ", "vykony"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"v", ",", "aZrychleni", ",", 
          RowBox[{"Sequence", "@@", 
           RowBox[{"dqduc", "[", 
            RowBox[{"{", 
             RowBox[{"q", ",", "uc", ",", "pdob", ",", "psbernice"}], "}"}], 
            "]"}]}], ",", "psbernice", ",", "pdob", ",", "pfc", ",", "pmarim",
           ",", "ppoh", ",", "pdobaterii", ",", "Post", ",", "pMechSkutecny", 
          ",", "pdoFC"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"derstav", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.9", "xmax"}], ",", "10", ",", 
        RowBox[{"0.5", "q0"}], ",", 
        RowBox[{"0.9", "uc0"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.530118064046875*^9, 3.530118070328125*^9}, {
   3.530118125640625*^9, 3.53011814125*^9}, {3.530118173953125*^9, 
   3.53011818190625*^9}, {3.530118232171875*^9, 3.5301183435*^9}, {
   3.530118756515625*^9, 3.53011881684375*^9}, {3.530118916109375*^9, 
   3.530119012015625*^9}, {3.53011904415625*^9, 3.530119049484375*^9}, {
   3.53011943453125*^9, 3.5301194409375*^9}, {3.530120365640625*^9, 
   3.530120410234375*^9}, {3.530120606453125*^9, 3.530120633921875*^9}, 
   3.530120886359375*^9, {3.530123937828125*^9, 3.53012394284375*^9}, {
   3.530153921625*^9, 3.530153963421875*^9}, 3.5301540554375*^9, 
   3.53015511196875*^9, 3.530155196765625*^9, 3.530155267984375*^9, 
   3.53015735553125*^9, {3.5301574204375*^9, 3.53015743134375*^9}, {
   3.530157487421875*^9, 3.53015754171875*^9}, {3.53019326459375*^9, 
   3.530193301078125*^9}, {3.53025287934375*^9, 3.530252897578125*^9}, {
   3.5302529435625*^9, 3.53025295746875*^9}, {3.530253002609375*^9, 
   3.530253100046875*^9}, {3.53025339134375*^9, 3.53025345934375*^9}, {
   3.53025355265625*^9, 3.530253554390625*^9}, {3.530253593796875*^9, 
   3.530253632375*^9}, {3.530254717390625*^9, 3.530254741234375*^9}, {
   3.530254836953125*^9, 3.53025492690625*^9}, {3.5302551578125*^9, 
   3.5302551880625*^9}, {3.5302553036875*^9, 3.530255450953125*^9}, {
   3.53025577371875*^9, 3.530255869703125*^9}, {3.53025591496875*^9, 
   3.530255916*^9}, 3.53025723240625*^9, {3.53025736796875*^9, 
   3.53025743515625*^9}, 3.530257481578125*^9, {3.53025751725*^9, 
   3.5302575428125*^9}, {3.5302575784375*^9, 3.53025758078125*^9}, {
   3.530257632609375*^9, 3.530257687890625*^9}, {3.530258060125*^9, 
   3.530258121890625*^9}, {3.5302581569375*^9, 3.5302583169375*^9}, {
   3.53025835234375*^9, 3.530258352640625*^9}, {3.530258400546875*^9, 
   3.530258411703125*^9}, {3.530258473203125*^9, 3.530258476140625*^9}, {
   3.530258514546875*^9, 3.530258537046875*^9}, {3.53025857659375*^9, 
   3.530258618765625*^9}, {3.53025865928125*^9, 3.5302587341875*^9}, {
   3.5302587921875*^9, 3.530258792703125*^9}, {3.530258841078125*^9, 
   3.53025892284375*^9}, {3.530258956546875*^9, 3.53025895696875*^9}, {
   3.530259018703125*^9, 3.5302590683125*^9}, {3.530259161140625*^9, 
   3.530259206890625*^9}, {3.53026004975*^9, 3.530260085703125*^9}, {
   3.530260232390625*^9, 3.530260260234375*^9}, 3.53026032153125*^9, {
   3.530260363953125*^9, 3.530260364859375*^9}, {3.530260462234375*^9, 
   3.530260465421875*^9}, {3.53026055684375*^9, 3.5302606059375*^9}, {
   3.530260886109375*^9, 3.530260888296875*^9}, {3.5302609343125*^9, 
   3.530260985265625*^9}, 3.530261161765625*^9, 3.530283915171875*^9, {
   3.530287193984375*^9, 3.53028719859375*^9}, {3.5302912693125*^9, 
   3.53029128165625*^9}, 3.530291855421875*^9, 3.5302918938125*^9, 
   3.530291942125*^9, 3.530292150609375*^9, 3.530292191625*^9, 
   3.530292624859375*^9, 3.530294093734375*^9, 3.530297174875*^9, {
   3.530339910765625*^9, 3.530339916046875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "nalezeni", " ", "nejmensiho", " ", "potrebneho", " ", "casoveho", " ", 
    "kroku", " ", "numericke", " ", "metody"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dv", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "#", "]"}], ",", 
           RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", "datRychlost"}], ")"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{"0.005", "*", 
      FractionBox["dv", 
       RowBox[{"Max", "[", 
        RowBox[{"Abs", "[", 
         RowBox[{"{", 
          RowBox[{"aminus", ",", "aplus"}], "}"}], "]"}], "]"}]]}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.527676892140625*^9, 3.52767691628125*^9}, {
   3.528219228328125*^9, 3.528219228890625*^9}, 3.528219274359375*^9, {
   3.530118605734375*^9, 3.530118609328125*^9}, 3.530119907953125*^9, {
   3.5301219273125*^9, 3.530121927546875*^9}, 3.530122029328125*^9, 
   3.530124018078125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tm", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EuSt", "[", 
    RowBox[{"stavTime", ":", 
     RowBox[{"{", 
      RowBox[{"t_", ",", "_List"}], "}"}]}], "]"}], ":=", 
   RowBox[{"stavTime", "+", 
    RowBox[{"\[CapitalDelta]t", "*", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"derstav", "[", "stavTime", "]"}]}], "}"}]}]}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.527676885609375*^9, 3.527676886734375*^9}, {
   3.528215740140625*^9, 3.52821574134375*^9}, {3.528217477046875*^9, 
   3.52821747828125*^9}, 3.530118572734375*^9, 3.530155372265625*^9, {
   3.5301557546875*^9, 3.530155755078125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "jelikoz", " ", "nedosahneme", " ", "pokazde", " ", "kvuli", " ", 
     "omezenim", " ", "systemu", " ", "vykonu", " ", "odpovidajiciho", " ", 
     "idealnimu", " ", "projeti", " ", "trasy"}], ",", " ", 
    RowBox[{"pojedeme", " ", 
     RowBox[{"dele", ":", " ", 
      RowBox[{
      "z", " ", "toho", " ", "duvodu", " ", "nekonci", " ", "iteracni", " ", 
       "vypocet", " ", "Eulerem", " ", "po", " ", "danem", " ", "poctu", " ", 
       "casovych", " ", "kroku"}]}]}], ",", " ", 
    RowBox[{"ale", " ", "dosazenim", " ", "cile"}], ",", " ", 
    RowBox[{
     RowBox[{"tedy", " ", "x"}], "\[GreaterEqual]", "xmax"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"resEu", "=", 
     RowBox[{"Timing", "[", 
      RowBox[{"NestWhileList", "[", 
       RowBox[{"EuSt", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "stavStart"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}], "<", "xmax"}], "&"}]}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<trvalo to  \>\"", ",", 
     RowBox[{"resEu", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rv", "=", 
     RowBox[{"resEu", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"drahaRychlost", "=", 
     RowBox[{"rv", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{
          "x_", ",", "v_", ",", "q_", ",", "uc_", ",", "Wsb_", ",", "Wdob_", 
           ",", "Wfc_", ",", "Wzmar_", ",", "Wpoh_", ",", "Wdobat_", ",", 
           "Wost_", ",", "Wmech_", ",", "WdoFC_"}], "}"}]}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "v"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plxv", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"drahaRychlost", ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "0", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.0035", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5301555651875*^9, 3.530155570765625*^9}, {
   3.530155624875*^9, 3.53015562984375*^9}, {3.530155670015625*^9, 
   3.530155690578125*^9}, 3.5301557226875*^9, 3.530155768*^9, {
   3.530155801640625*^9, 3.530155803015625*^9}, {3.5301558423125*^9, 
   3.530155947171875*^9}, {3.5301569078125*^9, 3.530156966484375*^9}, {
   3.5301570139375*^9, 3.53015702671875*^9}, {3.53015705703125*^9, 
   3.530157061359375*^9}, {3.530157109984375*^9, 3.530157116265625*^9}, {
   3.530157764453125*^9, 3.530157766203125*^9}, 3.53015846275*^9, 
   3.53029357075*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"dal", " ", "uz", " ", "je", " ", "to", " ", "stejne"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.53015721628125*^9, 3.530157222140625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rv", "=", 
   RowBox[{"resEu", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ucecka", "=", 
   RowBox[{"rv", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", 
       RowBox[{"{", 
        RowBox[{
        "x_", ",", "v_", ",", "q_", ",", "uc_", ",", "Wsb_", ",", "Wdob_", 
         ",", "Wfc_", ",", "Wzmar_", ",", "Wpoh_", ",", "Wdobat_", ",", 
         "Wost_", ",", "Wmech_", ",", "WdoFC_"}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       FractionBox["uc", "UmaxSupCap"]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pluc", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"ucecka", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t (s)\>\"", ",", "\"\<souc (-)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.005", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "xmax"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.530157089203125*^9, 3.530157096921875*^9}, {
   3.530293936609375*^9, 3.530293945359375*^9}, {3.530294222734375*^9, 
   3.530294235640625*^9}, 3.530294281328125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"socka", "=", 
   RowBox[{"rv", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", 
       RowBox[{"{", 
        RowBox[{
        "x_", ",", "v_", ",", "q_", ",", "uc_", ",", "Wsb_", ",", "Wdob_", 
         ",", "Wfc_", ",", "Wzmar_", ",", "Wpoh_", ",", "Wdobat_", ",", 
         "Wost_", ",", "Wmech_", ",", "WdoFC_"}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       FractionBox["q", "Qmax"]}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plsoc", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"socka", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<soc (-)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.005", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WdoFCcka", "=", 
   RowBox[{"rv", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", 
       RowBox[{"{", 
        RowBox[{
        "x_", ",", "v_", ",", "q_", ",", "uc_", ",", "Wsb_", ",", "Wdob_", 
         ",", "Wfc_", ",", "Wzmar_", ",", "Wpoh_", ",", "Wdobat_", ",", 
         "Wost_", ",", "Wmech_", ",", "WdoFC_"}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "WdoFC"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plsdoFC", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"WdoFCcka", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<WdoFC (J)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.005", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.53015716709375*^9, 3.53015717684375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"drahaRychlost", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "v_"}], "}"}], "\[RuleDelayed]", "v"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<i [-]\>\"", ",", 
        "\"\<v [m.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", "0.0055", "]"}]}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->{{3.530296586671875*^9, 3.530296770296875*^9}, {
  3.530296807125*^9, 3.530296860609375*^9}, {3.530296975703125*^9, 
  3.530296996703125*^9}}],

Cell[BoxData[{
 RowBox[{"Show", "[", 
  RowBox[{"plxv", ",", "plzad", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]", "pluc", "\[IndentingNewLine]", 
 RowBox[{"plzad", 
  ";"}], "\[IndentingNewLine]", "plh", "\[IndentingNewLine]", "plsoc", "\n", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<prum. rychlost= \>\"", ",", 
   RowBox[{"3.6", "*", 
    FractionBox[
     RowBox[{"rv", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2", ",", "1"}], "]"}], "]"}], 
     RowBox[{"rv", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]]}], ",", 
   "\"\< km/h,  cas jizdy= \>\"", ",", 
   RowBox[{
    RowBox[{"rv", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}], "/", "60"}], ",", 
   "\"\< min, ujeta draha= \>\"", ",", 
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], 
    RowBox[{"rv", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "1"}], "]"}], "]"}]}], ",", 
   "\"\< km\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.530159070734375*^9, 3.53015908215625*^9}, {
   3.53029346015625*^9, 3.530293555515625*^9}, {3.53029376078125*^9, 
   3.53029379125*^9}, 3.530295194859375*^9, {3.53029524253125*^9, 
   3.5302952914375*^9}, {3.530296134125*^9, 3.5302961399375*^9}}]
},
WindowSize->{1698, 918},
WindowMargins->{{8, Automatic}, {Automatic, 19}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 333, 10, 103, "Input"],
Cell[881, 32, 2844, 71, 606, "Input"],
Cell[3728, 105, 3352, 85, 301, "Input"],
Cell[7083, 192, 2658, 69, 243, "Input"],
Cell[9744, 263, 1554, 38, 187, "Input"],
Cell[11301, 303, 2501, 66, 250, "Input"],
Cell[13805, 371, 2540, 70, 271, "Input"],
Cell[16348, 443, 2385, 56, 280, "Input"],
Cell[18736, 501, 1142, 32, 103, "Input"],
Cell[19881, 535, 1370, 36, 158, "Input"],
Cell[21254, 573, 2673, 53, 166, "Input"],
Cell[23930, 628, 1068, 25, 131, "Input"],
Cell[25001, 655, 2027, 51, 194, "Input"],
Cell[27031, 708, 6898, 148, 411, "Input"],
Cell[33932, 858, 1135, 27, 103, "Input"],
Cell[35070, 887, 9649, 234, 971, "Input"],
Cell[44722, 1123, 1089, 22, 131, "Input"],
Cell[45814, 1147, 1755, 37, 243, "Input"],
Cell[47572, 1186, 1123, 31, 158, "Input"],
Cell[48698, 1219, 4561, 122, 397, "Input"],
Cell[53262, 1343, 2430, 58, 568, "Input"],
Cell[55695, 1403, 467, 11, 164, "Input"],
Cell[56165, 1416, 3085, 85, 568, "Input"],
Cell[59253, 1503, 6547, 140, 923, "Input"],
Cell[65803, 1645, 1006, 21, 299, "Input"],
Cell[66812, 1668, 2278, 52, 612, "Input"],
Cell[69093, 1722, 7506, 176, 1803, "Input"],
Cell[76602, 1900, 5077, 122, 881, "Input"],
Cell[81682, 2024, 2948, 71, 523, "Input"],
Cell[84633, 2097, 413, 10, 120, "Input"],
Cell[85049, 2109, 1173, 29, 254, "Input"],
Cell[86225, 2140, 1670, 35, 299, "Input"],
Cell[87898, 2177, 13730, 294, 2441, "Input"],
Cell[101631, 2473, 1276, 36, 216, "Input"],
Cell[102910, 2511, 770, 21, 211, "Input"],
Cell[103683, 2534, 3040, 76, 478, "Input"],
Cell[106726, 2612, 182, 4, 73, "Input"],
Cell[106911, 2618, 1690, 46, 348, "Input"],
Cell[108604, 2666, 2539, 68, 571, "Input"],
Cell[111146, 2736, 787, 21, 126, "Input"],
Cell[111936, 2759, 1365, 37, 419, "Input"]
}
]
*)

(* End of internal cache information *)
