(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27699,        781]
NotebookOptionsPosition[     27184,        761]
NotebookOutlinePosition[     27585,        778]
CellTagsIndexPosition[     27542,        775]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.51609935275*^9, 3.516099367171875*^9}, {
  3.516252719015625*^9, 3.516252724765625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vrtsStations", "=", 
   RowBox[{"<<", "\"\<vrtsStations\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prdeles", "=", 
   RowBox[{"<<", "\"\<prdeles\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.516099551921875*^9, 3.51609956234375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"km", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Rz", "=", 
    RowBox[{"6372", "km"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Chi]", " ", "rovnobezky"}], ",", " ", 
    RowBox[{"\[CurlyPhi]", " ", "poledniky"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"toCart", "[", 
    RowBox[{"{", 
     RowBox[{"\[Chi]_", ",", "\[CurlyPhi]_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rz", " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[Chi]", "]"}]}], ",", 
     RowBox[{"Rz", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[Chi]", "]"}]}], ",", 
     RowBox[{"Rz", " ", 
      RowBox[{"Sin", "[", "\[Chi]", "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dg", "=", 
   FractionBox["Pi", "180."]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Chi]0", "=", 
   RowBox[{"50.09", "dg"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CurlyPhi]0", "=", 
   RowBox[{"14.4", "dg"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", 
   RowBox[{"0.01", "dg"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norm", ":=", 
   RowBox[{
    FractionBox["#", 
     RowBox[{"Norm", "[", "#", "]"}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"norm", "[", 
    RowBox[{
     RowBox[{"toCart", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Chi]0", "+", "\[CapitalDelta]"}], ",", "\[CurlyPhi]0"}], 
       "}"}], "]"}], "-", 
     RowBox[{"toCart", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Chi]0", "-", "\[CapitalDelta]"}], ",", "\[CurlyPhi]0"}], 
       "}"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"-", 
    RowBox[{"norm", "[", 
     RowBox[{
      RowBox[{"toCart", "[", 
       RowBox[{"{", 
        RowBox[{"\[Chi]0", ",", 
         RowBox[{"\[CurlyPhi]0", "+", "\[CapitalDelta]"}]}], "}"}], "]"}], 
      "-", 
      RowBox[{"toCart", "[", 
       RowBox[{"{", 
        RowBox[{"\[Chi]0", ",", 
         RowBox[{"\[CurlyPhi]0", "-", "\[CapitalDelta]"}]}], "}"}], "]"}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stred", "=", 
   RowBox[{"toCart", "[", 
    RowBox[{"{", 
     RowBox[{"\[Chi]0", ",", "\[CurlyPhi]0"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"doRoviny", "[", 
    RowBox[{"b", ":", 
     RowBox[{"{", 
      RowBox[{"\[Chi]_", ",", "\[CurlyPhi]_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"smer", ",", "kt", ",", "ku", ",", "kv"}], "}"}], ",", 
      RowBox[{
       RowBox[{"smer", "=", 
        RowBox[{"norm", "@", "stred"}]}], ";", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "kv"}], ",", "ku"}], "}"}], "/.", 
        RowBox[{"Solve", "[", 
         RowBox[{"Thread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"kt", "*", "smer"}], "+", 
             RowBox[{"toCart", "[", "b", "]"}]}], "\[Equal]", 
            RowBox[{"stred", "+", 
             RowBox[{"ku", "*", "u"}], "+", 
             RowBox[{"kv", "*", "v"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"kt", ",", "ku", ",", "kv"}], "}"}]}], "]"}], "]"}]}]}]}],
      "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"from", ":=", 
   RowBox[{
    RowBox[{"FromDMS", "[", 
     RowBox[{"dg", "*", "#"}], "]"}], "&"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Praha", "=", 
    RowBox[{"{", 
     RowBox[{"\"\<praha\>\"", ",", 
      RowBox[{"doRoviny", "[", 
       RowBox[{"from", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"50", ",", "5", ",", "0.953"}], "}"}], ",", 
          RowBox[{"{", " ", 
           RowBox[{"14", ",", "27", ",", "44.503"}], "}"}]}], "}"}]}], 
       "]"}]}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prds", "=", 
   RowBox[{"prdeles", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"doRoviny", "[", 
      RowBox[{"dg", "*", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vrts", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"vrtsStations", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p_", ",", 
         RowBox[{"{", 
          RowBox[{"b_", ",", "c_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"doRoviny", "[", 
          RowBox[{"dg", "*", 
           RowBox[{"{", 
            RowBox[{"b", ",", "c"}], "}"}]}], "]"}]}], "}"}]}]}], ",", 
     "Praha"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ukVrt", "[", 
    RowBox[{"{", 
     RowBox[{"popis_", ",", 
      RowBox[{"bod", ":", 
       RowBox[{"{", 
        RowBox[{"b_", ",", "c_"}], "}"}]}]}], "}"}], "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0", "]"}], ",", 
       RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
       RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
       RowBox[{"Point", "[", "bod", "]"}], ",", 
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Opacity", "[", "1", "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"popis", ",", "\"\<Medium\>\""}], "]"}], ",", "bod", ",", 
         RowBox[{"{", 
          RowBox[{"Center", ",", "Bottom"}], "}"}]}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mesta", "=", 
   RowBox[{"ukVrt", "/@", "vrts"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prdsGr", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.011", "]"}], ",", 
        RowBox[{"Opacity", "[", "1", "]"}], ",", 
        RowBox[{"Point", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
    "prds"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"trate", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"praha", ",", "usti"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"praha", ",", "liberec"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"usti", ",", "drazdany"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"praha", ",", "plzen"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"plzen", ",", "chemDojc"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"plzen", ",", "kVary"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kVary", ",", "hofDojc"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"praha", ",", "budejice"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"budejice", ",", "jihlava"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"praha", ",", "brno"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"praha", ",", "hk"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ostrava", ",", "katowiz"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ostrava", ",", "zilina"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"brno", ",", "zilina"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"brno", ",", "viden"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"blava", ",", "zilina"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kVary", ",", "praha"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"drazdany", ",", "liberec"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jihlava", ",", "brno"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jihlava", ",", "viden"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"liberec", ",", "hk"}], "}"}]}], "}"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"ToString", "/@", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejTrat", "[", "dveMesta_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Cases", "[", 
         RowBox[{"vrts", ",", 
          RowBox[{"{", 
           RowBox[{"#", ",", 
            RowBox[{"{", 
             RowBox[{"_", ",", "_"}], "}"}]}], "}"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "dveMesta"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grTrat", "[", "dveMesta_", "]"}], ":=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"dejTrat", "[", "dveMesta", "]"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"trtsGr", "=", 
   RowBox[{"grTrat", "/@", "trate"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"mesta", ",", "prdsGr", ",", "trtsGr"}], "]"}], "\n"}], "Input",
 CellChangeTimes->{{3.515979642390625*^9, 3.515979716234375*^9}, {
   3.515979750625*^9, 3.5159797928125*^9}, {3.515979849484375*^9, 
   3.5159798795625*^9}, {3.515979921421875*^9, 3.51597996103125*^9}, {
   3.515980030203125*^9, 3.51598004321875*^9}, {3.515980261765625*^9, 
   3.51598028690625*^9}, {3.51598032546875*^9, 3.515980390671875*^9}, 
   3.5159804286875*^9, {3.515980500515625*^9, 3.51598053978125*^9}, {
   3.515980668796875*^9, 3.5159807268125*^9}, 3.51598093728125*^9, 
   3.515994103359375*^9, {3.51599448984375*^9, 3.515994497875*^9}, {
   3.51599455015625*^9, 3.515994644765625*^9}, {3.515994841765625*^9, 
   3.51599498103125*^9}, {3.515995063765625*^9, 3.5159951789375*^9}, {
   3.515999671296875*^9, 3.515999712140625*^9}, 3.51600409621875*^9, {
   3.51600569284375*^9, 3.516005824875*^9}, {3.5160058611875*^9, 
   3.516005989640625*^9}, {3.516006045703125*^9, 3.516006060171875*^9}, {
   3.5160069781875*^9, 3.51600698978125*^9}, {3.5160826263125*^9, 
   3.51608263725*^9}, {3.51608298803125*^9, 3.51608298834375*^9}, {
   3.516099509046875*^9, 3.516099547390625*^9}, {3.51611124084375*^9, 
   3.516111241171875*^9}, 3.51611293321875*^9, 3.516113970234375*^9, {
   3.516114000375*^9, 3.5161140178125*^9}, {3.51611405884375*^9, 
   3.516114079765625*^9}, 3.516114131921875*^9, {3.516114233328125*^9, 
   3.516114234671875*^9}, {3.51611430265625*^9, 3.516114330234375*^9}, 
   3.51611441296875*^9, {3.51611481025*^9, 3.516114898328125*^9}, {
   3.516115423921875*^9, 3.5161154263125*^9}, {3.5161154589375*^9, 
   3.51611555784375*^9}, {3.516115741375*^9, 3.516115759734375*^9}, {
   3.516117247265625*^9, 3.5161172956875*^9}, {3.5161173695625*^9, 
   3.5161173738125*^9}, {3.516117416203125*^9, 3.5161174955*^9}, {
   3.516118196625*^9, 3.5161181970625*^9}, {3.516255519265625*^9, 
   3.516255522*^9}, {3.516257488921875*^9, 3.51625749440625*^9}, {
   3.51625752865625*^9, 3.516257529421875*^9}, {3.516284097109375*^9, 
   3.5162841218125*^9}, {3.5162841689375*^9, 3.516284169359375*^9}, 
   3.51628423915625*^9, 3.516285317921875*^9, {3.516287999765625*^9, 
   3.516288001*^9}, {3.51628884796875*^9, 3.516288989828125*^9}, {
   3.516289222671875*^9, 3.516289227890625*^9}, {3.516289297640625*^9, 
   3.51628931121875*^9}, {3.51628935009375*^9, 3.5162893581875*^9}, 
   3.516289390328125*^9, 3.516289421953125*^9, {3.516289484296875*^9, 
   3.516289488671875*^9}, 3.516289979375*^9, {3.516290337609375*^9, 
   3.516290348578125*^9}, 3.51637903665625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"minOdchylka", "=", ".4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"vydej", ",", "ukazOpt"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydej", "[", 
     RowBox[{"arg", ":", 
      RowBox[{"{", 
       RowBox[{"p_", ",", 
        RowBox[{"dr", ":", 
         RowBox[{"{", 
          RowBox[{"b_", ",", "c_"}], "}"}]}]}], "}"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"body", ",", "usecka", ",", "t", ",", 
        RowBox[{"\[CapitalDelta]t", "=", "0.01"}], ",", "vAt", ",", "best", 
        ",", "bt", ",", "min", ",", "pom", ",", "tOpt", ",", "sel", ",", 
        "vs"}], "}"}], ",", 
      RowBox[{
       RowBox[{"body", "=", 
        RowBox[{"dejTrat", "[", "dr", "]"}]}], ";", 
       RowBox[{"usecka", ":=", 
        RowBox[{
         RowBox[{
          RowBox[{"body", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{"#", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"body", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", 
             RowBox[{"body", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "&"}]}], ";", 
       RowBox[{"vAt", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{
              RowBox[{"usecka", "[", "#", "]"}], "-", "p"}], "]"}], ",", 
            "#"}], "}"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"0.", ",", "1.", ",", "\[CapitalDelta]t"}], "]"}]}]}], ";", 
       RowBox[{"best", "=", 
        RowBox[{"First", "@", 
         RowBox[{"Sort", "[", "vAt", "]"}]}]}], ";", 
       RowBox[{"min", "=", 
        RowBox[{"best", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", 
       RowBox[{"bt", "=", 
        RowBox[{"best", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", 
       RowBox[{"sel", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"vAt", ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "minOdchylka"}], ")"}], "*", "min"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "minOdchylka"}], ")"}], "*", "min"}]}], 
           "&"}]}], "]"}]}], ";", 
       RowBox[{"vs", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "sel"}]}], ";", 
       RowBox[{"tOpt", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"bt", "\[Equal]", "1."}], "||", 
           RowBox[{"bt", "\[Equal]", "0."}]}], ",", 
          RowBox[{"{", "bt", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Min", "[", "vs", "]"}], ",", 
            RowBox[{"Max", "[", "vs", "]"}]}], "}"}]}], "]"}]}], ";", 
       RowBox[{"{", 
        RowBox[{"min", ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", 
           RowBox[{"usecka", "/@", "tOpt"}]}], "}"}]}], "}"}]}]}], "]"}]}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ukazOpt", "[", 
     RowBox[{"{", 
      RowBox[{"prdel_", ",", "body_"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", "=", 
        RowBox[{"Length", "[", "body", "]"}]}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[Equal]", "1"}], ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"Opacity", "[", "0.9", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"prdel", ",", 
              RowBox[{"body", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}],
         ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Hue", "[", "0", "]"}], ",", 
           RowBox[{"Opacity", "[", "0.3", "]"}], ",", 
           RowBox[{"Polygon", "[", 
            RowBox[{"{", 
             RowBox[{"prdel", ",", 
              RowBox[{"body", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"body", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
         "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "spojPrdel", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"spojPrdel", "[", "prdel_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"all", ",", "min"}], "}"}], ",", 
     RowBox[{
      RowBox[{"all", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"vydej", "[", 
           RowBox[{"{", 
            RowBox[{"prdel", ",", "#"}], "}"}], "]"}], "&"}], "/@", "trate"}],
         "]"}]}], ";", 
      RowBox[{"min", "=", 
       RowBox[{"all", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
      RowBox[{"Union", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"all", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "minOdchylka"}], ")"}], "*", "min"}]}], 
           "&"}]}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spojVse", "=", 
   RowBox[{"spojPrdel", "/@", "prds"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spojeni", "=", 
   RowBox[{"ukazOpt", "/@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"spojVse", ",", "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"mesta", ",", "prdsGr", ",", "trtsGr", ",", "spojeni"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.51628577371875*^9, 3.516285890828125*^9}, {
   3.516285948875*^9, 3.516286001640625*^9}, {3.516286059953125*^9, 
   3.516286081578125*^9}, {3.516286171578125*^9, 3.516286171890625*^9}, {
   3.516286211875*^9, 3.516286237171875*^9}, {3.516286285046875*^9, 
   3.516286311421875*^9}, {3.51628634621875*^9, 3.516286406640625*^9}, {
   3.51628644328125*^9, 3.516286449359375*^9}, {3.516286588875*^9, 
   3.516286605921875*^9}, {3.516286662328125*^9, 3.516286746359375*^9}, {
   3.51628680078125*^9, 3.51628685625*^9}, {3.516286915625*^9, 
   3.516286916828125*^9}, {3.516287013*^9, 3.5162870441875*^9}, {
   3.516287095546875*^9, 3.51628714140625*^9}, {3.51628718903125*^9, 
   3.516287280453125*^9}, {3.516287534984375*^9, 3.51628754459375*^9}, {
   3.516288382828125*^9, 3.516288469703125*^9}, {3.51628900490625*^9, 
   3.51628902284375*^9}, 3.5162890585625*^9, {3.516289109765625*^9, 
   3.5162891493125*^9}, 3.51628925475*^9, 3.51628952984375*^9, 
   3.516289726078125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"zkus", ":=", 
     RowBox[{
      FractionBox[
       RowBox[{"#", "-", 
        RowBox[{"zRoviny", "[", 
         RowBox[{"doRoviny", "[", "#", "]"}], "]"}]}], 
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{"#", "-", "arg0"}], "]"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arg0", "=", 
     RowBox[{"{", 
      RowBox[{"\[Chi]0", ",", "\[CurlyPhi]0"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"v1", "=", 
     RowBox[{"doRoviny", "[", 
      RowBox[{"t1", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Chi]0", "+", "\[CapitalDelta]"}], ",", "\[CurlyPhi]0"}], 
        "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v2", "=", 
     RowBox[{"doRoviny", "[", 
      RowBox[{"t2", "=", 
       RowBox[{"{", 
        RowBox[{"\[Chi]0", ",", 
         RowBox[{"\[CurlyPhi]0", "+", "\[CapitalDelta]"}]}], "}"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", "=", 
     RowBox[{"(", GridBox[{
        {"a", "b"},
        {"c", "d"}
       }], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vysmat", "=", 
     RowBox[{"mat", "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{"Union", "[", 
         RowBox[{
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{"v1", ".", "mat"}], "\[Equal]", 
            RowBox[{"t1", "-", "arg0"}]}], "]"}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{"v2", ".", "mat"}], "\[Equal]", 
            RowBox[{"t2", "-", "arg0"}]}], "]"}]}], "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zRoviny", "[", 
      RowBox[{"v", ":", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"v", ".", "vysmat"}], "+", "arg0"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<max chyba= \>\"", ",", 
     RowBox[{"100", "*", 
      RowBox[{"Max", "[", 
       RowBox[{"Abs", "/@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"zkus", "/@", 
          RowBox[{"(", 
           RowBox[{"dg", "*", "prdeles"}], ")"}]}], "]"}]}], "]"}]}], ",", 
     "\"\< %\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5162915173125*^9, {3.516291743359375*^9, 3.51629178659375*^9}, {
   3.516291937765625*^9, 3.5162921104375*^9}, {3.5163744745625*^9, 
   3.51637450265625*^9}, 3.516374541875*^9, {3.5163745725625*^9, 
   3.516374577*^9}, 3.516374735078125*^9, {3.5163747824375*^9, 
   3.51637478571875*^9}, {3.51637482615625*^9, 3.516374845140625*^9}, {
   3.5163749828125*^9, 3.51637520496875*^9}, 3.516375246765625*^9, {
   3.516375322671875*^9, 3.51637532478125*^9}, {3.516375356328125*^9, 
   3.516375357296875*^9}, {3.516375557453125*^9, 3.51637556028125*^9}, {
   3.516375693734375*^9, 3.516375720953125*^9}, {3.51637579803125*^9, 
   3.516375802828125*^9}, {3.516375917296875*^9, 3.51637596471875*^9}, {
   3.51637599946875*^9, 3.516376077109375*^9}, {3.51637628296875*^9, 
   3.5163762854375*^9}, {3.51637632396875*^9, 3.516376327140625*^9}, 
   3.516377769109375*^9, {3.51637868871875*^9, 3.516378688953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "vyrchi", ",", "vyrfi", ",", "zkus", ",", "zRoviny", ",", "chi", ",", 
    "fi"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dgprdeles", "=", 
   RowBox[{"dg", "*", "prdeles"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"np", "=", 
   RowBox[{"Length", "[", "prdeles", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodchi", ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"prds", "[", 
        RowBox[{"[", "#", "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"dgprdeles", "[", 
        RowBox[{"[", 
         RowBox[{"#", ",", "1"}], "]"}], "]"}], "-", "\[Chi]0"}]}], "}"}], 
    "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodfi", ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"prds", "[", 
        RowBox[{"[", "#", "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"dgprdeles", "[", 
        RowBox[{"[", 
         RowBox[{"#", ",", "2"}], "]"}], "]"}], "-", "\[CurlyPhi]0"}]}], 
     "}"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datchi", "=", 
   RowBox[{"bodchi", "/@", 
    RowBox[{"Range", "[", "np", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"chi", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"datchi", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", 
       SuperscriptBox["x", "2"], ",", 
       SuperscriptBox["y", "2"], ",", 
       RowBox[{"x", "*", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datfi", "=", 
   RowBox[{"bodfi", "/@", 
    RowBox[{"Range", "[", "np", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fi", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"datfi", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", 
       SuperscriptBox["x", "2"], ",", 
       SuperscriptBox["y", "2"], ",", 
       RowBox[{"x", "*", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zkus", ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"#", "-", 
      RowBox[{"zRoviny", "[", 
       RowBox[{"doRoviny", "[", "#", "]"}], "]"}]}], 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"#", "-", "arg0"}], "]"}], "+", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zRoviny", "[", 
    RowBox[{"v", ":", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"arg0", "+", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"chi", "[", "v", "]"}], ",", 
      RowBox[{"fi", "[", "v", "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<max chyba= \>\"", ",", 
   RowBox[{"100", "*", 
    RowBox[{"Max", "[", 
     RowBox[{"Abs", "/@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"zkus", "/@", 
        RowBox[{"(", 
         RowBox[{"dg", "*", "prdeles"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   "\"\< %\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.51637737721875*^9, 3.516377629921875*^9}, {
  3.516377700828125*^9, 3.516377754703125*^9}, {3.516377800125*^9, 
  3.516377937640625*^9}}]
},
WindowSize->{1147, 766},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 320, 8, 67, "Input"],
Cell[868, 30, 292, 7, 67, "Input"],
Cell[1163, 39, 11902, 321, 978, "Input"],
Cell[13068, 362, 7209, 194, 567, "Input"],
Cell[20280, 558, 3375, 89, 297, "Input"],
Cell[23658, 649, 3522, 110, 361, "Input"]
}
]
*)

(* End of internal cache information *)
