(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8347,        246]
NotebookOptionsPosition[      7693,        222]
NotebookOutlinePosition[      8093,        239]
CellTagsIndexPosition[      8050,        236]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"FileNames", "[", "]"}]], "Input",
 CellChangeTimes->{{3.694009747296875*^9, 3.694009749859375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"First", "/@", 
    RowBox[{"Import", "[", "\"\<denniVykony.csv\>\"", "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.694230535390625*^9, 3.694230564015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"maxP", "=", 
   RowBox[{"Max", "[", "dats", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minP", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nVykonu", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]P", "=", 
   FractionBox[
    RowBox[{"maxP", "-", "minP"}], 
    RowBox[{"nVykonu", "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vykony", "=", "dats"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"nDni", "[", "vykon_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "sel", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sel", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"vykony", ",", 
          RowBox[{
           RowBox[{"#", "\[GreaterEqual]", "vykon"}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Length", "[", "sel", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataCara", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"nDni", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "maxP", ",", "\[CapitalDelta]P"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plok", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"dataCara", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t[dni]\>\"", ",", "\"\<P[kW]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], 
   "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6940100943125*^9, 3.694010398671875*^9}, {
   3.694010513015625*^9, 3.694010551*^9}, {3.69401058934375*^9, 
   3.694010598921875*^9}, {3.69401063434375*^9, 3.694010900578125*^9}, {
   3.694011017546875*^9, 3.69401104840625*^9}, {3.69401118721875*^9, 
   3.694011247390625*^9}, 3.6940113826875*^9, 3.69401144640625*^9, {
   3.694011539953125*^9, 3.694011560015625*^9}, {3.694011823125*^9, 
   3.694011830421875*^9}, 3.69401188434375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"plu", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Reverse", "[", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"dataCara", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "==", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.694011638640625*^9, 3.694011656671875*^9}, {
   3.694011742328125*^9, 3.69401175371875*^9}, 3.69401195353125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vydejObdelnik", "[", 
    RowBox[{"pmax1_", ",", "pmax2_"}], "]"}], ":=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cas", ",", "t", ",", "myt1", ",", "myt2", ",", "gr"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"myt1", "=", 
        RowBox[{"t", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"plu", "[", "t", "]"}], "\[Equal]", "pmax1"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "180"}], "}"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"myt2", "=", 
        RowBox[{"t", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"plu", "[", "t", "]"}], "\[Equal]", 
            RowBox[{"pmax2", "+", "pmax1"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "180"}], "}"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"gr", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Magenta", ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"myt1", ",", "pmax1"}], "}"}]}], "]"}], ",", "Blue", 
           ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "pmax1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"myt2", ",", 
               RowBox[{"pmax2", "+", "pmax1"}]}], "}"}]}], "]"}]}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Show", "[", 
        RowBox[{"plok", ",", "gr", ",", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"\"\<Ecelk= \>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "6"}]], "3600", "*", "24", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"myt1", "*", "pmax1"}], "+", 
               RowBox[{"myt2", "*", "pmax2"}]}], ")"}]}], "]"}], "<>", 
           "\"\<  GJ\>\""}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "0.5"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pp1", "=", "4000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pp2", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejObdelnik", "[", 
  RowBox[{"pp1", ",", "pp2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"vydejObdelnik", "[", 
  RowBox[{"pp2", ",", "pp1"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.69401186278125*^9, 3.694011908234375*^9}, {
  3.694011938703125*^9, 3.694011940765625*^9}, {3.694231909515625*^9, 
  3.6942319109375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Calendar`"}], ";"}]], "Input"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6942317210625*^9, 3.694231730125*^9}}],

Cell[BoxData[
 RowBox[{"EasterSunday", "[", "2017", "]"}]], "Input",
 CellChangeTimes->{{3.694231799234375*^9, 3.694231800953125*^9}}],

Cell[BoxData[
 RowBox[{"JewishNewYear", "[", "2017", "]"}]], "Input",
 CellChangeTimes->{3.69423182478125*^9}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->1.350000023841858,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 455, 14, 108, "Input"],
Cell[1003, 36, 123, 2, 38, "Input"],
Cell[1129, 40, 225, 6, 38, "Input"],
Cell[1357, 48, 2393, 62, 363, "Input"],
Cell[3753, 112, 552, 15, 38, "Input"],
Cell[4308, 129, 2967, 76, 354, "Input"],
Cell[7278, 207, 71, 2, 38, "Input"],
Cell[7352, 211, 87, 1, 38, "Input"],
Cell[7442, 214, 134, 2, 38, "Input"],
Cell[7579, 218, 110, 2, 38, "Input"]
}
]
*)

(* End of internal cache information *)
