(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31477,        788]
NotebookOptionsPosition[     30464,        750]
NotebookOutlinePosition[     30950,        769]
CellTagsIndexPosition[     30907,        766]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nDat", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]t", "=", 
    RowBox[{
     FractionBox["2.", "nDat"], "*", "Pi"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], "+", 
         "0.6"}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"5.5", "*", "nDat"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"k3", ",", "k5", ",", "k7"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.2", ",", "0.1"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPeriod", "=", "3.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], "+", 
          "0.6"}], "]"}], "+", 
        RowBox[{"k3", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"3", "*", 
            RowBox[{"(", 
             RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], "+", 
           "0.721"}], "]"}]}], "+", 
        RowBox[{"k5", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"5", "*", 
            RowBox[{"(", 
             RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], "-", 
           "0.721"}], "]"}]}], "+", 
        RowBox[{"k7", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"7", "*", 
            RowBox[{"(", 
             RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], "-", 
           "0.721"}], "]"}]}]}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"nPeriod", "*", "nDat"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", "%", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.753785022328125*^9, 3.753785087265625*^9}, {
   3.753785216609375*^9, 3.753785450046875*^9}, {3.753785678140625*^9, 
   3.753785678546875*^9}, 3.753787023875*^9, {3.75378797178125*^9, 
   3.753788035578125*^9}, {3.753788112015625*^9, 3.753788283828125*^9}, 
   3.75378833*^9, {3.75378852821875*^9, 3.753788537140625*^9}, {
   3.75378987846875*^9, 3.7537898958125*^9}, {3.75379257775*^9, 
   3.753792578765625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej1", "[", 
    RowBox[{"{", 
     RowBox[{"data_", ",", "nAv_Integer"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "filtrovanaData", ",", "dvojiceBodu", ",", "pla", ",", "plb", ",", 
       "plaa", ",", "plbb"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"filtrovanaData", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{"data", ",", "nAv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pla", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"data", ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"PointSize", "[", "0.009", "]"}]}], "}"}]}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"plaa", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"data", ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}]}], "}"}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"plb", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"filtrovanaData", ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"PointSize", "[", "0.009", "]"}]}], "}"}]}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"plbb", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"filtrovanaData", ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}]}], "}"}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"pla", ",", "plaa", ",", "plb", ",", "plbb", ",", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\< \!\(\*
StyleBox[\"orig\",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"filtered\",
FontColor->RGBColor[0, 0, 1]]\) \>\""}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydej1", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "20"}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753785022328125*^9, 3.753785087265625*^9}, {
   3.753785216609375*^9, 3.753785450046875*^9}, {3.75378554871875*^9, 
   3.753785563453125*^9}, {3.753785604265625*^9, 3.753785682375*^9}, {
   3.7537857295*^9, 3.75378575296875*^9}, {3.753786949640625*^9, 
   3.75378699584375*^9}, {3.753787036890625*^9, 3.753787122453125*^9}, {
   3.753787167765625*^9, 3.753787190296875*^9}, {3.75378724265625*^9, 
   3.753787375703125*^9}, {3.753787437578125*^9, 3.7537874756875*^9}, 
   3.75378761190625*^9, {3.753787651125*^9, 3.75378795403125*^9}, 
   3.753788021546875*^9, 3.753788074765625*^9, {3.753788361640625*^9, 
   3.753788477078125*^9}, {3.753788582140625*^9, 3.753788598078125*^9}, {
   3.75378864075*^9, 3.7537886505*^9}, {3.7537887400625*^9, 
   3.753788763078125*^9}, 3.753788928828125*^9, 3.75378964371875*^9, {
   3.7537897263125*^9, 3.753789759765625*^9}, {3.75395543309375*^9, 
   3.75395543321875*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], PointSize[0.009], PointBox[CompressedData["
1:eJxV1QlQlGUYB/CVUNO44hYIdjmXY2GX3VXC0fdvpGmgqYN5MaaElqLiMIiK
hJIiR6QyjFhExKiIliAhMirEpwjqFmISFJYZV4pmcot4djwPTu3Mzs7O7n7f
+/6f3/9dRWTM/JVGMpks8+/nP68jj6qjQcUL/DtFa09efIBjrfjQJizkYGUv
v28SAydc6y+NHxJzV/+huai8IQbrTprmbh/izztFmmxRstWBfmGvej38keK2
qG3Hksyv7vL374n45jyD/lqnqJ1vSDXs7xWrJg0VXM5o498PiPY+96rNTm3i
8e4NK/fl3xdzi9xSwyra+HrDIi6py9RV2yF039mFrCh8JBzk29ZZ9f7O138q
skp3Lmwt7BIVO97Za/u2DLZvGmyOxHfx/UYhZUXHofKyDtGo0G5LvGaELytV
k88rW/j+xsgzDo/KfFIn7klj1rdHjMY0uxOLdzmX8nrGQH20dnb12hxp/LKf
I2a2jsWi/sLY2XsvS7S+cThD+Umej4tDS94dj+2Un0TrfQk9lJ/0Wm5ysPUt
E/RTfhKt3wycn7QsaIF3whpzXKL8JNqPBeIoP2lKtLVJz30LcH4S7e9lcH5S
aHDSCweDLDGP8pNov5aIofykxeO6Hi5IsIKc8pNo/9bYT/lJ77XM63uxyhr2
lJ9EedhgJ+UnbSyqvF35xAbllJ9E+diilPKTdsR7tK0Xdkim/DgvO1w68m9+
Imv6nhZFsj2mUn483wk4yf6+sB6+0lQzAYnsj/J0wIi/4o7Ii6nGjiP5sQdH
pLK/yrL66uAZTjjP/ihvp5H8hCF5YsWfqa9gDfuj/J1xk/39NLeguMDgjDD2
R/NwQTz76zNPaTw6Wg539kfzkeMj9pcw9OqcHYflMGN/NC85Mtif7Ld7hog3
FKhlfzQ/Bc6yv7QLB6dP7FIgmP3RPF2x+TD5MytZdM483RVy9kfzdcVx9pez
z3TKbW83cH953m7oZX9OH9ScqvnW7bk/mr870tnfoahNurxodzSwP/Lg/tyf
T5hf6UYTD0SzP/LhgQH2V6Zt832r2AML2R958cAm9hfkmFOknOOJseyP/Hhi
C/s7axTqZtTtCSv2R568kMj+Ztx5lv/LHi/Usz/y5YVT7K/harnDSbUSx9gf
eVNiZhH5Cz+9Omf3VSUq+v7rzxuF7O96gbPl+7He2Mr+yKM3utlfZNoPH0+z
8sEw+yOfPshlf3di0sY5lvugg/2RV18ksb8NC6ekDIT7YgP7I7+++JH9PZja
J2sY9EUo+yPPfohif0meRYlFOX6wZX/k2w957G+MWcSD7ZNUcGB/5F2FdPaX
OWgRt6RFhUb2R/79cY79Wf9a163d4o8qW/JHffBHAeUn5dYmRJs6BMCJ/VE/
ApDP/lyPBdy6eSYACeyP+qLGXfbXNCtW06pSw+gC+aP+qJHD/j75Jqw7LEmN
JvZHfVIji/0t1XgVn25QI4b9Ub/UaGZ/LoWjoj1dNFCzP+qbBrHsr93+ujI7
RoMnLuSP+qfBVvZ3OLPi5jNJM9JfifqoQRz7Wy3LOrTWIhDV7I/6GYgT7E8V
Fx15bXkgSig/7msglrO/nlvT5TO+DsQN9kf9DcTn7K98qfxG2Sjtc3/UZy0e
sL9NVx5+5jJfCxnlJ6jfWuxjf5NDmhdnHtBikP1R37XYxv6eVhy3G+7TYu3/
/n91uM7+anwymleG6EbyE3Qe6DCb/aXkR2U3Zutgwv7ofNBhFfubZSnmiU4d
jNkfnRd6fMr+THZNMD+m06OE/dH5oUcV+/t+uL/ePkUPX/ZH54ke9iXkL3td
Q0ZKsx5PKT/pL3/mO+A=
     "]]}, 
   {GrayLevel[0], Thickness[0.002], LineBox[CompressedData["
1:eJxV1QlQlGUYB/CVUNO44hYIdjmXY2GX3VXC0fdvpGmgqYN5MaaElqLiMIiK
hJIiR6QyjFhExKiIliAhMirEpwjqFmISFJYZV4pmcot4djwPTu3Mzs7O7n7f
+/6f3/9dRWTM/JVGMpks8+/nP68jj6qjQcUL/DtFa09efIBjrfjQJizkYGUv
v28SAydc6y+NHxJzV/+huai8IQbrTprmbh/izztFmmxRstWBfmGvej38keK2
qG3Hksyv7vL374n45jyD/lqnqJ1vSDXs7xWrJg0VXM5o498PiPY+96rNTm3i
8e4NK/fl3xdzi9xSwyra+HrDIi6py9RV2yF039mFrCh8JBzk29ZZ9f7O138q
skp3Lmwt7BIVO97Za/u2DLZvGmyOxHfx/UYhZUXHofKyDtGo0G5LvGaELytV
k88rW/j+xsgzDo/KfFIn7klj1rdHjMY0uxOLdzmX8nrGQH20dnb12hxp/LKf
I2a2jsWi/sLY2XsvS7S+cThD+Umej4tDS94dj+2Un0TrfQk9lJ/0Wm5ysPUt
E/RTfhKt3wycn7QsaIF3whpzXKL8JNqPBeIoP2lKtLVJz30LcH4S7e9lcH5S
aHDSCweDLDGP8pNov5aIofykxeO6Hi5IsIKc8pNo/9bYT/lJ77XM63uxyhr2
lJ9EedhgJ+UnbSyqvF35xAbllJ9E+diilPKTdsR7tK0Xdkim/DgvO1w68m9+
Imv6nhZFsj2mUn483wk4yf6+sB6+0lQzAYnsj/J0wIi/4o7Ii6nGjiP5sQdH
pLK/yrL66uAZTjjP/ihvp5H8hCF5YsWfqa9gDfuj/J1xk/39NLeguMDgjDD2
R/NwQTz76zNPaTw6Wg539kfzkeMj9pcw9OqcHYflMGN/NC85Mtif7Ld7hog3
FKhlfzQ/Bc6yv7QLB6dP7FIgmP3RPF2x+TD5MytZdM483RVy9kfzdcVx9pez
z3TKbW83cH953m7oZX9OH9ScqvnW7bk/mr870tnfoahNurxodzSwP/Lg/tyf
T5hf6UYTD0SzP/LhgQH2V6Zt832r2AML2R958cAm9hfkmFOknOOJseyP/Hhi
C/s7axTqZtTtCSv2R568kMj+Ztx5lv/LHi/Usz/y5YVT7K/harnDSbUSx9gf
eVNiZhH5Cz+9Omf3VSUq+v7rzxuF7O96gbPl+7He2Mr+yKM3utlfZNoPH0+z
8sEw+yOfPshlf3di0sY5lvugg/2RV18ksb8NC6ekDIT7YgP7I7+++JH9PZja
J2sY9EUo+yPPfohif0meRYlFOX6wZX/k2w957G+MWcSD7ZNUcGB/5F2FdPaX
OWgRt6RFhUb2R/79cY79Wf9a163d4o8qW/JHffBHAeUn5dYmRJs6BMCJ/VE/
ApDP/lyPBdy6eSYACeyP+qLGXfbXNCtW06pSw+gC+aP+qJHD/j75Jqw7LEmN
JvZHfVIji/0t1XgVn25QI4b9Ub/UaGZ/LoWjoj1dNFCzP+qbBrHsr93+ujI7
RoMnLuSP+qfBVvZ3OLPi5jNJM9JfifqoQRz7Wy3LOrTWIhDV7I/6GYgT7E8V
Fx15bXkgSig/7msglrO/nlvT5TO+DsQN9kf9DcTn7K98qfxG2Sjtc3/UZy0e
sL9NVx5+5jJfCxnlJ6jfWuxjf5NDmhdnHtBikP1R37XYxv6eVhy3G+7TYu3/
/n91uM7+anwymleG6EbyE3Qe6DCb/aXkR2U3Zutgwv7ofNBhFfubZSnmiU4d
jNkfnRd6fMr+THZNMD+m06OE/dH5oUcV+/t+uL/ePkUPX/ZH54ke9iXkL3td
Q0ZKsx5PKT/pL3/mO+A=
     "]]}, 
   {RGBColor[0, 0, 1], PointSize[0.009], PointBox[CompressedData["
1:eJw91Gk4lWkYwPFjm3TZ9xPZ9+NYzjmukpbnLslOtFAZjFJZUoQQStJJUUlo
GKZUDCEK2fJmL5XKHBMloROaFIlEi2mu93l9eK772/Phf/3uW9N3v5ufII1G
i/r5/p90r+eetgMzqNxjXFQ9lY/MvpU4lO6cQ9U2Qv0xyUPINiveUn7kG+Kd
cOapCfSjIIsthtEB8yi856BL9n0eWhMoLz7xmQZbX42nfWhtQ86WcUJXLAQB
FHrLbdcXI6/Fo3NbooXAS2t6/Y+sy8SBHtdJ0Xph4Ha3NFsdriFCC+re1n0X
gXona62pxmbiWITuYDBaBBG23H06WR3EOeuzPZrxolDR2uH64dkTIld+9jGv
aTHcu+6tOV3KI4pe+7ZzhcUghx4V4C3bS1TdfNhguUEcNuWlKWyj9RMd8cuq
3nMloP30TPKB0EHi+cZLJZfuS4LrUMGTyoDXxEepxK5CEWlQPf+kbfJPPnF4
ZoVzQr40BFiPDd1gviGEXn2472kjA64uYi3rfd4Q3LYr1stGZcCX/shos/Mb
QqLUo1EqSRYqyH5EerrE6reGclBL9iNUYpuqmzrk4AXZj7i665D5H4HyEE32
IxiOzLJwcQXwJfsRFZxBI5cSBQgl+xEWKhkFBs6KoEX2Q42CDtqC44rgT/ZD
tv/O5744qwRFZD/U+bRCudKMDoFkP+Re459x5ikdSsl+qO+Smuze0CXQRPZD
u07+nbJWThkukv3Q6P6Ti1UqlMGJ7IfC3FcnTm1WgRayH5pZM0nrnFah+qGj
egUxBRlLQZnsh36R9PxydLkq1Q+lTEuHbe9RBReyH5J/2TrOiVKj+qGsluhA
CWV1qh/SLDYdGa5VhzvYX7ddKGvAWAP6sb+LdxzHHeM0IBb782Tpl9R0akAA
9qd+TSBQT10TkrC/IXqfQdp+TRDF/vKTq4bnCU3Yif0F0lKvBklrQTH2xwwL
9O310YID2N/EiLXGhnItKMP+KnZo9N8U0IZm7C/y8Vy2ups2ZGJ/q6y6tyXn
aYM99jdfdUNpdlIbmrC/Jsapbj8rHXDG/ri5u9K60nSAjv3ZySJXxNcBf+xP
8sQSqWJzXXDC/rpmPz2kJ+ou+Evf13kqsVsXqrE/j8G/bCd19YCg/G1J+MU7
Qg/42N/AvV9bHrTpQQL2l7fK4piFkj5EYH9+ZbJwbY8+XMb+GDrvv8tU64M8
9jeW2V4XJ2oA+7C/crG8qHceBlCG/YUdiVnuUWgAodifxaet0y2zBlQ/NLeb
dYtlb0j1Qw3PxUJyswwhHfs75jxsIvbOkOqHrJvujh1ayaD6IdFl2UX80wyq
H3pUGL7XtY9B9UNnVTfqNTCNIBD7c0tl8BmxRlQ/pCgikpf5yGjBX2/kK29h
NSbVD+WO1aiGBDPhLvbn43PhxcsGJrzF/nR4wb/bSxnDCexvxMbO/ba3MURj
f0V12go6ZcaQh/0Fm/7oOkczAT3sj32l59z3jSYQj/19VrzlHHDZBGqxv5pT
KeLPPprAQewv5seeDqt1ptT+EhC67mTZeVNqfwnh4aUbVF+bwgXsj1/8VaB1
iRnYYX+tw6M+X9eawV3sr0DjH4IVYAZO2F/S9ma1vefNQBH7C7hQFptba7Zw
/xw7c/p4Qz//w/5MRE+vFBNjgRf2J70uMmsthwU3sb/Jw36zh3awoB7741W6
eZQmsGAA+6scR7f511lwBPvLMDRWVOGxYDf2F7lTOdz1Gws2Y3/bcxbxuDps
iMP+Vj2bYjc4sqEc+1OTGUqdCmMDD/ujOTyeYOSw4Qz2N3S83uW3VjZUY3/N
DYWlme/Z0IH9XfuSIdGpwIFs7I/LPh4kvIazcP/8g0IeWO7mQCP255DvxQg5
wwEX7I854JBUUMUBJexPUnnF6Mt+zsL9m9ikZyO/yBwcsL+nKXL59qbmVD9U
0U4TiXc3p/qh/wCEzrKA
     "]]}, 
   {GrayLevel[0], Thickness[0.002], LineBox[CompressedData["
1:eJw91Gk4lWkYwPFjm3TZ9xPZ9+NYzjmukpbnLslOtFAZjFJZUoQQStJJUUlo
GKZUDCEK2fJmL5XKHBMloROaFIlEi2mu93l9eK772/Phf/3uW9N3v5ufII1G
i/r5/p90r+eetgMzqNxjXFQ9lY/MvpU4lO6cQ9U2Qv0xyUPINiveUn7kG+Kd
cOapCfSjIIsthtEB8yi856BL9n0eWhMoLz7xmQZbX42nfWhtQ86WcUJXLAQB
FHrLbdcXI6/Fo3NbooXAS2t6/Y+sy8SBHtdJ0Xph4Ha3NFsdriFCC+re1n0X
gXona62pxmbiWITuYDBaBBG23H06WR3EOeuzPZrxolDR2uH64dkTIld+9jGv
aTHcu+6tOV3KI4pe+7ZzhcUghx4V4C3bS1TdfNhguUEcNuWlKWyj9RMd8cuq
3nMloP30TPKB0EHi+cZLJZfuS4LrUMGTyoDXxEepxK5CEWlQPf+kbfJPPnF4
ZoVzQr40BFiPDd1gviGEXn2472kjA64uYi3rfd4Q3LYr1stGZcCX/shos/Mb
QqLUo1EqSRYqyH5EerrE6reGclBL9iNUYpuqmzrk4AXZj7i665D5H4HyEE32
IxiOzLJwcQXwJfsRFZxBI5cSBQgl+xEWKhkFBs6KoEX2Q42CDtqC44rgT/ZD
tv/O5744qwRFZD/U+bRCudKMDoFkP+Re459x5ikdSsl+qO+Smuze0CXQRPZD
u07+nbJWThkukv3Q6P6Ti1UqlMGJ7IfC3FcnTm1WgRayH5pZM0nrnFah+qGj
egUxBRlLQZnsh36R9PxydLkq1Q+lTEuHbe9RBReyH5J/2TrOiVKj+qGsluhA
CWV1qh/SLDYdGa5VhzvYX7ddKGvAWAP6sb+LdxzHHeM0IBb782Tpl9R0akAA
9qd+TSBQT10TkrC/IXqfQdp+TRDF/vKTq4bnCU3Yif0F0lKvBklrQTH2xwwL
9O310YID2N/EiLXGhnItKMP+KnZo9N8U0IZm7C/y8Vy2ups2ZGJ/q6y6tyXn
aYM99jdfdUNpdlIbmrC/Jsapbj8rHXDG/ri5u9K60nSAjv3ZySJXxNcBf+xP
8sQSqWJzXXDC/rpmPz2kJ+ou+Evf13kqsVsXqrE/j8G/bCd19YCg/G1J+MU7
Qg/42N/AvV9bHrTpQQL2l7fK4piFkj5EYH9+ZbJwbY8+XMb+GDrvv8tU64M8
9jeW2V4XJ2oA+7C/crG8qHceBlCG/YUdiVnuUWgAodifxaet0y2zBlQ/NLeb
dYtlb0j1Qw3PxUJyswwhHfs75jxsIvbOkOqHrJvujh1ayaD6IdFl2UX80wyq
H3pUGL7XtY9B9UNnVTfqNTCNIBD7c0tl8BmxRlQ/pCgikpf5yGjBX2/kK29h
NSbVD+WO1aiGBDPhLvbn43PhxcsGJrzF/nR4wb/bSxnDCexvxMbO/ba3MURj
f0V12go6ZcaQh/0Fm/7oOkczAT3sj32l59z3jSYQj/19VrzlHHDZBGqxv5pT
KeLPPprAQewv5seeDqt1ptT+EhC67mTZeVNqfwnh4aUbVF+bwgXsj1/8VaB1
iRnYYX+tw6M+X9eawV3sr0DjH4IVYAZO2F/S9ma1vefNQBH7C7hQFptba7Zw
/xw7c/p4Qz//w/5MRE+vFBNjgRf2J70uMmsthwU3sb/Jw36zh3awoB7741W6
eZQmsGAA+6scR7f511lwBPvLMDRWVOGxYDf2F7lTOdz1Gws2Y3/bcxbxuDps
iMP+Vj2bYjc4sqEc+1OTGUqdCmMDD/ujOTyeYOSw4Qz2N3S83uW3VjZUY3/N
DYWlme/Z0IH9XfuSIdGpwIFs7I/LPh4kvIazcP/8g0IeWO7mQCP255DvxQg5
wwEX7I854JBUUMUBJexPUnnF6Mt+zsL9m9ikZyO/yBwcsL+nKXL59qbmVD9U
0U4TiXc3p/qh/wCEzrKA
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotLabel->FormBox[
   "\" \\!\\(\\*\\nStyleBox[\\\"orig\\\",\\nFontColor->RGBColor[1, 0, 0]]\\) \
\\!\\(\\*\\nStyleBox[\\\"filtered\\\",\\nFontColor->RGBColor[0, 0, 1]]\\) \"",
     TraditionalForm],
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{{3.75395541753125*^9, 3.753955433484375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej2", "[", 
    RowBox[{"{", 
     RowBox[{"data_", ",", "nAv_Integer"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "filtrovanaData", ",", "dvojiceBodu", ",", "testPruchodu", ",", 
       "casyPruchoduch", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"filtrovanaData", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{"data", ",", "nAv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dvojiceBodu", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{"filtrovanaData", ",", "2", ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"testPruchodu", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t1_", ",", "u1_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t2_", ",", "u2_"}], "}"}]}], "}"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"u1", "*", "u2"}], "\[LessEqual]", "0"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"casyPruchoduch", "=", 
       RowBox[{"t", "/.", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Fit", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}], 
               "\[Equal]", "0"}], ",", "t"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Select", "[", 
           RowBox[{"dvojiceBodu", ",", "testPruchodu"}], "]"}]}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"2", "Pi"}], "-", 
       RowBox[{"Mean", "@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Partition", "[", 
           RowBox[{"casyPruchoduch", ",", "3", ",", "1"}], "]"}], "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t1_Real", ",", "_", ",", "t3_"}], "}"}], 
           "\[RuleDelayed]", 
           RowBox[{"t3", "-", "t1"}]}]}], ")"}]}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydej2", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "8"}], "}"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753788942*^9, 3.753789089953125*^9}, {
  3.753789221296875*^9, 3.75378932046875*^9}, {3.75378939053125*^9, 
  3.753789391296875*^9}, {3.753789495375*^9, 3.753789618796875*^9}, {
  3.7537896649375*^9, 3.753789711171875*^9}, {3.753789744578125*^9, 
  3.7537897669375*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.7539554191875*^9, 3.753955443796875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej3", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej3", "[", 
    RowBox[{"{", 
     RowBox[{"data_", ",", "nAv_Integer"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "filtrovanaData", ",", "dvojiceBodu", ",", "testPruchodu", ",", 
       "casyPruchoduch", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"filtrovanaData", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{"data", ",", "nAv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dvojiceBodu", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{"filtrovanaData", ",", "2", ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"testPruchodu", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t1_", ",", "u1_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t2_", ",", "u2_"}], "}"}]}], "}"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"u1", "*", "u2"}], "\[LessEqual]", "0"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"casyPruchoduch", "=", 
       RowBox[{"t", "/.", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Fit", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}], 
               "\[Equal]", "0"}], ",", "t"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Select", "[", 
           RowBox[{"dvojiceBodu", ",", "testPruchodu"}], "]"}]}], 
         ")"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydej3", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "1"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.75379060115625*^9, 3.75379068540625*^9}, {
  3.753791353890625*^9, 3.753791367296875*^9}, {3.753791739984375*^9, 
  3.753791746890625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.786899372830354`", ",", "5.928492026420151`", ",", "9.070084680009943`", 
   ",", "12.21167733359974`", ",", "15.353269987189526`", ",", 
   "18.494862640779324`", ",", "21.636455294369103`"}], "}"}]], "Output",
 CellChangeTimes->{3.75395541921875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejRozdily", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejRozdily", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"nPer_", ",", "nDat1Perioda_", ",", "SR_Integer"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"k3_", ",", "k5_", ",", "k7_"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV1_Integer", ",", "nAV2_Integer"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]t", ",", "data", ",", "pl", ",", "rn", ",", "fi3", ",", 
       "fi5", ",", "fi7", ",", "casy1", ",", "casy2", ",", "odNPi"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       RowBox[{
        FractionBox["2.", "nDat1Perioda"], "*", "Pi"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rn", ":=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SeedRandom", "[", "SR", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"fi3", ",", "fi5", ",", "fi7"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{"rn", ",", "rn", ",", "rn"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], 
              "+", "0.6"}], "]"}], "+", 
            RowBox[{"k3", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"3", "*", 
                RowBox[{"(", 
                 RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], 
               "+", "fi3"}], "]"}]}], "+", 
            RowBox[{"k5", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"5", "*", 
                RowBox[{"(", 
                 RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], 
               "+", "fi5"}], "]"}]}], "+", 
            RowBox[{"k7", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"7", "*", 
                RowBox[{"(", 
                 RowBox[{"#", "-", "1"}], ")"}], "*", "\[CapitalDelta]t"}], 
               "+", "fi7"}], "]"}]}]}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"nPer", "*", "nDat1Perioda"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"casy1", "=", 
       RowBox[{"vydej3", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "nAV1"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"casy2", "=", 
       RowBox[{"vydej3", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "nAV2"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"odNPi", "[", "listCasuch_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "n", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"n", "=", 
           RowBox[{"Length", "[", "listCasuch", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Mean", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", "*", "Pi"}], "-", 
               RowBox[{"listCasuch", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], ")"}], "&"}], "/@", 
            RowBox[{"Range", "[", "n", "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"odNPi", "[", "casy2", "]"}], "-", 
       RowBox[{"odNPi", "[", "casy1", "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejRozdily", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4.5", ",", "400", ",", "5"}], "}"}], ",", 
      RowBox[{".3", "*", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", "0.2", ",", "0.1"}], "}"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "200"}], "}"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.75379069265625*^9, 3.753790722890625*^9}, {
   3.75379076384375*^9, 3.753790842265625*^9}, {3.753790892703125*^9, 
   3.753791214078125*^9}, {3.7537912864375*^9, 3.753791395328125*^9}, 
   3.753791430296875*^9, {3.753791460375*^9, 3.753791485484375*^9}, {
   3.7537915243125*^9, 3.75379172434375*^9}, {3.753791783375*^9, 
   3.753791896015625*^9}, {3.753791963421875*^9, 3.75379198971875*^9}, {
   3.753792124359375*^9, 3.75379242796875*^9}, {3.7537926158125*^9, 
   3.75379270171875*^9}, {3.7537927390625*^9, 3.753792750984375*^9}}],

Cell[BoxData[
 RowBox[{"-", "0.11312378256122935`"}]], "Output",
 CellChangeTimes->{3.753955419328125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataV1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"vydejRozdily", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4.5", ",", "400", ",", "5"}], "}"}], ",", 
            RowBox[{"1", "*", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "0.0", ",", "0.0"}], "}"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "#"}], "}"}]}], "}"}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "300", ",", "5"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataV2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"vydejRozdily", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4.5", ",", "400", ",", "5"}], "}"}], ",", 
            RowBox[{"k", "*", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "0.0", ",", "0.0"}], "}"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "#"}], "}"}]}], "}"}], "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "300", ",", "5"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"dataV1", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "shift_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"nAV", ",", 
        RowBox[{"k", "*", "shift"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dataV2", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.753792858296875*^9, 3.75379305203125*^9}, {
  3.753793274625*^9, 3.753793415984375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxV0HtIU3EUB/BrYkZhL6gMJCaYWlnN0Aqb+lVXkqTNfGSGbr5fU6eZQg+7
pq1SKw1TcyyvZWWizNesnLqZmimBRfYQcg4kekAh1NDSpOIe/+gHl8uHw/d3
zu/Yx2YeSVjCMIzo7/fvz59pb+a/YwsmQsc17nDU83YEM5Jjntf4kYVg4rWq
UaswsjsYjb8/uzWW7AF2fcE1L2c52RtMgIN0m1MO2RdMnqp8l+w0b1YMdsZB
FGouoLo/OJsP760nlFQ/CNPrqZDerFKqHwLnrg7MlZZTPQirp43W0Z8qyBII
54PHjePVvA3BkFj6Wfh4qCkfAuxn1w1Y1/FGKIRT4Yevau5QPgy2Exv2tVTe
o3w4JGKHmaX6B5SPgKJh/kKuSzPlj8FteNndaXkL5SPB9uua8+PaKH8czgMv
Vp3P7aB8FCKqZ2vsb3dSPhriELdnxZOPKC+F6a1dUICzjrdMhude17Rl2T2U
j0H8JlHFdq2eNxcDw63aOtfvBrovFuJiC1vjQh9vUyxyPA1r/H4+ofvjsHei
febbZD9vQTzyI0s2L2gGaN54jFVFCTcmD1L/BJzdovXKsX5K/RPReMDX99wV
MpcIK6dJtc0vMpLg2tq21jtwiPonoVtp/Jp0kcwm42NoTWD9fbIgBSu0w3NB
GrIhBXmf3wxWqsmyVJyssSwNOEFm0mAucm912knm0pBS4NLW83KxvxyP04Pn
zJFkkxyFezqtRkboPWw67DKjfyvtyYIMlKm+JNZKF9+fAfFu3ZBASfuRZUJy
vakjtYr2xyggPvOqpPQG7VeiwKnRH8uPFtH+OQWYlohun9Fe3tMKjF1ut0y8
1E3zZaGh8GZ2q2cX77IsmOy7uPrZhzRvFkT9peVMn5a3MBusI1Qra9tp/my8
Cxhu4ipb9X8A6c0+KA==
     "]]}, 
   {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJxV0WtIk1EYB/AXP5QW4ZSFiVHTppEUjUIl0/bHSyaV17JV1OZ181KbVmCJ
OUtzEOYQk6lrLqw0L6kIppb65q1Zq6QLLv0yRElKzS+SlrqM9/FDB15efjz8
z3POc9wTlDHJdgzDBKx9//7cmhcz/61tYKI2IbLOt5ezFxiJ69NVzxiyCIw5
tNpSkkj2AXPXz8NoVpH9oR7M/iAfvE4Wg83eNWaR3iIHgZnt6gw3azirQ2AM
bs2acdVSPQxqQ1XpRGwZ1cPByrSBkk0VVD8B9ViTpfCIgeoRUP8Iun1t8SE5
CtaJzRka3mPObDRaQs+UR8rrKB8LmcV9buufBs44hZbyiDovUzPlT8OypUiq
n2qlfBx4usqKFVsb5SXg+Q3cyxe1U/4sjIv7NXZXOyh/DrxV/+fjQ12UPw9m
ss/jsLCb8hegFn+t9ynqpfxFKH66+WKBpbwUCn586VFhH2eZDELxu9wvJ/sp
Hw+2RjLHVw5wNq65KUooLhyk/RJgWs5tbi0e4mxNwN5D/ILlwte0fyJ07ysC
5tJNnAVJsI6bp/SBw3TeJAju96+kLZFlyVAMbTTYG95Q/xSE2Brzxd5vqX8K
NIMbpqv0ZMihde3fJ14gW+VQXClY6jlopv4KqD/yZ/PiyIJUqAKeefOlZDYV
I0G/vtceJ8vSoGt8sWy/g8ykgzXNf7J9Xu+fDp5N7zCcud4/A9nJA9POC3Re
awYE4fWVoVKy+hI6fm+v3dlK9xNchnbOcCN6hubBrnmPk9MxZ7JMiRBTtbJb
SPNjVJiZcjnQ7knzjVJhxK0mOMeF5m9UoexBwmTJMr3XvArGlOb0R6P0nsgE
+0SXd6fhFWdtJizVbJtjDr2/NRM6iSVsd2kPZ1EWRI4327+JXtL5s9CyUuxQ
NtrZ+xf9OUgW
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.75395542371875*^9}]
}, Open  ]]
},
WindowSize->{1107, 639},
WindowMargins->{{13, Automatic}, {Automatic, 6}},
ShowSelection->True,
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 307, 9, 92, "Input"],
Cell[855, 31, 2978, 86, 346, "Input"],
Cell[CellGroupData[{
Cell[3858, 121, 3392, 77, 317, "Input"],
Cell[7253, 200, 8394, 146, 341, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15684, 351, 2723, 71, 317, "Input"],
Cell[18410, 424, 94, 1, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18541, 430, 2123, 57, 267, "Input"],
Cell[20667, 489, 297, 6, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21001, 500, 5121, 135, 597, "Input"],
Cell[26125, 637, 106, 2, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26268, 644, 1978, 59, 117, "Input"],
Cell[28249, 705, 2199, 42, 310, "Output"]
}, Open  ]]
}
]
*)

