(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28412,        753]
NotebookOptionsPosition[     27609,        727]
NotebookOutlinePosition[     28088,        745]
CellTagsIndexPosition[     28045,        742]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "pripravim", " ", "si", " ", "parametry", " ", "testovaciho", " ", 
    "signalu", " ", "a", " ", "nominalni", " ", "parametry"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "=", "50.123"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fNom", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fNom"]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.753785022328125*^9, 3.753785087265625*^9}, {
   3.753785216609375*^9, 3.753785450046875*^9}, {3.753785678140625*^9, 
   3.753785678546875*^9}, 3.753787023875*^9, {3.75378797178125*^9, 
   3.753788035578125*^9}, {3.753788112015625*^9, 3.753788283828125*^9}, 
   3.75378833*^9, {3.75378852821875*^9, 3.753788537140625*^9}, {
   3.75378987846875*^9, 3.7537898958125*^9}, {3.75379257775*^9, 
   3.753792578765625*^9}, {3.7539561194375*^9, 3.753956119765625*^9}, {
   3.754100952671875*^9, 3.754101145453125*^9}, {3.754102072203125*^9, 
   3.754102077765625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Pripravim", " ", "si", " ", "data"}], ",", " ", 
    RowBox[{
    "vzdycky", " ", "nejdriv", " ", "pro", " ", "mensi", " ", "pocet", " ", 
     "bodu"}], ",", " ", 
    RowBox[{"kdyz", " ", "to", " ", "zacne", " ", "chodit"}], ",", " ", 
    RowBox[{"muzu", " ", "pocet", " ", "dat", " ", "zvetsovat"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nDat1Perioda", "=", "200"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"5.5", "Tnom"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     FractionBox["Tnom", 
      RowBox[{"nDat1Perioda", "-", "1."}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "ve", " ", "jmenovateli", " ", "je", " ", "1.", " ", "a", " ", "ne", " ",
       "1"}], ",", " ", 
     RowBox[{
     "tedy", " ", "typ", " ", "Real", " ", "a", " ", "ne", " ", "Integer", 
      " ", "aby", " ", "vyslo", " ", "Real", " ", "a", " ", "ne", " ", 
      "Rational"}], ",", " ", 
     RowBox[{
     "nemam", " ", "rad", " ", "zlomky", " ", "a", " ", "pocitat", " ", "to", 
      " ", "s", " ", "nimi", " ", "pomaleji"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"proc", " ", "nDat1Perioda"}], "-", 
      RowBox[{
       RowBox[{"1", " ", "?", " ", "Jde"}], " ", "o", " ", "to"}]}], ",", " ", 
     RowBox[{"jestli", " ", "chci", " ", "dany", " ", "pocet", " ", "BODU"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"pak", " ", "delim", " ", "n"}], "-", "1"}], ",", " ", 
     RowBox[{"nebo", " ", "dany", " ", "pocet", " ", "useku"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"pak", " ", "delim", " ", "n"}], "..."}], " ", "ve", " ", 
      "vetsine", " ", "pripadu", " ", "by", " ", "to", " ", "melo", " ", 
      "byt", " ", "jedno"}], ",", " ", 
     RowBox[{"jelikoz", " ", "dat", " ", "bude", " ", 
      RowBox[{"hodne", ".", "\[IndentingNewLine]", "Jde"}], " ", "si", " ", 
      "to", " ", 
      RowBox[{"vyzkouset", ":", " ", 
       RowBox[{"Length", "[", 
        RowBox[{"Table", "[", 
         RowBox[{"cokoli", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "Tnom", ",", "\[CapitalDelta]t"}], 
           "}"}]}], "]"}], "]"}]}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "u1", "]"}], ";", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "pro", " ", "zacatek", " ", "neni", " ", "spatne", " ", "zacinat", " ", 
       "deklaraci", " ", "funkce", " ", "vycistenim", " ", "jejiho", " ", 
       "jmena", " ", "kvuli", " ", "tomu"}], ",", " ", 
      RowBox[{"ze", " ", 
       RowBox[{"M", ".", " ", "povoluje"}], " ", "pretezovani", " ", "a", " ",
        "kdyz", " ", "napiseme", " ", 
       RowBox[{"napr", ".", " ", "dve"}], " ", "definice"}], ",", " ", 
      RowBox[{
       RowBox[{"treba", " ", 
        RowBox[{"g", "[", "x", "]"}]}], ":=", 
       RowBox[{
        RowBox[{"x", "  ", 
         RowBox[{"g", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], ":=", 
        RowBox[{"x", "+", "y"}]}]}], ",", " ", 
      RowBox[{"bdou", " ", "v", " ", "pameti", " ", 
       RowBox[{"obe", ".", " ", "Pkud"}], " ", "to", " ", "chceme"}], ",", 
      " ", "ok", ",", " ", 
      RowBox[{
      "ale", " ", "pokud", " ", "jsme", " ", "nejdriv", " ", "chteli", " ", 
       "jedno", " ", "a", " ", "pak", " ", "to", " ", "prepsali", " ", "na", 
       " ", "druhe"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"tak", " ", "v", " ", "pameti", " ", "zustanou", " ", 
         RowBox[{"(", 
          RowBox[{
          "do", " ", "vycisteni", " ", "promennych", " ", "nebo", " ", 
           "vypnuti", " ", "Kernelu"}], ")"}], " ", "definice", " ", "obe", 
         " ", "a", " ", "jedna", " ", "neni", " ", "videt", " ", "atd"}], 
        "..."}], "."}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"u1", "[", "t_", "]"}], ":=", 
     RowBox[{"230.", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"\[Omega]", "*", "t"}], "+", "0.456"}], "]"}]}], "+", 
        RowBox[{"0.2", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "*", "\[Omega]", "*", "t"}], "+", 
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "*", "0.456"}]}], "]"}]}], "+", 
        RowBox[{"0.1", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{
            StyleBox["5",
             FontColor->RGBColor[1, 0, 0]], "*", "\[Omega]", "*", "t"}], "+", 
           RowBox[{
            StyleBox["5",
             FontColor->RGBColor[1, 0, 0]], "*", "0.456"}]}], "]"}]}]}], 
       ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"cisla", " ", "si", " ", "proste", " ", "vymyslime"}], ",", " ", 
     RowBox[{"doporucuju", " ", "vyzkouset", " ", "si"}], ",", " ", 
     RowBox[{"jaks", " ", "se", " ", "to", " ", "chova", " ", 
      RowBox[{"(", 
       RowBox[{"tedy", " ", "jak", " ", "vypada", " ", "graf"}], ")"}]}], ",",
      " ", 
     RowBox[{
     "kdyz", " ", "se", " ", "vyssim", " ", "harmonickym", " ", "meni", " ", 
      "uhel", " ", "taky", " ", "tolikrat", " ", "vic"}], ",", " ", 
     RowBox[{
     "kolikrat", " ", "se", " ", "rychleji", " ", "harmonicka", " ", 
      "toci"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.753785022328125*^9, 3.753785087265625*^9}, {
   3.753785216609375*^9, 3.753785450046875*^9}, {3.753785678140625*^9, 
   3.753785678546875*^9}, 3.753787023875*^9, {3.75378797178125*^9, 
   3.753788035578125*^9}, {3.753788112015625*^9, 3.753788283828125*^9}, 
   3.75378833*^9, {3.75378852821875*^9, 3.753788537140625*^9}, {
   3.75378987846875*^9, 3.7537898958125*^9}, {3.75379257775*^9, 
   3.753792578765625*^9}, {3.7539561194375*^9, 3.753956119765625*^9}, {
   3.754100952671875*^9, 3.7541011176875*^9}, {3.754101173625*^9, 
   3.7541013486875*^9}, {3.754101608609375*^9, 3.754101947*^9}, {
   3.754102130171875*^9, 3.75410219534375*^9}, {3.754102229390625*^9, 
   3.754102256953125*^9}, {3.754102350625*^9, 3.754102377859375*^9}, {
   3.7541025090625*^9, 3.7541026015625*^9}, 3.754126516975692*^9, {
   3.754126577316598*^9, 3.7541265777689986`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"prvni", " ", 
    RowBox[{"zpusob", ":", " ", 
     RowBox[{"pouzijeme", " ", 
      RowBox[{"Table", "[", 
       RowBox[{"co", ",", 
        RowBox[{"{", 
         RowBox[{"jmenoPromenne", ",", "odkud", ",", "kam", ",", "krok"}], 
         "}"}]}], "]"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"u1", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax", ",", "\[CapitalDelta]t"}], 
        "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"na", " ", "data", " ", "se", " ", "vzdycky", " ", 
      RowBox[{"(", 
       RowBox[{"no", ",", " ", 
        RowBox[{"teda", " ", "vzdycky"}], ",", " ", 
        RowBox[{"kdy", " ", "to", " ", "jde"}]}], ")"}], " ", "podivame"}], 
     ",", " ", 
     RowBox[{
     "pripravim", " ", "si", " ", "rovnou", " ", "dva", " ", "ploty"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"data1", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t [s]\>\"", ",", "\"\<u1 [V]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"data1", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t [s]\>\"", ",", "\"\<u1 [V]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Thickness", "[", "0.003", "]"}]}], "}"}]}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plU1", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"pl1", ",", "pl2"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.754101998796875*^9, 3.75410210684375*^9}, {
   3.754102281875*^9, 3.754102341578125*^9}, {3.7541023879375*^9, 
   3.754102480078125*^9}, 3.75410260534375*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"druhy", " ", "zpusob"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "pouziju", " ", "mapovani", " ", "a", " ", "pure", " ", "function", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"g", "/@", 
        RowBox[{"{", 
         RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4"}], "}"}]}], " ", 
       "vrati", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"g", "[", "t1", "]"}], ",", 
         RowBox[{"g", "[", "t2", "]"}], ",", 
         RowBox[{"g", "[", "t3", "]"}], ",", 
         RowBox[{"g", "[", "t4", "]"}]}], "}"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Range", "[", 
        RowBox[{"odkud", ",", "kam", ",", "krok"}], "]"}], " ", "vrati", " ", 
       RowBox[{"{", 
        RowBox[{"odkud", ",", 
         RowBox[{"odkud", "+", "krok"}], ",", " ", 
         RowBox[{"odkud", "+", 
          RowBox[{"2", "*", "krok"}]}], ",", "...", ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"odkud", "+", 
            RowBox[{"k", "*", "krok"}]}], ",", " ", 
           RowBox[{"maximalne", " ", "vsak", " ", "kam"}]}], ")"}]}], "}"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"u1", "[", "#", "]"}]}], "}"}]}], "&"}], " ", "bude", " ", 
     "nase", " ", "funkce", " ", "g"}], ",", " ", 
    RowBox[{
    "tedy", " ", "bere", " ", "si", " ", "za", " ", "#", " ", "cas", " ", "a",
      " ", "vraci", " ", "dvojici", " ", 
     RowBox[{"{", 
      RowBox[{"cas", ",", 
       RowBox[{"u1", "[", "cas", "]"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data2", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"u1", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"hele", ",", " ", 
      RowBox[{"ja", " ", "vim"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
          "ze", " ", "se", " ", "ti", " ", "to", " ", "asi", " ", "nelibi"}], 
          "..."}], " ", "samozrejme", " ", "s", " ", "Table", " ", "a", " ", 
         "pojmenovanymi", " ", "funkcemi", " ", "uplne", " ", "vystacis"}], 
        "..."}], " ", "ale", " ", "ja", " ", "pisu", " ", "kody", " ", 
       "takhle", " ", "a", " ", "jelikoz", " ", "planujeme", " ", 
       "spolupracovat"}], ",", " ", 
      RowBox[{"tak", " ", "to", " ", "prosim", " ", 
       RowBox[{"prekousni", ":", "-"}]}]}], ")"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"data1", "-", "data2"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"to", " ", "jen", " ", "ukazuju"}], ",", " ", 
     RowBox[{"ze", " ", "jsou", " ", "data", " ", "stejna"}]}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.754102613078125*^9, 3.7541026636875*^9}, {
  3.754102695671875*^9, 3.754103038625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vyrobim", " ", "si", " ", "filtrovana", " ", "data"}], ",", " ", 
    RowBox[{
    "nAv", " ", "je", " ", "delka", " ", "postupujiciho", " ", "okna"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nAv", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataFiltered", "=", 
     RowBox[{"MovingAverage", "[", 
      RowBox[{"data1", ",", "nAv"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"na", " ", "data", " ", "se", " ", "podivame"}], ",", " ", 
     RowBox[{"zkopiruju", " ", "ploty", " ", "u1"}], ",", " ", 
     RowBox[{"zmenim", " ", "data", " ", "a", " ", "barvu"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl3", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"dataFiltered", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t [s]\>\"", ",", "\"\<u1 [V]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl4", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"dataFiltered", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t [s]\>\"", ",", "\"\<u1 [V]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"Thickness", "[", "0.003", "]"}]}], "}"}]}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plU1Filtered", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"pl3", ",", "pl4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"kdyz", " ", "napisu", " ", 
      RowBox[{"Show", "[", 
       RowBox[{"pl3", ",", "pl4"}], "]"}], " ", "tak", " ", "se", " ", 
      "rozsah", " ", "grafu", " ", "a", " ", "options", " ", "vubec", " ", 
      "vezmou", " ", "z", " ", "pl3"}], ",", " ", 
     RowBox[{
     "vyzkousej", " ", "si", " ", "kdyz", " ", "to", " ", "otocis", " ", "a", 
      " ", "das", " ", 
      RowBox[{"Show", "[", 
       RowBox[{"pl4", ",", "pl3"}], "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"plU1", ",", "plU1Filtered", ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\< \!\(\*
StyleBox[\"original\",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"filtered\",
FontColor->RGBColor[0, 0, 1]]\)\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"doporucuji", " ", "si", " ", "HRAT"}], ",", " ", 
     RowBox[{"menit", " ", "nAv", " ", "a", " ", "koukat"}], ",", " ", 
     RowBox[{"co", " ", "to", " ", "dela"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.754103070359375*^9, 3.754103435875*^9}, {
  3.7541254716782556`*^9, 3.754125483097476*^9}, {3.7541265297053137`*^9, 
  3.754126534042122*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"zacneme", " ", "s", " ", "pruchody", " ", "nulou"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataPruchody", "=", "dataFiltered"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "vyzkousim", " ", "si", " ", "to", " ", "na", " ", "filtrovanych", " ", 
     "datech"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxU", "=", 
     RowBox[{"Max", "[", 
      RowBox[{"dataPruchody", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_"}], "}"}], "\[RuleDelayed]", "u"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minU", "=", 
     RowBox[{"Min", "[", 
      RowBox[{"dataPruchody", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_"}], "}"}], "\[RuleDelayed]", "u"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"amplituda", "=", 
     RowBox[{"0.5", "*", 
      RowBox[{"(", 
       RowBox[{"maxU", "-", "minU"}], ")"}]}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kKolemNuly", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"testKolemNuly", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_"}], "}"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Abs", "[", "u", "]"}], "\[LessEqual]", 
      RowBox[{"kKolemNuly", "*", "amplituda"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bodyKolemNuly1", "=", 
     RowBox[{"Select", "[", 
      RowBox[{"dataPruchody", ",", "testKolemNuly"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "alternativni", " ", "zapis", " ", "pomocu", " ", "pure", " ", 
     "function"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bodyKolemNuly2", "=", 
     RowBox[{"Select", "[", 
      RowBox[{"dataPruchody", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "\[LessEqual]", 
         RowBox[{"kKolemNuly", "*", "amplituda"}]}], "&"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"jenom", " ", "overeni", " ", "ze", " ", "oba", " ", 
     RowBox[{"zp", "[", 
      RowBox[{"usoby", " ", "davaji", " ", "stejne", " ", "vysledky"}]}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Complement", "[", 
    RowBox[{"bodyKolemNuly1", ",", "bodyKolemNuly2"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7541255297571573`*^9, 3.7541255444991837`*^9}, {
  3.7541257253191013`*^9, 3.7541261314356146`*^9}, {3.7541261740548897`*^9, 
  3.7541261941789246`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "ted", " ", "si", " ", "ty", " ", "body", " ", "seskupime", " ", "podle", 
    " ", "casove", " ", "souradnice"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kVzdalenostVuciPeriode", "=", "0.1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"testGather", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t1_", ",", "u1_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t2_", ",", "u2_"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"t1", "-", "t2"}], "]"}], "<", 
     RowBox[{"kVzdalenostVuciPeriode", "*", "T"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gathered1", "=", 
     RowBox[{"Gather", "[", 
      RowBox[{"bodyKolemNuly1", ",", "testGather"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "opet", " ", "otravuji", " ", "s", " ", "pude", " ", "functions"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gathered2", "=", 
     RowBox[{"Gather", "[", 
      RowBox[{"bodyKolemNuly1", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<", 
         RowBox[{"kVzdalenostVuciPeriode", "*", "T"}]}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Complement", "[", 
    RowBox[{"gathered1", ",", "gathered2"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"opet", " ", "jen", " ", "kontrola"}], ",", " ", 
       RowBox[{"ze", " ", "oba", " ", "zpusoby", " ", "daji", " ", 
        RowBox[{"totez", ":", "-"}]}]}], "]"}], ",", " ", 
     RowBox[{
     "vidime", " ", "ze", " ", "test", " ", "je", " ", "funkce", " ", "dvou", 
      " ", "promennych"}]}], "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7541262071269474`*^9, 3.754126213648759*^9}, {
   3.754126284426083*^9, 3.7541263912238708`*^9}, {3.7541264353407483`*^9, 
   3.754126490393245*^9}, 3.7541266150530643`*^9, {3.754126673958768*^9, 
   3.754126780258354*^9}, {3.7541268166688185`*^9, 3.7541269317658205`*^9}, {
   3.75412696583628*^9, 3.7541269791275034`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"udelam", " ", "si", " ", "funkci"}], ",", " ", 
    RowBox[{
    "ktera", " ", "si", " ", "vezme", " ", "skupinu", " ", "bodu", " ", 
     RowBox[{"(", 
      RowBox[{"tady", " ", "si", " ", "ji", " ", "zkousim", " ", "na", " ", 
       RowBox[{"gathered1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], " ", "a", " ", "udela", " ", 
     "Fit", " ", "a", " ", "najde", " ", "jeho", " ", "prusecik", " ", "s", 
     " ", "nulou"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"najdiPruchod", "[", "prvekGatheredDat_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"fit", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fit", "=", 
         RowBox[{"Fit", "[", 
          RowBox[{"prvekGatheredDat", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"t", "/.", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{"fit", "\[Equal]", "0"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"jakmile", " ", "napisu", " ", "funkci"}], ",", " ", 
     RowBox[{
     "zkusim", " ", "si", " ", "ji", " ", "zavolat", " ", "a", " ", "overim", 
      " ", "si", " ", "jestli", " ", "dela", " ", "to", " ", "co", " ", 
      "ma"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"najdiPruchod", "[", 
    RowBox[{"gathered1", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7541270011547422`*^9, 3.754127203003497*^9}, {
  3.754127719536004*^9, 3.7541277414072423`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ted", " ", "najdu", " ", "vsechny", " ", "pruchody"}], ",", " ", 
    RowBox[{"opet", " ", "dbema", " ", "zpusoby"}], ",", " ", 
    RowBox[{
    "jednak", " ", "pomoc", " ", "Table", " ", "a", " ", "ponoci", " ", 
     "mapovani", " ", 
     RowBox[{"(", 
      RowBox[{"tedy", " ", 
       RowBox[{"pomoc", " ", "/@"}]}], ")"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nGathered", "=", 
     RowBox[{"Length", "[", "gathered1", "]"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "pro", " ", "Table", " ", "potrebuji", " ", "vedet", " ", "kolik", " ", 
     "skupin", " ", "mame"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pruchody1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"najdiPruchod", "[", 
        RowBox[{"gathered1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "nGathered"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"tady", " ", "uvidime", " ", "vyhodu", " ", "mapovani"}], ",", 
     " ", 
     RowBox[{"nepotrebuji", " ", "zkoumat"}], ",", " ", 
     RowBox[{
     "kolik", " ", "skupin", " ", "v", " ", "gathered1", " ", "je"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pruchody2", "=", 
     RowBox[{"najdiPruchod", "/@", "gathered1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Complement", "[", 
    RowBox[{"pruchody1", ",", "pruchody2"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"opet", " ", "jen", " ", "vidime"}], ",", " ", 
     RowBox[{"ze", " ", "to", " ", "dopadlo", " ", "stejne"}]}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.75412721623232*^9, 3.7541274577363443`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "protoze", " ", "perioda", " ", "je", " ", "vzdalenost", " ", "pruchodu", 
     " ", "ob", " ", "jeden"}], ",", " ", 
    RowBox[{
     RowBox[{
     "tak", " ", "si", " ", "udelam", " ", "trojice", " ", "a", " ", "pro", 
      " ", "delku", " ", "vezmu", " ", "cas", " ", "treti"}], "-", "prvni"}], 
    ",", " ", 
    RowBox[{"ctvrty", "-", 
     RowBox[{"druhy", " ", 
      RowBox[{"atd", "."}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"trojicePruchodu", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{"pruchody1", ",", "3", ",", "1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"periody", "=", 
     RowBox[{"trojicePruchodu", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t1_", ",", "_", ",", "t3_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"t3", "-", "t1"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "a", " ", "jako", " ", "vyslednou", " ", "periodu", " ", "vezmu", " ", 
     "jejich", " ", "prumer"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tvysl", "=", 
     RowBox[{"Mean", "[", "periody", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<perioda= \>\"", ",", "Tvysl", ",", "\"\< chyba= \>\"", ",", 
     RowBox[{"100", "*", 
      FractionBox[
       RowBox[{"T", "-", "Tvysl"}], "T"]}], ",", "\"\< %\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7541274687655635`*^9, 3.7541277012059717`*^9}}]
},
WindowSize->{1107, 639},
WindowMargins->{{13, Automatic}, {Automatic, 6}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 307, 9, 106, "Input"],
Cell[855, 31, 1270, 29, 250, "Input"],
Cell[2128, 62, 6530, 152, 926, "Input"],
Cell[8661, 216, 2349, 64, 280, "Input"],
Cell[11013, 282, 3226, 83, 599, "Input"],
Cell[14242, 367, 3079, 77, 425, "Input"],
Cell[17324, 446, 2689, 74, 454, "Input"],
Cell[20016, 522, 2364, 61, 396, "Input"],
Cell[22383, 585, 1836, 45, 309, "Input"],
Cell[24222, 632, 1831, 50, 338, "Input"],
Cell[26056, 684, 1549, 41, 278, "Input"]
}
]
*)

