(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     57768,       1462]
NotebookOptionsPosition[     56692,       1429]
NotebookOutlinePosition[     57072,       1445]
CellTagsIndexPosition[     57029,       1442]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"aKrychle", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mm", "=", 
   RowBox[{"0.1", "cm"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.72250085221875*^9, 3.722500854609375*^9}, {
  3.722506449765625*^9, 3.722506451484375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dataElipsoidLS", "[", 
    RowBox[{"elipsoid", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"stred", ":", 
        RowBox[{"{", 
         RowBox[{"xs_", ",", "ys_", ",", "zs_"}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], 
      "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "m1", ",", "m2", ",", "m3", ",", "xx", ",", "yy", ",", "zz", ",", 
       "parametrizace", ",", "vect", ",", "aa", ",", "bb", ",", "cc", ",", 
       "dd", ",", "ee", ",", "ff", ",", "rce", ",", "rceVys", ",", "line", 
       ",", "rhs", ",", "mat"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"m1", "=", 
       RowBox[{"(", GridBox[{
          {"1.", "0.", "0."},
          {"0.", 
           RowBox[{"Cos", "[", "\[Alpha]", "]"}], 
           RowBox[{"Sin", "[", "\[Alpha]", "]"}]},
          {"0.", 
           RowBox[{"-", 
            RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], 
           RowBox[{"Cos", "[", "\[Alpha]", "]"}]}
         }], ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"m2", "=", 
       RowBox[{"(", GridBox[{
          {
           RowBox[{"Cos", "[", "\[Beta]", "]"}], "0.", 
           RowBox[{"-", 
            RowBox[{"Sin", "[", "\[Beta]", "]"}]}]},
          {"0.", "1.", "0."},
          {
           RowBox[{"Sin", "[", "\[Beta]", "]"}], "0", 
           RowBox[{"Cos", "[", "\[Beta]", "]"}]}
         }], ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"m3", "=", 
       RowBox[{"(", GridBox[{
          {
           RowBox[{"Cos", "[", "\[Gamma]", "]"}], 
           RowBox[{"Sin", "[", "\[Gamma]", "]"}], "0."},
          {
           RowBox[{"-", 
            RowBox[{"Sin", "[", "\[Gamma]", "]"}]}], 
           RowBox[{"Cos", "[", "\[Gamma]", "]"}], "0."},
          {"0.", "0.", "1."}
         }], ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xx", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"a", "*", 
        RowBox[{"Cos", "[", "t", "]"}], "*", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"yy", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", "t", "]"}], "*", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zz", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"c", "*", 
        RowBox[{"Cos", "[", "u", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vect", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"xx", "[", 
          RowBox[{"t", ",", "u"}], "]"}], ",", 
         RowBox[{"yy", "[", 
          RowBox[{"t", ",", "u"}], "]"}], ",", 
         RowBox[{"zz", "[", 
          RowBox[{"t", ",", "u"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"parametrizace", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"m1", ".", "m2", ".", "m3", ".", 
        RowBox[{"vect", "[", 
         RowBox[{"t", ",", "u"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"line", "[", 
        RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
           RowBox[{"parametrizace", "[", 
            RowBox[{"t", ",", "u"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SuperscriptBox["x", "2"], ",", 
            SuperscriptBox["y", "2"], ",", 
            SuperscriptBox["z", "2"], ",", 
            RowBox[{"x", "*", "y"}], ",", 
            RowBox[{"x", "*", "z"}], ",", 
            RowBox[{"y", "*", "z"}]}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mat", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"line", "[", 
          RowBox[{
           RowBox[{"Random", "[", "]"}], ",", 
           RowBox[{"Random", "[", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "6", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rhs", "=", 
       RowBox[{
        RowBox[{"1.", "&"}], "/@", 
        RowBox[{"Range", "[", "6", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rceVys", "=", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee", ",", "ff"}], 
            "}"}], "=", 
           RowBox[{"Quiet", "@", 
            RowBox[{"LinearSolve", "[", 
             RowBox[{"mat", ",", "rhs"}], "]"}]}]}], ")"}], ".", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["x", "2"], ",", 
           SuperscriptBox["y", "2"], ",", 
           SuperscriptBox["z", "2"], ",", 
           RowBox[{"x", "*", "y"}], ",", 
           RowBox[{"x", "*", "z"}], ",", 
           RowBox[{"y", "*", "z"}]}], "}"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"elipsoid", ",", 
        RowBox[{"{", 
         RowBox[{"rceVys", ",", 
          RowBox[{"rceVys", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "\[Rule]", 
              RowBox[{"x", "-", "xs"}]}], ",", 
             RowBox[{"y", "\[Rule]", 
              RowBox[{"y", "-", "ys"}]}], ",", 
             RowBox[{"z", "\[Rule]", 
              RowBox[{"z", "-", "zs"}]}]}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
           "aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee", ",", "ff"}], 
           "}"}]}], "}"}], ",", 
        RowBox[{
         FractionBox[
          RowBox[{"4.", "Pi"}], "3"], "*", "a", "*", "b", "*", "c"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"dataElipsoidLS", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.3", ",", 
        RowBox[{"-", "1.5"}], ",", 
        RowBox[{"-", "0.69"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.722242562546875*^9, 3.722242623953125*^9}, {
   3.72224265840625*^9, 3.722242681515625*^9}, {3.722246536*^9, 
   3.722246627109375*^9}, {3.7222466809375*^9, 3.7222466918125*^9}, {
   3.72224706821875*^9, 3.72224710609375*^9}, {3.72224719353125*^9, 
   3.722247197234375*^9}, {3.7222473044375*^9, 3.7222475075625*^9}, {
   3.7222480235625*^9, 3.72224810609375*^9}, {3.72224851625*^9, 
   3.722248609015625*^9}, {3.722248684640625*^9, 3.722248713125*^9}, {
   3.722248778765625*^9, 3.72224887509375*^9}, {3.7222490004375*^9, 
   3.722249091390625*^9}, {3.722249255*^9, 3.72224926840625*^9}, {
   3.7224984485*^9, 3.72249862465625*^9}, {3.72249866028125*^9, 
   3.72249868340625*^9}, {3.72249871815625*^9, 3.7224988134375*^9}, {
   3.722498858078125*^9, 3.7224989761875*^9}, {3.722499957640625*^9, 
   3.722499989265625*^9}, {3.722503020796875*^9, 3.722503027234375*^9}, {
   3.72250305959375*^9, 3.722503097421875*^9}, 3.7225045940625*^9, {
   3.722700889625*^9, 3.72270089425*^9}, {3.72330249334375*^9, 
   3.72330249734375*^9}, 3.7236504824375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"elipsoidTrial", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"0.25", "Pi"}], ",", 
        RowBox[{"0.33", "Pi"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.723302351671875*^9, 3.72330241521875*^9}, {
   3.723302770421875*^9, 3.7233027871875*^9}, 3.723309893234375*^9, 
   3.72365062690625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "vseOElipsoidu", ",", "x", ",", "y", ",", "psi", ",", "a", ",", "b", ",", 
    "vyr", ",", "axx", ",", "axy", ",", "ax", ",", "ay", ",", "a00"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vseOElipsoidu", "[", 
    RowBox[{"\[Xi]z_", ",", "elipsoid_", ",", "hue_", ",", "listIndexuch_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dataElipsoid", ",", "rceVys", ",", "rceVysStred", ",", "aa", ",", "bb",
        ",", "cc", ",", "dd", ",", "ee", ",", "ff", ",", "ObjemElipsoidu", 
       ",", "elipsoidInt", ",", "rvs", ",", "xvect", ",", "dx", ",", "a0", 
       ",", "b0", ",", "c0", ",", "rce", ",", "sol", ",", "proPlot", ",", 
       "pla", ",", "plb", ",", "xs", ",", "ys", ",", "vyr", ",", "p1", ",", 
       "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", "p7", ",", "p8",
        ",", "p9", ",", "p10", ",", "dosAcka", ",", "xss", ",", "yss", ",", 
       "vyrStred", ",", "primka", ",", 
       RowBox[{"mm", "=", "0.001"}], ",", "plot", ",", "prusecikSPrimkou", 
       ",", "delkaPrusecikuch", ",", "delkaPrimek"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataElipsoid", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"elipsoidInt", ",", 
          RowBox[{"{", 
           RowBox[{"rceVys", ",", "rceVysStred", ",", 
            RowBox[{"{", 
             RowBox[{
             "aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee", ",", "ff"}], 
             "}"}]}], "}"}], ",", "ObjemElipsoidu"}], "}"}], "=", 
        RowBox[{"dataElipsoidLS", "[", "elipsoid", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a0", ",", "b0", ",", "c0"}], "}"}], "=", 
       RowBox[{"dataElipsoid", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rvs", "=", 
       RowBox[{"rceVysStred", "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"\[Xi]z", "*", "aKrychle"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vyr", "[", 
        RowBox[{"xx_", ",", "yy_"}], "]"}], ":=", 
       RowBox[{"rvs", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "\[Rule]", "xx"}], ",", 
          RowBox[{"y", "\[Rule]", "yy"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p1", "=", 
       RowBox[{"vyr", "[", 
        RowBox[{"0", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p2", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p3", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p4", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"1", ",", "1"}], "]"}], "-", "p1", "-", "p2", "-", "p3"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"p5", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p6", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p3", "+", "p5"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p7", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p8", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p7", "+", "p2"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p9", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p3", "-", "p5"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p10", "=", 
       RowBox[{
        RowBox[{"-", "0.5"}], "*", 
        RowBox[{"(", 
         RowBox[{"p7", "-", "p2"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dosAcka", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a00", "\[Rule]", "p1"}], ",", 
         RowBox[{"axy", "\[Rule]", "p4"}], ",", 
         RowBox[{"axx", "\[Rule]", "p6"}], ",", 
         RowBox[{"ayy", "\[Rule]", "p8"}], ",", 
         RowBox[{"ax", "\[Rule]", "p9"}], ",", 
         RowBox[{"ay", "\[Rule]", "p10"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xss", ",", "yss"}], "}"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "/.", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{
                 RowBox[{"-", "axy"}], " ", "ay"}], "+", 
                RowBox[{"2", " ", "ax", " ", "ayy"}]}], 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["axy", "2"]}], "+", 
                RowBox[{"4", " ", "axx", " ", "ayy"}]}]]}]}], ",", 
            RowBox[{"y", "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{"ax", " ", "axy"}], "-", 
                RowBox[{"2", " ", "axx", " ", "ay"}]}], 
               RowBox[{
                SuperscriptBox["axy", "2"], "-", 
                RowBox[{"4", " ", "axx", " ", "ayy"}]}]]}]}]}], "}"}], "/.", 
          "dosAcka"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vyrStred", "=", 
       RowBox[{"vyr", "[", 
        RowBox[{"xss", ",", "yss"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xvect", "[", 
        RowBox[{"psi_", ",", "t_"}], "]"}], ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", GridBox[{
            {
             RowBox[{"Cos", "[", "psi", "]"}], 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "psi", "]"}]}]},
            {
             RowBox[{"Sin", "[", "psi", "]"}], 
             RowBox[{"Cos", "[", "psi", "]"}]}
           }], ")"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"Cos", "[", "t", "]"}]}], ",", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}]}], "+", 
        RowBox[{"{", 
         RowBox[{"xss", ",", "yss"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dx", "[", 
        RowBox[{"psi_", ",", "t_"}], "]"}], ":=", 
       RowBox[{"Thread", "[", 
        RowBox[{"Rule", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{"xvect", "[", 
           RowBox[{"psi", ",", "t"}], "]"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rce", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"0", "==", 
           RowBox[{"(", 
            RowBox[{"rvs", "/.", 
             RowBox[{"dx", "[", 
              RowBox[{"psi", ",", 
               RowBox[{"Random", "[", "]"}]}], "]"}]}], ")"}]}], "&"}], "/@", 
         RowBox[{"Range", "[", "3", "]"}]}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"plot", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"vyrStred", "<", "0"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"sol", "=", 
           RowBox[{"Quiet", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{"rce", ",", 
              RowBox[{"{", 
               RowBox[{"psi", ",", 
                RowBox[{"0.65", "Pi"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", 
                RowBox[{"0.5", "a0"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"b", ",", 
                RowBox[{"0.5", "b0"}]}], "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"proPlot", "=", 
           RowBox[{
            RowBox[{"xvect", "[", 
             RowBox[{"psi", ",", "t"}], "]"}], "/.", "sol"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"pla", "=", 
           RowBox[{"ParametricPlot", "[", 
            RowBox[{"proPlot", ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "0.", ",", 
               RowBox[{"2.", "Pi"}]}], "}"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Hue", "[", "hue", "]"}], ",", 
                RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Show", "[", 
           RowBox[{"pla", ",", 
            RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ",", "Null"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"prusecikSPrimkou", "[", "i_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "diskriminant", ",", "t1", ",", "t2", ",", "akv", ",", "bkv", ",", 
           "ckv"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"akv", ",", "bkv", ",", "ckv"}], "}"}], "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"axx", ",", 
              RowBox[{"ax", "+", 
               RowBox[{"axy", " ", "i", " ", "mm"}]}], ",", 
              RowBox[{"a00", "+", 
               RowBox[{"ay", " ", "i", " ", "mm"}], "+", 
               RowBox[{"ayy", " ", 
                SuperscriptBox["i", "2"], " ", 
                SuperscriptBox["mm", "2"]}]}]}], "}"}], "/.", "dosAcka"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"diskriminant", "=", 
           RowBox[{
            SuperscriptBox["bkv", "2"], "-", 
            RowBox[{"4.", "*", "akv", "*", "ckv"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t1", ",", "t2"}], "}"}], "=", 
           RowBox[{"{", 
            RowBox[{
             FractionBox[
              RowBox[{
               RowBox[{"-", "bkv"}], "-", 
               SqrtBox["diskriminant"]}], 
              RowBox[{"2.", "akv"}]], ",", 
             FractionBox[
              RowBox[{
               RowBox[{"-", "bkv"}], "+", 
               SqrtBox["diskriminant"]}], 
              RowBox[{"2.", "akv"}]]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"diskriminant", "\[GreaterEqual]", "0"}], ",", 
            RowBox[{"Abs", "[", 
             RowBox[{"t2", "-", "t1"}], "]"}], ",", "0."}], "]"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"delkaPrusecikuch", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"prusecikSPrimkou", "/@", "listIndexuch"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"delkaPrimek", "=", 
       RowBox[{
        RowBox[{"Length", "[", "listIndexuch", "]"}], "*", "aKrychle"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"plot", ",", 
        RowBox[{"{", 
         RowBox[{"delkaPrusecikuch", ",", "delkaPrimek"}], "}"}], ",", 
        "ObjemElipsoidu", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vyrStred", "<", "0"}], ",", 
          RowBox[{
           RowBox[{"1.", "*", "Pi", "*", 
            RowBox[{"Abs", "[", "a", "]"}], "*", 
            RowBox[{"Abs", "[", "b", "]"}]}], "/.", "sol"}], ",", "0."}], 
         "]"}]}], "}"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poma", "=", 
   RowBox[{
    RowBox[{"vseOElipsoidu", "[", 
     RowBox[{"13.5", ",", "elipsoidTrial", ",", "0.6", ",", 
      RowBox[{"Range", "[", "100", "]"}]}], "]"}], "//", "Timing"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.723302820328125*^9, 3.723303085046875*^9}, {
   3.7233031195625*^9, 3.72330316853125*^9}, {3.723303238515625*^9, 
   3.723303252015625*^9}, {3.723305139578125*^9, 3.723305212625*^9}, {
   3.7233052836875*^9, 3.723305289625*^9}, {3.72330531978125*^9, 
   3.7233053268125*^9}, {3.72330712675*^9, 3.7233071273125*^9}, {
   3.72330765725*^9, 3.723307711015625*^9}, {3.723307808640625*^9, 
   3.72330783396875*^9}, {3.723307874015625*^9, 3.7233081760625*^9}, {
   3.723308210484375*^9, 3.723308288515625*^9}, {3.723308356453125*^9, 
   3.723308390953125*^9}, {3.723308433890625*^9, 3.723308577375*^9}, 
   3.723308649296875*^9, {3.723308703140625*^9, 3.723308706109375*^9}, {
   3.72330891021875*^9, 3.72330893215625*^9}, {3.72330953153125*^9, 
   3.72330968171875*^9}, {3.723309743765625*^9, 3.723309856609375*^9}, 
   3.723309905484375*^9, {3.723310085390625*^9, 3.723310091703125*^9}, {
   3.72363774896875*^9, 3.723637757375*^9}, {3.72363779775*^9, 
   3.72363783584375*^9}, {3.723637995171875*^9, 3.7236380255*^9}, {
   3.7236380918125*^9, 3.723638121015625*^9}, {3.72363958509375*^9, 
   3.723639748359375*^9}, {3.723639815859375*^9, 3.72363991534375*^9}, {
   3.723639956609375*^9, 3.723639971015625*^9}, {3.723640021078125*^9, 
   3.723640063921875*^9}, {3.723640118453125*^9, 3.723640148515625*^9}, {
   3.7236401978125*^9, 3.723640237359375*^9}, {3.7236402869375*^9, 
   3.723640295125*^9}, {3.72364041165625*^9, 3.723640412109375*^9}, {
   3.723640645515625*^9, 3.72364064921875*^9}, {3.72364073165625*^9, 
   3.72364074015625*^9}, {3.723640770765625*^9, 3.723640792515625*^9}, {
   3.72364188775*^9, 3.723641895125*^9}, {3.723641927390625*^9, 
   3.723641931421875*^9}, 3.723641968078125*^9, {3.723644576515625*^9, 
   3.723644627484375*^9}, {3.7236446749375*^9, 3.723644675421875*^9}, {
   3.723644720453125*^9, 3.723644737671875*^9}, {3.72364477275*^9, 
   3.7236447979375*^9}, 3.723644839828125*^9, {3.723644884046875*^9, 
   3.723645042875*^9}, {3.723645084265625*^9, 3.7236451225*^9}, 
   3.72364534421875*^9, {3.723645558*^9, 3.723645590625*^9}, {
   3.723645666328125*^9, 3.72364569503125*^9}, {3.723645849*^9, 
   3.72364586753125*^9}, {3.72364742378125*^9, 3.72364770284375*^9}, {
   3.723647775765625*^9, 3.723647781859375*^9}, {3.723647865296875*^9, 
   3.723648003546875*^9}, {3.723648296328125*^9, 3.723648300109375*^9}, {
   3.723648399625*^9, 3.723648412765625*^9}, {3.723648553359375*^9, 
   3.72364864828125*^9}, {3.72364872921875*^9, 3.723648772734375*^9}, {
   3.723648813671875*^9, 3.723648885609375*^9}, 3.723650164796875*^9, {
   3.723650245578125*^9, 3.72365025715625*^9}, {3.72370176215625*^9, 
   3.72370176765625*^9}, {3.7237018306875*^9, 3.72370185290625*^9}, {
   3.7237019150625*^9, 3.723701950984375*^9}, {3.72370198478125*^9, 
   3.723702027796875*^9}, {3.723702059734375*^9, 3.723702081484375*^9}, {
   3.723702118609375*^9, 3.72370217425*^9}, {3.723702396609375*^9, 
   3.723702479171875*^9}, {3.72370252184375*^9, 3.723702532609375*^9}, {
   3.723703650640625*^9, 3.723703650875*^9}, 3.72370380575*^9, {
   3.723704040515625*^9, 3.723704067078125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "jenDelky", ",", "x", ",", "y", ",", "psi", ",", "a", ",", "b", ",", "vyr",
     ",", "axx", ",", "axy", ",", "ax", ",", "ay", ",", "a00"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"jenDelky", "[", 
    RowBox[{"\[Xi]z_", ",", "elipsoid_", ",", "listIndexuch_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dataElipsoid", ",", "rceVys", ",", "rceVysStred", ",", "aa", ",", "bb",
        ",", "cc", ",", "dd", ",", "ee", ",", "ff", ",", "ObjemElipsoidu", 
       ",", "elipsoidInt", ",", "rvs", ",", "rce", ",", "xs", ",", "ys", ",", 
       "vyr", ",", "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", 
       "p6", ",", "p7", ",", "p8", ",", "p9", ",", "p10", ",", "dosAcka", ",", 
       RowBox[{"mm", "=", "0.001"}], ",", "plot", ",", "prusecikSPrimkou", 
       ",", "delkaPrusecikuch", ",", "delkaPrimek"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataElipsoid", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"elipsoidInt", ",", 
          RowBox[{"{", 
           RowBox[{"rceVys", ",", "rceVysStred", ",", 
            RowBox[{"{", 
             RowBox[{
             "aa", ",", "bb", ",", "cc", ",", "dd", ",", "ee", ",", "ff"}], 
             "}"}]}], "}"}], ",", "ObjemElipsoidu"}], "}"}], "=", 
        RowBox[{"dataElipsoidLS", "[", "elipsoid", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rvs", "=", 
       RowBox[{"rceVysStred", "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"\[Xi]z", "*", "aKrychle"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vyr", "[", 
        RowBox[{"xx_", ",", "yy_"}], "]"}], ":=", 
       RowBox[{"rvs", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "\[Rule]", "xx"}], ",", 
          RowBox[{"y", "\[Rule]", "yy"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p1", "=", 
       RowBox[{"vyr", "[", 
        RowBox[{"0", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p2", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p3", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p4", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"1", ",", "1"}], "]"}], "-", "p1", "-", "p2", "-", "p3"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"p5", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p6", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p3", "+", "p5"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p7", "=", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "]"}], "-", "p1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p8", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p7", "+", "p2"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p9", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"p3", "-", "p5"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p10", "=", 
       RowBox[{
        RowBox[{"-", "0.5"}], "*", 
        RowBox[{"(", 
         RowBox[{"p7", "-", "p2"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dosAcka", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a00", "\[Rule]", "p1"}], ",", 
         RowBox[{"axy", "\[Rule]", "p4"}], ",", 
         RowBox[{"axx", "\[Rule]", "p6"}], ",", 
         RowBox[{"ayy", "\[Rule]", "p8"}], ",", 
         RowBox[{"ax", "\[Rule]", "p9"}], ",", 
         RowBox[{"ay", "\[Rule]", "p10"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"prusecikSPrimkou", "[", "i_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "diskriminant", ",", "t1", ",", "t2", ",", "akv", ",", "bkv", ",", 
           "ckv"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"akv", ",", "bkv", ",", "ckv"}], "}"}], "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"axx", ",", 
              RowBox[{"ax", "+", 
               RowBox[{"axy", " ", "i", " ", "mm"}]}], ",", 
              RowBox[{"a00", "+", 
               RowBox[{"ay", " ", "i", " ", "mm"}], "+", 
               RowBox[{"ayy", " ", 
                SuperscriptBox["i", "2"], " ", 
                SuperscriptBox["mm", "2"]}]}]}], "}"}], "/.", "dosAcka"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"diskriminant", "=", 
           RowBox[{
            SuperscriptBox["bkv", "2"], "-", 
            RowBox[{"4.", "*", "akv", "*", "ckv"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t1", ",", "t2"}], "}"}], "=", 
           RowBox[{"{", 
            RowBox[{
             FractionBox[
              RowBox[{
               RowBox[{"-", "bkv"}], "-", 
               SqrtBox["diskriminant"]}], 
              RowBox[{"2.", "akv"}]], ",", 
             FractionBox[
              RowBox[{
               RowBox[{"-", "bkv"}], "+", 
               SqrtBox["diskriminant"]}], 
              RowBox[{"2.", "akv"}]]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"diskriminant", "\[GreaterEqual]", "0"}], ",", 
            RowBox[{"Abs", "[", 
             RowBox[{"t2", "-", "t1"}], "]"}], ",", "0."}], "]"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"delkaPrusecikuch", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"prusecikSPrimkou", "/@", "listIndexuch"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"delkaPrimek", "=", 
       RowBox[{
        RowBox[{"Length", "[", "listIndexuch", "]"}], "*", "aKrychle"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"delkaPrusecikuch", ",", "delkaPrimek"}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poma", "=", 
   RowBox[{
    RowBox[{"jenDelky", "[", 
     RowBox[{"13.5", ",", "elipsoidTrial", ",", 
      RowBox[{"Range", "[", "100", "]"}]}], "]"}], "//", "Timing"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.723302820328125*^9, 3.723303085046875*^9}, {
   3.7233031195625*^9, 3.72330316853125*^9}, {3.723303238515625*^9, 
   3.723303252015625*^9}, {3.723305139578125*^9, 3.723305212625*^9}, {
   3.7233052836875*^9, 3.723305289625*^9}, {3.72330531978125*^9, 
   3.7233053268125*^9}, {3.72330712675*^9, 3.7233071273125*^9}, {
   3.72330765725*^9, 3.723307711015625*^9}, {3.723307808640625*^9, 
   3.72330783396875*^9}, {3.723307874015625*^9, 3.7233081760625*^9}, {
   3.723308210484375*^9, 3.723308288515625*^9}, {3.723308356453125*^9, 
   3.723308390953125*^9}, {3.723308433890625*^9, 3.723308577375*^9}, 
   3.723308649296875*^9, {3.723308703140625*^9, 3.723308706109375*^9}, {
   3.72330891021875*^9, 3.72330893215625*^9}, {3.72330953153125*^9, 
   3.72330968171875*^9}, {3.723309743765625*^9, 3.723309856609375*^9}, 
   3.723309905484375*^9, {3.723310085390625*^9, 3.723310091703125*^9}, {
   3.72363774896875*^9, 3.723637757375*^9}, {3.72363779775*^9, 
   3.72363783584375*^9}, {3.723637995171875*^9, 3.7236380255*^9}, {
   3.7236380918125*^9, 3.723638121015625*^9}, {3.72363958509375*^9, 
   3.723639748359375*^9}, {3.723639815859375*^9, 3.72363991534375*^9}, {
   3.723639956609375*^9, 3.723639971015625*^9}, {3.723640021078125*^9, 
   3.723640063921875*^9}, {3.723640118453125*^9, 3.723640148515625*^9}, {
   3.7236401978125*^9, 3.723640237359375*^9}, {3.7236402869375*^9, 
   3.723640295125*^9}, {3.72364041165625*^9, 3.723640412109375*^9}, {
   3.723640645515625*^9, 3.72364064921875*^9}, {3.72364073165625*^9, 
   3.72364074015625*^9}, {3.723640770765625*^9, 3.723640792515625*^9}, {
   3.72364188775*^9, 3.723641895125*^9}, {3.723641927390625*^9, 
   3.723641931421875*^9}, 3.723641968078125*^9, {3.723644576515625*^9, 
   3.723644627484375*^9}, {3.7236446749375*^9, 3.723644675421875*^9}, {
   3.723644720453125*^9, 3.723644737671875*^9}, {3.72364477275*^9, 
   3.7236447979375*^9}, 3.723644839828125*^9, {3.723644884046875*^9, 
   3.723645042875*^9}, {3.723645084265625*^9, 3.7236451225*^9}, 
   3.72364534421875*^9, {3.723645558*^9, 3.723645590625*^9}, {
   3.723645666328125*^9, 3.72364569503125*^9}, {3.723645849*^9, 
   3.72364586753125*^9}, {3.72364742378125*^9, 3.72364770284375*^9}, {
   3.723647775765625*^9, 3.723647781859375*^9}, {3.723647865296875*^9, 
   3.723648003546875*^9}, {3.723648296328125*^9, 3.723648300109375*^9}, {
   3.723648399625*^9, 3.723648412765625*^9}, {3.723648553359375*^9, 
   3.72364864828125*^9}, {3.72364872921875*^9, 3.723648772734375*^9}, {
   3.723648813671875*^9, 3.723648885609375*^9}, 3.723650164796875*^9, {
   3.723650245578125*^9, 3.72365025715625*^9}, {3.72370176215625*^9, 
   3.72370176765625*^9}, {3.7237018306875*^9, 3.72370185290625*^9}, {
   3.7237019150625*^9, 3.723701950984375*^9}, {3.72370198478125*^9, 
   3.723702027796875*^9}, {3.723702059734375*^9, 3.723702081484375*^9}, {
   3.723702118609375*^9, 3.72370217425*^9}, {3.723702396609375*^9, 
   3.723702479171875*^9}, {3.72370252184375*^9, 3.72370261609375*^9}, {
   3.723702691578125*^9, 3.72370272996875*^9}, {3.723702764421875*^9, 
   3.72370283728125*^9}, {3.7237029271875*^9, 3.72370292815625*^9}, {
   3.723703106046875*^9, 3.723703111453125*^9}, 3.723703811171875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nDeleni", "=", "17"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]x", "=", 
    FractionBox["aKrychle", 
     RowBox[{"nDeleni", "+", "1"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rTypicky", "=", 
   RowBox[{"0.2", "*", "\[CapitalDelta]x"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnSouradnice", ":=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "*", "rTypicky"}], ",", 
      RowBox[{"k", "*", "rTypicky"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rnPoloosa", ":=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"k", "*", "rTypicky"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnabc", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["10",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox["*",
       FontColor->RGBColor[1, 0, 0]], "rnPoloosa"}], "&"}], "/@", 
    RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnUhel", ":=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "Pi"}], ",", 
      RowBox[{"0.5", "Pi"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn\[Alpha]\[Beta]\[Gamma]", ":=", 
   RowBox[{
    RowBox[{"rnUhel", "&"}], "/@", 
    RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stredy", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "+", "rnSouradnice"}], ",", 
          RowBox[{"y", "+", "rnSouradnice"}], ",", 
          RowBox[{"z", "+", "rnSouradnice"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "\[CapitalDelta]x", ",", 
          RowBox[{"aKrychle", "-", "\[CapitalDelta]x"}], ",", 
          "\[CapitalDelta]x"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "\[CapitalDelta]x", ",", 
          RowBox[{"aKrychle", "-", "\[CapitalDelta]x"}], ",", 
          "\[CapitalDelta]x"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "\[CapitalDelta]x", ",", 
          RowBox[{"aKrychle", "-", "\[CapitalDelta]x"}], ",", 
          "\[CapitalDelta]x"}], "}"}]}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.722499767609375*^9, {3.722499807875*^9, 3.72249984346875*^9}, 
   3.72250004740625*^9, {3.72250013575*^9, 3.7225002111875*^9}, 
   3.72250025703125*^9, {3.722500858546875*^9, 3.722500859828125*^9}, {
   3.72250283834375*^9, 3.72250286778125*^9}, {3.72250290690625*^9, 
   3.722502961453125*^9}, {3.722506657*^9, 3.722506693875*^9}, {
   3.72257813553125*^9, 3.72257813703125*^9}, 3.723301373578125*^9, {
   3.7236510010625*^9, 3.7236510045625*^9}, {3.72365108353125*^9, 
   3.723651148421875*^9}, 3.7236512395*^9, 3.723651678078125*^9, {
   3.72370366975*^9, 3.72370373625*^9}, {3.723703778203125*^9, 
   3.7237037805*^9}, 3.723703828265625*^9, 3.723703911765625*^9, {
   3.72370425928125*^9, 3.7237042595625*^9}, {3.7239672181875*^9, 
   3.723967218515625*^9}, 3.72396759290625*^9, {3.7239686609375*^9, 
   3.72396868521875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "prusecik", " ", "elipsoidu", " ", "s", " ", "rovinou", " ", "z"}], "=", 
    RowBox[{
     RowBox[{"konst", ".", " ", "a"}], " ", "primkou", " ", "v", " ", 
     "ni"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "3", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nmax", "=", 
     RowBox[{"Length", "[", "stredy", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"elipsoid1", "[", "i_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"stredy", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "rnabc", ",", 
       "rn\[Alpha]\[Beta]\[Gamma]"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"elipsoidy", "=", 
     RowBox[{"elipsoid1", "/@", 
      RowBox[{"Range", "[", "nmax", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eltry", "=", 
     RowBox[{"elipsoidy", "[", 
      RowBox[{"[", "150", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]zTry", "=", "0.45"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.722500803953125*^9, 3.72250083490625*^9}, {
   3.7225008683125*^9, 3.722500989578125*^9}, {3.722501044765625*^9, 
   3.72250108659375*^9}, {3.722501154203125*^9, 3.722501169421875*^9}, {
   3.72250122303125*^9, 3.7225012234375*^9}, {3.72250152278125*^9, 
   3.722501668390625*^9}, {3.7225017115*^9, 3.72250174071875*^9}, {
   3.722502439890625*^9, 3.72250245334375*^9}, {3.72250250521875*^9, 
   3.72250261728125*^9}, {3.72250266190625*^9, 3.722502664890625*^9}, {
   3.7225027225*^9, 3.72250276921875*^9}, 3.722503119171875*^9, {
   3.722503360921875*^9, 3.722503380921875*^9}, {3.72250424459375*^9, 
   3.72250428521875*^9}, {3.722504321203125*^9, 3.72250437978125*^9}, {
   3.7225044263125*^9, 3.72250453625*^9}, {3.722504631984375*^9, 
   3.722504635953125*^9}, {3.72250466703125*^9, 3.722504715234375*^9}, {
   3.722504761734375*^9, 3.72250493709375*^9}, {3.7225050109375*^9, 
   3.722505029859375*^9}, {3.722505287421875*^9, 3.722505290890625*^9}, {
   3.72250533659375*^9, 3.7225055255*^9}, {3.72250576634375*^9, 
   3.722505821890625*^9}, {3.722506363453125*^9, 3.722506419234375*^9}, {
   3.722506462015625*^9, 3.722506480625*^9}, {3.72250652409375*^9, 
   3.72250653821875*^9}, {3.722506599015625*^9, 3.722506626140625*^9}, {
   3.722506724421875*^9, 3.722506724890625*^9}, {3.7225782261875*^9, 
   3.722578226265625*^9}, 3.72257852834375*^9, 3.7225885965625*^9, {
   3.7236480946875*^9, 3.72364809796875*^9}, {3.723651279296875*^9, 
   3.7236513023125*^9}, 3.723651341484375*^9, {3.72365141109375*^9, 
   3.723651425484375*^9}, {3.72365166175*^9, 3.72365166203125*^9}, {
   3.72365551509375*^9, 3.723655515578125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zpracuj", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpracuj", "[", 
    RowBox[{"\[Xi]z_", ",", "listIndexuch_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"test", ",", "podezrele", ",", "nElMax", ",", "vysledky"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"test", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xs_", ",", "ys_", ",", "zs_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], 
         "}"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"zs", "-", 
          RowBox[{"aKrychle", "*", "\[Xi]z"}]}], "]"}], "<", 
        RowBox[{"0.5", "*", "\[CapitalDelta]x"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"podezrele", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"Select", "[", 
         RowBox[{"elipsoidy", ",", "test"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nElMax", "=", 
       RowBox[{"Length", "[", "podezrele", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<podezrelych elipsoidu geft: \>\"", ",", "nElMax"}], "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"vysledky", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"vseOElipsoidu", "[", 
          RowBox[{"\[Xi]z", ",", "#", ",", 
           RowBox[{"Random", "[", "]"}], ",", "listIndexuch"}], "]"}], "&"}], 
        "/@", "podezrele"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"\[Xi]zTry", "=", "0.59"}], ";"}],
  FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{
    RowBox[{"zpracuj", "[", 
     RowBox[{"\[Xi]zTry", ",", 
      RowBox[{"Range", "[", "100", "]"}]}], "]"}], "//", "Timing"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<trvalo to \>\"", ",", 
   RowBox[{"pom", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.7236518301875*^9, 3.72365191984375*^9}, {
   3.723651957421875*^9, 3.723652078390625*^9}, {3.723652128375*^9, 
   3.723652150640625*^9}, {3.723652190859375*^9, 3.723652194*^9}, {
   3.723703158734375*^9, 3.723703293640625*^9}, {3.72370333740625*^9, 
   3.723703377890625*^9}, {3.723703522875*^9, 3.723703526921875*^9}, 
   3.72370375996875*^9, {3.723704193828125*^9, 3.723704213140625*^9}, {
   3.72370498775*^9, 3.7237050228125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vysledky", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rezy", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"First", "/@", "vysledky"}], ",", "Null"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "aKrychle"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "aKrychle"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Frame", "\[Rule]", "Automatic"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.723703407640625*^9, 3.723703433609375*^9}, {
   3.723703474453125*^9, 3.723703502890625*^9}, {3.72370355146875*^9, 
   3.72370362621875*^9}, {3.723703704359375*^9, 3.72370370596875*^9}, {
   3.723703845765625*^9, 3.72370390178125*^9}, 3.7239666633125*^9, {
   3.7239670640625*^9, 3.72396708628125*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<vysgraf.png\>\"", ",", "rezy", ",", 
    RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{
  3.723966645375*^9, {3.723967155171875*^9, 3.72396715884375*^9}, 
   3.72396719940625*^9, 3.72396842896875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listIndexuch1", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"1", ",", "99", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listIndexuch2", "=", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "12", ",", "18", ",", "24", ",", "34", ",", "40", ",", "46", 
     ",", "52", ",", "76", ",", "82", ",", "88", ",", "94"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"primka", "[", "i_", "]"}], ":=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"i", "*", "mm"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"aKrychle", ",", 
         RowBox[{"i", "*", "mm"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plPrimky", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"primka", "/@", "listIndexuch2"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "aKrychle"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "aKrychle"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"Frame", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dohr", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plPrimky", ",", "rezy"}], "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<vysgrafS.png\>\"", ",", "dohr", ",", 
     RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.72396666715625*^9, 3.72396669396875*^9}, {
   3.7239667479375*^9, 3.723966887375*^9}, {3.72396692990625*^9, 
   3.72396695028125*^9}, {3.7239669836875*^9, 3.723966997828125*^9}, {
   3.723967046296875*^9, 3.72396705725*^9}, {3.72396708925*^9, 
   3.723967095609375*^9}, {3.7239671661875*^9, 3.72396719359375*^9}, 
   3.723968421765625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"celkovyObjemPoru", "=", 
    RowBox[{
     FractionBox["4.", "3"], "*", "Pi", "*", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"elipsoidy", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xs_", ",", "ys_", ",", "zs_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}],
           "}"}], "\[RuleDelayed]", 
         RowBox[{"a", "*", "b", "*", "c"}]}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"provitostSkutecna", "=", 
   RowBox[{"100", 
    FractionBox["celkovyObjemPoru", 
     SuperscriptBox["aKrychle", "3"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<porovitost skutecna= \>\"", ",", "provitostSkutecna", ",", 
   "\"\< %\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.7239684844375*^9, 3.723968598*^9}, {3.723968703875*^9, 
  3.723968789109375*^9}, {3.723970032046875*^9, 3.723970034625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zpracujJenDelky", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpracujJenDelky", "[", 
    RowBox[{"\[Xi]z_", ",", "listIndexuch_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"test", ",", "podezrele", ",", "nElMax", ",", "vysledky"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"test", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xs_", ",", "ys_", ",", "zs_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], 
         "}"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"zs", "-", 
          RowBox[{"aKrychle", "*", "\[Xi]z"}]}], "]"}], "<", 
        RowBox[{"0.5", "*", "\[CapitalDelta]x"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"podezrele", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"Select", "[", 
         RowBox[{"elipsoidy", ",", "test"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nElMax", "=", 
       RowBox[{"Length", "[", "podezrele", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<podezrelych elipsoidu geft: \>\"", ",", "nElMax"}], 
         "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"vysledky", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"jenDelky", "[", 
          RowBox[{"\[Xi]z", ",", "#", ",", "listIndexuch"}], "]"}], "&"}], "/@",
         "podezrele"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{
    RowBox[{"zpracujJenDelky", "[", 
     RowBox[{"\[Xi]zTry", ",", 
      RowBox[{"Range", "[", "100", "]"}]}], "]"}], "//", "Timing"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.723968827296875*^9, 3.72396883575*^9}, {
   3.7239689225625*^9, 3.723968966640625*^9}, {3.723969025734375*^9, 
   3.723969027546875*^9}, 3.72396907528125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zpVysledky", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpVysledky", "[", "listDvojic_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"delkyPresPory", ",", "delkyCelkem"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"delkyPresPory", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"First", "/@", "listDvojic"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"delkyCelkem", "=", 
       RowBox[{"listDvojic", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"delkyPresPory", ",", "delkyCelkem"}], "}"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"100", "*", 
       FractionBox["delkyPresPory", "delkyCelkem"]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.72396934675*^9, 3.72396948534375*^9}, {
   3.723969559203125*^9, 3.72396956796875*^9}, 3.723969894375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejProKsiz", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejProKsiz", "[", 
    RowBox[{"\[Xi]z_", ",", "listIndexuch_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"zpracvysledky", ",", "vysDelky1"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"vysDelky1", "=", 
       RowBox[{"zpracujJenDelky", "[", 
        RowBox[{"\[Xi]z", ",", "listIndexuch"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"zpVysledky", "[", "vysDelky1", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"vydejProKsiz", "[", 
    RowBox[{"\[Xi]zTry", ",", "listIndexuch1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"vydejProKsiz", "[", 
    RowBox[{"\[Xi]zTry", ",", "listIndexuch2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<spravne= \>\"", ",", "provitostSkutecna", ",", 
    "\"\<, po milimetru= \>\"", ",", "v1", ",", "\"\<  podle normy= \>\"", 
    ",", "v2", ",", "\"\< %\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.723969599375*^9, 3.72396967171875*^9}, {3.723969702*^9, 
  3.723969740265625*^9}, {3.723969791*^9, 3.723969802375*^9}, {
  3.723969865546875*^9, 3.7239698765625*^9}, {3.72396991403125*^9, 
  3.723970008953125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dats", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Quiet", "@", 
       RowBox[{"vydejProKsiz", "[", 
        RowBox[{"#", ",", "listIndexuch1"}], "]"}]}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"0.5", "\[CapitalDelta]x"}], ",", 
       RowBox[{"aKrychle", "-", 
        RowBox[{"0.5", "\[CapitalDelta]x"}]}], ",", 
       FractionBox[
        RowBox[{"aKrychle", "-", "\[CapitalDelta]x"}], 
        RowBox[{"1.2345", "*", "nDeleni"}]]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.723970192859375*^9, 3.72397024446875*^9}, {
  3.723970289078125*^9, 3.72397040371875*^9}, {3.72397049246875*^9, 
  3.7239704941875*^9}, {3.72397064290625*^9, 3.7239706489375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"prumerna", "=", 
   RowBox[{"Mean", "[", 
    RowBox[{"nr", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"np", "=", "dats"}], ",", "0"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<prumerna= \>\"", ",", "prumerna", ",", "\"\< % chyba= \>\"", ",", 
   RowBox[{"100", 
    FractionBox[
     RowBox[{"provitostSkutecna", "-", "prumerna"}], "provitostSkutecna"]}], 
   ",", "\"\< %, pri poctu \>\"", ",", 
   RowBox[{"Length", "[", "nr", "]"}], ",", "\"\< rezu, \[Sigma]= \>\"", ",", 
   RowBox[{"StandardDeviation", "[", "nr", "]"}], ",", "\"\< %\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.723970564421875*^9, 3.723970834828125*^9}, 
   3.723971137671875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dats2", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Quiet", "@", 
       RowBox[{"vydejProKsiz", "[", 
        RowBox[{"#", ",", "listIndexuch2"}], "]"}]}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"0.5", "\[CapitalDelta]x"}], ",", 
       RowBox[{"aKrychle", "-", 
        RowBox[{"0.5", "\[CapitalDelta]x"}]}], ",", 
       FractionBox[
        RowBox[{"aKrychle", "-", "\[CapitalDelta]x"}], 
        RowBox[{
         StyleBox["1.2345",
          FontColor->RGBColor[1, 0, 0]], "*", "nDeleni"}]]}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.723970192859375*^9, 3.72397024446875*^9}, {
  3.723970289078125*^9, 3.72397040371875*^9}, {3.72397049246875*^9, 
  3.7239704941875*^9}, {3.72397064290625*^9, 3.7239706489375*^9}, {
  3.7239709106875*^9, 3.72397091578125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"prumerna2", "=", 
   RowBox[{"Mean", "[", 
    RowBox[{"nr2", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"np2", "=", "dats2"}], ",", "0"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<prumerna= \>\"", ",", "prumerna2", ",", "\"\< % chyba= \>\"", ",", 
   RowBox[{"100", 
    FractionBox[
     RowBox[{"provitostSkutecna", "-", "prumerna2"}], "provitostSkutecna"]}], 
   ",", "\"\< %, pri poctu \>\"", ",", 
   RowBox[{"Length", "[", "nr2", "]"}], ",", "\"\< rezu, \[Sigma]= \>\"", ",", 
   RowBox[{"StandardDeviation", "[", "nr2", "]"}], ",", "\"\< %\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.723970564421875*^9, 3.723970834828125*^9}, {
  3.72397091853125*^9, 3.723970939734375*^9}, {3.723971147140625*^9, 
  3.7239711561875*^9}}]
},
WindowSize->{1158, 780},
WindowMargins->{{3, Automatic}, {Automatic, 4}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 333, 10, 103, "Input"],
Cell[893, 32, 355, 9, 103, "Input"],
Cell[1251, 43, 7767, 199, 927, "Input"],
Cell[9021, 244, 591, 17, 75, "Input"],
Cell[9615, 263, 15118, 359, 1469, "Input"],
Cell[24736, 624, 9943, 221, 1014, "Input"],
Cell[34682, 847, 3635, 96, 525, "Input"],
Cell[38320, 945, 2816, 57, 243, "Input"],
Cell[41139, 1004, 2755, 70, 327, "Input"],
Cell[43897, 1076, 1068, 26, 103, "Input"],
Cell[44968, 1104, 319, 7, 46, "Input"],
Cell[45290, 1113, 2061, 55, 271, "Input"],
Cell[47354, 1170, 1176, 31, 227, "Input"],
Cell[48533, 1203, 2209, 60, 271, "Input"],
Cell[50745, 1265, 1115, 28, 303, "Input"],
Cell[51863, 1295, 1516, 40, 299, "Input"],
Cell[53382, 1337, 780, 20, 133, "Input"],
Cell[54165, 1359, 776, 20, 150, "Input"],
Cell[54944, 1381, 888, 23, 133, "Input"],
Cell[55835, 1406, 853, 21, 150, "Input"]
}
]
*)

(* End of internal cache information *)
