(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51176,       1373]
NotebookOptionsPosition[     49627,       1328]
NotebookOutlinePosition[     50029,       1345]
CellTagsIndexPosition[     49986,       1342]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plusVahyVlevo", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["17", "24"], ",", 
     FractionBox[
      RowBox[{"-", "7"}], "24"], ",", 
     FractionBox["1", "12"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plusVahyVpravo", "=", 
   RowBox[{"Reverse", "[", "plusVahyVlevo", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahyOld", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "3"], 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], ",", 
      "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaVahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldVahy", ",", "nVah"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"oldVahy", "=", 
       RowBox[{"vahyOld", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nVah", "=", 
       RowBox[{"Length", "[", "oldVahy", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"plusVahyVlevo", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0", "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"nVah", "-", "6"}], "]"}]}], ")"}], ",", 
        "plusVahyVpravo"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"vahyOld", "[", "n", "]"}], "+", 
    RowBox[{"deltaVahy", "[", "n", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.682683537734375*^9, 3.68268359509375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"k", "*", "48000"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"pocet", " ", "samplu", " ", "za", " ", "sekundu"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", 
     FractionBox["1", "sr"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fmin", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fmax", "=", "10000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T1", "=", 
     FractionBox["1", "fmin"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nFrekvenci", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"Exp", "[", 
      RowBox[{
       FractionBox["1.", "nFrekvenci"], "*", 
       RowBox[{"Log", "[", 
        FractionBox["fmax", "fmin"], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fcesIdal", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"fmin", "*", 
        SuperscriptBox["q", 
         RowBox[{"#", "-", "1"}]]}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"nFrekvenci", "+", "1"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datNfces", "=", 
     FractionBox["sr", 
      RowBox[{"fcesIdal", "+", "0.01"}]]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.682683734109375*^9, 3.6826837624375*^9}, {
   3.682683808546875*^9, 3.682683878515625*^9}, {3.682683943328125*^9, 
   3.68268395328125*^9}, {3.682684003515625*^9, 3.682684010671875*^9}, {
   3.682684109453125*^9, 3.682684115703125*^9}, {3.68268415965625*^9, 
   3.682684167484375*^9}, {3.68268458709375*^9, 3.68268459378125*^9}, {
   3.682684845*^9, 3.682684846140625*^9}, {3.68275380034375*^9, 
   3.682753838171875*^9}, 3.682760316046875*^9, {3.683042604953125*^9, 
   3.683042605171875*^9}, {3.68304265078125*^9, 3.6830426509375*^9}, {
   3.683046645625*^9, 3.68304664646875*^9}, {3.68304669846875*^9, 
   3.68304670978125*^9}, 3.683046743296875*^9, {3.683046809875*^9, 
   3.6830468676875*^9}, {3.683284958609375*^9, 3.68328501259375*^9}, 
   3.683285523671875*^9, 3.683286243109375*^9, 3.683445867578125*^9, {
   3.683446151046875*^9, 3.6834461701875*^9}, 3.69104953075*^9, 
   3.69209461278125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dejLicheNF", "[", "nf_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "trojice", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"trojice", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Round", "[", 
            RowBox[{"nf", "-", "1"}], "]"}], ",", 
           RowBox[{"Round", "[", "nf", "]"}], ",", 
           RowBox[{"Round", "[", 
            RowBox[{"nf", "+", "1"}], "]"}]}], "}"}], ",", "OddQ"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Nearest", "[", 
       RowBox[{"trojice", ",", "nf"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fonlys", "=", 
   RowBox[{"DeleteDuplicates", "[", 
    FractionBox["sr", 
     RowBox[{"Flatten", "[", 
      RowBox[{"dejLicheNF", "/@", "datNfces"}], "]"}]], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.682684210234375*^9, 3.682684243828125*^9}, {
   3.682684318453125*^9, 3.682684332046875*^9}, {3.682684536671875*^9, 
   3.68268457596875*^9}, {3.682684626078125*^9, 3.682684762265625*^9}, 
   3.68268480659375*^9, {3.682684903765625*^9, 3.6826849111875*^9}, {
   3.682684950046875*^9, 3.682685031484375*^9}, {3.682685075765625*^9, 
   3.682685092453125*^9}, {3.682753780015625*^9, 3.68275379709375*^9}, {
   3.682753853578125*^9, 3.682753859953125*^9}, {3.683286302875*^9, 
   3.683286307015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fPrepend", "=", 
   RowBox[{"fonlys", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dvojiceFonlys", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Prepend", "[", 
      RowBox[{"fonlys", ",", "fPrepend"}], "]"}], ",", "2", ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "/@", 
   RowBox[{"{", 
    RowBox[{"fonlys", ",", "dvojiceFonlys"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.69088812996875*^9, 3.690888141453125*^9}, {
   3.69088829296875*^9, 3.6908883351875*^9}, {3.690888393546875*^9, 
   3.690888406890625*^9}, 3.69088887228125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"vydejSamply", ",", "indexFce"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"indexFce", "[", "f_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Position", "[", 
     RowBox[{"fonlys", ",", "f"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejSamply", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "normFce_Function"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"T", ",", "dt", ",", "nT"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       FractionBox["1", "f"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dt", "=", 
       FractionBox["1", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nT", "=", 
       FractionBox["T", "dt"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          FractionBox["fmin", "f"], ")"}], "*", 
         RowBox[{"normFce", "[", 
          RowBox[{"2.", "*", "Pi", "*", "f", "*", "#"}], "]"}]}], "&"}], "/@", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", 
         RowBox[{"T", "-", "dt"}], ",", "dt"}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejSamply", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"fonlys", "[", 
       RowBox[{"[", "10", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "}"}], "]"}], "//", 
   "Length"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nFci", "=", 
    RowBox[{"Length", "[", "fonlys", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<imax= \>\"", ",", "nFci"}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6826852604375*^9, 3.6826853045625*^9}, {3.68268535*^9, 
   3.682685443203125*^9}, {3.682685473671875*^9, 3.682685481015625*^9}, {
   3.682756722515625*^9, 3.682756726921875*^9}, {3.690888420625*^9, 
   3.690888442296875*^9}, {3.690889264890625*^9, 3.69088926925*^9}, {
   3.69209410825*^9, 3.6920941151875*^9}, 3.692094438890625*^9, {
   3.692094639828125*^9, 3.692094646859375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kper", "=", "3"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"kper", " ", "musi", " ", "byt", " ", "liche", " ", "cislo"}], 
    ",", 
    RowBox[{
    "ale", " ", "jen", " ", "pro", " ", "vyhodnocovani", " ", "amplitud"}]}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.692097390953125*^9, 3.692097397125*^9}, {
  3.692097452859375*^9, 3.6920974536875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "vydejSamplySmooth", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejSamplySmooth", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"fStart_", ",", "fEnd_"}], "}"}], ",", "normFce_Function"}], 
       "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "T", ",", "dt", ",", "nT", ",", "tmax", ",", "rn", ",", "f", ",", 
         RowBox[{"pocetPeriod", "=", "8"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"T", "=", 
         FractionBox["1", "fEnd"]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dt", "=", 
         FractionBox["1", "sr"]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tmax", "=", 
         RowBox[{
          RowBox[{"pocetPeriod", "*", "T"}], "-", "dt"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rn", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"0.", ",", "tmax", ",", "dt"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"f", "=", 
         RowBox[{
          RowBox[{"fStart", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"fEnd", "-", "fStart"}], ")"}], "*", 
            FractionBox["#", "tmax"]}]}], "&"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            FractionBox["fmin", 
             RowBox[{"f", "[", "#", "]"}]], ")"}], "*", 
           RowBox[{"normFce", "[", 
            RowBox[{"2.", "*", "Pi", "*", 
             RowBox[{"f", "[", "#", "]"}], "*", "#"}], "]"}]}], "&"}], "/@", 
         "rn"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2"}], "}"}], "=", 
     RowBox[{"dvojiceFonlys", "[", 
      RowBox[{"[", "12", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vydejSamplySmooth", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f1", ",", "f2"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "}"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"%", ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.690889272359375*^9, 3.69088935565625*^9}, {
   3.69088938578125*^9, 3.690889393359375*^9}, {3.69088949453125*^9, 
   3.690889531984375*^9}, {3.690889705484375*^9, 3.690889755375*^9}, {
   3.6908898233125*^9, 3.6908899949375*^9}, {3.690890106796875*^9, 
   3.690890144140625*^9}, 3.690890192765625*^9, {3.690890231296875*^9, 
   3.6908903735*^9}, {3.690890412984375*^9, 3.6908904875*^9}, {
   3.690890543953125*^9, 3.69089054415625*^9}, {3.6908905901875*^9, 
   3.690890628828125*^9}, {3.690890659625*^9, 3.690890685921875*^9}, {
   3.690891316953125*^9, 3.690891398734375*^9}, {3.69089147534375*^9, 
   3.690891560359375*^9}, {3.69089166946875*^9, 3.690891678203125*^9}, {
   3.690893065265625*^9, 3.690893104453125*^9}, 3.69089409553125*^9, 
   3.69104878084375*^9, {3.69104969121875*^9, 3.691049707609375*^9}, 
   3.69104974753125*^9, 3.69104993384375*^9, {3.69209374940625*^9, 
   3.692093760296875*^9}, {3.69209383396875*^9, 3.69209389825*^9}, {
   3.6920939900625*^9, 3.6920940613125*^9}, 3.692094692109375*^9, 
   3.69209738684375*^9, 3.69209747246875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tabSin", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejSamply", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "}"}], "]"}], "&"}], "/@", 
    "fonlys"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabCos", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejSamply", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{
         RowBox[{"Cos", "[", "#", "]"}], "&"}]}], "}"}], "]"}], "&"}], "/@", 
    "fonlys"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejNperiod", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejNperiod", "[", 
    RowBox[{"{", 
     RowBox[{"i_Integer", ",", "nper_Integer"}], "}"}], "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"tabSin", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "&"}], "/@", 
     RowBox[{"Range", "[", "nper", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.682685556921875*^9, 3.68268556846875*^9}, 
   3.682685607359375*^9, {3.682756745984375*^9, 3.682756746921875*^9}, 
   3.692093640140625*^9, 3.692093689796875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejKusSignalu", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejKusSignalu", "[", "index_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"konecSignalu", ",", "zacatekSignalu", ",", "kusSignalu", ",", 
       RowBox[{"kperLocal", "=", "15"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"konecSignalu", "=", 
       RowBox[{"vydejNperiod", "[", 
        RowBox[{"{", 
         RowBox[{"index", ",", "kperLocal"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"zacatekSignalu", "=", 
       RowBox[{"vydejSamplySmooth", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dvojiceFonlys", "[", 
           RowBox[{"[", "index", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kusSignalu", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"zacatekSignalu", ",", "konecSignalu"}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejKusSignalu", "[", "5", "]"}], "//", "ListPlot"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.69089195371875*^9, 3.690891976890625*^9}, {
   3.69089208178125*^9, 3.69089211634375*^9}, {3.6908930446875*^9, 
   3.690893055546875*^9}, {3.690893176765625*^9, 3.6908932499375*^9}, {
   3.6908932846875*^9, 3.690893307796875*^9}, {3.690893385765625*^9, 
   3.690893400703125*^9}, 3.69089368475*^9, {3.690893803171875*^9, 
   3.690893833765625*^9}, {3.69089387165625*^9, 3.690893901875*^9}, {
   3.690894106625*^9, 3.690894109171875*^9}, {3.69104924428125*^9, 
   3.6910492565*^9}, {3.6910494523125*^9, 3.691049491140625*^9}, 
   3.691049579671875*^9, {3.692094355640625*^9, 3.69209441159375*^9}, {
   3.692094454078125*^9, 3.692094474765625*^9}, 3.692094668296875*^9, 
   3.69209543459375*^9, {3.692097485984375*^9, 3.6920974933125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pomDat", "=", 
   RowBox[{"vydejKusSignalu", "/@", 
    RowBox[{"Range", "[", "nFci", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"signalVlastni", "=", 
   RowBox[{"Flatten", "[", "pomDat", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690893946125*^9, 3.690893948578125*^9}, {
  3.69089401234375*^9, 3.690894039375*^9}, {3.69104975975*^9, 
  3.691049760875*^9}, {3.691050980828125*^9, 3.691050989453125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"Take", "[", 
    RowBox[{"signalVlastni", ",", "All"}], "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6908940539375*^9, 3.690894079890625*^9}, 
   3.690894120671875*^9, 3.69209459384375*^9, {3.692094712296875*^9, 
   3.69209471953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fTelegram", "=", 
   RowBox[{"1", "*", "440"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kTelegram", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPerPredsignal", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"indexPocFce", "=", 
   RowBox[{"indexFce", "@", 
    RowBox[{
     RowBox[{"Nearest", "[", 
      RowBox[{"fonlys", ",", "fTelegram"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poom", "=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{"fonlys", "[", 
       RowBox[{"[", "indexPocFce", "]"}], "]"}], "fmin"], ")"}], "*", 
    RowBox[{"vydejNperiod", "[", 
     RowBox[{"{", 
      RowBox[{"indexPocFce", ",", "nPerPredsignal"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"predsignal", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"poom", ",", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", "poom"}], ",", "poom", ",", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", "poom"}], ",", "poom"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lplpredsignal", "=", 
   RowBox[{"ListPlot", "[", "%", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.682757203109375*^9, {3.682758547859375*^9, 3.682758555984375*^9}, {
   3.68275870465625*^9, 3.68275873253125*^9}, {3.682760067375*^9, 
   3.682760104625*^9}, 3.6827608643125*^9, {3.682848759046875*^9, 
   3.682848773265625*^9}, 3.683013568484375*^9, {3.68301360109375*^9, 
   3.683013626328125*^9}, 3.683037209859375*^9, 3.68303752090625*^9, 
   3.683037724015625*^9, 3.683042526875*^9, {3.683042585609375*^9, 
   3.68304258575*^9}, 3.683045438828125*^9, 3.683284561296875*^9, {
   3.683285277921875*^9, 3.68328530303125*^9}, {3.683285367984375*^9, 
   3.68328536915625*^9}, 3.683285404625*^9, 3.6832859734375*^9, {
   3.690886080125*^9, 3.690886090234375*^9}, {3.690894126796875*^9, 
   3.6908941296875*^9}, {3.692093525796875*^9, 3.6920935314375*^9}, {
   3.692094725015625*^9, 3.69209482775*^9}, {3.69209496596875*^9, 
   3.69209497309375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nperpredPredSignal", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"predPredSignal", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"fonlys", "[", 
       RowBox[{"[", "indexPocFce", "]"}], "]"}], "fmin"], ")"}], "*", 
    RowBox[{"vydejNperiod", "[", 
     RowBox[{"{", 
      RowBox[{"indexPocFce", ",", "nperpredPredSignal"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"telegram", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"predPredSignal", ",", "predsignal"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"signal", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"kTelegram", "*", "telegram"}], ",", "signalVlastni"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startKus", "=", 
   RowBox[{"Take", "[", 
    RowBox[{"signal", ",", 
     RowBox[{
      RowBox[{"Length", "[", "telegram", "]"}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"Length", "[", 
        RowBox[{"tabSin", "[", 
         RowBox[{"[", "indexPocFce", "]"}], "]"}], "]"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plstart", "=", 
   RowBox[{"ListPlot", "[", "startKus", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.69209489425*^9, 3.692094926140625*^9}, {
  3.692094986125*^9, 3.69209501734375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nHodnotim", "[", 
    RowBox[{"i_Integer", ",", "kper_Integer"}], "]"}], ":=", 
   RowBox[{"kper", "*", 
    RowBox[{"Length", "[", 
     RowBox[{"tabSin", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nProVahy", "[", 
    RowBox[{"i_Integer", ",", "kper_Integer"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"nHodnotim", "[", 
       RowBox[{"i", ",", "kper"}], "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejAmpl", "[", 
     RowBox[{"{", 
      RowBox[{"listDat_", ",", "i_Integer", ",", "kper_Integer"}], "}"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "T", ",", "f", ",", "dt", ",", "nTake", ",", "vazky", ",", "data", ",",
         "tabsin", ",", "tabcos"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nTake", "=", 
        RowBox[{"nHodnotim", "[", 
         RowBox[{"i", ",", "kper"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"vazky", "=", 
        RowBox[{"vahy", "[", 
         RowBox[{"nProVahy", "[", 
          RowBox[{"i", ",", "kper"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"listDat", ",", "nTake"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fonlys", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"T", "=", 
        FractionBox["1", "f"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"tabsin", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"tabSin", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "kper", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"tabcos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"tabCos", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "kper", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"fonlys", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "fmin"], ")"}], "*", 
        FractionBox["2.", 
         RowBox[{"sr", "*", "T", "*", "kper"}]], "*", 
        RowBox[{"Abs", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"data", "*", "vazky"}], ")"}], ".", "tabsin"}], ")"}], 
           "+", 
           RowBox[{"I", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"data", "*", "vazky"}], ")"}], ".", "tabcos"}], 
             ")"}]}]}], ")"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.682757371015625*^9, 3.68275740084375*^9}, 
   3.68275852690625*^9, {3.68344632665625*^9, 3.683446362203125*^9}, {
   3.692093594125*^9, 3.692093599015625*^9}, {3.692095666390625*^9, 
   3.692095678*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejZacatekV", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejZacatekV", "[", 
    RowBox[{"{", 
     RowBox[{"data_", ",", "ip1_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ldi", ",", "nshiftmax", ",", 
       RowBox[{"nmax", "=", 
        RowBox[{"Length", "[", "data", "]"}]}], ",", "nw1", ",", "fpom", ",", 
       "dats", ",", "nshiftmaxf", ",", "f", ",", "rozdily", ",", "sort", ",", 
       "nTake", ",", "d1", ",", "d2", ",", "aaa", ",", "a", ",", "b", ",", 
       "c", ",", "d", ",", "n0", ",", "nDrop"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"nw1", "=", 
       RowBox[{"nHodnotim", "[", 
        RowBox[{"ip1", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ldi", "[", 
        RowBox[{"{", 
         RowBox[{"i_", ",", "nw_"}], "}"}], "]"}], ":=", 
       RowBox[{"Take", "[", 
        RowBox[{"data", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"i", "+", "nw"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fpom", "[", "i_", "]"}], ":=", 
       RowBox[{"vydejAmpl", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ldi", "[", 
           RowBox[{"{", 
            RowBox[{"i", ",", "nw1"}], "}"}], "]"}], ",", "ip1", ",", "1"}], 
         "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nshiftmax", "=", 
       RowBox[{
        RowBox[{"Length", "[", "data", "]"}], "-", "nw1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dats", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"fpom", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", "nshiftmax", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nshiftmaxf", "=", 
       RowBox[{
        RowBox[{"Length", "[", "dats", "]"}], "-", "nw1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", "index_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{"index", ",", 
         RowBox[{
          RowBox[{"dats", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"index", "+", "nw1"}], ",", "2"}], "]"}], "]"}], "-", 
          RowBox[{"dats", "[", 
           RowBox[{"[", 
            RowBox[{"index", ",", "2"}], "]"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rozdily", "=", 
       RowBox[{"f", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", "nshiftmaxf"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sort", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"rozdily", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "<", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nTake", "=", "4"}], ";", "\[IndentingNewLine]", 
      RowBox[{"d1", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"sort", ",", "nTake"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d2", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"sort", ",", 
         RowBox[{"-", "nTake"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"aaa", "=", 
       RowBox[{"First", "/@", 
        RowBox[{"Union", "[", 
         RowBox[{"d1", ",", "d2"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
       RowBox[{
        RowBox[{"First", "/@", 
         RowBox[{"Partition", "[", 
          RowBox[{"aaa", ",", "2"}], "]"}]}], "-", "1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"n0", "=", 
       RowBox[{"Round", "[", 
        FractionBox[
         RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", 
          RowBox[{"4", " ", "nw1"}], "-", 
          RowBox[{"10", " ", "nPerPredsignal", " ", "nw1"}]}], 
         RowBox[{"4", " "}]], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nDrop", "=", 
       RowBox[{"n0", "+", 
        RowBox[{"5", "nPerPredsignal", "*", "nw1"}]}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6830382806875*^9, 3.683038374640625*^9}, {
   3.683038425609375*^9, 3.683038465578125*^9}, {3.6830385391875*^9, 
   3.68303855240625*^9}, {3.683038643078125*^9, 3.68303866371875*^9}, {
   3.68303957871875*^9, 3.683039592859375*^9}, {3.683039712828125*^9, 
   3.683039722515625*^9}, {3.683039766859375*^9, 3.683039785453125*^9}, {
   3.68303982375*^9, 3.6830398291875*^9}, 3.683039927921875*^9, {
   3.683040062234375*^9, 3.683040066140625*^9}, 3.68304192078125*^9, {
   3.68304214*^9, 3.6830421598125*^9}, {3.683042262015625*^9, 
   3.68304227471875*^9}, {3.683042490671875*^9, 3.683042496171875*^9}, 
   3.683284814421875*^9, {3.683446654578125*^9, 3.683446671125*^9}, 
   3.691050425875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nDropZacatek", "=", 
   RowBox[{"vydejZacatekV", "[", 
    RowBox[{"{", 
     RowBox[{"startKus", ",", "indexPocFce"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prozprac", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"startKus", ",", "nDropZacatek"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.68304036671875*^9, {3.683040477296875*^9, 3.683040489140625*^9}, {
   3.683042208359375*^9, 3.68304224171875*^9}, {3.68304229003125*^9, 
   3.683042292453125*^9}, {3.68304235825*^9, 3.68304237740625*^9}, {
   3.683045131671875*^9, 3.6830451551875*^9}, 3.683284840859375*^9, 
   3.683284879640625*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{"vydejZacatekV", "[", 
     RowBox[{"{", 
      RowBox[{"startKus", ",", "indexPocFce"}], "}"}], "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"14.99", ",", "10725"}], "}"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.683285138828125*^9, 3.683285141671875*^9}, {
  3.683285215328125*^9, 3.6832852454375*^9}}],

Cell[BoxData[{
 RowBox[{"Timing", "[", 
  RowBox[{"vydejZacatekV", "[", 
   RowBox[{"{", 
    RowBox[{"startKus", ",", "indexPocFce"}], "}"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"casove", " ", "slabe", " ", "misto", " ", "vypoctu"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6832861733125*^9, 3.683286183640625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", "startKus", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.691049798203125*^9, 3.691049801625*^9}, 
   3.69104983371875*^9, {3.692095068359375*^9, 3.69209507084375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vlastniSignal", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"signal", ",", "nDropZacatek"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", 
  RowBox[{"signalVlastni", "-", "vlastniSignal"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68304523434375*^9, 3.68304528484375*^9}, 
   3.6830453165625*^9, 3.683045421890625*^9, {3.68304678709375*^9, 
   3.683046787921875*^9}, 3.68328487315625*^9, {3.692095074734375*^9, 
   3.69209507665625*^9}, {3.692095746421875*^9, 3.69209574684375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "data", "]"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "kper", " ", "musi", " ", "byt", " ", "liche", " ", "cislo", " ", 
     "skrzeva", " ", "Simpsona"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"i_Integer", ",", "vlastniSignal_", ",", 
       RowBox[{"kper_", "?", "OddQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"indexyKoncu", ",", "nShift", ",", "dafFce"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"indexyKoncu", "=", 
         RowBox[{"Accumulate", "[", 
          RowBox[{"Length", "/@", "pomDat"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nShift", "=", 
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["0.5", "kper"], 
           RowBox[{"nHodnotim", "[", 
            RowBox[{"i", ",", "kper"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dafFce", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"vlastniSignal", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"indexyKoncu", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", 
              RowBox[{"nHodnotim", "[", 
               RowBox[{"i", ",", "kper"}], "]"}], "-", "nShift"}], ",", 
             RowBox[{
              RowBox[{"indexyKoncu", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "nShift"}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"vydejAmpl", "[", 
         RowBox[{"{", 
          RowBox[{"dafFce", ",", "i", ",", "kper"}], "}"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Min", "[", "#", "]"}], ",", 
       RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"#", ",", "vlastniSignal", ",", "3"}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "nFci", "]"}]}], ")"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.683045842609375*^9, {3.683045991328125*^9, 3.6830460309375*^9}, {
   3.683046088*^9, 3.683046175234375*^9}, {3.683046243515625*^9, 
   3.6830464286875*^9}, {3.683046463546875*^9, 3.683046629640625*^9}, 
   3.68304672028125*^9, 3.683046756515625*^9, {3.6830469368125*^9, 
   3.68304694771875*^9}, {3.683046996546875*^9, 3.683047014109375*^9}, {
   3.68328635575*^9, 3.6832863823125*^9}, {3.683446834953125*^9, 
   3.68344688075*^9}, {3.68344717384375*^9, 3.68344723315625*^9}, 
   3.6910488695*^9, {3.691050150125*^9, 3.691050202375*^9}, {
   3.69209722159375*^9, 3.6920972270625*^9}, {3.692097560109375*^9, 
   3.692097604984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "graf", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"graf", "[", "signal_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"amplitudy", ",", "pl1", ",", "pl2", ",", "protisk", ",", 
       RowBox[{"plr", "=", "0.1"}], ",", "int", ",", "f1", ",", "f2", ",", 
       RowBox[{"ndf", "=", "5"}], ",", "newfonlys", ",", "protiskSpojity", 
       ",", "intpom", ",", "korekce"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"korekce", "[", "f_", "]"}], ":=", 
       FractionBox["f", "fmin"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"amplitudy", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"N", "@", 
            RowBox[{"fonlys", "[", 
             RowBox[{"[", "#", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"korekce", "[", 
             RowBox[{"N", "@", 
              RowBox[{"fonlys", "[", 
               RowBox[{"[", "#", "]"}], "]"}]}], "]"}], "*", 
            RowBox[{"data", "[", 
             RowBox[{"#", ",", "signal", ",", "kper"}], "]"}]}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", "nFci", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"protisk", "=", 
       RowBox[{"amplitudy", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_Real", ",", "b_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"a", ",", 
           FractionBox["b", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "amplitudy"}], 
             "]"}]]}], "}"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pl1", "=", 
       RowBox[{"ListLogLogPlot", "[", 
        RowBox[{"protisk", ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"plr", ",", "1.2"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<f [Hz]\>\"", ",", "\"\<Abs[p] [-]\>\""}], "}"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"intpom", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{"protisk", ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"int", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"intpom", "[", "#", "]"}]}], "}"}], "&"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"newfonlys", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"fmin", "*", 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["q", 
             FractionBox["1", "ndf"]], ")"}], 
           RowBox[{"#", "-", "1"}]]}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"ndf", "*", "nFrekvenci"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f1", ",", "f2"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"newfonlys", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"newfonlys", "[", 
          RowBox[{"[", 
           RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"protiskSpojity", "=", 
       RowBox[{"int", "/@", "newfonlys"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pl2", "=", 
       RowBox[{"ListLogLogPlot", "[", 
        RowBox[{"protiskSpojity", ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"plr", ",", "1.5"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"pl1", ",", "pl2"}], "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pp", "=", 
  RowBox[{
  "graf", "[", "vlastniSignal", "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.683047033*^9, 3.68304712746875*^9}, {
   3.68304716003125*^9, 3.68304723946875*^9}, {3.683047279984375*^9, 
   3.683047407546875*^9}, {3.6830474469375*^9, 3.683047776140625*^9}, {
   3.683049924015625*^9, 3.6830499388125*^9}, {3.6830512253125*^9, 
   3.68305123709375*^9}, {3.683051808796875*^9, 3.683051835140625*^9}, {
   3.683051866359375*^9, 3.683051930296875*^9}, {3.683051982796875*^9, 
   3.68305228303125*^9}, {3.68305248990625*^9, 3.683052537171875*^9}, {
   3.68305261121875*^9, 3.68305271409375*^9}, {3.683052774296875*^9, 
   3.68305310190625*^9}, {3.68305314540625*^9, 3.683053214984375*^9}, {
   3.683053292640625*^9, 3.683053336546875*^9}, {3.683447277703125*^9, 
   3.68344734328125*^9}, {3.690893033421875*^9, 3.690893034265625*^9}, {
   3.692095275515625*^9, 3.692095328828125*^9}, {3.692095370875*^9, 
   3.692095383859375*^9}, 3.692095873078125*^9, {3.692095906484375*^9, 
   3.692095978390625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"prenos", "[", "f_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"frezonancni", "=", "600."}], ",", 
        RowBox[{"Rz", "=", "1000."}], ",", 
        RowBox[{"RL", "=", "130."}], ",", 
        RowBox[{"L", "=", 
         RowBox[{"46.", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "3"}]]}]}], ",", "c", ",", "cpom", ",", "citatel"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"c", "=", 
        RowBox[{"cpom", "/.", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2.", "*", "Pi", "*", "frezonancni"}], "\[Equal]", 
             FractionBox["1", 
              SqrtBox[
               RowBox[{"L", "*", "cpom"}]]]}], ",", "cpom"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"citatel", "=", 
        RowBox[{"RL", "+", 
         RowBox[{"2.", "*", "Pi", "*", "f", "*", "I", "*", "L"}], "+", 
         FractionBox["1", 
          RowBox[{"2.", "*", "Pi", "*", "f", "*", "I", "*", "c"}]]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Abs", "[", 
        FractionBox["citatel", 
         RowBox[{"citatel", "+", "Rz"}]], "]"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.68304870153125*^9, 3.68304872290625*^9}, {
   3.68304877590625*^9, 3.683049066546875*^9}, {3.68304913965625*^9, 
   3.683049144203125*^9}, {3.683049176875*^9, 3.683049355046875*^9}, {
   3.683051085859375*^9, 3.6830511125*^9}, {3.68328491959375*^9, 
   3.68328492828125*^9}, 3.683285800046875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"newDat", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"pomDat", "[", 
         RowBox[{"[", "#", "]"}], "]"}], "*", 
        RowBox[{"prenos", "[", 
         RowBox[{"fonlys", "[", 
          RowBox[{"[", "#", "]"}], "]"}], "]"}]}], "&"}], "/@", 
      RowBox[{"Range", "[", "nFci", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.683049672296875*^9, 3.683049849640625*^9}, {
  3.683284921046875*^9, 3.683284924*^9}}],

Cell[BoxData[
 RowBox[{"gr", "=", 
  RowBox[{"graf", "[", "newDat", "]"}]}]], "Input",
 CellChangeTimes->{
  3.683049876734375*^9, {3.683050593875*^9, 3.683050598859375*^9}, 
   3.683050665390625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"signalCoZpracovavam", "=", "signal"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nmax", "=", 
   RowBox[{"Length", "[", "signal", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"nTakeMin", ",", "nTakeMax"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Round", "[", 
      RowBox[{"sr", "/", 
       RowBox[{"#", "[", "fonlys", "]"}]}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"Max", ",", "Min"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nEnd", "[", "ksi_", "]"}], ":=", 
   RowBox[{"nTakeMax", "+", 
    RowBox[{"Round", "@", 
     RowBox[{"Exp", "[", 
      RowBox[{"ksi", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"nmax", "-", "nTakeMax"}], "]"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nStart", "[", 
    RowBox[{"ksi_", ",", "psi_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nend", ",", "nokno"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"nend", "=", 
       RowBox[{"nEnd", "[", "ksi", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nokno", "=", 
       RowBox[{"Round", "[", 
        RowBox[{"nTakeMax", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"psi", "*", 
           RowBox[{"Log", "[", 
            FractionBox["nTakeMin", "nTakeMax"], "]"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"Max", "[", 
         RowBox[{"1", ",", 
          RowBox[{"nend", "-", "nokno"}]}], "]"}], ",", "nend"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.691052987265625*^9, 3.69105310390625*^9}, {
   3.69105313925*^9, 3.6910531851875*^9}, {3.691053224140625*^9, 
   3.691053256421875*^9}, {3.691053327125*^9, 3.691053375140625*^9}, {
   3.691053461890625*^9, 3.691053463390625*^9}, {3.691053525421875*^9, 
   3.691053526484375*^9}, 3.69105356025*^9, {3.69105359078125*^9, 
   3.69105362246875*^9}, {3.691053670390625*^9, 3.691053729640625*^9}, {
   3.6910537871875*^9, 3.69105383053125*^9}, {3.691053912046875*^9, 
   3.69105393590625*^9}, 3.69105398215625*^9, {3.69105415965625*^9, 
   3.691054180015625*^9}, {3.69105421996875*^9, 3.691054264859375*^9}, {
   3.691054325828125*^9, 3.6910543750625*^9}, {3.69105480396875*^9, 
   3.691054815765625*^9}, {3.69105485190625*^9, 3.69105486665625*^9}, {
   3.691054924734375*^9, 3.691054935671875*^9}, {3.69105498646875*^9, 
   3.691054994875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ukazKusSignalu", "[", 
    RowBox[{"signal_", ",", "ksi_", ",", "psi_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "data", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"signal", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"nStart", "[", 
            RowBox[{"ksi", ",", "psi"}], "]"}], ",", 
           RowBox[{"nEnd", "[", "ksi", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"data", ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"None", ",", "Automatic"}], "}"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ukazKusSignalu", "[", 
   RowBox[{"vlastniSignal", ",", ".92", ",", "0.01"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.691050798375*^9, 3.691050832328125*^9}, {
   3.691050888140625*^9, 3.6910508980625*^9}, {3.691051086359375*^9, 
   3.691051157390625*^9}, {3.691051303375*^9, 3.69105134521875*^9}, {
   3.69105138640625*^9, 3.691051514*^9}, {3.6910518349375*^9, 
   3.691051877765625*^9}, 3.691052956296875*^9, {3.6910543936875*^9, 
   3.691054534140625*^9}, {3.691054665984375*^9, 3.691054713265625*^9}, {
   3.691054744515625*^9, 3.6910547605*^9}, {3.691054819578125*^9, 
   3.691054825265625*^9}, {3.691054858625*^9, 3.691054882140625*^9}, {
   3.69105500015625*^9, 3.691055051796875*^9}, {3.691055161375*^9, 
   3.691055178640625*^9}, {3.691055213078125*^9, 3.691055222234375*^9}, 
   3.692093298890625*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"ukazKusSignalu", "[", 
     RowBox[{"vlastniSignal", ",", "ksi", ",", "psi"}], "]"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"ksi", ",", "0.01", ",", "0.999"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"psi", ",", "0", ",", "1"}], "}"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.69105508709375*^9, 3.69105513046875*^9}, 
   3.69209328909375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plrn", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "signal", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kplrn", "=", "1.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"play", "=", 
  RowBox[{"ListPlay", "[", 
   RowBox[{"signal", ",", 
    RowBox[{"SampleRate", "\[Rule]", "sr"}], ",", 
    RowBox[{"PlayRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "kplrn"}], "*", "plrn"}], ",", 
       RowBox[{"kplrn", "*", "plrn"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<play.wav\>\"", ",", "play"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6910553454375*^9, 3.6910553506875*^9}, {
  3.691055389375*^9, 3.691055409578125*^9}, {3.69209600753125*^9, 
  3.692096016734375*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"int", "=", 
    RowBox[{"Interpolation", "[", "signal", "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"dint", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"int", "'"}], "[", "#", "]"}], "&"}]}], ";", "\n", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"dint", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2000", ",", "25000"}], "}"}]}], "]"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.69209771021875*^9, 3.69209774740625*^9}, {
  3.69209781078125*^9, 3.692097815125*^9}}]
},
WindowSize->{1155, 638},
WindowMargins->{{14, Automatic}, {Automatic, 8}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 333, 10, 103, "Input"],
Cell[881, 32, 2056, 61, 330, "Input"],
Cell[2940, 95, 2357, 58, 443, "Input"],
Cell[5300, 155, 1477, 36, 187, "Input"],
Cell[6780, 193, 717, 19, 131, "Input"],
Cell[7500, 214, 2396, 65, 554, "Input"],
Cell[9899, 281, 413, 12, 46, "Input"],
Cell[10315, 295, 3537, 86, 587, "Input"],
Cell[13855, 383, 1223, 38, 159, "Input"],
Cell[15081, 423, 2054, 46, 271, "Input"],
Cell[17138, 471, 492, 11, 103, "Input"],
Cell[17633, 484, 310, 7, 46, "Input"],
Cell[17946, 493, 2114, 51, 245, "Input"],
Cell[20063, 546, 1375, 40, 245, "Input"],
Cell[21441, 588, 3334, 92, 559, "Input"],
Cell[24778, 682, 5053, 127, 690, "Input"],
Cell[29834, 811, 693, 17, 103, "Input"],
Cell[30530, 830, 412, 11, 75, "Input"],
Cell[30945, 843, 366, 10, 75, "Input"],
Cell[31314, 855, 219, 4, 46, "Input"],
Cell[31536, 861, 562, 12, 103, "Input"],
Cell[32101, 875, 2906, 72, 386, "Input"],
Cell[35010, 949, 5637, 135, 780, "Input"],
Cell[40650, 1086, 1765, 43, 371, "Input"],
Cell[42418, 1131, 552, 16, 75, "Input"],
Cell[42973, 1149, 200, 5, 46, "Input"],
Cell[43176, 1156, 2613, 65, 353, "Input"],
Cell[45792, 1223, 1916, 44, 187, "Input"],
Cell[47711, 1269, 490, 12, 103, "Input"],
Cell[48204, 1283, 851, 24, 131, "Input"],
Cell[49058, 1309, 565, 17, 103, "Input"]
}
]
*)

(* End of internal cache information *)
