(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     37348,       1062]
NotebookOptionsPosition[     36404,       1032]
NotebookOutlinePosition[     36785,       1048]
CellTagsIndexPosition[     36742,       1045]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"users", ".", "fit", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "stampfra"}]}], "/", "lectures"}], "/", "lin"}], "/", 
     "lin"}], "-", "prednaska", "-", "14", "-", 
    RowBox[{"handout", ".", "v1", ".", "pdf"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6856836586400037`*^9, 3.6856836622806287`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "popovidat", " ", "o", " ", "experimentalni", " ", "matematice", " ", 
         "s", " ", "pouzitim", " ", "nahodnych", " ", "cisel"}], "..."}], " ",
        "slo", " ", "by", " ", "o", " ", "tom", " ", "delat", " ", "doktorat",
        " ", "na", " ", "statistice", " ", "a", " ", "pravdepodobnosti"}], 
      "..."}], " ", "ale", " ", "jistotu", " ", "inzenyrum", " ", "neda", " ",
      "nic"}], ",", " ", 
    RowBox[{
    "tedy", " ", "pravdepodobnost", " ", "a", " ", "statistika", " ", 
     "zvetsi", " ", "pravdepodobnost"}], ",", " ", 
    RowBox[{"ze", " ", "jsme", " ", "nevypocitali", " ", 
     RowBox[{"pitomost", " ", ":", "-"}]}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.68572043146875*^9, 3.685720524296875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sortByImag", ":=", 
   RowBox[{
    RowBox[{"Sort", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Im", "[", "#1", "]"}], "<", 
        RowBox[{"Im", "[", "#2", "]"}]}], "&"}]}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"randomMatrix", "[", "rnm_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "&"}], "[", "i", 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6856875226556287`*^9, 3.6856875658743787`*^9}, {
  3.6856878199368787`*^9, 3.6856878215931287`*^9}, {3.68571858965625*^9, 
  3.685718645375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
   RowBox[{
    RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Inverse", "[", "P", "]"}], ".", "A", ".", "P"}], "//", 
    "Chop"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "mf"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sortByImag", "[", 
      RowBox[{"Eigenvalues", "[", "diag", "]"}], "]"}], "-", 
     RowBox[{"sortByImag", "[", "lambdas", "]"}]}], "}"}], "//", "Chop"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685683424625*^9, 3.685683427375*^9}, {
  3.6856869625775037`*^9, 3.6856869639837537`*^9}, {3.6856871341556287`*^9, 
  3.6856872405931287`*^9}, {3.6856872751712537`*^9, 3.6856873130618787`*^9}, {
  3.6856873595462537`*^9, 3.6856874004525037`*^9}, {3.6856875840150037`*^9, 
  3.6856875882806287`*^9}, {3.6856876514993787`*^9, 3.6856876959212537`*^9}, {
  3.6856878448900037`*^9, 3.6856878511243787`*^9}, {3.6857172029375*^9, 
  3.68571723615625*^9}, {3.6857186751875*^9, 3.68571867653125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"functions", " ", "of", " ", "matrices"}], "..."}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix_", ",", "function_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "lambdas", ",", "vectors", ",", "P", ",", "invP", ",", 
         "diagonalMatrix"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
         RowBox[{
          RowBox[{"Eigensystem", "[", "matrix", "]"}], "//", "N"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"P", "=", 
         RowBox[{"Transpose", "[", "vectors", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"invP", "=", 
         RowBox[{"Inverse", "[", "P", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"diagonalMatrix", "=", 
         RowBox[{
          RowBox[{"Inverse", "[", "P", "]"}], ".", "matrix", ".", "P"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"P", ".", 
         RowBox[{"DiagonalMatrix", "[", 
          RowBox[{"function", "/@", 
           RowBox[{"Diagonal", "[", "diagonalMatrix", "]"}]}], "]"}], ".", 
         "invP"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{"#", "&"}]}], "]"}], "-", "A"}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{
        SuperscriptBox["#", "2"], "&"}]}], "]"}], "-", 
     RowBox[{"A", ".", "A"}]}], "//", "Chop"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{
        SuperscriptBox["#", 
         RowBox[{"-", "1"}]], "&"}]}], "]"}], "-", 
     RowBox[{"Inverse", "[", "A", "]"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6857173034375*^9, 3.685717580828125*^9}, {
  3.685717612265625*^9, 3.685717619109375*^9}, {3.685717694515625*^9, 
  3.68571784334375*^9}, {3.685717955203125*^9, 3.685718015671875*^9}, {
  3.685718048140625*^9, 3.68571805409375*^9}, {3.68571809434375*^9, 
  3.685718143109375*^9}, {3.685718698890625*^9, 3.685718705765625*^9}, {
  3.685778281015625*^9, 3.685778284234375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dokazte", ",", " ", 
    RowBox[{
    "ze", " ", "pokud", " ", "takto", " ", "zavedeme", " ", "funkce"}], ",", 
    " ", 
    RowBox[{
    "ktere", " ", "maji", " ", "konvergentni", " ", "rozvoje", " ", "v", " ", 
     "Taylorovy", " ", "rady"}], ",", " ", 
    RowBox[{
    "tak", " ", "ze", " ", "vztahy", " ", "platne", " ", "pro", " ", "funkce",
      " ", "jedne", " ", "realne", " ", 
     RowBox[{"(", 
      RowBox[{"var", ":", " ", "komplexni"}], ")"}], "plati", " ", "i", " ", 
     "pro", " ", "prislusne", " ", "funkce", " ", "\"\<rozumnych\>\"", " ", 
     "matic"}], ",", " ", 
    RowBox[{
    "ukazeme", " ", "\"\<dukaz\>\"", " ", "s", " ", "pouzitim", " ", 
     "nahodne", " ", "matice"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Sin"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cos", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Cos"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exp", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Exp"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ln", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Log"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", 
       RowBox[{
        SuperscriptBox["#", "2"], "&"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alfa", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"beta", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "/@", 
     RowBox[{"{", 
      RowBox[{"alfa", ",", "beta"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"2", "*", "alfa"}], "]"}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"sin", "[", "alfa", "]"}], ".", 
       RowBox[{"cos", "[", "alfa", "]"}]}]}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exp", "[", 
      RowBox[{"I", "*", "alfa"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"cos", "[", "alfa", "]"}], "+", 
       RowBox[{"I", "*", 
        RowBox[{"sin", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ln", "[", 
      RowBox[{"exp", "[", "alfa", "]"}], "]"}], "-", "alfa"}], "//", "Chop"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", "alfa", "]"}], "-", 
     RowBox[{"exp", "[", 
      RowBox[{"2", "*", 
       RowBox[{"ln", "[", "alfa", "]"}]}], "]"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.68571812734375*^9, {3.685718158515625*^9, 3.685718439*^9}, {
   3.68571875828125*^9, 3.68571881184375*^9}, {3.685718849171875*^9, 
   3.685718862140625*^9}, {3.68571893453125*^9, 3.68571898603125*^9}, {
   3.685719068890625*^9, 3.685719255578125*^9}, {3.685719309890625*^9, 
   3.6857193148125*^9}, {3.685719424890625*^9, 3.6857194463125*^9}, {
   3.685719481578125*^9, 3.685719639890625*^9}, {3.6857197019375*^9, 
   3.685719722265625*^9}, {3.685719772953125*^9, 3.68571984015625*^9}, {
   3.6857198815*^9, 3.685719921453125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPoints", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", "t_", "]"}], ":=", 
   RowBox[{"alfa", "*", "t"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejCislo", "[", 
    RowBox[{"fce_", ",", "matSkalarFce_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"matSkalarFce", "@", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{
       RowBox[{"mat", "[", "t", "]"}], ",", "fce"}], "]"}]}], "//", "Re"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejPlot", "[", 
    RowBox[{"fce_", ",", "matSkalarFce_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "dats", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dats", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"vydejCislo", "[", 
            RowBox[{"fce", ",", "matSkalarFce", ",", "#"}], "]"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", "tmax", ",", 
          FractionBox["tmax", "nPoints"]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"dats", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<t\>\"", ",", "\"\<fce[t]\>\""}], "}"}]}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
        RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matSkalarFce", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{"List", "\[Rule]", "Plus"}]}], ")"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"dejPlot", "[", 
  RowBox[{"Sin", ",", "matSkalarFce"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685721060203125*^9, 3.68572114934375*^9}, {
   3.6857212245625*^9, 3.685721329890625*^9}, {3.685721372203125*^9, 
   3.68572143103125*^9}, {3.68572146984375*^9, 3.685721590953125*^9}, {
   3.685721631421875*^9, 3.6857219174375*^9}, {3.685721992484375*^9, 
   3.685722109234375*^9}, 3.68572218078125*^9, 3.6857223648125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"co", " ", "takhle", " ", "vyzkouset"}], ",", " ", 
    RowBox[{"neni", "-", 
     RowBox[{"li", " ", "duvodem"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "ze", " ", "nejsou", " ", "stejne", " ", "diagonalni", " ", "matice", 
       " ", "a", " ", "transformacni", " ", "matice", " ", "P"}], "..."}], 
     " ", "za", " ", 
     RowBox[{"body", ":", " ", 
      RowBox[{"najdete", " ", "ruzne", " ", "matice"}]}]}], ",", 
    RowBox[{
    "ntere", " ", "maji", " ", "stejny", " ", "Eigensystem", " ", "a", " ", 
     "vyzkousejte", " ", "identity", " ", "pro", " ", "dve", " ", 
     RowBox[{"promenne", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", 
      RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqr", "[", "alfa", "]"}], "+", 
       RowBox[{"sqr", "[", "beta", "]"}], "+", 
       RowBox[{"2", "*", 
        RowBox[{"alfa", ".", "beta"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", 
      RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqr", "[", "alfa", "]"}], "+", 
       RowBox[{"sqr", "[", "beta", "]"}], "+", 
       RowBox[{"2", "*", 
        RowBox[{"beta", ".", "alfa"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "nepomuze", " ", "ani", " ", "prehodit", " ", "poradi", " ", "matic", " ",
      "pri", " ", 
     RowBox[{"nasobeni", "!"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.6857199673125*^9, 3.685720171140625*^9}, {
  3.685720211953125*^9, 3.685720232421875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"pozor", " ", "na", " ", "zobecneni"}], ",", " ", 
    RowBox[{
    "pro", " ", "vic", " ", "promennych", " ", "to", " ", "nefunguje", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"alespon", " ", "ne", " ", "obecne"}], ")"}], "!!"}], 
      "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", "alfa", "]"}], ".", 
         RowBox[{"cos", "[", "beta", "]"}]}], "+", 
        RowBox[{
         RowBox[{"cos", "[", "alfa", "]"}], ".", 
         RowBox[{"sin", "[", "beta", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", "alfa", "]"}], ".", 
         RowBox[{"cos", "[", "beta", "]"}]}], "+", 
        RowBox[{
         RowBox[{"sin", "[", "beta", "]"}], ".", 
         RowBox[{"cos", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cos", "[", "beta", "]"}], ".", 
         RowBox[{"sin", "[", "alfa", "]"}]}], "+", 
        RowBox[{
         RowBox[{"sin", "[", "beta", "]"}], ".", 
         RowBox[{"cos", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cos", "[", "beta", "]"}], ".", 
         RowBox[{"sin", "[", "alfa", "]"}]}], "+", 
        RowBox[{
         RowBox[{"cos", "[", "alfa", "]"}], ".", 
         RowBox[{"sin", "[", "beta", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68571982896875*^9, 3.6857198339375*^9}, {
  3.6857199366875*^9, 3.68571994434375*^9}, {3.68572018003125*^9, 
  3.685720201140625*^9}}],

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", "A", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invP", "=", 
   RowBox[{"Inverse", "[", "P", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{"invP", ".", "A", ".", "P"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"diag", "//", "Chop"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", ".", "diag", ".", "invP"}], "//", "Chop"}], "//", 
  "mf"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sortByImag", "@", 
    RowBox[{"Eigenvalues", "[", "diag", "]"}]}], "-", 
   RowBox[{"sortByImag", "@", "lambdas"}]}], "//", "Chop"}]}], "Input",
 CellChangeTimes->{{3.6856865878900037`*^9, 3.6856866719837537`*^9}, {
  3.6856867147962537`*^9, 3.6856867159212537`*^9}, {3.6856867830931287`*^9, 
  3.6856868233275037`*^9}, {3.6856878857962537`*^9, 3.6856878973743787`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "linear", " ", "1", "st", " ", "order", " ", "differential", " ", 
    "equations", " ", "and", " ", "eigenvalues"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"(", GridBox[{
        {"2", "1"},
        {"1", "2"}
       }], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mrank", "=", 
     RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{"Eigensystem", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"invP", "=", 
     RowBox[{"Inverse", "[", "P", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diag", "=", 
     RowBox[{"invP", ".", "A", ".", "P"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "@", "diag"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"P", ".", "diag", ".", "invP"}], "//", "mf"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Eigenvalues", "[", "diag", "]"}], "-", "lambdas"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "#"], "[", "t", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "mrank", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"vars", ",", "t"}], "]"}], "\[Equal]", 
       RowBox[{"A", ".", "vars"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vectInitConds", "=", 
     RowBox[{"Range", "[", "mrank", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"vars", "==", "vectInitConds"}], "]"}], "/.", 
      RowBox[{"t", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expDiagMat", "=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"Diagonal", "[", 
        RowBox[{"t", "*", "diag"}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expDiagMat", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expMatA", "=", 
     RowBox[{"P", ".", "expDiagMat", ".", "invP"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"expMatA", ".", "vectInitConds"}], "//", "Simplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"eqns", ",", "initConds"}], "]"}], ",", "vars", ",", "t"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6856879851087537`*^9, 3.6856879891243787`*^9}, {
  3.6856887820931287`*^9, 3.6856887845931287`*^9}, {3.6856888571243787`*^9, 
  3.6856889788743787`*^9}, {3.6856890943587537`*^9, 3.6856892230775037`*^9}, {
  3.6856893027493787`*^9, 3.6856894558900037`*^9}, {3.6856894936087537`*^9, 
  3.6856895799212537`*^9}, {3.6856900909212537`*^9, 3.6856901037650037`*^9}, {
  3.685716804109375*^9, 3.685716804640625*^9}, {3.685716834890625*^9, 
  3.685716835421875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\"\<dukaz\>\"", " ", "ze", " ", "rovnice", " ", "n"}], "-", 
    RowBox[{
    "teho", " ", "radu", " ", "ma", " ", "stejne", " ", "koreny", " ", "jako",
      " ", "matice", " ", "vlastni", " ", "cisla"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "a", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mrank", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origEqn", "=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "mrank"}], "}"}]}], "]"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], 
        RowBox[{"mrank", "-", "1"}]], 
       RowBox[{
        SubscriptBox["a", "i"], "*", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"y", "[", "t", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "i"}], "}"}]}], "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "#"], "[", "t", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "mrank", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", 
           RowBox[{"#", "-", "1"}]], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         SubscriptBox["x", "#"], "[", "t", "]"}]}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"2", ",", "mrank"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnn", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "mrank"], "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", "1"}], "mrank"], 
        RowBox[{
         SubscriptBox["a", 
          RowBox[{"i", "-", "1"}]], "*", 
         RowBox[{
          SubscriptBox["x", "i"], "[", "t", "]"}]}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"eqnsTogether", "=", 
    RowBox[{"Append", "[", 
     RowBox[{"eqns1", ",", "eqnn"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"b", ",", "m"}], "}"}], "=", 
    RowBox[{
     RowBox[{"CoefficientArrays", "[", 
      RowBox[{"eqnsTogether", ",", "vars"}], "]"}], "//", "Normal"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Thread", "[", 
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      StyleBox["-",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       StyleBox["m",
        FontColor->RGBColor[1, 0, 0]], ".", "vars"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"-", "m"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "A"}], "\[IndentingNewLine]", 
   RowBox[{"Det", "[", 
    RowBox[{"A", "-", 
     RowBox[{"\[Lambda]", "*", 
      RowBox[{"IdentityMatrix", "[", "mrank", "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"origEqn", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "n_", "]"}], "[", "y", "]"}], "[", "t", 
         "]"}], ")"}], "\[RuleDelayed]", 
       SuperscriptBox["\[Lambda]", "n"]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "\[Rule]", "1"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6856900526868787`*^9, 3.6856900768275037`*^9}, {
   3.6856901143743787`*^9, 3.6856901688118787`*^9}, {3.6856902096087537`*^9, 
   3.6856902544056287`*^9}, {3.6856902874993787`*^9, 
   3.6856903959368787`*^9}, {3.6856904347337537`*^9, 
   3.6856905076556287`*^9}, {3.6856906767181287`*^9, 3.6856907117962537`*^9}, 
   3.6856908119837537`*^9, {3.6856908506556287`*^9, 3.6856908637337537`*^9}, 
   3.6856909850150037`*^9, {3.6856910239525037`*^9, 3.6856910608118787`*^9}, {
   3.6856911028587537`*^9, 3.6856911685150037`*^9}, {3.6856912122806287`*^9, 
   3.6856915537806287`*^9}, {3.6856918025306287`*^9, 
   3.6856918052493787`*^9}, {3.68571709028125*^9, 3.685717130453125*^9}, 
   3.6857224233125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"matice", " ", "a", " ", "slozky"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dosa", "=", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "2", "*", 
         FractionBox["Pi", "3."]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"1", "1", "1"},
         {"1", 
          SuperscriptBox["a", "2"], "a"},
         {"1", "a", 
          SuperscriptBox["a", "2"]}
        }], ")"}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"invT", "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], 
       RowBox[{"(", GridBox[{
          {"1", "1", "1"},
          {"1", "a", 
           SuperscriptBox["a", "2"]},
          {"1", 
           SuperscriptBox["a", "2"], "a"}
         }], ")"}]}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Inverse", "[", "T", "]"}], "-", "invT"}], "//", "Simplify"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6856932708743787`*^9, 3.6856932786087537`*^9}, {
   3.6856933219056287`*^9, 3.6856934819368787`*^9}, {3.6856940138743787`*^9, 
   3.6856940630931287`*^9}, {3.68577487578125*^9, 3.685774904515625*^9}, {
   3.6857749355*^9, 3.685774974375*^9}, 3.685775304109375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"impedances", "=", 
   RowBox[{"{", 
    RowBox[{"Zv", ",", "Z1", ",", "Z2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matZ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"RotateRight", "[", 
      RowBox[{"impedances", ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "2", ",", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "@", "matZ"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"transformedMatZ", "=", 
   RowBox[{"Chop", "@", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"invT", ".", "matZ", ".", "T"}], "//", "Chop"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "%"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6857750335*^9, 3.68577511096875*^9}, {
   3.6857751805625*^9, 3.685775180921875*^9}, {3.685775226671875*^9, 
   3.685775258375*^9}, {3.685775290046875*^9, 3.685775337765625*^9}, {
   3.685775392125*^9, 3.685775394625*^9}, {3.6857754278125*^9, 
   3.685775434953125*^9}, {3.685775478828125*^9, 3.6857755254375*^9}, 
   3.685775741171875*^9, {3.685778404296875*^9, 3.685778429828125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqnJthPhase", "[", "j_", "]"}], ":=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "j"], "==", 
    RowBox[{
     RowBox[{
      SubscriptBox["R", "j"], "*", 
      SubscriptBox["i", "j"]}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "3"], 
      RowBox[{
       SubscriptBox["Z", 
        RowBox[{"k", ",", "j"}]], "*", 
       SubscriptBox["i", "k"]}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqns3phases", "=", 
  RowBox[{
   RowBox[{"eqnJthPhase", "/@", 
    RowBox[{"Range", "[", "3", "]"}]}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"varsToSolve", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["i", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rhsabc", ",", "Zaux"}], "}"}], "=", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{"eqns3phases", ",", "varsToSolve"}], "]"}], "//", "Normal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zabc", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "*", "Zaux"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "Zabc"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Thread", "[", 
  RowBox[{"rhsabc", "\[Equal]", 
   RowBox[{"Zabc", ".", "varsToSolve"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.685776050640625*^9, 3.68577618884375*^9}, {
  3.685776221265625*^9, 3.685776247984375*^9}, {3.685776299640625*^9, 
  3.68577631771875*^9}, {3.68577654528125*^9, 3.68577664084375*^9}, {
  3.6857766748125*^9, 3.68577669803125*^9}, {3.68577672909375*^9, 
  3.68577676646875*^9}, {3.68577682040625*^9, 3.68577687321875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"symmetric", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["R", "_"], "\[RuleDelayed]", "R"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "k_"}]], "\[RuleDelayed]", "Zv"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "r_"}]], "\[RuleDelayed]", 
      SubscriptBox["Z", 
       RowBox[{"r", ",", "k"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ZabcSymmetric", "=", 
   RowBox[{"Zabc", "//.", "symmetric"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "ZabcSymmetric"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]voltages", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
       RowBox[{"Range", "[", "3", "]"}]}], ")"}], "->", 
     RowBox[{"\[CapitalDelta]Uf", "*", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SuperscriptBox["a", "2"], ",", "a"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalDelta]Uf", "\[Rule]", "100"}], ",", 
     RowBox[{"Zm", "\[Rule]", 
      RowBox[{"20", "I"}]}], ",", 
     RowBox[{"Zv", "\[Rule]", 
      RowBox[{"30", "I"}]}], ",", 
     RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"originalEqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"eqns3phases", "//.", "symmetric"}], ")"}], "/.", 
      "\[CapitalDelta]voltages"}], ")"}], "/.", "values"}], "/.", 
   "dosa"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", "originalEqns", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685776939578125*^9, 3.685776955171875*^9}, 
   3.68577701765625*^9, {3.685777057484375*^9, 3.685777240078125*^9}, {
   3.685777318546875*^9, 3.68577738565625*^9}, {3.685777418296875*^9, 
   3.685777423609375*^9}, {3.685778585484375*^9, 3.685778737234375*^9}, {
   3.685778768984375*^9, 3.685778801171875*^9}, {3.68577885315625*^9, 
   3.685778933078125*^9}, {3.68577916865625*^9, 3.68577920478125*^9}, {
   3.6857801846875*^9, 3.68578018596875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Zcomponents", "=", 
   RowBox[{
    RowBox[{"invT", ".", 
     RowBox[{"(", 
      RowBox[{"ZabcSymmetric", "/.", "values"}], ")"}], ".", "T"}], "//", 
    "Chop"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "Zcomponents"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"voltagesOriginal", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
        RowBox[{"Range", "[", "3", "]"}]}], "/.", "\[CapitalDelta]voltages"}],
       ")"}], "/.", "values"}], "/.", "dosa"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"voltagesComponents", "=", 
   RowBox[{
    RowBox[{"invT", ".", "voltagesOriginal"}], "//", "Chop"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"currentsComponents", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["iomn", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsComponents", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"voltagesComponents", "==", 
    RowBox[{"Zcomponents", ".", "currentsComponents"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"solComponents", "=", 
  RowBox[{
   RowBox[{"Solve", "[", "eqnsComponents", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"originalCurrents", "=", 
  RowBox[{"T", ".", 
   RowBox[{"(", 
    RowBox[{"currentsComponents", "/.", "solComponents"}], 
    ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.68577954978125*^9, 3.685779657765625*^9}, {
  3.6857797485625*^9, 3.685779836015625*^9}, {3.685779947578125*^9, 
  3.685780075875*^9}, {3.685780120078125*^9, 3.685780121875*^9}, {
  3.68578017075*^9, 3.68578017721875*^9}, {3.685780214890625*^9, 
  3.6857802251875*^9}, {3.685780367890625*^9, 3.68578038203125*^9}}]
},
WindowSize->{1032, 694},
WindowMargins->{{27, Automatic}, {Automatic, 0}},
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 478, 13, 71, "Input"],
Cell[1038, 35, 875, 20, 152, "Input"],
Cell[1916, 57, 1337, 41, 179, "Input"],
Cell[3256, 100, 1752, 43, 341, "Input"],
Cell[5011, 145, 2857, 76, 482, "Input"],
Cell[7871, 223, 3844, 103, 587, "Input"],
Cell[11718, 328, 2413, 64, 418, "Input"],
Cell[14134, 394, 1793, 48, 260, "Input"],
Cell[15930, 444, 2348, 71, 179, "Input"],
Cell[18281, 517, 1586, 42, 287, "Input"],
Cell[19870, 561, 3376, 93, 549, "Input"],
Cell[23249, 656, 4272, 120, 512, "Input"],
Cell[27524, 778, 1474, 44, 321, "Input"],
Cell[29001, 824, 1163, 30, 152, "Input"],
Cell[30167, 856, 1739, 49, 247, "Input"],
Cell[31909, 907, 2633, 71, 238, "Input"],
Cell[34545, 980, 1855, 50, 233, "Input"]
}
]
*)

(* End of internal cache information *)
