V            
     A      4   Gh   h    x   x   G       P   8    8   xG G    (*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       152,          0]
NotebookDataLength[    376494,       7391]
NotebookOptionsPosition[    375001,       7340]
NotebookOutlinePosition[    375757,       7366]
CellTagsIndexPosition[    375714,       7363]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"Solve", "::", "\"\<svars\>\""}], ",", 
    RowBox[{"Power", "::", "\"\<infy\>\""}], ",", 
    RowBox[{"\[Infinity]", "::", "\"\<indet\>\""}], ",", 
    RowBox[{"N", "::", "\"\<meprec\>\""}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.440868711166557*^9, 3.4408687171151104`*^9}, {
  3.443200529899627*^9, 3.443200546279627*^9}, {3.4434648403546*^9, 
  3.4434648413529997`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.449849037057*^9, 3.4498490460738*^9}, {
   3.68526646828125*^9, 3.685266470453125*^9}, 3.75418892971875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"l", ",", "c", ",", "sh", ",", "patt"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thicky", "[", "gen_", "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"0.1", "*", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"gen", "+", "2"}], ")"}], "2"]}]}], ")"}], "/", "300."}], 
    ",", "0"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{"inf", ":", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "gen___"}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"inf", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "1", "]"}], ",", 
        RowBox[{"Hue", "[", 
         RowBox[{"0.63", "+", 
          RowBox[{
           RowBox[{"0", "/", 
            SqrtBox["Pi"]}], "*", "gen"}]}], "]"}], ",", 
        RowBox[{"Thickness", "[", 
         RowBox[{"0.006", "+", 
          RowBox[{"0", "*", 
           RowBox[{"thicky", "[", "gen", "]"}]}]}], "]"}], ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
      "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgx", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgy", "=", "rgx"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"patt", ":=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_Graphics"}], "}"}], ",", "Infinity"}], "]"}], 
     "]"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jpatt", ":=", 
   RowBox[{
    RowBox[{"Length", "@", 
     RowBox[{"patt", "@", "#"}]}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sh", "[", "xxx_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{"p", "=", 
       RowBox[{
        RowBox[{"patt", "[", "xxx", "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_", ",", "b_Graphics"}], "}"}], ":>", "b"}]}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Background", "\[Rule]", "White"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "rgx"}], ",", "rgx"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "rgy"}], ",", "rgy"}], "}"}]}], "}"}]}]}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"c", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"c", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", ".5", ",", "0"}], "}"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"c", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}]}], 
    "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.440265160652608*^9, 3.440265429258845*^9}, {
   3.4402658702329345`*^9, 3.4402660953566465`*^9}, {3.440266361349125*^9, 
   3.440266361849845*^9}, {3.4407000860730095`*^9, 3.440700136004808*^9}, {
   3.4407001781754465`*^9, 3.4407002074976096`*^9}, {3.4407002771677904`*^9, 
   3.440700367287376*^9}, {3.4407005387138753`*^9, 3.440700606851853*^9}, {
   3.440700759992058*^9, 3.440700765680237*^9}, {3.440700813398853*^9, 
   3.4407008452346306`*^9}, {3.4407010575399103`*^9, 
   3.4407011032556467`*^9}, {3.440701494287923*^9, 3.44070150076724*^9}, {
   3.4407015507591248`*^9, 3.4407016585140686`*^9}, {3.4407019009827213`*^9, 
   3.440701924095957*^9}, {3.440702073120243*^9, 3.4407021100733795`*^9}, {
   3.440702144633074*^9, 3.440702150501512*^9}, {3.4407021829081106`*^9, 
   3.4407021940240946`*^9}, {3.440702365730997*^9, 3.4407024075210876`*^9}, {
   3.4407026800028973`*^9, 3.4407026892662177`*^9}, {3.440703302758376*^9, 
   3.440703323958861*^9}, {3.4407065143063555`*^9, 3.440706514746989*^9}, {
   3.4407075131225824`*^9, 3.4407075179194803`*^9}, 3.440707548543515*^9, 
   3.440781100084526*^9, {3.440860618660104*^9, 3.44086064193357*^9}, {
   3.440860792189627*^9, 3.4408608102956624`*^9}, {3.4408613064390817`*^9, 
   3.440861342070317*^9}, {3.4408614400311775`*^9, 3.4408614411628046`*^9}, {
   3.4408614805294113`*^9, 3.4408614936082177`*^9}, {3.4408615796018705`*^9, 
   3.440861579892288*^9}, 3.440861623134467*^9, {3.4408616818589087`*^9, 
   3.440861687927635*^9}, {3.4408617366076336`*^9, 3.4408617510984707`*^9}, {
   3.440861781101613*^9, 3.440861881796405*^9}, {3.440861925138728*^9, 
   3.440861982851715*^9}, {3.4408620157590337`*^9, 3.4408620658110046`*^9}, {
   3.4408623082295856`*^9, 3.4408623789312496`*^9}, {3.4408624823699875`*^9, 
   3.440862507726448*^9}, {3.440863300346179*^9, 3.4408633029098654`*^9}, {
   3.440866897708933*^9, 3.440867111566445*^9}, {3.4408671496612225`*^9, 
   3.4408671500918417`*^9}, {3.4408671912610397`*^9, 
   3.4408672395204334`*^9}, {3.4408672983750625`*^9, 3.440867299176214*^9}, {
   3.440869342474333*^9, 3.440869343535859*^9}, {3.4408694807231245`*^9, 
   3.4408694817145505`*^9}, {3.441045213119059*^9, 3.4410452181362734`*^9}, 
   3.44104679086775*^9, {3.4431067508416204`*^9, 3.443106782867672*^9}, {
   3.443106942346992*^9, 3.443107000049965*^9}, {3.4431071286448755`*^9, 
   3.4431071960518017`*^9}, {3.4431073739776464`*^9, 
   3.4431073744082656`*^9}, {3.4431090404338927`*^9, 3.443109108521798*^9}, {
   3.4431145674080286`*^9, 3.443114570862997*^9}, 3.4431146809212527`*^9, 
   3.443114791510272*^9, {3.4431149586606226`*^9, 3.44311496245608*^9}, {
   3.4431150074307504`*^9, 3.443115028250688*^9}, {3.443115247886509*^9, 
   3.4431152521726723`*^9}, {3.4431154891634483`*^9, 
   3.4431154933494673`*^9}, {3.4431155362912145`*^9, 
   3.4431155629795904`*^9}, {3.443115599972784*^9, 3.443115604309019*^9}, {
   3.4431161190792227`*^9, 3.4431161283926144`*^9}, {3.4431162599417725`*^9, 
   3.443116278408326*^9}, {3.443116578599981*^9, 3.4431165827259135`*^9}, {
   3.443116764967965*^9, 3.4431168300114927`*^9}, {3.4431173526930723`*^9, 
   3.443117354195232*^9}, {3.443117385019555*^9, 3.443117423795312*^9}, 
   3.443117471674158*^9, {3.443122020074437*^9, 3.4431220258827887`*^9}, {
   3.443122084216669*^9, 3.4431221031739283`*^9}, {3.443122911506253*^9, 
   3.443122913068499*^9}, {3.4431230058919725`*^9, 3.443123007404147*^9}, {
   3.443167996264425*^9, 3.443167996451625*^9}, {3.4431680590856247`*^9, 
   3.4431680691632247`*^9}, {3.443168273242425*^9, 3.4431683014472246`*^9}, {
   3.4431686077688246`*^9, 3.4431686527280245`*^9}, {3.4431697922324*^9, 
   3.4431698381432*^9}, {3.4431698773616*^9, 3.443169907454*^9}, {
   3.4431702436956*^9, 3.4431702565188*^9}, 3.4431704632344*^9, {
   3.4431710961888*^9, 3.4431711205872*^9}, {3.443171230302*^9, 
   3.4431712573368*^9}, 3.4431720149664*^9, {3.4431720852756*^9, 
   3.4431720966948*^9}, {3.4431721595004*^9, 3.4431721625892*^9}, {
   3.4431721958952*^9, 3.443172211698*^9}, {3.443172242508*^9, 
   3.4431722495592003`*^9}, {3.4431722799666*^9, 3.4431722801070004`*^9}, {
   3.4431723347382*^9, 3.4431723348942003`*^9}, 3.443194389599227*^9, {
   3.4438848370724*^9, 3.4438848782096*^9}, {3.4498488471884003`*^9, 
   3.4498488615404*^9}, {3.4498489158752003`*^9, 3.4498489190888*^9}, {
   3.4498489577144003`*^9, 3.4498489608968*^9}, {3.4498492003733997`*^9, 
   3.449849203119*^9}, {3.4498494232974*^9, 3.449849429631*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "OurSolve", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]", "=", ".2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OurSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xs1_", ",", "ys1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"xs2_", ",", "ys2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]xs", ",", "\[CapitalDelta]ys", ",", "pr", ",", "a", ",",
        "b", ",", "c", ",", "disk", ",", "x1", ",", "y1", ",", "x2", ",", 
       "y2", ",", "yx", ",", "x", ",", "px", ",", "ay", ",", "by", ",", "cy", 
       ",", "disky", ",", "yy1", ",", "yy2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]xs", "=", 
       RowBox[{"xs1", "-", "xs2"}]}], ";", 
      RowBox[{"\[CapitalDelta]ys", "=", 
       RowBox[{"ys1", "-", "ys2"}]}], ";", 
      RowBox[{"pr", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["\[CapitalDelta]xs", "2"], "+", 
           SuperscriptBox["\[CapitalDelta]ys", "2"]}], ">", "4"}], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", "\[CapitalDelta]xs", "]"}], "+", 
             RowBox[{"Abs", "[", "\[CapitalDelta]ys", "]"}]}], "<", 
            "\[Delta]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"xs1", ",", "ys1"}], "}"}], "+", 
              RowBox[{"{", 
               RowBox[{"xs2", ",", "ys2"}], "}"}]}], ")"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Abs", "[", "\[CapitalDelta]ys", "]"}], ">", 
              "\[Delta]"}], ",", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"1", "+", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"xs1", "-", "xs2"}], ")"}], "2"], 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"ys1", "-", "ys2"}], ")"}], "2"]]}]}], ";", 
              RowBox[{"b", "=", 
               RowBox[{"-", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"xs1", "+", "xs2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"xs1", "-", "xs2"}], ")"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"ys1", "-", "ys2"}], ")"}], "2"]}], ")"}]}], 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"ys1", "-", "ys2"}], ")"}], "2"]]}]}], ";", 
              RowBox[{"c", "=", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["xs1", "2"]}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["xs2", "2"]}], "+", 
                  FractionBox[
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["xs1", "2"], "-", 
                    SuperscriptBox["xs2", "2"]}], ")"}], "2"], 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"ys1", "-", "ys2"}], ")"}], "2"]], "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"ys1", "-", "ys2"}], ")"}], "2"]}], ")"}]}]}], 
              ";", 
              RowBox[{"disk", "=", 
               RowBox[{"Re", "[", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["b", "2"], "-", 
                  RowBox[{"4", "*", "a", "*", "c"}]}]], "]"}]}], ";", 
              RowBox[{"x1", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"-", "b"}], "+", "disk"}], 
                RowBox[{"2", "*", "a"}]]}], ";", 
              RowBox[{"x2", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"-", "b"}], "-", "disk"}], 
                RowBox[{"2", "*", "a"}]]}], ";", 
              RowBox[{"yx", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "x", " ", "xs1"}], "+", 
                 SuperscriptBox["xs1", "2"], "+", 
                 RowBox[{"2", " ", "x", " ", "xs2"}], "-", 
                 SuperscriptBox["xs2", "2"], "+", 
                 SuperscriptBox["ys1", "2"], "-", 
                 SuperscriptBox["ys2", "2"]}], 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"ys1", "-", "ys2"}], ")"}]}]]}], ";", 
              RowBox[{"y1", "=", 
               RowBox[{"yx", "/.", 
                RowBox[{"x", "\[Rule]", "x1"}]}]}], ";", 
              RowBox[{"y2", "=", 
               RowBox[{"yx", "/.", 
                RowBox[{"x", "\[Rule]", "x2"}]}]}], ";", 
              RowBox[{"Union", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "y1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"px", "=", 
               FractionBox[
                RowBox[{"xs1", "+", "xs2"}], "2"]}], ";", 
              RowBox[{"ay", "=", "1"}], ";", 
              RowBox[{"by", "=", 
               RowBox[{
                RowBox[{"-", "2"}], " ", "ys1"}]}], ";", 
              RowBox[{"cy", "=", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"xs1", "-", "xs2"}], ")"}], "2"]}], "+", 
                SuperscriptBox["ys1", "2"]}]}], ";", 
              RowBox[{"disky", "=", 
               RowBox[{"Re", "[", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["by", "2"], "-", 
                  RowBox[{"4", "*", "ay", "*", "cy"}]}]], "]"}]}], ";", 
              RowBox[{"yy1", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"-", "by"}], "+", "disky"}], 
                RowBox[{"2", "*", "ay"}]]}], ";", 
              RowBox[{"yy2", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"-", "by"}], "-", "disky"}], 
                RowBox[{"2", "*", "ay"}]]}], ";", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"px", ",", "yy1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"px", ",", "yy2"}], "}"}]}], "}"}]}]}], "]"}]}], 
          "]"}]}], "]"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.443200320485227*^9, 3.4432003397824273`*^9}, {
   3.443200747348027*^9, 3.443200753666027*^9}, {3.443201094307627*^9, 
   3.4432011186592274`*^9}, {3.443201163587227*^9, 3.4432011897484274`*^9}, {
   3.4432013573080273`*^9, 3.443201367978427*^9}, 3.4433655989262*^9, {
   3.443365635633*^9, 3.4433656834782*^9}, {3.4433659580382*^9, 
   3.4433660584554*^9}, {3.4433661089994*^9, 3.4433662747806*^9}, {
   3.4433663247785997`*^9, 3.443366387475*^9}, {3.4433664391577997`*^9, 
   3.4433664850374002`*^9}, {3.4433667894245996`*^9, 
   3.4433668872209997`*^9}, {3.4433669346605997`*^9, 3.443366935737*^9}, {
   3.443366987451*^9, 3.4433670185418*^9}, {3.4433670775878*^9, 
   3.4433670988817997`*^9}, {3.4433671331549997`*^9, 
   3.4433671340754004`*^9}, {3.4433671700802*^9, 3.4433672142906*^9}, {
   3.4433672497962*^9, 3.443367537507*^9}, {3.4433675765694*^9, 
   3.4433675987682*^9}, {3.4433676298278*^9, 3.4433676746622*^9}, {
   3.443367766749*^9, 3.4433678203662*^9}, {3.4433678673378*^9, 
   3.4433678777586*^9}, {3.443368005975*^9, 3.4433680115598*^9}, {
   3.443425916453125*^9, 3.443425924390625*^9}, {3.44342601309375*^9, 
   3.443426037890625*^9}, {3.44342607915625*^9, 3.443426102328125*^9}, {
   3.44342615175*^9, 3.443426298390625*^9}, {3.443426360234375*^9, 
   3.4434263605625*^9}, {3.44342643590625*^9, 3.443426582296875*^9}, {
   3.443426624234375*^9, 3.443426626515625*^9}, 3.44342865234375*^9, {
   3.4434626177848*^9, 3.4434626504824*^9}, {3.4434633982216*^9, 
   3.4434634114504004`*^9}, {3.4434634457548*^9, 3.443463454834*^9}, {
   3.4434634874224*^9, 3.4434636480868*^9}, {3.4434651516526003`*^9, 
   3.4434651559894*^9}, {3.4434654975512*^9, 3.4434655142276*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "prkr", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gg", ":=", 
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prkr", "[", 
    RowBox[{"{", 
     RowBox[{"k1_", ",", "k2_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ik1", ",", "ik2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"ik1", "=", 
       RowBox[{"gg", "@", 
        RowBox[{"k1", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
      RowBox[{"ik2", "=", 
       RowBox[{"gg", "@", 
        RowBox[{"k2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], ";", 
      RowBox[{"OurSolve", "[", 
       RowBox[{"ik1", ",", "ik2"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"prkr", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"c", "[", 
     RowBox[{"{", 
      RowBox[{
       SqrtBox["3."], ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4408629493414593`*^9, 3.4408629612385664`*^9}, {
   3.440867334446931*^9, 3.4408673778092833`*^9}, {3.443108229357622*^9, 
   3.4431082715883474`*^9}, {3.443200402229227*^9, 3.4432004162536273`*^9}, 
   3.4432005773860273`*^9, {3.443200679441227*^9, 3.443200740031627*^9}, {
   3.443428675484375*^9, 3.4434286803125*^9}, {3.4434340054375*^9, 
   3.443434161546875*^9}, 3.4434647112012*^9, {3.44346646394*^9, 
   3.4434664923943996`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"fgen", "[", 
     RowBox[{"g1_", ",", "g2_"}], "]"}], "=", 
    RowBox[{
     RowBox[{"0.5", 
      RowBox[{"(", 
       RowBox[{"g1", "+", "g2"}], ")"}]}], "+", "1"}]}], ";"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.443167400250825*^9, 3.4431675356276245`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[CapitalDelta]", "}"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}], "*", 
        RowBox[{"{", 
         RowBox[{"1.", ",", "1.", ",", "0"}], "}"}]}]}], ";", 
      SqrtBox[
       RowBox[{"\[CapitalDelta]", ".", "\[CapitalDelta]"}]]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delta", "=", ".1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpr", "[", 
    RowBox[{"{", 
     RowBox[{"udelane_", ",", "neudelane_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"stejne", ",", "ruzne", ",", "nst", ",", "i"}], "}"}], ",", 
     RowBox[{
      RowBox[{"stejne", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"neudelane", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"#", ",", 
             RowBox[{"neudelane", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<", "delta"}], 
          "&"}]}], "]"}]}], ";", 
      RowBox[{"ruzne", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"neudelane", ",", "stejne"}], "]"}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Mean", "[", "stejne", "]"}], "}"}], ",", "udelane"}], 
         "]"}], ",", "ruzne"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"udelej", "[", "list_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "n", "}"}], ",", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "list", "]"}]}], ";", 
      RowBox[{
       RowBox[{
        RowBox[{"NestWhile", "[", 
         RowBox[{"zpr", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "}"}], ",", "list"}], "}"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}], "\[NotEqual]", 
            RowBox[{"{", "}"}]}], "&"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "//", "Union"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4438821693134003`*^9, 3.4438821856466*^9}, {
  3.4438845464288*^9, 3.4438845491275997`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fgen", "[", 
    RowBox[{"g1_", ",", "g2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{"g1", ",", "g2"}], "]"}], "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kaszkas", "[", 
    RowBox[{"{", 
     RowBox[{"k1_", ",", "k2_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "g1", ",", "g2", ",", "a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{"g1", "=", 
       RowBox[{"k1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", 
      RowBox[{"g2", "=", 
       RowBox[{"k2", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{
        RowBox[{"prkr", "[", 
         RowBox[{"{", 
          RowBox[{"k1", ",", "k2"}], "}"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_", ",", 
           RowBox[{"b_", "?", "NumericQ"}]}], "}"}], "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", 
           RowBox[{"fgen", "[", 
            RowBox[{"g1", ",", "g2"}], "]"}]}], "}"}]}]}]}], ";", 
      RowBox[{"patt", "[", 
       RowBox[{"c", "/@", 
        RowBox[{"udelej", "[", "p", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4407069443547344`*^9, 3.440707033042261*^9}, {
   3.4407070921472497`*^9, 3.44070716340972*^9}, 3.4407072508955183`*^9, {
   3.440867674085307*^9, 3.4408677372861853`*^9}, {3.4408677842737503`*^9, 
   3.4408678329938064`*^9}, {3.4408679877663584`*^9, 
   3.4408680036892543`*^9}, {3.4408680405923185`*^9, 
   3.4408680782064047`*^9}, {3.443108412611128*^9, 3.443108413792827*^9}, {
   3.4431094326779118`*^9, 3.443109461679614*^9}, {3.443109495518272*^9, 
   3.443109630432269*^9}, {3.4431108028381057`*^9, 3.443110804800928*^9}, 
   3.4431108511675997`*^9, 3.4431109178434753`*^9, {3.4431109495791087`*^9, 
   3.443111002675458*^9}, {3.443111078875027*^9, 3.4431111483048625`*^9}, {
   3.4431113224252353`*^9, 3.4431113235468483`*^9}, {3.4431113851153793`*^9, 
   3.4431113925060062`*^9}, {3.44311451756636*^9, 3.4431145185878286`*^9}, {
   3.4431674389076247`*^9, 3.443167455646425*^9}, {3.443195111848027*^9, 
   3.443195117214427*^9}, 3.4434645694908*^9, {3.4438822101542*^9, 
   3.4438822119482*^9}, 3.4438823288546*^9, {3.4438825512637997`*^9, 
   3.4438825873934*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kaszkasAll", "[", 
    RowBox[{"{", 
     RowBox[{"k1_", ",", "k2_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ud", ",", "pom"}], "}"}], ",", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k1", ",", "k2", ",", 
          RowBox[{"Sequence", "@@", 
           RowBox[{"kaszkas", "[", 
            RowBox[{"{", 
             RowBox[{"k1", ",", "k2"}], "}"}], "]"}]}]}], "}"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ud_", ",", "_Graphics"}], "}"}], "\[RuleDelayed]", 
         "ud"}]}]}], ";", 
      RowBox[{"patt", "[", 
       RowBox[{"c", "/@", 
        RowBox[{"udelej", "[", "pom", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.443109359903267*^9, 3.443109399950853*^9}, {
  3.4438824323918*^9, 3.443882454341*^9}, {3.4438825001426*^9, 
  3.4438825091438*^9}, {3.4438826225246*^9, 3.4438826913986*^9}, {
  3.443882766731*^9, 3.4438828490678*^9}, {3.4438829052746*^9, 
  3.443882951981*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zmnozKas", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zmnozKas", "[", "kas_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "ud", ",", "tu"}], "}"}], ",", 
     RowBox[{
      RowBox[{"p", "=", 
       RowBox[{
        RowBox[{"patt", "[", 
         RowBox[{"kaszkasAll", "/@", 
          RowBox[{"Tuples", "[", 
           RowBox[{"kas", ",", "2"}], "]"}]}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ud_", ",", "_Graphics"}], "}"}], "\[RuleDelayed]", 
         "ud"}]}]}], ";", 
      RowBox[{"patt", "[", 
       RowBox[{"c", "/@", 
        RowBox[{"udelej", "[", "p", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4408684220107713`*^9, 3.4408685833127117`*^9}, 
   3.4408686906971235`*^9, {3.440868741229786*^9, 3.440868782579243*^9}, 
   3.4408691464624815`*^9, {3.443111329455344*^9, 3.4431113342822847`*^9}, 
   3.44311446398932*^9, {3.443195137712827*^9, 3.443195143313227*^9}, {
   3.4434641934004*^9, 3.4434641947732*^9}, {3.4438830189674*^9, 
   3.4438830656582003`*^9}, {3.443883143705*^9, 3.4438831571678*^9}, {
   3.443883371075*^9, 3.4438833728066*^9}, {3.4438834932386*^9, 
   3.4438835018654003`*^9}, {3.4438835593826*^9, 3.4438835778218*^9}, {
   3.443883619973*^9, 3.4438836584426003`*^9}, 3.4438837026686*^9, {
   3.4438837355066*^9, 3.4438837364894*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "line", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b1", ":", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "y1_"}], "}"}]}], ",", 
        RowBox[{"b2", ":", 
         RowBox[{"{", 
          RowBox[{"x2_", ",", "y2_"}], "}"}]}]}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "nL", ",", "sv", ",", "parfce", ",", "t", ",", "inf", ",", "cosfi"}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"nL", "=", 
         RowBox[{"Norm", "[", 
          RowBox[{"b1", "-", "b2"}], "]"}]}], ";", 
        RowBox[{"sv", "=", 
         RowBox[{"b1", "-", "b2"}]}], ";", 
        RowBox[{"parfce", ":=", 
         RowBox[{
          RowBox[{"b1", "+", 
           RowBox[{"#", "*", "sv"}]}], "&"}]}], ";", 
        RowBox[{"t", "=", 
         RowBox[{"Norm", "[", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["rgx", "nL"], ",", 
            FractionBox["rgx", "nL"]}], "}"}], "]"}]}], ";", 
        RowBox[{"inf", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"parfce", "[", 
            RowBox[{"-", "t"}], "]"}], ",", 
           RowBox[{"parfce", "[", "t", "]"}]}], "}"}]}], ";", 
        RowBox[{"cosfi", "=", 
         FractionBox[
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ".", "sv"}], 
          RowBox[{"Norm", "[", "sv", "]"}]]}], ";", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"cosfi", ",", "inf"}], "}"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
             RowBox[{"Line", "[", "inf", "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "//", 
     "sh"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4498457224586*^9, 3.449845954961*^9}, {
   3.4498459947722*^9, 3.4498462197553997`*^9}, {3.4498462676474*^9, 
   3.4498463757086*^9}, {3.4498464402458*^9, 3.4498465476362*^9}, {
   3.4498465986949997`*^9, 3.4498467201566*^9}, {3.4498473271244*^9, 
   3.4498474588664*^9}, {3.4498474934672003`*^9, 3.4498475002376003`*^9}, {
   3.4498476852848*^9, 3.449847695612*^9}, {3.4498477258915997`*^9, 
   3.4498477960448*^9}, 3.4498481980411997`*^9, {3.4498487462096*^9, 
   3.4498487467088003`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pooom", "=", 
   RowBox[{"Nest", "[", 
    RowBox[{"zmnozKas", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"c", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"Sqrt", "[", "3", "]"}], ",", "0"}], "}"}], "]"}]}], "}"}], 
     ",", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "sh"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"stredy", "=", 
   RowBox[{"pooom", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", "d_Graphics"}], 
      "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]p", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dvojice", "=", 
   RowBox[{
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Tuples", "[", 
       RowBox[{"stredy", ",", "2"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[GreaterEqual]", 
        "\[CapitalDelta]p"}], "&"}]}], "]"}], "//", "Chop"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lines", "=", 
   RowBox[{"line", "/@", "dvojice"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "//", "sh"}]}], "Input",
 CellChangeTimes->{{3.4431154114116464`*^9, 3.443115454814056*^9}, 
   3.4431165407455487`*^9, 3.4431653385944*^9, {3.4431653795288*^9, 
   3.4431653929136*^9}, {3.4431654241292*^9, 3.4431655156232*^9}, {
   3.443166916619625*^9, 3.443166985150425*^9}, {3.4431670389392247`*^9, 
   3.4431670542584248`*^9}, 3.443167232566425*^9, 3.443167306260825*^9, {
   3.443167520261625*^9, 3.443167642908825*^9}, {3.443167679943225*^9, 
   3.443167689974025*^9}, {3.443167750845225*^9, 3.443167750954425*^9}, {
   3.4431678162092247`*^9, 3.443167899544425*^9}, {3.4431680122232246`*^9, 
   3.443168026466025*^9}, {3.4431680876648245`*^9, 3.443168116649625*^9}, {
   3.4431683602280245`*^9, 3.443168362614825*^9}, {3.443168469646425*^9, 
   3.443168506103625*^9}, {3.4431685418588247`*^9, 3.443168593182825*^9}, 
   3.4431687203072248`*^9, 3.4431688012868247`*^9, {3.44316996026*^9, 
   3.4431699625220003`*^9}, 3.4431707321940002`*^9, {3.4431711779016*^9, 
   3.4431711878856*^9}, {3.4431713007827997`*^9, 3.4431713359452*^9}, 
   3.4431715001352*^9, {3.4431715884779997`*^9, 3.443171678568*^9}, {
   3.4431717531672*^9, 3.4431717533232*^9}, {3.4431719695392*^9, 
   3.4431719940624*^9}, {3.4431723532086*^9, 3.4431723566562*^9}, 
   3.4431723962354*^9, {3.443172456467*^9, 3.443172526901*^9}, {
   3.4431725881778*^9, 3.4431725997841997`*^9}, {3.4431726865358*^9, 
   3.4431727294202003`*^9}, {3.4431727948812*^9, 3.4431728152236*^9}, {
   3.4431740482008*^9, 3.443174086218*^9}, {3.4431742803599997`*^9, 
   3.4431742870836*^9}, {3.4431743436492*^9, 3.4431743899812*^9}, {
   3.4431748293396*^9, 3.4431749285556*^9}, {3.4431813872832003`*^9, 
   3.4431814537860003`*^9}, {3.443182760756*^9, 3.4431827886176*^9}, {
   3.4431940473196273`*^9, 3.4431941033860273`*^9}, {3.4431941460208273`*^9, 
   3.4431941594212275`*^9}, {3.443194556347627*^9, 3.443194657498027*^9}, {
   3.4431947452168274`*^9, 3.4431947463088274`*^9}, 3.443195260110427*^9, 
   3.4431953004832273`*^9, {3.443195667286027*^9, 3.443195732400427*^9}, {
   3.4431958455160275`*^9, 3.4431958778080273`*^9}, {3.443196028254427*^9, 
   3.443196266450827*^9}, {3.4431963108952274`*^9, 3.443196355542427*^9}, {
   3.4434640115824003`*^9, 3.4434640605664*^9}, {3.4434642094996*^9, 
   3.4434642112*^9}, 3.4434642511828003`*^9, 3.4434645232836*^9, {
   3.4434645986004*^9, 3.4434646449323997`*^9}, {3.4434646800792*^9, 
   3.4434646834175997`*^9}, {3.4434647832264*^9, 3.4434647982024*^9}, {
   3.443464880119*^9, 3.443464889791*^9}, 3.4434650718274*^9, {
   3.4434651400150003`*^9, 3.4434651967678003`*^9}, {3.4434655276436*^9, 
   3.4434655837567997`*^9}, 3.4434665581952*^9, 3.4437180780254*^9, 
   3.4438830716486*^9, {3.4438837415282*^9, 3.4438837426358*^9}, 
   3.4498478850584*^9, 3.4498479375056*^9, {3.4498479685652*^9, 
   3.4498479699848003`*^9}, {3.4498482092732*^9, 3.4498482225643997`*^9}, 
   3.4498483556324*^9, {3.4498483948508*^9, 3.4498485702728*^9}, {
   3.4498486077595997`*^9, 3.4498486382108*^9}, {3.4498487077088003`*^9, 
   3.4498487276612*^9}, 3.4498487710448*^9, {3.449848980584*^9, 
   3.4498490011292*^9}, {3.4498490878194*^9, 3.4498490952293997`*^9}, {
   3.449849243211*^9, 3.4498492441314*^9}, {3.4498493442366*^9, 
   3.4498493587757998`*^9}, {3.449849399835*^9, 3.4498494138438*^9}, {
   3.4498494509094*^9, 3.449849499363*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4498492767978*^9, 3.4498492798554*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<prd.png\>\"", ",", 
    GraphicsBox[{
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.5, 
         1.9624017209617517`}, {-2.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-2.5, 
         3.694452528530629}, {-2.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2, 2 2^Rational[1, 2]}, {-2, (-2) 
           2^Rational[1, 2]}}, {{-2, 
           2.8284271247461903`}, {-2, -2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.5, 
         1.9624017209617517`}, {-1.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.5, 
         3.694452528530629}, {-1.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, 2 2^Rational[1, 2]}, {-1, (-2) 
           2^Rational[1, 2]}}, {{-1, 
           2.8284271247461903`}, {-1, -2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, 2 2^Rational[1, 2] - 3^
           Rational[1, 2]}, {-1, (-2) 2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1, 
           1.096376317177313}, {-1, -4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, 2 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1, (-2) 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1, 
           4.5604779323150675`}, {-1, -1.096376317177313}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.5, 
         1.9624017209617517`}, {-0.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.5, 
         3.694452528530629}, {-0.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, 2 2^Rational[1, 2]}, {
          0, (-2) 2^Rational[1, 2]}}, {{0, 2.8284271247461903`}, {
          0, -2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, 2 2^Rational[1, 2] - 3^Rational[1, 2]}, {
          0, (-2) 2^Rational[1, 2] - 3^Rational[1, 2]}}, {{
          0, 1.096376317177313}, {0, -4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, 2 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          0, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
          0, 4.5604779323150675`}, {0, -1.096376317177313}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.5, 1.9624017209617517`}, {
         0.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.5, 3.694452528530629}, {
         0.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, 2 2^Rational[1, 2]}, {
          1, (-2) 2^Rational[1, 2]}}, {{1, 2.8284271247461903`}, {
          1, -2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, 2 2^Rational[1, 2] - 3^Rational[1, 2]}, {
          1, (-2) 2^Rational[1, 2] - 3^Rational[1, 2]}}, {{
          1, 1.096376317177313}, {1, -4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, 2 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
          1, 4.5604779323150675`}, {1, -1.096376317177313}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.5, 1.9624017209617517`}, {
         1.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.5, 3.694452528530629}, {
         1.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2, 2 2^Rational[1, 2]}, {
          2, (-2) 2^Rational[1, 2]}}, {{2, 2.8284271247461903`}, {
          2, -2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2], 2 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2], (-2) 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.5, 1.9624017209617517`}, {
         2.5, -3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{2.5, 3.694452528530629}, {
         2.5, -1.9624017209617517`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], 2^Rational[1, 2]}, {
          6^Rational[1, 2], -2^Rational[1, 2]}}, {{-2.449489742783178, 
         1.4142135623730951`}, {2.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], 2^Rational[1, 2] - 3^
           Rational[1, 2]}, {
          6^Rational[1, 2], -2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-2.449489742783178, -0.31783724519578205`}, {
         2.449489742783178, -3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2.449489742783178, 3.1462643699419726`}, {
         2.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], 2^
           Rational[1, 2]}, {-6^Rational[1, 2], -2^Rational[1, 2]}}, {{
         2.449489742783178, 
         1.4142135623730951`}, {-2.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], 2^Rational[1, 2] - 3^
           Rational[1, 2]}, {-6^Rational[1, 2], -2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{
         2.449489742783178, -0.31783724519578205`}, {-2.449489742783178, \
-3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{2.449489742783178, 
         3.1462643699419726`}, {-2.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], 2^Rational[1, 2]}, {-1 + 
           6^Rational[1, 2], -2^Rational[1, 2]}}, {{-3.449489742783178, 
         1.4142135623730951`}, {
         1.4494897427831779`, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], 2^Rational[1, 2] - 3^
           Rational[1, 2]}, {-1 + 6^Rational[1, 2], -2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-3.449489742783178, -0.31783724519578205`}, {
         1.4494897427831779`, -3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-3.449489742783178, 3.1462643699419726`}, {
         1.4494897427831779`, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.949489742783178, 
         0.5481881585886565}, {1.9494897427831779`, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-2.949489742783178, 
         2.2802389661575337`}, {1.9494897427831779`, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.9494897427831779`, 
         0.5481881585886565}, {2.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.9494897427831779`, 
         2.2802389661575337`}, {2.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.9494897427831779`, 
         4.012289773726411}, {2.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{1 - 6^Rational[1, 2], 2^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], -2^Rational[1, 2]}}, {{-1.4494897427831779`, 
         1.4142135623730951`}, {3.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 6^Rational[1, 2], 2^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], -2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.4494897427831779`, -0.31783724519578205`}, {
         3.449489742783178, -3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 6^Rational[1, 2], 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.4494897427831779`, 3.1462643699419726`}, {
         3.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.9494897427831779, 
         0.5481881585886565}, {3.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.9494897427831779, 
         2.2802389661575337`}, {3.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.9494897427831779, 
         4.012289773726411}, {3.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 6^Rational[1, 2], 2^Rational[1, 2]}, {
          2 + 6^Rational[1, 2], -2^Rational[1, 2]}}, {{-0.4494897427831779, 
         1.4142135623730951`}, {4.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 6^Rational[1, 2], 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.4494897427831779, 3.1462643699419726`}, {
         4.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.05051025721682212, 
         0.5481881585886565}, {4.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.05051025721682212, 
         2.2802389661575337`}, {4.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.05051025721682212, 
         4.012289773726411}, {4.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.05051025721682212, 
         0.5481881585886565}, {-4.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.05051025721682212, 
         2.2802389661575337`}, {-4.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.05051025721682212, 
         4.012289773726411}, {-4.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 6^Rational[1, 2], 2^Rational[1, 2]}, {-2 - 6^
           Rational[1, 2], -2^Rational[1, 2]}}, {{0.4494897427831779, 
         1.4142135623730951`}, {-4.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.4494897427831779, 
         3.1462643699419726`}, {-4.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.9494897427831779, 
         0.5481881585886565}, {-3.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.9494897427831779, 
         2.2802389661575337`}, {-3.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.9494897427831779, 
         4.012289773726411}, {-3.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], 2^Rational[1, 2]}, {-1 - 6^
           Rational[1, 2], -2^Rational[1, 2]}}, {{1.4494897427831779`, 
         1.4142135623730951`}, {-3.449489742783178, -1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], 2^Rational[1, 2] - 3^
           Rational[1, 2]}, {-1 - 6^Rational[1, 2], -2^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{
         1.4494897427831779`, -0.31783724519578205`}, {-3.449489742783178, \
-3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 - 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.4494897427831779`, 
         3.1462643699419726`}, {-3.449489742783178, 0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.9494897427831779`, 
         0.5481881585886565}, {-2.949489742783178, -2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.9494897427831779`, 
         2.2802389661575337`}, {-2.949489742783178, -0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.9494897427831779`, 
         4.012289773726411}, {-2.949489742783178, 1.1838626489802209`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.949489742783178, 
         0.5481881585886565}, {-1.9494897427831779`, \
-2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{2.949489742783178, 
         2.2802389661575337`}, {-1.9494897427831779`, \
-0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 6^Rational[1, 2], 2^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], -2^Rational[1, 2]}}, {{3.449489742783178, 
         1.4142135623730951`}, {-1.4494897427831779`, \
-1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 6^Rational[1, 2], 2^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], -2^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         3.449489742783178, -0.31783724519578205`}, {-1.4494897427831779`, \
-3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 6^Rational[1, 2], 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], -2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         3.449489742783178, 3.1462643699419726`}, {-1.4494897427831779`, 
         0.31783724519578205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 2^Rational[1, 2], 0}, {
          2 2^Rational[1, 2], 0}}, {{-2.8284271247461903`, 0}, {
          2.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 2^Rational[1, 2], -3^Rational[1, 2]}, {
          2 2^Rational[1, 2], -3^
            Rational[1, 2]}}, {{-2.8284271247461903`, -1.7320508075688772`}, {
         2.8284271247461903`, -1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 2^Rational[1, 2], 3^Rational[1, 2]}, {
          2 2^Rational[1, 2], 3^Rational[1, 2]}}, {{-2.8284271247461903`, 
         1.7320508075688772`}, {2.8284271247461903`, 1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 2^Rational[1, 2], 2 3^Rational[1, 2]}, {
          2 2^Rational[1, 2], 2 3^Rational[1, 2]}}, {{-2.8284271247461903`, 
         3.4641016151377544`}, {2.8284271247461903`, 3.4641016151377544`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 2^Rational[1, 2], 0}, {(-2) 2^Rational[1, 2], 0}}, {{
          2.8284271247461903`, 0}, {-2.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 2^Rational[1, 2], -3^Rational[1, 2]}, {(-2) 
           2^Rational[1, 2], -3^Rational[1, 2]}}, {{
         2.8284271247461903`, -1.7320508075688772`}, {-2.8284271247461903`, \
-1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 2^Rational[1, 2], 3^Rational[1, 2]}, {(-2) 2^Rational[1, 2], 3^
           Rational[1, 2]}}, {{2.8284271247461903`, 
         1.7320508075688772`}, {-2.8284271247461903`, 
         1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 2^Rational[1, 2], 2 3^Rational[1, 2]}, {(-2) 2^Rational[1, 2], 2 
           3^Rational[1, 2]}}, {{2.8284271247461903`, 
         3.4641016151377544`}, {-2.8284271247461903`, 
         3.4641016151377544`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{-4.32842712474619, -0.8660254037844386}, {
         1.3284271247461903`, -0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{-4.32842712474619, 0.8660254037844386}, {
         1.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{-4.32842712474619, 2.598076211353316}, {
         1.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2 2^Rational[1, 2], 0}, {-1 + 2 2^Rational[1, 2],
            0}}, {{-3.8284271247461903`, 0}, {1.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2 2^Rational[1, 2], 3^Rational[1, 2]}, {-1 + 
           2 2^Rational[1, 2], 3^Rational[1, 2]}}, {{-3.8284271247461903`, 
         1.7320508075688772`}, {1.8284271247461903`, 1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{-3.3284271247461903`, -0.8660254037844386}, {
         2.3284271247461903`, -0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{-3.3284271247461903`, 0.8660254037844386}, {
         2.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{-3.3284271247461903`, 2.598076211353316}, {
         2.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{-2.3284271247461903`, -0.8660254037844386}, {
         3.3284271247461903`, -0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{-2.3284271247461903`, 0.8660254037844386}, {
         3.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{-2.3284271247461903`, 2.598076211353316}, {
         3.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2 2^Rational[1, 2], 0}, {
          1 + 2 2^Rational[1, 2], 0}}, {{-1.8284271247461903`, 0}, {
          3.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2 2^Rational[1, 2], -3^Rational[1, 2]}, {
          1 + 2 2^Rational[1, 2], -3^
            Rational[1, 2]}}, {{-1.8284271247461903`, -1.7320508075688772`}, {
         3.8284271247461903`, -1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2 2^Rational[1, 2], 3^Rational[1, 2]}, {
          1 + 2 2^Rational[1, 2], 3^Rational[1, 2]}}, {{-1.8284271247461903`, 
         1.7320508075688772`}, {3.8284271247461903`, 1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2 2^Rational[1, 2], 2 3^Rational[1, 2]}, {
          1 + 2 2^Rational[1, 2], 2 
           3^Rational[1, 2]}}, {{-1.8284271247461903`, 3.4641016151377544`}, {
         3.8284271247461903`, 3.4641016151377544`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{-1.3284271247461903`, -0.8660254037844386}, {
         4.32842712474619, -0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{-1.3284271247461903`, 0.8660254037844386}, {
         4.32842712474619, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{-1.3284271247461903`, 2.598076211353316}, {
         4.32842712474619, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 2 2^Rational[1, 2], 0}, {
          2 + 2 2^Rational[1, 2], 0}}, {{-0.8284271247461903, 0}, {
          4.82842712474619, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 2 2^Rational[1, 2], 3^Rational[1, 2]}, {
          2 + 2 2^Rational[1, 2], 3^Rational[1, 2]}}, {{-0.8284271247461903, 
         1.7320508075688772`}, {4.82842712474619, 1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[5, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{-0.3284271247461903, -0.8660254037844386}, {
         5.32842712474619, -0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[5, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{-0.3284271247461903, 0.8660254037844386}, {
         5.32842712474619, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[5, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{-0.3284271247461903, 2.598076211353316}, {
         5.32842712474619, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[-5, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{
         0.3284271247461903, -0.8660254037844386}, {-5.32842712474619, \
-0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{0.3284271247461903, 
         0.8660254037844386}, {-5.32842712474619, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{0.3284271247461903, 
         2.598076211353316}, {-5.32842712474619, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2 2^Rational[1, 2], 0}, {-2 - 2 2^Rational[1, 2],
            0}}, {{0.8284271247461903, 0}, {-4.82842712474619, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2 2^Rational[1, 2], 3^Rational[1, 2]}, {-2 - 2 
           2^Rational[1, 2], 3^Rational[1, 2]}}, {{0.8284271247461903, 
         1.7320508075688772`}, {-4.82842712474619, 1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{
         1.3284271247461903`, -0.8660254037844386}, {-4.32842712474619, \
-0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{1.3284271247461903`, 
         0.8660254037844386}, {-4.32842712474619, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[-3, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{1.3284271247461903`, 
         2.598076211353316}, {-4.32842712474619, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 2^Rational[1, 2], 0}, {-1 - 2 2^Rational[1, 2],
            0}}, {{1.8284271247461903`, 0}, {-3.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 2^Rational[1, 2], -3^Rational[1, 2]}, {-1 - 2 
           2^Rational[1, 2], -3^Rational[1, 2]}}, {{
         1.8284271247461903`, -1.7320508075688772`}, {-3.8284271247461903`, \
-1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 2^Rational[1, 2], 3^Rational[1, 2]}, {-1 - 2 
           2^Rational[1, 2], 3^Rational[1, 2]}}, {{1.8284271247461903`, 
         1.7320508075688772`}, {-3.8284271247461903`, 
         1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 2^Rational[1, 2], 2 3^Rational[1, 2]}, {-1 - 2 
           2^Rational[1, 2], 2 3^Rational[1, 2]}}, {{1.8284271247461903`, 
         3.4641016151377544`}, {-3.8284271247461903`, 
         3.4641016151377544`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{
         2.3284271247461903`, -0.8660254037844386}, {-3.3284271247461903`, \
-0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{2.3284271247461903`, 
         0.8660254037844386}, {-3.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{2.3284271247461903`, 
         2.598076211353316}, {-3.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{
         3.3284271247461903`, -0.8660254037844386}, {-2.3284271247461903`, \
-0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{3.3284271247461903`, 
         0.8660254037844386}, {-2.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[1, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{3.3284271247461903`, 
         2.598076211353316}, {-2.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 2 2^Rational[1, 2], 0}, {
          1 - 2 2^Rational[1, 2], 0}}, {{
          3.8284271247461903`, 0}, {-1.8284271247461903`, 0}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 2 2^Rational[1, 2], 3^Rational[1, 2]}, {
          1 - 2 2^Rational[1, 2], 3^Rational[1, 2]}}, {{3.8284271247461903`, 
         1.7320508075688772`}, {-1.8284271247461903`, 
         1.7320508075688772`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[-1, 2] 
           3^Rational[1, 2]}}, {{
         4.32842712474619, -0.8660254037844386}, {-1.3284271247461903`, \
-0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}}, {{4.32842712474619, 
         0.8660254037844386}, {-1.3284271247461903`, 0.8660254037844386}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}, {
          Rational[3, 2] - 2 2^Rational[1, 2], Rational[3, 2] 
           3^Rational[1, 2]}}, {{4.32842712474619, 
         2.598076211353316}, {-1.3284271247461903`, 2.598076211353316}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], -2^Rational[1, 2]}, {
          6^Rational[1, 2], 2^
           Rational[1, 2]}}, {{-2.449489742783178, -1.4142135623730951`}, {
         2.449489742783178, 1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2.449489742783178, 0.31783724519578205`}, {
         2.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-6^Rational[1, 2], -2^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          6^Rational[1, 2], 2^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-2.449489742783178, 2.0498880527646595`}, {
         2.449489742783178, 4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], -2^Rational[1, 2]}, {-6^Rational[1, 2], 2^
           Rational[1, 2]}}, {{
         2.449489742783178, -1.4142135623730951`}, {-2.449489742783178, 
         1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{2.449489742783178, 
         0.31783724519578205`}, {-2.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          6^Rational[1, 2], -2^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-6^Rational[1, 2], 2^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{2.449489742783178, 
         2.0498880527646595`}, {-2.449489742783178, 4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], -2^Rational[1, 2]}, {-1 + 
           6^Rational[1, 2], 2^
           Rational[1, 2]}}, {{-3.449489742783178, -1.4142135623730951`}, {
         1.4494897427831779`, 1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-3.449489742783178, 0.31783724519578205`}, {
         1.4494897427831779`, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 6^Rational[1, 2], -2^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-3.449489742783178, 2.0498880527646595`}, {
         1.4494897427831779`, 4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-2.949489742783178, -0.5481881585886565}, {
         1.9494897427831779`, 2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-2.949489742783178, 
         1.1838626489802209`}, {1.9494897427831779`, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-1.9494897427831779`, -2.2802389661575337`}, {
         2.949489742783178, 0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-1.9494897427831779`, -0.5481881585886565}, {
         2.949489742783178, 2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.9494897427831779`, 
         1.1838626489802209`}, {2.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 6^Rational[1, 2], -2^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], 2^
           Rational[1, 2]}}, {{-1.4494897427831779`, -1.4142135623730951`}, {
         3.449489742783178, 1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 6^Rational[1, 2], -2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.4494897427831779`, 
         0.31783724519578205`}, {3.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 6^Rational[1, 2], -2^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.4494897427831779`, 
         2.0498880527646595`}, {3.449489742783178, 4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-0.9494897427831779, -2.2802389661575337`}, {
         3.949489742783178, 0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-0.9494897427831779, -0.5481881585886565}, {
         3.949489742783178, 2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.9494897427831779, 
         1.1838626489802209`}, {3.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 6^Rational[1, 2], -2^Rational[1, 2]}, {
          2 + 6^Rational[1, 2], 2^
           Rational[1, 2]}}, {{-0.4494897427831779, -1.4142135623730951`}, {
         4.449489742783178, 1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 6^Rational[1, 2], -2^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.4494897427831779, 0.31783724519578205`}, {
         4.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.05051025721682212, -2.2802389661575337`}, {4.949489742783178, 
         0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.05051025721682212, -0.5481881585886565}, {4.949489742783178, 
         2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.05051025721682212, 
         1.1838626489802209`}, {4.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-0.05051025721682212, -2.2802389661575337`}, \
{-4.949489742783178, 0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.05051025721682212, -0.5481881585886565}, \
{-4.949489742783178, 2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.05051025721682212, 
         1.1838626489802209`}, {-4.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 6^Rational[1, 2], -2^Rational[1, 2]}, {-2 - 6^
           Rational[1, 2], 2^Rational[1, 2]}}, {{
         0.4494897427831779, -1.4142135623730951`}, {-4.449489742783178, 
         1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.4494897427831779, 
         0.31783724519578205`}, {-4.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.9494897427831779, -2.2802389661575337`}, {-3.949489742783178, 
         0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.9494897427831779, -0.5481881585886565}, {-3.949489742783178, 
         2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.9494897427831779, 
         1.1838626489802209`}, {-3.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], -2^Rational[1, 2]}, {-1 - 6^
           Rational[1, 2], 2^Rational[1, 2]}}, {{
         1.4494897427831779`, -1.4142135623730951`}, {-3.449489742783178, 
         1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 - 6^Rational[1, 2], 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.4494897427831779`, 
         0.31783724519578205`}, {-3.449489742783178, 3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 6^Rational[1, 2], -2^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 - 6^Rational[1, 2], 2^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.4494897427831779`, 
         2.0498880527646595`}, {-3.449489742783178, 4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         1.9494897427831779`, -2.2802389661575337`}, {-2.949489742783178, 
         0.5481881585886565}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         1.9494897427831779`, -0.5481881585886565}, {-2.949489742783178, 
         2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.9494897427831779`, 
         1.1838626489802209`}, {-2.949489742783178, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         2.949489742783178, -0.5481881585886565}, {-1.9494897427831779`, 
         2.2802389661575337`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 6^Rational[1, 2], -2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 6^Rational[1, 2], 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{2.949489742783178, 
         1.1838626489802209`}, {-1.9494897427831779`, 4.012289773726411}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 6^Rational[1, 2], -2^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], 2^Rational[1, 2]}}, {{
         3.449489742783178, -1.4142135623730951`}, {-1.4494897427831779`, 
         1.4142135623730951`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 6^Rational[1, 2], -2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         3.449489742783178, 0.31783724519578205`}, {-1.4494897427831779`, 
         3.1462643699419726`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 6^Rational[1, 2], -2^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 - 6^Rational[1, 2], 2^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         3.449489742783178, 2.0498880527646595`}, {-1.4494897427831779`, 
         4.878315177510849}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-2.5, -1.9624017209617517`}, {-2.5, 
         3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[1, 2]}}, {{-2.5, -0.23035091339287428`}, {-2.5, 
         5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}, {-2, 
           2 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2, -1.096376317177313}, {-2, 
           4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-1.5, -1.9624017209617517`}, {-1.5, 
         3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[1, 2]}}, {{-1.5, -0.23035091339287428`}, {-1.5, 
         5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, (-2) 2^Rational[1, 2]}, {-1, 2 
           2^Rational[1, 2]}}, {{-1, -2.8284271247461903`}, {-1, 
           2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}, {-1, 
           2 2^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1, -1.096376317177313}, {-1, 
           4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1, (-2) 2^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1, 
           2 2^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{-1, 
           0.6356744903915641}, {-1, 6.292528739883945}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-0.5, -1.9624017209617517`}, {-0.5, 
         3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[1, 2]}}, {{-0.5, -0.23035091339287428`}, {-0.5, 
         5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, (-2) 2^Rational[1, 2]}, {
          0, 2 2^Rational[1, 2]}}, {{0, -2.8284271247461903`}, {
          0, 2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          0, 2 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
          0, -1.096376317177313}, {0, 4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{0, (-2) 2^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          0, 2 2^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
          0, 0.6356744903915641}, {0, 6.292528739883945}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.5, -1.9624017209617517`}, {
         0.5, 3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.5, -0.23035091339287428`}, {
         0.5, 5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, (-2) 2^Rational[1, 2]}, {
          1, 2 2^Rational[1, 2]}}, {{1, -2.8284271247461903`}, {
          1, 2.8284271247461903`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          1, 2 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
          1, -1.096376317177313}, {1, 4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1, (-2) 2^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1, 2 2^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
          1, 0.6356744903915641}, {1, 6.292528739883945}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.5, -1.9624017209617517`}, {
         1.5, 3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.5, -0.23035091339287428`}, {
         1.5, 5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2, (-2) 2^Rational[1, 2] + 3^Rational[1, 2]}, {
          2, 2 2^Rational[1, 2] + 3^Rational[1, 2]}}, {{
          2, -1.096376317177313}, {2, 4.5604779323150675`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2], (-2) 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2], 2 2^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{2.5, -1.9624017209617517`}, {
         2.5, 3.694452528530629}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2], (-2) 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2], 2 2^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{2.5, -0.23035091339287428`}, {
         2.5, 5.426503336099506}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 10 Rational[2, 37]^Rational[1, 2], 
           4 Rational[6, 37]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           10 Rational[2, 37]^Rational[1, 2], (-4) 
            Rational[6, 37]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.17504722512361415`, 
         0.7447491287292198}, {4.824952774876386, -2.476799936298097}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 10 Rational[2, 37]^Rational[1, 2], 
           4 Rational[6, 37]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 10 
           Rational[2, 37]^Rational[1, 2], (-4) 
            Rational[6, 37]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.17504722512361415`, 
         0.7447491287292198}, {-4.824952774876386, -2.476799936298097}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 10 
           Rational[2, 37]^Rational[1, 2], (-4) 
            Rational[6, 37]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 10 Rational[2, 37]^Rational[1, 2], 
           4 Rational[6, 37]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.17504722512361415`, 
         0.9873016788396576}, {4.824952774876386, 4.208850743866974}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           10 Rational[2, 37]^Rational[1, 2], (-4) 
            Rational[6, 37]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 10 Rational[2, 37]^Rational[1, 2], 
           4 Rational[6, 37]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.17504722512361415`, 
         0.9873016788396576}, {-4.824952774876386, 4.208850743866974}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 31]^Rational[1, 2], 
           6 Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 31]^Rational[1, 2], (-6) 
            Rational[6, 31]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.016001016001524038`, 0.9075972628154818}, {
         2.016001016001524, -4.371698877953236}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 4 Rational[2, 31]^Rational[1, 2], 
           6 Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 31]^Rational[1, 2], (-6) 
            Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.016001016001524038`, 
         0.9075972628154818}, {-2.016001016001524, -4.371698877953236}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.7780017780026671, 0.4676559177514221}, {
         2.7780017780026673`, -3.9317575328891765`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.7219982219973329, 
         1.3336813215358607`}, {4.278001778002667, -3.065732129104738}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.7219982219973329, 
         1.3336813215358607`}, {-4.278001778002667, -3.065732129104738}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.7780017780026671, 
         0.4676559177514221}, {-2.7780017780026673`, \
-3.9317575328891765`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.7780017780026671, 1.264394889817455}, {
         2.7780017780026673`, 5.663808340458054}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.7219982219973329, 
         0.3983694860330167}, {4.278001778002667, 4.797782936673615}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 31]^Rational[1, 2], 
           5 Rational[6, 31]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.7219982219973329, 
         0.3983694860330167}, {-4.278001778002667, 4.797782936673615}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           7 Rational[2, 31]^Rational[1, 2], (-5) 
            Rational[6, 31]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 31]^Rational[1, 2], 5 Rational[6, 31]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.7780017780026671, 
         1.264394889817455}, {-2.7780017780026673`, 5.663808340458054}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 31]^Rational[1, 2], (-6) 
            Rational[6, 31]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 31]^Rational[1, 2], 
           6 Rational[6, 31]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.016001016001524038`, 
         0.8244535447533954}, {2.016001016001524, 6.103749685522113}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           4 Rational[2, 31]^Rational[1, 2], (-6) 
            Rational[6, 31]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 31]^Rational[1, 2], 6 Rational[6, 31]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.016001016001524038`, 
         0.8244535447533954}, {-2.016001016001524, 6.103749685522113}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {
          Rational[2, 19]^Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-0.3244428422615251, 1.0777066271762044`}, {
         0.3244428422615251, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 19]^Rational[1, 2], 5 Rational[6, 19]^Rational[1, 2] - 
           3^Rational[1, 2]}, {-
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.3244428422615251, 
         1.0777066271762044`}, {-0.3244428422615251, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.324442842261525, 
         1.0777066271762044`}, {-0.6755571577384749, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.8244428422615251, 
         1.943732030960643}, {-0.1755571577384749, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.1755571577384749, 
         1.943732030960643}, {0.8244428422615251, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.6755571577384749, 1.0777066271762044`}, {
         1.324442842261525, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.175557157738475, 
         1.943732030960643}, {1.824442842261525, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.175557157738475, 
         1.943732030960643}, {-1.824442842261525, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 
           Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.6755571577384749, 
         1.0777066271762044`}, {-1.324442842261525, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.1755571577384749, 
         1.943732030960643}, {-0.8244428422615251, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.8244428422615251, 
         1.943732030960643}, {0.1755571577384749, -3.6757828385295204`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{1.324442842261525, 1.0777066271762044`}, {
         0.6755571577384749, -4.541808242313959}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 19]^Rational[1, 2], 3 
           Rational[6, 19]^Rational[1, 2]}, {
          1 + 7 Rational[2, 19]^Rational[1, 2], (-3) 
           Rational[6, 19]^Rational[1, 2]}}, {{-1.2710998958306758`, 
         1.685854460847049}, {3.271099895830676, -1.685854460847049}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.2710998958306758`, -0.04619634672182826}, {
         3.271099895830676, -3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.7710998958306758, 
         0.8198290570626103}, {3.771099895830676, -2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 19]^Rational[1, 2], 3 
           Rational[6, 19]^Rational[1, 2]}, {
          2 + 7 Rational[2, 19]^Rational[1, 2], (-3) 
           Rational[6, 19]^Rational[1, 2]}}, {{-0.27109989583067584`, 
         1.685854460847049}, {4.271099895830676, -1.685854460847049}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.22890010416932416`, 
         0.8198290570626103}, {4.771099895830676, -2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.22890010416932416`, 
         2.5518798646314877`}, {4.771099895830676, -0.8198290570626103}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.22890010416932416`, 
         0.8198290570626103}, {-4.771099895830676, -2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.22890010416932416`, 
         2.5518798646314877`}, {-4.771099895830676, -0.8198290570626103}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 7 Rational[2, 19]^Rational[1, 2], 3 
           Rational[6, 19]^Rational[1, 2]}, {-2 - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
           Rational[6, 19]^Rational[1, 2]}}, {{0.27109989583067584`, 
         1.685854460847049}, {-4.271099895830676, -1.685854460847049}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.7710998958306758, 
         0.8198290570626103}, {-3.771099895830676, -2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 19]^Rational[1, 2], 3 
           Rational[6, 19]^Rational[1, 2]}, {-1 - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
           Rational[6, 19]^Rational[1, 2]}}, {{1.2710998958306758`, 
         1.685854460847049}, {-3.271099895830676, -1.685854460847049}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         1.2710998958306758`, -0.04619634672182826}, {-3.271099895830676, \
-3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.0955427380922007`, 
         0.257877570113594}, {4.095542738092201, -1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[3, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.0955427380922007`, 
         1.9899283776824712`}, {4.095542738092201, -0.257877570113594}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 8 Rational[2, 19]^Rational[1, 2], 2 
           Rational[6, 19]^Rational[1, 2]}, {
          2 + 8 Rational[2, 19]^Rational[1, 2], (-2) 
           Rational[6, 19]^Rational[1, 2]}}, {{-0.5955427380922007, 
         1.1239029738980326`}, {4.595542738092201, -1.1239029738980326`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.09554273809220071, 
         0.257877570113594}, {5.095542738092201, -1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.09554273809220071, 
         1.9899283776824712`}, {5.095542738092201, -0.257877570113594}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.09554273809220071, 
         0.257877570113594}, {-5.095542738092201, -1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.09554273809220071, 
         1.9899283776824712`}, {-5.095542738092201, -0.257877570113594}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 8 Rational[2, 19]^Rational[1, 2], 2 
           Rational[6, 19]^Rational[1, 2]}, {-2 - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
           Rational[6, 19]^Rational[1, 2]}}, {{0.5955427380922007, 
         1.1239029738980326`}, {-4.595542738092201, -1.1239029738980326`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.0955427380922007`, 
         0.257877570113594}, {-4.095542738092201, -1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.0955427380922007`, 
         1.9899283776824712`}, {-4.095542738092201, -0.257877570113594}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-1.0955427380922007`, -0.257877570113594}, {
         4.095542738092201, 1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.0955427380922007`, 
         1.4741732374552834`}, {4.095542738092201, 3.7219791852513486`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.5955427380922007, 0.6081478336708446}, {
         4.595542738092201, 2.85595378146691}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-0.09554273809220071, -0.257877570113594}, {
         5.095542738092201, 1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 8 
           Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.09554273809220071, 
         1.4741732374552834`}, {5.095542738092201, 3.7219791852513486`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.09554273809220071, -0.257877570113594}, {-5.095542738092201, 
         1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.09554273809220071, 
         1.4741732374552834`}, {-5.095542738092201, 3.7219791852513486`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 8 
           Rational[2, 19]^Rational[1, 2], 2 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.5955427380922007, 
         0.6081478336708446}, {-4.595542738092201, 2.85595378146691}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         1.0955427380922007`, -0.257877570113594}, {-4.095542738092201, 
         1.9899283776824712`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           8 Rational[2, 19]^Rational[1, 2], (-2) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 8 Rational[2, 19]^Rational[1, 2], 
           2 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.0955427380922007`, 
         1.4741732374552834`}, {-4.095542738092201, 3.7219791852513486`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.2710998958306758`, 0.04619634672182826}, {
         3.271099895830676, 3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.2710998958306758`, 
         1.7782471542907055`}, {3.271099895830676, 5.149956075984804}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.7710998958306758, 
         0.9122217505062671}, {3.771099895830676, 4.2839306722003645`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.27109989583067584`, 
         0.04619634672182826}, {4.271099895830676, 3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.22890010416932416`, -0.8198290570626103}, {4.771099895830676, 
         2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.22890010416932416`, 
         0.9122217505062671}, {4.771099895830676, 4.2839306722003645`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.22890010416932416`, -0.8198290570626103}, \
{-4.771099895830676, 2.5518798646314877`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.22890010416932416`, 
         0.9122217505062671}, {-4.771099895830676, 4.2839306722003645`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 7 
           Rational[2, 19]^Rational[1, 2], 3 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.27109989583067584`, 
         0.04619634672182826}, {-4.271099895830676, 3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 Rational[2, 19]^Rational[1, 2], 
           3 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.7710998958306758, 
         0.9122217505062671}, {-3.771099895830676, 4.2839306722003645`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 19]^Rational[1, 2], 3 Rational[6, 19]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.2710998958306758`, 
         0.04619634672182826}, {-3.271099895830676, 3.417905268415926}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           7 Rational[2, 19]^Rational[1, 2], (-3) 
            Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 19]^Rational[1, 2], 3 Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.2710998958306758`, 
         1.7782471542907055`}, {-3.271099895830676, 5.149956075984804}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          Rational[2, 19]^Rational[1, 2], 5 Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.3244428422615251, 0.6543441803926728}, {
         0.3244428422615251, 6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 19]^Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         0.3244428422615251, 0.6543441803926728}, {-0.3244428422615251, 
         6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.324442842261525, 
         0.6543441803926728}, {-0.6755571577384749, 6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.8244428422615251, -0.21168122339176554`}, \
{-0.1755571577384749, 5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.1755571577384749, -0.21168122339176554`}, {0.8244428422615251, 
         5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          1 + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         0.6755571577384749, 0.6543441803926728}, {1.324442842261525, 
         6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 19]^
           Rational[1, 2], (-5) Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.175557157738475, -0.21168122339176554`}, {1.824442842261525, 
         5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.175557157738475, -0.21168122339176554`}, \
{-1.824442842261525, 5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 
           Rational[2, 19]^Rational[1, 2], 5 Rational[6, 19]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.6755571577384749, 
         0.6543441803926728}, {-1.324442842261525, 6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.1755571577384749, -0.21168122339176554`}, \
{-0.8244428422615251, 5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.8244428422615251, -0.21168122339176554`}, {0.1755571577384749, 
         5.407833646098398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 19]^Rational[1, 2], (-5) 
            Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 - Rational[2, 19]^Rational[1, 2], 
           5 Rational[6, 19]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         1.324442842261525, 0.6543441803926728}, {0.6755571577384749, 
         6.2738590498828355`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {
          2 Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{-0.7844645405527362, 
         2.7174648819470297`}, {0.7844645405527362, -2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.7844645405527362, 0.9854140743781525}, {
         0.7844645405527362, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {(-2) 
           Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{0.7844645405527362, 
         2.7174648819470297`}, {-0.7844645405527362, \
-2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] - 
           3^Rational[1, 2]}, {(-2) 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.7844645405527362, 
         0.9854140743781525}, {-0.7844645405527362, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.284464540552736, 
         1.8514394781625911`}, {-0.7155354594472638, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.7844645405527362`, 
         0.9854140743781525}, {-0.21553545944726382`, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.2844645405527362`, 
         1.8514394781625911`}, {0.2844645405527362, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.2844645405527362, 
         1.8514394781625911`}, {1.2844645405527362`, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {
          1 + 2 Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{0.21553545944726382`, 
         2.7174648819470297`}, {
         1.7844645405527362`, -2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.21553545944726382`, 0.9854140743781525}, {
         1.7844645405527362`, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.7155354594472638, 
         1.8514394781625911`}, {2.284464540552736, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2 Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {
          2 + 2 Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{1.2155354594472638`, 
         2.7174648819470297`}, {2.784464540552736, -2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.7155354594472638`, 
         1.8514394781625911`}, {3.284464540552736, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.7155354594472638`, 
         1.8514394781625911`}, {-3.284464540552736, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2 Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {-2 - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{-1.2155354594472638`, 
         2.7174648819470297`}, {-2.784464540552736, -2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.7155354594472638, 
         1.8514394781625911`}, {-2.284464540552736, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 Rational[2, 13]^Rational[1, 2], 4 
           Rational[6, 13]^Rational[1, 2]}, {-1 - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
           Rational[6, 13]^Rational[1, 2]}}, {{-0.21553545944726382`, 
         2.7174648819470297`}, {-1.7844645405527362`, \
-2.7174648819470297`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.21553545944726382`, 
         0.9854140743781525}, {-1.7844645405527362`, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.2844645405527362, 
         1.8514394781625911`}, {-1.2844645405527362`, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.2844645405527362`, 
         1.8514394781625911`}, {-0.2844645405527362, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 - 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         1.7844645405527362`, 0.9854140743781525}, {
         0.21553545944726382`, -4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.284464540552736, 
         1.8514394781625911`}, {0.7155354594472638, -3.583490285731468}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {
          5 Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{-1.9611613513818404`, 
         2.038098661460272}, {1.9611613513818404`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.9611613513818404`, 0.3060478538913949}, {
         1.9611613513818404`, -3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {(-5) 
           Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{1.9611613513818404`, 
         2.038098661460272}, {-1.9611613513818404`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] - 
           3^Rational[1, 2]}, {(-5) 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         1.9611613513818404`, 
         0.3060478538913949}, {-1.9611613513818404`, \
-3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.4611613513818404`, 
         1.1720732576758335`}, {
         2.4611613513818407`, -2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {
          1 + 5 Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{-0.9611613513818404, 
         2.038098661460272}, {2.9611613513818407`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.9611613513818404, 0.3060478538913949}, {
         2.9611613513818407`, -3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.46116135138184045`, 
         1.1720732576758335`}, {
         3.4611613513818407`, -2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.46116135138184045`, 
         2.9041240652447105`}, {
         3.4611613513818407`, -1.1720732576758335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {
          2 + 5 Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{0.038838648618159555`, 
         2.038098661460272}, {3.9611613513818407`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.5388386486181596, 
         1.1720732576758335`}, {4.461161351381841, -2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.5388386486181596, 
         2.9041240652447105`}, {4.461161351381841, -1.1720732576758335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.5388386486181596, 
         1.1720732576758335`}, {-4.461161351381841, -2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.5388386486181596, 
         2.9041240652447105`}, {-4.461161351381841, -1.1720732576758335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 5 Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {-2 - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{-0.038838648618159555`, 
         2.038098661460272}, {-3.9611613513818407`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.46116135138184045`, 
         1.1720732576758335`}, {-3.4611613513818407`, \
-2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.46116135138184045`, 
         2.9041240652447105`}, {-3.4611613513818407`, \
-1.1720732576758335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 13]^Rational[1, 2], 3 
           Rational[6, 13]^Rational[1, 2]}, {-1 - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
           Rational[6, 13]^Rational[1, 2]}}, {{0.9611613513818404, 
         2.038098661460272}, {-2.9611613513818407`, -2.038098661460272}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.9611613513818404, 
         0.3060478538913949}, {-2.9611613513818407`, \
-3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.4611613513818404`, 
         1.1720732576758335`}, {-2.4611613513818407`, \
-2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}}, {{-1.7456258919345764`, 
         0.6793662204867574}, {3.7456258919345764`, -0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.7456258919345764`, -1.0526845870821198`}, {
         3.7456258919345764`, -2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.7456258919345764`, 2.4114170280556344`}, {
         3.7456258919345764`, 1.0526845870821198`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-1.2456258919345764`, -0.18665918329768116`}, {
         4.245625891934576, -1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.2456258919345764`, 
         1.545391624271196}, {4.245625891934576, 0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}, {
          2 + 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}}, {{-0.7456258919345764, 
         0.6793662204867574}, {4.745625891934576, -0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.7456258919345764, 2.4114170280556344`}, {
         4.745625891934576, 1.0526845870821198`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-0.2456258919345764, -0.18665918329768116`}, {
         5.245625891934576, -1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.2456258919345764, 
         1.545391624271196}, {5.245625891934576, 0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.2456258919345764, 
         3.2774424318400737`}, {5.245625891934576, 1.9187099908665586`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.2456258919345764, -0.18665918329768116`}, {-5.245625891934576, \
-1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.2456258919345764, 
         1.545391624271196}, {-5.245625891934576, 0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.2456258919345764, 
         3.2774424318400737`}, {-5.245625891934576, 1.9187099908665586`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2]}, {-2 - 7 
           Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}}, {{0.7456258919345764, 
         0.6793662204867574}, {-4.745625891934576, -0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.7456258919345764, 
         2.4114170280556344`}, {-4.745625891934576, 1.0526845870821198`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         1.2456258919345764`, -0.18665918329768116`}, {-4.245625891934576, \
-1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.2456258919345764`, 
         1.545391624271196}, {-4.245625891934576, 0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2]}, {-1 - 7 
           Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}}, {{1.7456258919345764`, 
         0.6793662204867574}, {-3.7456258919345764`, -0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{
         1.7456258919345764`, -1.0526845870821198`}, {-3.7456258919345764`, \
-2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.7456258919345764`, 
         2.4114170280556344`}, {-3.7456258919345764`, 
         1.0526845870821198`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}}, {{-1.7456258919345764`, -0.6793662204867574}, {
         3.7456258919345764`, 0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.7456258919345764`, 1.0526845870821198`}, {
         3.7456258919345764`, 2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.7456258919345764`, 
         2.7847353946509967`}, {3.7456258919345764`, 4.143467835624512}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.2456258919345764`, 
         0.18665918329768116`}, {4.245625891934576, 1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.2456258919345764`, 
         1.9187099908665586`}, {4.245625891934576, 3.2774424318400737`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}, {
          2 + 7 Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}}, {{-0.7456258919345764, -0.6793662204867574}, {
         4.745625891934576, 0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 7 Rational[2, 13]^Rational[1, 2], -
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.7456258919345764, 1.0526845870821198`}, {
         4.745625891934576, 2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[1, 2]}}, {{-0.2456258919345764, -1.545391624271196}, {
         5.245625891934576, -0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.2456258919345764, 
         0.18665918329768116`}, {5.245625891934576, 1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 7 
           Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.2456258919345764, 
         1.9187099908665586`}, {5.245625891934576, 3.2774424318400737`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.2456258919345764, -1.545391624271196}, {-5.245625891934576, \
-0.18665918329768116`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.2456258919345764, 
         0.18665918329768116`}, {-5.245625891934576, 1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.2456258919345764, 
         1.9187099908665586`}, {-5.245625891934576, 3.2774424318400737`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}, {-2 - 7 
           Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}}, {{
         0.7456258919345764, -0.6793662204867574}, {-4.745625891934576, 
         0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.7456258919345764, 1.0526845870821198`}, {-4.745625891934576, 
         2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.2456258919345764`, 
         0.18665918329768116`}, {-4.245625891934576, 1.545391624271196}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.2456258919345764`, 
         1.9187099908665586`}, {-4.245625891934576, 3.2774424318400737`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 7 Rational[2, 13]^Rational[1, 2], -
           Rational[6, 13]^Rational[1, 2]}, {-1 - 7 
           Rational[2, 13]^Rational[1, 2], Rational[6, 13]^
           Rational[1, 2]}}, {{
         1.7456258919345764`, -0.6793662204867574}, {-3.7456258919345764`, 
         0.6793662204867574}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         1.7456258919345764`, 1.0526845870821198`}, {-3.7456258919345764`, 
         2.4114170280556344`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           7 Rational[2, 13]^Rational[1, 2], -Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 - 7 Rational[2, 13]^Rational[1, 2], 
           Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         1.7456258919345764`, 2.7847353946509967`}, {-3.7456258919345764`, 
         4.143467835624512}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          5 Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.9611613513818404`, -0.3060478538913949}, {
         1.9611613513818404`, 3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          5 Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.9611613513818404`, 
         1.4260029536774823`}, {1.9611613513818404`, 5.5022002765980265`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {(-5) 
           Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{
         1.9611613513818404`, -0.3060478538913949}, {-1.9611613513818404`, 
         3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {(-5) 
           Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.9611613513818404`, 
         1.4260029536774823`}, {-1.9611613513818404`, 
         5.5022002765980265`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.4611613513818404`, 
         0.5599775498930439}, {2.4611613513818407`, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          1 - 5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.9611613513818404, -0.3060478538913949}, {
         2.9611613513818407`, 3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.9611613513818404, 
         1.4260029536774823`}, {2.9611613513818407`, 5.5022002765980265`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.46116135138184045`, -1.1720732576758335`}, {
         3.4611613513818407`, 2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.46116135138184045`, 
         0.5599775498930439}, {3.4611613513818407`, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.038838648618159555`, -0.3060478538913949}, {3.9611613513818407`, 
         3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.5388386486181596, -1.1720732576758335`}, {4.461161351381841, 
         2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 
           Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.5388386486181596, 
         0.5599775498930439}, {4.461161351381841, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.5388386486181596, -1.1720732576758335`}, \
{-4.461161351381841, 2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.5388386486181596, 
         0.5599775498930439}, {-4.461161351381841, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 5 
           Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-0.038838648618159555`, -0.3060478538913949}, \
{-3.9611613513818407`, 3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.46116135138184045`, -1.1720732576758335`}, {-3.4611613513818407`, 
         2.9041240652447105`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.46116135138184045`, 
         0.5599775498930439}, {-3.4611613513818407`, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 5 
           Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{
         0.9611613513818404, -0.3060478538913949}, {-2.9611613513818407`, 
         3.7701494690291493`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 5 
           Rational[2, 13]^Rational[1, 2], 3 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.9611613513818404, 
         1.4260029536774823`}, {-2.9611613513818407`, 
         5.5022002765980265`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           5 Rational[2, 13]^Rational[1, 2], (-3) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 Rational[2, 13]^Rational[1, 2], 
           3 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.4611613513818404`, 
         0.5599775498930439}, {-2.4611613513818407`, 4.636174872813588}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.7844645405527362, -0.9854140743781525}, {
         0.7844645405527362, 4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-2) 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          2 Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.7844645405527362, 0.7466367331907247}, {
         0.7844645405527362, 6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {(-2) 
           Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{
         0.7844645405527362, -0.9854140743781525}, {-0.7844645405527362, 
         4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {(-2) 
           Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.7844645405527362, 
         0.7466367331907247}, {-0.7844645405527362, 6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-2.284464540552736, -0.11938867059371372`}, \
{-0.7155354594472638, 5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 + 
           2 Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.7844645405527362`, 
         0.7466367331907247}, {-0.21553545944726382`, 6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.2844645405527362`, -0.11938867059371372`}, {
         0.2844645405527362, 5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.2844645405527362, -0.11938867059371372`}, {
         1.2844645405527362`, 5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.21553545944726382`, -0.9854140743781525}, {1.7844645405527362`, 
         4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         0.21553545944726382`, 0.7466367331907247}, {1.7844645405527362`, 
         6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.7155354594472638, -0.11938867059371372`}, {2.284464540552736, 
         5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         1.2155354594472638`, -0.9854140743781525}, {2.784464540552736, 
         4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 
           Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.7155354594472638`, -0.11938867059371372`}, {3.284464540552736, 
         5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.7155354594472638`, -0.11938867059371372`}, \
{-3.284464540552736, 5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 2 
           Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-1.2155354594472638`, -0.9854140743781525}, \
{-2.784464540552736, 4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.7155354594472638, -0.11938867059371372`}, \
{-2.284464540552736, 5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 2 
           Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-0.21553545944726382`, -0.9854140743781525}, \
{-1.7844645405527362`, 4.449515689515907}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 2 
           Rational[2, 13]^Rational[1, 2], 4 Rational[6, 13]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.21553545944726382`, 
         0.7466367331907247}, {-1.7844645405527362`, 6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.2844645405527362, -0.11938867059371372`}, {-1.2844645405527362`, 
         5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.2844645405527362`, -0.11938867059371372`}, {-0.2844645405527362, 
         5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         1.7844645405527362`, 0.7466367331907247}, {0.21553545944726382`, 
         6.181566497084784}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 
           2 Rational[2, 13]^Rational[1, 2], (-4) 
            Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] - 2 Rational[2, 13]^Rational[1, 2], 
           4 Rational[6, 13]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         2.284464540552736, -0.11938867059371372`}, {0.7155354594472638, 
         5.315541093300346}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {
          Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{-0.5345224838248488, 
         2.7774602993176543`}, {0.5345224838248488, -2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-0.5345224838248488, 1.045409491748777}, {
         0.5345224838248488, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2]}, {-
           Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{0.5345224838248488, 
         2.7774602993176543`}, {-0.5345224838248488, \
-2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}, {-
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{0.5345224838248488, 
         1.045409491748777}, {-0.5345224838248488, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {-2 + 
           Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{-2.5345224838248486`, 
         2.7774602993176543`}, {-1.4654775161751512`, \
-2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.0345224838248486`, 
         1.9114348955332157`}, {-0.9654775161751512, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {-1 + 
           Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{-1.5345224838248488`, 
         2.7774602993176543`}, {-0.4654775161751512, \
-2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-1.5345224838248488`, 
         1.045409491748777}, {-0.4654775161751512, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.0345224838248488`, 
         1.9114348955332157`}, {0.03452248382484879, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.0345224838248488`, 
         3.643485703102093}, {0.03452248382484879, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.03452248382484879, 
         1.9114348955332157`}, {1.0345224838248488`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.03452248382484879, 
         3.643485703102093}, {1.0345224838248488`, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {
          1 + Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{0.4654775161751512, 
         2.7774602993176543`}, {
         1.5345224838248488`, -2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {
          1 + Rational[2, 7]^Rational[1, 2], (-3) 
            Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.4654775161751512, 1.045409491748777}, {
         1.5345224838248488`, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.9654775161751512, 
         1.9114348955332157`}, {2.0345224838248486`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.9654775161751512, 
         3.643485703102093}, {2.0345224838248486`, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {
          2 + Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{1.4654775161751512`, 
         2.7774602993176543`}, {
         2.5345224838248486`, -2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.9654775161751512`, 
         1.9114348955332157`}, {3.0345224838248486`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.9654775161751512`, 
         1.9114348955332157`}, {-3.0345224838248486`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {-2 - Rational[2, 7]^
           Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{-1.4654775161751512`, 
         2.7774602993176543`}, {-2.5345224838248486`, \
-2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.9654775161751512, 
         1.9114348955332157`}, {-2.0345224838248486`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.9654775161751512, 
         3.643485703102093}, {-2.0345224838248486`, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {-1 - Rational[2, 7]^
           Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{-0.4654775161751512, 
         2.7774602993176543`}, {-1.5345224838248488`, \
-2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-0.4654775161751512, 
         1.045409491748777}, {-1.5345224838248488`, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.03452248382484879, 
         1.9114348955332157`}, {-1.0345224838248488`, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.03452248382484879, 
         3.643485703102093}, {-1.0345224838248488`, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.0345224838248488`, 
         1.9114348955332157`}, {-0.03452248382484879, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.0345224838248488`, 
         3.643485703102093}, {-0.03452248382484879, -1.9114348955332157`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {
          1 - Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{1.5345224838248488`, 
         2.7774602993176543`}, {0.4654775161751512, -2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {
          1 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{1.5345224838248488`, 1.045409491748777}, {
         0.4654775161751512, -4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.0345224838248486`, 
         1.9114348955332157`}, {0.9654775161751512, -3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 + Rational[2, 7]^Rational[1, 2], 3 
           Rational[6, 7]^Rational[1, 2]}, {
          2 - Rational[2, 7]^Rational[1, 2], (-3) 
           Rational[6, 7]^Rational[1, 2]}}, {{2.5345224838248486`, 
         2.7774602993176543`}, {
         1.4654775161751512`, -2.7774602993176543`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-4) Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {
          4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{-2.138089935299395, 
         1.8516401995451028`}, {2.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-4) Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          4 Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-2.138089935299395, 0.11958939197622565`}, {
         2.138089935299395, -3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {(-4) 
           Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{2.138089935299395, 
         1.8516401995451028`}, {-2.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          4 Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {(-4) 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{2.138089935299395, 
         0.11958939197622565`}, {-2.138089935299395, -3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.638089935299395, 
         0.9856147957606642}, {1.6380899352993952`, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-2.638089935299395, 
         2.717665603329541}, {1.6380899352993952`, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.6380899352993952`, 
         0.9856147957606642}, {2.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.6380899352993952`, 
         2.717665603329541}, {2.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{-1.1380899352993952`, 
         1.8516401995451028`}, {3.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-1.1380899352993952`, 0.11958939197622565`}, {
         3.138089935299395, -3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.1380899352993952`, 3.58369100711398}, {
         3.138089935299395, -0.11958939197622565`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.6380899352993952, 
         0.9856147957606642}, {3.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.6380899352993952, 
         2.717665603329541}, {3.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {
          2 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{-0.13808993529939517`, 
         1.8516401995451028`}, {4.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.13808993529939517`, 3.58369100711398}, {
         4.138089935299395, -0.11958939197622565`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.3619100647006048, 
         0.9856147957606642}, {4.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.3619100647006048, 
         2.717665603329541}, {4.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.3619100647006048, 
         0.9856147957606642}, {-4.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.3619100647006048, 
         2.717665603329541}, {-4.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {-2 - 4 
           Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{0.13808993529939517`, 
         1.8516401995451028`}, {-4.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.13808993529939517`, 
         3.58369100711398}, {-4.138089935299395, -0.11958939197622565`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.6380899352993952, 
         0.9856147957606642}, {-3.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.6380899352993952, 
         2.717665603329541}, {-3.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}}, {{1.1380899352993952`, 
         1.8516401995451028`}, {-3.138089935299395, -1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{1.1380899352993952`, 
         0.11958939197622565`}, {-3.138089935299395, -3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.1380899352993952`, 
         3.58369100711398}, {-3.138089935299395, -0.11958939197622565`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.6380899352993952`, 
         0.9856147957606642}, {-2.638089935299395, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.6380899352993952`, 
         2.717665603329541}, {-2.638089935299395, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.638089935299395, 
         0.9856147957606642}, {-1.6380899352993952`, -2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{2.638089935299395, 
         2.717665603329541}, {-1.6380899352993952`, -0.9856147957606642}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{-2.6726124191242437`, 
         0.9258200997725514}, {2.6726124191242437`, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-2.6726124191242437`, -0.8062307077963258}, {
         2.6726124191242437`, -2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2.6726124191242437`, 2.6578709073414286`}, {
         2.6726124191242437`, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {(-5) Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{2.6726124191242437`, 
         0.9258200997725514}, {-2.6726124191242437`, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}, {(-5) 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{
         2.6726124191242437`, -0.8062307077963258}, {-2.6726124191242437`, \
-2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {(-5) 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{2.6726124191242437`, 
         2.6578709073414286`}, {-2.6726124191242437`, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-2.1726124191242437`, 
         0.05979469598811282}, {3.1726124191242437`, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-2.1726124191242437`, 
         1.79184550355699}, {3.1726124191242437`, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{-1.6726124191242437`, 
         0.9258200997725514}, {3.6726124191242437`, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-1.6726124191242437`, -0.8062307077963258}, {
         3.6726124191242437`, -2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.6726124191242437`, 2.6578709073414286`}, {
         3.6726124191242437`, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.1726124191242437`, 
         0.05979469598811282}, {4.172612419124244, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-1.1726124191242437`, 
         1.79184550355699}, {4.172612419124244, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.1726124191242437`, 
         3.5238963111258674`}, {4.172612419124244, 1.6722561115807646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {
          2 + 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{-0.6726124191242437, 
         0.9258200997725514}, {4.672612419124244, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          2 + 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.6726124191242437, 2.6578709073414286`}, {
         4.672612419124244, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.17261241912424374`, 
         0.05979469598811282}, {5.172612419124244, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.17261241912424374`, 
         1.79184550355699}, {5.172612419124244, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.17261241912424374`, 
         3.5238963111258674`}, {5.172612419124244, 1.6722561115807646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.17261241912424374`, 
         0.05979469598811282}, {-5.172612419124244, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.17261241912424374`, 
         1.79184550355699}, {-5.172612419124244, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.17261241912424374`, 
         3.5238963111258674`}, {-5.172612419124244, 1.6722561115807646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {-2 - 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{0.6726124191242437, 
         0.9258200997725514}, {-4.672612419124244, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.6726124191242437, 
         2.6578709073414286`}, {-4.672612419124244, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.1726124191242437`, 
         0.05979469598811282}, {-4.172612419124244, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{1.1726124191242437`, 
         1.79184550355699}, {-4.172612419124244, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.1726124191242437`, 
         3.5238963111258674`}, {-4.172612419124244, 1.6722561115807646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}, {-1 - 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}}, {{1.6726124191242437`, 
         0.9258200997725514}, {-3.6726124191242437`, -0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{
         1.6726124191242437`, -0.8062307077963258}, {-3.6726124191242437`, \
-2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.6726124191242437`, 
         2.6578709073414286`}, {-3.6726124191242437`, 0.8062307077963258}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{2.1726124191242437`, 
         0.05979469598811282}, {-3.1726124191242437`, -1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{2.1726124191242437`, 
         1.79184550355699}, {-3.1726124191242437`, -0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}}, {{-2.6726124191242437`, -0.9258200997725514}, {
         2.6726124191242437`, 0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2.6726124191242437`, 0.8062307077963258}, {
         2.6726124191242437`, 2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-5) 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-2.6726124191242437`, 2.538281515365203}, {
         2.6726124191242437`, 4.389921714910306}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {(-5) 
           Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2]}}, {{
         2.6726124191242437`, -0.9258200997725514}, {-2.6726124191242437`, 
         0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {(-5) Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         2.6726124191242437`, 0.8062307077963258}, {-2.6726124191242437`, 
         2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {(-5) Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         2.6726124191242437`, 2.538281515365203}, {-2.6726124191242437`, 
         4.389921714910306}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-2.1726124191242437`, -0.05979469598811282}, {
         3.1726124191242437`, 1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-2.1726124191242437`, 
         1.6722561115807646`}, {3.1726124191242437`, 3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}}, {{-1.6726124191242437`, -0.9258200997725514}, {
         3.6726124191242437`, 0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-1.6726124191242437`, 0.8062307077963258}, {
         3.6726124191242437`, 2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          1 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.6726124191242437`, 2.538281515365203}, {
         3.6726124191242437`, 4.389921714910306}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[1, 2]}}, {{-1.1726124191242437`, -1.79184550355699}, {
         4.172612419124244, 0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-1.1726124191242437`, -0.05979469598811282}, {
         4.172612419124244, 1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.1726124191242437`, 
         1.6722561115807646`}, {4.172612419124244, 3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {
          2 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^
           Rational[1, 2]}}, {{-0.6726124191242437, -0.9258200997725514}, {
         4.672612419124244, 0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          2 + 5 Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.6726124191242437, 0.8062307077963258}, {
         4.672612419124244, 2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[1, 2]}}, {{-0.17261241912424374`, -1.79184550355699}, {
         5.172612419124244, 0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.17261241912424374`, -0.05979469598811282}, {
         5.172612419124244, 1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 5 
           Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.17261241912424374`, 
         1.6722561115807646`}, {5.172612419124244, 3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.17261241912424374`, -1.79184550355699}, {-5.172612419124244, 
         0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.17261241912424374`, -0.05979469598811282}, {-5.172612419124244, 
         1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.17261241912424374`, 
         1.6722561115807646`}, {-5.172612419124244, 3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {-2 - 5 
           Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2]}}, {{
         0.6726124191242437, -0.9258200997725514}, {-4.672612419124244, 
         0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.6726124191242437, 0.8062307077963258}, {-4.672612419124244, 
         2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         1.1726124191242437`, -1.79184550355699}, {-4.172612419124244, 
         0.05979469598811282}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         1.1726124191242437`, -0.05979469598811282}, {-4.172612419124244, 
         1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.1726124191242437`, 
         1.6722561115807646`}, {-4.172612419124244, 3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 5 Rational[2, 7]^Rational[1, 2], -
           Rational[6, 7]^Rational[1, 2]}, {-1 - 5 
           Rational[2, 7]^Rational[1, 2], Rational[6, 7]^Rational[1, 2]}}, {{
         1.6726124191242437`, -0.9258200997725514}, {-3.6726124191242437`, 
         0.9258200997725514}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         1.6726124191242437`, 0.8062307077963258}, {-3.6726124191242437`, 
         2.6578709073414286`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         1.6726124191242437`, 2.538281515365203}, {-3.6726124191242437`, 
         4.389921714910306}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         2.1726124191242437`, -0.05979469598811282}, {-3.1726124191242437`, 
         1.79184550355699}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           5 Rational[2, 7]^Rational[1, 2], -Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 5 Rational[2, 7]^Rational[1, 2], 
           Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{2.1726124191242437`, 
         1.6722561115807646`}, {-3.1726124191242437`, 
         3.5238963111258674`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-4) 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          4 Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-2.138089935299395, -0.11958939197622565`}, {
         2.138089935299395, 3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{(-4) 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          4 Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-2.138089935299395, 1.6124614155926515`}, {
         2.138089935299395, 5.315741814682857}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          4 Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {(-4) Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         2.138089935299395, -0.11958939197622565`}, {-2.138089935299395, 
         3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          4 Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {(-4) Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         2.138089935299395, 1.6124614155926515`}, {-2.138089935299395, 
         5.315741814682857}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-2.638089935299395, -0.9856147957606642}, {
         1.6380899352993952`, 2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-2.638089935299395, 
         0.7464360118082132}, {1.6380899352993952`, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-1.6380899352993952`, -0.9856147957606642}, {
         2.638089935299395, 2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.6380899352993952`, 
         0.7464360118082132}, {2.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^
            Rational[1, 2]}}, {{-1.1380899352993952`, -1.8516401995451028`}, {
         3.138089935299395, 1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-1.1380899352993952`, -0.11958939197622565`}, {
         3.138089935299395, 3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.1380899352993952`, 
         1.6124614155926515`}, {3.138089935299395, 5.315741814682857}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[3, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[1, 2]}}, {{-0.6380899352993952, -0.9856147957606642}, {
         3.638089935299395, 2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.6380899352993952, 
         0.7464360118082132}, {3.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}, {
          2 + 4 Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^
            Rational[
             1, 2]}}, {{-0.13808993529939517`, -1.8516401995451028`}, {
         4.138089935299395, 1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-0.13808993529939517`, -0.11958939197622565`}, {
         4.138089935299395, 3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.3619100647006048, -0.9856147957606642}, {4.638089935299395, 
         2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 4 
           Rational[2, 7]^Rational[1, 2], (-2) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.3619100647006048, 
         0.7464360118082132}, {4.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.3619100647006048, -0.9856147957606642}, \
{-4.638089935299395, 2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.3619100647006048, 
         0.7464360118082132}, {-4.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}, {-2 - 4 
           Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}}, {{
         0.13808993529939517`, -1.8516401995451028`}, {-4.138089935299395, 
         1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 4 
           Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{
         0.13808993529939517`, -0.11958939197622565`}, {-4.138089935299395, 
         3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.6380899352993952, -0.9856147957606642}, {-3.638089935299395, 
         2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.6380899352993952, 
         0.7464360118082132}, {-3.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 4 Rational[2, 7]^Rational[1, 2], (-2) 
           Rational[6, 7]^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], 2 
           Rational[6, 7]^Rational[1, 2]}}, {{
         1.1380899352993952`, -1.8516401995451028`}, {-3.138089935299395, 
         1.8516401995451028`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{
         1.1380899352993952`, -0.11958939197622565`}, {-3.138089935299395, 
         3.58369100711398}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 4 
           Rational[2, 7]^Rational[1, 2], 2 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.1380899352993952`, 
         1.6124614155926515`}, {-3.138089935299395, 5.315741814682857}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         1.6380899352993952`, -0.9856147957606642}, {-2.638089935299395, 
         2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.6380899352993952`, 
         0.7464360118082132}, {-2.638089935299395, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         2.638089935299395, -0.9856147957606642}, {-1.6380899352993952`, 
         2.717665603329541}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           4 Rational[2, 7]^Rational[1, 2], (-2) 
            Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - 4 Rational[2, 7]^Rational[1, 2], 
           2 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{2.638089935299395, 
         0.7464360118082132}, {-1.6380899352993952`, 4.449716410898419}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.5345224838248488, -1.045409491748777}, {
         0.5345224838248488, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.5345224838248488, 0.6866413158201001}, {
         0.5345224838248488, 6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.5345224838248488, -1.045409491748777}, {-0.5345224838248488, 
         4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         0.5345224838248488, 0.6866413158201001}, {-0.5345224838248488, 
         6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-2.5345224838248486`, -1.045409491748777}, \
{-1.4654775161751512`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-2.0345224838248486`, -0.17938408796433825`}, \
{-0.9654775161751512, 5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-1.5345224838248488`, -1.045409491748777}, \
{-0.4654775161751512, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.5345224838248488`, 
         0.6866413158201001}, {-0.4654775161751512, 6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-1.0345224838248488`, -1.9114348955332157`}, {
         0.03452248382484879, 3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.0345224838248488`, -0.17938408796433825`}, {
         0.03452248382484879, 5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.03452248382484879, -1.9114348955332157`}, {
         1.0345224838248488`, 3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.03452248382484879, -0.17938408796433825`}, {
         1.0345224838248488`, 5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          1 + Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.4654775161751512, -1.045409491748777}, {
         1.5345224838248488`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          1 + Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.4654775161751512, 0.6866413158201001}, {
         1.5345224838248488`, 6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.9654775161751512, -1.9114348955332157`}, {2.0345224838248486`, 
         3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.9654775161751512, -0.17938408796433825`}, {2.0345224838248486`, 
         5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          2 + Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.4654775161751512`, -1.045409491748777}, {
         2.5345224838248486`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - Rational[2, 7]^
           Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.9654775161751512`, -0.17938408796433825`}, {3.0345224838248486`, 
         5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.9654775161751512`, -0.17938408796433825`}, \
{-3.0345224838248486`, 5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-1.4654775161751512`, -1.045409491748777}, \
{-2.5345224838248486`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 
            3^Rational[
              1, 2]}}, {{-0.9654775161751512, -1.9114348955332157`}, \
{-2.0345224838248486`, 3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.9654775161751512, -0.17938408796433825`}, \
{-2.0345224838248486`, 5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-1 - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-0.4654775161751512, -1.045409491748777}, \
{-1.5345224838248488`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.4654775161751512, 
         0.6866413158201001}, {-1.5345224838248488`, 6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         0.03452248382484879, -1.9114348955332157`}, {-1.0345224838248488`, 
         3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.03452248382484879, -0.17938408796433825`}, {-1.0345224838248488`, 
         5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{
         1.0345224838248488`, -1.9114348955332157`}, {-0.03452248382484879, 
         3.643485703102093}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.0345224838248488`, -0.17938408796433825`}, {-0.03452248382484879, 
         5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 7]^Rational[1, 2], (-3) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          1 - Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{1.5345224838248488`, -1.045409491748777}, {
         0.4654775161751512, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[2, 7]^Rational[1, 2], (-3) 
            Rational[6, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 - Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.5345224838248488`, 0.6866413158201001}, {
         0.4654775161751512, 6.241561914455408}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 
           Rational[2, 7]^Rational[1, 2], (-3) Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] - Rational[2, 7]^Rational[1, 2], 
           3 Rational[6, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         2.0345224838248486`, -0.17938408796433825`}, {0.9654775161751512, 
         5.375536510670971}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 + Rational[2, 7]^Rational[1, 2], (-3) 
            Rational[6, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 - Rational[2, 7]^Rational[1, 2], 3 Rational[6, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{2.5345224838248486`, -1.045409491748777}, {
         1.4654775161751512`, 4.5095111068865315`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], 6^Rational[1, 2]}, {
          2^Rational[1, 2], -6^Rational[1, 2]}}, {{-1.4142135623730951`, 
         2.449489742783178}, {1.4142135623730951`, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], -3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          2^Rational[1, 2], -3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-1.4142135623730951`, 0.7174389352143007}, {
         1.4142135623730951`, -4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-1.4142135623730951`, 4.1815405503520555`}, {
         1.4142135623730951`, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], 6^
           Rational[1, 2]}, {-2^Rational[1, 2], -6^Rational[1, 2]}}, {{
         1.4142135623730951`, 
         2.449489742783178}, {-1.4142135623730951`, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], -3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-2^Rational[1, 2], -3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{1.4142135623730951`, 
         0.7174389352143007}, {-1.4142135623730951`, \
-4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{1.4142135623730951`, 
         4.1815405503520555`}, {-1.4142135623730951`, \
-0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - 2^Rational[1, 2], 6^Rational[1, 2]}, {-2 + 
           2^Rational[1, 2], -6^Rational[1, 2]}}, {{-3.414213562373095, 
         2.449489742783178}, {-0.5857864376269049, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-2 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-3.414213562373095, 
         4.1815405503520555`}, {-0.5857864376269049, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          Rational[-3, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-2.914213562373095, 
         1.5834643389987393`}, {-0.08578643762690485, \
-3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-2.914213562373095, 
         3.3155151465676163`}, {-0.08578643762690485, \
-1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], 6^Rational[1, 2]}, {-1 + 
           2^Rational[1, 2], -6^Rational[1, 2]}}, {{-2.414213562373095, 
         2.449489742783178}, {0.41421356237309515`, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], -3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-1 + 2^Rational[1, 2], -3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-2.414213562373095, 0.7174389352143007}, {
         0.41421356237309515`, -4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-1 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-2.414213562373095, 4.1815405503520555`}, {
         0.41421356237309515`, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-1.9142135623730951`, 1.5834643389987393`}, {
         0.9142135623730951, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-1.9142135623730951`, 3.3155151465676163`}, {
         0.9142135623730951, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-1.9142135623730951`, 5.047565954136494}, {
         0.9142135623730951, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-0.9142135623730951, 1.5834643389987393`}, {
         1.9142135623730951`, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-0.9142135623730951, 3.3155151465676163`}, {
         1.9142135623730951`, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-0.9142135623730951, 5.047565954136494}, {
         1.9142135623730951`, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2^Rational[1, 2], 6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], -6^Rational[1, 2]}}, {{-0.41421356237309515`, 
         2.449489742783178}, {2.414213562373095, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2^Rational[1, 2], -3^Rational[1, 2] + 6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], -3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-0.41421356237309515`, 0.7174389352143007}, {
         2.414213562373095, -4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-0.41421356237309515`, 4.1815405503520555`}, {
         2.414213562373095, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{0.08578643762690485, 1.5834643389987393`}, {
         2.914213562373095, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{0.08578643762690485, 3.3155151465676163`}, {
         2.914213562373095, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{0.08578643762690485, 5.047565954136494}, {
         2.914213562373095, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 2^Rational[1, 2], 6^Rational[1, 2]}, {
          2 + 2^Rational[1, 2], -6^Rational[1, 2]}}, {{0.5857864376269049, 
         2.449489742783178}, {3.414213562373095, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          2 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}}, {{
         0.5857864376269049, 4.1815405503520555`}, {
         3.414213562373095, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[5, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{1.0857864376269049`, 1.5834643389987393`}, {
         3.914213562373095, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[5, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{1.0857864376269049`, 3.3155151465676163`}, {
         3.914213562373095, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          Rational[-5, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-1.0857864376269049`, 
         1.5834643389987393`}, {-3.914213562373095, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-5, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-1.0857864376269049`, 
         3.3155151465676163`}, {-3.914213562373095, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2^Rational[1, 2], 6^Rational[1, 2]}, {-2 - 2^
           Rational[1, 2], -6^Rational[1, 2]}}, {{-0.5857864376269049, 
         2.449489742783178}, {-3.414213562373095, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-2 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-0.5857864376269049, 
         4.1815405503520555`}, {-3.414213562373095, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{-0.08578643762690485, 
         1.5834643389987393`}, {-2.914213562373095, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-0.08578643762690485, 
         3.3155151465676163`}, {-2.914213562373095, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{-0.08578643762690485, 
         5.047565954136494}, {-2.914213562373095, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], 6^Rational[1, 2]}, {-1 - 2^
           Rational[1, 2], -6^Rational[1, 2]}}, {{0.41421356237309515`, 
         2.449489742783178}, {-2.414213562373095, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], -3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-1 - 2^Rational[1, 2], -3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{0.41421356237309515`, 
         0.7174389352143007}, {-2.414213562373095, -4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {-1 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}}, {{0.41421356237309515`, 
         4.1815405503520555`}, {-2.414213562373095, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^Rational[1, 2]}}, {{
         0.9142135623730951, 
         1.5834643389987393`}, {-1.9142135623730951`, \
-3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{0.9142135623730951, 
         3.3155151465676163`}, {-1.9142135623730951`, \
-1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{0.9142135623730951, 
         5.047565954136494}, {-1.9142135623730951`, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{1.9142135623730951`, 
         1.5834643389987393`}, {-0.9142135623730951, \
-3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{1.9142135623730951`, 
         3.3155151465676163`}, {-0.9142135623730951, \
-1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{1.9142135623730951`, 
         5.047565954136494}, {-0.9142135623730951, 0.14858646857013813`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 2^Rational[1, 2], 6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], -6^Rational[1, 2]}}, {{2.414213562373095, 
         2.449489742783178}, {-0.41421356237309515`, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2^Rational[1, 2], -3^Rational[1, 2] + 6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], -3^Rational[1, 2] - 6^Rational[1, 2]}}, {{
         2.414213562373095, 
         0.7174389352143007}, {-0.41421356237309515`, \
-4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}}, {{
         2.414213562373095, 
         4.1815405503520555`}, {-0.41421356237309515`, \
-0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[3, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{2.914213562373095, 1.5834643389987393`}, {
         0.08578643762690485, -3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}, {
          Rational[3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}}, {{2.914213562373095, 3.3155151465676163`}, {
         0.08578643762690485, -1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 + 2^Rational[1, 2], 6^Rational[1, 2]}, {
          2 - 2^Rational[1, 2], -6^Rational[1, 2]}}, {{3.414213562373095, 
         2.449489742783178}, {0.5857864376269049, -2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 + 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}, {
          2 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}}, {{
         3.414213562373095, 4.1815405503520555`}, {
         0.5857864376269049, -0.7174389352143007}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], -6^Rational[1, 2]}, {
          2^Rational[1, 2], 6^
           Rational[1, 2]}}, {{-1.4142135623730951`, -2.449489742783178}, {
         1.4142135623730951`, 2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {
          2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-1.4142135623730951`, -0.7174389352143007}, {
         1.4142135623730951`, 4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2^Rational[1, 2], 2 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {
          2^Rational[1, 2], 2 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-1.4142135623730951`, 1.0146118723545765`}, {
         1.4142135623730951`, 5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], -6^Rational[1, 2]}, {-2^Rational[1, 2], 6^
           Rational[1, 2]}}, {{
         1.4142135623730951`, -2.449489742783178}, {-1.4142135623730951`, 
         2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{
         1.4142135623730951`, -0.7174389352143007}, {-1.4142135623730951`, 
         4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2^Rational[1, 2], 2 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-2^Rational[1, 2], 2 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{1.4142135623730951`, 
         1.0146118723545765`}, {-1.4142135623730951`, 5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - 2^Rational[1, 2], -6^Rational[1, 2]}, {-2 + 
           2^Rational[1, 2], 6^
           Rational[
            1, 2]}}, {{-3.414213562373095, -2.449489742783178}, \
{-0.5857864376269049, 2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-2 + 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-3.414213562373095, -0.7174389352143007}, \
{-0.5857864376269049, 4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-2.914213562373095, -1.5834643389987393`}, \
{-0.08578643762690485, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-2.914213562373095, 
         0.14858646857013813`}, {-0.08578643762690485, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], -6^Rational[1, 2]}, {-1 + 
           2^Rational[1, 2], 6^
           Rational[1, 2]}}, {{-2.414213562373095, -2.449489742783178}, {
         0.41421356237309515`, 2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-1 + 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-2.414213562373095, -0.7174389352143007}, {
         0.41421356237309515`, 4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - 2^Rational[1, 2], 2 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-1 + 2^Rational[1, 2], 2 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-2.414213562373095, 1.0146118723545765`}, {
         0.41421356237309515`, 5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-1.9142135623730951`, -3.3155151465676163`}, {
         0.9142135623730951, 1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-1.9142135623730951`, -1.5834643389987393`}, {
         0.9142135623730951, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-1.9142135623730951`, 
         0.14858646857013813`}, {0.9142135623730951, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-0.9142135623730951, -3.3155151465676163`}, {
         1.9142135623730951`, 1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-0.9142135623730951, -1.5834643389987393`}, {
         1.9142135623730951`, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-0.9142135623730951, 0.14858646857013813`}, {
         1.9142135623730951`, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 - 2^Rational[1, 2], -6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], 6^
           Rational[1, 2]}}, {{-0.41421356237309515`, -2.449489742783178}, {
         2.414213562373095, 2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-0.41421356237309515`, -0.7174389352143007}, {
         2.414213562373095, 4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2^Rational[1, 2], 2 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          1 + 2^Rational[1, 2], 2 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-0.41421356237309515`, 
         1.0146118723545765`}, {2.414213562373095, 5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{0.08578643762690485, -3.3155151465676163`}, {
         2.914213562373095, 1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{0.08578643762690485, -1.5834643389987393`}, {
         2.914213562373095, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{0.08578643762690485, 0.14858646857013813`}, {
         2.914213562373095, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 - 2^Rational[1, 2], -6^Rational[1, 2]}, {
          2 + 2^Rational[1, 2], 6^Rational[1, 2]}}, {{
         0.5857864376269049, -2.449489742783178}, {3.414213562373095, 
         2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          2 + 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}}, {{
         0.5857864376269049, -0.7174389352143007}, {3.414213562373095, 
         4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[5, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{1.0857864376269049`, -1.5834643389987393`}, {
         3.914213562373095, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[5, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{1.0857864376269049`, 0.14858646857013813`}, {
         3.914213562373095, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-5, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-1.0857864376269049`, -1.5834643389987393`}, \
{-3.914213562373095, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-5, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-1.0857864376269049`, 
         0.14858646857013813`}, {-3.914213562373095, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2^Rational[1, 2], -6^Rational[1, 2]}, {-2 - 2^
           Rational[1, 2], 6^
           Rational[
            1, 2]}}, {{-0.5857864376269049, -2.449489742783178}, \
{-3.414213562373095, 2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-2 - 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-0.5857864376269049, -0.7174389352143007}, \
{-3.414213562373095, 4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-0.08578643762690485, -3.3155151465676163`}, \
{-2.914213562373095, 1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[
             1, 2]}}, {{-0.08578643762690485, -1.5834643389987393`}, \
{-2.914213562373095, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{-0.08578643762690485, 
         0.14858646857013813`}, {-2.914213562373095, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], -6^Rational[1, 2]}, {-1 - 2^
           Rational[1, 2], 6^Rational[1, 2]}}, {{
         0.41421356237309515`, -2.449489742783178}, {-2.414213562373095, 
         2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-1 - 2^Rational[1, 2], 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{
         0.41421356237309515`, -0.7174389352143007}, {-2.414213562373095, 
         4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2^Rational[1, 2], 2 3^Rational[1, 2] - 6^
           Rational[1, 2]}, {-1 - 2^Rational[1, 2], 2 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{0.41421356237309515`, 
         1.0146118723545765`}, {-2.414213562373095, 5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], 
           Rational[-1, 2] 3^Rational[1, 2] + 6^Rational[1, 2]}}, {{
         0.9142135623730951, -3.3155151465676163`}, {-1.9142135623730951`, 
         1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{
         0.9142135623730951, -1.5834643389987393`}, {-1.9142135623730951`, 
         3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[-1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{0.9142135623730951, 
         0.14858646857013813`}, {-1.9142135623730951`, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{
         1.9142135623730951`, -3.3155151465676163`}, {-0.9142135623730951, 
         1.5834643389987393`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{
         1.9142135623730951`, -1.5834643389987393`}, {-0.9142135623730951, 
         3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[1, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{1.9142135623730951`, 
         0.14858646857013813`}, {-0.9142135623730951, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{1 + 2^Rational[1, 2], -6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], 6^Rational[1, 2]}}, {{
         2.414213562373095, -2.449489742783178}, {-0.41421356237309515`, 
         2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}}, {{
         2.414213562373095, -0.7174389352143007}, {-0.41421356237309515`, 
         4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + 2^Rational[1, 2], 2 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          1 - 2^Rational[1, 2], 2 3^Rational[1, 2] + 6^Rational[1, 2]}}, {{
         2.414213562373095, 1.0146118723545765`}, {-0.41421356237309515`, 
         5.913591357920932}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[3, 2] - 2^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{2.914213562373095, -1.5834643389987393`}, {
         0.08578643762690485, 3.3155151465676163`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] + 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] - 
           6^Rational[1, 2]}, {
          Rational[3, 2] - 2^Rational[1, 2], Rational[3, 2] 3^Rational[1, 2] + 
           6^Rational[1, 2]}}, {{2.914213562373095, 0.14858646857013813`}, {
         0.08578643762690485, 5.047565954136494}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{2 + 2^Rational[1, 2], -6^Rational[1, 2]}, {
          2 - 2^Rational[1, 2], 6^Rational[1, 2]}}, {{
         3.414213562373095, -2.449489742783178}, {0.5857864376269049, 
         2.449489742783178}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 + 2^Rational[1, 2], 3^Rational[1, 2] - 6^Rational[1, 2]}, {
          2 - 2^Rational[1, 2], 3^Rational[1, 2] + 6^Rational[1, 2]}}, {{
         3.414213562373095, -0.7174389352143007}, {0.5857864376269049, 
         4.1815405503520555`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-0.9258200997725514, 0.9405616115553666}, {
         0.9258200997725514, -4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}, {-
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{0.9258200997725514, 
         0.9405616115553666}, {-0.9258200997725514, -4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-1.9258200997725514`, 
         0.9405616115553666}, {-0.07417990022744858, \
-4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.4258200997725514, 
         1.8065870153398051`}, {1.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {
          1 + Rational[6, 7]^Rational[1, 2], (-5) 
            Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}}, {{
         0.07417990022744858, 0.9405616115553666}, {
         1.9258200997725514`, -4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.5741799002274486, 
         1.8065870153398051`}, {2.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.5741799002274486`, 
         1.8065870153398051`}, {3.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.5741799002274486`, 
         1.8065870153398051`}, {-3.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.5741799002274486, 
         1.8065870153398051`}, {-2.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{-0.07417990022744858, 
         0.9405616115553666}, {-1.9258200997725514`, \
-4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.4258200997725514, 
         1.8065870153398051`}, {-1.4258200997725514`, -3.538637822908682}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}, {
          1 - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{1.9258200997725514`, 0.9405616115553666}, {
         0.07417990022744858, -4.4046632266931205`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-1.3516401995451028`, 
         1.2720645315149566`}, {2.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {
          1 + 2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] - 3^
           Rational[1, 2]}}, {{-0.8516401995451028, 0.406039127730518}, {
         2.851640199545103, -3.8701407428682724`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.35164019954510284`, 
         1.2720645315149566`}, {3.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2 Rational[6, 7]^Rational[1, 2], 4 
           Rational[2, 7]^Rational[1, 2]}, {
          2 + 2 Rational[6, 7]^Rational[1, 2], (-4) 
           Rational[2, 7]^Rational[1, 2]}}, {{0.14835980045489716`, 
         2.138089935299395}, {3.851640199545103, -2.138089935299395}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.6483598004548972, 
         1.2720645315149566`}, {4.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{-0.6483598004548972, 
         1.2720645315149566`}, {-4.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 2 Rational[6, 7]^Rational[1, 2], 4 
           Rational[2, 7]^Rational[1, 2]}, {-2 - 2 
           Rational[6, 7]^Rational[1, 2], (-4) 
           Rational[2, 7]^Rational[1, 2]}}, {{-0.14835980045489716`, 
         2.138089935299395}, {-3.851640199545103, -2.138089935299395}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{0.35164019954510284`, 
         1.2720645315149566`}, {-3.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] - 3^Rational[1, 2]}, {-1 - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] - 
           3^Rational[1, 2]}}, {{0.8516401995451028, 
         0.406039127730518}, {-2.851640199545103, -3.8701407428682724`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{1.3516401995451028`, 
         1.2720645315149566`}, {-2.351640199545103, -3.0041153390838335`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 3 Rational[6, 7]^Rational[1, 2], Rational[2, 7]^
           Rational[1, 2]}, {
          2 + 3 Rational[6, 7]^Rational[1, 2], -
           Rational[2, 7]^Rational[1, 2]}}, {{-0.7774602993176543, 
         0.5345224838248488}, {4.777460299317655, -0.5345224838248488}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 3 Rational[6, 7]^Rational[1, 2], Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          2 + 3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.7774602993176543, 2.266573291393726}, {
         4.777460299317655, 1.1975283237440284`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 
            3^Rational[
              1, 2]}}, {{-0.27746029931765426`, -0.3315029199595898}, {
         5.277460299317655, -1.4005478876092874`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 
           3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.27746029931765426`, 
         1.4005478876092874`}, {5.277460299317655, 0.3315029199595898}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 3 
           Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}}, {{
         0.27746029931765426`, -0.3315029199595898}, {-5.277460299317655, \
-1.4005478876092874`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 3 
           Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.27746029931765426`, 
         1.4005478876092874`}, {-5.277460299317655, 0.3315029199595898}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 3 Rational[6, 7]^Rational[1, 2], Rational[2, 7]^
           Rational[1, 2]}, {-2 - 3 Rational[6, 7]^Rational[1, 2], -
           Rational[2, 7]^Rational[1, 2]}}, {{0.7774602993176543, 
         0.5345224838248488}, {-4.777460299317655, -0.5345224838248488}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 3 
           Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{0.7774602993176543, 
         2.266573291393726}, {-4.777460299317655, 1.1975283237440284`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 3 Rational[6, 7]^Rational[1, 2], -
           Rational[2, 7]^Rational[1, 2]}, {
          2 + 3 Rational[6, 7]^Rational[1, 2], Rational[2, 7]^
           Rational[1, 2]}}, {{-0.7774602993176543, -0.5345224838248488}, {
         4.777460299317655, 0.5345224838248488}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{
          2 - 3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {
          2 + 3 Rational[6, 7]^Rational[1, 2], Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}}, {{-0.7774602993176543, 1.1975283237440284`}, {
         4.777460299317655, 2.266573291393726}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 3 
           Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{-0.27746029931765426`, 
         0.3315029199595898}, {5.277460299317655, 1.4005478876092874`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 3 
           Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.27746029931765426`, 
         2.0635537275284674`}, {5.277460299317655, 3.1325986951781646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}}, {{0.27746029931765426`, 
         0.3315029199595898}, {-5.277460299317655, 1.4005478876092874`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.27746029931765426`, 
         2.0635537275284674`}, {-5.277460299317655, 3.1325986951781646`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[
        NCache[{{-2 + 3 Rational[6, 7]^Rational[1, 2], -
           Rational[2, 7]^Rational[1, 2]}, {-2 - 3 
           Rational[6, 7]^Rational[1, 2], Rational[2, 7]^Rational[1, 2]}}, {{
         0.7774602993176543, -0.5345224838248488}, {-4.777460299317655, 
         0.5345224838248488}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           3 Rational[6, 7]^Rational[1, 2], -Rational[2, 7]^Rational[1, 2] + 
           3^Rational[1, 2]}, {-2 - 3 Rational[6, 7]^Rational[1, 2], 
           Rational[2, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.7774602993176543, 1.1975283237440284`}, {-4.777460299317655, 
         2.266573291393726}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-1.3516401995451028`, 
         0.45998627605392084`}, {2.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - 2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.8516401995451028, 
         1.3260116798383592`}, {2.851640199545103, 5.60219155043715}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.35164019954510284`, 
         0.45998627605392084`}, {3.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          2 - 2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {
          2 + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 3^Rational[1, 2]}}, {{
         0.14835980045489716`, -0.406039127730518}, {3.851640199545103, 
         3.8701407428682724`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - 2 
           Rational[6, 7]^Rational[1, 2], (-4) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.6483598004548972, 
         0.45998627605392084`}, {4.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{-0.6483598004548972, 
         0.45998627605392084`}, {-4.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-2 + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 3^Rational[1, 2]}, {-2 - 2 
           Rational[6, 7]^Rational[1, 2], 4 Rational[2, 7]^Rational[1, 2] + 
           3^Rational[
             1, 2]}}, {{-0.14835980045489716`, -0.406039127730518}, \
{-3.851640199545103, 3.8701407428682724`}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{0.35164019954510284`, 
         0.45998627605392084`}, {-3.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {-1 - 2 
           Rational[6, 7]^Rational[1, 2], 4 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.8516401995451028, 
         1.3260116798383592`}, {-2.851640199545103, 5.60219155043715}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           2 Rational[6, 7]^Rational[1, 2], (-4) 
            Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - 2 Rational[6, 7]^Rational[1, 2], 
           4 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{1.3516401995451028`, 
         0.45998627605392084`}, {-2.351640199545103, 4.736166146652711}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.9258200997725514, 0.7914891960135106}, {
         0.9258200997725514, 6.136714034261998}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}}, {{
         0.9258200997725514, 0.7914891960135106}, {-0.9258200997725514, 
         6.136714034261998}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-1.9258200997725514`, 
         0.7914891960135106}, {-0.07417990022744858, 6.136714034261998}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[1, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.4258200997725514, -0.07453620777092773}, {
         1.4258200997725514`, 5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {
          1 + Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{0.07417990022744858, 0.7914891960135106}, {
         1.9258200997725514`, 6.136714034261998}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[3, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[3, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.5741799002274486, -0.07453620777092773}, {2.4258200997725514`, 
         5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[5, 2] - Rational[6, 7]^
           Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[5, 2] + Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         1.5741799002274486`, -0.07453620777092773}, {3.4258200997725514`, 
         5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-5, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-5, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-1.5741799002274486`, -0.07453620777092773}, \
{-3.4258200997725514`, 5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-3, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-3, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 
            3^Rational[
              1, 2]}}, {{-0.5741799002274486, -0.07453620777092773}, \
{-2.4258200997725514`, 5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{-1 + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}, {-1 - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{-0.07417990022744858, 
         0.7914891960135106}, {-1.9258200997725514`, 6.136714034261998}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          Rational[-1, 2] + 
           Rational[6, 7]^Rational[1, 2], (-5) Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2] - Rational[6, 7]^Rational[1, 2], 
           5 Rational[2, 7]^Rational[1, 2] + 
           Rational[3, 2] 3^Rational[1, 2]}}, {{
         0.4258200997725514, -0.07453620777092773}, {-1.4258200997725514`, 
         5.27068863047756}}]]}, 
      {GrayLevel[0], Thickness[0.001], 
       LineBox[NCache[{{
          1 + Rational[6, 7]^Rational[1, 2], (-5) 
            Rational[2, 7]^Rational[1, 2] + 2 3^Rational[1, 2]}, {
          1 - Rational[6, 7]^Rational[1, 2], 5 Rational[2, 7]^Rational[1, 2] + 
           2 3^Rational[1, 2]}}, {{1.9258200997725514`, 0.7914891960135106}, {
         0.07417990022744858, 6.136714034261998}}]]}},
     Background->GrayLevel[1],
     ImageSize->{102.66666666666583`, Automatic},
     PlotRange->{{-2, 2}, {-2, 2}},
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
    RowBox[{"ImageResolution", "\[Rule]", "600"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.4498496070498*^9, 3.449849682975*^9}, {
   3.449849737185*^9, 3.4498497474966*^9}, {3.4498497875886*^9, 
   3.4498497997566*^9}, 3.449850152691*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"pt2", ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_Graphics"}], "}"}], "\[RuleDelayed]", 
    RowBox[{"a", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.449850252455*^9, 3.4498503448226*^9}, {
  3.4498504097966003`*^9, 3.4498504174406*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"nlines", "=", 
   RowBox[{"N", "[", 
    RowBox[{"lines", "/.", "pt2"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4498504257398*^9, 3.4498504429309998`*^9}, 
   3.4498505099486*^9, {3.4498506094298*^9, 3.4498506191642*^9}}],

Cell[BoxData[
 RowBox[{"nlines", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "10"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.449850623657*^9, 3.4498506420182*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"clusters", "=", 
   RowBox[{"FindClusters", "[", "nlines", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4498501607874002`*^9, 3.4498501976521997`*^9}, {
  3.449850231941*^9, 3.4498502339066*^9}, {3.4498504486874*^9, 
  3.4498504497326*^9}, {3.4498505181386003`*^9, 3.4498505549702*^9}, {
  3.4498506509102*^9, 3.4498506586322002`*^9}, {3.449850754073*^9, 
  3.4498507561322002`*^9}, {3.449938584988241*^9, 3.449938587281441*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", "clusters", "]"}]], "Input",
 CellChangeTimes->{{3.4498508989034*^9, 3.4498509048626003`*^9}}],

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"0.17", "*", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "3.01"}], ",", "1", ",", "1", ",", "2", ",", "2.1"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4498506793022003`*^9, 3.449850730361*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"lines", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4498505715685997`*^9, 3.4498505813654003`*^9}}]
},
PrintingStyleEnvironment->"Working",
WindowSize->{1172, 891},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{14.4, 14.4}, {72., 72.}}},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[552, 13, 454, 10, 43, "Input"],
Cell[1009, 25, 490, 13, 125, "Input"],
Cell[1502, 40, 8340, 184, 422, "Input"],
Cell[9845, 226, 9019, 211, 629, "Input"],
Cell[18867, 439, 1632, 46, 307, "Input"],
Cell[20502, 487, 332, 11, 96, "Input"],
Cell[20837, 500, 2485, 76, 495, "Input"],
Cell[23325, 578, 2504, 61, 220, "Input"],
Cell[25832, 641, 1099, 31, 220, "Input"],
Cell[26934, 674, 1468, 34, 280, "Input"],
Cell[28405, 710, 3178, 88, 645, "Input"],
Cell[31586, 800, 4919, 97, 463, "Input"],
Cell[36508, 899, 88, 1, 144, "Input"],
Cell[36599, 902, 336482, 6380, 600, "Input"],
Cell[373084, 7284, 352, 9, 238, "Input"],
Cell[373439, 7295, 265, 6, 144, "Input"],
Cell[373707, 7303, 169, 4, 144, "Input"],
Cell[373879, 7309, 467, 8, 144, "Input"],
Cell[374349, 7319, 134, 2, 144, "Input"],
Cell[374486, 7323, 328, 9, 144, "Input"],
Cell[374817, 7334, 180, 4, 144, "Input"]
}
]
*)

