(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9992,        310]
NotebookOptionsPosition[      9484,        290]
NotebookOutlinePosition[      9887,        307]
CellTagsIndexPosition[      9844,        304]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 3.689476074453125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], "=", 
   RowBox[{"T1", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"T2", "-", "T1"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]1", "*", 
         RowBox[{"(", 
          RowBox[{"To1", "-", "T1"}], ")"}]}]}], ",", "T1"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], "=", 
   RowBox[{"Tn", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Tnminus"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]n", "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Ton"}], ")"}]}]}], ",", "Tn"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Tpom", "}"}], ",", 
     RowBox[{
      RowBox[{"Tpom", "=", 
       RowBox[{"ListConvolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Fo", ",", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}], 
        "]"}]}], ";", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fTn", "[", 
         RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ";", 
      RowBox[{"PrependTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"6", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotik", "[", 
    RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"nel", "=", 
        RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i"}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"lispom", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
           RowBox[{"list", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"lispom", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Ton", "-", "2"}], ",", 
             RowBox[{"To1", "+", "2"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"tpopis", "=", 
          RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<t=\>\"", "<>", 
           RowBox[{"ToString", "[", "tpopis", "]"}], "<>", "\"\< s\>\""}]}]}],
         ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 3.689476362265625*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"plots", "[", 
    RowBox[{"[", "i", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Ttry", "=", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       SubscriptBox["T", "i"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     RowBox[{"ClearAll", "[", "Fo", "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ListConvolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", 
     RowBox[{"ListCorrelate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", "%"}], "===", "%%"}]}], "*)"}]], "Input",
 CellChangeTimes->{3.689476233734375*^9}]
},
WindowSize->{1003, 740},
WindowMargins->{{24, Automatic}, {Automatic, 40}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 330, 9, 92, "Input"],
Cell[878, 31, 1900, 52, 466, "Input"],
Cell[2781, 85, 4931, 144, 656, "Input"],
Cell[7715, 231, 536, 16, 67, "Input"],
Cell[8254, 249, 256, 8, 41, "Input"],
Cell[8513, 259, 967, 29, 142, "Input"]
}
]
*)

(* End of internal cache information *)
