(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48743,       1304]
NotebookOptionsPosition[     47881,       1276]
NotebookOutlinePosition[     48281,       1293]
CellTagsIndexPosition[     48238,       1290]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", "pom"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kW", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", "3600."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kWh", "=", 
   RowBox[{"kW", "*", "h"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GJ", "=", 
    RowBox[{"1.", "*", 
     SuperscriptBox["10", "9"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"myInt", ",", "e"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myInt", "[", 
    RowBox[{"vyrt_", ",", "t1_", ",", "t2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"e", "[", "t2", "]"}], "/.", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"e", "'"}], "[", "t", "]"}], "\[Equal]", "vyrt"}], ",", 
         RowBox[{
          RowBox[{"e", "[", "t1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "e",
        ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "t1", ",", "t2"}], "}"}], ",", 
       RowBox[{"SolveDelayed", "\[Rule]", "True"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        FractionBox[
         RowBox[{"Abs", "[", 
          RowBox[{"t2", "-", "t1"}], "]"}], "1000"]}], ",", 
       RowBox[{"MaxSteps", "\[Rule]", 
        SuperscriptBox["10", "6"]}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4531791488873825`*^9, 3.4531791500280075`*^9}, {
   3.4531837757623825`*^9, 3.4531837760592575`*^9}, {3.4531875703873825`*^9, 
   3.4531875707467575`*^9}, {3.45451787773632*^9, 3.454517879598998*^9}, {
   3.4545977000783997`*^9, 3.4545977008115997`*^9}, {3.4550252076704645`*^9, 
   3.4550252327765656`*^9}, {3.550218023921875*^9, 3.550218033765625*^9}, 
   3.56035131378125*^9, {3.56035616353125*^9, 3.560356164046875*^9}, {
   3.561558558453125*^9, 3.561558563234375*^9}, 3.56155920684375*^9, {
   3.56156675884375*^9, 3.561566811015625*^9}, {3.56156684496875*^9, 
   3.561566878640625*^9}, {3.562824767421875*^9, 3.56282476796875*^9}, {
   3.562825362171875*^9, 3.562825362609375*^9}, {3.56282593725*^9, 
   3.562825937890625*^9}, {3.562826383671875*^9, 3.562826384328125*^9}, {
   3.562826482953125*^9, 3.56282650803125*^9}, {3.564250849125*^9, 
   3.564250859296875*^9}, {3.56882040753125*^9, 3.568820445296875*^9}, {
   3.570031644734375*^9, 3.570031652171875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n1", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n2", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tlist1", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n1", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Tlist2", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"n1", "+", "1"}], ",", 
      RowBox[{"n1", "+", "n2"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.568821272703125*^9, 3.568821303671875*^9}, {
   3.5688213863125*^9, 3.568821472953125*^9}, {3.56882151040625*^9, 
   3.568821510609375*^9}, {3.568821561078125*^9, 3.5688216156875*^9}, {
   3.56882167421875*^9, 3.5688217051875*^9}, {3.568821958640625*^9, 
   3.56882196959375*^9}, 3.568822028484375*^9, {3.568822264*^9, 
   3.5688223546875*^9}, {3.569421391953125*^9, 3.569421392375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "newList", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"newList", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"list1_", ",", "list2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Fo1_", ",", "Fo2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"qdop1_", ",", "qdop2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[CapitalDelta]x1_", ",", "\[CapitalDelta]x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]1_", ",", "\[Lambda]2_"}], "}"}]}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "inList1", ",", "inList2", ",", "T1", ",", "T12", ",", "T2", ",", 
        "T2n", ",", "TL", ",", "TP", ",", "Ts", ",", "listVys1", ",", 
        "listVys2"}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"inList1", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{"list1", ",", 
          RowBox[{"{", 
           RowBox[{"Fo1", ",", 
            RowBox[{"1", "-", 
             RowBox[{"2.", "Fo1"}]}], ",", "Fo1"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"inList2", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{"list2", ",", 
          RowBox[{"{", 
           RowBox[{"Fo2", ",", 
            RowBox[{"1", "-", 
             RowBox[{"2.", "Fo2"}]}], ",", "Fo2"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"T12", "=", 
        RowBox[{"inList1", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"T1", "=", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "qdop1"}], " ", "\[CapitalDelta]x1"}], "+", 
          RowBox[{"T12", " ", "\[Lambda]1"}]}], "\[Lambda]1"]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"T2n", "=", 
        RowBox[{"inList2", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"T2", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"qdop2", " ", "\[CapitalDelta]x2"}], "+", 
          RowBox[{"T2n", " ", "\[Lambda]2"}]}], "\[Lambda]2"]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"TL", "=", 
        RowBox[{"inList1", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"TP", "=", 
        RowBox[{"inList2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Ts", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"TL", " ", "\[CapitalDelta]x2", " ", "\[Lambda]1"}], "+", 
          RowBox[{"TP", " ", "\[CapitalDelta]x1", " ", "\[Lambda]2"}]}], 
         RowBox[{
          RowBox[{"\[CapitalDelta]x2", " ", "\[Lambda]1"}], "+", 
          RowBox[{"\[CapitalDelta]x1", " ", "\[Lambda]2"}]}]]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"listVys1", "=", 
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"Prepend", "[", 
           RowBox[{"inList1", ",", "T1"}], "]"}], ",", "Ts"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"listVys2", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"inList2", ",", "T2"}], "]"}], ",", "Ts"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"listVys1", ",", "listVys2"}], "}"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.569421166265625*^9, 3.569421308578125*^9}, 
   3.56942149340625*^9, 3.569478798921875*^9, {3.56947887765625*^9, 
   3.569478956203125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vcka", " ", "jsou", " ", "vrstvy"}], ",", " ", 
    RowBox[{"ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"d", ",", "rocp", ",", "\[Lambda]"}], "}"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"v1", "=", 
     RowBox[{"{", 
      RowBox[{"0.45", ",", 
       RowBox[{"1.35", "*", 
        SuperscriptBox["10", "6"]}], ",", "0.8"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v2", "=", 
     RowBox[{"{", 
      RowBox[{"0.15", ",", 
       RowBox[{"5.", "*", 
        SuperscriptBox["10", "4"]}], ",", "0.2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v3", "=", 
     RowBox[{"{", 
      RowBox[{"0.45", ",", 
       RowBox[{"1.35", "*", 
        SuperscriptBox["10", "6"]}], ",", "0.8"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v4", "=", 
     RowBox[{"{", 
      RowBox[{"0.15", ",", 
       RowBox[{"5.", "*", 
        SuperscriptBox["10", "4"]}], ",", "0.2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v5", "=", 
     RowBox[{"{", 
      RowBox[{"0.15", ",", 
       RowBox[{"1.35", "*", 
        SuperscriptBox["10", "6"]}], ",", "0.8"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v6", "=", 
     RowBox[{"{", 
      RowBox[{"0.15", ",", 
       RowBox[{"5.", "*", 
        SuperscriptBox["10", "4"]}], ",", "0.2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vrstvy", "=", 
     RowBox[{"{", 
      RowBox[{"v1", ",", "v2", ",", "v3", ",", "v4", ",", "v5", ",", "v6"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"alfa", "[", "\[CapitalDelta]T_", "]"}], "=", 
     RowBox[{"<<", "\"\<alfa\>\""}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.569421632328125*^9, 3.569421813671875*^9}, {
  3.56942184528125*^9, 3.569421864703125*^9}, {3.569421992375*^9, 
  3.5694219928125*^9}, {3.569422086265625*^9, 3.569422095453125*^9}, {
  3.56942447809375*^9, 3.569424483640625*^9}, {3.569424669453125*^9, 
  3.5694247210625*^9}, {3.569424978796875*^9, 3.569424980265625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "20."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kN", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"n", ",", "focka", ",", "Fo"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fo", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d_", ",", "rocp_", ",", "\[Lambda]_"}], "}"}], ",", "n_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "\[CapitalDelta]x"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       FractionBox["\[Lambda]", "rocp"]}], ";", 
      RowBox[{"\[CapitalDelta]x", "=", 
       FractionBox["d", "n"]}], ";", 
      FractionBox[
       RowBox[{"a", "*", "\[CapitalDelta]t"}], 
       SuperscriptBox["\[CapitalDelta]x", "2"]]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"focka", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Fo", "[", 
      RowBox[{"#", ",", "n"}], "]"}], "&"}], "/@", "vrstvy"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"kN", "*", 
     RowBox[{"Min", "[", 
      RowBox[{"Abs", "/@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"n", "/.", 
         RowBox[{"Solve", "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "\[Equal]", "0.5"}], "&"}], "/@", "focka"}], 
           ")"}]}]}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"focka", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Fo", "[", 
      RowBox[{"#", ",", "n"}], "]"}], "&"}], "/@", "vrstvy"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<n= \>\"", ",", "n", ",", "\"\<  focka= \>\"", ",", "focka"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5694220425625*^9, 3.5694220699375*^9}, {
   3.56942210009375*^9, 3.5694225525625*^9}, {3.569422615171875*^9, 
   3.56942264696875*^9}, 3.56942311196875*^9, {3.569423145875*^9, 
   3.56942326840625*^9}, 3.56942441484375*^9, {3.569424514390625*^9, 
   3.569424551609375*^9}, 3.56942458184375*^9, {3.569424826359375*^9, 
   3.569424839609375*^9}, 3.569424894765625*^9, 3.569424928625*^9, {
   3.5694249875625*^9, 3.56942502525*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"To1Start", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To2Start", "=", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pocatek", "[", 
    RowBox[{"zed", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d1_", ",", "rocp1_", ",", "\[Lambda]1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d2_", ",", "rocp2_", ",", "\[Lambda]2_"}], "}"}]}], "}"}]}], 
    "]"}], ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "T1", ",", "T2", ",", "Ts", ",", "rce", ",", "listVys1", ",", 
       "listVys2"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"rce", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"To1Start", "-", "T1"}], ")"}], "*", 
           RowBox[{"alfa", "[", 
            RowBox[{"To1Start", "-", "T1"}], "]"}]}], "\[Equal]", 
          FractionBox[
           RowBox[{"\[Lambda]1", "*", 
            RowBox[{"(", 
             RowBox[{"T1", "-", "Ts"}], ")"}]}], "d1"]}], ",", 
         RowBox[{
          FractionBox[
           RowBox[{"\[Lambda]1", "*", 
            RowBox[{"(", 
             RowBox[{"T1", "-", "Ts"}], ")"}]}], "d1"], "==", 
          FractionBox[
           RowBox[{"\[Lambda]2", "*", 
            RowBox[{"(", 
             RowBox[{"Ts", "-", "T2"}], ")"}]}], "d1"]}], ",", 
         RowBox[{
          FractionBox[
           RowBox[{"\[Lambda]1", "*", 
            RowBox[{"(", 
             RowBox[{"T1", "-", "Ts"}], ")"}]}], "d1"], "==", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"T2", "-", "To2Start"}], ")"}], "*", 
           RowBox[{"alfa", "[", 
            RowBox[{"T2", "-", "To2Start"}], "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T1", ",", "Ts", ",", "T2"}], "}"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"T1", ",", "Ts", ",", "T2"}], "}"}], "/.", 
        RowBox[{"FindRoot", "[", 
         RowBox[{"rce", ",", 
          RowBox[{"{", 
           RowBox[{"T1", ",", 
            RowBox[{"To1Start", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Ts", ",", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{"To1Start", "+", "To2Start"}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"T2", ",", 
            RowBox[{"To2Start", "+", "1"}]}], "}"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"listVys1", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"T1", ",", "Ts", ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"T1", "-", "Ts"}], 
           RowBox[{"n", "-", "1"}]]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"listVys2", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"Ts", ",", "T2", ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"Ts", "-", "T2"}], 
           RowBox[{"n", "-", "1"}]]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"listVys1", ",", "listVys2"}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocatek", "[", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2"}], "}"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.569422802890625*^9, 3.569422823515625*^9}, {
   3.569422925640625*^9, 3.569422994203125*^9}, {3.5694230405*^9, 
   3.569423091953125*^9}, 3.569423272046875*^9, {3.569423332234375*^9, 
   3.569423606359375*^9}, {3.5694236745*^9, 3.56942375834375*^9}, {
   3.569424143875*^9, 3.569424208359375*^9}, {3.5694242600625*^9, 
   3.569424393640625*^9}, 3.56942444871875*^9, 3.569424496515625*^9, 
   3.56942459459375*^9, {3.569477671203125*^9, 3.56947768965625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"zed1", "=", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zed2", "=", 
   RowBox[{"{", 
    RowBox[{"v3", ",", "v4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zed3", "=", 
   RowBox[{"{", 
    RowBox[{"v5", ",", "v6"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ficka", "=", 
   RowBox[{"(", GridBox[{
      {"0", "0.34", "0.33", "0.33"},
      {"0.34", "0", "0.34", "0.33"},
      {"0.33", "0.34", "0", "0.34"},
      {"0.33", "0.33", "0.34", "0"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "=", 
    RowBox[{"ficka", "-", 
     RowBox[{"IdentityMatrix", "[", "4", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "matici", " ", "mat", " ", "vynasobim", " ", "salave", " ", "toky", " ", 
    "z", " ", "jednotlivych", " ", "sten", " ", "a", " ", "dostanu", " ", 
    "bilancmi", " ", "dopadajici", " ", "toky"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.56942463028125*^9, 3.5694246488125*^9}, {
   3.569425041265625*^9, 3.569425051515625*^9}, {3.569425230265625*^9, 
   3.569425261046875*^9}, {3.56942652521875*^9, 3.5694266385625*^9}, {
   3.569426698640625*^9, 3.56942672096875*^9}, {3.569426771703125*^9, 
   3.569426909625*^9}, {3.56942709471875*^9, 3.569427124953125*^9}, {
   3.569427290953125*^9, 3.569427291234375*^9}, {3.56942736078125*^9, 
   3.5694273885*^9}, 3.569476842796875*^9, {3.569476878109375*^9, 
   3.569476905375*^9}, {3.57003125909375*^9, 3.570031279328125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"zdi", "=", 
   RowBox[{"{", 
    RowBox[{"zed1", ",", "zed2", ",", "zed3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourka", "=", 
   RowBox[{"zdi", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d_", ",", "rocp_", ",", "\[Lambda]_Real"}], "}"}], ":>", 
     RowBox[{"Fo", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "rocp", ",", "\[Lambda]"}], "}"}], ",", "n"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltax", "[", 
    RowBox[{"zed", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d1_", ",", "rocp1_", ",", "\[Lambda]1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d2_", ",", "rocp2_", ",", "\[Lambda]2_"}], "}"}]}], "}"}]}], 
    "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["d1", "n"], ",", 
     FractionBox["d2", "n"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]xs", "=", 
   RowBox[{"deltax", "/@", "zdi"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lambda", "[", 
    RowBox[{"zed", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d1_", ",", "rocp1_", ",", "\[Lambda]1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d2_", ",", "rocp2_", ",", "\[Lambda]2_"}], "}"}]}], "}"}]}], 
    "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]s", "=", 
    RowBox[{"lambda", "/@", "zdi"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocteplots", "=", 
   RowBox[{"pocatek", "/@", "zdi"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pocqs", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.", ",", "0."}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "krokZdi", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krokZdi", "[", 
    RowBox[{"Tss_", ",", "qss_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"newList", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Tss", "[", 
           RowBox[{"[", "#", "]"}], "]"}], ",", 
          RowBox[{"fourka", "[", 
           RowBox[{"[", "#", "]"}], "]"}], ",", 
          RowBox[{"qss", "[", 
           RowBox[{"[", "#", "]"}], "]"}], ",", 
          RowBox[{"\[CapitalDelta]xs", "[", 
           RowBox[{"[", "#", "]"}], "]"}], ",", 
          RowBox[{"\[Lambda]s", "[", 
           RowBox[{"[", "#", "]"}], "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"krokZdi", "[", 
   RowBox[{"pocteplots", ",", "pocqs"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.56947734371875*^9, 3.56947738825*^9}, {
   3.569477424890625*^9, 3.569477569890625*^9}, {3.569477819796875*^9, 
   3.56947799328125*^9}, {3.569478081390625*^9, 3.56947817590625*^9}, {
   3.569478259265625*^9, 3.56947843503125*^9}, {3.569478600765625*^9, 
   3.56947861378125*^9}, {3.56947868934375*^9, 3.569478737140625*^9}, 
   3.5694789846875*^9, {3.56947919609375*^9, 3.56947923634375*^9}, {
   3.569479317171875*^9, 3.569479327953125*^9}, {3.56947937846875*^9, 
   3.56947941721875*^9}, {3.569479476734375*^9, 3.569479521109375*^9}, {
   3.56947974884375*^9, 3.569479756171875*^9}, {3.56947979953125*^9, 
   3.569479820546875*^9}, {3.569480151984375*^9, 3.5694801740625*^9}, 
   3.570083301703125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TdenniPrumerna", "=", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"den", "=", 
   RowBox[{"24", "*", "3600."}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1", "*", "den"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]R", "=", "4."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tden", "[", "t_", "]"}], ":=", 
   RowBox[{"TdenniPrumerna", "+", 
    RowBox[{"7", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "*", "Pi", "*", 
       FractionBox["t", "den"]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qSlunce", "[", "t_", "]"}], ":=", 
   RowBox[{"2", "*", "600", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "*", "Pi", 
      FractionBox["t", "den"]}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Tanh", "[", 
           FractionBox[
            RowBox[{"#", "-", "0.1"}], "0.1"], "]"}]}], ")"}]}], "&"}], ")"}],
      "@", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "*", "Pi", 
       FractionBox["t", "den"]}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5694812204375*^9, 3.569481236890625*^9}, {
  3.569481285609375*^9, 3.56948130896875*^9}, {3.5694819604375*^9, 
  3.56948197209375*^9}, {3.57003059521875*^9, 3.57003060690625*^9}, {
  3.570087514734375*^9, 3.570087545*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "qcka", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qcka", "[", 
    RowBox[{"Tss_", ",", "Tpodl_", ",", "Tvduch_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "qSol", ",", "qk2", ",", "qkacka", ",", "qrka", ",", "qrLefts", ",", 
       "qPodl"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"qSol", "=", 
       RowBox[{"qSlunce", "[", "t", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"qk2", "[", "i_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"T1", ",", "T2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"T1", "=", 
           RowBox[{"Tss", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
          RowBox[{"T2", "=", 
           RowBox[{"Tss", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2", ",", 
              RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Tvduch", "-", "T1"}], ")"}], "*", 
             RowBox[{"alfa", "[", 
              RowBox[{"Tvduch", "-", "T1"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Tden", "[", "t", "]"}], "-", "T2"}], ")"}], "*", 
             RowBox[{"alfa", "[", 
              RowBox[{
               RowBox[{"Tden", "[", "t", "]"}], "-", "T2"}], "]"}]}]}], 
           "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"qkacka", "=", 
       RowBox[{"qk2", "/@", 
        RowBox[{"Range", "[", "3", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"qrLefts", "=", 
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[Sigma]", "*", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Tss", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", ",", "1", ",", "1"}], "]"}], "]"}], "+", 
                "273."}], ")"}], "4"]}], "&"}], "/@", 
           RowBox[{"Range", "[", "3", "]"}]}], ",", 
          RowBox[{"\[Sigma]", "*", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Tpodl", "+", "273."}], ")"}], "4"]}]}], "]"}], ".", 
        "mat"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"qrka", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"qrLefts", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"#", "\[Equal]", "1"}], ",", 
             RowBox[{
              RowBox[{"qSlunce", "[", "t", "]"}], "+", 
              RowBox[{"\[Sigma]", "*", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Tden", "[", "t", "]"}], "+", "273."}], ")"}], 
                  "4"], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Tss", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", ",", "2", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}], "+", "273."}], ")"}], 
                  "4"]}], ")"}]}]}], ",", 
             RowBox[{"\[Sigma]", "*", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Tden", "[", "t", "]"}], "+", "273."}], ")"}], 
                 "4"], "-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Tss", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", ",", "2", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}], "+", "273."}], ")"}], 
                 "4"]}], ")"}]}]}], "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", "3", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"qPodl", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"qrLefts", "[", 
          RowBox[{"[", 
           RowBox[{"-", "1"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"Tpodl", "-", "Tvduch"}], ")"}]}], "*", 
          RowBox[{"alfa", "[", 
           RowBox[{"Tpodl", "-", "Tvduch"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qkacka", ",", "qrka"}], "}"}], ",", "qPodl"}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qcka", "[", 
   RowBox[{"pocteplots", ",", "25.", ",", "20.", ",", "2560"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.569481021421875*^9, 3.56948110778125*^9}, {
   3.56948132290625*^9, 3.569481388953125*^9}, {3.5694814789375*^9, 
   3.569481493046875*^9}, {3.5694815555*^9, 3.569481783203125*^9}, {
   3.569482040921875*^9, 3.569482064796875*^9}, {3.569482113859375*^9, 
   3.569482222375*^9}, {3.56948234871875*^9, 3.569482362203125*^9}, {
   3.56948239378125*^9, 3.569482441171875*^9}, {3.569482480234375*^9, 
   3.56948249665625*^9}, {3.56948270403125*^9, 3.56948279975*^9}, {
   3.569482853703125*^9, 3.569482905*^9}, {3.569482963625*^9, 
   3.569483249328125*^9}, {3.56948329290625*^9, 3.569483461734375*^9}, {
   3.5700304521875*^9, 3.570030460671875*^9}, {3.570030586015625*^9, 
   3.57003058646875*^9}, {3.570030764109375*^9, 3.57003078803125*^9}, {
   3.570031117125*^9, 3.570031142171875*^9}, {3.570032161484375*^9, 
   3.57003216846875*^9}, 3.57003329221875*^9, 3.57003338528125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TtopMax", "=", "60."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cVzuch", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roVzduch", "=", 
     FractionBox["349.", "20"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delka", "=", "6."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sirka", "=", "5."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vyska", "=", "3."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kOkna", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Sokna", "=", "6."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mcVzduch", "=", 
     RowBox[{
     "cVzuch", "*", "roVzduch", "*", "delka", "*", "sirka", "*", "vyska"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"vezmeme", " ", "S1", " ", "obvod", " ", "se", " ", "zisky"}], 
     ",", " ", 
     RowBox[{"S2", " ", "obvod", " ", "bez", " ", "zisku"}], ",", 
     RowBox[{"S3", " ", "strop"}], ",", " ", 
     RowBox[{"S4", " ", "podlaha"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"S1", ",", "S2", ",", "S3", ",", "Spodl"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"delka", "*", "vyska"}], ",", 
       RowBox[{
        RowBox[{"delka", "*", "vyska"}], "+", 
        RowBox[{"2", "*", "sirka", "*", "vyska"}]}], ",", 
       RowBox[{"sirka", "*", "delka"}], ",", 
       RowBox[{"sirka", "*", "delka"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "Rt", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rth", "=", 
     RowBox[{"Rt", "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"(", 
           RowBox[{"26.", "-", 
            FractionBox[
             RowBox[{"40", "+", "35"}], "2"]}], ")"}], "Rt"], "\[Equal]", 
         RowBox[{"-", "7000"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roPodl", "=", "3000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dPodl", "=", 
     RowBox[{"50", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cPodl", "=", "450."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mcPodl", "=", 
     RowBox[{"roPodl", "*", "cPodl", "*", "dPodl", "*", "Spodl"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "nadale", " ", "se", " ", "uvazuje", " ", "stredni", " ", "teplota", " ",
       "vody", " ", "jako", " ", "vstup"}], ",", " ", 
     RowBox[{
     "aby", " ", "nebyla", " ", "nutna", " ", "rovnice", " ", "pro", " ", 
      "vystupni", " ", "teplotu", " ", "vody"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ucinnostRekuperace", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dobaVymenyVzduchu", "=", 
     RowBox[{"6", "h"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"QvzduchVetrani", "[", 
      RowBox[{"Tvzduch_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "ucinnostRekuperace"}], ")"}], "*", "mcVzduch", "*", 
      RowBox[{"(", 
       RowBox[{"Tvzduch", "-", 
        RowBox[{"Tden", "[", "t", "]"}]}], ")"}], "*", 
      FractionBox["1", "dobaVymenyVzduchu"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Qokna", "[", 
      RowBox[{"Tvzduch_", ",", "t_"}], "]"}], ":=", 
     RowBox[{"kOkna", "*", "Sokna", "*", 
      RowBox[{"(", 
       RowBox[{"Tvzduch", "-", 
        RowBox[{"Tden", "[", "t", "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"derTvzduch", "[", 
      RowBox[{"QstenySPodlahou_", ",", "Tvzduch_", ",", "t_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Qvetr", ",", "Qvokna"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Qvetr", "=", 
         RowBox[{"QvzduchVetrani", "[", 
          RowBox[{"Tvzduch", ",", "t"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Qvokna", "=", 
         RowBox[{"Qokna", "[", 
          RowBox[{"Tvzduch", ",", "t"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Qvetr", "+", "QstenySPodlahou", "+", "Qvokna"}], 
          "mcVzduch"]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"derTpodl", "[", 
      RowBox[{"Qpodl_", ",", "Tpodl_", ",", "Ttop_", ",", "t_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Qtop", ",", "solzisk", ",", "Ssolzisk"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Qtop", "=", 
         FractionBox[
          RowBox[{"Ttop", "-", "Tpodl"}], "Rth"]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Ssolzisk", "=", 
         RowBox[{"0.8", "*", "Sokna"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"solzisk", "=", 
         RowBox[{"Ssolzisk", "*", 
          RowBox[{"qSlunce", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
        FractionBox[
         RowBox[{"Qtop", "+", "Qpodl", "+", "solzisk"}], "mcPodl"]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ttop", "[", 
      RowBox[{"Tvzduch_", ",", "Tzadana_", ",", "Tpodl_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Tzadana", ">", "Tvzduch"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{"TtopMax", "*", 
          RowBox[{"Tanh", "[", 
           FractionBox[
            RowBox[{"Tzadana", "-", "Tvzduch"}], "2"], "]"}]}], ",", 
         "Tpodl"}], "]"}], ",", "Tpodl"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Qtop", "[", 
      RowBox[{"Tvzduch_", ",", "Tzadana_", ",", "Tpodl_"}], "]"}], ":=", 
     FractionBox[
      RowBox[{
       RowBox[{"Ttop", "[", 
        RowBox[{"Tvzduch", ",", "Tzadana", ",", "Tpodl"}], "]"}], "-", 
       "Tpodl"}], "Rth"]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tzadana", "[", "t_", "]"}], ":=", 
     RowBox[{"20", "+", 
      RowBox[{"0", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "*", "Pi", "*", 
         FractionBox["t", "den"]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plTepls", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Tzadana", "[", "t", "]"}], ",", 
         RowBox[{"Ttop", "[", 
          RowBox[{"20", ",", 
           RowBox[{"Tzadana", "[", "t", "]"}], ",", "23"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "*", "den"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", 
          RowBox[{"Ttop", "[", "\[Degree]C", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plQtop", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["10", 
          RowBox[{"-", "3"}]], 
         RowBox[{"Qtop", "[", 
          RowBox[{"20", ",", 
           RowBox[{"Tzadana", "[", "t", "]"}], ",", "23"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "*", "den"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<Qtop[kW]\>\""}], "}"}]}]}], 
      "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.570030944265625*^9, 3.570031060203125*^9}, {
   3.570031190015625*^9, 3.570031226546875*^9}, {3.570031266578125*^9, 
   3.57003141221875*^9}, {3.570031587828125*^9, 3.570031766609375*^9}, {
   3.570031798828125*^9, 3.57003183815625*^9}, {3.570031930765625*^9, 
   3.570031967875*^9}, 3.570032017734375*^9, 3.570033390359375*^9, 
   3.570033537828125*^9, {3.570033620296875*^9, 3.570033831890625*^9}, {
   3.570033974390625*^9, 3.570033996640625*^9}, {3.570034085859375*^9, 
   3.57003427259375*^9}, {3.57003435421875*^9, 3.570034440140625*^9}, {
   3.570034699390625*^9, 3.570034975140625*^9}, {3.570036060203125*^9, 
   3.570036190859375*^9}, {3.5700362765625*^9, 3.57003661221875*^9}, 
   3.570036654796875*^9, {3.570036686578125*^9, 3.570036746203125*^9}, {
   3.570036778546875*^9, 3.57003679834375*^9}, {3.570036834046875*^9, 
   3.57003685440625*^9}, {3.570036894703125*^9, 3.57003703903125*^9}, {
   3.570037165109375*^9, 3.570037167734375*^9}, {3.570037282796875*^9, 
   3.5700373669375*^9}, {3.570082619765625*^9, 3.570082713375*^9}, {
   3.57008274825*^9, 3.570082798890625*^9}, {3.570082948703125*^9, 
   3.5700829595*^9}, {3.570083005078125*^9, 3.570083123140625*^9}, {
   3.57008430990625*^9, 3.57008432034375*^9}, 3.57008695659375*^9, {
   3.570087380953125*^9, 3.570087410046875*^9}, 3.570087498328125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "krokSystemu", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"krokSystemu", "[", 
      RowBox[{"{", 
       RowBox[{
       "Tss_List", ",", "Tpodl_", ",", "Tvzduch_", ",", "Wtop_", ",", 
        "t_Real"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "qkacka", ",", "qrka", ",", "qPodl", ",", "qsZdi", ",", 
         "QstenySPodlahou", ",", "Qpodl", ",", "newTss", ",", "newTpodl", ",",
          "TtopAct", ",", "newTvzduch", ",", "Tzad", ",", "newWtop", ",", 
         "vys"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"qkacka", ",", "qrka"}], "}"}], ",", "qPodl"}], "}"}], 
         "=", 
         RowBox[{"qcka", "[", 
          RowBox[{"Tss", ",", "Tpodl", ",", "Tvzduch", ",", "t"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"qsZdi", "=", 
         RowBox[{"qkacka", "+", "qrka"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Qpodl", "=", 
         RowBox[{"Spodl", "*", 
          RowBox[{"Plus", "@@", "qPodl"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"QstenySPodlahou", "=", 
         RowBox[{
          RowBox[{"Spodl", "*", 
           RowBox[{"qPodl", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ".", 
           RowBox[{"First", "/@", "qkacka"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"newTss", "=", 
         RowBox[{"krokZdi", "[", 
          RowBox[{"Tss", ",", "qsZdi"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"TtopAct", "=", 
         RowBox[{"Ttop", "[", 
          RowBox[{"Tvzduch", ",", 
           RowBox[{"Tzad", "=", 
            RowBox[{"Tzadana", "[", "t", "]"}]}], ",", "Tpodl"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"newTpodl", "=", 
         RowBox[{"Tpodl", "+", 
          RowBox[{"\[CapitalDelta]t", "*", 
           RowBox[{"derTpodl", "[", 
            RowBox[{"Qpodl", ",", "Tpodl", ",", "TtopAct", ",", "t"}], 
            "]"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newTvzduch", "=", 
         RowBox[{"Tvzduch", "+", 
          RowBox[{"\[CapitalDelta]t", "*", 
           RowBox[{"derTvzduch", "[", 
            RowBox[{"QstenySPodlahou", ",", "Tvzduch", ",", "t"}], 
            "]"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newWtop", "=", 
         RowBox[{"Wtop", "+", 
          RowBox[{"\[CapitalDelta]t", "*", 
           RowBox[{"Qtop", "[", 
            RowBox[{"Tvzduch", ",", "Tzad", ",", "Tpodl"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vys", "=", 
         RowBox[{"{", 
          RowBox[{
          "newTss", ",", "newTpodl", ",", "newTvzduch", ",", "newWtop", ",", 
           RowBox[{"t", "+", "\[CapitalDelta]t"}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"pro", " ", "ladeni"}], ",", " ", 
          RowBox[{
          "je", " ", "diuny", " ", "ze", " ", "teplota", " ", "klesa"}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Spodl", "*", 
           RowBox[{"qPodl", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", "QstenySPodlahou", ",", 
          RowBox[{"derTvzduch", "[", 
           RowBox[{"QstenySPodlahou", ",", "Tvzduch", ",", "t"}], "]"}]}], 
         "}"}], ";", "\[IndentingNewLine]", "vys"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"krokSystemu", "[", 
    RowBox[{"{", 
     RowBox[{"pocteplots", ",", "35.", ",", "20", ",", "0", ",", "0."}], 
     "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.57003748*^9, 3.570037516765625*^9}, {3.5700375815625*^9,
    3.570037607890625*^9}, {3.570037988296875*^9, 3.570037989015625*^9}, {
   3.57008351634375*^9, 3.5700835430625*^9}, {3.57008358825*^9, 
   3.570083611296875*^9}, {3.570083645140625*^9, 3.570083679109375*^9}, {
   3.57008377565625*^9, 3.57008394909375*^9}, {3.570084213953125*^9, 
   3.570084245625*^9}, {3.570084359796875*^9, 3.570084360390625*^9}, {
   3.570084394421875*^9, 3.570084426109375*^9}, {3.570084531359375*^9, 
   3.570084570703125*^9}, {3.570084627546875*^9, 3.57008464903125*^9}, {
   3.570084690171875*^9, 3.570084697703125*^9}, {3.570084738765625*^9, 
   3.570084739921875*^9}, {3.570084784078125*^9, 3.570084873359375*^9}, {
   3.57008491946875*^9, 3.570084960625*^9}, {3.570085681328125*^9, 
   3.57008575190625*^9}, {3.570085827328125*^9, 3.5700861495*^9}, {
   3.570086280609375*^9, 3.57008637240625*^9}, 3.57008707375*^9, {
   3.570087112046875*^9, 3.57008713878125*^9}, {3.5700871696875*^9, 
   3.570087195046875*^9}, {3.570087232265625*^9, 3.57008723265625*^9}, {
   3.570087362140625*^9, 3.570087367859375*^9}, {3.570087425*^9, 
   3.57008743903125*^9}, {3.57008746946875*^9, 3.5700874898125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmaxpom", "=", 
   RowBox[{"3.", "h"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nKroku", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmaxpom", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpodl0", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tvzduch0", "=", "20."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W0", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t0", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocStav", "=", 
   RowBox[{"{", 
    RowBox[{
    "pocteplots", ",", "Tpodl0", ",", "Tvzduch0", ",", "W0", ",", "t0"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"respom", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"NestList", "[", 
     RowBox[{"krokSystemu", ",", "pocStav", ",", "nKroku"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<trvalo to: \>\"", ",", 
    RowBox[{"respom", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"respom", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.570086418125*^9, 3.57008661584375*^9}, {
  3.57008665028125*^9, 3.570086692078125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vTpodl", "=", 
   RowBox[{"res", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Tss_List", ",", "Tpodl_", ",", "Tvzduch_", ",", "Wtop_", ",", 
       "t_Real"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "Tpodl"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vTvzduch", "=", 
   RowBox[{"res", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Tss_List", ",", "Tpodl_", ",", "Tvzduch_", ",", "Wtop_", ",", 
       "t_Real"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "Tvzduch"}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "vTpodl", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "vTvzduch", "]"}]}], "Input",
 CellChangeTimes->{{3.570086713875*^9, 3.570086760515625*^9}, {
  3.570086906015625*^9, 3.570086934390625*^9}}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->1.350000023841858,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3869, 100, 486, "Input"],
Cell[4417, 122, 972, 25, 108, "Input"],
Cell[5392, 149, 3943, 99, 651, "Input"],
Cell[9338, 250, 2188, 65, 252, "Input"],
Cell[11529, 317, 2319, 66, 246, "Input"],
Cell[13851, 385, 3962, 106, 486, "Input"],
Cell[17816, 493, 1637, 40, 265, "Input"],
Cell[19456, 535, 3813, 105, 427, "Input"],
Cell[23272, 642, 1643, 48, 217, "Input"],
Cell[24918, 692, 5994, 152, 403, "Input"],
Cell[30915, 846, 9538, 243, 1383, "Input"],
Cell[40456, 1091, 5124, 114, 476, "Input"],
Cell[45583, 1207, 1393, 40, 289, "Input"],
Cell[46979, 1249, 898, 25, 108, "Input"]
}
]
*)

(* End of internal cache information *)
