(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    123280,       5833]
NotebookOptionsPosition[    115942,       5600]
NotebookOutlinePosition[    116285,       5615]
CellTagsIndexPosition[    116242,       5612]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
autor: Ladislav Musil

Lit:
[1]Young W. Kwon, Hyochoong Bang: The Finite Element Method using Matlab, 1997\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
Metody zalo\[ZHacek]en\[EAcute] na metod\[EHacek] v\[AAcute]hov\[YAcute]ch \
residu\[IAcute] (Methods of Weighted Residual)
\
\>", "Section",
 FontSize->16],

Cell["\<\
Z\[AAcute]kladn\[IAcute] my\[SHacek]lenky budou uk\[AAcute]z\[AAcute]ny na n\
\[AAcute]sleduj\[IAcute]c\[IAcute] \[UAcute]loze\
\>", "Text"],

Cell["Zad\[AAcute]n\[IAcute] \[UAcute]lohy", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rov", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"x", ",", "x"}]], 
     RowBox[{"T", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"3", "*", "0.2", "*", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"T", "[", "x", "]"}], "-", "20"}], ")"}]}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{
    RowBox[{"T", "[", "0", "]"}], "\[Equal]", "0"}]}], ";", 
  RowBox[{"okr2", "=", 
   RowBox[{
    RowBox[{"T", "[", "1", "]"}], "\[Equal]", "0"}]}], ";"}]], "Input",
 CellChangeTimes->{3.720931044140625*^9}],

Cell["\<\
Te\[DHacek] si navrhneme tvar \[RHacek]e\[SHacek]en\[IAcute], tedy omez\
\[IAcute]me mno\[ZHacek]inu v\[SHacek]ech funkc\[IAcute], mezi \
kter\[YAcute]mi hled\[AAcute]me \[RHacek]e\[SHacek]en\[IAcute] na \
mno\[ZHacek]inu popsatelnou jedn\[IAcute]m tvarem s n\[EHacek]kolika \
parametry a spl\[NHacek]uj\[IAcute]c\[IAcute] okrajov\[EAcute] \
podm\[IAcute]nky. \
\>", "Text"],

Cell["\<\
Tvar jenom s jedn\[IAcute]m parametrem:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tapr", "=", 
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"Tapr", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.235442 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -6 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.5)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(1)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(1.5)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(2)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(2.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29725 m
.02756 .29725 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57978 m
.02756 .57978 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01472 L
.03944 .01472 L
.04011 .01472 L
.04132 .01472 L
.04262 .01472 L
.04327 .01472 L
.04396 .01472 L
.04519 .01472 L
.04588 .01472 L
.04652 .01472 L
.04722 .01472 L
.04797 .01472 L
.04862 .01472 L
.04933 .01472 L
.05061 .01472 L
.05186 .01472 L
.05302 .01472 L
.05414 .01472 L
.05519 .01472 L
.05634 .01472 L
.05759 .01472 L
.05882 .01472 L
.06012 .01472 L
.06123 .01472 L
.06244 .01472 L
.06315 .01472 L
.06381 .01472 L
.06453 .01472 L
.06529 .01472 L
.06657 .01472 L
.06729 .01472 L
.06797 .01472 L
.06924 .01472 L
.0704 .01472 L
.07103 .01472 L
.07173 .01472 L
.073 .01472 L
Mistroke
.07376 .01472 L
.07448 .01472 L
.07513 .01472 L
.07583 .01472 L
.0766 .01472 L
.0774 .01472 L
.07809 .01472 L
.07885 .01472 L
.07956 .01472 L
.0802 .01472 L
.08095 .01472 L
.08166 .01472 L
.08291 .01472 L
.08362 .01472 L
.08427 .01472 L
.08544 .01472 L
.08669 .01472 L
.08787 .01472 L
.08896 .01472 L
.09016 .01472 L
.09148 .01472 L
.09214 .01472 L
.09285 .01472 L
.09413 .01472 L
.09483 .01472 L
.09548 .01472 L
.09619 .01472 L
.09695 .01472 L
.09821 .01472 L
.09893 .01472 L
.09961 .01472 L
.10086 .01472 L
.10201 .01472 L
.10333 .01472 L
.10458 .01472 L
.10572 .01472 L
.10694 .01472 L
.1081 .01472 L
.10916 .01472 L
.11033 .01472 L
.11162 .01472 L
.11227 .01472 L
.11297 .01472 L
.11422 .01472 L
.11491 .01472 L
.11554 .01472 L
.11624 .01472 L
.11698 .01472 L
.11822 .01472 L
.11892 .01472 L
Mistroke
.11958 .01472 L
.12081 .01472 L
.12194 .01472 L
.12323 .01472 L
.12446 .01472 L
.12562 .01472 L
.12668 .01472 L
.12789 .01472 L
.12903 .01472 L
.13009 .01472 L
.13107 .01472 L
.13214 .01472 L
.13327 .01472 L
.13441 .01472 L
.13564 .01472 L
.1368 .01472 L
.13785 .01472 L
.13909 .01472 L
.13979 .01472 L
.14043 .01472 L
.14162 .01472 L
.14288 .01472 L
.14402 .01472 L
.14526 .01472 L
.14656 .01472 L
.14777 .01472 L
.14891 .01472 L
.14994 .01472 L
.15113 .01472 L
.15226 .01472 L
.15348 .01472 L
.15478 .01472 L
.15589 .01472 L
.15711 .01472 L
.15842 .01472 L
.15915 .01472 L
.15982 .01472 L
.16113 .01472 L
.16236 .01472 L
.16352 .01472 L
.16456 .01472 L
.16577 .01472 L
.1669 .01472 L
.16796 .01472 L
.16893 .01472 L
.16999 .01472 L
.17111 .01472 L
.17225 .01472 L
.17347 .01472 L
.17462 .01472 L
Mistroke
.17566 .01472 L
.17689 .01472 L
.17758 .01472 L
.17823 .01472 L
.1794 .01472 L
.18065 .01472 L
.18185 .01472 L
.18316 .01472 L
.18441 .01472 L
.18556 .01472 L
.1867 .01472 L
.18773 .01472 L
.18893 .01472 L
.19005 .01472 L
.19128 .01472 L
.19258 .01472 L
.19369 .01472 L
.19491 .01472 L
.19623 .01472 L
.19696 .01472 L
.19763 .01472 L
.19894 .01472 L
.20017 .01472 L
.20122 .01472 L
.20238 .01472 L
.20359 .01472 L
.20472 .01472 L
.20578 .01472 L
.20675 .01472 L
.20781 .01472 L
.20894 .01472 L
.21008 .01472 L
.21129 .01472 L
.21244 .01472 L
.21349 .01472 L
.21472 .01472 L
.21541 .01472 L
.21605 .01472 L
.21723 .01472 L
.21847 .01472 L
.21968 .01472 L
.221 .01472 L
.22224 .01472 L
.2234 .01472 L
.22454 .01472 L
.22558 .01472 L
.22677 .01472 L
.2279 .01472 L
.22914 .01472 L
.23044 .01472 L
Mistroke
.23155 .01472 L
.23277 .01472 L
.23409 .01472 L
.23482 .01472 L
.2355 .01472 L
.2368 .01472 L
.23804 .01472 L
.23909 .01472 L
.24025 .01472 L
.24146 .01472 L
.2426 .01472 L
.24365 .01472 L
.24462 .01472 L
.24569 .01472 L
.24681 .01472 L
.24795 .01472 L
.24917 .01472 L
.25032 .01472 L
.25137 .01472 L
.2526 .01472 L
.25329 .01472 L
.25393 .01472 L
.2551 .01472 L
.25635 .01472 L
.25756 .01472 L
.25888 .01472 L
.26013 .01472 L
.26129 .01472 L
.26233 .01472 L
.26348 .01472 L
.26467 .01472 L
.2658 .01472 L
.26704 .01472 L
.26835 .01472 L
.26946 .01472 L
.27068 .01472 L
.272 .01472 L
.27274 .01472 L
.27341 .01472 L
.27472 .01472 L
.27595 .01472 L
.27701 .01472 L
.27817 .01472 L
.27938 .01472 L
.28052 .01472 L
.28158 .01472 L
.28255 .01472 L
.28367 .01472 L
.28474 .01472 L
.28588 .01472 L
Mistroke
.2871 .01472 L
.28825 .01472 L
.2893 .01472 L
.29053 .01472 L
.29122 .01472 L
.29186 .01472 L
.29303 .01472 L
.29427 .01472 L
.29549 .01472 L
.29618 .01472 L
.29682 .01472 L
.29799 .01472 L
.29923 .01472 L
.30034 .01472 L
.30138 .01472 L
.30252 .01472 L
.30375 .01472 L
.30499 .01472 L
.30569 .01472 L
.30634 .01472 L
.30765 .01472 L
.30839 .01472 L
.30906 .01472 L
.31026 .01472 L
.31156 .01472 L
.31278 .01472 L
.31392 .01472 L
.31497 .01472 L
.31611 .01472 L
.31718 .01472 L
.31816 .01472 L
.3193 .01472 L
.32055 .01472 L
.32173 .01472 L
.32282 .01472 L
.32406 .01472 L
.32522 .01472 L
.32626 .01472 L
.32739 .01472 L
.32862 .01472 L
.32992 .01472 L
.33103 .01472 L
.33225 .01472 L
.33356 .01472 L
.33477 .01472 L
.33541 .01472 L
.3361 .01472 L
.33683 .01472 L
.33751 .01472 L
.33876 .01472 L
Mistroke
.33991 .01472 L
.34123 .01472 L
.34249 .01472 L
.3436 .01472 L
.3448 .01472 L
.34592 .01472 L
.34694 .01472 L
.34814 .01472 L
.34945 .01472 L
.35067 .01472 L
.35181 .01472 L
.35302 .01472 L
.35431 .01472 L
.35554 .01472 L
.35665 .01472 L
.35796 .01472 L
.3587 .01472 L
.35939 .01472 L
.36064 .01472 L
.36128 .01472 L
.36198 .01472 L
.36266 .01472 L
.36337 .01472 L
.36465 .01472 L
.36536 .01472 L
.36602 .01472 L
.36675 .01472 L
.36753 .01472 L
.3682 .01472 L
.36893 .01472 L
.36962 .01472 L
.37026 .01472 L
.37146 .01472 L
.37274 .01472 L
.37394 .01472 L
.37526 .01472 L
.37651 .01472 L
.37766 .01472 L
.3788 .01472 L
.37984 .01472 L
.38103 .01472 L
.38216 .01472 L
.38339 .01472 L
.3847 .01472 L
.38581 .01472 L
.38703 .01472 L
.38834 .01472 L
.38908 .01472 L
.38975 .01472 L
.39106 .01472 L
Mistroke
.39229 .01472 L
.39334 .01472 L
.3945 .01472 L
.39571 .01472 L
.39685 .01472 L
.39791 .01472 L
.39888 .01472 L
.39994 .01472 L
.40106 .01472 L
.40221 .01472 L
.40342 .01472 L
.40457 .01472 L
.40562 .01472 L
.40685 .01472 L
.40754 .01472 L
.40818 .01472 L
.40936 .01472 L
.4106 .01472 L
.41181 .01472 L
.41313 .01472 L
.41438 .01472 L
.41554 .01472 L
.41669 .01472 L
.41772 .01472 L
.41892 .01472 L
.42005 .01472 L
.42129 .01472 L
.42259 .01472 L
.42371 .01472 L
.42493 .01472 L
.42624 .01472 L
.42698 .01472 L
.42765 .01472 L
.42896 .01472 L
.43019 .01472 L
.43125 .01472 L
.43241 .01472 L
.43362 .01472 L
.43476 .01472 L
.43582 .01472 L
.43679 .01472 L
.43791 .01472 L
.43898 .01472 L
.44012 .01472 L
.44134 .01472 L
.44249 .01472 L
.44354 .01472 L
.44477 .01472 L
.44546 .01472 L
.4461 .01472 L
Mistroke
.44727 .01472 L
.44851 .01472 L
.44973 .01472 L
.45042 .01472 L
.45106 .01472 L
.45223 .01472 L
.45347 .01472 L
.45458 .01472 L
.45562 .01472 L
.45676 .01472 L
.45799 .01472 L
.45922 .01472 L
.45992 .01472 L
.46057 .01472 L
.46188 .01472 L
.46262 .01472 L
.46329 .01472 L
.46449 .01472 L
.46579 .01472 L
.46702 .01472 L
.46815 .01472 L
.4692 .01472 L
.47034 .01472 L
.47141 .01472 L
.47239 .01472 L
.47353 .01472 L
.47478 .01472 L
.47596 .01472 L
.47705 .01472 L
.47829 .01472 L
.47945 .01472 L
.48049 .01472 L
.48162 .01472 L
.48285 .01472 L
.48415 .01472 L
.48526 .01472 L
.48648 .01472 L
.48779 .01472 L
.489 .01472 L
.48963 .01472 L
.49033 .01472 L
.49105 .01472 L
.49174 .01472 L
.49299 .01472 L
.49413 .01472 L
.49539 .01472 L
.49671 .01472 L
.49783 .01472 L
.49902 .01472 L
.50014 .01472 L
Mistroke
.50116 .01472 L
.50236 .01472 L
.50366 .01472 L
.50489 .01472 L
.50603 .01472 L
.50723 .01472 L
.50853 .01472 L
.50975 .01472 L
.51087 .01472 L
.51218 .01472 L
.51292 .01472 L
.51361 .01472 L
.51486 .01472 L
.5155 .01472 L
.5162 .01472 L
.51687 .01472 L
.51759 .01472 L
.51886 .01472 L
.51958 .01472 L
.52024 .01472 L
.52096 .01472 L
.52174 .01472 L
.52241 .01472 L
.52314 .01472 L
.52383 .01472 L
.52447 .01472 L
.52568 .01472 L
.52695 .01472 L
.52816 .01472 L
.52947 .01472 L
.53072 .01472 L
.53187 .01472 L
.53301 .01472 L
.53405 .01472 L
.53525 .01472 L
.53637 .01472 L
.5376 .01472 L
.53891 .01472 L
.54002 .01472 L
.54124 .01472 L
.54255 .01472 L
.54329 .01472 L
.54396 .01472 L
.54526 .01472 L
.5465 .01472 L
.54755 .01472 L
.54871 .01472 L
.54992 .01472 L
.55105 .01472 L
.55211 .01472 L
Mistroke
.55308 .01472 L
.55415 .01472 L
.55527 .01472 L
.55641 .01472 L
.55763 .01472 L
.55878 .01472 L
.55982 .01472 L
.56105 .01472 L
.56175 .01472 L
.56238 .01472 L
.56356 .01472 L
.5648 .01472 L
.56601 .01472 L
.56734 .01472 L
.56858 .01472 L
.56974 .01472 L
.57088 .01472 L
.57192 .01472 L
.57312 .01472 L
.57425 .01472 L
.57548 .01472 L
.57679 .01472 L
.5779 .01472 L
.57912 .01472 L
.58044 .01472 L
.58118 .01472 L
.58185 .01472 L
.58315 .01472 L
.58439 .01472 L
.58544 .01472 L
.5866 .01472 L
.58782 .01472 L
.58895 .01472 L
.59001 .01472 L
.59098 .01472 L
.5921 .01472 L
.59317 .01472 L
.59431 .01472 L
.59553 .01472 L
.59668 .01472 L
.59773 .01472 L
.59896 .01472 L
.59965 .01472 L
.60029 .01472 L
.60146 .01472 L
.60271 .01472 L
.60392 .01472 L
.60461 .01472 L
.60525 .01472 L
.60642 .01472 L
Mistroke
.60766 .01472 L
.60876 .01472 L
.6098 .01472 L
.61094 .01472 L
.61217 .01472 L
.61341 .01472 L
.6141 .01472 L
.61475 .01472 L
.61607 .01472 L
.6168 .01472 L
.61747 .01472 L
.61867 .01472 L
.61997 .01472 L
.6212 .01472 L
.62233 .01472 L
.62339 .01472 L
.62452 .01472 L
.62559 .01472 L
.62657 .01472 L
.62771 .01472 L
.62896 .01472 L
.63014 .01472 L
.63123 .01472 L
.63247 .01472 L
.63363 .01472 L
.63467 .01472 L
.6358 .01472 L
.63703 .01472 L
.63833 .01472 L
.63944 .01472 L
.64066 .01472 L
.64197 .01472 L
.64318 .01472 L
.64381 .01472 L
.6445 .01472 L
.64523 .01472 L
.64591 .01472 L
.64716 .01472 L
.64831 .01472 L
.64956 .01472 L
.65088 .01472 L
.652 .01472 L
.65319 .01472 L
.65431 .01472 L
.65533 .01472 L
.65653 .01472 L
.65784 .01472 L
.65906 .01472 L
.6602 .01472 L
.6614 .01472 L
Mistroke
.6627 .01472 L
.66392 .01472 L
.66504 .01472 L
.66635 .01472 L
.66709 .01472 L
.66777 .01472 L
.66903 .01472 L
.66966 .01472 L
.67036 .01472 L
.67104 .01472 L
.67175 .01472 L
.67303 .01472 L
.67374 .01472 L
.6744 .01472 L
.67513 .01472 L
.67591 .01472 L
.67658 .01472 L
.67731 .01472 L
.678 .01472 L
.67864 .01472 L
.67984 .01472 L
.68112 .01472 L
.68232 .01472 L
.68364 .01472 L
.68488 .01472 L
.68603 .01472 L
.68718 .01472 L
.68821 .01472 L
.68941 .01472 L
.69053 .01472 L
.69176 .01472 L
.69307 .01472 L
.69418 .01472 L
.6954 .01472 L
.69671 .01472 L
.69745 .01472 L
.69812 .01472 L
.69942 .01472 L
.70066 .01472 L
.70171 .01472 L
.70286 .01472 L
.70407 .01472 L
.70521 .01472 L
.70627 .01472 L
.70724 .01472 L
.7083 .01472 L
.70942 .01472 L
.71056 .01472 L
.71178 .01472 L
.71293 .01472 L
Mistroke
.71398 .01472 L
.71521 .01472 L
.7159 .01472 L
.71654 .01472 L
.71771 .01472 L
.71896 .01472 L
.72017 .01472 L
.72149 .01472 L
.72273 .01472 L
.72389 .01472 L
.72503 .01472 L
.72607 .01472 L
.72727 .01472 L
.7284 .01472 L
.72963 .01472 L
.73094 .01472 L
.73205 .01472 L
.73327 .01472 L
.73458 .01472 L
.73532 .01472 L
.73599 .01472 L
.7373 .01472 L
.73853 .01472 L
.73959 .01472 L
.74075 .01472 L
.74196 .01472 L
.7431 .01472 L
.74416 .01472 L
.74513 .01472 L
.74619 .01472 L
.74731 .01472 L
.74846 .01472 L
.74967 .01472 L
.75083 .01472 L
.75187 .01472 L
.7531 .01472 L
.75379 .01472 L
.75443 .01472 L
.75561 .01472 L
.75685 .01472 L
.75806 .01472 L
.75875 .01472 L
.75939 .01472 L
.76056 .01472 L
.7618 .01472 L
.7629 .01472 L
.76394 .01472 L
.76508 .01472 L
.76631 .01472 L
.76754 .01472 L
Mistroke
.76824 .01472 L
.76889 .01472 L
.7702 .01472 L
.77094 .01472 L
.77161 .01472 L
.7728 .01472 L
.7741 .01472 L
.77533 .01472 L
.77646 .01472 L
.77752 .01472 L
.77865 .01472 L
.77972 .01472 L
.7807 .01472 L
.78184 .01472 L
.78309 .01472 L
.78427 .01472 L
.78536 .01472 L
.7866 .01472 L
.78776 .01472 L
.7888 .01472 L
.78993 .01472 L
.79116 .01472 L
.79246 .01472 L
.79357 .01472 L
.79479 .01472 L
.7961 .01472 L
.7973 .01472 L
.79793 .01472 L
.79863 .01472 L
.79936 .01472 L
.80004 .01472 L
.80129 .01472 L
.80243 .01472 L
.80369 .01472 L
.80501 .01472 L
.80612 .01472 L
.80731 .01472 L
.80843 .01472 L
.80945 .01472 L
.81066 .01472 L
.81196 .01472 L
.81318 .01472 L
.81432 .01472 L
.81552 .01472 L
.81682 .01472 L
.81804 .01472 L
.81916 .01472 L
.82047 .01472 L
.8212 .01472 L
.82189 .01472 L
Mistroke
.82315 .01472 L
.82385 .01472 L
.82448 .01472 L
.82516 .01472 L
.82587 .01472 L
.82715 .01472 L
.82786 .01472 L
.82852 .01472 L
.82925 .01472 L
.83002 .01472 L
.8307 .01472 L
.83143 .01472 L
.83212 .01472 L
.83275 .01472 L
.83396 .01472 L
.83524 .01472 L
.83644 .01472 L
.83775 .01472 L
.839 .01472 L
.84015 .01472 L
.84129 .01472 L
.84232 .01472 L
.84352 .01472 L
.84464 .01472 L
.84587 .01472 L
.84718 .01472 L
.84829 .01472 L
.8495 .01472 L
.85082 .01472 L
.85155 .01472 L
.85222 .01472 L
.85353 .01472 L
.85476 .01472 L
.85581 .01472 L
.85697 .01472 L
.85818 .01472 L
.85932 .01472 L
.86037 .01472 L
.86134 .01472 L
.86241 .01472 L
.86353 .01472 L
.86467 .01472 L
.86589 .01472 L
.86704 .01472 L
.86808 .01472 L
.86931 .01472 L
.87 .01472 L
.87064 .01472 L
.87182 .01472 L
.87306 .01472 L
Mistroke
.87427 .01472 L
.87559 .01472 L
.87684 .01472 L
.87799 .01472 L
.87914 .01472 L
.88017 .01472 L
.88137 .01472 L
.88249 .01472 L
.88373 .01472 L
.88503 .01472 L
.88615 .01472 L
.88737 .01472 L
.88868 .01472 L
.88942 .01472 L
.89009 .01472 L
.89139 .01472 L
.89263 .01472 L
.89368 .01472 L
.89484 .01472 L
.89605 .01472 L
.89719 .01472 L
.89825 .01472 L
.89922 .01472 L
.90029 .01472 L
.90141 .01472 L
.90255 .01472 L
.90377 .01472 L
.90492 .01472 L
.90596 .01472 L
.90719 .01472 L
.90789 .01472 L
.90852 .01472 L
.9097 .01472 L
.91094 .01472 L
.91216 .01472 L
.91284 .01472 L
.91348 .01472 L
.91464 .01472 L
.91589 .01472 L
.91699 .01472 L
.91803 .01472 L
.91917 .01472 L
.9204 .01472 L
.92163 .01472 L
.92233 .01472 L
.92297 .01472 L
.92429 .01472 L
.92502 .01472 L
.92569 .01472 L
.92689 .01472 L
Mistroke
.92819 .01472 L
.92941 .01472 L
.93055 .01472 L
.9316 .01472 L
.93273 .01472 L
.9338 .01472 L
.93478 .01472 L
.93592 .01472 L
.93717 .01472 L
.93835 .01472 L
.93944 .01472 L
.94068 .01472 L
.94184 .01472 L
.94288 .01472 L
.94401 .01472 L
.94524 .01472 L
.94654 .01472 L
.94765 .01472 L
.94887 .01472 L
.94975 .01472 L
.95057 .01472 L
.95146 .01472 L
.95241 .01472 L
.95324 .01472 L
.95401 .01472 L
.95486 .01472 L
.95577 .01472 L
.95653 .01472 L
.95737 .01472 L
.95824 .01472 L
.95905 .01472 L
.95981 .01472 L
.9605 .01472 L
.9613 .01472 L
.96206 .01472 L
.96287 .01472 L
.96377 .01472 L
.96471 .01472 L
.96559 .01472 L
.96641 .01472 L
.96716 .01472 L
.96802 .01472 L
.96884 .01472 L
.96972 .01472 L
.97067 .01472 L
.97155 .01472 L
.97236 .01472 L
.97331 .01472 L
.97433 .01472 L
.9753 .01472 L
Mistroke
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .02388 L
.10458 .03299 L
.14415 .04071 L
.18221 .04736 L
.22272 .05362 L
.26171 .05884 L
.30316 .06352 L
.34309 .06718 L
.3815 .06993 L
.40095 .07103 L
.42237 .07201 L
.44268 .07272 L
.45178 .07297 L
.46172 .0732 L
.4671 .07329 L
.4721 .07337 L
.47727 .07344 L
.48196 .07349 L
.48658 .07353 L
.4887 .07354 L
.49093 .07355 L
.49332 .07356 L
.49438 .07357 L
.49552 .07357 L
.49675 .07357 L
.49789 .07357 L
.49859 .07358 L
.49925 .07358 L
.50049 .07358 L
.50163 .07357 L
.50286 .07357 L
.50401 .07357 L
.50508 .07357 L
.50754 .07356 L
.51014 .07355 L
.51268 .07353 L
.51504 .07352 L
.5204 .07347 L
.5293 .07335 L
.53882 .07318 L
.54906 .07295 L
.56016 .07264 L
.58032 .0719 L
.60019 .07097 L
.62123 .06976 L
.65912 .067 L
.69946 .06325 L
.73829 .05884 L
.77956 .05329 L
Mistroke
.81932 .04711 L
.85757 .04039 L
.89827 .0324 L
.93745 .0239 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .03304 L
.10458 .05126 L
.14415 .0667 L
.18221 .08001 L
.22272 .09252 L
.26171 .10296 L
.30316 .11232 L
.34309 .11965 L
.3815 .12515 L
.40095 .12734 L
.42237 .12931 L
.44268 .13073 L
.45178 .13123 L
.46172 .13168 L
.4671 .13187 L
.4721 .13203 L
.47727 .13217 L
.48196 .13227 L
.48658 .13234 L
.4887 .13237 L
.49093 .13239 L
.49332 .13241 L
.49438 .13242 L
.49552 .13243 L
.49675 .13243 L
.49789 .13243 L
.49859 .13243 L
.49925 .13244 L
.50049 .13244 L
.50163 .13243 L
.50286 .13243 L
.50401 .13243 L
.50508 .13242 L
.50754 .13241 L
.51014 .13238 L
.51268 .13235 L
.51504 .13232 L
.5204 .13222 L
.5293 .13199 L
.53882 .13165 L
.54906 .13119 L
.56016 .13056 L
.58032 .12909 L
.60019 .12722 L
.62123 .12481 L
.65912 .11929 L
.69946 .11178 L
.73829 .10296 L
.77956 .09186 L
Mistroke
.81932 .0795 L
.85757 .06606 L
.89827 .05009 L
.93745 .03309 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .04221 L
.10458 .06954 L
.14415 .09269 L
.18221 .11265 L
.22272 .13142 L
.26171 .14708 L
.30316 .16112 L
.34309 .17212 L
.3815 .18036 L
.40095 .18366 L
.42237 .1866 L
.44268 .18874 L
.45178 .18949 L
.46172 .19016 L
.4671 .19045 L
.4721 .19069 L
.47727 .19089 L
.48196 .19104 L
.48658 .19116 L
.4887 .1912 L
.49093 .19123 L
.49332 .19126 L
.49438 .19127 L
.49552 .19128 L
.49675 .19129 L
.49789 .19129 L
.49859 .19129 L
.49925 .1913 L
.50049 .1913 L
.50163 .19129 L
.50286 .19129 L
.50401 .19128 L
.50508 .19128 L
.50754 .19125 L
.51014 .19122 L
.51268 .19117 L
.51504 .19112 L
.5204 .19097 L
.5293 .19063 L
.53882 .19012 L
.54906 .18942 L
.56016 .18848 L
.58032 .18627 L
.60019 .18348 L
.62123 .17985 L
.65912 .17158 L
.69946 .16031 L
.73829 .14708 L
.77956 .13044 L
Mistroke
.81932 .11189 L
.85757 .09173 L
.89827 .06778 L
.93745 .04228 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .05137 L
.10458 .08781 L
.14415 .11868 L
.18221 .1453 L
.22272 .17033 L
.26171 .1912 L
.30316 .20993 L
.34309 .22459 L
.3815 .23558 L
.40095 .23997 L
.42237 .2439 L
.44268 .24675 L
.45178 .24774 L
.46172 .24864 L
.4671 .24903 L
.4721 .24935 L
.47727 .24962 L
.48196 .24982 L
.48658 .24997 L
.4887 .25002 L
.49093 .25007 L
.49332 .25011 L
.49438 .25012 L
.49552 .25014 L
.49675 .25015 L
.49789 .25015 L
.49859 .25015 L
.49925 .25016 L
.50049 .25016 L
.50163 .25015 L
.50286 .25015 L
.50401 .25014 L
.50508 .25013 L
.50754 .2501 L
.51014 .25005 L
.51268 .24999 L
.51504 .24992 L
.5204 .24972 L
.5293 .24927 L
.53882 .24859 L
.54906 .24766 L
.56016 .2464 L
.58032 .24346 L
.60019 .23973 L
.62123 .2349 L
.65912 .22387 L
.69946 .20885 L
.73829 .1912 L
.77956 .16901 L
Mistroke
.81932 .14428 L
.85757 .11741 L
.89827 .08547 L
.93745 .05147 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .06053 L
.10458 .10609 L
.14415 .14467 L
.18221 .17794 L
.22272 .20923 L
.26171 .23532 L
.30316 .25873 L
.34309 .27706 L
.3815 .29079 L
.40095 .29628 L
.42237 .30119 L
.44268 .30475 L
.45178 .306 L
.46172 .30712 L
.4671 .30761 L
.4721 .30801 L
.47727 .30835 L
.48196 .3086 L
.48658 .30878 L
.4887 .30885 L
.49093 .30891 L
.49332 .30896 L
.49438 .30898 L
.49552 .30899 L
.49675 .309 L
.49789 .30901 L
.49859 .30901 L
.49925 .30902 L
.50049 .30902 L
.50163 .30901 L
.50286 .30901 L
.50401 .309 L
.50508 .30898 L
.50754 .30894 L
.51014 .30888 L
.51268 .30881 L
.51504 .30872 L
.5204 .30848 L
.5293 .3079 L
.53882 .30706 L
.54906 .30589 L
.56016 .30432 L
.58032 .30065 L
.60019 .29599 L
.62123 .28994 L
.65912 .27616 L
.69946 .25738 L
.73829 .23532 L
.77956 .20758 L
Mistroke
.81932 .17668 L
.85757 .14308 L
.89827 .10315 L
.93745 .06066 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .0697 L
.10458 .12436 L
.14415 .17066 L
.18221 .21059 L
.22272 .24813 L
.26171 .27944 L
.30316 .30753 L
.34309 .32953 L
.3815 .34601 L
.40095 .3526 L
.42237 .35849 L
.44268 .36276 L
.45178 .36426 L
.46172 .3656 L
.4671 .36619 L
.4721 .36667 L
.47727 .36707 L
.48196 .36737 L
.48658 .3676 L
.4887 .36768 L
.49093 .36775 L
.49332 .36781 L
.49438 .36783 L
.49552 .36785 L
.49675 .36786 L
.49789 .36787 L
.49859 .36787 L
.49925 .36788 L
.50049 .36788 L
.50163 .36787 L
.50286 .36787 L
.50401 .36785 L
.50508 .36784 L
.50754 .36779 L
.51014 .36772 L
.51268 .36763 L
.51504 .36753 L
.5204 .36723 L
.5293 .36654 L
.53882 .36553 L
.54906 .36413 L
.56016 .36224 L
.58032 .35783 L
.60019 .35224 L
.62123 .34499 L
.65912 .32844 L
.69946 .30591 L
.73829 .27945 L
.77956 .24616 L
Mistroke
.81932 .20907 L
.85757 .16875 L
.89827 .12084 L
.93745 .06984 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .07886 L
.10458 .14263 L
.14415 .19665 L
.18221 .24323 L
.22272 .28703 L
.26171 .32356 L
.30316 .35633 L
.34309 .382 L
.3815 .40122 L
.40095 .40891 L
.42237 .41579 L
.44268 .42077 L
.45178 .42251 L
.46172 .42408 L
.4671 .42477 L
.4721 .42532 L
.47727 .4258 L
.48196 .42615 L
.48658 .42641 L
.4887 .42651 L
.49093 .42659 L
.49332 .42666 L
.49438 .42668 L
.49552 .4267 L
.49675 .42672 L
.49789 .42673 L
.49859 .42673 L
.49925 .42674 L
.50049 .42674 L
.50163 .42673 L
.50286 .42672 L
.50401 .42671 L
.50508 .42669 L
.50754 .42663 L
.51014 .42655 L
.51268 .42645 L
.51504 .42633 L
.5204 .42598 L
.5293 .42518 L
.53882 .424 L
.54906 .42236 L
.56016 .42016 L
.58032 .41502 L
.60019 .4085 L
.62123 .40003 L
.65912 .38073 L
.69946 .35445 L
.73829 .32357 L
.77956 .28473 L
Mistroke
.81932 .24146 L
.85757 .19442 L
.89827 .13853 L
.93745 .07903 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .08802 L
.10458 .16091 L
.14415 .22264 L
.18221 .27588 L
.22272 .32594 L
.26171 .36768 L
.30316 .40514 L
.34309 .43447 L
.3815 .45644 L
.40095 .46522 L
.42237 .47308 L
.44268 .47878 L
.45178 .48077 L
.46172 .48256 L
.4671 .48335 L
.4721 .48398 L
.47727 .48453 L
.48196 .48492 L
.48658 .48522 L
.4887 .48533 L
.49093 .48543 L
.49332 .48551 L
.49438 .48553 L
.49552 .48556 L
.49675 .48558 L
.49789 .48559 L
.49859 .48559 L
.49925 .4856 L
.50049 .4856 L
.50163 .48559 L
.50286 .48558 L
.50401 .48557 L
.50508 .48555 L
.50754 .48548 L
.51014 .48539 L
.51268 .48526 L
.51504 .48513 L
.5204 .48473 L
.5293 .48382 L
.53882 .48247 L
.54906 .4806 L
.56016 .47808 L
.58032 .4722 L
.60019 .46475 L
.62123 .45508 L
.65912 .43302 L
.69946 .40298 L
.73829 .36769 L
.77956 .3233 L
Mistroke
.81932 .27385 L
.85757 .2201 L
.89827 .15622 L
.93745 .08822 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .09719 L
.10458 .17918 L
.14415 .24863 L
.18221 .30853 L
.22272 .36484 L
.26171 .41181 L
.30316 .45394 L
.34309 .48694 L
.3815 .51165 L
.40095 .52154 L
.42237 .53038 L
.44268 .53678 L
.45178 .53903 L
.46172 .54104 L
.4671 .54193 L
.4721 .54264 L
.47727 .54325 L
.48196 .5437 L
.48658 .54404 L
.4887 .54416 L
.49093 .54427 L
.49332 .54435 L
.49438 .54439 L
.49552 .54441 L
.49675 .54443 L
.49789 .54445 L
.49859 .54445 L
.49925 .54446 L
.50049 .54446 L
.50163 .54445 L
.50286 .54444 L
.50401 .54442 L
.50508 .5444 L
.50754 .54433 L
.51014 .54422 L
.51268 .54408 L
.51504 .54393 L
.5204 .54349 L
.5293 .54245 L
.53882 .54094 L
.54906 .53884 L
.56016 .536 L
.58032 .52939 L
.60019 .52101 L
.62123 .51012 L
.65912 .48531 L
.69946 .45151 L
.73829 .41181 L
.77956 .36188 L
Mistroke
.81932 .30625 L
.85757 .24577 L
.89827 .17391 L
.93745 .09741 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNXUtzFdcRvtyrBwiQEBKSkABdZAlhnsZgHjHg8DAP87AJTmyMY0qm/KBc
hARIkfci5Y2rkl2qUpVlqrLxysk+6/yAbLPM/yBMz71fzxx9fabPnasUt5Bu
c+ac7v66z6P7nJnRjZWnX372cOXpg/sr7cuPV3765YP7T9qXHj1+UdRa12is
azcajb+3Gxn9/AXZ+fX8xb/nu7Nfjcb57KuZFQ+AamXUQEYtkauDGdXKqFes
tnJ1D7mq1P6MGgS/RuOcfIlUoaSw0VgvRKtUvMSrbiRVd8e4ripeTKp9gMiL
g9lAWsRkin0WXioII6TFK0kyY7Vb6HSG8aTvHEzWOs1YoZsiWqd6NMkFOjZH
QOmo2ghqsVxPjRi0PQBqOBdQnAi2ET3k94b/z/Wx7EssMp79WldotT4rGCTt
WWd8mcpY73iZ9POWNXM/accRt8jspGvFXtLwCCl7zVlvCZxFxlAofhi9Qir9
F11/EFfX866XfZSdtP4PqCFQ+WrVKHyMrpzrCE1R3oIOYqp/g/N6DMSgxWAo
ZTiolH2aaL0RhvkXKB3ugf5EJOrz4TkIacG01WU1Bmz/BDWKq01lgpZdeqBC
dGjOMm4NMsYh9x+wwHhZg4IuxGUbizqsQjlAfBSyyv/XFTQJhf6WUTJ1bSsr
nve9opju/werNRq0NApisymY48/QYxZX856x3tKj+z3gtdBA2HqAdqeu+O1Q
6RuoOV8evwVzDVC1Ntmdp1mlmDDXQSiiN2bUM4w5jW2HLQmrFRsMFVMU+dAb
Ckdk91uj40DSMMyyDC1XQC3j6nDAZSiU0P2W2ptjI69rPDbySxbUaONwRo1k
1HXodhhX2TLYIgOyCRtW6ccmMkNdM24QHicyajSjZAnajLIWAAaJS9ClDGVG
PQbuxnllhSsmmE3QTsLDI6D0KjW1b7BH9DZNYNt+CE02g/oO+m9C2WBnfmAa
NiNiq7Rlq0jY8fLhvFpZqfFtecRovRRlO5+xcF4YiiBjfYCV6Vw5Ch/+FdSY
1SKmfmM47Bml7yIMc4LvHZAaZQtg/AWULu3DlTBWzc4tcI2oXxgn3Y8Xia4q
wdVxSP8TqIkyEk90wELMiDeGtE3iPGO6ZBKO+AOoySj0VtCjWK/SQC4CpNov
THVWpvaeAoivQU3hqr1qbYjC6X43K2Dpys6DU0O6qds0MPwG1AxasLTOuTBI
o60VQIKAo0CzNKBbbSjqn7mMEr4/yyhhMYurbLsvRzRShaj73QyRFfpxfBZM
BRUEm9LwC1A7YGbd1Kmep02LR3wVbkJ1Psb6zTphEP4JtQBH3QU1j6ubLS5p
07fwmqiC5nGbc1llmzm6Bye63wKl+cKoCZfJ5ekx2xuIeHVDklfN3CzYVnwV
4C7Bq3vKMAsBEQMXn/d1SSkGTuywwHRHwXyr3RzJXFhOF+yTCufToPbhqh1U
MROMhEpY3x1DGGu1sXnMXDniGAfetZLh0g4iGZ7kejIBjMF2LdipIoOuXHuk
/baoadg60IQWI5XdhE9CDLkOEs0QJFlcyKhTuLoFFAuJmh0rViAvfcctoDOT
6a8+WYANdbXFH6HHOKnHekFrbWzhmH2rrVK9SsSDZe0F35TtUhFdplljKqd0
/tRNGQZ70xrBZs4dgyZfQ7utpJ6dN8TiA46hYw62SIZbI8rKH/eYoepWYP0d
qK1lnzis6Mm/p22EmyOGiRnUDFiDMgX5S0CbtNqa8xGb+YnGRZw0ror4j/mK
lamiKuYpQGpmy/xnh3SV0GZsF45WurB6fDLNNpSRysVHBD1bTFMykVSkzJ1c
kulTU29F+gDUFKnHvFuj4263MYehYy+Y46mJGFzGwwqoaVxlu8M20lXDiu1T
9BGtGXI5/LUdaO+AmrXaVgSlw1S7MgKy9cKNsGUtjSBAdgLwLVA7oi63E7bY
IC9jmE2DHFt+vJA18ZjPqCAz3YWrbL+BQQ5PF0u9fFVxETANZazO4Q2hGGQ9
IlkAZM1JF8qQKzZh/b6ds307HrNZDdzBlsIS3HoEaJfK9dzZhW+TqVMegc78
nRpVmfmTbrhsyiiZxuUwci+usn2HVNTs1HVHFeS+eptprH4/mlEzGXUsaik7
y0vydgT6hOntPidIgufXUS+zMR1Dy7y8swqqKwmqg1bz4WegwqUijranICX7
KY7qwo5S2UK2DCdeXRWEelJG2UMiEQ9EdtkenaznUTNVYouB4NJUgu38ePdk
UmKQ7CcyfNndSmtgAc2INcVQq9jJVM89OTKMDcjebu3Ij+XifVDhFJn9pOVS
fldHcE/5Xe3d12EdViePe2Wr9GiBaPRZrhoZ6QZ4r9PjyeQ0XH0HlJrBm0ym
RJ8VaKf7j1bzqBlgvA1qmrTwjupU3PMF3KqQc4m3ercG18xdCllu2xPDbo8a
yQ44XVNa5FmDGb9vzX13U+05wLsIai5qmt7yiXL9dhVa/64PY89UZJ1zByCf
BrXL2bamvxdsC2yv528TvHhULB/kj21cZRsENYHmjwflnPW5CArZ73Qvbt0l
WIT8PbBA/M4EL25juergZlkL4zLLudjTZ7WymhTKzdASM8+AYg+l1HG/YYbF
CjNI0Wyi+80Tp6BM02c5fJf0+SDKvNsGqQF5FeSgbK5f4IOM6mEZaMXugMuZ
S/1Dxjq2N7dQPA/KuB1tbbRczw5k7UlM8R2JLmQ8mLLqzM9AsTSyH0D35BRb
kGLwvH5kPU/zwRVQ3mPw1LgyAm/nGsHTDY8fg2KZYT/gLRfgiSAWxvTnHj89
/L1ThmXu43gXMabLku23XYl+856YCZgg3WGH+czndaBGuuj8GkHV/nITUNlB
sBeqN0CvhFrNwntQpKmOJu1Xy2XmlpR9Nlat37INsZ3oTaYGU1fBXATUGWdP
8EJlZZVQe/OmF7bm6mcyKn7C7ZDh7cR7bdi7Ix72nn5pzjYHgMcBMP0c2wvr
1QIsPWB1NGQCmCJMYd2G0Icj2UzgHaXepLEINrjkhZ2Ui7IlTLNSMUAbhvem
Y17P7qsPNp58aMYp2a88DSSr6QjKHEapA3G/DZGJr3PCwVSX7jSRleyHKbx7
C94uG4G4uBYQg/zDmzXbZxvlsgP14XjTKe2emm/UzxttOPpITI8+YWGXZqKa
VdTPCctlB22fLDlZeOFoLq/ZhDcH9MI5ZMNh3qkDRzP2H4Kqn/P1HU48w9PE
9VYZRO0M77Ct+nIN1ZlKurlwA1SdLI71gEQ43q0gBkfP068Ajv3AW29wXrPh
sN3iOnB0E+EiKG/i6U1VjhTgiIB9zobmiVlQpkf/Z0HpU9J1QtWi6jRi7S3y
Zke6p8plQQvvkS7T4HUbBPOEF4SZAkr0fAQUO66tA+eoDWd/n+FoNiTTiBxW
6aGs9y7eCIhG+OaPBn/QlNnGCzZ+DjmPDtgG2DZpUSe7ze+UpEN8uNOoWNbg
m/XsNYRevEx7QS5HcBNwrt6vzLIFL943bLzmu+ukiL02MgmiRroToMxsgcFh
HS0CJ/4clf0WzGo4miN8TK7WyeWOV8BxsDhUAxhT/QOAZWmQN6vrAPM+aOkF
wYyiyc+PyNU6qemJHASb3Q/XUJippEG192FgJu2krTB7j6SpcHBq/C4oloUx
5dhwLionzNhrLFnDeIp4DVSdnOqUbbk6aqoNL4MynwF1qPk9W83Xa6ipedEF
UPZLQ6pl9EHNeL5zFmqyBMGr5pu2mkdrqDkJNTWOZrdGetOy07aa7LmPeJCv
B15HQaUfeEVUesPJIn5YdQjKmXdYOmScKagpbI+TSt4bAzWf0H35uRrKnbVt
mKSmANO7FneB2omr3oD5LVulE06VmChRRKJbmWgkumVxvfeWyoiaJ2uoKYcB
8jpttqHpVe77acrFt9g1GPOe+5yzxZ9yimeibjvrsV51vqCSYHkzRZFgz9Eb
zxWF0mk/JbDU3UJvTHzBFn/aKZ4h1X0+b5h4MU2ReKx1CZQ3EHzbFn/GKV5j
KH1xqzfUi4g/6xSvsZEGHd4Q7pIt/i1LvOILQoj4CzYuh4PsHKlk3tkkLY5B
qHcT+YqNzyteUekhvzdYupom3nzrhW4EJ0UcEfHnneKnIFSf1/bGFO/k4mWS
lPWeJdYXLEWaQKpRQwvizajhWkGoI3S9SMoYW7k1J4gQdjpteD1XyXyRoBS9
7VREwhKJAdjdD0z8jVy89/7nS5YiwTrHLHyzaHzXPiWTxgx1g5RFNIjf+XzZ
KfQdcGHGe9ceXVcsAcJM10i2WL9ns71KyphmrFObezrFKfma1TBY3dja/gNb
b8aWQWcrHqt32xZ13WIhep8GxcKD9222rPvpunuyzFYDY87sJirpKnq0XBa0
iDB7j5TpiqlZKosIPrTZ3iJlum2wFxTb3bgTdisWm+vCog80sbO8j2wdGVt9
Q7K+bZgtl3dttu+TMv0LFzKM5eY3zV4/sZnpDRVyd+UoqKBehMUHzm5+z2bx
ISnT24k/Df31ESg2kX1qy7lLythkdN9m8TFk63TzuV39E1LGppEIi3uQo9PD
A7u63oWlw/4ru/p9VDoG6mFo8M9BaYz5yOb5BaprTPjYrq7PG+kR18/t6l+B
ZxvUs7x6I/wTHd0ixwnsTzBw9Bj/V6vYZt95LOkKH56AqY7L3+YN2O1q8XfL
/gIj9Pc5i/RDPPnd+YNPNd9oWmTlPaUqtmGuLam37n+xcjKJ\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0829852, -0.193675, \
0.00386179, 0.0156212}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["Dosad\[IAcute]me tento tvar do rovnice", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rovApr", "=", 
  RowBox[{"rov", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", "x", "]"}], "\[Rule]", "Tapr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "''"}], "[", "x", "]"}], "->", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "x"}]], "Tapr"}]}]}], "}"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "a"}], "\[Equal]", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A p\[RHacek]evedeme v\[SHacek]e na jednu stranu.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residuum", "=", 
  RowBox[{"rovApr", "/.", 
   RowBox[{
    RowBox[{"Equal", "[", 
     RowBox[{"Left_", ",", "Right_"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "Left"}], "+", "Right"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a"}], "+", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Dostaneme tedy n\[EHacek]co co chceme vynulovat, tak zvan\[EAcute] residuum\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"Residuum", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.343238 0.0273769 [
[.21429 .33074 -9 -9 ]
[.21429 .33074 9 0 ]
[.40476 .33074 -9 -9 ]
[.40476 .33074 9 0 ]
[.59524 .33074 -9 -9 ]
[.59524 .33074 9 0 ]
[.78571 .33074 -9 -9 ]
[.78571 .33074 9 0 ]
[.97619 .33074 -3 -9 ]
[.97619 .33074 3 0 ]
[.01131 .06947 -18 -4.5 ]
[.01131 .06947 0 4.5 ]
[.01131 .20635 -12 -4.5 ]
[.01131 .20635 0 4.5 ]
[.01131 .48012 -6 -4.5 ]
[.01131 .48012 0 4.5 ]
[.01131 .61701 -12 -4.5 ]
[.01131 .61701 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .34324 m
.21429 .34949 L
s
[(0.2)] .21429 .33074 0 1 Mshowa
.40476 .34324 m
.40476 .34949 L
s
[(0.4)] .40476 .33074 0 1 Mshowa
.59524 .34324 m
.59524 .34949 L
s
[(0.6)] .59524 .33074 0 1 Mshowa
.78571 .34324 m
.78571 .34949 L
s
[(0.8)] .78571 .33074 0 1 Mshowa
.97619 .34324 m
.97619 .34949 L
s
[(1)] .97619 .33074 0 1 Mshowa
.125 Mabswid
.07143 .34324 m
.07143 .34699 L
s
.11905 .34324 m
.11905 .34699 L
s
.16667 .34324 m
.16667 .34699 L
s
.2619 .34324 m
.2619 .34699 L
s
.30952 .34324 m
.30952 .34699 L
s
.35714 .34324 m
.35714 .34699 L
s
.45238 .34324 m
.45238 .34699 L
s
.5 .34324 m
.5 .34699 L
s
.54762 .34324 m
.54762 .34699 L
s
.64286 .34324 m
.64286 .34699 L
s
.69048 .34324 m
.69048 .34699 L
s
.7381 .34324 m
.7381 .34699 L
s
.83333 .34324 m
.83333 .34699 L
s
.88095 .34324 m
.88095 .34699 L
s
.92857 .34324 m
.92857 .34699 L
s
.25 Mabswid
0 .34324 m
1 .34324 L
s
.02381 .06947 m
.03006 .06947 L
s
[(-10)] .01131 .06947 1 0 Mshowa
.02381 .20635 m
.03006 .20635 L
s
[(-5)] .01131 .20635 1 0 Mshowa
.02381 .48012 m
.03006 .48012 L
s
[(5)] .01131 .48012 1 0 Mshowa
.02381 .61701 m
.03006 .61701 L
s
[(10)] .01131 .61701 1 0 Mshowa
.125 Mabswid
.02381 .09685 m
.02756 .09685 L
s
.02381 .12422 m
.02756 .12422 L
s
.02381 .1516 m
.02756 .1516 L
s
.02381 .17898 m
.02756 .17898 L
s
.02381 .23373 m
.02756 .23373 L
s
.02381 .26111 m
.02756 .26111 L
s
.02381 .28848 m
.02756 .28848 L
s
.02381 .31586 m
.02756 .31586 L
s
.02381 .37062 m
.02756 .37062 L
s
.02381 .39799 m
.02756 .39799 L
s
.02381 .42537 m
.02756 .42537 L
s
.02381 .45275 m
.02756 .45275 L
s
.02381 .5075 m
.02756 .5075 L
s
.02381 .53488 m
.02756 .53488 L
s
.02381 .56225 m
.02756 .56225 L
s
.02381 .58963 m
.02756 .58963 L
s
.02381 .04209 m
.02756 .04209 L
s
.02381 .01472 m
.02756 .01472 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .01472 L
.10458 .01472 L
.14415 .01472 L
.18221 .01472 L
.22272 .01472 L
.26171 .01472 L
.30316 .01472 L
.34309 .01472 L
.3815 .01472 L
.42237 .01472 L
.46172 .01472 L
.49955 .01472 L
.53984 .01472 L
.57861 .01472 L
.61984 .01472 L
.65954 .01472 L
.69774 .01472 L
.73838 .01472 L
.77751 .01472 L
.81909 .01472 L
.85916 .01472 L
.89771 .01472 L
.93871 .01472 L
.97619 .01472 L
s
.02381 .06947 m
.06244 .07011 L
.10458 .07074 L
.14415 .07128 L
.18221 .07175 L
.22272 .07218 L
.26171 .07255 L
.30316 .07287 L
.34309 .07313 L
.3815 .07332 L
.40095 .0734 L
.42237 .07347 L
.44268 .07352 L
.45178 .07353 L
.46172 .07355 L
.4671 .07356 L
.4721 .07356 L
.47727 .07357 L
.48196 .07357 L
.48658 .07357 L
.4887 .07357 L
.49093 .07357 L
.49332 .07357 L
.49438 .07357 L
.49552 .07358 L
.49675 .07358 L
.49789 .07358 L
.49859 .07358 L
.49925 .07358 L
.50049 .07358 L
.50163 .07358 L
.50286 .07358 L
.50401 .07358 L
.50508 .07358 L
.50754 .07357 L
.51014 .07357 L
.51268 .07357 L
.51504 .07357 L
.5204 .07357 L
.5293 .07356 L
.53882 .07355 L
.54906 .07353 L
.56016 .07351 L
.58032 .07346 L
.60019 .07339 L
.62123 .07331 L
.65912 .07312 L
.69946 .07285 L
.73829 .07255 L
.77956 .07216 L
Mistroke
.81932 .07173 L
.85757 .07126 L
.89827 .0707 L
.93745 .07011 L
.97619 .06947 L
Mfstroke
.02381 .12422 m
.06244 .1255 L
.10458 .12677 L
.14415 .12785 L
.18221 .12878 L
.22272 .12965 L
.26171 .13038 L
.30316 .13103 L
.34309 .13154 L
.3815 .13193 L
.40095 .13208 L
.42237 .13222 L
.44268 .13232 L
.45178 .13235 L
.46172 .13238 L
.4671 .1324 L
.4721 .13241 L
.47727 .13242 L
.48196 .13242 L
.48658 .13243 L
.4887 .13243 L
.49093 .13243 L
.49332 .13243 L
.49438 .13243 L
.49552 .13244 L
.49675 .13244 L
.49789 .13244 L
.49859 .13244 L
.49925 .13244 L
.50049 .13244 L
.50163 .13244 L
.50286 .13244 L
.50401 .13244 L
.50508 .13243 L
.50754 .13243 L
.51014 .13243 L
.51268 .13243 L
.51504 .13243 L
.5204 .13242 L
.5293 .1324 L
.53882 .13238 L
.54906 .13235 L
.56016 .1323 L
.58032 .1322 L
.60019 .13207 L
.62123 .1319 L
.65912 .13152 L
.69946 .13099 L
.73829 .13038 L
.77956 .12961 L
Mistroke
.81932 .12874 L
.85757 .1278 L
.89827 .12669 L
.93745 .1255 L
.97619 .12422 L
Mfstroke
.02381 .17898 m
.06244 .18089 L
.10458 .1828 L
.14415 .18442 L
.18221 .18581 L
.22272 .18712 L
.26171 .18821 L
.30316 .18919 L
.34309 .18996 L
.3815 .19053 L
.40095 .19076 L
.42237 .19097 L
.44268 .19112 L
.45178 .19117 L
.46172 .19122 L
.4671 .19124 L
.4721 .19125 L
.47727 .19127 L
.48196 .19128 L
.48658 .19129 L
.4887 .19129 L
.49093 .19129 L
.49332 .19129 L
.49438 .19129 L
.49552 .1913 L
.49675 .1913 L
.49789 .1913 L
.49859 .1913 L
.49925 .1913 L
.50049 .1913 L
.50163 .1913 L
.50286 .1913 L
.50401 .1913 L
.50508 .19129 L
.50754 .19129 L
.51014 .19129 L
.51268 .19129 L
.51504 .19128 L
.5204 .19127 L
.5293 .19125 L
.53882 .19121 L
.54906 .19117 L
.56016 .1911 L
.58032 .19095 L
.60019 .19075 L
.62123 .1905 L
.65912 .18992 L
.69946 .18913 L
.73829 .18821 L
.77956 .18705 L
Mistroke
.81932 .18576 L
.85757 .18435 L
.89827 .18268 L
.93745 .1809 L
.97619 .17898 L
Mfstroke
.02381 .23373 m
.06244 .23629 L
.10458 .23883 L
.14415 .24098 L
.18221 .24284 L
.22272 .24459 L
.26171 .24604 L
.30316 .24735 L
.34309 .24837 L
.3815 .24914 L
.40095 .24945 L
.42237 .24972 L
.44268 .24992 L
.45178 .24999 L
.46172 .25005 L
.4671 .25008 L
.4721 .2501 L
.47727 .25012 L
.48196 .25013 L
.48658 .25014 L
.4887 .25015 L
.49093 .25015 L
.49332 .25015 L
.49438 .25015 L
.49552 .25016 L
.49675 .25016 L
.49789 .25016 L
.49859 .25016 L
.49925 .25016 L
.50049 .25016 L
.50163 .25016 L
.50286 .25016 L
.50401 .25016 L
.50508 .25015 L
.50754 .25015 L
.51014 .25015 L
.51268 .25014 L
.51504 .25014 L
.5204 .25013 L
.5293 .25009 L
.53882 .25005 L
.54906 .24998 L
.56016 .24989 L
.58032 .24969 L
.60019 .24943 L
.62123 .24909 L
.65912 .24832 L
.69946 .24727 L
.73829 .24604 L
.77956 .2445 L
Mistroke
.81932 .24277 L
.85757 .24089 L
.89827 .23867 L
.93745 .23629 L
.97619 .23373 L
Mfstroke
.02381 .28848 m
.06244 .29168 L
.10458 .29486 L
.14415 .29755 L
.18221 .29987 L
.22272 .30206 L
.26171 .30388 L
.30316 .30551 L
.34309 .30679 L
.3815 .30775 L
.40095 .30813 L
.42237 .30847 L
.44268 .30872 L
.45178 .30881 L
.46172 .30888 L
.4671 .30892 L
.4721 .30895 L
.47727 .30897 L
.48196 .30899 L
.48658 .309 L
.4887 .30901 L
.49093 .30901 L
.49332 .30901 L
.49438 .30901 L
.49552 .30902 L
.49675 .30902 L
.49789 .30902 L
.49859 .30902 L
.49925 .30902 L
.50049 .30902 L
.50163 .30902 L
.50286 .30902 L
.50401 .30902 L
.50508 .30901 L
.50754 .30901 L
.51014 .30901 L
.51268 .309 L
.51504 .309 L
.5204 .30898 L
.5293 .30894 L
.53882 .30888 L
.54906 .3088 L
.56016 .30869 L
.58032 .30843 L
.60019 .30811 L
.62123 .30769 L
.65912 .30672 L
.69946 .30541 L
.73829 .30388 L
.77956 .30194 L
Mistroke
.81932 .29978 L
.85757 .29744 L
.89827 .29465 L
.93745 .29169 L
.97619 .28848 L
Mfstroke
.02381 .34324 m
.06244 .34707 L
.10458 .35089 L
.14415 .35412 L
.18221 .3569 L
.22272 .35952 L
.26171 .36171 L
.30316 .36367 L
.34309 .3652 L
.3815 .36635 L
.40095 .36681 L
.42237 .36722 L
.44268 .36752 L
.45178 .36762 L
.46172 .36772 L
.4671 .36776 L
.4721 .36779 L
.47727 .36782 L
.48196 .36784 L
.48658 .36786 L
.4887 .36786 L
.49093 .36787 L
.49332 .36787 L
.49438 .36787 L
.49552 .36788 L
.49675 .36788 L
.49789 .36788 L
.49859 .36788 L
.49925 .36788 L
.50049 .36788 L
.50163 .36788 L
.50286 .36788 L
.50401 .36788 L
.50508 .36787 L
.50754 .36787 L
.51014 .36787 L
.51268 .36786 L
.51504 .36785 L
.5204 .36783 L
.5293 .36778 L
.53882 .36771 L
.54906 .36762 L
.56016 .36748 L
.58032 .36718 L
.60019 .36679 L
.62123 .36628 L
.65912 .36513 L
.69946 .36355 L
.73829 .36171 L
.77956 .35939 L
Mistroke
.81932 .3568 L
.85757 .35398 L
.89827 .35064 L
.93745 .34708 L
.97619 .34324 L
Mfstroke
.02381 .39799 m
.06244 .40247 L
.10458 .40692 L
.14415 .41069 L
.18221 .41394 L
.22272 .41699 L
.26171 .41954 L
.30316 .42183 L
.34309 .42362 L
.3815 .42496 L
.40095 .42549 L
.42237 .42597 L
.44268 .42632 L
.45178 .42644 L
.46172 .42655 L
.4671 .4266 L
.4721 .42664 L
.47727 .42667 L
.48196 .4267 L
.48658 .42671 L
.4887 .42672 L
.49093 .42673 L
.49332 .42673 L
.49438 .42673 L
.49552 .42674 L
.49675 .42674 L
.49789 .42674 L
.49859 .42674 L
.49925 .42674 L
.50049 .42674 L
.50163 .42674 L
.50286 .42674 L
.50401 .42674 L
.50508 .42673 L
.50754 .42673 L
.51014 .42672 L
.51268 .42672 L
.51504 .42671 L
.5204 .42669 L
.5293 .42663 L
.53882 .42655 L
.54906 .42643 L
.56016 .42628 L
.58032 .42592 L
.60019 .42547 L
.62123 .42487 L
.65912 .42353 L
.69946 .42169 L
.73829 .41954 L
.77956 .41683 L
Mistroke
.81932 .41381 L
.85757 .41053 L
.89827 .40663 L
.93745 .40248 L
.97619 .39799 L
Mfstroke
.02381 .45275 m
.06244 .45786 L
.10458 .46295 L
.14415 .46725 L
.18221 .47097 L
.22272 .47446 L
.26171 .47737 L
.30316 .47998 L
.34309 .48203 L
.3815 .48356 L
.40095 .48418 L
.42237 .48472 L
.44268 .48512 L
.45178 .48526 L
.46172 .48539 L
.4671 .48544 L
.4721 .48549 L
.47727 .48552 L
.48196 .48555 L
.48658 .48557 L
.4887 .48558 L
.49093 .48559 L
.49332 .48559 L
.49438 .48559 L
.49552 .4856 L
.49675 .4856 L
.49789 .4856 L
.49859 .4856 L
.49925 .4856 L
.50049 .4856 L
.50163 .4856 L
.50286 .4856 L
.50401 .4856 L
.50508 .48559 L
.50754 .48559 L
.51014 .48558 L
.51268 .48557 L
.51504 .48557 L
.5204 .48554 L
.5293 .48547 L
.53882 .48538 L
.54906 .48525 L
.56016 .48507 L
.58032 .48466 L
.60019 .48414 L
.62123 .48347 L
.65912 .48193 L
.69946 .47983 L
.73829 .47737 L
.77956 .47428 L
Mistroke
.81932 .47083 L
.85757 .46707 L
.89827 .46262 L
.93745 .45787 L
.97619 .45275 L
Mfstroke
.02381 .5075 m
.06244 .51325 L
.10458 .51897 L
.14415 .52382 L
.18221 .528 L
.22272 .53193 L
.26171 .5352 L
.30316 .53814 L
.34309 .54045 L
.3815 .54217 L
.40095 .54286 L
.42237 .54348 L
.44268 .54392 L
.45178 .54408 L
.46172 .54422 L
.4671 .54428 L
.4721 .54433 L
.47727 .54437 L
.48196 .54441 L
.48658 .54443 L
.4887 .54444 L
.49093 .54445 L
.49332 .54445 L
.49438 .54445 L
.49552 .54446 L
.49675 .54446 L
.49789 .54446 L
.49859 .54446 L
.49925 .54446 L
.50049 .54446 L
.50163 .54446 L
.50286 .54446 L
.50401 .54446 L
.50508 .54445 L
.50754 .54445 L
.51014 .54444 L
.51268 .54443 L
.51504 .54442 L
.5204 .54439 L
.5293 .54432 L
.53882 .54421 L
.54906 .54407 L
.56016 .54387 L
.58032 .54341 L
.60019 .54282 L
.62123 .54206 L
.65912 .54033 L
.69946 .53797 L
.73829 .5352 L
.77956 .53172 L
Mistroke
.81932 .52784 L
.85757 .52362 L
.89827 .51861 L
.93745 .51327 L
.97619 .5075 L
Mfstroke
.02381 .56225 m
.06244 .56865 L
.10458 .575 L
.14415 .58039 L
.18221 .58503 L
.22272 .5894 L
.26171 .59304 L
.30316 .5963 L
.34309 .59886 L
.3815 .60078 L
.40095 .60154 L
.42237 .60223 L
.44268 .60272 L
.45178 .6029 L
.46172 .60305 L
.4671 .60312 L
.4721 .60318 L
.47727 .60323 L
.48196 .60326 L
.48658 .60329 L
.4887 .6033 L
.49093 .6033 L
.49332 .60331 L
.49438 .60331 L
.49552 .60332 L
.49675 .60332 L
.49789 .60332 L
.49859 .60332 L
.49925 .60332 L
.50049 .60332 L
.50163 .60332 L
.50286 .60332 L
.50401 .60332 L
.50508 .60331 L
.50754 .60331 L
.51014 .6033 L
.51268 .60329 L
.51504 .60328 L
.5204 .60324 L
.5293 .60316 L
.53882 .60305 L
.54906 .60288 L
.56016 .60266 L
.58032 .60215 L
.60019 .6015 L
.62123 .60066 L
.65912 .59873 L
.69946 .59611 L
.73829 .59304 L
.77956 .58917 L
Mistroke
.81932 .58485 L
.85757 .58016 L
.89827 .57459 L
.93745 .56866 L
.97619 .56225 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWTtv01AUduqEpAkNAZS2gUId0laiD14SVIFMUQRLq65lNBFSK4SoSqX8
ivwEpiysbPkHSEiZmFiYkBAzEwvB55h8dtPrcx2StC5t1F5/Oo/r43s+33Ns
b9oHOy9f2we7ddt6tm/v7ezW31pP3+w7IjNmGDHLMIwPlkG468C/Q9f56xZp
IImH83wwDdeo6/7TOHmMeg4xQUMyQlENq59wV99B6QhFJeh58TkNE4g/ofFx
D4nDejeh7ix9virZ0PNVSNIk9MRHIsey5+l6O7/4CMIt09gkSXU8a5DC6sdD
5+Gc0WPTz5G2Q+i6j10q1wKNj0hiA90KNt+i0SbJdoQu92wmOUfab0BCkqdo
LJKkRcgiNBNsfgfmNtD6CDmRRc50WwQH7mwpfn1vjxHccgo972AmiOKvHzy/
GTqorEKviyiLs+ssj4U6vPH/InRBQx1etgyYliY0pWHaNEnaQALTSjDiUpgn
tBZsXgZ7N0DMarD5cxo3SFIf4dr9n5vNeBlxkSQdOAqMKIAHLSChHi0jI15Y
i5D19SLsWlJoTWiXCGUJrWBVEsGnv83jkf0ppRD3mBtXu2QUsxfDz94Lk28J
XxdJx6TaflVxxsEvdVJhauG+mx/oCkYTUVphWhooDsnaBMMC1oIJtaa5EjZa
HiiohXDrL8SvSlXArKNJkHdzpoGWgDJAC4ftvCXu810FOiXP3Fz1eeWuso1m
P1UxN0oyFYGiFJ9KxkzmGqVq6wTyenVrVqG9r5DdC2k3g4RfGiykAq6ljSmE
2liCUQuOQnPFXT/3Yg0goeuv0cjlmdFNQpvB5tyL1Ujyymd03ks5Y4ok35Ei
oZdKY84vcBR6qZwbmPP7BMd5Db281usKoUUNX5heTSCBL2UYNYCE3p1JdYMk
FSW9mDkvCFX6SXXS6T8J+vwACkWfrzhPPgx9Opj9moY+6t1JfuAX9qkBnv8F
OsqvA5iYvNvZQNUwcW/hLmGKconf9jmGeEVg9xM4Yu8Jzh5VAwspz/keSCik
K4j9HWJ/6DNnQj0AZRpAj4PnrCFOG0iotgI1VeZHaBgJcrH6N5BALl7in1h2
oZdIIIH88iJJKBdsPgVefYajUHCnEcJHIKHgziGENmYXCq6un2Ne3YXR2Kry
v9CQQ5gNQ8N1kuyFo8mp/frHomFm4TE7vK/qux3rL7t6xopv8H5sxP4AydL6
4g==\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -12.8439, \
0.00385924, 0.134254}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Zobrazen\[EAcute] je residuum pro r\[URing]zn\[EAcute] hodnoty \
hledan\[EAcute]ho koeficientu (koeficient v na\[SHacek]em tvaru \[RHacek]e\
\[SHacek]en\[IAcute])\
\>", "Text"],

Cell["\<\
Cht\[EHacek]li bychom tedy, aby toto residuum bylo nulov\[EAcute] pro jak\
\[EAcute]koli x mezi (0,1), co\[ZHacek] (jak u\[ZHacek] je vid\[EHacek]t z p\
\[RHacek]edchoz\[IAcute]ho grafu) pro n\[AAcute]mi zvolen\[YAcute] tvar \
\[RHacek]e\[SHacek]en\[IAcute] nelze.\
\>", "Text"],

Cell["\<\
Metoda v\[AAcute]hov\[YAcute]ch residu\[IAcute] spo\[CHacek]\[IAcute]v\
\[AAcute] v tom, \[ZHacek]e :
a) Residuum vyn\[AAcute]sob\[IAcute]me t\[EAcute]m\[EHacek]\[RHacek] \
libovolnou funkc\[IAcute] w[x] (m\[URing]\[ZHacek]e z\[AAcute]viset i na \
koeficientu a, pak tedy w[x,a])
b) Tento sou\[CHacek]in zintegrujeme p\[RHacek]es celou oblast (tedy mezi \
(0,1)).
c) Tento integr\[AAcute]l pak polo\[ZHacek]\[IAcute]me nule a dostaneme t\
\[IAcute]m jednu rovnici, v kter\[EAcute] nezn\[AAcute]me pouze koeficient a \
(sou\[RHacek]adnice x jsme se zbavili integrov\[AAcute]n\[IAcute]m)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "*", "Residuum"}]], "Input"],

Cell[BoxData[
 RowBox[{"w", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "a"}], "+", 
    RowBox[{"0.6000000000000001`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "20"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"MVR", "=", 
   RowBox[{"0", "==", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{"w", "*", "Residuum", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], ";"}]], "Input"],

Cell["\<\
Pozn.1: Kdy\[ZHacek] bude navrhovan\[YAcute] tvar \[RHacek]e\[SHacek]en\
\[IAcute] m\[IAcute]t n koeficient\[URing], vyn\[AAcute]sob\[IAcute]me \
postupn\[EHacek] residuum n r\[URing]zn\[YAcute]mi (nav\[IAcute]c \
vz\[AAcute]jem\[EHacek] line\[AAcute]rn\[EHacek] nez\[AAcute]visl\[YAcute]mi) \
funkcemi a dostaneme tak soustavu n rovnic, v kter\[EAcute] bude t\[EHacek]ch \
n nezn\[AAcute]m\[YAcute]ch koeficient\[URing]\
\>", "Text"],

Cell["\<\
Pozn.2: Funkci w se \[RHacek]\[IAcute]k\[AAcute] v\[AAcute]hov\[AAcute] (pop\
\[RHacek]. testovac\[IAcute]) funkce, proto\[ZHacek]e j\[IAcute] vlastn\
\[EHacek] v\[AAcute]hujeme, v kter\[EAcute] oblasti m\[AAcute] b\[YAcute]t \
spln\[EHacek]na rovnice l\[EAcute]pe a v kter\[EAcute] m\[EAcute]n\[EHacek]. \
(Hodn\[EHacek] zjednodu\[SHacek]en\[EHacek] \[RHacek]e\[CHacek]eno)\
\>", "Text"],

Cell["\<\
Pozn.3: Mimochodem lze dok\[AAcute]zat, \[ZHacek]e je-li integral z jakekoli \
funkce f  vyn\[AAcute]soben\[EAcute] v\[AAcute]hovou funkc\[IAcute] nulov\
\[YAcute] pro v\[SHacek]echny mo\[ZHacek]n\[EAcute] v\[AAcute]hov\[EAcute] \
funkce (v\[AAcute]hov\[EAcute] funkce z dosti obecn\[EAcute] mno\[ZHacek]iny \
funkc\[IAcute]) je tato funkce f na cel\[EAcute] oblasti (p\[RHacek]es kterou \
integruji) nulov\[AAcute]. Tak\[ZHacek]e na\[SHacek]\[IAcute]m postupem z\
\[IAcute]sk\[AAcute]me residuum, kter\[EAcute]ho v\[AAcute]hovan\[YAcute] \
integr\[AAcute]l nen\[IAcute] nulov\[YAcute] pro v\[SHacek]ech \
nekone\[CHacek]n\[EHacek] mnoho pot\[RHacek]ebn\[YAcute]ch \
testovac\[IAcute]ch funkc\[IAcute], ale jen pro  kone\[CHacek]n\[YAcute] po\
\[CHacek]et n\[AAcute]mi (poku\[DHacek] mo\[ZHacek]no vhodn\[EHacek]) vybran\
\[YAcute]ch v\[AAcute]hov\[YAcute]ch funkc\[IAcute].
\
\>", "Text"],

Cell["\<\
Podle toho jak vol\[IAcute]me v\[AAcute]hov\[EAcute] funkce se pak dostanou r\
\[URing]zn\[EAcute] metody \[RHacek]e\[SHacek]en\[IAcute]. (N\[AAcute]sleduj\
\[IAcute]c\[IAcute] metody, tedy lze tedy zjednodu\[SHacek]en\[EHacek] ozna\
\[CHacek]it za metody volby v\[AAcute]hov\[YAcute]ch funkc\[IAcute] )\
\>", "Text"],

Cell[CellGroupData[{

Cell["Collocation method", "Subsection"],

Cell["MVR/.{w\[Rule]DiracDelta[x-xi]};", "Text"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci dirakuv impuls v nejak\
\[EAcute]m bod\[EHacek] (pop\[RHacek]. v n\[EHacek]jak\[YAcute]ch bodech, v p\
\[RHacek]\[IAcute]pad\[EHacek] v\[IAcute]ce koeficient\[URing]), v kter\
\[EAcute]m chceme m\[IAcute]t rovnici spln\[EHacek]nu\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CM", "=", 
  RowBox[{"0", "==", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{"DiracDelta", "[", 
      RowBox[{"x", "-", "0.5"}], "]"}], "*", "Residuum", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"-", "12.000000000000002`"}], "+", 
   RowBox[{"2.1500000000000004`", " ", "a"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\[RHacek]e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"resCM", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"CM", ",", "a"}], "]"}], "\[LeftDoubleBracket]", "1", 
   "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", "\[Rule]", "5.5813953488372094`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\[RHacek]edpokl\
\[AAcute]dan\[EAcute]ho tvaru \[RHacek]e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tapr", "/.", "resCM"}]], "Input"],

Cell[BoxData[
 RowBox[{"5.5813953488372094`", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]], "Output"]
}, Open  ]],

Cell["\<\
\[CapitalRHacek]e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu \
(samoz\[RHacek]ejm\[EHacek] z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Tapr", "/.", "resCM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.421833 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09908 -18 -4.5 ]
[.01131 .09908 0 4.5 ]
[.01131 .18345 -18 -4.5 ]
[.01131 .18345 0 4.5 ]
[.01131 .26781 -18 -4.5 ]
[.01131 .26781 0 4.5 ]
[.01131 .35218 -18 -4.5 ]
[.01131 .35218 0 4.5 ]
[.01131 .43655 -6 -4.5 ]
[.01131 .43655 0 4.5 ]
[.01131 .52091 -18 -4.5 ]
[.01131 .52091 0 4.5 ]
[.01131 .60528 -18 -4.5 ]
[.01131 .60528 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09908 m
.03006 .09908 L
s
[(0.2)] .01131 .09908 1 0 Mshowa
.02381 .18345 m
.03006 .18345 L
s
[(0.4)] .01131 .18345 1 0 Mshowa
.02381 .26781 m
.03006 .26781 L
s
[(0.6)] .01131 .26781 1 0 Mshowa
.02381 .35218 m
.03006 .35218 L
s
[(0.8)] .01131 .35218 1 0 Mshowa
.02381 .43655 m
.03006 .43655 L
s
[(1)] .01131 .43655 1 0 Mshowa
.02381 .52091 m
.03006 .52091 L
s
[(1.2)] .01131 .52091 1 0 Mshowa
.02381 .60528 m
.03006 .60528 L
s
[(1.4)] .01131 .60528 1 0 Mshowa
.125 Mabswid
.02381 .03581 m
.02756 .03581 L
s
.02381 .0569 m
.02756 .0569 L
s
.02381 .07799 m
.02756 .07799 L
s
.02381 .12017 m
.02756 .12017 L
s
.02381 .14127 m
.02756 .14127 L
s
.02381 .16236 m
.02756 .16236 L
s
.02381 .20454 m
.02756 .20454 L
s
.02381 .22563 m
.02756 .22563 L
s
.02381 .24672 m
.02756 .24672 L
s
.02381 .28891 m
.02756 .28891 L
s
.02381 .31 m
.02756 .31 L
s
.02381 .33109 m
.02756 .33109 L
s
.02381 .37327 m
.02756 .37327 L
s
.02381 .39436 m
.02756 .39436 L
s
.02381 .41546 m
.02756 .41546 L
s
.02381 .45764 m
.02756 .45764 L
s
.02381 .47873 m
.02756 .47873 L
s
.02381 .49982 m
.02756 .49982 L
s
.02381 .54201 m
.02756 .54201 L
s
.02381 .5631 m
.02756 .5631 L
s
.02381 .58419 m
.02756 .58419 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0849055, -0.108354, \
0.00387438, 0.00874727}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\[ZHacek] do rovnice dosad\[IAcute]me \[RHacek]e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rovApr", "/.", "resCM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11.162790697674419`"}], "\[Equal]", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.5813953488372094`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Spln\[EHacek]n\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me \
na residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residuum", "/.", "resCM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"11.162790697674419`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.5813953488372094`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Residuum", "/.", "resCM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.603319 0.703055 [
[.21429 .59082 -9 -9 ]
[.21429 .59082 9 0 ]
[.40476 .59082 -9 -9 ]
[.40476 .59082 9 0 ]
[.59524 .59082 -9 -9 ]
[.59524 .59082 9 0 ]
[.78571 .59082 -9 -9 ]
[.78571 .59082 9 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.01131 .04088 -24 -4.5 ]
[.01131 .04088 0 4.5 ]
[.01131 .18149 -24 -4.5 ]
[.01131 .18149 0 4.5 ]
[.01131 .3221 -24 -4.5 ]
[.01131 .3221 0 4.5 ]
[.01131 .46271 -24 -4.5 ]
[.01131 .46271 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .60332 m
.21429 .60957 L
s
[(0.2)] .21429 .59082 0 1 Mshowa
.40476 .60332 m
.40476 .60957 L
s
[(0.4)] .40476 .59082 0 1 Mshowa
.59524 .60332 m
.59524 .60957 L
s
[(0.6)] .59524 .59082 0 1 Mshowa
.78571 .60332 m
.78571 .60957 L
s
[(0.8)] .78571 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(1)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.2619 .60332 m
.2619 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.5 .60332 m
.5 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.7381 .60332 m
.7381 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.02381 .04088 m
.03006 .04088 L
s
[(-0.8)] .01131 .04088 1 0 Mshowa
.02381 .18149 m
.03006 .18149 L
s
[(-0.6)] .01131 .18149 1 0 Mshowa
.02381 .3221 m
.03006 .3221 L
s
[(-0.4)] .01131 .3221 1 0 Mshowa
.02381 .46271 m
.03006 .46271 L
s
[(-0.2)] .01131 .46271 1 0 Mshowa
.125 Mabswid
.02381 .07603 m
.02756 .07603 L
s
.02381 .11118 m
.02756 .11118 L
s
.02381 .14633 m
.02756 .14633 L
s
.02381 .21664 m
.02756 .21664 L
s
.02381 .25179 m
.02756 .25179 L
s
.02381 .28694 m
.02756 .28694 L
s
.02381 .35725 m
.02756 .35725 L
s
.02381 .3924 m
.02756 .3924 L
s
.02381 .42756 m
.02756 .42756 L
s
.02381 .49786 m
.02756 .49786 L
s
.02381 .53301 m
.02756 .53301 L
s
.02381 .56817 m
.02756 .56817 L
s
.02381 .00572 m
.02756 .00572 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59951 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60247 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58657 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztm3loHFUYwCfZ3ZxN77tNu7lM2qT3YU97mrS2SW3VVqVSQ2pJeqQhBhUR
ERGxpbRFSxGVVlHxRKyIRykiIiIi4tXWCxERKSriH1rFf7Y7b5Y3mcnvm8zs
zBT/MHR3h9987/d9b+bN7Nu329b2vs7b9rX3dXW0p1t623s6uzpuTzfv782i
RIFhFKQNwziVNsztTHYz95TJ/stUmU8myX97knpJGJY0Yz3M50S//YVW3uxW
MkCrgPv/BZbKP1zVTEFFQYP67TL//oHwYmtviXYmYSsVTGa9JB27jFyOgTgJ
8r9BXpK3XPXBSGi7+fqXnKFfpPlXaD2hvtR1iAYEXIy0I9ksjnGZq/JPSFLq
Pq9lrlIDq2goFwL7A1jZf12RAPY7sPJoFXh1mY/fgA2Rc7uvoYgUvwKrkBXU
kV8uu6II2AVgQ2NVFAP7GdiwaBVqQJWEz02Kn4ANj1VRCuxHYCNiVZQB+wHY
yFgV5cC+BzYqVsUQYN8BG+0ekxV5NPSR+1tgY2QFVfFNeMXXwMbKiqHAvgqv
OA9snKwYBuycrKAZonrLU9F036YEZ4GNtxKEmzWaj+HAvow0oer1CFB+AWxC
rqn/6WSJ5/GkvJ/LeYXu0Q2RDiZl+wzYRPfwKNOdIO1IYJ/KWhq4EShGAfsE
2KRYFaOBfQxscrQKdZbGQtBHwCrl3GPCK6iKD4FNiVUxDtgHwKbGqhgP7H1g
6VgVE4C9B8xjESYfhRqTJHsXWLWce2J4BbF3gNXEqpgM7Ayw2lgVlcBOA6uT
FVOAvR1e8RawK9wDKg1Bbw7SEC9YJ3sDWL2soCpeB9YQq6IK2GvApgVTnAI2
XVZUA3s1mKIG2CvAGi0FzVvV7EpF06JNwATCPIs+bNFCVS2wl4E1eWZTvUzp
Hqle1oHlJWAzcpKA81R/c3Iq4kW5CJ+T1iDZXgA20z02yp2jBO8PTva8rKVR
S4rngM2SFfXAngU2W1Y0AHsmvOJpYHNkxTRgTwGb20+hzk0jBD05SEO8sTjZ
SWDzZAVVcSKYognYE8DmB1M8DmyBrJgB7LFgipnAHgW2UFbMAnYc2JXRKtSA
mgNBx4AtknOT4pHwioeBLZYVc4EdBbZEVswDdiS84jCwpbJiPrBDwJbJigXA
DgJbLisWAjsQXvEQsKvcY3IRBD0IbIWcmxQPAFsZq2IxsPuBrZIVS4DdB2y1
rFgK7F5gayJTiCulSc1wMDvZPcDWWgk8Fy6dLWgdcTmwu4Fd7ZlNXEdU/V0B
e+8C1pzT+Z970lcpNIunCu4A1uLjmPqa6QZMKH8zTxeYk/UBWyeP31XAeoGt
lxWrgfUAu0ZWrAHWDWyDrFgLbC+wjdEq1LlphqDdwFrl3KToBNYmK1qA7QK2
SVasA7YT2LWyYr0+Kh2wd7PccAOwHcC2yIqNwLbrem6QG7YCuxmYh6IN2I3A
tsqKTbrUbbB3m3vUbYGg68QqMCMpNgO7SVZQxjZd43a54fU6iI6+R8Ot0qhz
sVtkBR3fZl3PrXJDOqN02/BQNOg8NAWo1lu0JFUjtbVSON8pqyDY3lIfdlNa
77Ws4Gs2UavNhvPXdPSmXOXlHYCrA0XTR/ABP6Fs4LY0calxheb+7FU1r/KS
gwUEr9/fKaKjTgus6mgIExx3z3O4WHdMCLB/+UgLEfkON6G8lBvb3XL/VMuj
5JQumdZhYz2B9v3AnuzVwQVrl1gLe9WW6x5h+xr1VrFcSIdWNOnwbjl8lw6v
1+E9cniXDrIL7JXD92h7pd7qk8O79ZhU370XmVt3WuHqa3B1YipUE98/BaNL
iNj/baNv63G90ILebJ/Mb1uP9BlrOPrar7Yj+O8MRsEljuPTeg==\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.89166, \
0.00394728, 0.00534711}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Pozn.1: Aplikujeme-li tuto metodu na  speci\[AAcute]ln\[IAcute] volbu tvaru \
\[RHacek]e\[SHacek]en\[IAcute], dostaneme metodu kone\[CHacek]\[YAcute]ch \
diferenc\[IAcute]\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Least Squares Method", "Subsection"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci derivace residua podle \
jednotliv\[YAcute]ch koeficient\[URing]. (derivac\[IAcute] residua podle n \
koeficient\[URing] je n, tak\[ZHacek]e po\[CHacek]et rovnic bude \
spr\[AAcute]vn\[YAcute])\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LSM", "=", 
  RowBox[{"0", "==", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "a"], " ", "Residuum"}], "*", "Residuum", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"-", "25.20000000000001`"}], "+", 
   RowBox[{"4.412000000000002`", " ", "a"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\[RHacek]e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"resLSM", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"LSM", ",", "a"}], "]"}], "\[LeftDoubleBracket]", "1", 
   "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", "\[Rule]", "5.7116953762466`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\[RHacek]edpokl\
\[AAcute]dan\[EAcute]ho tvaru \[RHacek]e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tapr", "/.", "resLSM"}]], "Input"],

Cell[BoxData[
 RowBox[{"5.7116953762466`", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]], "Output"]
}, Open  ]],

Cell["\<\
\[CapitalRHacek]e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu \
(samoz\[RHacek]ejm\[EHacek] z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Tapr", "/.", "resLSM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.41221 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09716 -18 -4.5 ]
[.01131 .09716 0 4.5 ]
[.01131 .1796 -18 -4.5 ]
[.01131 .1796 0 4.5 ]
[.01131 .26204 -18 -4.5 ]
[.01131 .26204 0 4.5 ]
[.01131 .34448 -18 -4.5 ]
[.01131 .34448 0 4.5 ]
[.01131 .42693 -6 -4.5 ]
[.01131 .42693 0 4.5 ]
[.01131 .50937 -18 -4.5 ]
[.01131 .50937 0 4.5 ]
[.01131 .59181 -18 -4.5 ]
[.01131 .59181 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09716 m
.03006 .09716 L
s
[(0.2)] .01131 .09716 1 0 Mshowa
.02381 .1796 m
.03006 .1796 L
s
[(0.4)] .01131 .1796 1 0 Mshowa
.02381 .26204 m
.03006 .26204 L
s
[(0.6)] .01131 .26204 1 0 Mshowa
.02381 .34448 m
.03006 .34448 L
s
[(0.8)] .01131 .34448 1 0 Mshowa
.02381 .42693 m
.03006 .42693 L
s
[(1)] .01131 .42693 1 0 Mshowa
.02381 .50937 m
.03006 .50937 L
s
[(1.2)] .01131 .50937 1 0 Mshowa
.02381 .59181 m
.03006 .59181 L
s
[(1.4)] .01131 .59181 1 0 Mshowa
.125 Mabswid
.02381 .03533 m
.02756 .03533 L
s
.02381 .05594 m
.02756 .05594 L
s
.02381 .07655 m
.02756 .07655 L
s
.02381 .11777 m
.02756 .11777 L
s
.02381 .13838 m
.02756 .13838 L
s
.02381 .15899 m
.02756 .15899 L
s
.02381 .20021 m
.02756 .20021 L
s
.02381 .22082 m
.02756 .22082 L
s
.02381 .24143 m
.02756 .24143 L
s
.02381 .28265 m
.02756 .28265 L
s
.02381 .30326 m
.02756 .30326 L
s
.02381 .32387 m
.02756 .32387 L
s
.02381 .36509 m
.02756 .36509 L
s
.02381 .3857 m
.02756 .3857 L
s
.02381 .40631 m
.02756 .40631 L
s
.02381 .44754 m
.02756 .44754 L
s
.02381 .46815 m
.02756 .46815 L
s
.02381 .48876 m
.02756 .48876 L
s
.02381 .52998 m
.02756 .52998 L
s
.02381 .55059 m
.02756 .55059 L
s
.02381 .5712 m
.02756 .5712 L
s
.02381 .61242 m
.02756 .61242 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -0.112305, \
0.00385924, 0.00891649}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\[ZHacek] do rovnice dosad\[IAcute]me \[RHacek]e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rovApr", "/.", "resLSM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11.4233907524932`"}], "\[Equal]", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.7116953762466`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Spln\[EHacek]n\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me \
na residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residuum", "/.", "resLSM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"11.4233907524932`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.7116953762466`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Residuum", "/.", "resLSM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.410855 0.687017 [
[.21429 .39836 -9 -9 ]
[.21429 .39836 9 0 ]
[.40476 .39836 -9 -9 ]
[.40476 .39836 9 0 ]
[.59524 .39836 -9 -9 ]
[.59524 .39836 9 0 ]
[.78571 .39836 -9 -9 ]
[.78571 .39836 9 0 ]
[.97619 .39836 -3 -9 ]
[.97619 .39836 3 0 ]
[.01131 .13605 -24 -4.5 ]
[.01131 .13605 0 4.5 ]
[.01131 .27345 -24 -4.5 ]
[.01131 .27345 0 4.5 ]
[.01131 .54826 -18 -4.5 ]
[.01131 .54826 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .41086 m
.21429 .41711 L
s
[(0.2)] .21429 .39836 0 1 Mshowa
.40476 .41086 m
.40476 .41711 L
s
[(0.4)] .40476 .39836 0 1 Mshowa
.59524 .41086 m
.59524 .41711 L
s
[(0.6)] .59524 .39836 0 1 Mshowa
.78571 .41086 m
.78571 .41711 L
s
[(0.8)] .78571 .39836 0 1 Mshowa
.97619 .41086 m
.97619 .41711 L
s
[(1)] .97619 .39836 0 1 Mshowa
.125 Mabswid
.07143 .41086 m
.07143 .41461 L
s
.11905 .41086 m
.11905 .41461 L
s
.16667 .41086 m
.16667 .41461 L
s
.2619 .41086 m
.2619 .41461 L
s
.30952 .41086 m
.30952 .41461 L
s
.35714 .41086 m
.35714 .41461 L
s
.45238 .41086 m
.45238 .41461 L
s
.5 .41086 m
.5 .41461 L
s
.54762 .41086 m
.54762 .41461 L
s
.64286 .41086 m
.64286 .41461 L
s
.69048 .41086 m
.69048 .41461 L
s
.7381 .41086 m
.7381 .41461 L
s
.83333 .41086 m
.83333 .41461 L
s
.88095 .41086 m
.88095 .41461 L
s
.92857 .41086 m
.92857 .41461 L
s
.25 Mabswid
0 .41086 m
1 .41086 L
s
.02381 .13605 m
.03006 .13605 L
s
[(-0.4)] .01131 .13605 1 0 Mshowa
.02381 .27345 m
.03006 .27345 L
s
[(-0.2)] .01131 .27345 1 0 Mshowa
.02381 .54826 m
.03006 .54826 L
s
[(0.2)] .01131 .54826 1 0 Mshowa
.125 Mabswid
.02381 .033 m
.02756 .033 L
s
.02381 .06735 m
.02756 .06735 L
s
.02381 .1017 m
.02756 .1017 L
s
.02381 .1704 m
.02756 .1704 L
s
.02381 .20475 m
.02756 .20475 L
s
.02381 .2391 m
.02756 .2391 L
s
.02381 .3078 m
.02756 .3078 L
s
.02381 .34215 m
.02756 .34215 L
s
.02381 .3765 m
.02756 .3765 L
s
.02381 .44521 m
.02756 .44521 L
s
.02381 .47956 m
.02756 .47956 L
s
.02381 .51391 m
.02756 .51391 L
s
.02381 .58261 m
.02756 .58261 L
s
.02381 .61696 m
.02756 .61696 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmltsFFUYgLd7aUtLESh3BLa0hUKrUIhKRS4WaCnQIqAiWgKbatNys6mN
GqPGGGP0SYM+e4karzFijKAxxhhjjDFGxbvGGGOMUWN8MGp8Wbtntv/OTL9/
OtuZWdnAcvjOf75zzpx/z57OtDszMnDD8czIYF8m3TmcGRoY7Lsp3XHj8ChK
lMViZelYLHYqHcuVs6PF/Ft29E+2LveWI5MvLzT/JGKWNGv9zb0n/r/6f4Gl
Jh8ez1VQUHmxQbaq3OsfCK+whSf8BLmcf0N4pT086agaff0VfouUc7nyQ/sT
mk0JoZmzKg7sD2BV55zCpFASgn4HVq33nQiuoFH8BmxqyRW/AqvRFSlgv5Rc
UQ7sZ2DTwlWYhKqEoJ+Anaf3XXFOKGgiPwKbHqliCrAfgM0ITVEpS5mUkslJ
E00f9ipg3wObaXVgrc24Xb4aWtC2Fk5vZpYpmZGZ5VSwfAesNi9JjMnMK269
6b2Nx7Th0GXwGIQyPfeaa73RlL8FNsudG9XOLAmmpawlxTfAZuuKGmBfB1d8
BWyOrpgG7Mvgii+AzbUpzNpMh6DPJ2iIO6STfQZsnq6gUXwaXHEW2HxdMQPY
J8EVHwNboCtmAvuo5IpaYB8CW+hOqFmTaIifeSf7ANj5kSpmA3sf2KJIFXOA
vQdscaSKucDeBbYkXIVJqPkQ9A6wtN73vOAKGsXbwDxuQoSgWADsLWBLI1UQ
exNYfWgKOnGas1VSGH6wnewNYA1WB15nQFcL+ukrnN7oGF6Y72KofR1YY17n
/+xJ52U6xdMIXtNH4HlNfZ10qcMzwJa5s6RKSrRaS4Cd1rWUq6R4FdhyXZEG
9gqwpkgVdcBeBraiOMUpYCttCrM29RD00gQNcX9wsheBNUeqaAD2ArCW4hTP
A7tAVzQCey644llgF+qKZcCeCa54Gtgqd0I1QdBTwFbrfZPiyeCKJ4C16ooV
wB4HtkZXrAT2WHDFo8DW6opmYI8Up2iS5XV/feVfhYNAg4TSjal6qE1ILbUt
1JpLkRIfj9Ta7MsdzDZWumHa4JpSPpRu8dRxqPJ1upRxhetiTpx24547NbGZ
fPSdXu8xjZTHyEs5T1zXcX3QEYlmXNyEvK5PwiOAsstcgJZQJpvMt7Pjsfym
S6xkK911VCZEp2HlUqb8p2SRS1/YfOggGZfaRikVbnsWdpQq5+LFC+vlHPNY
XbOUlOequb+rgT0MbJ2uaAX2UHDFSWBtumINsAeBXaor1gJ7QFeYu0MmRWpM
te+HIvSTEjFqS9lISeXXF2QspWibyr+7Etz8n27dB+nf4xO8Chjt3HTYoY8Y
xdHSUluPYV4M7H5gG4pT3Adso664BNi9wDbpinXA7gG2OVJFG7C7gV1uU5gN
dz0E3QWsXe+bFHcC2xKp4jJgtwPbqis2ALsN2DZdsRHYrcA6dMUmYDcD64xU
sRnYCLDt7oRqh6BhYF1636QYArZDV2wBdgLYTl2xFdgxYLsiVWwDdgRYt67o
ADYArEdXdALrB7ZbV2wHdj2wK3RFlyRZH9TucWfiLgg6BGyv3iMpeqWDq/SG
3cCuBeah6AF2DbCrdcVuGep+qN2vN9wDbJ86HlTs9ak9YCmKf+JB4+mRtr2W
NuBzjivFRwvq3Yf30w1akC5gBz378Pskg3rrkLEc9nGtfD2/oPSkPfCwe829
n18ckNp2KfXpmXcdMPpe9lD0AlsvfffrDQ9KUJuUBvTwQxJ0kZSO6OEZCWqV
0jFbuAFmUzXtWoSd0J39Er5cwof08EEJKvxoP6yHHxX7IimN6OFmnCbVzO9j
mFuLt+jhpuPaHLlDD8paHYdXb+actUZqqCmH8Jv8sbL/AChWf84=\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.632331, \
0.00394728, 0.00547194}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Galerkin's Method", "Subsection"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci derivace navrhovan\
\[EAcute]ho \[RHacek]e\[SHacek]en\[IAcute] podle jednotliv\[YAcute]ch \
koeficient\[URing]. (derivac\[IAcute] podle n koeficient\[URing] je op\
\[EHacek]t n, tak\[ZHacek]e to op\[EHacek]t vyhovuje)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GM", "=", 
  RowBox[{"0", "==", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "a"], " ", "Tapr"}], "*", "Residuum", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"-", "2.000000000000001`"}], "+", 
   RowBox[{"0.3533333333333334`", " ", "a"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\[RHacek]e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"resGM", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"GM", ",", "a"}], "]"}], "\[LeftDoubleBracket]", "1", 
   "\[RightDoubleBracket]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \
\\\"\\!\\(resGM\\)\\\" is similar to existing symbol \\\"\\!\\(resCM\\)\\\". \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", "\[Rule]", "5.6603773584905674`"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\[RHacek]edpokl\
\[AAcute]dan\[EAcute]ho tvaru \[RHacek]e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tapr", "/.", "resGM"}]], "Input"],

Cell[BoxData[
 RowBox[{"5.6603773584905674`", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]], "Output"]
}, Open  ]],

Cell["\<\
\[CapitalRHacek]e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu \
(samoz\[RHacek]ejm\[EHacek] z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Tapr", "/.", "resGM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.415947 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .0979 -18 -4.5 ]
[.01131 .0979 0 4.5 ]
[.01131 .18109 -18 -4.5 ]
[.01131 .18109 0 4.5 ]
[.01131 .26428 -18 -4.5 ]
[.01131 .26428 0 4.5 ]
[.01131 .34747 -18 -4.5 ]
[.01131 .34747 0 4.5 ]
[.01131 .43066 -6 -4.5 ]
[.01131 .43066 0 4.5 ]
[.01131 .51385 -18 -4.5 ]
[.01131 .51385 0 4.5 ]
[.01131 .59704 -18 -4.5 ]
[.01131 .59704 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .0979 m
.03006 .0979 L
s
[(0.2)] .01131 .0979 1 0 Mshowa
.02381 .18109 m
.03006 .18109 L
s
[(0.4)] .01131 .18109 1 0 Mshowa
.02381 .26428 m
.03006 .26428 L
s
[(0.6)] .01131 .26428 1 0 Mshowa
.02381 .34747 m
.03006 .34747 L
s
[(0.8)] .01131 .34747 1 0 Mshowa
.02381 .43066 m
.03006 .43066 L
s
[(1)] .01131 .43066 1 0 Mshowa
.02381 .51385 m
.03006 .51385 L
s
[(1.2)] .01131 .51385 1 0 Mshowa
.02381 .59704 m
.03006 .59704 L
s
[(1.4)] .01131 .59704 1 0 Mshowa
.125 Mabswid
.02381 .03551 m
.02756 .03551 L
s
.02381 .05631 m
.02756 .05631 L
s
.02381 .07711 m
.02756 .07711 L
s
.02381 .1187 m
.02756 .1187 L
s
.02381 .1395 m
.02756 .1395 L
s
.02381 .1603 m
.02756 .1603 L
s
.02381 .20189 m
.02756 .20189 L
s
.02381 .22269 m
.02756 .22269 L
s
.02381 .24349 m
.02756 .24349 L
s
.02381 .28508 m
.02756 .28508 L
s
.02381 .30588 m
.02756 .30588 L
s
.02381 .32668 m
.02756 .32668 L
s
.02381 .36827 m
.02756 .36827 L
s
.02381 .38907 m
.02756 .38907 L
s
.02381 .40986 m
.02756 .40986 L
s
.02381 .45146 m
.02756 .45146 L
s
.02381 .47226 m
.02756 .47226 L
s
.02381 .49305 m
.02756 .49305 L
s
.02381 .53465 m
.02756 .53465 L
s
.02381 .55545 m
.02756 .55545 L
s
.02381 .57624 m
.02756 .57624 L
s
.02381 .61784 m
.02756 .61784 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -0.111296, \
0.00385924, 0.00883638}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\[ZHacek] do rovnice dosad\[IAcute]me \[RHacek]e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rovApr", "/.", "resGM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11.320754716981135`"}], "\[Equal]", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.6603773584905674`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Spln\[EHacek]n\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me \
na residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residuum", "/.", "resGM"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"11.320754716981135`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"5.6603773584905674`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Residuum", "/.", "resGM"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.485599 0.693245 [
[.21429 .4731 -9 -9 ]
[.21429 .4731 9 0 ]
[.40476 .4731 -9 -9 ]
[.40476 .4731 9 0 ]
[.59524 .4731 -9 -9 ]
[.59524 .4731 9 0 ]
[.78571 .4731 -9 -9 ]
[.78571 .4731 9 0 ]
[.97619 .4731 -3 -9 ]
[.97619 .4731 3 0 ]
[.01131 .06965 -24 -4.5 ]
[.01131 .06965 0 4.5 ]
[.01131 .2083 -24 -4.5 ]
[.01131 .2083 0 4.5 ]
[.01131 .34695 -24 -4.5 ]
[.01131 .34695 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .4856 m
.21429 .49185 L
s
[(0.2)] .21429 .4731 0 1 Mshowa
.40476 .4856 m
.40476 .49185 L
s
[(0.4)] .40476 .4731 0 1 Mshowa
.59524 .4856 m
.59524 .49185 L
s
[(0.6)] .59524 .4731 0 1 Mshowa
.78571 .4856 m
.78571 .49185 L
s
[(0.8)] .78571 .4731 0 1 Mshowa
.97619 .4856 m
.97619 .49185 L
s
[(1)] .97619 .4731 0 1 Mshowa
.125 Mabswid
.07143 .4856 m
.07143 .48935 L
s
.11905 .4856 m
.11905 .48935 L
s
.16667 .4856 m
.16667 .48935 L
s
.2619 .4856 m
.2619 .48935 L
s
.30952 .4856 m
.30952 .48935 L
s
.35714 .4856 m
.35714 .48935 L
s
.45238 .4856 m
.45238 .48935 L
s
.5 .4856 m
.5 .48935 L
s
.54762 .4856 m
.54762 .48935 L
s
.64286 .4856 m
.64286 .48935 L
s
.69048 .4856 m
.69048 .48935 L
s
.7381 .4856 m
.7381 .48935 L
s
.83333 .4856 m
.83333 .48935 L
s
.88095 .4856 m
.88095 .48935 L
s
.92857 .4856 m
.92857 .48935 L
s
.25 Mabswid
0 .4856 m
1 .4856 L
s
.02381 .06965 m
.03006 .06965 L
s
[(-0.6)] .01131 .06965 1 0 Mshowa
.02381 .2083 m
.03006 .2083 L
s
[(-0.4)] .01131 .2083 1 0 Mshowa
.02381 .34695 m
.03006 .34695 L
s
[(-0.2)] .01131 .34695 1 0 Mshowa
.125 Mabswid
.02381 .10431 m
.02756 .10431 L
s
.02381 .13898 m
.02756 .13898 L
s
.02381 .17364 m
.02756 .17364 L
s
.02381 .24296 m
.02756 .24296 L
s
.02381 .27763 m
.02756 .27763 L
s
.02381 .31229 m
.02756 .31229 L
s
.02381 .38161 m
.02756 .38161 L
s
.02381 .41627 m
.02756 .41627 L
s
.02381 .45094 m
.02756 .45094 L
s
.02381 .52026 m
.02756 .52026 L
s
.02381 .55492 m
.02756 .55492 L
s
.02381 .58959 m
.02756 .58959 L
s
.02381 .03499 m
.02756 .03499 L
s
.02381 .00033 m
.02756 .00033 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNm1toHFUYgCd7SdKk6S29xqTZXNqkTWqb3mO1N2pSK0lt1dZqSl2iIY23
EIM+9aWIqIiKLUVUtKUtXhFbSr0gIiIiIuL9joiIiIr4ICq+rDtnwpmdyffP
zuzsrIZmc/jO/3//nJkzu2fPbvvS48M33pIePziYTvWOpUeHDw7enuq5bSyL
4mWGUZYyDONMyjDbmWxz4iGT/ZdpMh9MUnj7AvNPzPJmW4kcasQNq1TG+jUf
49H1/wMsWXi4GhMFlQcNyukyf/6G8Iqc8LifIJfzLwivzA1POLqyP38WPyPp
vFwTh/YHpE0pQpqzKwbsd2BVlqJSX7yEbsX1yU+GL1DB57CSceI/KRiTSv8G
rHoiNa6vkPkTsx7k0uL5jAerKwxvCmTQiIj9Cmyqe3pU6UEUQUsTlxS/AKuR
FXR6fy65ohzYT8CmRaqoAPYjsOk5iph9owRLLEJtfD51sh+AzYhUQXfV98Bm
RqqoAvYdsFmRKqqBfQus1j2hphaQiE8bTvYNsNklV3wNbI6sqAH2VXjFl8Dm
yoppwL4Ir/gc2DxZMR3YZ3kUakLNgKBPgc2Xa5Pik/CKj4EtkBUzgX0UXvEh
sDpZMQvYB5EqaNGpXnhVNC2IaoG9D8w6OGmRRE9htLosTjU1yqQekRrlHLC8
B6x+QhJwkelvQT072EH4XHFK1WjI7wJrcM+NaucsCaelWTsX2DvAFkaqmAfs
bWCNkSrmA3sLWCpHoa7NggIS8enNyd4E1hSpog7YG8CaI1UQex1YS6SKemCv
AWuNVNEA7FVgi9xzshGCXsmTiDesk70MbLGsoKN4KbziPLA2WZECdg5Ye6SK
JmBngS0JpjgDbKmsaAb2Yh6FmlCtEPQCsA65dkt4BR3F88A6gymeA7ZMViwC
9mx4xTPALpQVi4E9LSvEbc6EZj4KPAVsuVXAc9fRmUFbTG3ATgNb4VlN3ARU
410CvafkGgHWnrS7QKv4dmAngXX5OKe+Vro05BPAVrpnSZVu0dVaCuy4rKX5
S4onga2SFR3Angim6AT2OLDVwRSPAVsjK5YBezSPQl2b5RD0CLC1cm1SHAO2
LlLFCmBHga2XFV3AjoRXPAysW1asBPYQsItkxSpgD4ZXPABsg6xYDex+YBe7
5+RaCLoP2CVybVLcG15xD7CNsmIdsLuBbZIV64HdBWxzpIpuYIeBbZEV7fry
0vKBXuoWQoa9xdUi+VQvrXRdwXZLvZAktZ6P31peFLw6qed02k5r8qo0CTcy
pj25cg6lF8FJX15o51y/n5kKw7f395r/Z4P2d/Vp1UbDF74FIYyuxSM6bg+f
v+tA56BCX0ZaahQ66Sdh+si1zt+88Rg2TTHa1gi2qRvw+tvPXvaylm79Ot1r
b722OnNVAm3tJKBGh24JX9gxfzcBuwNYb6SKzcDGgW2XFVuAjQG7TFZsBTYK
bIelUPv4akLUqG7fnz/TnU/Mb67frwmV4ljC5NIx09hKd059v+GgT+D8vtPw
+7ki5Xoc5qXARoD1yYoeYMPA+mVFL7AhYDtlxXZgNwC7Qlaom149FQ5C7y45
8XJgB4DtzlGoOn0QNKB7r5YrUuK1wDwU/cCuAbZHVuzUh7oXevfKibuAXSke
Dyp2+9TukxVUsV8PaUBOvCr/BeTEPdKsc7H97olCF6ZH914vV6TEbcA8FPt0
na2uGwTDrwO2EZiHYgDYBl17SE7cr4O6dWtYDj+gg9bo1ogcntZBXbp1sxyu
BqhQpw6/VQ4f0uFtOnzUPQ9GdMt+dzomO2/SzgbdGpfD1dGphaz6ckW52bpT
DleFa01ySA7KWIVL0q/aRfhfAkbZv09qo6o=\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.734468, \
0.00394728, 0.00542278}}],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Pozn.1: Aplikac\[IAcute] t\[EAcute]to metody na  speci\[AAcute]ln\[IAcute] \
volbu tvaru \[RHacek]e\[SHacek]en\[IAcute], dostaneme metodu kone\[CHacek]\
\[YAcute]ch element\[URing] (op\[EHacek]t velmi zhruba \
\[RHacek]e\[CHacek]eno, metoda kone\[CHacek]n\[YAcute]ch element\[URing] je \
sp\[IAcute]\[SHacek]e naopak: metodou volby tvaru \[RHacek]e\[SHacek]en\
\[IAcute] pro galerkina (nebo pro Reil-Ritzovu metodu, co\[ZHacek] je metoda \
zalo\[ZHacek]en\[AAcute] ne na metod\[EHacek] v\[AAcute]hov\[YAcute]ch residu\
\[IAcute], ale na minimalizaci ur\[CHacek]it\[EAcute]ho speci\[AAcute]ln\
\[IAcute]ho funkcion\[AAcute]lu)\
\>", "Text"],

Cell["\<\
Pozn.2: Tato metoda dosad\[IAcute] za v\[AAcute]hov\[EAcute] funkci derivace \
navrhovan\[EAcute]ho \[RHacek]e\[SHacek]en\[IAcute] podle \
jednotliv\[YAcute]ch koeficient\[URing]. Ka\[ZHacek]d\[AAcute] rovnice se \
tedy bude sna\[ZHacek]it dostat \[RHacek]e\[SHacek]en\[IAcute], kter\[EAcute] \
je nejp\[RHacek]esn\[EHacek]j\[SHacek]\[IAcute] v m\[IAcute]stech, kde je \
citlivost \[RHacek]e\[SHacek]en\[IAcute] na dan\[YAcute] koeficient nejvy\
\[SHacek]\[SHacek]\[IAcute]. (op\[EHacek]t velmi zjednodu\[SHacek]eno)\
\>", "Text"],

Cell["\<\
Pozn.3: Galerkinova metoda d\[AAcute]v\[AAcute] obvykle l\[EAcute]pe podm\
\[IAcute]n\[EHacek]n\[EAcute] soustavy rovnic, ne\[ZHacek] metoda nejmen\
\[SHacek]\[IAcute]ch \[CHacek]tverc\[URing]. (pravd\[EHacek]podobn\[EHacek] \
souvis\[IAcute] s pozn.2:)\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Slab\[AAcute] formulace (weak formulation) \
\>", "Section"],

Cell["\<\
Laicky \[RHacek]e\[CHacek]eno: Je to metoda zbaven\[IAcute] se \
druh\[YAcute]ch derivac\[IAcute] v rovnici (tedy v residuu).  Pou\[ZHacek]ije \
semetoda per partes (ve 2D a 3D jej\[IAcute] analogii: Green-Gaussovu v\
\[EHacek]tu)\
\>", "Text"],

Cell["\<\
Aplikuje se je\[SHacek]t\[EHacek] p\[RHacek]ed pou\[ZHacek]it\[IAcute]m n\
\[EHacek]kter\[EAcute] z t\[RHacek]\[IAcute] v\[YAcute]\[SHacek]e uveden\
\[YAcute]ch metod\
\>", "Text"],

Cell["\<\
Nejd\[RHacek]\[IAcute]ve si nap\[IAcute]\[SHacek]eme a dosad\[IAcute]me do \
metody v\[AAcute]hov\[YAcute]ch residu\[IAcute] na\[SHacek]\[IAcute] konkr\
\[EAcute]tn\[IAcute] rovnici, (je\[SHacek]t\[EHacek] p\[RHacek]ed \
t\[IAcute]m, ne\[ZHacek] dosad\[IAcute]me n\[AAcute]mi navrhovan\[YAcute] \
tvar  \[RHacek]e\[SHacek]en\[IAcute]). \
\>", "Text"],

Cell["\<\
Residuum tedy v na\[SHacek]em p\[RHacek]\[IAcute]pad\[EHacek] bude:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResiduumGen", "=", 
  RowBox[{"rov", "/.", 
   RowBox[{
    RowBox[{"Equal", "[", 
     RowBox[{"Left_", ",", "Right_"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "Left"}], "+", "Right"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.6000000000000001`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"T", "[", "x", "]"}]}], ")"}]}], "-", 
  RowBox[{
   SuperscriptBox["T", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Dostaneme rovnici, kde na prav\[EAcute] stran\[EHacek] bude integr\[AAcute]l\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVR", "=", 
  RowBox[{"0", "==", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{"w", "[", "x", "]"}], "*", "ResiduumGen", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "1"], 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.6000000000000001`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "20"}], "+", 
          RowBox[{"T", "[", "x", "]"}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["T", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], ")"}]}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Output"]
}, Open  ]],

Cell["Jen si to trochu rozn\[AAcute]sob\[IAcute]me:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVR2", "=", 
  RowBox[{"MVR", "/.", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "b_", "a_"], 
     RowBox[{"c_", " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "\[RuleDelayed]", 
    RowBox[{"Distribute", "[", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "b", "a"], 
      RowBox[{
       RowBox[{"Expand", "[", "c", "]"}], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.000000000000002`"}], " ", 
      RowBox[{"w", "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{"0.6000000000000001`", " ", 
      RowBox[{"T", "[", "x", "]"}], " ", 
      RowBox[{"w", "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"w", "[", "x", "]"}]}], " ", 
      RowBox[{
       SuperscriptBox["T", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A na \[CHacek]leny kde se vyskytuje druh\[AAcute] derivace T \
pou\[ZHacek]ijeme per partes:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WF", "=", 
  RowBox[{"MVR2", "/.", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "b_", "a_"], 
     RowBox[{
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"c___", "?", "NumericQ"}], ",", 
        RowBox[{"w", "[", "x", "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "2", "]"}], "[", "T_", "]"}], "[", "x", 
         "]"}]}], "]"}], " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "b", "a"], 
      RowBox[{
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", "1", "]"}], "[", "w", "]"}], "[", "x", 
          "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", "1", "]"}], "[", "T", "]"}], "[", "x", 
          "]"}]}], "]"}], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
     RowBox[{"c", "*", 
      RowBox[{"w", "[", "a", "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", "T", "]"}], "[", "a", 
       "]"}]}], "-", 
     RowBox[{"c", "*", 
      RowBox[{"w", "[", "b", "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", "T", "]"}], "[", "b", 
       "]"}]}]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.000000000000002`"}], " ", 
      RowBox[{"w", "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{"0.6000000000000001`", " ", 
      RowBox[{"T", "[", "x", "]"}], " ", 
      RowBox[{"w", "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["T", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
   RowBox[{
    RowBox[{"w", "[", "0", "]"}], " ", 
    RowBox[{
     SuperscriptBox["T", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}]}], "-", 
   RowBox[{
    RowBox[{"w", "[", "1", "]"}], " ", 
    RowBox[{
     SuperscriptBox["T", "\[Prime]",
      MultilineFunction->None], "[", "1", "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Nyn\[IAcute] jen \[UAcute]lohu p\[RHacek]eformulujeme takto: hled\[AAcute]me \
\[RHacek]e\[SHacek]en\[IAcute], kter\[EAcute] pro \"v\[SHacek]echny mo\
\[ZHacek]n\[EAcute]\" testovac\[IAcute] funkce spl\[NHacek]uje v\[YAcute]\
\[SHacek]e uvedenou rovnici plus nav\[IAcute]c okrajov\[EAcute] \
podm\[IAcute]nky. T\[IAcute]m jsme dostali to, \[CHacek]emu se \[RHacek]\
\[IAcute]k\[AAcute] slab\[AAcute] formulace \[UAcute]lohy.\
\>", "Text"],

Cell["\<\
Pozn.1: P\[URing]vodn\[IAcute] formulaci pomoc\[IAcute] \
p\[URing]vodn\[IAcute] diferenci\[AAcute]ln\[IAcute] rovnice se logicky \
\[RHacek]\[IAcute]k\[AAcute] siln\[AAcute] formulace\
\>", "Text"],

Cell["\<\
Pozn.2: Lze dok\[AAcute]zat, \[ZHacek]e je-li \[RHacek]e\[SHacek]en\[IAcute] \
\[RHacek]e\[SHacek]en\[IAcute]m siln\[EAcute] formulace, je \[RHacek]e\
\[SHacek]en\[IAcute]m i slab\[EAcute] formulace. S opa\[CHacek]n\[YAcute]m sm\
\[EHacek]rem je to trochu slo\[ZHacek]it\[EHacek]j\[SHacek]\[IAcute]. \
Existuje na to docela slo\[ZHacek]it\[AAcute] matematick\[AAcute] teorie, \
kter\[AAcute] ukazuje, \[ZHacek]e slab\[EAcute] \
\[RHacek]e\[SHacek]en\[IAcute] je v jak\[EAcute]msi smyslu limitou siln\
\[YAcute]ch \[RHacek]e\[SHacek]en\[IAcute].\
\>", "Text"],

Cell["\<\
Pozn.3: Sice se m\[URing]\[ZHacek]e zd\[AAcute]t, \[ZHacek]e jsme \
p\[RHacek]eformulov\[AAcute]n\[IAcute]m nic v\[YAcute]znamn\[EAcute]ho neud\
\[EHacek]lali. Je to ale dosti v\[YAcute]znamn\[YAcute] krok. Mimo jin\
\[EAcute] n\[AAcute]m umo\[ZHacek]n\[IAcute] pou\[ZHacek]\[IAcute]t v metod\
\[EHacek] kon. prvk\[URing] line\[AAcute]rn\[IAcute] elementy, kter\[EAcute] \
maj\[IAcute] nulovou druhou derivaci a p\[RHacek]i zp\[EHacek]tn\[EAcute]m \
dosazen\[IAcute] \[RHacek]e\[SHacek]en\[IAcute] do p\[URing]vodn\[IAcute] \
dif. rovnice by n\[AAcute]m \[CHacek]len stouto derivac\[IAcute] \[UAcute]pln\
\[EHacek] vypadl. Slab\[EAcute] \[RHacek]e\[SHacek]en\[IAcute] pomoc\[IAcute] \
lin element\[URing] je ale jak\[YAcute]msi limitn\[IAcute]m p\[RHacek]ibl\
\[IAcute]\[ZHacek]en\[IAcute]m \[RHacek]e\[SHacek]en\[IAcute] na\[SHacek]eho \
tvaru k \[RHacek]e\[SHacek]en\[IAcute] obecn\[EAcute]mu i p\[RHacek]i uva\
\[ZHacek]ov\[AAcute]n\[IAcute] vlivu druh\[YAcute]ch derivac\[IAcute]. Nav\
\[IAcute]c n\[AAcute]m slab\[AAcute] formulace nap\[RHacek]. umo\[ZHacek]\
\[NHacek]uje zahrnout do modelu bodov\[EAcute] zdroje.\
\>", "Text"],

Cell["\<\
Pozn.4: Metodu v\[AAcute]hov\[YAcute]ch residu\[IAcute] dostaneme ze slab\
\[EAcute] formulace pouye t\[IAcute]m, \[ZHacek]e hled\[AAcute]me \[RHacek]e\
\[SHacek]en\[IAcute] v n\[AAcute]mi zvolen\[EAcute]m tvaru (samoz\[RHacek]ejm\
\[EHacek] kone\[CHacek]n\[EHacek] parametrizovateln\[EAcute]m) a \
spln\[EHacek]n\[IAcute] uveden\[EAcute] integr\[AAcute]ln\[IAcute] rovnice \
\[ZHacek]\[AAcute]d\[AAcute]me pouze pro kone\[CHacek]n\[YAcute] \
po\[CHacek]et v\[AAcute]hov\[YAcute]ch funkc\[IAcute] w[x].\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Metoda kone\[CHacek]n\[YAcute]ch prvk\[URing] MKP (Finite elements method FEM)\
\>", "Section"],

Cell[CellGroupData[{

Cell["Tvorba hledan\[EAcute]ho tvaru \[RHacek]e\[SHacek]en\[IAcute]", \
"Subsection"],

Cell["\<\
Jedn\[IAcute]m z hlavn\[IAcute]ch prvk\[UAcute] metody \
kone\[CHacek]n\[YAcute]ch element\[URing] je zp\[URing]sob, jak\[YAcute]m se \
pro r\[URing]zn\[EAcute] geometrie generuje tvar hledan\[EAcute]ho \[RHacek]e\
\[SHacek]en\[IAcute]:\
\>", "Text"],

Cell["\<\
Nejd\[RHacek]\[IAcute]ve se po\[CHacek]\[IAcute]tan\[AAcute] oblast rozd\
\[EHacek]l\[IAcute] na men\[SHacek]\[IAcute] podoblasti \
ur\[CHacek]en\[EAcute]ho tvaru - tzv. elementy  (v 1D jsou to \[UAcute]se\
\[CHacek]ky, ve 2D obvykle troj\[UAcute]heln\[IAcute]ky, nebo m\[EAcute]n\
\[EHacek] obvykle obd\[EAcute]ln\[IAcute]ky, ve 3D tetrahedrony nebo kv\
\[AAcute]dry). Pro ka\[ZHacek]d\[YAcute] element se podle jeho typu (nap\
\[RHacek]. Lagrangeuv line\[AAcute]rn\[IAcute], kvadratick\[YAcute] atd., kde \
to linearn\[IAcute] je ve skute\[CHacek]nosti typ funkce, kterou aproximujeme \
\[RHacek]e\[SHacek]en\[IAcute] a Lagrange\[URing]v je zp\[URing]sob jak\
\[YAcute]m to na dan\[EAcute]m elementu d\[EHacek]l\[AAcute]me (tedy ehm. \
zase zjednodu\[SHacek]en\[EHacek] \[RHacek]e\[CHacek]eno, \[ZHacek]e?) ), tak\
\[ZHacek]e znovu: pro ka\[ZHacek]d\[YAcute] element se podle jeho typu ur\
\[CHacek]\[IAcute] ur\[CHacek]it\[YAcute] po\[CHacek]et bod\[URing] - tzv. n\
\[OAcute]d\[URing], nebo t\[EAcute]\[ZHacek] Gausov\[YAcute]ch bod\[URing]. V\
\[ZHacek]dy to jsou vrcholy dan\[EAcute]ho elementu (v 2D nap\[RHacek]. \
vrcholy troj\[UAcute]heln\[IAcute]ka, v 1D samoz\[RHacek]ejm\[EHacek] krajn\
\[IAcute] body) plus u elementu vy\[SHacek]\[SHacek]\[IAcute]ch \[RHacek]\
\[AAcute]d\[URing] (ne line\[AAcute]rn\[IAcute]ch) nav\[IAcute]c nap\[RHacek] \
st\[RHacek]edy hran nebo st\[RHacek]ed elementu atd. 
Takto rozd\[EHacek]len\[EAcute] celkov\[EAcute] oblasti na elementy s n\
\[OAcute]dy se \[RHacek]\[IAcute]k\[AAcute] s\[IAcute]\[THacek] (mesh).\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Galerkinova formulace", "Subsection"],

Cell["\<\
Postup: 
-nejd\[RHacek]\[IAcute]ve p\[RHacek]evedeme formulaci \[UAcute]lohy na slabou \
formulaci
-dosad\[IAcute]me hledan\[YAcute] tvar \[RHacek]e\[SHacek]en\[IAcute] (metoda \
v\[AAcute]hov\[YAcute]ch residu\[IAcute]) dan\[YAcute] metodou kone\[CHacek]n\
\[YAcute]ch prvk\[URing]
-dosad\[IAcute]me tvary v\[AAcute]hov\[YAcute]ch funkc\[IAcute] podle \
Galerkinovy metody (t\[IAcute]m dostaneme pot\[RHacek]ebn\[YAcute] \
po\[CHacek]et rovnic)
-vy\[RHacek]e\[SHacek]\[IAcute]me vzniklou soustavu rovnic (\[RHacek]e\
\[SHacek]en\[IAcute]m jsou koeficienty na\[SHacek]eho tvaru \[RHacek]e\
\[SHacek]en\[IAcute])\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{784, 565},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 130, 5, 83, "Text"],
Cell[CellGroupData[{
Cell[712, 29, 166, 5, 87, "Section"],
Cell[881, 36, 150, 3, 29, "Text"],
Cell[1034, 41, 52, 0, 29, "Text"],
Cell[1089, 43, 342, 11, 31, "Input"],
Cell[1434, 56, 270, 8, 31, "Input"],
Cell[1707, 66, 384, 7, 47, "Text"],
Cell[2094, 75, 63, 2, 29, "Text"],
Cell[2160, 79, 155, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[2340, 88, 304, 9, 31, "Input"],
Cell[2647, 99, 31393, 1790, 186, 26397, 1705, "GraphicsData", "PostScript", \
"Graphics"],
Cell[34043, 1891, 134, 4, 30, "Output"]
}, Open  ]],
Cell[34192, 1898, 54, 0, 29, "Text"],
Cell[CellGroupData[{
Cell[34271, 1902, 370, 12, 31, "Input"],
Cell[34644, 1916, 302, 10, 30, "Output"]
}, Open  ]],
Cell[34961, 1929, 72, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[35058, 1935, 237, 7, 31, "Input"],
Cell[35298, 1944, 276, 9, 30, "Output"]
}, Open  ]],
Cell[35589, 1956, 99, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[35713, 1962, 308, 9, 30, "Input"],
Cell[36024, 1973, 13593, 827, 186, 12120, 799, "GraphicsData", "PostScript", \
"Graphics"],
Cell[49620, 2802, 134, 4, 29, "Output"]
}, Open  ]],
Cell[49769, 2809, 186, 4, 33, "Text"],
Cell[49958, 2815, 288, 5, 52, "Text"],
Cell[50249, 2822, 609, 11, 109, "Text"],
Cell[CellGroupData[{
Cell[50883, 2837, 56, 1, 30, "Input"],
Cell[50942, 2840, 343, 12, 29, "Output"]
}, Open  ]],
Cell[51300, 2855, 234, 7, 42, "Input"],
Cell[51537, 2864, 444, 7, 52, "Text"],
Cell[51984, 2873, 398, 6, 52, "Text"],
Cell[52385, 2881, 899, 14, 109, "Text"],
Cell[53287, 2897, 327, 5, 52, "Text"],
Cell[CellGroupData[{
Cell[53639, 2906, 40, 0, 38, "Subsection"],
Cell[53682, 2908, 48, 0, 33, "Text"],
Cell[53733, 2910, 308, 5, 52, "Text"],
Cell[CellGroupData[{
Cell[54066, 2919, 279, 8, 42, "Input"],
Cell[54348, 2929, 159, 4, 29, "Output"]
}, Open  ]],
Cell[54522, 2936, 112, 3, 33, "Text"],
Cell[54637, 2941, 56, 0, 33, "Text"],
Cell[CellGroupData[{
Cell[54718, 2945, 183, 5, 30, "Input"],
Cell[54904, 2952, 97, 2, 29, "Output"]
}, Open  ]],
Cell[55016, 2957, 162, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[55203, 2964, 57, 1, 30, "Input"],
Cell[55263, 2967, 125, 3, 29, "Output"]
}, Open  ]],
Cell[55403, 2973, 156, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[55584, 2980, 208, 6, 30, "Input"],
Cell[55795, 2988, 6546, 329, 186, 4192, 287, "GraphicsData", "PostScript", \
"Graphics"],
Cell[62344, 3319, 134, 4, 29, "Output"]
}, Open  ]],
Cell[62493, 3326, 108, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[62626, 3333, 59, 1, 30, "Input"],
Cell[62688, 3336, 314, 9, 29, "Output"]
}, Open  ]],
Cell[63017, 3348, 114, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[63156, 3355, 61, 1, 30, "Input"],
Cell[63220, 3358, 323, 9, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63580, 3372, 212, 6, 30, "Input"],
Cell[63795, 3380, 5713, 283, 186, 3581, 245, "GraphicsData", "PostScript", \
"Graphics"],
Cell[69511, 3665, 134, 4, 29, "Output"]
}, Open  ]],
Cell[69660, 3672, 195, 4, 33, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[69892, 3681, 42, 0, 30, "Subsection"],
Cell[69937, 3683, 272, 5, 52, "Text"],
Cell[CellGroupData[{
Cell[70234, 3692, 280, 8, 42, "Input"],
Cell[70517, 3702, 157, 4, 29, "Output"]
}, Open  ]],
Cell[70689, 3709, 112, 3, 33, "Text"],
Cell[70804, 3714, 56, 0, 33, "Text"],
Cell[CellGroupData[{
Cell[70885, 3718, 185, 5, 30, "Input"],
Cell[71073, 3725, 94, 2, 29, "Output"]
}, Open  ]],
Cell[71182, 3730, 162, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[71369, 3737, 58, 1, 30, "Input"],
Cell[71430, 3740, 122, 3, 29, "Output"]
}, Open  ]],
Cell[71567, 3746, 156, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[71748, 3753, 209, 6, 30, "Input"],
Cell[71960, 3761, 6543, 331, 186, 4226, 290, "GraphicsData", "PostScript", \
"Graphics"],
Cell[78506, 4094, 134, 4, 29, "Output"]
}, Open  ]],
Cell[78655, 4101, 108, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[78788, 4108, 60, 1, 30, "Input"],
Cell[78851, 4111, 309, 9, 29, "Output"]
}, Open  ]],
Cell[79175, 4123, 114, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[79314, 4130, 62, 1, 30, "Input"],
Cell[79379, 4133, 318, 9, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79734, 4147, 213, 6, 30, "Input"],
Cell[79950, 4155, 5623, 280, 186, 3490, 242, "GraphicsData", "PostScript", \
"Graphics"],
Cell[85576, 4437, 134, 4, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85759, 4447, 39, 0, 30, "Subsection"],
Cell[85801, 4449, 296, 5, 52, "Text"],
Cell[CellGroupData[{
Cell[86122, 4458, 275, 8, 42, "Input"],
Cell[86400, 4468, 158, 4, 29, "Output"]
}, Open  ]],
Cell[86573, 4475, 112, 3, 33, "Text"],
Cell[86688, 4480, 56, 0, 33, "Text"],
Cell[CellGroupData[{
Cell[86769, 4484, 183, 5, 30, "Input"],
Cell[86955, 4491, 389, 8, 37, "Message"],
Cell[87347, 4501, 97, 2, 29, "Output"]
}, Open  ]],
Cell[87459, 4506, 162, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[87646, 4513, 57, 1, 30, "Input"],
Cell[87706, 4516, 125, 3, 29, "Output"]
}, Open  ]],
Cell[87846, 4522, 156, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[88027, 4529, 208, 6, 30, "Input"],
Cell[88238, 4537, 6567, 332, 186, 4225, 290, "GraphicsData", "PostScript", \
"Graphics"],
Cell[94808, 4871, 134, 4, 29, "Output"]
}, Open  ]],
Cell[94957, 4878, 108, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[95090, 4885, 59, 1, 30, "Input"],
Cell[95152, 4888, 314, 9, 29, "Output"]
}, Open  ]],
Cell[95481, 4900, 114, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[95620, 4907, 61, 1, 30, "Input"],
Cell[95684, 4910, 323, 9, 29, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96044, 4924, 212, 6, 30, "Input"],
Cell[96259, 4932, 5580, 280, 186, 3463, 242, "GraphicsData", "PostScript", \
"Graphics"],
Cell[101842, 5214, 134, 4, 29, "Output"]
}, Open  ]],
Cell[101991, 5221, 649, 10, 71, "Text"],
Cell[102643, 5233, 540, 8, 52, "Text"],
Cell[103186, 5243, 277, 5, 52, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103512, 5254, 70, 2, 73, "Section"],
Cell[103585, 5258, 254, 5, 52, "Text"],
Cell[103842, 5265, 190, 4, 33, "Text"],
Cell[104035, 5271, 360, 6, 52, "Text"],
Cell[104398, 5279, 91, 2, 33, "Text"],
Cell[CellGroupData[{
Cell[104514, 5285, 237, 7, 30, "Input"],
Cell[104754, 5294, 290, 9, 29, "Output"]
}, Open  ]],
Cell[105059, 5306, 100, 2, 33, "Text"],
Cell[CellGroupData[{
Cell[105184, 5312, 245, 7, 42, "Input"],
Cell[105432, 5321, 561, 17, 42, "Output"]
}, Open  ]],
Cell[106008, 5341, 61, 0, 33, "Text"],
Cell[CellGroupData[{
Cell[106094, 5345, 455, 13, 44, "Input"],
Cell[106552, 5360, 853, 26, 42, "Output"]
}, Open  ]],
Cell[107420, 5389, 116, 3, 33, "Text"],
Cell[CellGroupData[{
Cell[107561, 5396, 1408, 43, 99, "Input"],
Cell[108972, 5441, 1209, 37, 42, "Output"]
}, Open  ]],
Cell[110196, 5481, 448, 7, 52, "Text"],
Cell[110647, 5490, 208, 4, 33, "Text"],
Cell[110858, 5496, 568, 9, 52, "Text"],
Cell[111429, 5507, 1143, 16, 90, "Text"],
Cell[112575, 5525, 526, 8, 52, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113138, 5538, 105, 2, 73, "Section"],
Cell[CellGroupData[{
Cell[113268, 5544, 85, 1, 38, "Subsection"],
Cell[113356, 5547, 260, 5, 33, "Text"],
Cell[113619, 5554, 1577, 22, 147, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115233, 5581, 43, 0, 38, "Subsection"],
Cell[115279, 5583, 635, 13, 109, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

