(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21282,        574]
NotebookOptionsPosition[     20724,        553]
NotebookOutlinePosition[     21125,        570]
CellTagsIndexPosition[     21082,        567]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"fourPlot", "[", "fDats_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "obraz", ",", "im", ",", "re", ",", "abs", ",", "implot", ",", 
         "replot", ",", "absplot", ",", 
         RowBox[{"opacity", "=", "0.7"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"obraz", "=", 
         RowBox[{"Fourier", "[", "fDats", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"im", ",", "re", ",", "abs"}], "}"}], "=", 
         RowBox[{"Transpose", "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Through", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Im", ",", "Re", ",", "Abs"}], "}"}], "[", "#", "]"}],
               "]"}], "&"}], "/@", "obraz"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"implot", "=", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"im", ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Yellow", ",", "Thick", ",", 
              RowBox[{"Opacity", "[", "opacity", "]"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", "True"}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<i\>\"", ",", "\"\< \!\(\*
StyleBox[\"Im\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"Re\",
FontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\"Abs\",
FontColor->GrayLevel[0]]\) \>\""}], "}"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"replot", "=", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"re", ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thick", ",", 
              RowBox[{"Opacity", "[", "opacity", "]"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", "True"}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<i\>\"", ",", "\"\< \!\(\*
StyleBox[\"Im\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"Re\",
FontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\"Abs\",
FontColor->GrayLevel[0]]\) \>\""}], "}"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"absplot", "=", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"abs", ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", "Thick", ",", 
              RowBox[{"Opacity", "[", "opacity", "]"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", "True"}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<i\>\"", ",", "\"\< \!\(\*
StyleBox[\"Im\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"Re\",
FontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\"Abs\",
FontColor->GrayLevel[0]]\) \>\""}], "}"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"replot", ",", "implot", ",", "absplot", ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fourPlot2", "[", "fDats_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "obraz", ",", "im", ",", "re", ",", "abs", ",", "absplot", ",", 
         RowBox[{"opacity", "=", "0.7"}], ",", 
         RowBox[{"ptSize", "=", "0.01"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"obraz", "=", 
         RowBox[{"Fourier", "[", "fDats", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"im", ",", "re", ",", "abs"}], "}"}], "=", 
         RowBox[{"Transpose", "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Through", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Im", ",", "Re", ",", "Abs"}], "}"}], "[", "#", "]"}],
               "]"}], "&"}], "/@", "obraz"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"absplot", "=", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"abs", ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"PointSize", "[", "ptSize", "]"}], ",", 
              RowBox[{"Opacity", "[", "opacity", "]"}]}], "}"}]}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<i\>\"", ",", "\"\< \!\(\*
StyleBox[\"Im\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"Re\",
FontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\"Abs\",
FontColor->GrayLevel[0]]\) \>\""}], "}"}]}], ",", 
           RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"absplot", ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tamAzpet", "[", "fDats_", "]"}], ":=", 
     RowBox[{"InverseFourier", "@", 
      RowBox[{"Fourier", "[", "fDats", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"error", "[", "fDats_", "]"}], ":=", 
     RowBox[{"Abs", "[", 
      RowBox[{"fDats", "-", 
       RowBox[{"tamAzpet", "[", "fDats", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"errorPlot", "[", "fDats_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "err", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"err", "=", 
         RowBox[{"error", "[", "fDats", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"100", "*", "err"}], 
           RowBox[{"Max", "[", "fDats", "]"}]], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<i\>\"", ",", "\"\<\[Delta] [%]\>\""}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"\"\<\[Delta]max= \>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{"TraditionalForm", "[", 
              RowBox[{"Max", "[", 
               FractionBox[
                RowBox[{"100", "*", "err"}], 
                RowBox[{"Max", "[", "fDats", "]"}]], "]"}], "]"}], "]"}], 
            "<>", "\"\< %\>\""}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejPeaky", "[", "fDats_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"obraz", ",", "d1", ",", "maxAbs", ",", 
         RowBox[{"uroven", "=", "0.05"}], ",", "test"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"obraz", "=", 
         RowBox[{"Prepend", "[", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{"Fourier", "[", "fDats", "]"}], ",", "1"}], "]"}], ",", 
           "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#", ",", 
             RowBox[{"Abs", "[", 
              RowBox[{"obraz", "[", 
               RowBox[{"[", "#", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "[", "fDats", "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"maxAbs", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"Last", "/@", "d1"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"test", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i1_", ",", "a1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i2_", ",", "a2_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i3_", ",", "a3_"}], "}"}]}], "}"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a1", "<", "a2", ">", "a3"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"a2", ">", 
            RowBox[{"uroven", "*", "maxAbs"}]}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"Partition", "[", 
           RowBox[{"d1", ",", "3", ",", "1"}], "]"}], ",", "test"}], 
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejIx", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i1_", ",", "a1_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i2_", ",", "a2_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i3_", ",", "a3_"}], "}"}]}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"index", ",", "hodnota"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"index", "=", 
         FractionBox[
          RowBox[{"a1", "+", 
           RowBox[{"2", " ", "a1", " ", "i2"}], "-", 
           RowBox[{"4", " ", "a2", " ", "i2"}], "+", 
           RowBox[{"a3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "i2"}]}], ")"}]}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"a1", "-", 
             RowBox[{"2", " ", "a2"}], "+", "a3"}], ")"}]}]]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"hodnota", "=", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "a2"}], "+", "a3"}], ")"}], "2"], 
            "-", 
            RowBox[{"2", " ", "a1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "a2"}], "+", "a3"}], ")"}]}]}], 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"a1", "-", 
              RowBox[{"2", " ", "a2"}], "+", "a3"}], ")"}]}]]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i2", ",", "a2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"index", ",", "hodnota"}], "}"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.692863162109375*^9, 3.69286338525*^9}, {
   3.692863420015625*^9, 3.692863440421875*^9}, {3.692863473125*^9, 
   3.692863537953125*^9}, {3.692863655890625*^9, 3.69286365971875*^9}, {
   3.692863710171875*^9, 3.69286393509375*^9}, {3.692863965171875*^9, 
   3.6928640306875*^9}, {3.692864117078125*^9, 3.69286416190625*^9}, {
   3.692864196328125*^9, 3.69286431259375*^9}, {3.692864353171875*^9, 
   3.692864462*^9}, {3.692864563265625*^9, 3.692864563625*^9}, {
   3.69286461065625*^9, 3.692864691734375*^9}, {3.69286474065625*^9, 
   3.692864841890625*^9}, {3.692865044046875*^9, 3.6928650506875*^9}, 
   3.692865616109375*^9, {3.692865678359375*^9, 3.692865678796875*^9}, 
   3.6928657411875*^9, {3.692865785640625*^9, 3.692865913796875*^9}, {
   3.692866074390625*^9, 3.69286608228125*^9}, {3.69286912965625*^9, 
   3.692869134875*^9}, {3.692869391015625*^9, 3.692869391234375*^9}, {
   3.693047844984375*^9, 3.6930478853125*^9}, {3.69304881184375*^9, 
   3.69304890146875*^9}, {3.693106369578125*^9, 3.693106381328125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nSamplu", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{
    StyleBox[
     StyleBox[
      RowBox[{"2", ".0"}]],
     FontColor->RGBColor[1, 0, 0]], "Pi"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmin", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox[
    RowBox[{"tmax", "-", "tmin"}], 
    RowBox[{"nSamplu", "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rn", "=", 
    RowBox[{"Range", "[", 
     RowBox[{"tmin", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"f", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegy", "=", 
   RowBox[{"N", "@", 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "2"], "+", "1."}], "&"}], "/@", 
       RowBox[{"Range", "[", "7", "]"}]}], ",", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DC", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "t_", "]"}], "=", 
    RowBox[{"DC", "+", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"#", "*", "t"}], "]"}], "&"}], "/@", "omegy"}], ")"}]}]}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fValues", ":=", 
   RowBox[{
    RowBox[{"#", "/@", "rn"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fDats", "=", 
   RowBox[{"fValues", "[", "f", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errorPlot", "[", "fDats", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tamAzpet", "[", "fDats", "]"}], "//", "ListPlot"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"fourPlot", "[", "fDats", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.692865661171875*^9, 3.692865661578125*^9}, 
   3.692865716359375*^9, {3.6928660881875*^9, 3.692866101140625*^9}, {
   3.692867112015625*^9, 3.69286716653125*^9}, 3.69286790353125*^9, {
   3.692869174640625*^9, 3.69286919165625*^9}, 3.692869427953125*^9, {
   3.69286985540625*^9, 3.69286986046875*^9}, {3.6929497097140074`*^9, 
   3.6929497224327574`*^9}, {3.6929497780421324`*^9, 3.6929497997921324`*^9}, 
   3.6929498804796324`*^9, {3.6929499281358824`*^9, 3.6929499823390074`*^9}, {
   3.6930462581875*^9, 3.6930462628125*^9}, {3.69304629584375*^9, 
   3.693046358421875*^9}, {3.693046409453125*^9, 3.6930464464375*^9}, {
   3.693046528296875*^9, 3.693046528578125*^9}, {3.69304658834375*^9, 
   3.693046597234375*^9}, 3.693047058515625*^9, 3.693047152796875*^9, 
   3.6930474216875*^9, {3.693047471265625*^9, 3.6930475148125*^9}, {
   3.693047795890625*^9, 3.693047798265625*^9}, 3.693047915828125*^9, 
   3.693048093625*^9, {3.69304815546875*^9, 3.693048184625*^9}, 
   3.693048226765625*^9, 3.693048261796875*^9, {3.69304829784375*^9, 
   3.6930483076875*^9}, 3.69304839059375*^9, {3.693048484703125*^9, 
   3.693048509765625*^9}, {3.693048560296875*^9, 3.693048577765625*^9}, {
   3.693048619296875*^9, 3.69304867659375*^9}, {3.6930489140625*^9, 
   3.693048932625*^9}, {3.693106405328125*^9, 3.693106419390625*^9}, {
   3.693106464890625*^9, 3.693106493328125*^9}, {3.693106558828125*^9, 
   3.69310657109375*^9}, {3.69310661484375*^9, 3.69310662653125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"imax", "=", 
   RowBox[{"Length", "[", "fDats", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vysledky", "=", 
   RowBox[{"vydejIx", "/@", 
    RowBox[{"vydejPeaky", "[", "fDats", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       StyleBox["First",
        FontColor->RGBColor[1, 0, 0]], "/@", "vysledky"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", 
        RowBox[{"0.5", "imax"}]}], "&"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"index_", ",", "val_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"index", "-", "1"}], ")"}], "*", "2.", "Pi"}], "tmax"], ",", 
       FractionBox[
        RowBox[{"2", "val"}], 
        SqrtBox["imax"]]}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"amplitudy", "=", 
  RowBox[{"Last", "/@", "pom"}]}], "\[IndentingNewLine]", 
 RowBox[{"omegyMer", "=", 
  RowBox[{
  "First", "/@", 
   "pom"}]}], "\[IndentingNewLine]", "omegy", "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6928687516875*^9, 3.692868771078125*^9}, 
   3.692869402875*^9, 3.6929499958702574`*^9, {3.693047751796875*^9, 
   3.69304775259375*^9}, {3.693047945921875*^9, 3.6930480720625*^9}, {
   3.693048111625*^9, 3.69304811346875*^9}, {3.693048205421875*^9, 
   3.693048205953125*^9}, 3.6930482474375*^9, {3.693048334203125*^9, 
   3.6930483635625*^9}, {3.693048405359375*^9, 3.69304842521875*^9}, {
   3.693048531796875*^9, 3.693048542640625*^9}, {3.6930486294375*^9, 
   3.69304863315625*^9}, {3.693106595625*^9, 3.69310659678125*^9}}],

Cell[BoxData[
 RowBox[{"DCcomponent", "=", 
  RowBox[{"(", 
   FractionBox[
    RowBox[{"Chop", "@", 
     RowBox[{
      RowBox[{"Fourier", "[", "fDats", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], 
    SqrtBox["imax"]], ")"}]}]], "Input",
 CellChangeTimes->{{3.693046604140625*^9, 3.693046639671875*^9}, {
  3.69304669428125*^9, 3.693046712109375*^9}, {3.69304674390625*^9, 
  3.693046761109375*^9}, {3.693046963828125*^9, 3.693046983640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", 
     SuperscriptBox["i", "2"]}], "+", 
    RowBox[{"b", "*", "i"}], "+", "c"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom1", "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["b", 
      RowBox[{"2", " ", "a"}]]}], "/.", 
    RowBox[{"(", 
     RowBox[{"solabc", "=", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"vyr", "[", "i1", "]"}], "\[Equal]", "a1"}], ",", 
           RowBox[{
            RowBox[{"vyr", "[", "i2", "]"}], "\[Equal]", "a2"}], ",", 
           RowBox[{
            RowBox[{"vyr", "[", "i3", "]"}], "\[Equal]", "a3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"index", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"pom1", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i1", "\[Rule]", 
       RowBox[{"i2", "-", "1"}]}], ",", 
      RowBox[{"i3", "\[Rule]", 
       RowBox[{"i2", "+", "1"}]}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"hodnota", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"vyr", "[", "index", "]"}], "/.", "solabc"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i1", "\[Rule]", 
       RowBox[{"i2", "-", "1"}]}], ",", 
      RowBox[{"i3", "\[Rule]", 
       RowBox[{"i2", "+", "1"}]}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.693107252859375*^9, 3.693107255765625*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"0", "==", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"vyr", "[", "i", "]"}], ",", "i"}], "]"}]}], ",", "i"}], 
  "]"}]], "Input"]
},
WindowSize->{1153, 638},
WindowMargins->{{4, Automatic}, {Automatic, 6}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 333, 10, 103, "Input"],
Cell[881, 32, 12142, 308, 1391, "Input"],
Cell[13026, 342, 3537, 85, 534, "Input"],
Cell[16566, 429, 1779, 46, 284, "Input"],
Cell[18348, 477, 457, 11, 87, "Input"],
Cell[18808, 490, 1710, 52, 165, "Input"],
Cell[20521, 544, 199, 7, 46, "Input"]
}
]
*)

(* End of internal cache information *)
