(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    229445,       4076]
NotebookOptionsPosition[    228464,       4039]
NotebookOutlinePosition[    228867,       4056]
CellTagsIndexPosition[    228824,       4053]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"www", ".", "profitableinsulation", ".", "com"}], "/", 
        "media"}], "/", "20499"}], "/", "prorox"}], "%20", "sl", "%20920", 
     RowBox[{"cz", ".", "pdf"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Lambda]", "=", "0.04"}], ",", " ", 
    RowBox[{"ro", "=", "100"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"www", ".", "profitableinsulation", ".", "com"}], "/", 
        "media"}], "/", "20526"}], "/", "prorox"}], "%20", "wm", 
     RowBox[{"%20960", ".", "pdf"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Lambda]", "=", "0.044"}], ",", 
    RowBox[{"ro", "=", "40"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]Izolace", "=", "0.048"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roIzol", "=", "40"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cpIzol", "=", "2100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roCpIzol", "=", 
     RowBox[{"roIzol", "*", "cpIzol"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cm", "=", 
     RowBox[{"10", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "2.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dIzol", "=", 
     RowBox[{"10", "cm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Sdeska", "=", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "b"}], "+", 
        RowBox[{"a", "*", "c"}], "+", 
        RowBox[{"b", "*", "c"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vvzduch", "=", 
     RowBox[{"a", "*", "b", "*", "c"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cpVzduch", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tloustkaDeska", "=", 
     RowBox[{"3", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vdeska", "=", 
     RowBox[{"Sdeska", "*", "tloustkaDeska"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rocpAl", "=", 
     RowBox[{"2700", "*", "896."}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roVzduch", "=", 
     FractionBox["349.", 
      RowBox[{"273", "+", "20"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pmax", "=", 
     RowBox[{"12.5", "*", "230."}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Pmax", "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"0.5", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"Tanh", "[", 
            FractionBox[
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], "[", "t", "]"}], "-", "90"}], "0.1"], 
            "]"}]}], ")"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.682665067669345*^9, 3.68266522709122*^9}, {
   3.68266549174747*^9, 3.682665493231845*^9}, {3.6827440004375*^9, 
   3.682744013234375*^9}, {3.68274432103125*^9, 3.682744328734375*^9}, {
   3.682744484296875*^9, 3.68274449575*^9}, 3.683437876109375*^9, {
   3.683437966703125*^9, 3.68343799803125*^9}, {3.68343803590625*^9, 
   3.683438055140625*^9}, {3.68343866859375*^9, 3.683438788359375*^9}, {
   3.683438857640625*^9, 3.683438953921875*^9}, {3.68343914203125*^9, 
   3.683439142578125*^9}, 3.683439261359375*^9, 3.683439473125*^9, {
   3.6834398455*^9, 3.6834398665625*^9}, {3.683439998046875*^9, 
   3.6834400018125*^9}, {3.68344008884375*^9, 3.683440091828125*^9}, {
   3.6834405913125*^9, 3.683440591546875*^9}, 3.68344063709375*^9, 
   3.68344091584375*^9, {3.6834411123125*^9, 3.683441124890625*^9}, {
   3.683441172625*^9, 3.683441179234375*^9}, {3.683441212171875*^9, 
   3.683441226421875*^9}, {3.683441333375*^9, 3.683441442984375*^9}, 
   3.6834427244375*^9, {3.694324619296875*^9, 3.694324644109375*^9}, 
   3.69432492484375*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nDeleni", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dVrstva", "=", 
   FractionBox["dIzol", "nDeleni"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mcpVrstva", "=", 
   RowBox[{"dVrstva", "*", "Sdeska", "*", "roCpIzol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rocp", "=", 
   RowBox[{"rocppom", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Vdeska", "*", "rocppom"}], "\[Equal]", 
       RowBox[{
        RowBox[{"Vdeska", "*", "rocpAl"}], "+", 
        RowBox[{"Vvzduch", "*", "roVzduch", "*", "cpVzduch"}], "+", 
        "mcpVrstva"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rthvrstva", "=", 
   FractionBox["dVrstva", 
    RowBox[{"\[Lambda]Izolace", "*", "Sdeska"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcei", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"mcpVrstva", "*", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "i"], "'"}], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["T", 
         RowBox[{"i", "-", "1"}]], "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["T", "i"], "[", "t", "]"}]}], "Rthvrstva"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["T", "i"], "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["T", 
         RowBox[{"i", "+", "1"}]], "[", "t", "]"}]}], "Rthvrstva"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceUvnitr", "=", 
   RowBox[{
    RowBox[{"rcei", "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"2", ",", 
       RowBox[{"nDeleni", "-", "1"}], ",", "1"}], "]"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceDeska", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rocp", "*", "Vdeska", "*", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], "'"}], "[", "t", "]"}]}], "\[Equal]", 
     RowBox[{"P", "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], "[", "t", "]"}], "-", 
        RowBox[{
         SubscriptBox["T", "2"], "[", "t", "]"}]}], "Rthvrstva"]}]}], "}"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceKonec", "=", 
   RowBox[{"{", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          SubscriptBox["T", 
           RowBox[{"nDeleni", "-", "1"}]], "[", "t", "]"}], "-", 
         RowBox[{
          SubscriptBox["T", "nDeleni"], "[", "t", "]"}]}], "Rthvrstva"], 
       "\[Equal]", 
       RowBox[{"\[Alpha]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "nDeleni"], "[", "t", "]"}], "-", "To"}], 
         ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rceUvnitr", ",", "rceDeska", ",", "rceKonec"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "\[Equal]", "To"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "a_"], "[", "t", "]"}], "\[RuleDelayed]", 
       SubscriptBox["T", "a"]}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"5", "*", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{"nezname", "[", "t", "]"}], "]"}], "/.", "res"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68343906875*^9, 3.68343921065625*^9}, {
   3.683439243140625*^9, 3.68343939628125*^9}, 3.683439427515625*^9, {
   3.683439487734375*^9, 3.68343951625*^9}, {3.683439618796875*^9, 
   3.683439618984375*^9}, 3.683439691921875*^9, {3.683439738546875*^9, 
   3.683439792484375*^9}, {3.683439884734375*^9, 3.68344044759375*^9}, {
   3.6834405636875*^9, 3.683440573*^9}, {3.6834406895*^9, 
   3.683440699453125*^9}, 3.683441473796875*^9, 3.694324850921875*^9, {
   3.6943260795625*^9, 3.694326104171875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV03k41PsXB3BXiqLINbeStJEWWoeQ5Y1IpFLmi6uFsVyiSKI9WSJFMlI0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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk0ldsfBvDSQCEylCThaiL9Socm9EiDqVTO+yLJeC6VuuXKcHUzJeUK
IUm6Gswp4rznOGaVqUyHNA+GiIuSKTrcfvv+sdden/X95/mu/ay11V1+O8gR
mzFjRi45/92mV5IXychv3m6rMIuIBbU3vQJPxUV4Ni3BejeXhc85T+MMFFdi
gWS+o6UCC44++zkd0euR6yaz8LAmC+YJxUGaivrou+vNfaHHgh5vZbJ70jZU
2LdHbDJlQba/1r4tGmiTirTfbM/C1HyWr5LibkyXLx0PDGFhOKlvdtFLU5zN
qNdKTGChVysl1j7JAo6GF1r6slk4tmKOTVP0flg1SZ+Ue84CteuUl5wijdet
TU71q/QQ7LLglIzir2Dsx8qH/9TH4tPvv0gr+kB5ZOgfrvYWeMwazWkQC4eY
89TUo2YjFPWuH5mpdAWHtJz4hkPGSG/JEEXGJiDT9ktxNbUTCjt8TCZCk1ES
+lQU9GY3Lvsnpw+K34bcSzUl9V/M0BK/xsJqXiq8U61KjCMtEPEwoTtzKh3n
5t97grd7seDrtJNRaRb8VBIHI8atYP1VdspEkAOZ89KnC5ccgJusql9YSC50
d2lLz1U7CO/rc858VH2I4PL2tAoVayyWajFkJeXD/SFvg6sWG5q6fImSlHzk
8a+LTNexsd42udUkLR8668bD1+myYZr661HrvHysKXDondjChp+BKN6rOh8f
Zfl1EWZsvPHUHMgbzkdgldyyux5sJDf4JOlYFOBdsod/ejobmSP2HGZ/AdBF
55/PZoO7xHi9IV2AxJ01uS4P2KjnSFZbOhfA19JzYhmPjenplG/HfQtgouP/
6EoVG0fW1Zlm3y2AheLaPSc/saEWvfT7yqkCaBtnBorUKeRL4c4KMS56Imz7
NVdSMIlw26spwUX3qX3y+7Qo/Bp2/666AhcjryYSU3Qp3A/Yvl9lLRdpP14G
bDehsNXDNWvhYS62KPjnerlRqO8OZ8u6cLFX/ELfNQ8KDq45Pxd4cBEeJdFR
4kkh6MgYJeXNReabVom5ZyjUsMPFxCO5cGxINrwaRoFtfM9+qphL+rvMIiOd
Qk9Z01xRJRe14U6c2mwKvgajDydruLD5o9Ow7wGFpE2GEt9buTjTo7Nai09h
LeNcMPaaC2MzQ13zYgpluheOjH7koquB3XW0nEKHThP3Wz8XHY5nb6bXUPC6
N+I49I0L17bfU8qfUZi9Rkny63cuZN3/OlLXRCEh3YA3OE3yzL+xLb2VwmpN
Z+eBWQzchzaz1V9SKLodJtU/j8EP6fvLZN9QsFieze+TYRBv4Znk9Y4i79jo
0qvIIPp50yHXDxROKo9If17KQLjBL/vnRwozEhcLutUZ/O/TZcGRDgqxigZu
n1YxGDmwc8mVTgqacU4yXToMEN2NO10UGNmwoo6NDAa3HVZN+kRhd1QWp30L
mdeGbjnXTeGVZKPsx+0MzI8xQQd7KEzNXez+zoLB9bb8TS8+U4g6v03u7QEG
8oJmu0u9FJaLOZW+tmHQ1pX1G6uPwo7pTPmXrgw8bkZq+/xD4dLI1gphAAPd
JW2XBQMUVDdY2HODGfiXnjA0HCT9OWk/nhDOwOh+qUcp8bu+gLWH4xh0KThp
cr9QWNdektiTzcDMuTcwaIjCo2UNG+vyGFyuMk0YJLaxf994j8egNSj0gu03
0o8X07NPP2IQ9fiA0+phCi31RqdFrxkwZ1/9kT9C+jjfSurDRwYh911HZUcp
iPY4ZlR0M7jTNDB0gljzceD7sG8M5k3LP/hljIKPoMJMdh4Pj2/l3A0cp6Cc
vkNjxWYeNL07UsQmKTzoOlgqbsSDxoLEB/uITdRdbf8x4QE9Wz9eJ/ZMDo3K
teJBWdRepvOD9Cn2yY8t7jyEfY+RsxRRcA3c3bovgYfMSi9d92kKObbm5/1G
eXh6zsFj/UwaIREq18YmeTjE0VHjENuWfMny+slDjuQs/+vEs9Ximjzn8xGR
8k5+phgNh89vlZ3V+FB5/2VxPfECnxMPzSz5cLd+EHJwNo1TcTEflFP5qI2P
vrdanMbuKpdv17L4mKWq0G1NrPKdNVsxl4/TnZ6d54hrD71eI1PEx0vN29rP
idU1NM7MaibzW+clz0rQaMkrkBwQ8SEM/juuch4NvcYXm0utC7GIY1y1SopG
jE2v9kO7Qkx4s2qsiAfaJ1XTHAvRAZ9rvsSpIypzLh8vxKfj0mnVxHJLXIWH
Qwsx4nspxEWaxpDr16NT+YXQ/uLw8MoCGtmT4je2yQkQINH/olmWhuqKLdOC
ZgFuHks161agUXxHysP0hQCdv019nkn+EVu19pYXbwWY7uk6oUoctzQ8c6RH
gJVGCzfYEEvItVnrTAvgbdueWEM8/O+p7FtrijC6JV0+dRGN6leZNuEhRdCx
WFJsqUTjRKRSPptVjLl5MgOuS8l+ztrTdluLIaqNC/iTOF/fyNQRxcjTevQ9
gXii3fXDUcti1MdE8eqIQ/Vy5we6FePSs+UH1qnQuP5hl2tWfDEaZ+jJjRJX
rf9d4d/RYvikLvPzUqWxrK3BJ4MpATtGVLZdnUa46u/64/8rw85YMf8VK2nQ
fld7OmPKwRGrfKauRePx692tj8MrUBNmZf9Nh0ZUYLA2Z2sl2Kesny7ZQIO3
ghV8vq8SVRv367dvJPMS4YfAjEeYMLtTH6tP8ry9z3pq+xh2Ce2DzzfTYPd7
xw4pPUF2xwNf8W00PEUFg/FtT2CW5Dlz3IAGP26D8cWwKvy99F/tq0Zkf5Wk
ZJud1bBRcrDTAo12HeOhM+PVuM12CjpnTOP4didjubQasrdt270dNDKMjyVF
uNSiZ5uOa4sJDcX6/P4D8nXYOGRTXbeTBmtPz86xljq4v7KTLd5F44K5bcLn
sKeQiXr3d9hu0rd9O7pt9J5hX7369OY9NOJ3LDZIHXmGD1cXr+klXlmu9df2
tHrIqB8wDDCl4bF2TSeP04AJXfPL881oiCel6OdoNOLSnr47F4lfR7NDh1oa
YXq67Pwwsb3P6EvZ2CYkawwI7cxpXPQ6KgeNZkgazwjPI16YHc/n+TfjsJWG
1TTxsB3jdONVM26mi/abWtAY3DsWtmqDEMuPR5iFE6dzqj7n6wrhctaFfZHY
6c+rZkYsIZ4vrzxyibglR0+a2iRE2k85r7+IeZI+8SGGQvhay8RFEwfVjd95
byZEed6NsmvECrsmyuNchJDe5FeaQdxwuFZ9uZsQltaRgkziC96JodkcIQS5
OkwW8eTdzXsqPYSY+q507x7xBzH/xi8nhTA9ee1KLnFGxeQ7swAhJDY6m/H/
y/eqzqjtrBAeMc5GhcTKQ9dvOZ0jeY4O6wqII5dvdfMNFiLYoVq5mPjUuT/6
U8OF4IwZdJcRr0kw37v+khD2r6pflBN33lfOLY4QouJ5Z00FMfW+yKvlshC8
XmHmI+IFYxHPHaKFKHRPS3xMXCtlr98XI8S8JsmLT4iDNbUTvWOFcD44x7eK
eKuBaPJnnBB+K2I51cT/B8NUHYE=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Hk01VsbB3AhFElKFIVCEY2HSoYvbpkaDGcfSplFaZBcNJnlZixTkW6T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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwd0gk0lekfB/BLiEIiMaayhJI0me6VLb5R1hbxvmGk7FFGSFdiQkhJFEaR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     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwd0gk0lVsbB3BJ6Sskc1KGUKTpdgxR/M1DynD2i6LMUqnroiPpFpm6Ehkr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     "]]}, 
   {Hue[0.8503398874989481, 0.6, 0.6], LineBox[CompressedData["
1:eJwd03k01YsWB3AZKiqJUJLpolSK288h1emLW0gZzu93opBjKlSSx6mum0JS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     "]]}, 
   {Hue[0.08640786499873876, 0.6, 0.6], LineBox[CompressedData["
1:eJwd0gs0lGsXB3AkIpVomNzCQUe695IU/VGuXTTvTIgKQykpSSMpuTSUEuGo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     "]]}, 
   {Hue[0.3224758424985268, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk4lYkXB3DtskdUtjCqUVLqJSF9LSmkeN/XUqRrC5NK0qUh4iYlRUhI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     "]]}, 
   {Hue[0.5585438199983166, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nk0lXsXB3DX0CBTIjOHiy7pptdzhKSvkCTDec4jYyGzJEkiSkhKA5ky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     "]]}, 
   {Hue[0.7946117974981064, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk0VYsXB3CZKnNKxoSXRiW9Q6T4IjKEe849ogwZG4QibvlJhSQyX0nS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     "]]}, 
   {Hue[0.030679774997896203`, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1Xk41AsXB3AXIWW5toSEi0K9kZ816YskRPObGRGSQiiVpJGrmz1Li0Kq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     "]]}, 
   {Hue[0.266747752497686, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1Xk0lWsbBnBDSCJ1ojJzpCRHTq8tY5cxw8GeilAZo5KQdqGvkzlShCQ5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     "]]}, 
   {Hue[0.5028157299974758, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ws0lAsXB3B3pUIK5VI4JJWinhmR+OsmCc/MIxGVRCFpXJouyl0jESEV
Oikh0qkY4xZyUCiX0VE5SvR2JLqQ22H09j7nrHevtddev7U/7b0/bG2PY2wv
CTExsSI6/6nbL2WqKCxYbyn2bxDQ+nOg3E9ZBTb/98fC5hRz5WUwqJb41/u5
pFdfohFESQX/ekdaZbiuMhNGfQ9m/2OGYFnm4fQNKCAPWP1jxaFG185EYOFa
/kJx2jIhoZ+47M2Yy//mJkl7Ro44sUh5G6bDgjmzaH9P/yRV8Wo7Bjh8NSXa
AytuJLum28JyKidKh3ZPhaPWDzd7ROb1zjOn7asnvbstkQTu/2lygLbXl3ea
WiMsvPxTPDyVtntJxQcOm4LZosMOr2nvOXv5bm2xI3QdZYdWixPYtZUTqKTs
BATJ+6bTJufZmh7k7sYON+siDQl6vk49Mf4rZ8xOXBdcSnvrdbGnUqZ7oOWU
s8JPkgC8uhN2pbuigpLXMpcisMFQ4JgrckPs4i/+y6UJMMeT1Cfd9qFq2ENq
rQwB46oj762r9yMv81SuiyyBtE3Zjs8T3eE8zB+/MYtAaq5iWTAOIG0yjCMt
R+CSXKi65sgBLH38+lTcHAIX/YdCG256wNKR4bJmHoH4Duf3R9kH4dnTvWFM
nsB55pOtKpKe8EiwsuxSJHAufV1+dbEnFhpN+fYoEYjwkOcoKB8CvI8p2KgS
CH0S8qK04RCKhbLkb4sJnFnxienOPYxmar3dOg0C3O91Px688kZb2LpbGdoE
gp2MD7jE+uCZ21/cUF0CARW/1oub+sLgaohMuD4Bv8hTF9jpR6CXumRxjyF9
n/7+r9M7/HBaSvW7qTGBwzsc2dkiP1gsekEUEwQ8lNYsHnPzh+FJ99iZDQRW
sQJfNCdykPNycn6vLYGVkgbSSwc4iAo4P6pBElhR8o4ZhAAoaFZYBzsS0F9s
l64+EoDBxuynnL0EdPr0D/ixg7D2h15DGoeAasDbr/OUuXiZWNmzLYOAf8Z5
3fZgLt7xxp6H3CRQ38DYk/wHF5t550yb8ggEql1sUEk9ASPHiZm7fAKtdRaZ
SxecgvAQrp9ro/epkmVjPP8M/rAf2281m4HpvcbsApkIKBmIfPLjGFgWJHv0
AjMClcpbCNsUBlixb3l+hyKwiyuaFmUwcKfofNXqJxE4gz255+8x4CT7fnlx
TCS43WNVDkIGHj5I/lkpFQ3PKpGzmzoT3pJjhS0SPMSea36zs4yJrIqumMg1
PByPXinfVMvE64CafSZuPEz/ymm0e8aETW+c4s0SHpRlUwI5PUysqNIODvaO
RcO5gClVaRMMcR02qLeeh63L5I1uygT+gwVN3tfi4f9m+ubtCRNUDBiNii+6
hNoaX8N4O1PkduSJ4pPTYH028Dg0zbFwE3fz31GZkAkSzJZ3skTCqczcL7I3
YZc00DtuYoWOVANbh9m3cWh7f0r7l02Ie5j2152ZXPxMOhZBZG2B/Lcf7hZV
+ZjJOrYq3WQbqG+KM5vLC6EvZ9AX8N0anopLTsZE3kfvOyldqSQbBF+TPv5u
yUO8k9YY/KlrC9W5HRuJ9CKsGtSS9+zeCa1E9cllM8W41C8aUA+yR9Fc3NKT
4GPFeIKX2Gl7bI7ztNOdxYdfhlj9h3B7HIq5l629kI/CrVuW3btoj3shlqTG
Kj6IIp+z5gX2MPM+mD/fjY9vPcc8d/XZw9HqrutMJR/NZxJ4xxwc0F/dJiOq
5YMd1KZKOjnghPnYw6mnfJTNEDyjvQ5IN9k4a/IFHwyXQckRXwf0GbbxR4b4
8F5THsA55wB/tdF5H9VLsL16f6N3lQPOj5o9FoaUwLxxeWjdQhJLjG1d+REl
sNE03zmuSqLI33UijVeCSXLrV211Em8+haxySynBYv0e5hFtEqt7H13tLyjB
I+vI3ysNSXQ8twgQdZUgNeCnE7mVhFruJh299QK0aJsNR3FI/PYfdpWshQAy
ZgXL5INIbNY+6Dy4WYCq3ssfUo6T8MuMunjfQQCPktlrk0+TqE6unzY9LAAZ
K57vGk3iYNi2F/ZpArzz+mXx6iskCp13RJ8cE8DXINVUv4JEZJzGlfEpAZwu
Hq9XfUTC+dHX/MCfAkQvlCmTriYhpZXS5idXiqnE8vGuWhJ7P3arHdAqxU6f
V0meTSTkuUcf2uwshajjsOKs1yQ4KUk9ardLUb9x7OTDURLbGjxGruSXgtx4
luE6TkJjkpBSvl8K/gujBZKTJBr3dBkoVJTiWuyzzXbTJLR1dI5LtpdCJSp2
5JkYCx0Piud8FpXie/bKBdx5LDBaX66vosrQXLNn4xU9FpJ2D6x86FIGzoj6
ylX6LHzunVqSs78MA4Yfj9YsZ+H2qIZ0wpEyjKqHivetZEFp8UGhW1QZXI4o
1SmuZWH44DefmaIy9N1LLtCzYKFgSjZjg1I5wtcuSDPbxcISPdMf5e3lMBsc
ms4KY6Hy1lzv7S/L4YQb/s/DWXDW6u142V0OCXGpmYkIFlLUeXdG+8vRuj7U
xyaahVlKnZThj3K0z68p+U8sC9//yynIMqhA15enpt8usfDk9Z3dvMgKZLx+
FeubzcLR+EVFjkQl5odZHl1dz4JmZws3r+QRHPvEfumVYIO3JIg5saYa1jn+
dytN2HA6ebn/fVINFL4F+U54sFHXte1FHe8xwuWpbJ94Ni6GRaz0MqvFtmSG
ZvtvbAj0iIjoT7XIrzP3UWih+4+EPWF5v6MmtqSIO8jGte57RLNzHaIHB42U
JCk4DgUnDy+qx+l4lati6hT8RMVfUjvrYSSv1CljRKE0xdgqNqYBR+w7VxdY
USjSSM/cveUJ9qI4/i39x3sNrYaPTzzBxrfhD2wPUDhi6W6llPMUan2f5yv5
U8iz8k2P82hEnSi9Pf40BeXnRUOsBU3AT0VHmRgKhHX/lvGOJnwSJKw3T6Rw
bodz2seYZjiwQqiWKxQY9pv+2s14hqkMj6MeNyikblI1vz36DHd+v7CxKZfC
spoVFyxznsNJbDr0ZyEF71UG7wVeLdh33d53bjEF2fQbzEKdVvydkpW1r4xC
V6Jj1HBHK8bHrq97+YiCK3fslWJyG8wl5ZKNaynEBvooQacdCu1iUV31FOYX
pJYKTrVj6YYcTZVGCt9dStwzXrejocrloOUzCl/sxmP0jYVoO8m5099CIder
4WPRWiFacn7tH6HtfvayjQUhRHNT4dIftDsKGfN2mQgRmhAYuaCVgmAONzVy
oxD9Oh/lQDu8aeLWWxshBNrxBldpL9z6d02KhxAnSi/e29JGocWtUXuppxAu
O5k7HWifC74aVeAlhIqFTL8L7ans9da13kKsmtafc4x2j8Sp1q/+QgzoPFC/
Rjvv8dQbmxAhvuVV7f5M2/11k0XnGSGsno7kT9BWG76W5R4qBM82YFKsnUL8
UjPPExFCjG5xjVamzQk9PXSbJ0SwzaJDFrQN0nbYGZ0XIq7nQ/J22u/vqd2v
jBMiy02+kk1719uKwI4Eej+d4T8O0ZYfj/tjb6IQg8atqgG0G+e6Mj8lCTHH
NMIwhHaE7sqrwclCFKlnWsTQNjMXTf1MEcJdTts2kfb/APFG/yA=
     "]]}, 
   {Hue[0.7388837074972656, 0.6, 0.6], LineBox[CompressedData["
1:eJwt03k0lXsXB3BT6hYRSeEKRbdBUY9jaPDFJRSec47MykxISEcyhYyZpyRv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     "]]}, 
   {Hue[0.9749516849970554, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1Xk01fkbB/DsjVKylSUukwptpu+9idIbJbLdRchSspTspFuGCMmanYmk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     "]]}, 
   {Hue[0.21101966249684523`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hk0lesXB/CSoUwZMkSmoqJu0X3PCZW+kSRxjnPIWBlLpmu6ilzzTBQS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     "]]}, 
   {Hue[0.44708763999663503`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt0nk0lev7BnBjikKKRLRTxo7Kr3cTlS5UMuyNNxUZkiEqmc8uQ2UbEhEb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     "]]}, 
   {Hue[0.6831556174964248, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nk0lV0bBvBMUalEIuOpKJWUt8cQ0mVOOHiSIXxkLjJ3JNGLZEiZJVRk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     "]]}, 
   {Hue[0.9192235949962146, 0.6, 0.6], LineBox[CompressedData["
1:eJwt0gk0lVsbB3BjGpBknnORlEq955T5n6I4jpw3U6aMUVFCR27iHpEh4yFu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     "]]}, 
   {Hue[0.15529157249600445`, 0.6, 0.6], LineBox[CompressedData["
1:eJwl0nk0lfsaB3BjytEoCoXcVIZIvXuHDN9IZcze5iFJlDJkb9pSUmTOTJJU
HKLkENrGIqGSyKvQZEgnckxlKtHpvu591vqtZ33W759n2uBykunGx8PDU0C9
hbw/MUN8uai6Ls//goBRavWFjWJ0iPL/3/PChP9asb2oKbz2P0+kDwlUde1H
EY7xLfiL4s0kh3RjaDZUCi24p8pS9pejGaw8pcQWfEJe0OZlvDm+eWVvX7Db
aO962W8MfFK18VqwM7fqbx+mBdYNn3qzYPtzl+/WlVpiUXNaHC9lKwMf9iox
a+y6wC7ho2y+1FjjCMcGde/tTgos1Nshz3O/yxa+ZrTZRZQNrvM8FdCwR/bV
yzHClOH2PtYq3QHaShreyynv2lpmmTvnCMMmqX/EKNOnE6S+OzpBRP0+U5qy
2kOP/n01h/DM3YJHgXKqXrbli3hnvInnNadTTsldUeGHwyjjdmbtpZwoHCS1
/tth5KsP29lTjvMeDmrMckHPDfVuFuWYdtt+L+YRLGZpJcVSjqI/MRDnd8Xn
79J9f1EOT99xp6bUFTG8LOVXlEP/zRQ55uoG/0vC3b8oB7ss81kudhRN2Z+s
VHgJBD05+6q88She8YTMulIOVByiO3OOQXmmV/5PygFx1umLN7tDlKOhMUCZ
M1H/616XOzJuPIhV4yPgZ6122C7yOJqbjpwJpcyqutHAq3ECc5ahFr2UPUMC
LjHTPTCiYiBUyE/tb2Bg7KeRJzaEWQbICRA4ZmTJzJ7zhP6h5wKZlF0L67jG
BV54EXZ4ZJMgAZdVqhJTjt5o6Yr1LqfszMkIzFh6EllM5lPGIgIH3y3p21Nz
Eu0lO1RnKCsz2K+ex/ugr+3Ir4OLCSjxKwjKfPGBqJZL/YYlBBS5vXRfsBC7
97HdV8qbJUzTpb6xcJ0Vd6XwDwKbmvlfnDRk4xVLOfyGCIGN56p+1WexkRTR
3HV1KQG5j5sPezJ94X7isnjpcgKyyT1Jj/J9caogdie5goCMweWG1fx+cJOe
3Di3ksC6O3xbHpb6oWniWDF7NYE1rO6xpWIcfPTeYD0hQcD7WtTGNj8OtqyK
PpgoRaChkWaf9JqDTU0lT3TWE2BLxjWKp/hD8rF+d4MsgdZ6nQwZ0QCoenaG
B20hID/2D/mRHQDXqP9IJipS+1t7RSinPQCDrfyyJcpUv17j7C1JZ7Bxa7yP
jBp1H+KZhmorA3H92BHnXE0C3TA5P+kTCN3v51qUtAkQHj/uc9sCcVjrjEet
LoH+WnNZzYRzmF5rtGSlAQHt47zf9ZafhwqZZ+RoTuDnQTVm/qJg3HKYkAk7
Ts3PV8jrEj0YFRpDmQOeBBiR3RGeR4PxWqXQ3MqHwO2SqIcqT4LhUpo2budP
wFqof0tpWAhk89jC/4YRKL6X9LtaIBTROw30M28R+NDoLnmdCEWCoh6r+Q6B
xe91aEGuoSCnJOL5Cgk4CQ6fQEMo3tKj9qeUERCx1+9suBiGh819QfrPCLjz
TxW08EXgQefuU7WjBDKr3oaFqEYgQ0RAznSCwBtWrdNOxwj0q7XK/T1DwLAv
ekUWNwKRq8993MpDg+LDDX5+7pHwJdk5KqI0DHMO7JJqjcJbZbX5Lk0avP/J
b3K/GoNPj2LTXRNoqPqybZJ3bSJKZjPbIhl0uDQwZUa2JuK419p9PTZ0CGf6
GXfqJ6JJ0jpTw4kOO5uK7PyTiaiTle7g9aDjR6OupcXTRIh8N9vbFUoHLduM
m8NJgn1itWdcJR33Dnr67+tIBh79ZE1s2onc9ry5mKRUuOWOuA8tV8dqPY7+
j4sZKGJJaBZoayI2ICN3VCgLZIuu1AOOFtpTFIwPLMmBhE71/gpBXUQXp36+
PZ+Lz5Ur63vbgWXjv5x1Ht7Bzttmz3aI68FifMW8fmUBxob9MhTP6cN1hfTp
sJAiDFVV/XBr3wO/q4KneqWLcbsu+bm9/F6sEWnXJtJLsPn+/buDafsgGy/1
fdN8KeoZZr20mf2ImtR8RJ7lwufjt7+fso0grWbscD+Yizyzgb03ThuhxNth
JjWCi6k9twZ8g4zwYeissmMyFzvit9muizaCSt+DtIF8Lu7uz1njlGWE9hc6
rLm3XAQ1fN0X9tIIkrl6cvLqZfi39uhEnIIxCmyNQk9PlSGthrXLmjRGSPS6
K9OzZbhpnz0x02EM2wdjd9i/y1AhvH0o+Z0xBGSTX3oKl2OYT/bm40/GODj4
XvKwbDmU3M4ETk4bYxnHq9jQpBynfXwbbkmYwCc5oUcypxys7X1Vbk4moLV2
qj+0qMCFu6I6qj0mSLD5olRsV4HiWSbHrN8EI32z0rcOVUCo3NbpxIAJcibX
CcZ6VOB+Yah52pgJVkkcIR0vVuBtkZ5Oy78m+Hpk/Ph8SQU2p4yo3pQ2Rf6s
0LVdqyph6bM/hNfRFNLyGr8q2yrh0xnie7XVFF4xa0ssiWoU/bo0vi7GDOs7
Wjh53AfIEu/5Lap9ABHSvvQZ1RrMDDjesHp9ANanLw/0J9TinXdWwqUt5qh/
u/dVfcQjxB8yVipyNUfc+WAlN806TKVJyj5JNUeZPBEcOlSHJZLzTUOPqf8H
ZM/5vMdQd8ne1D9qjqvv/yKe29bjdRJ/Q99KBiyH/ZK+rm0Aa5LmNEgw4DlX
OprS0QCahWxxkQUD5clquyPDGvHzzheFUC8GStalZ9jseQIhOQUvbjgDfVt3
fz018wTq1lrmb64x4KHrvHvVracYbszOjytkIG/3ifRol2cYdZQ26nzEgNiL
kmGGaBPmR4flVNoYIPYN7Jlub0LftY4BuV4Gwo1sUwfDnmP6XtSeomEGaGZ6
n21ozbh2dNz/+QwDKXprtHImm3GCEfkqi5eJTbWKl3RvvQDP5+Fl1cJMuCsr
9Je5tWBH6zz3iigTQuk36QVyrSD4MntcpJh4G2958Wt7Kz54Gzwd3cCEA2eq
a0XSS/SOaDkc2MJEJPv4Ksi1YWVwhmz+ViZW5qeUlwW0QT/ZuPDYdiYm7LjO
1960gb1k7MvinUyMmk6HbVYjMbm0sXpYk4lct8bBku0kpsLnt89Tdj532VCH
IBHDLPlTZBcT7QW0pVY7SfiO5npspVz2ByclRJvEyzDxHG/KF5pm/uw2JEHr
likZp7za4EdtsguJ2pqfdiNaTLQ4Ptsg40pi++KYwTnK4X5pF/PdSBgWC3r/
oc3EbLb6vjp3EjdmatwUKffwBbSOeZMwkcrmcaec92j2g+FZEjbqPIMfKTu/
adLpCCRhYZ8m8I2y5Nermc5BJJ4pm0jx6DARI6Pp6h9MglkuSkhT9gk6M5wT
QcJ+W6CoPWWFVCPTbVEkErONf7pT7v9Lsqg6mkTBSfN3/pStuqvY7bFU/QOL
wi9TXjYd/fpgPIn2uRpGDuVnIg70oQQS89qV4qWUgzcqpfklkTDt//G6jrKm
1tzs72RqPuuDY9oo/xfH+Moq
     "]]}, 
   {Hue[0.39135954999579425`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt0nk01fkbB3BrythSJIRMkbKUvvcWld4U4hL3RiRlCSP7crtSUUSi7DLj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     "]]}, 
   {Hue[0.6274275274955841, 0.6, 0.6], LineBox[CompressedData["
1:eJwt03k01tsaB3CSIUMvQgppMGtAv1eS+FLmileIqCOZkszekoQi8zx0DZUi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     "]]}, 
   {Hue[0.8634955049953739, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Xk01VsbB3COpAwpIUNSIpGK+p1DKr4ZElLnGJIMyXBDMjulcCJzZpJO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     "]]}, 
   {Hue[0.09956348249516367, 0.6, 0.6], LineBox[CompressedData["
1:eJw103k0lWsbBnBTKZkayKFCIRlC3r1F6DJn3ttchqRNEpm2jZPMEhmyTRFF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     "]]}, 
   {Hue[0.3356314599949535, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Hk01VsfBnBjShmbZK7MTVy/cwyFB0mmnCMhQ6GDkyHzkRKZMs/DKxSu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     "]]}, 
   {Hue[0.5716994374947397, 0.6, 0.6], LineBox[CompressedData["
1:eJw11nk01VsfBnBjIqKihEJFcgn5nRMqHnOmnJAhQ+iIJLMjmTIlEhlSSUWk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     "]]}, 
   {Hue[0.8077674149945295, 0.6, 0.6], LineBox[CompressedData["
1:eJw11nk01VsbB3BDEh2RMlyKckmGivodheJrntI5GUIomZLMjlMKZUrm6RBS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     "]]}, 
   {Hue[0.04383539249432289, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hk01VsbB3CzFIWQ0CwqKfI7h06DL4XMxzxWnI5SyNBBIiJzMmdWRBmi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     "]]}, 
   {Hue[0.27990336999410914`, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hk01OsfB/AQSZbS5hLaLC1CfWdkiTdC9rGFUBJZUpimQcS1Zd8nZYyi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     "]]}, 
   {Hue[0.5159713474939025, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Xk01N//B3BrUirZQ6FEtEi9Z0LFE1HWsS9FpCmSvSFKiuxkmWTPEiER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     "]]}, 
   {Hue[0.7520393249936888, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hk01OsfB3BL2q6lhShF2pQobt8ZUnjbsoRphFR0NVEjZBsjJbLvCZNl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     "]]}, 
   {Hue[0.9881073024934821, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Xk01VsbB3BDKBENopQiMqRB/Y4xfE2Zj5u5qBBRkflIIvOcmepQEalc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     "]]}, 
   {Hue[0.22417527999326836`, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Xk0Vev/B3AzhZQoEaUyRCW1j6nkbYiO4XQTlYokQpkdU4rMQ6Y4VIeK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     "]]}, 
   {Hue[0.4602432574930617, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Qk0Vd8eB3BDMhYNZKj8GxAR/Tv3hsQXScbKkCmKKJV5uEgpU+YhJG6U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     "]]}, 
   {Hue[0.696311234992848, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Qk0ldv7B3BDpUFmMoVbhlREvefQKfoiyXBuESIpiTqV2UEKISLzFDmm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     "]]}, 
   {Hue[0.9323792124926413, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Qk0VV0bB/CQWUTSlaJBSTLVuZKivyHiuikRkpKhLpH5ChEi8zyEKKKB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     "]]}, 
   {Hue[0.16844718999242758`, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Xk0VXsbB/AQylAqdKKiJFFE7WO6pa/Z4ajIWOlSlIrMUxk6hszTMeWg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     "]]}, 
   {Hue[0.40451516749221383`, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Xk0VXv/B/BMSZG5hFAZojJkH8Ut3lEJx63MrnQlSkXmKbOIzMPJcOLm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     "]]}, 
   {Hue[0.6405831449920072, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Qk0VmsXB3BjEkkyEymSZMp5TUV/U4aXpExFUiFK5gzJmClkJmPGJlcT
UWlApgbkpSSVW4rCjUSSdPue967vrHXWWb911nnWefbez94yB312ubGxsLC8
ITfzaZpRJLxildY2lv8uCrbGvv4CQnaQ/L+jD/L5rhByR6xN3n+OaA/ru9Xm
jtl1U//55MYxDZegwygb9mZlOjTVrmCpvAcy0+TZmA761vL7+ksPnHVXYmc6
0E7twJ5ET5SYFXAw7ddwrpVV+wiUv6QuYdpbindD1dgRuBurczPtFROavKvg
KL6/vc3L9JHR0ckFcy/MyjquZPqwuc2uil9eKNc+IMK069XmOnr1MSyclJZm
+qCAitiskzdGxH9uYNolqOhk0XIfmLPspzG9b5D7ndEDHxR1vjBiWqnkblmQ
pi9SaN/tmd5k7d/3JM0XK/S9fJhWZFfglP7si9TP35OZ3lj3t0YA/OA64XWV
6Q2Hcz068vzQGfLwJdPyYpYFEtN+UP7Awc1KvP4pe6ePmT8MD9gaMi0b3vC7
pcwfOiK/Ephep+KnIrrgD+t+2wGm176XP+C1KwAvkj/R2IjXZA1lNlUFIHSt
aTnT0sY5rYLsgVB6oSvNTiz1gz7n4RiI49sqrjIteZltw/3aQHjfD9/FQSzh
eGfPSt7jqL/1jZeTWHy5b7Kb63HYOZi+Y1q0cf39O/eO49mHke4lxCJ+byeX
CwVh9Ta711zM/BSelu0JDMJQjeo6buLWNtrezOdB2BDQk72Muf7X92k2VDCs
M1kpXmJ/8dQ24exgJMq3c/ARPzbS+TUwEwx+QQsefuZ+fEZVC3eHQP/VNF2A
ODg/031fbQhKFoyeChJ3t+gVSa8KxXzkwhkRYrnJccZ7/1BIG87niTPrT/Qs
V2VvKFRydk6vJu4zMNR133wC05t1i2SY+Tk25b8h8wRYt2wskWPW89nCS+PT
J1Bzu/KPAvFAs8lQtXUYtDw9WpSJ44VLzdRWnoTHGu8UbeK3sIic8T2J4LuD
xduIqaPzN+t6TmJI8NvG7cTJOZXjwarhOKAnrGNJPNy4c41OejgEOwcZNsTa
44u2i1PhML8zMe9EnC54OfmBVQTYt/PUuxHrerL+MFgRCRZONb5Q4uysK5s4
fSJhmkG/dYp4/P6egx3dkXCUOyuQRmzB/WpUziQK5+R/LV4kDpG6xsoVHIUi
FUZBHXGFepzk5wtR4LjgtLSVeGGf2q6qJdHg5231/cCsvwCuY8ka0XCye31i
ltg68W2Cl3s0bFNEApawUrhUc/q+cns0Vp/lsFQift6xf2DFXDSyu3T1DIj/
vKHNfJWLgfanB1sdiO24hjfUxsXg7a3vUQnEMZK3DbPrYhCa79lfSnxFLdX5
+EgMhNoLHe4SczjpZGsan0KXbxvbLPGN65l/7nLEInL5myeBbBTetHmIF1Ox
qPvUfzCPeOlrPVqEayx8Xwa53yd25pw4gtZYqEsMPeNhp5Ak3hwnMxuLmndC
xjTiOpWzpWyycfB8Mm3kQsy717C/9VQcTAxt2e8Sa/mITZ+vjcPpQ1yMceJD
sVM8CR/iMDrx3ESSg0LD1UJ9M8N4eOgO7ogl9mCfre5iS4CX35UMT04KpQ2v
4mJUEiD5L7tVBfGAX6OzplMC+k523hgiNnuXxF9Wl4B5Vq7IvUtI/d2XCQz0
SERgfGy/OxfpR4Fclgo5iehLMtx/lbhA8YvcUHMiEqKSGn4QLyu4/dJE4jSs
Psn/m7aUwkSQ1RaJ7tPYwKtp9ZKb9AtlmmDPwmnsdNZkVV5GwWlE/EusfBJy
i25eiyfu3D16bjIqCdLOocJ6PBSqVcPZHqonQ93hW1YbLzm/41WPPfJTEB8u
5rOFn8KFsvTy1e0pOGVdJH+TeMghKKz3WwpcslvXq6ykYNWhr7TV4gw8Qxe4
NwlQUK0cSF/x5wxKWtX69QVJfBwfeLYqpuLHwy6NLuJSgUqDUIdUCIVY/rtX
iAJ/tM/s8I1UaKhLMsKFKUzvW+JQ75oGq2j7iXeiJD5C/6gezUhDo/bYWKQY
iU8ng3vNgzSY/9LzkhGn4Fnc/baVJx2f2wO4vSQovOIpSFN2S0fAoyC2NVIk
X59VZ1hFMxAysvwSpyz5vnWX9D9KGTjvre3xhHhZaSC93zADOjI9zRlyFPbY
366o8slAfV8MfYM8hfm2bTa7OzIwZyOzGLiRAq1iR11lUCbpw3XPUtVIPUb4
vk9NyURC+jG9iM0UYvdmLg8tz8SVjcZHfNXJ+VjZ72bZnYk+k79Y9tFIv4va
Jzwnl4U/4n577bUpXN/nFWzyIgsxigqGvfoUHLRTK9QmsuCqK2ozaUCBRej6
MwnWbIT1Xt663IjEu3NG/uumbMh8mcrfvZ3CpE7YQF5sNmzKsy6z0cn8EU3S
HlfPgcnRBZUJG5K/3ou/UjJzMfLRe+yfI2T+8XZc2lWVi50Q2xTvRebH9lFb
0Ye5OHHr6MRabwrFd2SvV0znwiMhatjdj/Sb0jLXhp1n8eNecItoCDm/3oVd
n/jyYNoU1ikbT+bjsrQSg+R8KPKHWr+rJPPC6KrF0op8dKy7+WvsAqn/8K6f
XQ35CGb0K/64RMFmmsdmz3g+Lv0uWS15hYL5QOJSX7MC7NrrZpBeR87fhRi/
Yq5CLGnNdZbpoCBoEGQ4f6oIg11WLh//IetZFD+TLyjCy3qRZ+pTFIrsWx3t
rxfhkl6DUfw0qf9jAoH1b4ow12dpQM2RfOVdrQykFSOvbiTo5h/SjyZHOadH
i3E2wtnIeBUNZwvsH42ZlcDpuHhPxVYazoQWXfjCVYa/WGSFFPJoWLiirDSz
qgxZUgqcQYU0eAw31c5Ll2Eyotek/RwNBvSRJnatMtw8I9Xke56GOUnl12Ie
ZZDN37jnSw0Nzk2NK7Y/KoPMwJ6lsd00qHJ9CDmXWI6+64vLpJZqoDdbgW7F
XYkVDiYl9bEaMDbLuiEpVIl2TYWjDYkauP17UWR8TSUOz3AKNado4Jx7z8dY
rUqsd15c7M/WgKdWcETD4Urst9gxJ3teAyxvWm/ItVdid1TdbtN2DSivcxFd
jDmPc3fmnpcv00TSjdyRS4sXwDVAC7Uv1ATf1G8XvfuXcarsaGhNixZ2T/Ev
Gt6pxmKAFpUorwNXfqmQuJhr6LI68zEnbQsC8zmP/y11A9teqygOLtGFCG+v
LlVQgwN2rJNqtXpYkybxY/1iLV597F35TAE4PaPTxAirQ6ps0jHhVfqodjCP
DZmtR69UqYvpv/qgdfdr3d99GzbDXGErXhtASk77952eOzhUMDto3WKIYymi
NTbUXVTfqnZJSzPC6hddQRfr7iGGr0lN08kYCVIBGnMqD9CY03k9fNV22IXk
jA6nN+K4EXsZx7XtaHm1va8loQkXTX3/rTMxQWpktKKbTjNcKlTOHXpkgno5
Kjp2rBlN88r+eTqmSL3HGIq8+BDC3f7RllWmyH99hXri0IJbHWJbFZaawWYi
MPOraCtG7PRl/jpkBq9ftV+yX7TiecTKi6o3zXArS00/Ma4NS6LiErp/mKFG
sqDI3qgdb90VZx5pm+Odkv7X43PtGJT5/VPezxxHt7noC5zvwNb9vCEq5ea4
qH+kIOngIyRWj64S7jWHUGfNhPWqxxDZ4rODvmAOymTU6HvvY6hterApXIaO
eHOH3E9xT1BhXd6234AO2g6DEXvaU6ROt346sZ+ObAORrZUzT1F711b9Yxgd
6xs3Jm8734nb1xrM72XR4bFJYbjerQtzgflp36vo4Coo0ahe2w3enGfLDjbS
8SrN5tTX3m40H4rXSeihwzFo9iV/5jMsrz/Eh/d0JPp7CmBtD1JPy8ubTtGx
sir7Vn1oD6z0ebbc/EXHtz11LoUDPfh4WZGvn8sCXyy/x8mrMXBMnHeMQ8AC
F9zaPtVsZkBlvpxPldglPMdMj2KA9f2ZNY7EvdW05baaDNidj+W+QVzPE5Qd
o8uAc+2Pr46rLBD1eK78rRkDI16Lq68KWkDQeL4x6yADe2LElIxELNDl9EhG
2pWBG4mHJr2I4wPzTlW5MbA5RaQ4h/hnhZZJswcDZhv/fjhKPMQW2j3pzcCC
9IBqoqgFLjb9fGMWxsDrwafFHWLk/wYe6704ycDNwxe0p4jFv+aXukQwIOHr
1yIsboEUaR3X4GgGFLIWSt2IfSNOTFQmMBAU2RrLJmEBhVxzS9XTDHw25stQ
IB6+In7tbhIDYh3JyTuJbd82+PeeYcA635B+jpjve9LzfWkMyDWk8rcRP+J1
1BhLJ+9pKq0TxNGyinmBmQzc9VdyF5C0gM7WXz//ZJH9DGbMaRH/DyGK0zA=

     "]]}, 
   {Hue[0.8766511224917934, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Xc01f8fB3AjqWwhUWgIKVT3CqmeRolLSfbICGla16rsK7K3rIyQfFVK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     "]]}, 
   {Hue[0.1127190999915868, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Xk4VO/7B/AQE5ElIvnYImSvGVvSO0uWSVpEkpIoRIPGiOyNbFkakjVk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     "]]}, 
   {Hue[0.34878707749137305`, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Qk0VO8bB3BLSEKFEqXlpxBC3bEVfbPPRGUrkpKoIWUfW2RE1ixjiUFS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     "]]}, 
   {Hue[0.5848550549911664, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1gk0FX0fB3BLoSQh2UklhFLNRZ7S1xb3ZinZKuQRpSI7CdmzlWvfZU+L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     "]]}, 
   {Hue[0.8209230324909527, 0.6, 0.6], LineBox[CompressedData["
1:eJw11nc0lv0fB3AjlJ2W6AlFS1Zdt1DpbcWNKNFQPBJSyMgs2Xvd3PbKjkTW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     "]]}, 
   {Hue[0.05699100999074602, 0.6, 0.6], LineBox[CompressedData["
1:eJw11gk0lPsbB/AsheykJIkKiaJ6B0n62mJERURFSbi69m0k2cZO2ddByJKk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     "]]}, 
   {Hue[0.2930589874905323, 0.6, 0.6], LineBox[CompressedData["
1:eJw11gk0Vd37B3AZUuYhkUKTIhl6O1ca6ItwrwYlRBN5EU3mK7NrniJjxkSX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     "]]}, 
   {Hue[0.5291269649903256, 0.6, 0.6], LineBox[CompressedData["
1:eJw11gk0lPv/B3AGyVJkX8pSSUUiz0gSb4TRopQtS1curlZLlkbZ1ygylsYg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     "]]}, 
   {Hue[0.7651949424901119, 0.6, 0.6], LineBox[CompressedData["
1:eJw11gk0VWsbB3CzIpmSqUsDUUTqHKTobzykSQi3SS4hZJ4zZp7nKUIOlQwZ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     "]]}, 
   {Hue[0.0012629199899052423`, 0.6, 0.6], LineBox[CompressedData["
1:eJw11nlYTP37B3BtorTQItWTUEKoONOGereO7FpUkpJKodVUon3f932RNllK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     "]]}, 
   {Hue[0.2373308974896915, 0.6, 0.6], LineBox[CompressedData["
1:eJw11nk0VW0bBvCiKDKFEkoUhYpqH0mGy3heoZHI0KtCKmXMVOSYhzKT4cgY
EZWkUEKmCDkqX4MolUpleMkrqb5n963vrLXXWb8/zrP3fq77ue8je8h1jyPX
nDlzvpKL/v4rgb1ESFRdZ86fDwULQzePxeL78H+zDgm6CYk7YZnA/+wS7Bez
J+M4RPfP++N1uz0et8e5YYO/0x8rVQ6oecIdhW+a/njNMrMMqXF3WIocm0tb
4SF3h6uxB0xvvf3j1QE1PxtzPbCKEcRFe5WKu4rEjAcyB5jctOXerDnosscT
rvEG82ivTOpPrC/xhGwraz5tGcOUJjFuL+SZCfDSXvGvyZSzjRe2PZ1aQFu6
mGttbYUXMLCLn7aUTfV+kUWnENKiKkhbUsAtxtHhFG42XBWhLVGnUFt99xTE
NIbEaS91fzUiIO6NTNMpSdonM6NWd3t54+NEgiztpmaGdeITb0j8G674Z/2x
N3HmlA/yRIQ20/aQjG1ekuyD4UXHtGm3GWj8eDbhg332r03+vI/rkGrmXl8U
NzTY0PZJT3Syq/DFozynk7S7GrXZMqJ+EBPeGEpbfmSY88bDDyuUYrJon5G4
wFvQ4weT3s81tB/r6Ws5bfJHvGhP3588Tox6rE30Rxe7nXsuneeFzMvD4/64
zXVClfazBmZ/6e7TmHpke5i2ypcJUdfy0zA8YJZFO3xJjvFGkTPw/DLTT/sV
TM9OuJ2B0M9NilzE1PHpm5XdZ2Dc2n2GdkxKwbCPagDefa95QXuwbtdKjfgA
ePCN6nMTbx2etZgdDUDPSddq2vFixTH3dgbCLdJacx7xkLZFQ9C1QEyaPOmk
rXV07r96QmcxvW2Z63zi5KSydfNdz8L1k4csD/Fw7f5DrV1nMSmoMUR75SRX
h8HSIOzgf3uPl9h04fMheWYQJprely4g9l1xbS6vTxB+3e0pX0icvzlM+mNh
EGZ9zR/x0fv9l82Wtt4gNCpJ8C4inrHbuKeEh4XZmA/WAnT9evKeiFFjQSg0
r0OQeHfkqwgXJxaiBdYfEKbzyKrIM0tl4bbSOZHFxJdvRNVuaGHBqZfzUZT4
Sevfz4SmWChykSYFRuF3H2NiTD4YOuPF/BLE+3gH11aEBcNC9uYzaeJg6Sr9
5MpgyG79HSpDXLYx9sCp98EQZokelqPzM3Lw2ycego/R4afkiefZaiRvMQyB
kwBf3Vo6T3fhaxKnQsBav0tvHbF1+FDb94IQ2LsIcKkSl19P/H1nXigkzvvp
qRP3NTtLZlGheP1Sqk2TeMFLbUagQyhkH/26oEt8YP7nY2gKhYccn5QpcbRk
Q5jsZCiajhQ/3U1cqXIhh2t1GJybzd9bEi+y1u9tCgnDmms6Io7E6q7Lxi9V
hEG+2IVyIT4cOsof8TYM7bkHajyJa65m6hrrhyOruH82hK6HRndbJc9wbNrW
XH+OWOQ504c/PxyTJ7imUoiduSdLO7ki0NaR1FhMnFPzPCxYJQJRaq5XKuj9
ca87sMU2AqsDtbnvERu/jhbOrYzA1u/eQk/o/b3g9sliMAJ1Da7tA/T9d+y7
zycUiTu37Lm+0OenVtbLyzkSYbo2U/PnUjjkxWummBIJ4QOC1aLEGcpf5fsb
IrGkRppHjpgvo+o/TKkohD2dZwbiz947t0l1RcGrgzUSQrx6A0OseyYKg1S1
Qyqx7XvJr6FromEWJscqJu7YO3RxJCgaOsaVNRziefwdPvll0XiisnBgiFjz
fvkuqxfROPru+e1Z4lLVAK77m2Pwe3JPihIXhXcfDr30to9B806VXD1i6ey/
biqfj0GnwrSrDfF5ATGnlKEYCIb1OsQRnxwuaXNOP4fiiniRudwUCnPj85a3
nENWQW6GDHG/lffpnn/OgYd9l1uHeGer7npN0/MYTsoPDSJWLXgWL/T7PGRe
bi0SnEfysLl3tEk5Fi/YIakUcc7iAj0/q1j0S34MtiEWZrlODpbHok88+GAp
8bgdj9UthzjwHpXKsJ5P9lv8i+rxhDgYZTzujSQ+1MFZuPJeHNjiJuuriI9m
db1q4o+H70MfhiQPhef8GXEbHONh6d8m9oW45qPqxFyJBDiWbRZtX0B+37RH
5sv6BJw+MKrNt5Dkk+Nl0qufAO4tH8pMiPdbVuWXuCbgt9T0wR7i6WYd872t
CajTyfYZ5SPPn3swSOtVAq5nZS/W4KfADAgpXTORgNFffAvDiVOp1nmzKxJx
MP+dqNwiCoz8HZUF3ongYZqNHxMg5ynQ7U3suUSsrVlXVU8cap0o4JeXiIfR
+8eXCpJ+INLraNaViG/T55rbiT2C7JZMySfhTeQ26AlTuG7n4sN8mgTr3n87
/EUpWG2Nzd/4OQlawUZTH4nniF9/JDU3GS1T9nesxEg+HRNrxtYlgx21U05L
nMKIxulnaaHJGBdXLli2lIKyRPTW4c0paNBb6bVKikLPxBXHJ8YpmArKOl5K
7P+oM+He3ynoFHOX2yJNoT1cZDgxJgWqfD+e7l5O8v2WlrHtbQqO8NTEsGVI
vfQU/TiXmArtxhcvIldTcFjUenlPSSqU/p7o1pQn89toyELifiq4r6RO/0Oc
Vb36ev54KtT9s945riH9PCfXoWbXBfAo5hxxUiLn8WRm5wfBNLgWLe16rEoB
l2v8yxTSYDNg0nplI4Vfb56v8dROg8JtVeHwTRT8LCSCf51Ig+CS+gu6FAU3
zRQ18c40pM8EXn6yhYIdX1y2Xkw6zvYUSrnokHlvcNV0QX46BlbZNh0F6Q8B
nd87a9KxnCf/8VFdCubj/Ob7h9PB/PhdyV2fwvZnkQvcjDOg8/FIH5tJ+ldh
sHsWbyY4gV2Mo7soiOl560+HsDHQ7vf15WGynmnWozUZbKSZafEsdqTAtmyy
sbzOhpVWi9l2J3L+Tyz2utXHRrBGyLEGZ1IvaVcLvBhZqIqSf9d2gvT/kaH5
40NZMLNTXmngS+FChuWDT8bZUHnCUByIJf3iUqD5Mvts7BwfTrWJJ/Pu+qXX
f3lnI8zYcOuLBDJvmiemi/KyMcvOl+pPplA1Fqfo9CMb++4vt5iTSf6/rXIw
dN+Xg2+Os1FXi0g/8GMXfuXNRYSY04vr98m8K9uwfkI0F5V9yp7pTSTvwfqK
aZlcGJfsZoe2UNAzeV/PrZ6Lwl9bLh5qpzAlveHlMudc5JnWm2v1kPlQXydk
9CAX4U2ey08Mkv7A+9b3YmQeKhKytt+Yx0BPsqLJzoUFKCwcP1S2iwFD46Ry
afECVCpzsxT3MlD1c3bp8MoCdL+587XIgoGLTt3vQtUL0PG09NoVawaOqvsE
1hwpQGaRSG2XAwNz+prK5VsKMFobvy3Yj4ENq+wlZoMvwXv0Q0xaAQPR5anv
L88WYsPxLpEdc9UgOPrTXru2GKf88uwWN6lh76jwrH51Kcwjp1+uuLkFDsIr
fMOCr6FY3nF5xxV1eKXPPzWwohzHVrCD88q3YumiHi0q4waCfI4ojg9oYGWc
1L8KsxWg2vqawxZoImpCo55zuhITh+VTdSy1UGq1PdR38hY2z7i//16iDUZX
r3rt3iqwDBulPo/oYIX81p/V3dWYSZSYaC0ETpyTuGFO3YFLSJbODwNdLH/a
6V1UeRcRuy8fOzCki4gVnmpTKvfwWKW1OstXD/t8U4YG4+sgJj/dmfFND43P
jR43RtTjpJ7EVJ+bPmLPspQdNRowMZMmsOC5Pm7JU6zQTw1g7a6+UsAwQOxd
Tv/Zovt4IX6TbR5vgPSXZVS7VSMUXkyuTekzgPlnr8QxiSbspsy9vikYwuVH
xdfkp02oUlJ76eJsiNtJG3Ujw5rxusGk0znbEDekM9iWBi34GaW5UeSpIV6v
1x07NdWCjN8twpJcRjiuY6+7+FIrDqYe/DSjaIQi3WMZ0YceIMd2i9D4LiOI
d9z4vFu0DWbLHwZccjcCxRwy+NbTBl3rroURCUYI326V+iGsHTNrbe8blRqB
sUPvvSXjIT7eHjs/0WiEZL2lmgUTD5GXM3ZD6KURFOqUYnQudWDz+plOrxEj
OK9THLzl2AmVVOkqq7lM8GZkq5XKdaFcfiD1mwgTz+PMQ8Z6uvC7pKLpgwwT
Nt6T/xFOfISR1txO1nomIj2OLoZcN+5J+l78rM6ESEny7Vt+3Uh29THh0Wfi
n/2V9pnPurGZezThnSkTX82+ha3ZyAFjVO3HOgsmCh2bP9zYxEGSaqnoLmL7
gBRjbYqDk8qy0p7EPaUMAYstHORg7c8q4lv83snBWhwsij0zx2AfE0FtU3mv
jDl4F9Oy2NKSCTHD6bqkQxwwPZQuuO9notP2gayMAwdsm6TaROJwr7SQEkcO
JMT6n1QQf89XZzY4c7DUlOr9RtzP5dc1cpIDcZP81X7WTBTVf+8zPs2BjXTE
1Bkb8nzP2rSfnuHgi7fuhixiybH0HPtADgZ5TCxric/JaDj4sDiIWHkk4Cex
W6D/54IIDi6VBUsG2DKhmLrdTDWKAx0F71ds4sEyyWt3osn6EaMJd4ktXtV4
9Jzn4LJt3KMfxILfop/YxZH3D2i0krJj4sEiG7VP8RyUvE57rEHMWq2c5pXI
wVrbJbAm1tD88f13EgdBLXoX/Yj/C+/cVCY=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
  AxesOrigin->{0, 20.},
  GridLines->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.69432417471875*^9, {3.6943246234375*^9, 3.694324651390625*^9}, 
   3.6943248529375*^9, 3.69432492740625*^9, {3.694326083375*^9, 
   3.694326112234375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Thlinik", "=", 
   RowBox[{"First", "[", 
    RowBox[{"nezname", "/.", "res"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"nezname", "/.", "res"}], "]"}], "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"To", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68344070834375*^9, 3.6834407454375*^9}, {
  3.683440788984375*^9, 3.683440823859375*^9}, {3.683441494578125*^9, 
  3.68344150990625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Large], LineBox[CompressedData["
1:eJwV03k41PsXB3BXiqLINbeStJEWWoeQ5Y1IpFLmi6uFsVyiSKI9WSJFMlI0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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
  AxesOrigin->{20, 0},
  GridLines->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.694324174859375*^9, {3.694324623515625*^9, 3.69432465146875*^9}, 
   3.694324853015625*^9, 3.694324927484375*^9, {3.6943260835625*^9, 
   3.694326112296875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"int", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thlinik", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "5256", ",", "10"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"Quiet", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"Round", "@", 
         RowBox[{"int", "[", "#", "]"}]}]}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"25", ",", "90", ",", "5"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"obr", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"d1", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<T[\[Degree]C]\>\"", ",", "\"\<t[s]\>\""}], "}"}]}], "]"}],
     ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.683441569484375*^9, 3.683441603421875*^9}, {
  3.683441644109375*^9, 3.6834417315*^9}, {3.683441763484375*^9, 
  3.683441770109375*^9}, {3.683441980859375*^9, 3.6834420988125*^9}, {
  3.683444242328125*^9, 3.683444243765625*^9}, {3.694326029859375*^9, 
  3.694326032359375*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"T[\[Degree]C]\"\>", "\<\"t[s]\"\>"},
    {"25", "289"},
    {"30", "602"},
    {"35", "934"},
    {"40", "1280"},
    {"45", "1640"},
    {"50", "2012"},
    {"55", "2397"},
    {"60", "2792"},
    {"65", "3199"},
    {"70", "3616"},
    {"75", "4042"},
    {"80", "4479"},
    {"85", "4925"},
    {"90", "5380"}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.6943241749375*^9, {3.69432462353125*^9, 3.6943246515*^9}, 
   3.694324853046875*^9, 3.6943249275*^9, 3.69432603328125*^9, {
   3.694326083578125*^9, 3.69432611234375*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<tab.png\>\"", ",", "obr"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.683444247359375*^9, 3.683444284265625*^9}}],

Cell[CellGroupData[{

Cell[BoxData["Pmax"], "Input",
 CellChangeTimes->{{3.694326363375*^9, 3.69432636390625*^9}}],

Cell[BoxData["2875.`"], "Output",
 CellChangeTimes->{3.694326364296875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"P", "/.", "res"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<P[W]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Magenta", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.694326490546875*^9, 3.694326547921875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 1], Thickness[Large], LineBox[CompressedData["
1:eJxFzgk01IsXB3BZUhKe0iJRXiUPrxQlz/ItJYVW/e1lLxVF1pnsNHYzxhPy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"P[W]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  GridLines->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.694326510578125*^9, 3.694326548125*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
},
WindowSize->{1042, 694},
WindowMargins->{{18, Automatic}, {Automatic, 11}},
ShowSelection->True,
Magnification->1.3999992609024048`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 4929, 127, 801, "Input"],
Cell[CellGroupData[{
Cell[5511, 151, 5392, 161, 615, "Input"],
Cell[10906, 314, 201789, 3378, 343, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212732, 3697, 985, 25, 91, "Input"],
Cell[213720, 3724, 3920, 71, 343, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217677, 3800, 1283, 37, 91, "Input"],
Cell[218963, 3839, 738, 25, 354, "Output"]
}, Open  ]],
Cell[219716, 3867, 190, 4, 40, "Input"],
Cell[CellGroupData[{
Cell[219931, 3875, 92, 1, 40, "Input"],
Cell[220026, 3878, 75, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220138, 3884, 671, 17, 66, "Input"],
Cell[220812, 3903, 7636, 133, 334, 3623, 66, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
