(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12898,        328]
NotebookOptionsPosition[     12349,        306]
NotebookOutlinePosition[     12751,        323]
CellTagsIndexPosition[     12708,        320]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7208615645625*^9, 3.7208615731875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"57", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"1", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sk", "=", 
   RowBox[{"Pi", "*", 
    FractionBox[
     SuperscriptBox["d", "2"], "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "=", 
   FractionBox["i", "Sk"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ee", "=", 
   FractionBox["J", "\[Gamma]"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qv", "=", 
   RowBox[{"Ee", "*", "J"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pout", "=", 
   RowBox[{
    RowBox[{"\[Alpha]", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"T", "[", "x", "]"}], "-", "To"}], ")"}]}], "+", 
    RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"T", "[", "x", "]"}], "+", "273"}], ")"}], "4"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"To", "+", "273"}], ")"}], "4"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvOut", "=", 
   RowBox[{"Pout", "*", 
    FractionBox[
     RowBox[{"Pi", "*", "d"}], "Sk"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvCelk", "=", 
   RowBox[{
    RowBox[{"-", "Qv"}], "+", "Pout"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delka", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{"\[Lambda]", "*", 
     RowBox[{
      RowBox[{"T", "''"}], "[", "x", "]"}]}], "\[Equal]", "QvCelk"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eqn", ",", 
        RowBox[{
         RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT"}]}], "}"}], 
      ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"endValue", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"T", "[", "delka", "]"}], "/.", 
    RowBox[{"sol", "[", "derT", "]"}]}]}], ";"}], "\n", 
 RowBox[{"dder", "=", 
  RowBox[{"der", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"endValue", "[", "der", "]"}], "==", "To"}], ",", 
     RowBox[{"{", 
      RowBox[{"der", ",", "100"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"sol", "[", "dder", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "pom"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
  3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
  3.7208620900625*^9}, {3.720862139265625*^9, 3.720862742015625*^9}, {
  3.72093376590625*^9, 3.72093377*^9}, {3.720933950390625*^9, 
  3.72093398778125*^9}, {3.72093401853125*^9, 3.720934032234375*^9}}],

Cell[BoxData["1732.7165006537518`"], "Output",
 CellChangeTimes->{{3.720933951796875*^9, 3.720933988296875*^9}, {
  3.7209340190625*^9, 3.720934032484375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2HlcDV8bAPA2RGkTKZHQgiiKUN3nKEu0KGmVSoXQrihp32dSIQmVKEtC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {0., 878.6300331684271}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.720933951796875*^9, 3.720933988296875*^9}, {
  3.7209340190625*^9, 3.7209340325*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_Integer", "]"}], ":=", "\"\<dort\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], ":=", "\"\<rohlik\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", "\"\<vetrnik\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", "<", "5"}], "&"}], ")"}]}], "]"}], ":=", 
   "\"\<marokanka\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"f", "[", "0", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.720933419796875*^9, 3.720933490359375*^9}, {
  3.72093353821875*^9, 3.7209336676875*^9}}],

Cell[BoxData[
 RowBox[{"NumericQ", "[", "Pi", "]"}]], "Input",
 CellChangeTimes->{{3.720933492578125*^9, 3.720933525640625*^9}}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->2.3499999046325684`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 517, 15, 184, "Input"],
Cell[CellGroupData[{
Cell[1087, 39, 4019, 121, 1273, "Input"],
Cell[5109, 162, 159, 2, 95, "Output"],
Cell[5271, 166, 6056, 105, 578, "Output"]
}, Open  ]],
Cell[11342, 274, 872, 26, 330, "Input"],
Cell[12217, 302, 128, 2, 95, "Input"]
}
]
*)

(* End of internal cache information *)
