(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22625,        669]
NotebookOptionsPosition[     21712,        639]
NotebookOutlinePosition[     22113,        656]
CellTagsIndexPosition[     22070,        653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 3.676092822828125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", "*", "x"}], "+", 
        RowBox[{"b", "*", "y"}]}], "\[Equal]", "p1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "*", "x"}], "+", 
        RowBox[{"d", "*", "y"}]}], "\[Equal]", "p2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.676097044546875*^9, 3.67609706796875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"5", "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMat1", "=", 
   RowBox[{"Det", "[", "mat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<determinant= \>\"", ",", "detMat1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.676092443*^9, 3.676092455296875*^9}, {
  3.676092486734375*^9, 3.676092564375*^9}, {3.6760926228125*^9, 
  3.676092638515625*^9}, {3.6760962355*^9, 3.676096249375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "mat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"odhadMaxDet", "=", 
     RowBox[{
      SqrtBox[
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         RowBox[{"i", "=", "1"}], "n"], 
        RowBox[{"(", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"j", "=", "1"}], "n"], 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"mat1", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}], "2"]}], ")"}]}]], 
      "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<maximalni hodnota determinantu: \>\"", ",", "odhadMaxDet"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.676095958703125*^9, {3.67609601296875*^9, 3.676096018296875*^9}, {
   3.67609606778125*^9, 3.676096231953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"detMat2", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.67609263334375*^9, 3.6760926529375*^9}, {
  3.676092730828125*^9, 3.67609274709375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"invEps", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"Inverse", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"invEps", "[", "\[Epsilon]", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.676092752921875*^9, 3.676092835140625*^9}}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"LinearSolve", "::", "\"\<luc\>\""}], ",", 
   RowBox[{"RowReduce", "::", "\"\<luc\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"mat2", "[", 
     FractionBox[
      RowBox[{"-", "1"}], 
      RowBox[{"68", "-", 
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]]}]], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xPresne", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solSol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"A", ".", 
        RowBox[{"(", 
         RowBox[{"xvect", "=", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", "#"], "&"}], "/@", 
           RowBox[{"Range", "[", "n", "]"}]}]}], ")"}]}], "\[Equal]", "b"}], 
      "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"errVect1", "=", 
  RowBox[{
   RowBox[{"A", ".", "xPresne"}], "-", "b"}]}], "\[IndentingNewLine]", 
 RowBox[{"errVect2", "=", 
  RowBox[{
   RowBox[{"A", ".", 
    RowBox[{"(", 
     RowBox[{"xvect", "/.", "solSol"}], ")"}]}], "-", 
   "b"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6760977475*^9, 3.676098134625*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"prosta", " ", "iterace"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "=", ".025"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{
      RowBox[{"k", "*", 
       RowBox[{"(", GridBox[{
          {"20", "3", "4"},
          {"3", "44", "5"},
          {"1", "2", "50"}
         }], ")"}]}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"k", "*", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Norm", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], 
         ")"}]}], ")"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.67609936765625*^9, 3.67609937503125*^9}, {
   3.6761003179375*^9, 3.676100349453125*^9}, {3.676101115875*^9, 
   3.676101202046875*^9}, {3.676269990734375*^9, 3.676270011984375*^9}, {
   3.67627087578125*^9, 3.676270967140625*^9}, {3.676271000078125*^9, 
   3.676271025171875*^9}, 3.676271086921875*^9, {3.676273503703125*^9, 
   3.67627350975*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Jacobi", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", 
          RowBox[{"3", "+", "I"}], "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LinearSolve", "[", 
     RowBox[{"Aorig", ",", "borig"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Norm", "/@", "%"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.676105032961247*^9, 3.676105075961247*^9}, {
   3.676105114054997*^9, 3.676105206804997*^9}, {3.676105245633122*^9, 
   3.676105245883122*^9}, {3.676105350539372*^9, 3.676105397804997*^9}, {
   3.676105497039372*^9, 3.676105542664372*^9}, 3.676269892203125*^9, {
   3.676270187109375*^9, 3.676270188421875*^9}, {3.676270266546875*^9, 
   3.676270275953125*^9}, {3.67627043290625*^9, 3.6762704591875*^9}, {
   3.67627069090625*^9, 3.67627069184375*^9}, {3.67627073290625*^9, 
   3.676270769328125*^9}, {3.676270799515625*^9, 3.67627080465625*^9}, {
   3.676270842046875*^9, 3.6762708435*^9}, {3.676271017640625*^9, 
   3.676271084125*^9}, 3.67627133303125*^9, {3.6762713951875*^9, 
   3.676271416734375*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.676270323859375*^9, 3.676270328109375*^9}, 
   3.6762704955*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Seidel", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", "3", "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "x_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xn", ",", "xp"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"xn", "=", "x"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"xp", "=", 
            RowBox[{
             RowBox[{"Cmat", ".", "xn"}], "+", "b"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", 
            RowBox[{"xp", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "xn"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Norm", "/@", "%"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.676271376046875*^9, 3.6762713814375*^9}, 
   3.676271424046875*^9, {3.676273062046875*^9, 3.6762730915*^9}, {
   3.676273151359375*^9, 3.67627315178125*^9}, {3.676273268609375*^9, 
   3.676273317328125*^9}, {3.67627336390625*^9, 3.676273495640625*^9}, 
   3.67739442165625*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "podivejme", " ", "se", " ", "pomoci", " ", "experimentalni", " ", 
    "matematiky", " ", "na", " ", "vlastni", " ", "cisla", " ", "matic"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "aijMax"}], ",", "aijMax"}], "}"}], "]"}], "&"}], 
        "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "rnm"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{
      RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Abs", "/@", "lambdas"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"vectors", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "dejSouradniceVBaziEigenvectors", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eqns", ",", "lambdas", ",", "\[Lambda]"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lambdas", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "rnm", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"lambdas", "/.", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"lambdas", ".", "vectors"}], "\[Equal]", "vect"}], 
             "]"}], ",", "lambdas"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"dejSouradniceVBaziEigenvectors", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.684507384390625*^9, 3.68450773*^9}, {
   3.68450779615625*^9, 3.684507854296875*^9}, {3.68450790325*^9, 
   3.6845079044375*^9}, {3.684508081984375*^9, 3.684508368984375*^9}, 
   3.684508414421875*^9, {3.6845084795625*^9, 3.68450851825*^9}, {
   3.68450857453125*^9, 3.684508605921875*^9}, {3.684508672890625*^9, 
   3.6845087789375*^9}, {3.68450897421875*^9, 3.684509153671875*^9}, {
   3.684509196234375*^9, 3.684509237*^9}, {3.684509268375*^9, 
   3.68450931365625*^9}, {3.68450934990625*^9, 3.68450942665625*^9}, {
   3.68450971296875*^9, 3.684509714515625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vect", "=", 
   RowBox[{"{", 
    RowBox[{"0.256", ",", 
     RowBox[{"2", "-", "I"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect", "]"}], "[", 
     RowBox[{"[", "#", "]"}], "]"}], "*", 
    RowBox[{"vectors", "[", 
     RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", 
  RowBox[{"Range", "[", "rnm", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Chop", "/@", 
  RowBox[{"Plus", "@@", "%"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", "vect"}]}], "Input",
 CellChangeTimes->{{3.68450947375*^9, 3.684509501859375*^9}, {
  3.684509542625*^9, 3.684509641359375*^9}}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.6845118365*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]AbsMax", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "/@", "lambdas"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ratio", "[", 
     RowBox[{"exp_Integer", ",", "vect_List"}], "]"}], ":=", 
    FractionBox[
     RowBox[{"Norm", "@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"MatrixPower", "[", 
          RowBox[{"A", ",", "exp"}], "]"}], ".", "vect"}], "//", "N"}], 
       ")"}]}], 
     RowBox[{
      SuperscriptBox["\[Lambda]AbsMax", "exp"], "*", 
      RowBox[{"Norm", "[", "vect", "]"}]}]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"upravit", ",", " ", "opravit"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ratio", "[", 
  RowBox[{"17", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.684511345484375*^9, 3.684511406640625*^9}, {
  3.68451144090625*^9, 3.68451158309375*^9}, {3.684511613421875*^9, 
  3.684511637609375*^9}, {3.68451176071875*^9, 3.684511765421875*^9}, {
  3.684511799625*^9, 3.684511828953125*^9}, {3.68451190390625*^9, 
  3.68451192446875*^9}, {3.684570222828125*^9, 3.684570300265625*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"en", ".", "wikipedia", ".", "org"}], "/", "wiki"}], "/", 
     "Square_root"}], "_of", "_a", "_matrix"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.68457101390625*^9, 3.684571016109375*^9}}]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 522, 14, 131, "Input"],
Cell[1070, 36, 527, 16, 75, "Input"],
Cell[1600, 54, 631, 16, 178, "Input"],
Cell[2234, 72, 987, 28, 198, "Input"],
Cell[3224, 102, 539, 15, 150, "Input"],
Cell[3766, 119, 358, 9, 75, "Input"],
Cell[4127, 130, 1487, 46, 275, "Input"],
Cell[5617, 178, 2487, 70, 439, "Input"],
Cell[8107, 250, 3772, 107, 565, "Input"],
Cell[11882, 359, 113, 2, 46, "Input"],
Cell[11998, 363, 3955, 117, 761, "Input"],
Cell[15956, 482, 3382, 86, 551, "Input"],
Cell[19341, 570, 732, 20, 131, "Input"],
Cell[20076, 592, 82, 1, 75, "Input"],
Cell[20161, 595, 1225, 31, 166, "Input"],
Cell[21389, 628, 319, 9, 46, "Input"]
}
]
*)

(* End of internal cache information *)
