(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      5080,        166]
NotebookOptionsPosition[      4568,        145]
NotebookOutlinePosition[      4953,        162]
CellTagsIndexPosition[      4910,        159]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"mocnina", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mocnina", "[", 
    RowBox[{"matrix_", ",", "1"}], "]"}], ":=", "matrix"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mocnina", "[", 
    RowBox[{"matrix_", ",", "n_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"mocnina", "[", 
     RowBox[{"matrix", ",", "n"}], "]"}], "=", 
    RowBox[{"matrix", ".", 
     RowBox[{"mocnina", "[", 
      RowBox[{"matrix", ",", 
       RowBox[{"n", "-", "1"}]}], "]"}]}]}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rad", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rad"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rad"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[
 RowBox[{"Eigensystem", "[", "mat", "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{"mocnina2", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mocnina2", "[", 
    RowBox[{"matrix_", ",", "pow_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"vlsys", "=", 
        RowBox[{"Eigensystem", "[", "matrix", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"lambdavect", "=", 
        RowBox[{"vlsys", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"umat", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{"vlsys", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"bmat", "=", 
        RowBox[{"Inverse", "[", "umat", "]"}]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Transpose", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"lambdavect", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "pow"], "*", 
           RowBox[{
            RowBox[{"Transpose", "[", "umat", "]"}], "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "rad"}], "}"}]}], "]"}], "]"}], ")"}], ".", 
      "bmat"}]}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"moc", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mocnina", "[", 
  RowBox[{"mat", ",", "moc"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"mocnina2", "[", 
  RowBox[{"mat", ",", "moc"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"mocnina2", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mocnina2", "[", 
    RowBox[{"matrix_", ",", "pow_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vlsys", ",", "lambdavect", ",", "umat", ",", "bmat"}], "}"}], 
     ",", 
     RowBox[{
      RowBox[{"vlsys", "=", 
       RowBox[{"Eigensystem", "[", "matrix", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"lambdavect", "=", 
       RowBox[{"vlsys", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"umat", "=", 
       RowBox[{"Transpose", "[", 
        RowBox[{"vlsys", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"bmat", "=", 
       RowBox[{"Inverse", "[", "umat", "]"}]}], ";", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Transpose", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"lambdavect", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "pow"], "*", 
            RowBox[{
             RowBox[{"Transpose", "[", "umat", "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "rad"}], "}"}]}], "]"}], "]"}], ")"}], ".", 
       "bmat"}]}]}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "Module"}]], "Input"]
},
WindowSize->{733, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 550, 17, 102, "Input"],
Cell[1110, 39, 376, 12, 80, "Input"],
Cell[1489, 53, 66, 1, 35, "Input"],
Cell[1558, 56, 1308, 36, 168, "Input"],
Cell[2869, 94, 248, 6, 80, "Input"],
Cell[3120, 102, 1392, 38, 212, "Input"],
Cell[4515, 142, 49, 1, 35, "Input"]
}
]
*)

(* End of internal cache information *)

