(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8452,        256]
NotebookOptionsPosition[      8019,        238]
NotebookOutlinePosition[      8420,        255]
CellTagsIndexPosition[      8377,        252]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
   3.676092820640625*^9, 3.676092822828125*^9}, 3.6845844423125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqn", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{"-", 
      RowBox[{"u", "[", "t", "]"}]}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Ordinary", " ", "differential", " ", "equation"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"init", "=", 
    RowBox[{
     RowBox[{"u", "[", "0", "]"}], "\[Equal]", "u0"}]}], ";", 
   RowBox[{"(*", 
    RowBox[{"initial", " ", "condition"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eqn", ",", "init"}], "}"}], ",", 
     RowBox[{"u", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  RowBox[{"(*", 
   RowBox[{"gives", " ", "analytical", " ", "solution"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], 
  RowBox[{"(*", 
   RowBox[{"desired", " ", "alanylical", " ", "expression"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]], " ", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "exponential", " ", "function", " ", "is", " ", "usually", " ", 
     "implemented"}], ",", " ", 
    RowBox[{
    "but", " ", "\"\<contains\>\"", " ", "infinite", " ", "algorithm", " ", 
     "for", " ", "exact", " ", "solution"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"another", " ", 
     RowBox[{"way", ":", " ", 
      RowBox[{"tables", " ", "of", " ", "values", " ", 
       RowBox[{"Exp", "[", "ti", "]"}], " ", "and", " ", "interpolation", " ", 
       RowBox[{"(", 
        RowBox[{"saves", " ", "the", " ", "computational", " ", "time"}], 
        ")"}]}]}]}], ",", " ", 
    RowBox[{
    "but", " ", "the", " ", "solution", " ", "is", " ", "no", " ", "longer", 
     " ", 
     RowBox[{"exact", "!"}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotExactSol", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"sol", "/.", 
      RowBox[{"u0", "\[Rule]", "1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\<u [V]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.684584456765625*^9, 3.684584592671875*^9}, {
  3.684584625359375*^9, 3.684584850265625*^9}, {3.6845853723125*^9, 
  3.684585428515625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "method"}], ",", " ", 
    RowBox[{"real", " ", "numbers"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "10000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{
      FractionBox["tmax", "n"], "//", "N"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"Real", " ", "number"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"nextPoint", "[", 
      RowBox[{"point", ":", 
       RowBox[{"{", 
        RowBox[{"t_", ",", "u_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
       RowBox[{"u", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "u"}], ")"}], "*", "\[CapitalDelta]t"}]}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initialPoint", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
       "a", " ", "particular", " ", "inital", " ", "state", " ", "t"}], "=", 
       "0"}], ",", " ", 
      RowBox[{"u", "=", "1"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"elapsedTime", ",", "sol"}], "}"}], "=", 
     RowBox[{"Timing", "@", 
      RowBox[{"NestList", "[", 
       RowBox[{"nextPoint", ",", "initialPoint", ",", "n"}], "]"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<elapsedTime= \>\"", ",", "elapsedTime", ",", "\"\< s\>\""}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotExactSol", ",", 
     RowBox[{"ListPlot", "[", "sol", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.68458487703125*^9, 3.6845849908125*^9}, {
  3.6845850875625*^9, 3.68458534371875*^9}, {3.68458543346875*^9, 
  3.684585504421875*^9}, {3.684585563328125*^9, 3.68458556365625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "1"}], ";", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "methpd"}], ",", " ", 
    RowBox[{
     RowBox[{"fractions", "..."}], " ", "see", " ", "rapidly", " ", 
     "inreasing", " ", "elapsed", " ", "time", " ", "with", " ", "increasing",
      " ", "n"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"n", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["tmax", "n"]}], ";", 
  RowBox[{"(*", "fraction", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"nextPoint", "[", 
    RowBox[{"point", ":", 
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{"u", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "u"}], ")"}], "*", "\[CapitalDelta]t"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialPoint", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "particular", " ", "inital", " ", "state", " ", "t"}], 
     "=", "0"}], ",", " ", 
    RowBox[{"u", "=", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"elapsedTime", ",", "sol"}], "}"}], "=", 
   RowBox[{"Timing", "@", 
    RowBox[{"NestList", "[", 
     RowBox[{"nextPoint", ",", "initialPoint", ",", "n"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<elapsedTime= \>\"", ",", "elapsedTime", ",", "\"\< s\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plotExactSol", ",", 
   RowBox[{"ListPlot", "[", "sol", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{"sol", ",", "10"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"fractions", "..."}], " ", "worse", " ", "and", " ", "worse", " ",
     "fractions"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.684585514484375*^9, 3.68458554715625*^9}, {
  3.684585587*^9, 3.684585627953125*^9}, {3.684585658546875*^9, 
  3.684585692296875*^9}}]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 488, 12, 131, "Input"],
Cell[1036, 34, 2719, 79, 330, "Input"],
Cell[3758, 115, 2079, 58, 329, "Input"],
Cell[5840, 175, 2175, 61, 329, "Input"]
}
]
*)

(* End of internal cache information *)
