(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6562,        202]
NotebookOptionsPosition[      6135,        184]
NotebookOutlinePosition[      6536,        201]
CellTagsIndexPosition[      6493,        198]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"soly", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "-", "y"}], ")"}], "*", "Pr", "*", "Ps"}], "\[Equal]", 
      "y"}], ",", "y"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.75358392059375*^9, 3.753583959*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"example1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ps", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        RowBox[{"\[Tau]1", "*", "s"}]}]]}], ",", 
     RowBox[{"Pr", "\[Rule]", 
      RowBox[{
       RowBox[{"kD", "*", "s"}], "+", "kP", "+", 
       FractionBox["kI", "s"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"trf1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"y", "/.", "soly"}], "/.", "example1"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7535839791875*^9, 3.75358406746875*^9}, {
   3.753584117234375*^9, 3.7535841200625*^9}, 3.753584197671875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outLaplace", "=", 
   RowBox[{"trf1", "/.", 
    RowBox[{"(", 
     RowBox[{"values", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Tau]1", "\[Rule]", "1"}], ",", 
        RowBox[{"kP", "\[Rule]", "5"}], ",", 
        RowBox[{"kD", "\[Rule]", "0.5"}], ",", 
        RowBox[{"kI", "\[Rule]", "2"}], ",", 
        RowBox[{"u", "\[Rule]", 
         FractionBox["1", "s"]}]}], "}"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outTimeDomain", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{"outLaplace", ",", "s", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outP", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", "kP"}], "/.", "values"}], ",", "s", ",", 
     "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outI", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", 
       FractionBox["kI", "s"]}], "/.", "values"}], ",", "s", ",", "t"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outD", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", "kD", "*", "s"}], "/.", "values"}], ",", "s",
      ",", "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"popis", "=", 
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"values", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", "a", "]"}], "<>", "\"\< = \>\"", "<>", 
      RowBox[{"ToString", "[", "b", "]"}], "<>", "\"\< \>\""}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pla", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outTimeDomain", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\< \!\(\*
StyleBox[\"outReal\",
FontColor->RGBColor[1, 0, 0]]\) outDesired\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "popis"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plb", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outP", ",", "outI", ",", "outD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Magenta", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\<outsReg\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"outP\",
FontColor->RGBColor[0, 0, 1]]\) outI \!\(\*
StyleBox[\"outD\",
FontColor->RGBColor[1, 0, 1]]\)\>\"", "<>", "\"\<\\n\>\"", "<>", 
       "popis"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{"{", 
   RowBox[{"pla", ",", "plb"}], "}"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753584141578125*^9, 3.753584316*^9}, {
   3.75358436790625*^9, 3.75358462721875*^9}, {3.753584668453125*^9, 
   3.75358475271875*^9}, {3.75358499859375*^9, 3.7535850486875*^9}, {
   3.75358510321875*^9, 3.75358512653125*^9}, {3.75358520246875*^9, 
   3.753585250234375*^9}, 3.7535852864375*^9}]
},
WindowSize->{1120, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 330, 9, 103, "Input"],
Cell[878, 31, 357, 11, 46, "Input"],
Cell[1238, 44, 655, 18, 104, "Input"],
Cell[1896, 64, 4235, 118, 526, "Input"]
}
]
*)

(* End of internal cache information *)
