(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49677,       1395]
NotebookOptionsPosition[     48900,       1369]
NotebookOutlinePosition[     49301,       1386]
CellTagsIndexPosition[     49258,       1383]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "DC", " ", "machine", " ", "with", " ", "constant", " ", "feeding", " ", 
     "current"}], ",", " ", 
    RowBox[{
    "La", " ", "and", " ", "Ra", "  ", "inductance", " ", "and", " ", 
     "resistance", " ", "of", " ", "the", " ", "rotor", " ", "windings"}], 
    ",", " ", 
    RowBox[{"J", " ", "moment", " ", "of", " ", "inertia"}], ",", " ", 
    RowBox[{
    "B", " ", "respects", " ", "the", " ", "torque", " ", "of", " ", 
     "newtonian", " ", "friction", " ", "and", " ", "kz", "*", 
     SuperscriptBox[
      RowBox[{"\[Omega]", "[", "t", "]"}], "2"], " ", "respects", " ", 
     "typical", " ", "load"}], ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "hydrodynamic"}], " ", "machine", " ", 
     RowBox[{"(", 
      RowBox[{"pump", ",", " ", 
       RowBox[{"fan", "..."}]}], ")"}]}], ",", " ", 
    RowBox[{
    "ia", " ", "is", " ", "the", " ", "current", " ", "through", " ", "the", 
     " ", "rotor", " ", "windings"}], ",", " ", 
    RowBox[{"u", " ", "or", " ", 
     RowBox[{"u", "[", "t", "]"}], " ", "voltage", " ", "on", " ", 
     RowBox[{"it", ".", " ", "k"}], "*", 
     RowBox[{"ia", "[", "t", "]"}], " ", "is", " ", "the", " ", "internal", 
     " ", "torque"}], ",", " ", 
    RowBox[{
     RowBox[{"ui", "[", "t", "]"}], " ", "induced", " ", "voltage", " ", 
     "beacause", " ", "the", " ", "motion", " ", "of", " ", "wires", " ", 
     "in", " ", "magnetic", " ", "field"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.67912361028125*^9, 3.67912362240625*^9}, {
  3.679123680828125*^9, 3.679123735015625*^9}, {3.67912377540625*^9, 
  3.679123794015625*^9}, {3.679123825453125*^9, 3.679124049703125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"to", " ", "see", " ", "outputs"}], ",", " ", 
    RowBox[{"delete", " ", "respective", " ", "semicolons"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"An", " ", "intristing", " ", "pehonomenon"}], ",", " ", 
     RowBox[{
      RowBox[{
      "possible", " ", "because", " ", "of", " ", "nonlinearity", " ", "of", 
       " ", "the", " ", "load", " ", 
       RowBox[{"(", 
        RowBox[{"do", " ", "you", " ", "know", " ", 
         RowBox[{"why", "?"}]}], ")"}], " ", "try", " ", "solution", " ", 
       "with", " ", "u"}], "\[Rule]", 
      RowBox[{
       RowBox[{"1", " ", "and", " ", "u"}], "\[Rule]", "10"}]}], ",", " ", 
     RowBox[{"first", " ", "response", " ", "is", " ", "oscillating"}], ",", 
     " ", 
     RowBox[{"the", " ", "second", " ", 
      RowBox[{"isn", "'"}], 
      RowBox[{"t", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sign", ":=", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"50.", "#"}], "]"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rcedif", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[Equal]", 
        RowBox[{
         RowBox[{"La", "*", 
          RowBox[{
           RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"Ra", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "+", 
         RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"ui", "[", "t", "]"}], "\[Equal]", 
        RowBox[{"k", "*", 
         RowBox[{"\[Omega]", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"J", "*", 
         RowBox[{
          RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"k", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "-", 
         RowBox[{"B", "*", 
          RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
         RowBox[{"kz", "*", 
          SuperscriptBox[
           RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pocs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"ia", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dos1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"La", "\[Rule]", "1"}], ",", 
       RowBox[{"Ra", "\[Rule]", "0.5"}], ",", 
       RowBox[{"k", "\[Rule]", "2"}], ",", 
       RowBox[{"B", "\[Rule]", ".3"}], ",", 
       RowBox[{"kz", "\[Rule]", "0.4"}], ",", 
       RowBox[{"J", "\[Rule]", 
        RowBox[{"1.5", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "1"}]]}]}], ",", 
       RowBox[{"u", "\[Rule]", "100"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", "dos1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nezname", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"rce", ",", 
        RowBox[{
         RowBox[{"a_Symbol", "[", "t", "]"}], "\[RuleDelayed]", "a"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{"rce", ",", "nezname", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "res"}], ",", 
        RowBox[{
         RowBox[{"ia", "[", "t", "]"}], "/.", "res"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<\!\(\*
StyleBox[\"\[Omega]\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[SuperscriptBox[\"s\", 
RowBox[{\"-\", \"1\"}]],
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"ia\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"A\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[0, 0, 1]]\)\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gr1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "res"}], ",", 
         RowBox[{
          RowBox[{"ia", "[", "t", "]"}], "/.", "res"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t [s]\>\"", ",", "\"\<\!\(\*
StyleBox[\"\[Omega]\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[SuperscriptBox[\"s\", 
RowBox[{\"-\", \"1\"}]],
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"ia\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"A\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[0, 0, 1]]\)\>\""}], "}"}]}], ",", 
       RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.67739446709375*^9, {3.677394591203125*^9, 3.6773951425*^9}, {
   3.67835134171875*^9, 3.678351390125*^9}, {3.678351442515625*^9, 
   3.678351477765625*^9}, {3.678351514734375*^9, 3.67835169046875*^9}, {
   3.6783517318125*^9, 3.678351774859375*^9}, {3.678351810515625*^9, 
   3.678351929921875*^9}, 3.678351964359375*^9, {3.67836093278125*^9, 
   3.67836098834375*^9}, {3.679119970640625*^9, 3.67912006653125*^9}, {
   3.679120289171875*^9, 3.679120359171875*^9}, 3.679123246296875*^9, 
   3.679123406109375*^9, {3.6791242488125*^9, 3.679124275640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "rSteady1", ",", "\[Omega]", ",", "uSteady1", ",", "uSteady2", ",", "u"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"rSteady1", "[", "\[Omega]_", "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"rcedif", "/.", 
       RowBox[{
        RowBox[{
         RowBox[{"_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", "0"}]}], 
      ")"}], "/.", 
     RowBox[{
      RowBox[{"a_", "[", "t", "]"}], "\[RuleDelayed]", "a"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"if", " ", "easily", " ", "possible"}], ",", " ", 
    RowBox[{
     RowBox[{
     "it", " ", "would", " ", "be", " ", "interesting", " ", "and", " ", 
      "sometimes", " ", "profitable", " ", "for", " ", "programming"}], 
     "..."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solGeneral", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"rSteady1", "[", "\[Omega]", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ia", ",", "u", ",", "ui"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"numerical", " ", "solution"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"uSteady1", "[", "\[Omega]_", "]"}], ":=", 
    RowBox[{"u", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"rSteady1", "[", "\[Omega]", "]"}], "/.", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"dos1", ",", 
          RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"using", " ", "analytical", " ", "solGeneral"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uSteady2", "[", "\[Omega]_", "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "/.", "solGeneral"}], ")"}], "/.", "dos1"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.678351991421875*^9, 3.67835204675*^9}, {
  3.678352080640625*^9, 3.67835240303125*^9}, {3.678352441046875*^9, 
  3.67835251171875*^9}, {3.6783527504375*^9, 3.678352971421875*^9}, {
  3.678353456125*^9, 3.6783534565*^9}, {3.679120315296875*^9, 
  3.67912032859375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "solution", " ", "based", " ", "on", " ", "symbolic", " ", 
    "access", " ", "is", " ", "reasonably", " ", 
    RowBox[{"faster", "!"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"time", "[", 
      RowBox[{"f_", ",", "nEvaluations_Integer"}], "]"}], ":=", 
     RowBox[{"First", "@", 
      RowBox[{"Timing", "[", 
       RowBox[{"f", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", "nEvaluations"}], "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"time", "[", 
      RowBox[{"#", ",", "1000"}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"uSteady1", ",", "uSteady2"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6783531011875*^9, 3.678353278671875*^9}, {
  3.678353315640625*^9, 3.678353379359375*^9}, {3.67835347109375*^9, 
  3.67835347453125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "response", " ", "of", " ", "the", " ", "system", " ", "when", " ", "we", 
     " ", "first", " ", "switch", " ", "the", " ", "voltage", " ", "from", 
     " ", "0", " ", "to", " ", "the", " ", "value", " ", "corresponding", " ",
      "to", " ", "the", " ", "first", " ", "steady", " ", "\[Omega]1"}], ",", 
    " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "u1"}], "=", 
     RowBox[{"uSteady2", "[", "\[Omega]1", "]"}]}], ",", " ", 
    RowBox[{
    "wait", " ", "till", " ", "the", " ", "steady", " ", "state", " ", "is", 
     " ", "nearly", " ", "reached"}], ",", " ", 
    RowBox[{
    "then", " ", "we", " ", "switch", "  ", "the", " ", "voltage", " ", 
     "from", " ", "u1", " ", "to", " ", "the", " ", "value", " ", 
     "corresponding", " ", "to", " ", "the", " ", "first", " ", "steady", " ",
      "\[Omega]2"}], ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "u2"}], "=", 
     RowBox[{"uSteady2", "[", "\[Omega]2", "]"}]}], ",", " ", 
    RowBox[{
    "wait", " ", "till", " ", "the", " ", "steady", " ", "state", " ", "is", 
     " ", "nearly", " ", "reached"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"sol1", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol1", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"omegas", ":", 
         RowBox[{"{", 
          RowBox[{"\[Omega]1_", ",", "\[Omega]2_"}], "}"}]}], ",", "tsol_"}], 
       "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "u1", ",", "u2", ",", "step", ",", "uu", ",", "rce", ",", "res"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], "=", 
         RowBox[{"uSteady2", "/@", "omegas"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"step", "=", "UnitStep"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uu", "[", "t_", "]"}], ":=", 
         RowBox[{
          RowBox[{"u1", "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "0"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u2", "-", "u1"}], ")"}], "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rce", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Union", "[", 
             RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", 
            RowBox[{"u", "\[Rule]", 
             RowBox[{"uu", "[", "t", "]"}]}]}], ")"}], "/.", "dos1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{"rce", ",", "nezname", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", 
              RowBox[{"2", "*", "tsol"}]}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"res", ",", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"uu", "[", "t", "]"}], "/.", 
             RowBox[{"t", "\[Rule]", "#"}]}], "]"}], "&"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"\[Omega]", "/.", 
      RowBox[{
       RowBox[{"sol1", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "40"}], "}"}], ",", "10"}], "}"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"time", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Omega]", "/.", 
          RowBox[{
           RowBox[{"sol1", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"20", ",", 
                RowBox[{"20", "+", "#"}]}], "}"}], ",", "10"}], "}"}], "]"}], 
           "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "[", "0.5", "]"}], "&"}], 
      ",", "40"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"pom", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<time= \>\"", "<>", 
       RowBox[{"ToString", "[", "%", "]"}], "<>", "\"\< s\>\""}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\<\[Omega] [\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], 
       "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.678353505140625*^9, 3.67835357303125*^9}, {
   3.678353620125*^9, 3.6783539295*^9}, {3.6783539660625*^9, 
   3.6783540546875*^9}, {3.67835410746875*^9, 3.678354122296875*^9}, {
   3.678354281*^9, 3.678354525046875*^9}, {3.6783545614375*^9, 
   3.678354851234375*^9}, {3.678354992359375*^9, 3.67835509740625*^9}, {
   3.678355674046875*^9, 3.67835570271875*^9}, {3.678355889984375*^9, 
   3.678356097140625*^9}, {3.678438857828125*^9, 3.678438861765625*^9}, 
   3.67912037575*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"continuous", " ", "access"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"we", " ", "can", " ", "see", " ", "no", " ", "profit"}], 
       "..."}], "now"}], "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"20", "t"}], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"sol1", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol1", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"omegas", ":", 
         RowBox[{"{", 
          RowBox[{"\[Omega]1_", ",", "\[Omega]2_"}], "}"}]}], ",", "tsol_"}], 
       "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "u1", ",", "u2", ",", "step", ",", "uu", ",", "rce", ",", "res"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], "=", 
         RowBox[{"uSteady2", "/@", "omegas"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"step", "=", 
         RowBox[{
          RowBox[{"0.5", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Tanh", "[", 
              RowBox[{"20", "#"}], "]"}]}], ")"}]}], "&"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uu", "[", "t_", "]"}], ":=", 
         RowBox[{
          RowBox[{"u1", "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "0"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u2", "-", "u1"}], ")"}], "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rce", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Union", "[", 
             RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", 
            RowBox[{"u", "\[Rule]", 
             RowBox[{"uu", "[", "t", "]"}]}]}], ")"}], "/.", "dos1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{"rce", ",", "nezname", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", 
              RowBox[{"2", "*", "tsol"}]}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"res", ",", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"uu", "[", "t", "]"}], "/.", 
             RowBox[{"t", "\[Rule]", "#"}]}], "]"}], "&"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"\[Omega]", "/.", 
      RowBox[{
       RowBox[{"sol1", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "40"}], "}"}], ",", "10"}], "}"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"time", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Omega]", "/.", 
          RowBox[{
           RowBox[{"sol1", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"20", ",", 
                RowBox[{"20", "+", "#"}]}], "}"}], ",", "10"}], "}"}], "]"}], 
           "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "[", "0.5", "]"}], "&"}], 
      ",", "40"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"pom", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<time= \>\"", "<>", 
        RowBox[{"ToString", "[", "%", "]"}], "<>", "\"\< s\>\""}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t [s]\>\"", ",", 
         "\"\<\[Omega] [\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], 
        "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6783561149375*^9, 3.678356285765625*^9}, {
  3.678358226625*^9, 3.678358243515625*^9}, {3.678438867125*^9, 
  3.678438871109375*^9}, {3.67912040821875*^9, 3.67912041265625*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "desired", " ", "angular", " ", 
    "frequency"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"\[Omega]desired", ",", "step"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"steepness", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tsol", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"step", "=", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"steepness", "#"}], "]"}]}], ")"}]}], "&"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Omega]1", "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "0"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Omega]2", "-", "\[Omega]1"}], ")"}], "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", 
      RowBox[{"2.5", "*", 
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart"}], ")"}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6783582938125*^9, 3.678358466171875*^9}, {
   3.678358496953125*^9, 3.678358539609375*^9}, {3.6783585745*^9, 
   3.678358655765625*^9}, {3.67835869565625*^9, 3.678358797984375*^9}, {
   3.67835933484375*^9, 3.678359336421875*^9}, {3.6783603835625*^9, 
   3.678360389765625*^9}, 3.678360573546875*^9, 3.67836075315625*^9, {
   3.678425156453125*^9, 3.678425197015625*^9}, 3.67843888196875*^9, 
   3.67843902784375*^9, 3.67843907378125*^9, 3.678439143609375*^9, {
   3.679120464015625*^9, 3.679120473765625*^9}, {3.679122753484375*^9, 
   3.679122776625*^9}, {3.679123062578125*^9, 3.679123076*^9}, {
   3.67912316378125*^9, 3.679123231328125*^9}, 3.679123425859375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"adding", " ", "P", " ", "controller"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      StyleBox["100",
       FontColor->RGBColor[1, 0, 0]], "*", "\[CapitalDelta]\[Omega]"}]}], 
    ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "proportional", " ", "controller", " ", "without", " ", "output", " ", 
     "limitations"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"initConds", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "[", "_", "]"}], "\[Equal]", "_"}], "\[RuleDelayed]", 
       "a"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "sol"}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\< \!\(\*
StyleBox[\"\[Omega]Real\",
FontColor->RGBColor[0, 0, 1]]\)  \!\(\*
StyleBox[\"\[Omega]Desired\",
FontColor->RGBColor[1, 0, 0]]\) [\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)]\>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.67843896134375*^9, 3.678438969015625*^9}, {
  3.67912206271875*^9, 3.679122181375*^9}, {3.679122256875*^9, 
  3.6791222956875*^9}, {3.679122378984375*^9, 3.679122384015625*^9}, {
  3.6791224148125*^9, 3.679122769546875*^9}, {3.679122802828125*^9, 
  3.67912285340625*^9}, {3.679122918375*^9, 3.679123000765625*^9}, {
  3.67912303571875*^9, 3.67912305678125*^9}, {3.679123088625*^9, 
  3.67912309925*^9}, {3.679123166234375*^9, 3.679123173125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"adding", " ", "P", " ", "controller"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      StyleBox["8",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"Tanh", "[", 
       RowBox[{
        StyleBox["100",
         FontColor->RGBColor[1, 0, 0]], "\[CapitalDelta]\[Omega]"}], 
       "]"}]}]}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "proportional", " ", "controller", " ", "with", " ", "output", " ", 
       "limitations"}], ",", " ", 
      RowBox[{"try", " ", "to", " ", "change", " ", "red", " ", "numbers"}]}],
      "*)"}], "\[IndentingNewLine]", 
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"t", ",", "1"}], "}"}],
        FontColor->RGBColor[1, 0, 1]]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Try", " ", "eqnReg", " ", "without", " ", "time", " ", "derivative", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"simply", " ", "change", " ", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"t", ",", "1"}], "}"}],
         FontColor->RGBColor[1, 0, 1]], 
        StyleBox[
         RowBox[{
          StyleBox[" ",
           FontColor->RGBColor[1, 0, 1]], " "}]], "into", " ", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"t", ",", "0"}], "}"}],
         FontColor->RGBColor[1, 0, 1]]}], ":", " ", 
       RowBox[{"elapsed", " ", "time", " ", "will", " ", "increase", " ", 
        RowBox[{"strongly", "!"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{"a_Symbol", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"Timing", "[", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Union", "[", 
          RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
         ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "tStart", ",", 
           RowBox[{"2", "tsol"}]}], "}"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", 
          SuperscriptBox["10", "6"]}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", 
        RowBox[{"sol", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\< \!\(\*
StyleBox[\"\[Omega]Real\",
FontColor->RGBColor[0, 0, 1]]\)  \!\(\*
StyleBox[\"\[Omega]Desired\",
FontColor->RGBColor[1, 0, 0]]\) [\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<elapsed time= \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< s\>\""}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.679123357359375*^9, 3.679123390453125*^9}, {
   3.679124408453125*^9, 3.679124466703125*^9}, {3.6791245063125*^9, 
   3.67912451915625*^9}, {3.679721954171875*^9, 3.679721961046875*^9}, {
   3.679722019921875*^9, 3.679722068640625*^9}, {3.6797221000625*^9, 
   3.679722141671875*^9}, {3.67972218490625*^9, 3.67972221271875*^9}, {
   3.679722255625*^9, 3.679722342546875*^9}, {3.679722398078125*^9, 
   3.679722450390625*^9}, {3.679722495609375*^9, 3.679722649828125*^9}, 
   3.679722724125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"adding", " ", "P"}], "-", 
     RowBox[{"I", " ", "controller"}]}], ",", " ", 
    RowBox[{
    "play", " ", "with", " ", "red", " ", "values", " ", "and", " ", 
     "investigate", " ", "their", " ", 
     RowBox[{"influence", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"cosntP", "=", 
     StyleBox["4",
      FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"constI", "=", 
     StyleBox["100",
      FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      RowBox[{"cosntP", "*", "\[CapitalDelta]\[Omega]"}], "+", 
      RowBox[{"constI", "*", 
       RowBox[{"Integrate", "[", 
        RowBox[{"\[CapitalDelta]\[Omega]", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}]}]}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{"P", "-", 
      RowBox[{
      "I", " ", "controller", " ", "without", " ", "output", " ", 
       "limitations"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{"charReg", "[", 
           RowBox[{
            RowBox[{"\[Omega]des", "[", "t", "]"}], "-", 
            RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}],
        "]"}], "/.", 
      RowBox[{"\[Omega]des", "\[Rule]", "\[Omega]desired"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Try", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{"charReg", "[", 
           RowBox[{
            RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
            RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}],
        "]"}], " ", "instead", " ", "of", " ", "the", " ", "previous", " ", 
      RowBox[{"command", ":", " ", 
       RowBox[{"the", " ", "result", " ", "is", " ", "the", " ", "same"}]}]}],
      ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "but", " ", "elapsed", " ", "time", " ", "will", " ", "increase"}], 
       "..."}], " ", 
      RowBox[{"why", "?"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"initConds", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "[", "_", "]"}], "\[Equal]", "_"}], "\[RuleDelayed]", 
       "a"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "sol"}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\< \!\(\*
StyleBox[\"\[Omega]Real\",
FontColor->RGBColor[0, 0, 1]]\)  \!\(\*
StyleBox[\"\[Omega]Desired\",
FontColor->RGBColor[1, 0, 0]]\) [\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)]\>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6797228544375*^9, 3.6797230019375*^9}, {
  3.67972305809375*^9, 3.67972306121875*^9}, {3.6797230991875*^9, 
  3.679723287671875*^9}, {3.679723517328125*^9, 3.679723624515625*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.679723274734375*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"adding", " ", "P"}], "-", "I", "-", 
     RowBox[{"D", " ", "controller"}]}], ",", " ", 
    RowBox[{
    "play", " ", "with", " ", "red", " ", "values", " ", "and", " ", 
     "investigate", " ", "their", " ", 
     RowBox[{"influence", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"cosntP", "=", 
    StyleBox["4",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{"constI", "=", 
    StyleBox["100",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{"constD", "=", 
    StyleBox["1",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
    RowBox[{
     RowBox[{"cosntP", "*", "\[CapitalDelta]\[Omega]"}], "+", 
     RowBox[{"constI", "*", 
      RowBox[{"Integrate", "[", 
       RowBox[{"\[CapitalDelta]\[Omega]", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"D", "[", 
      RowBox[{"\[CapitalDelta]\[Omega]", ",", "t"}], "]"}]}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{"P", "-", 
     RowBox[{
     "I", " ", "controller", " ", "without", " ", "output", " ", 
      "limitations"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"eqnMachine", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"La", "*", 
          RowBox[{
           RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"Ra", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "+", 
         RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"J", "*", 
         RowBox[{
          RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"k", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "-", 
         RowBox[{"B", "*", 
          RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
         RowBox[{"kz", "*", 
          SuperscriptBox[
           RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
          RowBox[{"sign", "[", 
           RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
     RowBox[{
      RowBox[{"ui", "[", "t", "]"}], "->", 
      RowBox[{"k", "*", 
       RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"eqnReg", "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]des", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "/.", 
     RowBox[{"\[Omega]des", "\[Rule]", "\[Omega]desired"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"eqnNum1", "=", 
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{"dos1", ",", 
       RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"initConds", "=", 
    RowBox[{"Union", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], ",", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "''"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "'"}], "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"unknownVars", "=", 
    RowBox[{"Union", "@", 
     RowBox[{"Cases", "[", 
      RowBox[{"eqnNum1", ",", 
       RowBox[{"a_Symbol", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tStart", ",", 
         RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.679723787671875*^9, 3.67972385015625*^9}, {
   3.679723899734375*^9, 3.679724036140625*^9}, 3.67972410653125*^9, 
   3.679731138203125*^9}]
},
WindowSize->{1120, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1749, 37, 244, "Input"],
Cell[2297, 59, 7755, 223, 666, "Input"],
Cell[10055, 284, 2440, 70, 327, "Input"],
Cell[12498, 356, 937, 26, 103, "Input"],
Cell[13438, 384, 5454, 139, 530, "Input"],
Cell[18895, 525, 4837, 137, 474, "Input"],
Cell[23735, 664, 2699, 70, 411, "Input"],
Cell[26437, 736, 4864, 135, 396, "Input"],
Cell[31304, 873, 6464, 179, 575, "Input"],
Cell[37771, 1054, 6150, 173, 536, "Input"],
Cell[43924, 1229, 68, 1, 46, "Input"],
Cell[43995, 1232, 4901, 135, 442, "Input"]
}
]
*)

(* End of internal cache information *)
