(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50477,       1294]
NotebookOptionsPosition[     49533,       1264]
NotebookOutlinePosition[     50018,       1283]
CellTagsIndexPosition[     49975,       1280]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.638255496078125*^9, 3.638255503171875*^9}, {
  3.753346012453125*^9, 3.753346012859375*^9}},
 ExpressionUUID -> "215eb9ea-b69b-4be9-a9cd-0ec30aa71a3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"jen", " ", "pro", " ", "uplnost"}], ",", " ", 
    RowBox[{"pro", " ", "data", " ", "kratsi"}], ",", " ", 
    RowBox[{
    "nez", " ", "4.5", " ", "periody", " ", "dava", " ", "FFT", " ", "velke", 
     " ", "chyby"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ClearAll", "[", "vydejFourier", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vydejFourier", "[", 
      RowBox[{"listDat_", ",", "sr_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "f", ",", "pdata", ",", "n", ",", "pos", ",", "fr", ",", "frpos", ",",
          "nx", ",", "frekv"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"pdata", "=", "listDat"}], ";", "\[IndentingNewLine]", 
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "pdata", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"f", " ", "=", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"Fourier", "[", "pdata", "]"}], "]"}]}], ";", "\n", 
        "       ", 
        RowBox[{"pos", " ", "=", " ", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"f", ",", " ", 
            RowBox[{"Max", "[", "f", "]"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"fr", " ", "=", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"Fourier", "[", 
           RowBox[{
            RowBox[{"pdata", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{"2", " ", "Pi", " ", "I", " ", 
               RowBox[{"(", 
                RowBox[{"pos", " ", "-", " ", "2"}], ")"}], " ", 
               RowBox[{
                RowBox[{"N", "[", 
                 RowBox[{"Range", "[", 
                  RowBox[{"0", ",", " ", 
                   RowBox[{"n", " ", "-", " ", "1"}]}], "]"}], "]"}], "/", 
                "n"}]}], "]"}]}], ",", " ", 
            RowBox[{"FourierParameters", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"2", "/", "n"}]}], "}"}]}]}], "]"}], "]"}]}], ";", 
        "\n", "        ", 
        RowBox[{"frpos", " ", "=", " ", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"fr", ",", " ", 
            RowBox[{"Max", "[", "fr", "]"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nx", "=", 
         RowBox[{"N", "[", 
          RowBox[{"n", "/", 
           RowBox[{"(", 
            RowBox[{"pos", " ", "-", " ", "2", " ", "+", " ", 
             RowBox[{"2", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"frpos", " ", "-", " ", "1"}], ")"}], "/", "n"}]}]}], 
            ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"frekv", "=", 
           FractionBox[
            RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
          RowBox[{"100", "*", 
           RowBox[{"(", 
            RowBox[{"k\[Omega]", "-", 
             FractionBox["frekv", "fnom"]}], ")"}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pompom", "=", 
     RowBox[{"dejData", "[", 
      RowBox[{"{", 
       RowBox[{"trialfce", ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "0.2", ",", "0.2"}], "}"}]}], "}"}], "]"}]}], ";",
     "\[IndentingNewLine]", 
    RowBox[{"vydejFourier", "[", 
     RowBox[{"pompom", ",", "sr"}], "]"}]}], "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", 
    RowBox[{"listDat_", ",", "sr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
       RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
       "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
       ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
       "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0."}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"aclist", "[", 
                RowBox[{"[", 
                 RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
               RowBox[{"aclist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
            ")"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", 
             RowBox[{"0", "+", 
              RowBox[{"1.", "*", 
               SuperscriptBox["nOkno", "2"]}]}]], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "y1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", "y2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       FractionBox[
        RowBox[{"y1", "+", 
         RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
         RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
         RowBox[{"2", " ", "x2", " ", "y3"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"y1", "-", 
           RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       RowBox[{"Total", "[", 
        SuperscriptBox[
         RowBox[{"Take", "[", 
          RowBox[{"listDat", ",", 
           RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["y1", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "y1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox[
          RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["10", "6"], 
         SuperscriptBox["sr", "2"], 
         FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}, {3.7239556183125*^9, 
   3.723955630328125*^9}, {3.753346122546875*^9, 3.753346124640625*^9}, {
   3.7533479519375*^9, 3.753347957625*^9}, {3.75349614084375*^9, 
   3.753496211984375*^9}},
 ExpressionUUID -> "823b6015-adaf-4e73-9ca7-c2813b7ba6f6"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kperSampl", "=", "2.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]SumK", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SR", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "SR", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k\[Omega]", "=", "1.0456"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"2", "*", 
      RowBox[{"Round", "[", 
       FractionBox["48000", 
        RowBox[{"2", "*", "50"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"k\[Omega]", "*", "2.", "*", "Pi", "*", "fnom"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tnom", "=", 
     FractionBox["Tnom", "sr"]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"trialfce", "[", "t_", "]"}], ":=", 
     RowBox[{"1", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"\[Omega]", "*", "t"}], "+", "0.123"}], "]"}], "+", 
        RowBox[{"0.1", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"3.483", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}], "+", 
        RowBox[{"0.05", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"7.178", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}], "+", 
        RowBox[{"0.04", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"11", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.591248592265625*^9, 3.591248638765625*^9, {3.591248692484375*^9, 
   3.591248693125*^9}, {3.59124894825*^9, 3.591248998703125*^9}, {
   3.591249110484375*^9, 3.59124911196875*^9}, {3.591249147203125*^9, 
   3.591249147359375*^9}, 3.591249182125*^9, {3.591249215109375*^9, 
   3.591249239984375*^9}, 3.591249279671875*^9, {3.591250220390625*^9, 
   3.59125022371875*^9}, {3.591250276796875*^9, 3.59125032821875*^9}, {
   3.59125275034375*^9, 3.591252751078125*^9}, {3.59126424884375*^9, 
   3.591264249921875*^9}, {3.638254013921875*^9, 3.63825401484375*^9}, {
   3.638254666953125*^9, 3.638254695921875*^9}, {3.638254752515625*^9, 
   3.638254786796875*^9}, {3.638254821578125*^9, 3.63825495734375*^9}, {
   3.63825712134375*^9, 3.638257333140625*^9}, {3.638257389265625*^9, 
   3.6382577399375*^9}, {3.63825778628125*^9, 3.638257824234375*^9}, {
   3.638257915125*^9, 3.638258024171875*^9}, {3.638258059921875*^9, 
   3.6382580603125*^9}, {3.63825816075*^9, 3.63825827640625*^9}, {
   3.63825832834375*^9, 3.638258365515625*^9}, {3.6382585934375*^9, 
   3.638258595328125*^9}, 3.638258908015625*^9, 3.6382589783125*^9, {
   3.638259009859375*^9, 3.638259016359375*^9}, {3.63825905259375*^9, 
   3.6382590629375*^9}, {3.638259104640625*^9, 3.638259110703125*^9}, {
   3.63825916878125*^9, 3.638259177984375*^9}, {3.75334611496875*^9, 
   3.753346115625*^9}, {3.7533472788125*^9, 3.7533473130625*^9}, {
   3.753347348578125*^9, 3.75334736903125*^9}, {3.75335138578125*^9, 
   3.753351402640625*^9}, 3.753351481109375*^9, 3.753410711984375*^9, {
   3.753417918595194*^9, 3.7534179208759327`*^9}, {3.75342022144497*^9, 
   3.753420227677865*^9}, 3.753422680269084*^9, {3.7534227164949503`*^9, 
   3.7534227644993*^9}, 3.7534229938048162`*^9, {3.7534230933751726`*^9, 
   3.753423121681023*^9}, {3.7534232027244883`*^9, 3.753423208145096*^9}, {
   3.753496675609375*^9, 3.75349669621875*^9}},
 ExpressionUUID -> "78a246c8-036e-4d7c-8217-da1a4fc24674"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejPruchody", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejPruchody", "[", 
    RowBox[{"{", 
     RowBox[{"listDat_", ",", "sr_", ",", "kNula_", ",", "nAV_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "datsSCasy", ",", "minU", ",", "maxU", ",", "ampl", ",", "kolemNuly", 
       ",", "gathered", ",", 
       RowBox[{"kGatger", "=", "0.02"}], ",", "prusecik", ",", "t", ",", 
       "perioda", ",", "f", ",", "selectMozne", ",", "vybrane"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datsSCasy", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{
         RowBox[{"Thread", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[CapitalDelta]tnom", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Range", "[", 
                RowBox[{"Length", "[", "listDat", "]"}], "]"}], "-", "1"}], 
              ")"}]}], ",", "listDat"}], "}"}], "]"}], ",", 
         RowBox[{"Round", "[", "nAV", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"minU", ",", "maxU"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "#", "]"}], ",", 
           RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", "datsSCasy"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ampl", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"minU", ",", "maxU"}], "}"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kolemNuly", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"datsSCasy", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", 
           RowBox[{"kNula", "*", "ampl"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gathered", "=", 
       RowBox[{"Gather", "[", 
        RowBox[{"kolemNuly", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"#1", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"#2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<", 
           RowBox[{"kGatger", "*", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"prusecik", "[", "data_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "fit", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"fit", "=", 
           RowBox[{"Fit", "[", 
            RowBox[{"data", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"t", "/.", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"fit", "\[Equal]", "0"}], ",", "t"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"selectMozne", "[", "periody_", "]"}], ":=", 
       RowBox[{"Select", "[", 
        RowBox[{"periody", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "-", "Tnom"}], "]"}], "<", 
           RowBox[{"0.2", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"selectMozne", ":=", 
         RowBox[{"#", "&"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"vybrane", "=", 
       RowBox[{"selectMozne", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"prusecik", "/@", "gathered"}], ",", "3", ",", "1"}], 
          "]"}], "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a_", ",", "_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"b", "-", "a"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"perioda", "=", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[GreaterEqual]", "1"}], 
         ",", 
         RowBox[{"Mean", "[", "vybrane", "]"}], ",", 
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[LessEqual]", "1"}], ",",
          "0.04"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox["1.", "perioda"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", "1.", ",", 
        FractionBox["perioda", "Tnom"]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753347907296875*^9, 3.7533479268125*^9}, {
   3.753347964890625*^9, 3.753348165671875*^9}, {3.75334820690625*^9, 
   3.75334827159375*^9}, 3.75334830603125*^9, {3.753348345578125*^9, 
   3.75334834590625*^9}, {3.753348403796875*^9, 3.753348405296875*^9}, {
   3.7533485530625*^9, 3.753348680421875*^9}, 3.753349193640625*^9, {
   3.753349249625*^9, 3.753349257703125*^9}, {3.75334936328125*^9, 
   3.753349499484375*^9}, {3.75334953078125*^9, 3.753349554421875*^9}, {
   3.7533496896875*^9, 3.7533497893125*^9}, {3.753349829921875*^9, 
   3.75334985675*^9}, {3.753349895078125*^9, 3.753349932140625*^9}, {
   3.753350013984375*^9, 3.753350085234375*^9}, {3.753350124390625*^9, 
   3.753350352671875*^9}, {3.753350643375*^9, 3.7533506814375*^9}, {
   3.753351209046875*^9, 3.753351288375*^9}, {3.7533513275625*^9, 
   3.753351380453125*^9}, 3.753351440390625*^9, 3.753351471515625*^9, 
   3.75341075709375*^9, 3.75341079340625*^9, {3.753411184578125*^9, 
   3.753411188578125*^9}, {3.753496474484375*^9, 3.753496616125*^9}, 
   3.753496660140625*^9, 3.753496998484375*^9, {3.753497047640625*^9, 
   3.75349705746875*^9}, 3.7534972045625*^9, {3.7535825184375*^9, 
   3.7535826315*^9}},
 ExpressionUUID -> "5ea509df-331d-4d99-bdb0-bfcf37877543"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "dejData", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejData", "[", 
    RowBox[{"{", 
     RowBox[{"fce_", ",", 
      RowBox[{"{", 
       RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
     "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"datsFce", ",", "sum", ",", "rnp", ",", "ampl", ",", "dats"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datsFce", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"(", 
         RowBox[{"rnp", "=", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", 
            RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
           "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ampl", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"0.5", "*", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ".", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Min", "[", "#", "]"}], ",", 
             RowBox[{"Max", "[", "#", "]"}]}], "}"}]}]}], "&"}], "@", 
        RowBox[{"(", "datsFce", ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sum", "[", "seedRandom_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"SeedRandom", "[", "seedRandom", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"k", "*", "ampl", "*", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0.0", ",", "\[Sigma]SumK"}], "]"}], "]"}]}], "&"}], "/@",
            "rnp"}]}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dats", "=", 
       RowBox[{"datsFce", "+", 
        RowBox[{"sum", "[", "SR", "]"}]}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pompom", "=", 
   RowBox[{"dejData", "[", 
    RowBox[{"{", 
     RowBox[{"trialfce", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [-]\>\"", ",", "\"\<signal\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.9", "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.75335151846875*^9, 3.75335153778125*^9}, {
   3.753351589234375*^9, 3.753351654671875*^9}, {3.75335173928125*^9, 
   3.753351879859375*^9}, {3.753351984734375*^9, 3.75335210346875*^9}, {
   3.753352140734375*^9, 3.75335224896875*^9}, 3.753409775671875*^9, {
   3.753409933765625*^9, 3.753410003765625*^9}, {3.75341003684375*^9, 
   3.75341011884375*^9}, {3.75341031828125*^9, 3.753410319546875*^9}, {
   3.753410460609375*^9, 3.753410462234375*^9}, {3.753410598078125*^9, 
   3.753410623609375*^9}},
 ExpressionUUID -> "827f3a01-034d-43ac-a86e-7b268845f659"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejGrafy", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejGrafy", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "data", ",", "pl1", ",", "Nx5", ",", "pruchody", ",", "ukp1", ",", 
       "ukp2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"dejData", "[", "pars", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pl1", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"data", ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<i [-]\>\"", ",", "\"\<signal\>\""}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
            RowBox[{"Opacity", "[", "0.9", "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Nx5", "=", 
       RowBox[{"vydejNx5", "[", 
        RowBox[{"data", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pruchody", "=", 
       RowBox[{"vydejPruchody", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "sr", ",", "kNula", ",", "nAV"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ukp1", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"pl1", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"data", ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"PointSize", "[", "0.003", "]"}]}]}], "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<\[Delta]f= \>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"0.001", "*", 
             RowBox[{"Round", "[", 
              RowBox[{"1000", 
               RowBox[{"Nx5", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "<>", 
           "\"\< %\>\""}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ukp2", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"pl1", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"data", ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"PointSize", "[", "0.003", "]"}]}]}], "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<\[Delta]f= \>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"0.001", "*", 
             RowBox[{"Round", "[", 
              RowBox[{"1000", 
               RowBox[{"pruchody", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "<>", 
           "\"\< %\>\""}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"ukp1", ",", "ukp2"}], "}"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejGrafy", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"trialfce", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0.2", ",", "0.6"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0.04"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.753410846515625*^9, 3.75341116921875*^9}, {
   3.753411205984375*^9, 3.75341130259375*^9}, {3.75341134671875*^9, 
   3.753411465234375*^9}, 3.753411502953125*^9, 3.753422947799989*^9, 
   3.753496883890625*^9, {3.7534981695625*^9, 3.753498195015625*^9}},
 ExpressionUUID -> "2bea3057-6332-4670-98b1-dfb7b9ce14d4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejChyby", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejChyby", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "data", ",", "pl1", ",", "Nx5", ",", "pruchody", ",", "ukp1", ",", 
       "ukp2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"dejData", "[", "pars", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Nx5", "=", 
       RowBox[{"vydejNx5", "[", 
        RowBox[{"data", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pruchody", "=", 
       RowBox[{"vydejPruchody", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "sr", ",", "kNula", ",", "nAV"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Nx5", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"pruchody", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vydejChyby", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"trialfce", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.04"}], "}"}]}], "}"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7534115213125*^9, 3.753411536796875*^9}, {
   3.753411568859375*^9, 3.753411570015625*^9}, {3.753411604125*^9, 
   3.753411643765625*^9}, 3.753496896015625*^9},
 ExpressionUUID -> "30f95a56-70ae-4ad5-aff8-addfab822f0a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "\[IndentingNewLine]",
     "fce", " ", "je", " ", "puvodni", " ", "signal", " ", "bez", " ", 
    "sumu"}], ",", " ", 
   RowBox[{
   "jako", " ", "funkce", " ", "casu", "\[IndentingNewLine]", "SR", " ", 
    "urcuje", " ", 
    RowBox[{"SeedRandom", "[", "SR", "]"}], " ", "pro", " ", "generovani", 
    " ", "Gaussovskeho", " ", "sumu", "\[IndentingNewLine]", "\[Sigma]SumK", 
    " ", "smerodatna", " ", "odchylka", " ", "sumu", "\[IndentingNewLine]", 
    RowBox[{"k", ":", " ", 
     RowBox[{
     "sumy", " ", "jsou", " ", "nasobeny", " ", "k", " ", "a", " ", 
      "amplitudou", " ", "sumu"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
   "nAV", " ", "delka", " ", "okna", " ", "MovingAverage", " ", "pro", " ", 
    "filtraci", " ", "pri", " ", "pouziti", " ", "pruchodu", " ", "nulou", 
    "\[IndentingNewLine]", 
    RowBox[{"kNula", ":", " ", 
     RowBox[{
     "udava", " ", "hladinu", " ", "kolik", " ", "bodu", " ", "bereme", " ", 
      "pro", " ", "Fit", " ", "ze", " ", "ktereho", " ", "bereme", " ", 
      "casy", " ", "pruchodu", " ", "nulou"}]}]}]}], "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.753411697984375*^9, 3.75341177403125*^9}, {
  3.753411832546875*^9, 3.7534120035*^9}},
 ExpressionUUID -> "8884e628-3c30-4b37-bc72-e192bb9c1394"],

Cell[BoxData[
 RowBox[{"vydejGrafy", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"trialfce", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "0.2", ",", "0.2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0.02"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7534120199375*^9, 3.7534120404375*^9}, {
   3.75341796936455*^9, 3.7534180112765493`*^9}, {3.7534228338111396`*^9, 
   3.75342286341356*^9}, 3.7534229601096153`*^9, {3.7534230245007324`*^9, 
   3.7534230640070705`*^9}, {3.7534231351466103`*^9, 
   3.7534231491433287`*^9}, {3.7534232171429815`*^9, 3.753423217330432*^9}, {
   3.753496234609375*^9, 3.753496307328125*^9}, {3.75349662915625*^9, 
   3.753496642171875*^9}, {3.753496735578125*^9, 3.753496825875*^9}, {
   3.75349685609375*^9, 3.753496860578125*^9}, {3.753496919515625*^9, 
   3.75349695359375*^9}, {3.7534970693125*^9, 3.753497102375*^9}, {
   3.753497163546875*^9, 3.7534971730625*^9}, 3.753497213453125*^9, {
   3.75349724746875*^9, 3.753497251625*^9}},
 ExpressionUUID -> "48acb8b2-8ea4-4f35-9a92-fc6a0e6c4b6d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zpracujChybySR", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpracujChybySR", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pars", ":", 
        RowBox[{"{", 
         RowBox[{"fce_", ",", 
          RowBox[{"{", 
           RowBox[{"\[Sigma]SumK_", ",", "k_"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], ",", "nChyb_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "dataChyby", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataChyby", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"vydejChyby", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"fce", ",", 
              RowBox[{"{", 
               RowBox[{"#", ",", "\[Sigma]SumK", ",", "k"}], "}"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"nAV", ",", "kNula"}], "}"}]}], "}"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "nChyb", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Mean", "[", "dataChyby", "]"}], ",", 
        RowBox[{"Mean", "[", 
         RowBox[{"Abs", "/@", "dataChyby"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"First", "[", "#", "]"}], "]"}], "&"}], "/@", 
            "dataChyby"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"Last", "[", "#", "]"}], "]"}], "&"}], "/@", 
            "dataChyby"}], "]"}]}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"zpracujChybySR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"trialfce", ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.6"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.02"}], "}"}]}], "}"}], ",", "10"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753419548587361*^9, 3.753419811962971*^9}, {
   3.753419887835811*^9, 3.7534199679575872`*^9}, {3.7534200808998213`*^9, 
   3.7534200978177347`*^9}, {3.753420132950082*^9, 3.7534201713942027`*^9}, {
   3.7534202594204073`*^9, 3.753420366254673*^9}, {3.753422606723853*^9, 
   3.753422644433745*^9}, 3.753422816284011*^9, 3.753422980011175*^9, {
   3.753423075973016*^9, 3.753423085314537*^9}, {3.7534231643585224`*^9, 
   3.7534231938671994`*^9}, {3.75349609034375*^9, 3.753496095953125*^9}, {
   3.753496321078125*^9, 3.753496354921875*^9}, {3.753497287234375*^9, 
   3.7534973126875*^9}, {3.753497342796875*^9, 3.753497440296875*^9}, {
   3.753497474328125*^9, 3.753497617015625*^9}, {3.75349765490625*^9, 
   3.753497696390625*^9}, {3.753497791859375*^9, 3.75349783934375*^9}, 
   3.75349788971875*^9, {3.75349796109375*^9, 3.75349796153125*^9}, {
   3.753498109421875*^9, 3.7534981586875*^9}},
 ExpressionUUID -> "214b366e-3dc1-4d2f-a0a4-66be9c8f7dfd"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kmin", "=", 
     RowBox[{"1.", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "3"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kmax", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nKacek", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kacka", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"kmin", "*", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["kmax", "kmin"], ")"}], 
         FractionBox[
          RowBox[{"#", "-", "1"}], "nKacek"]]}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"Round", "[", 
        RowBox[{"nKacek", "+", "1"}], "]"}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.75349808278125*^9, 3.75349813396875*^9}, {
  3.7534982040625*^9, 3.75349829921875*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"ataChyb", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"Quiet", "@", 
         RowBox[{"zpracujChybySR", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"trialfce", ",", 
               RowBox[{"{", 
                RowBox[{"0.2", ",", "k"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "0.02"}], "}"}]}], "}"}], ",", "10"}], 
          "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "kacka"}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"dataChyb", ">>", "\"\<dataChyb\>\""}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.753498021234375*^9, 3.753498078828125*^9}, {
   3.753498308171875*^9, 3.7534983433125*^9}, 3.7535824394375*^9, 
   3.75358273259375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"<<", "\"\<dataChyb\>\""}], ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errNase", "=", 
   RowBox[{"vys", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k_", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_", ",", "b_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c_", ",", "d_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"e_", ",", "f_"}], "}"}]}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"k", ",", "e"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errZeroCrossing", "=", 
   RowBox[{"vys", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k_", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_", ",", "b_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c_", ",", "d_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"e_", ",", "f_"}], "}"}]}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"k", ",", "f"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plNase", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"errNase", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0.01", ",", "6"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Yellow"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kNoise [-]\>\"", ",", "\"\<\[Delta]f [%]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<\!\(\*
StyleBox[\"statistical\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"zero\",
FontColor->RGBColor[1, 0, 1]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 1]]\)\!\(\*
StyleBox[\"crossing\",
FontColor->RGBColor[1, 0, 1]]\)\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plZC", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"errZeroCrossing", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Magenta"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kNoise [-]\>\"", ",", "\"\<\[Delta]f [%]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<\!\(\*
StyleBox[\"statistical\",
FontColor->RGBColor[1, 1, 0]]\)  \!\(\*
StyleBox[\"zero\",
FontColor->RGBColor[1, 0, 1]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 1]]\)\!\(\*
StyleBox[\"crossing\",
FontColor->RGBColor[1, 0, 1]]\)\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNase", ",", "plZC", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.75349837334375*^9, 3.7534983835*^9}, {
  3.7534984478125*^9, 3.75349845015625*^9}, {3.753582745375*^9, 
  3.75358282721875*^9}, {3.753582881015625*^9, 3.753583258359375*^9}}]
},
WindowSize->{1107, 639},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1449, 39, 167, "Input"],
Cell[1997, 61, 3659, 94, 431, "Input"],
Cell[5659, 157, 13005, 312, 1036, "Input"],
Cell[18667, 471, 3904, 84, 502, "Input"],
Cell[22574, 557, 6403, 160, 575, "Input"],
Cell[28980, 719, 3460, 88, 342, "Input"],
Cell[32443, 809, 3987, 97, 417, "Input"],
Cell[36433, 908, 1960, 53, 242, "Input"],
Cell[38396, 963, 1653, 38, 217, "Input"],
Cell[40052, 1003, 1093, 21, 41, "Input"],
Cell[41148, 1026, 3187, 80, 217, "Input"],
Cell[44338, 1108, 888, 26, 179, "Input"],
Cell[45229, 1136, 924, 26, 67, "Input"],
Cell[46156, 1164, 3373, 98, 267, "Input"]
}
]
*)

