(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     11398,        352]
NotebookOptionsPosition[     10596,        324]
NotebookOutlinePosition[     11069,        343]
CellTagsIndexPosition[     11026,        340]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{3.687588845295551*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ukazfazory", "[", "list_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", "0", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Im", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Hue", "[", ".2", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Im", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Hue", "[", "0.5", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Im", "[", 
              RowBox[{"list", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{"(", 
  RowBox[{
   RowBox[{"Unprotect", "[", "j", "]"}], ";", 
   RowBox[{"j", "=", "I"}], ";", 
   RowBox[{"Unprotect", "[", "Complex", "]"}], ";", 
   RowBox[{
    RowBox[{"Format", "[", 
     RowBox[{"Complex", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
    RowBox[{"x", "+", 
     RowBox[{"\"\<j\>\"", "y"}]}]}], ";", 
   RowBox[{"Protect", "[", 
    RowBox[{"j", ",", "Complex"}], "]"}], ";"}], ")"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"j", "*", "\[Omega]"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"j", "/", "3"}]}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "doscis", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"doscis", "[", "pom_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Omega]", "\[Rule]", "314"}], ",", 
     RowBox[{"L1", "\[Rule]", 
      RowBox[{"L0", "*", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["n1", "2"], ")"}], "2"]}]}], ",", 
     RowBox[{"M1", "\[Rule]", 
      RowBox[{"L0", "*", 
       FractionBox["n1", "2"]}]}], ",", 
     RowBox[{"M2", "\[Rule]", 
      RowBox[{"1", "L0", "*", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["n1", "2"], ")"}], "2"]}]}], ",", 
     RowBox[{"L2", "->", 
      RowBox[{"L0", "*", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"pom", "*", "n1"}], "2"], ")"}], "2"]}]}], ",", 
     RowBox[{"M3", "\[Rule]", 
      RowBox[{"L0", "*", 
       FractionBox[
        RowBox[{"pom", "*", "n1"}], "2"]}]}], ",", 
     RowBox[{"r1", "\[Rule]", "100"}], ",", 
     RowBox[{"r2", "\[Rule]", "r1"}], ",", 
     RowBox[{"rk", "\[Rule]", "10"}], ",", 
     RowBox[{"u", "\[Rule]", "100"}], ",", 
     RowBox[{"n1", "\[Rule]", "20"}], ",", 
     RowBox[{"L0", "\[Rule]", "0.01"}], ",", 
     RowBox[{"L3", "\[Rule]", "L0"}]}], "}"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rc1", "=", 
   RowBox[{"u1", "\[Equal]", 
    RowBox[{
     RowBox[{"r1", "*", "i1"}], "+", 
     RowBox[{"k", "*", "L1", "*", "i1"}], "+", 
     RowBox[{"M1", "*", "k", "*", "is1"}], "+", 
     RowBox[{"M2", "*", "k", "*", "i2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc2", "=", 
   RowBox[{"u2", "\[Equal]", 
    RowBox[{
     RowBox[{"r1", "*", "i2"}], "+", 
     RowBox[{"k", "*", "L1", "*", "i2"}], "+", 
     RowBox[{"M1", "*", "k", "*", "is1"}], "+", 
     RowBox[{"M2", "*", "k", "*", "i1"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc3", "=", 
   RowBox[{"u3", "\[Equal]", 
    RowBox[{
     RowBox[{"r2", "*", "i3"}], "+", 
     RowBox[{"k", "*", "L2", "*", "i3"}], "+", 
     RowBox[{"M3", "*", "k", "*", "is2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc4", "=", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"rk", "*", "is1"}], "+", 
     RowBox[{"L3", "*", "k", "*", "is1"}], "+", 
     RowBox[{"M1", "*", "k", "*", 
      RowBox[{"(", 
       RowBox[{"i1", "+", "i2"}], ")"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc5", "=", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"rk", "*", "is2"}], "+", 
     RowBox[{"L3", "*", "k", "*", "is2"}], "+", 
     RowBox[{"M3", "*", "k", "*", "i3"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc6", "=", 
   RowBox[{"i3", "\[Equal]", 
    RowBox[{"i1", "-", "i2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc7", "=", 
   RowBox[{
    RowBox[{"u1", "+", "u2"}], "\[Equal]", 
    RowBox[{"u", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "a"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rc8", "=", 
   RowBox[{
    RowBox[{"u1", "+", "u3"}], "\[Equal]", 
    RowBox[{"u", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"rce", ",", "vyr"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "pom_", "]"}], "=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rc1", ",", "rc2", ",", "rc3", ",", "rc4", ",", "rc5", ",", "rc6", ",", 
       "rc7", ",", "rc8"}], "}"}], "//.", 
     RowBox[{"doscis", "[", "pom", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rce", "[", "pom_", "]"}], ":=", 
   RowBox[{"vyr", "[", "pom", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"res", "[", "pom_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rce", "[", "pom", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitnes1", "[", "pom_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"Abs", "[", "is1", "]"}], "-", 
      RowBox[{"Abs", "[", "is2", "]"}]}], "]"}], "/.", 
    RowBox[{"res", "[", "pom", "]"}]}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"fitnes1", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"pomer1", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 SuperscriptBox["pomer1", "2"]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fitnes2", "[", "pom_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"Abs", "[", "i1", "]"}], "-", 
       RowBox[{"Abs", "[", "i2", "]"}]}], "]"}], "+", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"Abs", "[", "i1", "]"}], "-", 
       RowBox[{"Abs", "[", "i3", "]"}]}], "]"}], "+", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"Abs", "[", "i3", "]"}], "-", 
       RowBox[{"Abs", "[", "i2", "]"}]}], "]"}]}], "/.", 
    RowBox[{"res", "[", "pom", "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"fitnes2", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"pomer2", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 SuperscriptBox["pomer2", "2"]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"fazory", ",", "sekundar"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fazory", "[", "pom_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i1", ",", 
      RowBox[{"-", "i2"}], ",", 
      RowBox[{"-", "i3"}]}], "}"}], "/.", 
    RowBox[{"res", "[", "pom", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sekundar", "[", "pom_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"is1", ",", "is2"}], "}"}], "/.", 
    RowBox[{"res", "[", "pom", "]"}]}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"fazory", "[", "pomer1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Abs", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"fazory", "[", "pomer2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Abs", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"sekundar", "[", "pomer1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Abs", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"sekundar", "[", "pomer2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Abs", "[", "%", "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"ukazfazory", "[", 
  RowBox[{"fazory", "[", "pomer1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ukazfazory", "[", 
  RowBox[{"fazory", "[", "pomer2", "]"}], "]"}]}], "Input"]
},
WindowSize->{863, 537},
WindowMargins->{{41, Automatic}, {Automatic, 22}},
PrintingCopies->1,
PrintingPageRange->{2, 2},
PrintingOptions->{"PrintingMargins"->{{102, 54}, {72, 72}}},
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 291, 8, 58, "Input"],
Cell[851, 30, 1988, 53, 124, "Input"],
Cell[2842, 85, 684, 20, 102, "Input"],
Cell[3529, 107, 1316, 38, 151, "Input"],
Cell[4848, 147, 2550, 76, 280, "Input"],
Cell[7401, 225, 523, 16, 70, "Input"],
Cell[7927, 243, 372, 10, 97, "Input"],
Cell[8302, 255, 596, 18, 70, "Input"],
Cell[8901, 275, 372, 10, 97, "Input"],
Cell[9276, 287, 612, 19, 96, "Input"],
Cell[9891, 308, 493, 8, 227, "Input"],
Cell[10387, 318, 205, 4, 70, "Input"]
}
]
*)

(* End of internal cache information *)

