(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19827,        590]
NotebookOptionsPosition[     19389,        572]
NotebookOutlinePosition[     19790,        589]
CellTagsIndexPosition[     19747,        586]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "exp", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5423813896875*^9, 3.542381405328125*^9}, {
  3.542430900953125*^9, 3.542430902765625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "14"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"strmost", "=", 
   FractionBox["500.", "T"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"10", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"\[Omega]", "*", "t"}], "+", "0.234"}], "]"}]}], "+", 
    RowBox[{"1", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"5", "*", "\[Omega]", "*", "t"}], "+", "0.867"}], "]"}]}], "+", 
    RowBox[{"0.5", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"7", "*", "\[Omega]", "*", "t"}], "+", "0.867"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"4", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plUz", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"uz", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\<uz [V]\>\""}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"csj", "[", "j_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"j", ">", "1"}], ",", "0", ",", "Cosciloskop"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcej", "[", "j_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["iR", 
         RowBox[{"j", "+", "1"}]], "[", "t", "]"}], "+", 
       RowBox[{
        SubscriptBox["iCs", 
         RowBox[{"j", "+", "1"}]], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        SubscriptBox["iCz", "j"], "[", "t", "]"}], "+", 
       RowBox[{
        SubscriptBox["iR", "j"], "[", "t", "]"}], "+", 
       RowBox[{
        SubscriptBox["iCs", "j"], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["iCz", "j"], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"Cz", "*", 
       RowBox[{
        RowBox[{
         SubscriptBox["u", "j"], "'"}], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"R", "*", 
       RowBox[{
        SubscriptBox["iR", "j"], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{
       SubscriptBox["uCs", "j"], "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["iCs", "j"], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Cs", "+", 
         RowBox[{"csj", "[", "j", "]"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{
         SubscriptBox["uCs", "j"], "'"}], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["uCs", "j"], "[", "0", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"uz", "[", "0", "]"}], "n"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["uCs", "j"], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{
        SubscriptBox["u", "j"], "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["u", 
         RowBox[{"j", "-", "1"}]], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["u", "j"], "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox["j", "n"], "*", 
       RowBox[{"uz", "[", "0", "]"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rces", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"rcej", "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"konecVN", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["iCs", "n"], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["iR", "n"], "[", "t", "]"}], "*", "R"}], "\[Equal]", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["u", 
         RowBox[{"n", "-", "1"}]], "[", "t", "]"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcedohr", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"konecVN", ",", "rces"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"R", "\[Rule]", 
      RowBox[{"3", "*", 
       SuperscriptBox["10", "6"]}]}], ",", 
     RowBox[{"pF", "\[Rule]", 
      RowBox[{"1.", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]]}]}], ",", 
     RowBox[{"Cs", "\[Rule]", 
      RowBox[{"10", "pF"}]}], ",", 
     RowBox[{"Cz", "\[Rule]", 
      RowBox[{"2", "pF"}]}], ",", 
     RowBox[{"Cosciloskop", "\[Rule]", 
      RowBox[{"20", "pF"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["u", "0"], "[", "t", "]"}], "\[Rule]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosrce", "=", 
   RowBox[{"rcedohr", "//.", "dos"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"dosrce", ",", 
        RowBox[{
         SubscriptBox["_", "_"], "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", "Union"}], 
     ")"}], "/.", 
    RowBox[{
     RowBox[{"a_", "[", "t", "]"}], "\[RuleDelayed]", "a"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "Length"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"dosrce", ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tk", "=", "0.005"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"plUzAU1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"n", "*", 
         RowBox[{
          SubscriptBox["u", "1"], "[", "t", "]"}]}], "/.", "res"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "tk", "]"}], ",", "Red"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "tk", "]"}], ",", "Black"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\<\!\(\*
StyleBox[\"uz\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"V\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[1, 0, 0]]\)  \!\(\*
StyleBox[\"n\",
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[\"*\",
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[SubscriptBox[\"u\", \"1\"],
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[\" \",
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[\"[\",
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[\"V\",
FontColor->GrayLevel[0]]\)\!\(\*
StyleBox[\"]\",
FontColor->GrayLevel[0]]\)\>\""}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"exp", "[", "plUzAU1", "]"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.542381424015625*^9, 3.542382185890625*^9}, {
   3.542382224421875*^9, 3.54238228975*^9}, {3.542382328484375*^9, 
   3.542382396703125*^9}, {3.542382447296875*^9, 3.542382757140625*^9}, {
   3.542382866546875*^9, 3.54238286728125*^9}, {3.54238304359375*^9, 
   3.542383053875*^9}, {3.5423832529375*^9, 3.542383263484375*^9}, 
   3.542383312671875*^9, {3.542383350375*^9, 3.54238336290625*^9}, {
   3.542383412234375*^9, 3.542383444984375*^9}, {3.542383492125*^9, 
   3.542383500796875*^9}, {3.54238390584375*^9, 3.542383910765625*^9}, {
   3.542383953*^9, 3.542384027953125*^9}, {3.542384087140625*^9, 
   3.542384169953125*^9}, {3.542384201546875*^9, 3.542384320828125*^9}, {
   3.542384356640625*^9, 3.5423843784375*^9}, {3.54238445221875*^9, 
   3.542384505578125*^9}, {3.54238455953125*^9, 3.542384581984375*^9}, {
   3.542385232015625*^9, 3.542385308890625*^9}, {3.5423853718125*^9, 
   3.542385448125*^9}, {3.542385897921875*^9, 3.542386016234375*^9}, {
   3.542386113125*^9, 3.54238611903125*^9}, {3.54238621034375*^9, 
   3.542386214625*^9}, {3.542386461640625*^9, 3.542386466296875*^9}, {
   3.542390581140625*^9, 3.54239060821875*^9}, {3.542390683796875*^9, 
   3.542390702953125*^9}, {3.5423912655*^9, 3.542391283703125*^9}, {
   3.54239131571875*^9, 3.542391379265625*^9}, {3.542426156484375*^9, 
   3.54242624490625*^9}, 3.54242643259375*^9, 3.542429580828125*^9, 
   3.542430617375*^9, {3.542431412203125*^9, 3.542431420328125*^9}, {
   3.54243830453125*^9, 3.54243830475*^9}, 3.54244078459375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"iOrder", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nModel", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kSampleKuDat", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ndat", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "tmax", ",", 
     FractionBox["tmax", 
      RowBox[{"ndat", "-", "1."}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uzz", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"uz", "[", "#", "]"}]}], "}"}], "&"}], "/@", "rn"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "iOrder"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"un1", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{"n", "*", 
           RowBox[{
            SubscriptBox["u", "1"], "[", "#", "]"}]}], "/.", "res"}]}], "}"}],
        "&"}], "/@", "rn"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "iOrder"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nSample", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"kSampleKuDat", "*", "ndat"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnSample", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "tmax", ",", 
     FractionBox["tmax", 
      RowBox[{"nSample", "-", "1."}]]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datsUz", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"uz", "[", "#", "]"}]}], "}"}], "&"}], "/@", "rnSample"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datsUn1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"un1", "[", "#", "]"}]}], "}"}], "&"}], "/@", "rnSample"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"intUn1", ",", "intUz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"intUz", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"Derivative", "[", "n", "]"}], "[", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"datsUz", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "iOrder"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"samoUn1", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"datsUn1", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "iOrder"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"intUn1", "[", "n_Integer", "]"}], ":=", 
    RowBox[{
     RowBox[{"Derivative", "[", "n", "]"}], "[", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"datsUn1", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "iOrder"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"proms", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["derun", "#"], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "nModel", ",", "1"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dats", "[", "t_", "]"}], ":=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"intUn1", "[", "#", "]"}], "[", "t", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "nModel", ",", "1"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"intUz", "[", "0", "]"}], "[", "t", "]"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datFit", "=", 
   RowBox[{"dats", "/@", "rnSample"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fitik", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"datFit", ",", "proms", ",", "proms"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dalF", "=", 
   RowBox[{"fitik", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["derun", "a_"], "\[RuleDelayed]", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"un", "[", "t", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "a"}], "}"}]}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["deruz", "a_"], "\[RuleDelayed]", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"uZ", "[", "t", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "a"}], "}"}]}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uzzz", "[", "t_", "]"}], ":=", 
   RowBox[{"dalF", "/.", 
    RowBox[{"un", "->", "samoUn1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<uz[t]= \>\"", ",", "dalF"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5423861825625*^9, 3.5423861964375*^9}, {
   3.542386385375*^9, 3.542386412234375*^9}, {3.542386448734375*^9, 
   3.5423864500625*^9}, {3.542386504546875*^9, 3.54238687421875*^9}, {
   3.542386907875*^9, 3.5423870528125*^9}, {3.542387249078125*^9, 
   3.542387257328125*^9}, {3.5423873*^9, 3.5423873896875*^9}, {
   3.542387684453125*^9, 3.54238774825*^9}, 3.542388732421875*^9, 
   3.54238901409375*^9, {3.542389843078125*^9, 3.5423898480625*^9}, 
   3.542390888484375*^9, 3.54239104309375*^9, 3.542391098390625*^9, 
   3.54239114559375*^9, 3.54242981984375*^9, {3.542430790296875*^9, 
   3.542430845859375*^9}, {3.542431344796875*^9, 3.54243135128125*^9}, {
   3.542431442265625*^9, 3.542431449203125*^9}, {3.54243166740625*^9, 
   3.54243167921875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"100", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"uzz", "[", "t", "]"}], "-", 
         RowBox[{"uzzz", "[", "t", "]"}]}], ")"}]}], ",", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"uzz", "[", "t", "]"}], "-", 
        RowBox[{"samoUn1", "[", "t", "]"}]}], ")"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"0.05", "tmax"}], ",", 
      RowBox[{"0.5", "tmax"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "tk", "]"}], ",", "Red"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "tk", "]"}], ",", "Black"}], "}"}]}], 
      "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t [s]\>\"", ",", "\"\<uz-uzSpoctene [V]\>\""}], "}"}]}], 
    ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "0"}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotLegend", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<100*\[CapitalDelta]nase\>\"", ",", "\"\<\[CapitalDelta]\>\""}], 
      "}"}]}], ",", 
    RowBox[{"LegendPosition", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"13", "*", "tmax"}], ",", 
       RowBox[{"-", "0.5"}]}], "}"}]}], ",", " ", 
    RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.542430330625*^9, {3.54243046146875*^9, 3.54243052640625*^9}, {
   3.54243059009375*^9, 3.54243059075*^9}, {3.542430648890625*^9, 
   3.542430658234375*^9}, {3.542430696046875*^9, 3.54243073540625*^9}, {
   3.542430909296875*^9, 3.5424309333125*^9}, {3.542430993484375*^9, 
   3.542431054359375*^9}, {3.54243126090625*^9, 3.542431266390625*^9}, {
   3.542431696375*^9, 3.542431763890625*^9}, {3.542439390765625*^9, 
   3.542439421078125*^9}, 3.586081094046875*^9}]
},
WindowSize->{1145, 629},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1333, 38, 206, "Input"],
Cell[1881, 60, 9693, 282, 904, "Input"],
Cell[11577, 344, 5674, 168, 726, "Input"],
Cell[17254, 514, 2131, 56, 179, "Input"]
}
]
*)

(* End of internal cache information *)
