(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20315,        587]
NotebookOptionsPosition[     19456,        558]
NotebookOutlinePosition[     19859,        575]
CellTagsIndexPosition[     19816,        572]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.505321783390625*^9, 3.505321788078125*^9}, {
   3.60467097675*^9, 3.60467101234375*^9}, 3.60467289*^9, {
   3.6820718363175707`*^9, 3.6820718445831957`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", "*", "x"}], "+", "c"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vyr", "[", "x0", "]"}], "\[Equal]", "f0"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "+", "dx"}], "]"}], "\[Equal]", "fplus1"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "-", "dx"}], "]"}], "\[Equal]", "fminus1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"integrand", "=", 
   RowBox[{
    RowBox[{"vyr", "[", "x", "]"}], "/.", "res"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"intNormal", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", "dx"}], ",", 
      RowBox[{"x0", "+", "dx"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.682679477296875*^9, 3.682679644734375*^9}, {
  3.682679678140625*^9, 3.682679679234375*^9}}],

Cell[BoxData[
 RowBox[{"intNewVlevo", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", 
       RowBox[{
        FractionBox["3", "2"], "dx"}]}], ",", 
      RowBox[{"x0", "+", "dx"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.682679692390625*^9, 3.682679701328125*^9}, {
  3.682680025609375*^9, 3.682680026640625*^9}}],

Cell[BoxData[
 RowBox[{"intNewVlevo", "-", "intNormal"}]], "Input",
 CellChangeTimes->{{3.682679716234375*^9, 3.682679721734375*^9}, {
  3.682680031875*^9, 3.682680054109375*^9}}],

Cell[BoxData[
 RowBox[{"plusVahyVlevo", "=", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["17", "24"], ",", 
    FractionBox[
     RowBox[{"-", "7"}], "24"], ",", 
    FractionBox["1", "12"]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.682679757421875*^9, 3.682679825203125*^9}, {
  3.682680057671875*^9, 3.682680058734375*^9}}],

Cell[BoxData[
 RowBox[{"intNewVpravo", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", "dx"}], ",", 
      RowBox[{"x0", "+", 
       RowBox[{
        FractionBox["3", "2"], "dx"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.682680071796875*^9, 3.68268008875*^9}}],

Cell[BoxData[
 RowBox[{"intNewVpravo", "-", "intNormal"}]], "Input",
 CellChangeTimes->{{3.682680104390625*^9, 3.68268010484375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plusVahyVpravo", "=", 
     RowBox[{"Reverse", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["17", "24"], ",", 
        FractionBox[
         RowBox[{"-", "7"}], "24"], ",", 
        FractionBox["1", "12"]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plusVahyVpravo", "\[Equal]", 
    RowBox[{"Reverse", "[", "plusVahyVlevo", "]"}]}], "\[IndentingNewLine]", 
   "plusVahyVpravo"}]}]], "Input",
 CellChangeTimes->{{3.68268012221875*^9, 3.682680221625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vahyOld", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "3"], 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], ",", 
      "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vahyOld", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaVahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldVahy", ",", "nVah"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"oldVahy", "=", 
       RowBox[{"vahyOld", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nVah", "=", 
       RowBox[{"Length", "[", "oldVahy", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"plusVahyVlevo", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0", "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"nVah", "-", "6"}], "]"}]}], ")"}], ",", 
        "plusVahyVpravo"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"deltaVahy", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"vahyOld", "[", "n", "]"}], "+", 
    RowBox[{"deltaVahy", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vahy", "[", "5", "]"}]}], "Input",
 CellChangeTimes->{{3.6826798970625*^9, 3.6826799564375*^9}, {
  3.68267999259375*^9, 3.68267999940625*^9}, {3.6826802885*^9, 
  3.682680427921875*^9}, {3.682680475484375*^9, 3.68268055690625*^9}, {
  3.682682437390625*^9, 3.682682439359375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "ukazkove", " ", "pouziti", " ", "pro", " ", "zjisteni", " ", 
    "amplitudy"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sr", "=", "1000"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "kolik", " ", "samplu", " ", "ODPOVIDA", " ", "jedne", " ", "sekunde"}], 
     ",", " ", 
     RowBox[{"jsou", " ", "to", " ", "ale", " ", "vnitrni", " ", "samply"}]}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "a", " ", "ted", " ", "to", " ", "chosi", " ", "nufozne", " ", "i", " ", 
     "pro", " ", "male", " ", "sr"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", 
     FractionBox["1", "sr"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", 
     FractionBox["sr", "171"]}], 
    RowBox[{"(*", 
     RowBox[{
     "jmenovatel", " ", "liche", " ", "cislo", " ", "musi", " ", "byt"}], 
     "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sampluNaPeriodu", "=", 
     FractionBox["T", "dt"]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.682680835875*^9, 3.682681101984375*^9}, {
   3.682681163296875*^9, 3.682681261703125*^9}, {3.682681302640625*^9, 
   3.682681310453125*^9}, {3.68268141225*^9, 3.682681423734375*^9}, {
   3.68268147190625*^9, 3.68268153215625*^9}, {3.68268162078125*^9, 
   3.682681688*^9}, {3.682681730453125*^9, 3.682681797125*^9}, {
   3.68268182890625*^9, 3.6826818575*^9}, {3.68268194740625*^9, 
   3.68268194759375*^9}, 3.68268197934375*^9, {3.68268203828125*^9, 
   3.682682100703125*^9}, {3.682682236125*^9, 3.682682250484375*^9}, {
   3.682682717875*^9, 3.682682740921875*^9}, {3.682683074875*^9, 
   3.6826830856875*^9}, {3.682683170171875*^9, 3.682683203359375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"signalfce", "[", "t_", "]"}], ":=", 
   RowBox[{"1", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"2.", "*", "Pi", "*", "f", "*", "t"}], "+", "0.642"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabSin", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2.", "Pi", "*", "f", "*", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"T", "-", "dt"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabCos", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2.", "Pi", "*", "f", "*", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"T", "-", "dt"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPeriod", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"signal", "=", 
   RowBox[{"signalfce", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"nPeriod", "*", "T"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "ListPlot"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejAmplitdu", "[", "k_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dats", ",", "vazky", ",", "nProVahy", ",", "intSin", ",", "intCos"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dats", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"signal", ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"k", "+", "sampluNaPeriodu", "-", "1"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nProVahy", "[", "i_Integer", "]"}], ":=", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", "i"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vazky", "=", 
       RowBox[{
        RowBox[{"vahy", "@", 
         RowBox[{"nProVahy", "[", "sampluNaPeriodu", "]"}]}], "//", "N"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"intSin", "=", 
       RowBox[{"dt", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"tabSin", "*", "dats"}], ")"}], ".", "vazky"}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"intCos", "=", 
       RowBox[{"dt", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"tabCos", "*", "dats"}], ")"}], ".", "vazky"}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       FractionBox["2", "T"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"I", "*", "intCos"}], "+", "intSin"}], ")"}]}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejAmplitdu", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Abs"}]}], "Input",
 CellChangeTimes->{{3.682680835875*^9, 3.682681101984375*^9}, {
   3.682681163296875*^9, 3.682681261703125*^9}, {3.682681302640625*^9, 
   3.682681310453125*^9}, {3.68268141225*^9, 3.682681423734375*^9}, {
   3.68268147190625*^9, 3.68268153215625*^9}, {3.68268162078125*^9, 
   3.682681688*^9}, {3.682681730453125*^9, 3.682681797125*^9}, {
   3.68268182890625*^9, 3.68268185571875*^9}, {3.6826822763125*^9, 
   3.682682299109375*^9}, {3.6826823400625*^9, 3.68268235221875*^9}, {
   3.68268247378125*^9, 3.682682573640625*^9}, {3.682682607078125*^9, 
   3.682682618359375*^9}, {3.682682683828125*^9, 3.682682713015625*^9}, 
   3.682683164203125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnd", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kNoise", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"signalPeriodical", "[", "t_", "]"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["rnd", 
         RowBox[{
          SuperscriptBox["i", "2"], "+", "1"}]], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["rnd", 
         RowBox[{
          SuperscriptBox["i", "2"], "+", "1"}]], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"signalPeriodical", "[", "t_", "]"}], "=", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", "*", "2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"7", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"5", "*", "2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      "5.6"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"signalPeriodical", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noise", ":=", 
   RowBox[{"kNoise", "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68758352684375*^9, 3.68758374578125*^9}, {
   3.68758378496875*^9, 3.687583816125*^9}, 3.68758398015625*^9, {
   3.68758412925*^9, 3.68758413190625*^9}, {3.687584166703125*^9, 
   3.687584216953125*^9}, {3.687584262640625*^9, 3.687584281390625*^9}, {
   3.687585011420551*^9, 3.687585029701801*^9}, 3.687585113983051*^9, {
   3.6875858660611763`*^9, 3.6875859519049263`*^9}, 3.687586025889301*^9, {
   3.6875862256549263`*^9, 3.6875862837174263`*^9}, {3.6875863452486763`*^9, 
   3.687586345326801*^9}, 3.687586531920551*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sr", "=", "4000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dt", "=", 
   FractionBox["1.", "sr"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"signalPeriodical", "[", "#", "]"}], "+", "noise"}]}], "}"}], 
     "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "T"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", "data", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intData", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"intData", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "T"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "T"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"intData", "[", "t", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}], "/;", 
    RowBox[{"i", "\[Equal]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "T"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"intData", "[", "t", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}], "/;", 
    RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "i_", "]"}], ":=", 
   RowBox[{
    FractionBox["2", "T"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"intData", "[", "t", "]"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6875840055*^9, 3.687584115515625*^9}, 
   3.687584153984375*^9, 3.68758434115625*^9, {3.68758437253125*^9, 
   3.6875844140299263`*^9}, {3.687584563295551*^9, 3.687584615295551*^9}, {
   3.6875847817799263`*^9, 3.6875848208424263`*^9}, {3.6875848631861763`*^9, 
   3.687584914983051*^9}, {3.687584963233051*^9, 3.687584966545551*^9}, {
   3.687585442920551*^9, 3.687585491733051*^9}, {3.6875855400924263`*^9, 
   3.6875855440924263`*^9}, 3.6875856686236763`*^9, 3.6875857094986763`*^9, 
   3.687585811420551*^9, 3.6875858607799263`*^9, {3.6875860625924263`*^9, 
   3.687586120545551*^9}, 3.687586209983051*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"periodicalReconstruction", "[", "t_", "]"}], "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "0"}], "n"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "i", "]"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"b", "[", "i", "]"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}]}], 
       ")"}]}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6875863816236763`*^9, 3.687586420608051*^9}, {
  3.687586488889301*^9, 3.6875864951861763`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"periodicalReconstruction", "[", "t", "]"}], "-", 
    RowBox[{"signalPeriodical", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "T"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6875864333424263`*^9, 3.687586462639301*^9}, {
  3.687586511514301*^9, 3.687586512139301*^9}}]
},
WindowSize->{1042, 694},
WindowMargins->{{18, Automatic}, {Automatic, 11}},
ShowSelection->True,
Magnification->1.6999993324279785`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 513, 13, 107, "Input"],
Cell[1073, 35, 1368, 42, 167, "Input"],
Cell[2444, 79, 411, 11, 75, "Input"],
Cell[2858, 92, 179, 3, 48, "Input"],
Cell[3040, 97, 327, 9, 75, "Input"],
Cell[3370, 108, 359, 10, 75, "Input"],
Cell[3732, 120, 133, 2, 48, "Input"],
Cell[3868, 124, 575, 16, 166, "Input"],
Cell[4446, 142, 2052, 55, 369, "Input"],
Cell[6501, 199, 1866, 45, 364, "Input"],
Cell[8370, 246, 3685, 102, 632, "Input"],
Cell[12058, 350, 3045, 82, 502, "Input"],
Cell[15106, 434, 3127, 86, 430, "Input"],
Cell[18236, 522, 764, 21, 120, "Input"],
Cell[19003, 545, 449, 11, 78, "Input"]
}
]
*)

(* End of internal cache information *)
