(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9020,        288]
NotebookOptionsPosition[      8150,        259]
NotebookOutlinePosition[      8527,        275]
CellTagsIndexPosition[      8484,        272]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costCoefficients", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "0.1", ",", "0.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "0.15", ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "0.08", ",", "0.006"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minMaxPowers", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "1000"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482721896609375*^9, 3.482722028265625*^9}, {
  3.4827221586875*^9, 3.48272216184375*^9}, {3.688282390202379*^9, 
  3.688282403805603*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fCost", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", "power"}], "+", 
    RowBox[{"c", "*", 
     SuperscriptBox["power", "2"]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6882824195772305`*^9, 3.688282420778433*^9}, {
  3.6882824978581686`*^9, 3.6882825041449795`*^9}, {3.688282570959897*^9, 
  3.6882825924255342`*^9}}],

Cell[BoxData[
 RowBox[{"fCost", "[", 
  RowBox[{"P", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6882825204158077`*^9, 3.6882825290270233`*^9}, 
   3.688282596060341*^9}],

Cell[BoxData[{
 RowBox[{"powers", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["P", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "n", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"cost", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"MapThread", "[", 
    RowBox[{"fCost", ",", 
     RowBox[{"{", 
      RowBox[{"powers", ",", "costCoefficients"}], "}"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.688282620068783*^9, 3.688282641799621*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fPowerConstrains", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "\[LessEqual]", "power", "\[LessEqual]", "b"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"powerConstrains", "=", 
  RowBox[{"MapThread", "[", 
   RowBox[{"fPowerConstrains", ",", 
    RowBox[{"{", 
     RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.688282714136948*^9, 3.688282748129408*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"desiredPower", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"conditionOfDesiredPower", "=", 
  RowBox[{"{", 
   RowBox[{"desiredPower", "\[Equal]", 
    RowBox[{"Plus", "@@", "powers"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.6882827763654575`*^9, 3.6882828010447006`*^9}}],

Cell[BoxData[
 RowBox[{"condionsTogether", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"powerConstrains", ",", "conditionOfDesiredPower"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.68828286884242*^9, 3.6882828998240747`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cost", "}"}], ",", "condionsTogether"}], "]"}], ",", 
    "powers"}], "]"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.6882829451694756`*^9, 3.688282980232481*^9}}],

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", "cost", "}"}], ",", "condionsTogether"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1.5"}], ")"}], "2"], "*", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], "*", "300"}], "]"}], "-", 
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "2"}], ")"}], "*", "300"}], "]"}]}], ")"}]}], 
     ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.688283433554619*^9, 3.6882834555350575`*^9}, {
  3.6882835089339514`*^9, 3.6882835545640316`*^9}, {3.6882836047961197`*^9, 
  3.688283620224547*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"slope", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "fPenale", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fPenale", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Tanh", "[", 
           RowBox[{"slope", "*", 
            RowBox[{"(", 
             RowBox[{"x", "-", "a"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"slope", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "b"}], ")"}]}], "]"}]}], ")"}]}], ")"}], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], "2"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fPenale", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<penale\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68828309001176*^9, 3.68828312480375*^9}, {
  3.688283657165412*^9, 3.6882836609718184`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaltyTotalPower", "=", 
   RowBox[{"100", "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"desiredPower", "-", 
       RowBox[{"Plus", "@@", "powers"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"penaltyPossiblePowers", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"MapThread", "[", 
     RowBox[{"fPenale", ",", 
      RowBox[{"{", 
       RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.6882836719074373`*^9, 3.6882837522475786`*^9}}],

Cell[BoxData["penaltyTotalPower"], "Input"],

Cell[BoxData[
 RowBox[{"Fmin", "=", 
  RowBox[{
  "cost", "+", "penaltyTotalPower", "+", "penaltyPossiblePowers"}]}]], "Input",
 CellChangeTimes->{{3.688283850808552*^9, 3.688283864739376*^9}}],

Cell[BoxData[{
 RowBox[{"startOfTheSearch", "=", 
  RowBox[{"minMaxPowers", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{"a", "+", "b"}], "2."]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"start", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{"powers", ",", "startOfTheSearch"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"Fmin", ",", "start"}], "]"}]}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.6882839075302515`*^9, 3.6882839105098567`*^9}, {
  3.6882839488079243`*^9, 3.688283988603594*^9}}]
},
WindowSize->{1264, 889},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->2.499999761581421,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 94, 2, 103, "Input"],
Cell[654, 24, 897, 26, 284, "Input"],
Cell[1554, 52, 488, 13, 106, "Input"],
Cell[2045, 67, 236, 6, 103, "Input"],
Cell[2284, 75, 446, 13, 194, "Input"],
Cell[2733, 90, 534, 14, 194, "Input"],
Cell[3270, 106, 323, 7, 194, "Input"],
Cell[3596, 115, 227, 5, 149, "Input"],
Cell[3826, 122, 297, 8, 149, "Input"],
Cell[4126, 132, 122, 3, 103, "Input"],
Cell[4251, 137, 792, 24, 207, InheritFromParent],
Cell[5046, 163, 1605, 47, 468, "Input"],
Cell[6654, 212, 571, 17, 198, "Input"],
Cell[7228, 231, 43, 0, 103, "Input"],
Cell[7274, 233, 193, 4, 103, "Input"],
Cell[7470, 239, 676, 18, 237, "Input"]
}
]
*)

(* End of internal cache information *)
