(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14655,        438]
NotebookOptionsPosition[     14178,        419]
NotebookOutlinePosition[     14578,        436]
CellTagsIndexPosition[     14535,        433]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "PhysicalConstants`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", ":=", 
   RowBox[{
    SubscriptBox["\[Alpha]", "#"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"params", ":=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", 
       SubscriptBox["\[Alpha]", "_"], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], "&"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.543046981734375*^9, 3.54304699184375*^9}, {
  3.543212964625*^9, 3.5432129825*^9}, {3.54321303353125*^9, 
  3.543213034125*^9}, {3.543213786234375*^9, 3.543213786796875*^9}, {
  3.543326690078125*^9, 3.543326692265625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"(", GridBox[{
      {"22.4", "189.94", "180.65", "192.06"},
      {"38.6", "159.95", "150.57", "162.07"},
      {"56.1", "127.14", "117.71", "129.26"},
      {"83.8", "77.27", "68.3", "79.17"},
      {"120.1", "26.71", "21.53", "27.84"},
      {"149.3", "8.543", "6.596", "9.029"},
      {"155", "6.79", "5.194", "7.116"},
      {"156.3", "6.44", "4.93", "6.76"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TKelv", "=", "273.15"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"dats", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"T_", ",", "u1_", ",", "u2_", ",", "u3_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", "+", "TKelv"}], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "u1"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d2", "=", 
   RowBox[{"dats", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"T_", ",", "u1_", ",", "u2_", ",", "u3_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", "+", "TKelv"}], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "u2"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d3", "=", 
   RowBox[{"dats", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"T_", ",", "u1_", ",", "u2_", ",", "u3_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", "+", "TKelv"}], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "u3"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lpl", "[", 
    RowBox[{"co_", ",", "hue_", ",", "plotLabel_"}], "]"}], ":=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"co", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<T (K)\>\"", ",", "\"\<uD (V)\>\""}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"22", "+", "TKelv"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Hue", "[", "hue", "]"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "plotLabel"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lpl", "[", 
   RowBox[{"d1", ",", "0", ",", "\"\<u D 1\>\""}], "]"}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5432130465*^9, 3.54321313021875*^9}, {
  3.543213179453125*^9, 3.543213326421875*^9}, {3.54321337465625*^9, 
  3.543213639328125*^9}, {3.543214017078125*^9, 3.54321403840625*^9}, {
  3.54332768203125*^9, 3.543327711203125*^9}, {3.543327841796875*^9, 
  3.54332787203125*^9}, {3.54332790746875*^9, 3.543327917859375*^9}, {
  3.543328039484375*^9, 3.54332806978125*^9}, {3.543331111828125*^9, 
  3.543331182390625*^9}, {3.543331249703125*^9, 3.543331284875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"set", "=", "d3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"ElectronCharge", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"BoltzmannConstant", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "model", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{
    RowBox[{"v", "[", "1", "]"}], "*", 
    SuperscriptBox["T", "2"], "*", 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{"v", "[", "2", "]"}], "T"], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Exp", "[", 
       FractionBox[
        RowBox[{"e", "*", "u"}], 
        RowBox[{"k", "*", "T"}]], "]"}], "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mA", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iConst", "=", 
   RowBox[{"6.42", "mA"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"datSchot", "[", 
    RowBox[{"a", ":", 
     RowBox[{"{", 
      RowBox[{"T_", ",", "u_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Join", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "iConst", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datModel", "=", 
   RowBox[{"datSchot", "/@", "set"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nalfit", "=", 
   RowBox[{
    RowBox[{"FindFit", "[", 
     RowBox[{"datModel", ",", "model", ",", 
      RowBox[{"params", "[", "model", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "u"}], "}"}], ",", 
      RowBox[{"MaxIterations", "\[Rule]", 
       SuperscriptBox["10", "3"]}]}], "]"}], "//", "Quiet"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "proreseni", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"proreseni", "[", "T_", "]"}], "=", 
   RowBox[{"model", "/.", "nalfit"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "[", "T_", "]"}], ":=", 
  RowBox[{"u", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"proreseni", "[", "T", "]"}], "\[Equal]", "iConst"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"20", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]]}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datsRes", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"u", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"22", "+", "TKelv"}], ",", 
      RowBox[{"220", "+", "TKelv"}], ",", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datsResMT", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"22", "+", "TKelv"}], ",", 
      RowBox[{"220", "+", "TKelv"}], ",", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"merT", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"datsRes", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"merTMT", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"datsResMT", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"merT", "[", "T", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", 
       RowBox[{"22.4", "+", "TKelv"}], ",", 
       RowBox[{"220", "+", "TKelv"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pll", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"lpl", "[", 
      RowBox[{"set", ",", "0", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"params", "[", "model", "]"}], "/.", "nalfit"}], "]"}]}], 
      "]"}], ",", "pl2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"struct", "=", 
    RowBox[{"{", 
     RowBox[{"set", ",", "nalfit", ",", 
      RowBox[{"proreseni", "[", "T", "]"}], ",", "merTMT", ",", "pll"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"struct", ">>", "\"\<struct3\>\""}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.543326703203125*^9, 3.543326979796875*^9}, {
   3.543327046078125*^9, 3.54332705778125*^9}, {3.543327093265625*^9, 
   3.54332723665625*^9}, {3.54332726784375*^9, 3.543327288046875*^9}, 
   3.543327738765625*^9, {3.543327775*^9, 3.543327822828125*^9}, 
   3.54332810503125*^9, {3.54332814171875*^9, 3.54332815134375*^9}, 
   3.543328219296875*^9, 3.54332828915625*^9, {3.543328541765625*^9, 
   3.54332855209375*^9}, 3.543328993125*^9, {3.543329035390625*^9, 
   3.54332913790625*^9}, {3.543329182625*^9, 3.543329244078125*^9}, 
   3.543329302890625*^9, {3.54332933490625*^9, 3.543329362203125*^9}, {
   3.543329392390625*^9, 3.54332939346875*^9}, {3.543331224140625*^9, 
   3.5433312410625*^9}, {3.54333130875*^9, 3.5433313296875*^9}, {
   3.54333137003125*^9, 3.543331394234375*^9}, {3.543331433234375*^9, 
   3.543331462625*^9}, {3.543331530828125*^9, 3.54333166475*^9}, {
   3.543332743484375*^9, 3.54333282525*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"structs", "=", 
   RowBox[{"Get", "/@", 
    RowBox[{"{", 
     RowBox[{
     "\"\<struct1\>\"", ",", "\"\<struct2\>\"", ",", "\"\<struct3\>\""}], 
     "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obrs", "=", 
   RowBox[{"GraphicsArray", "[", 
    RowBox[{"structs", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "set_", ",", "nalfit_", ",", "pror_", ",", "merT_", ",", "pll_"}], 
       "}"}], "\[RuleDelayed]", "pll"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"merTs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Part", "[", 
      RowBox[{"#", ",", 
       RowBox[{"-", "2"}]}], "]"}], "&"}], "/@", "structs"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "tepls", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tepls", "[", "uus_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "TKelv"}], "+", 
      RowBox[{
       RowBox[{"merTs", "[", 
        RowBox[{"[", "#", "]"}], "]"}], "[", 
       RowBox[{"uus", "[", 
        RowBox[{"[", "#", "]"}], "]"}], "]"}]}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "uus", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.543331670875*^9, 3.543331790171875*^9}, {
   3.543331875140625*^9, 3.54333187553125*^9}, {3.543331912734375*^9, 
   3.54333191665625*^9}, 3.54333206528125*^9, {3.543332547609375*^9, 
   3.5433325590625*^9}, {3.543332653140625*^9, 3.5433327088125*^9}, {
   3.543332911265625*^9, 3.543333109484375*^9}, {3.543333155203125*^9, 
   3.543333278875*^9}, {3.5433334726875*^9, 3.543333473015625*^9}, {
   3.54333359125*^9, 3.54333359171875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datsVys", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6.3", ",", 
        RowBox[{"{", 
         RowBox[{"5.8", ",", "2.8", ",", "5.3"}], "}"}], ",", "121"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"8.35", ",", 
        RowBox[{"{", 
         RowBox[{"2.3", ",", "0.9", ",", "1.8"}], "}"}], ",", "135"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"10.44", ",", 
        RowBox[{"{", 
         RowBox[{"1.1", ",", "0.54", ",", "0.75"}], "}"}], ",", "148.7"}], 
       "}"}]}], "}"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i_", "?", "NumberQ"}], ",", "naps_", ",", "Tcels_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "*", "naps"}], ",", 
       RowBox[{"Tcels", "+", "TKelv"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"iToTpr", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i_", "?", "NumberQ"}], ",", "naps_", ",", "T_"}], "}"}], "]"}],
    ":=", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"tepls", "[", "naps", "]"}], ",", 
     RowBox[{"T", "-", "TKelv"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", "obrs", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iToTpr", "/@", "datsVys"}], "//", "Grid"}]}], "Input",
 CellChangeTimes->{{3.543332081*^9, 3.543332086640625*^9}, {
  3.54333213040625*^9, 3.543332261890625*^9}, {3.543332302046875*^9, 
  3.543332318828125*^9}, {3.543332398578125*^9, 3.543332532390625*^9}, {
  3.5433333094375*^9, 3.54333343278125*^9}, {3.54333350425*^9, 
  3.54333350615625*^9}}]
},
WindowSize->{872, 759},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1788, 51, 272, "Input"],
Cell[2336, 73, 2976, 85, 523, "Input"],
Cell[5315, 160, 5425, 154, 760, "Input"],
Cell[10743, 316, 1716, 48, 215, "Input"],
Cell[12462, 366, 1712, 51, 219, "Input"]
}
]
*)

(* End of internal cache information *)
