(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9586,        304]
NotebookOptionsPosition[      9150,        286]
NotebookOutlinePosition[      9531,        302]
CellTagsIndexPosition[      9488,        299]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"proklad", " ", "obrazku"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dat1", "=", 
     RowBox[{"Import", "[", "\"\<dataUloha10.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vyr", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{
       RowBox[{"dat1", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"a", ",", 
           FractionBox["1", "b"]}], "}"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["t", "#"], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "4", ",", "1"}], "]"}]}], ",", "t"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      FractionBox["1", "vyr"], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.689564222796875*^9, 3.68956443071875*^9}, {
  3.689564469859375*^9, 3.689564477375*^9}, {3.689564605296875*^9, 
  3.68956460728125*^9}, {3.68956469059375*^9, 3.689564716390625*^9}, {
  3.689564931484375*^9, 3.68956493859375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"vykon", " ", "na", " ", "diode"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"iD", "[", "uD_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"19", "uD"}], "]"}], "-", "1."}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"iD", "[", "u", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "0.1"}], ",", "1."}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datInv", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"iD", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1", ",", "0.01"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uD", "=", 
     RowBox[{"Interpolation", "[", "datInv", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2.", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"idioda", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Omega]", "*", "t"}], "]"}]}], "/;", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Omega]", "*", "t"}], "]"}], "\[GreaterEqual]", "0"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"idioda", "[", "t_", "]"}], ":=", 
     RowBox[{"0", "/;", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Omega]", "*", "t"}], "]"}], "<", "0"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"idioda", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{
         RowBox[{"-", "0.1"}], "T"}], ",", 
        RowBox[{"1.6", "T"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<iD [A]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"uD", "[", 
       RowBox[{"idioda", "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{
         RowBox[{"-", "0.1"}], "T"}], ",", 
        RowBox[{"1.6", "T"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<uD [V]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"uD", "[", 
        RowBox[{"idioda", "[", "t", "]"}], "]"}], "*", 
       RowBox[{"idioda", "[", "t", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{
         RowBox[{"-", "0.1"}], "T"}], ",", 
        RowBox[{"1.6", "T"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t [s]\>\"", ",", "\"\<p [W]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Quiet", "@", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "T"], 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"uD", "[", 
            RowBox[{"idioda", "[", "t", "]"}], "]"}], "*", 
           RowBox[{"idioda", "[", "t", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}], ")"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<P= \>\"", ",", "P", ",", "\"\< W\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6895649454375*^9, 3.689565432453125*^9}, {
  3.689565484328125*^9, 3.689565520921875*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"minimum", " ", "ztrat"}], "*)"}]], "Input",
 CellChangeTimes->{{3.689565535625*^9, 3.68956554034375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Rv1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mH", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lv1", "=", 
   RowBox[{"3", "mH"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rv2", "=", 
   RowBox[{"0.2", "Rv1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lv2", "=", 
   RowBox[{"0.2", "Lv1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lz", "=", 
   RowBox[{"300", "mH"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rz", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", "230."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"U", "-", "Uu"}], 
      RowBox[{
       RowBox[{"I", "*", "\[Omega]", "*", "Lv1"}], "+", "Rv1"}]], "\[Equal]", 
     RowBox[{
      FractionBox["Uu", 
       RowBox[{"I", "*", "\[Omega]", "*", "Lz"}]], "+", 
      FractionBox["Uu", "Rz"], "+", 
      FractionBox["Uu", 
       RowBox[{
        RowBox[{"I", "*", "\[Omega]", "*", "Lv2"}], "+", "Rv2", "+", 
        FractionBox["1", 
         RowBox[{"I", "*", "\[Omega]", "*", "c"}]]}]]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosUu", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"eqns", ",", "Uu"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"forMin", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Rv1", "*", 
      SuperscriptBox[
       RowBox[{"Abs", "[", 
        FractionBox[
         RowBox[{"U", "-", "Uu"}], 
         RowBox[{
          RowBox[{"I", "*", "\[Omega]", "*", "Lv1"}], "+", "Rv1"}]], "]"}], 
       "2"]}], "+", 
     RowBox[{"Rv2", "*", 
      SuperscriptBox[
       RowBox[{"Abs", "[", 
        FractionBox["Uu", 
         RowBox[{
          RowBox[{"I", "*", "\[Omega]", "*", "Lv2"}], "+", "Rv2", "+", 
          FractionBox["1", 
           RowBox[{"I", "*", "\[Omega]", "*", "c"}]]}]], "]"}], "2"]}]}], "/.",
     "dosUu"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindMinimum", "[", 
  RowBox[{"forMin", ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.689565582078125*^9, 3.689565649171875*^9}, {
  3.689565684453125*^9, 3.689565966921875*^9}}]
},
WindowSize->{1051, 778},
WindowMargins->{{11, Automatic}, {Automatic, 5}},
Magnification->1.7000001668930054`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 330, 9, 107, "Input"],
Cell[891, 31, 1343, 38, 231, "Input"],
Cell[2237, 71, 4327, 131, 603, "Input"],
Cell[6567, 204, 146, 3, 48, "Input"],
Cell[6716, 209, 2430, 75, 500, "Input"]
}
]
*)

