(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10664,        335]
NotebookOptionsPosition[     10138,        315]
NotebookOutlinePosition[     10517,        331]
CellTagsIndexPosition[     10474,        328]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"General", "::", "\"\<obspkg\>\""}], ",", 
   RowBox[{"General", "::", "\"\<spell1\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5129589200625*^9, 3.512958922*^9}, {3.5129597564375*^9, 
  3.51295977615625*^9}}],

Cell[BoxData[{
 RowBox[{"<<", "Graphics`ImplicitPlot`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"2", "x", "*", "y"}], "-", "36"}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["y", "2"], "-", 
     RowBox[{"2", "x", "*", "y"}], "-", "36"}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rang", "=", "9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{"rce1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{"rce2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.5", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"p1", ",", "p2", ",", 
    RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.512958872109375*^9, 3.51295887234375*^9}, {
  3.512959760703125*^9, 3.51295977890625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"StartPoint", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.8"}], ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TecnaRovina", "[", 
    RowBox[{"rce_", ",", 
     RowBox[{"{", 
      RowBox[{"x0_", ",", "y0_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rce", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "x0"}], ",", 
         RowBox[{"y", "\[Rule]", "y0"}]}], "}"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rce", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "y"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "x0"}], ",", 
         RowBox[{"y", "\[Rule]", "y0"}]}], "}"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"y", "-", "y0"}], ")"}]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"rce", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "x0"}], ",", 
        RowBox[{"y", "\[Rule]", "y0"}]}], "}"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tisk", "[", 
    RowBox[{"rce_", ",", "bod_"}], "]"}], ":=", 
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TecnaRovina", "[", 
       RowBox[{"rce", ",", "bod"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ZobrazBod", "[", "bod_", "]"}], ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hue", "[", "0.23", "]"}], ",", 
     RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
     RowBox[{"Point", "[", "bod", "]"}]}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.512958953015625*^9, 3.512959026515625*^9}, 
   3.512959515359375*^9, 3.512959654125*^9, {3.5129596885*^9, 
   3.512959688734375*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"tisk", "[", 
    RowBox[{"rce2", ",", "StartPoint"}], "]"}], ",", 
   RowBox[{"tisk", "[", 
    RowBox[{"rce1", ",", "StartPoint"}], "]"}], ",", "p1", ",", "p2", ",", 
   RowBox[{"ZobrazBod", "[", "StartPoint", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512958853828125*^9, 3.512958862546875*^9}, {
  3.512959540125*^9, 3.51295954690625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NewtonianStep", "[", "bod_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"TecnaRovina", "[", 
          RowBox[{"rce1", ",", "bod"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"TecnaRovina", "[", 
          RowBox[{"rce2", ",", "bod"}], "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nSteps", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StartPoint", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "20."}], ",", 
     RowBox[{"+", "20."}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CestaBodu", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"NewtonianStep", ",", "StartPoint", ",", "nSteps"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"CestaBodu", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "rang"}], ",", "rang"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ExactRoots", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{"{", 
      RowBox[{"rce1", ",", "rce2"}], "}"}], "]"}]}], "//", 
   "N"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "body"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.51295883390625*^9, {3.512959131796875*^9, 3.512959185484375*^9}, {
   3.51295922521875*^9, 3.51295923121875*^9}}],

Cell[BoxData[{
 RowBox[{"odchylky", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"#", "-", 
      RowBox[{"ExactRoots", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
   "CestaBodu"}]}], "\[IndentingNewLine]", 
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"odchylky", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", "CestaBodu", "]"}], "]"}], ",", "Automatic"}], 
     "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<i [-]\>\"", ",", "\"\<odchylka\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512959255828125*^9, 3.512959494453125*^9}}]
},
WindowSize->{881, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.4500000476837158`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 271, 6, 41, "Input"],
Cell[819, 28, 2705, 80, 297, "Input"],
Cell[3527, 110, 2855, 88, 242, "Input"],
Cell[6385, 200, 407, 9, 67, "Input"],
Cell[6795, 211, 631, 20, 117, "Input"],
Cell[7429, 233, 1711, 50, 242, "Input"],
Cell[9143, 285, 991, 28, 167, "Input"]
}
]
*)

(* End of internal cache information *)
