(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5563,        177]
NotebookOptionsPosition[      5042,        157]
NotebookOutlinePosition[      5423,        173]
CellTagsIndexPosition[      5380,        170]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"NewtonStep", "[", 
   RowBox[{"f_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NewtonIteration", "[", 
    RowBox[{"f_", ",", "init_", ",", "opt___"}], "]"}], ":=", "\n", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NewtonStep", "[", 
       RowBox[{"f", ",", "#"}], "]"}], "&"}], ",", "init", ",", "opt"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.482723645625*^9, 3.482723650671875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NewtonPlot", "[", 
    RowBox[{"f_", ",", "x0_", ",", "n_", ",", "opt___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "data", "}"}], ",", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"NestList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "-", 
           FractionBox[
            RowBox[{"f", "[", "#1", "]"}], 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "#1", "]"}]]}], "&"}], ",", "x0",
          ",", "n"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "data", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "data", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"f", "[", 
                  RowBox[{
                  "data", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}], "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", "data", "]"}]}], "}"}]}], "]"}], ",", 
           "1"}], "]"}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "0", ",", "1"}], "]"}], "}"}]}], ",", "opt", 
         ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<f[x]\>\""}], "}"}]}]}], "]"}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.48272349740625*^9, {3.48272369140625*^9, 3.482723708109375*^9}, {
   3.4827237899375*^9, 3.4827237980625*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"Log", "[", "x", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "1."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "5"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.482723564515625*^9, 3.482723584421875*^9}, 
   3.482723911515625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "11"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
        RowBox[{"Hue", "[", "0", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<f[x]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.482723603703125*^9, 3.482723626328125*^9}, 
   3.4827237180625*^9}],

Cell[BoxData[
 RowBox[{"theroot", "=", 
  RowBox[{"NewtonIteration", "[", 
   RowBox[{"f", ",", "x0", ",", "10"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", 
   RowBox[{"NewtonPlot", "[", 
    RowBox[{"f", ",", "3.", ",", "4"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.482723509125*^9, 3.482723522*^9}, 3.4827235946875*^9}]
},
WindowSize->{767, 599},
WindowMargins->{{39, Automatic}, {Automatic, 31}},
Magnification->1.3000000715255737`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 283, 9, 59, "Input"],
Cell[831, 31, 398, 11, 61, "Input"],
Cell[1232, 44, 2199, 59, 232, "Input"],
Cell[3434, 105, 478, 14, 109, "Input"],
Cell[3915, 121, 750, 22, 84, "Input"],
Cell[4668, 145, 133, 3, 37, "Input"],
Cell[4804, 150, 234, 5, 37, "Input"]
}
]
*)

(* End of internal cache information *)
