(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7305,        231]
NotebookOptionsPosition[      6932,        215]
NotebookOutlinePosition[      7311,        231]
CellTagsIndexPosition[      7268,        228]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", ".01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]0", "=", "314"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox[
    RowBox[{"2.", "Pi"}], "\[Omega]0"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"10", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "0.06"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"10", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"\[Omega]0", "*", "t"}], "+", "0.13"}], "]"}]}], "+", 
    RowBox[{"3", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3.23", "*", "\[Omega]0", "*", "t"}], "+", "0.9"}], "]"}]}], 
    "+", 
    RowBox[{"5", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"9.23", "*", "\[Omega]0", "*", "t"}], "-", "0.9"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "-", 
       RowBox[{"u1", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"R", "*", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"u1", "[", "t", "]"}], "-", 
       RowBox[{"u2", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"L", "*", 
       RowBox[{
        RowBox[{"i", "'"}], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"i", "[", "t", "]"}], "\[Equal]", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"u2", "'"}], "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"i", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"u2", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"_Symbol", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", "Union"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "'"}], ",", "u1", ",", "u2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"StartingStepSize", "\[Rule]", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], "/.", "res"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6064509136875*^9, 3.606451188375*^9}, {
   3.606451228359375*^9, 3.606451246234375*^9}, {3.606451578578125*^9, 
   3.606451640109375*^9}, {3.606451690703125*^9, 3.60645170221875*^9}, {
   3.606451783328125*^9, 3.606451783703125*^9}, {3.60645192790625*^9, 
   3.606451937296875*^9}, {3.606452058546875*^9, 3.606452077859375*^9}, {
   3.60645211790625*^9, 3.6064521290625*^9}, {3.606452192875*^9, 
   3.60645219309375*^9}, 3.606452283484375*^9, {3.606452380625*^9, 
   3.606452421234375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"bod", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i", "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"i", "'"}], "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"i", "''"}], "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"uz", "'"}], "[", "t", "]"}]}], "}"}], "/.", "res"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"bod", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"tmax", "-", "T"}], ",", "tmax", ",", 
       FractionBox[
        RowBox[{"tmax", "-", "T"}], "1000"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Fit", "[", 
  RowBox[{"data1", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "di", ",", "d2i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "di", ",", "d2i"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.606451391953125*^9, 3.6064515395625*^9}, 
   3.60645159990625*^9, {3.606451758015625*^9, 3.60645177325*^9}, {
   3.60645194825*^9, 3.60645195353125*^9}, {3.6064523631875*^9, 
   3.606452365*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"derproud", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"i", "'"}], "[", "#", "]"}], "/.", "res"}]}], "}"}], "&"}],
       "/@", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"tmax", "-", "T"}], ",", "tmax", ",", 
        FractionBox[
         RowBox[{"tmax", "-", "T"}], "1000"]}], "]"}]}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "5"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bod", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i", "[", "t", "]"}], ",", 
      RowBox[{"derproud", "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"derproud", "'"}], "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"uz", "'"}], "[", "t", "]"}]}], "}"}], "/.", "res"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"bod", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"tmax", "-", "T"}], ",", "tmax", ",", 
       FractionBox[
        RowBox[{"tmax", "-", "T"}], "1000"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Fit", "[", 
  RowBox[{"data1", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "di", ",", "d2i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "di", ",", "d2i"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.60645180928125*^9, 3.606451899796875*^9}, {
   3.60645215496875*^9, 3.60645216903125*^9}, {3.606452211109375*^9, 
   3.606452213*^9}, 3.606452372515625*^9}]
},
WindowSize->{941, 729},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3508, 102, 478, "Input"],
Cell[4056, 124, 1172, 35, 133, "Input"],
Cell[5231, 161, 1697, 52, 259, "Input"]
}
]
*)

(* End of internal cache information *)
