(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4729,        167]
NotebookOptionsPosition[      4020,        141]
NotebookOutlinePosition[      4387,        157]
CellTagsIndexPosition[      4344,        154]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Prost\[AAcute] iterace = Cobweb Diagram\
\>", "Subtitle"],

Cell["The iteration process:", "MainSection"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["x", "0"], ";", " ", 
   RowBox[{
    SubscriptBox["x", "1"], "=", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "0"], ")"}]}], ";", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], "=", 
      RowBox[{"f", "(", 
       SubscriptBox["x", "1"], ")"}]}], ";"}], " ", "..."}], " ", ";", " ", 
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "n"], ")"}], " "}]}], TraditionalForm]]]], "TextBox",
 CellMargins->{{70, 207}, {Inherited, Inherited}},
 TextAlignment->Center,
 TextJustification->0],

Cell[TextData[{
 "Definition and the plot of  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]]]
}], "MainSection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"2.8", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"p0", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.8"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Thickness", "[", "0.006", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482723326640625*^9, 3.482723373265625*^9}}],

Cell["The iteration", "MainSection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x0", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"data", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"f", ",", "x0", ",", "NN"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"dd", "=", 
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"Thread", "[", 
     RowBox[{"{", 
      RowBox[{"data", ",", 
       RowBox[{"RotateLeft", "[", "data", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input"],

Cell["The Cobweb diagram ", "MainSection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cary", "=", 
   RowBox[{"dd", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u_", ",", "v_"}], "}"}], "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "u", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"u", ",", "u"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"u", ",", "v"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"v", ",", "v"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p0", ",", "cary", ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.48272331953125*^9, {3.482723388359375*^9, 3.482723389703125*^9}}]
}, Open  ]]
},
WindowSize->{1014, 694},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->2,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"modeling-sty.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 67, 2, 99, "Subtitle"],
Cell[637, 26, 45, 0, 43, "MainSection"],
Cell[685, 28, 651, 21, 78, "TextBox"],
Cell[1339, 51, 145, 5, 43, "MainSection"],
Cell[1487, 58, 163, 5, 57, "Input"],
Cell[1653, 65, 805, 21, 160, "Input"],
Cell[2461, 88, 36, 0, 43, "MainSection"],
Cell[2500, 90, 266, 7, 126, "Input"],
Cell[2769, 99, 261, 8, 57, "Input"],
Cell[3033, 109, 42, 0, 43, "MainSection"],
Cell[3078, 111, 926, 27, 228, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

