(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3068,         91]*)
(*NotebookOutlinePosition[      3975,        123]*)
(*  CellTagsIndexPosition[      3893,        117]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Graphics`\)], "Input"],

Cell[BoxData[
    \(ConstrainedMin[
      2\ x - 3\ y, {x + y < 10, x - y > 2, x > 1}, {x, y}]\)], "Input",
  CellTags->"LinearProgramming"],

Cell[BoxData[
    RowBox[{"LinearProgramming", "[", 
      RowBox[{\({2, \(-3\)}\), ",", 
        RowBox[{"(", GridBox[{
              {\(-1\), \(-1\)},
              {"1", \(-1\)},
              {"1", "0"}
              }], ")"}], ",", \({\(-10\), 2, 1}\)}], "]"}]], "Input",
  CellTags->"LinearProgramming"],

Cell[BoxData[{
    \(\(fce = x^3 + x*y\^2;\)\), "\[IndentingNewLine]", 
    \(\(podminka =  .02*x^3 + 0.05*x\^2*y + y\^2 - 
          6;\)\), "\[IndentingNewLine]", 
    \(ImplicitPlot[podminka \[Equal] 0, {x, \(-5\), 45}]\)}], "Input"],

Cell[BoxData[{
    \(\(lagrange = fce + \[Lambda]*podminka;\)\), "\[IndentingNewLine]", 
    \(\(res = 
        Solve[{D[lagrange, x] \[Equal] 0, D[lagrange, y] \[Equal] 0, 
              podminka \[Equal] 0}] // N;\)\)}], "Input"],

Cell[BoxData[
    \(data = Select[{x, y} /. res, #[\([1]\)] \[Element] Reals &]\)], "Input"],

Cell[BoxData[
    \(DisplayTogether[ImplicitPlot[podminka \[Equal] 0, {x, \(-20\), 45}], 
      ListPlot[data, PlotStyle \[Rule] {Hue[0], PointSize[ .03]}]]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{763, 537},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "LinearProgramming"->{
    Cell[1872, 57, 140, 3, 35, "Input",
      CellTags->"LinearProgramming"],
    Cell[2015, 62, 309, 8, 67, "Input",
      CellTags->"LinearProgramming"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"LinearProgramming", 3711, 108}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 58, 1, 35, "Input"],
Cell[1815, 54, 54, 1, 35, "Input"],
Cell[1872, 57, 140, 3, 35, "Input",
  CellTags->"LinearProgramming"],
Cell[2015, 62, 309, 8, 67, "Input",
  CellTags->"LinearProgramming"],
Cell[2327, 72, 236, 4, 79, "Input"],
Cell[2566, 78, 231, 4, 56, "Input"],
Cell[2800, 84, 92, 1, 35, "Input"],
Cell[2895, 87, 169, 2, 56, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

