(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3814,         96]*)
(*NotebookOutlinePosition[      4480,        119]*)
(*  CellTagsIndexPosition[      4436,        115]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(Off[General::spell1];\)\), "\[IndentingNewLine]", 
    \(\(xmin = \(-20\);\)\), "\[IndentingNewLine]", 
    \(\(xmax = 10;\)\), "\[IndentingNewLine]", 
    \(\(delta = 0.1;\)\), "\[IndentingNewLine]", 
    \(\(fcekhledani[
          x_] = \((Table[{x, 
                  0.1 \((x +  .5  Random[])\)\^4 + \((x + 5  Random[])\)\^3 - 
                    10 \((x + 5  Random[])\)\^2 + 100 \((x + 5  Random[])\) + 
                    20  Random[]}, {x, xmin, xmax, delta}] // 
              Interpolation)\)[
          x];\)\[IndentingNewLine] (*\(fcekhledani[
            x_] = \((x - 5)\)\^2;\)*) \), "\[IndentingNewLine]", 
    \(\(Plot[fcekhledani[x], {x, xmin, xmax}, PlotPoints \[Rule] 1000, 
        PlotRange \[Rule] All, 
        AxesLabel \[Rule] {"\<x\>", "\<f[x]\>"}];\)\)}], "Input"],

Cell[BoxData[{
    \(k = 5000; deltax = 1; T0 = 100; 
    pocetiteraci = 15000;\), "\[IndentingNewLine]", 
    \(\(T[i_] = \(T0*k\)\/\(i + k\);\)\), "\[IndentingNewLine]", 
    \(\(Plot[T[i], {i, 1, pocetiteraci}, 
        AxesLabel \[Rule] {"\<i\>", "\<T[i]\>"}];\)\), "\[IndentingNewLine]", \

    \(\(p[i_, deltaW_] = Exp[\(-deltaW\)\/T[i]];\)\), "\[IndentingNewLine]", 
    \(\(xdal[listik_] := 
        Module[{xtry, dW, xminule, i}, xminule = listik[\([2]\)]; 
          i = listik[\([1]\)]; 
          xtry = Random[Real, {xminule - deltax, xminule + deltax}]; 
          dW = fcekhledani[xtry] - fcekhledani[xminule]; 
          pravd = p[i, dW]; {i + 1, 
            If[dW < 0, xtry, 
              If[pravd > Random[], xtry, 
                xminule]]}];\)\), "\[IndentingNewLine]", 
    \(\(vyslednylist = 
        NestList[xdal, {0, 1}, pocetiteraci];\)\), "\[IndentingNewLine]", 
    \(ListPlot[% /. {a_, b_} \[Rule] {a, fcekhledani[b]}, 
      PlotRange \[Rule] All]\), "\[IndentingNewLine]", 
    \(\((vyslednylist // Last)\) /. {a_, b_} \[Rule] {a, 
          fcekhledani[b]}\), "\[IndentingNewLine]", 
    \(FindMinimum[fcekhledani[x], {x, xmin/2, xmax/2}]\)}], "Input"],

Cell[BoxData[
    \(\(?NMinimize\)\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{779, 537},
WindowMargins->{{11, Automatic}, {Automatic, 12}},
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 816, 15, 246, "Input"],
Cell[2573, 68, 1187, 23, 303, "Input"],
Cell[3763, 93, 47, 1, 35, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

