(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11158,        337]
NotebookOptionsPosition[     10642,        317]
NotebookOutlinePosition[     11083,        335]
CellTagsIndexPosition[     11040,        332]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"proklad", " ", "zvolenych", " ", "bodu", " ", "polynomem"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"body", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.", ",", "12.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.", ",", "18.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.", ",", "30.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.", ",", "48.4"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"body", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", " ", 
          RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"polynom3rad", "[", "x_", "]"}], ":=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "0"}], "3"], 
      RowBox[{
       SubscriptBox["a", "i"], "*", 
       SuperscriptBox["x", "i"]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rcei", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"polynom3rad", "[", 
       RowBox[{"body", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], "==", 
      RowBox[{"body", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"rcei", "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"dosKoeficienty", "=", 
    RowBox[{
     RowBox[{"Solve", "[", "rce", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"polynom", "=", 
    RowBox[{
     RowBox[{"polynom3rad", "[", "x", "]"}], "/.", "dosKoeficienty"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"polynom", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", " ", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "pl2"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5111445320625*^9, 3.5111445415625*^9}, {
  3.51114462328125*^9, 3.51114491609375*^9}, {3.511145066796875*^9, 
  3.511145166796875*^9}, {3.51114519725*^9, 3.511145281046875*^9}, {
  3.51114535390625*^9, 3.511145374640625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"potrebujeme", " ", "opakovane", " ", "resit", " ", 
      RowBox[{"fOskliva", "[", "x", "]"}]}], "\[Equal]", "y"}], ",", " ", 
    RowBox[{"y", " ", "zadane"}], ",", " ", 
    RowBox[{"x", " ", "nezname"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"fOskliva", "[", "x_", "]"}], ":=", 
     RowBox[{"x", "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}], "2"]}]]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fOskliva", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"reseni", " ", "pomoci", " ", "FindRoot"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"resX", "[", "y_", "]"}], ":=", 
     RowBox[{"x", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"fOskliva", "[", "x", "]"}], "\[Equal]", "y"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vys", "=", 
     RowBox[{"Timing", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"resX", "[", "y", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
        RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<trvalo to \>\"", ",", 
     RowBox[{"vys", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.51114542271875*^9, 3.5111454425*^9}, {3.5111454865*^9, 
  3.511145940546875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "reseni", " ", "pomoci", " ", "vyreseni", " ", "v", " ", "nekolika", " ", 
    "bodech", " ", "a", " ", "dale", " ", "interpolace"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"body", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"resX", "[", "y", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nahr", "=", 
     RowBox[{"Interpolation", "[", "body", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"nahr", "[", "y", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5111459578125*^9, 3.511146117109375*^9}, {
  3.5111462134375*^9, 3.511146218078125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "reseni", " ", "pomoci", " ", "definice", " ", "inverzni", " ", "funkce", 
    " ", "a", " ", "interpolace"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"invbody", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fOskliva", "[", "x", "]"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5."}], ",", "5", ",", "0.05"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"interpInv", "=", 
     RowBox[{"Interpolation", "[", "invbody", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"interpInv", "[", "y", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.511146153359375*^9, 3.511146326671875*^9}, {
  3.51114930409375*^9, 3.511149312140625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Ukazka", " ", "idealizovane", " ", "charakteristiky", " ", "diody"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "iD", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iD", "[", "uD_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"19", "*", "uD"}], "]"}], "-", "1"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"iD", "[", "uD", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"uD", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<uD[V]\>\"", ",", "\"\<iD[A]\>\""}], "}"}]}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"iD", "[", "uD", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"uD", ",", 
        RowBox[{"-", "1"}], ",", "0.1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<uD[V]\>\"", ",", "\"\<iD[A]\>\""}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.469623178082181*^9, 3.469623285736981*^9}, {
  3.469627312927797*^9, 3.4696273188362927`*^9}, {3.511149320484375*^9, 
  3.511149321609375*^9}}]
},
WindowSize->{831, 652},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3010, 87, 403, "Input"],
Cell[3558, 109, 2320, 66, 316, "Input"],
Cell[5881, 177, 1471, 41, 243, "Input"],
Cell[7355, 220, 1449, 40, 187, "Input"],
Cell[8807, 262, 1831, 53, 217, "Input"]
}
]
*)

(* End of internal cache information *)
