(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9112,        275]
NotebookOptionsPosition[      8676,        258]
NotebookOutlinePosition[      9119,        275]
CellTagsIndexPosition[      9076,        272]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fce", "[", "x_", "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hledej", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "min_", ",", "i_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"normgrad", ",", "newx"}], "}"}], ",", 
    RowBox[{
     RowBox[{"normgrad", "=", 
      RowBox[{"Tanh", "[", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"fce", "'"}], "[", "x", "]"}]}], "]"}]}], ";", 
     RowBox[{"newx", "=", 
      RowBox[{"x", "+", 
       RowBox[{"dx", "*", "normgrad"}]}]}], ";", 
     RowBox[{"{", 
      RowBox[{"newx", ",", 
       RowBox[{"fce", "[", "newx", "]"}], ",", 
       RowBox[{"i", "+", "1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Nest", "[", 
  RowBox[{"hledej", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", "150"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "&"}], ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"body", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "b"}], "}"}]}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<i\>\"", ",", "\"\<f [xi]\>\""}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.451631313859375*^9, 3.451631604796875*^9}, {
   3.45163168234375*^9, 3.451631712953125*^9}, {3.512915605703125*^9, 
   3.512915633140625*^9}, {3.512915734671875*^9, 3.51291580815625*^9}, {
   3.512915893703125*^9, 3.512915939390625*^9}, 3.5129160510625*^9, 
   3.512916767609375*^9, {3.512958601390625*^9, 3.512958604921875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"x", "+", "3"}], "2"], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"y", "-", "1"}], "4"], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmin", "=", 
   RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymin", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymax", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pl1", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x \>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.5129161295625*^9, {3.5129164641875*^9, 3.512916488578125*^9}, {
   3.512916597015625*^9, 3.51291660678125*^9}, {3.512916981734375*^9, 
   3.512917000453125*^9}, {3.5129177440625*^9, 3.5129177548125*^9}, {
   3.512917793421875*^9, 3.512917801390625*^9}, {3.51291783534375*^9, 
   3.512917979265625*^9}, {3.51291801275*^9, 3.512918017828125*^9}, {
   3.512918058421875*^9, 3.51291807334375*^9}, {3.5129183208125*^9, 
   3.512918321796875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", 
    RowBox[{"xx_", ",", "yy_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[RuleDelayed]", "xx"}], ",", 
      RowBox[{"y", "\[RuleDelayed]", "yy"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "0.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k0", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hledej", "[", 
    RowBox[{"{", 
     RowBox[{"i_", ",", 
      RowBox[{"b", ":", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}]}], ",", "hodn_", ",", "k_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gr", ",", "newbod"}], "}"}], ",", 
     RowBox[{
      RowBox[{"gr", "=", 
       RowBox[{"grad", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ";", 
      RowBox[{"newbod", "=", 
       RowBox[{"b", "-", 
        RowBox[{"dx", "*", "k", "*", 
         FractionBox["gr", 
          RowBox[{"Norm", "[", "gr", "]"}]]}]}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "newbod", ",", 
        RowBox[{"vyr", "[", 
         RowBox[{"Sequence", "@@", "newbod"}], "]"}], ",", 
        RowBox[{"k", "*", "q"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"vyr", "[", 
      RowBox[{"4", ",", "5"}], "]"}], ",", "k0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", "poc", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], ">", "0.01"}], "&"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"dat", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", "b", "}"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Bold"}], "]"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "1"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"dat", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"min", "[", 
  RowBox[{"[", "2", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.51291652671875*^9, 3.512916536375*^9}, {
   3.512916577625*^9, 3.512916578171875*^9}, {3.5129166568125*^9, 
   3.512916739546875*^9}, {3.51291678884375*^9, 3.5129168789375*^9}, {
   3.512916913953125*^9, 3.512916964390625*^9}, {3.512917078265625*^9, 
   3.512917130875*^9}, {3.512917164609375*^9, 3.512917242546875*^9}, {
   3.5129172891875*^9, 3.51291739909375*^9}, {3.51291744190625*^9, 
   3.51291748215625*^9}, {3.51291751515625*^9, 3.5129175488125*^9}, {
   3.512917723765625*^9, 3.51291773278125*^9}, {3.51291810890625*^9, 
   3.512918160453125*^9}, {3.5129182040625*^9, 3.5129182528125*^9}, {
   3.512918288109375*^9, 3.512918419578125*^9}, {3.51291846996875*^9, 
   3.51291855353125*^9}, 3.512918588453125*^9, {3.512958628359375*^9, 
   3.512958675359375*^9}}]
},
WindowSize->{1006, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2445, 71, 238, "Input"],
Cell[2993, 93, 1889, 54, 263, "Input"],
Cell[4885, 149, 3787, 107, 407, "Input"]
}
]
*)

(* End of internal cache information *)
