(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26591,        776]
NotebookOptionsPosition[     25454,        740]
NotebookOutlinePosition[     26024,        762]
CellTagsIndexPosition[     25981,        759]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.638609350415511*^9, 3.6386093508061357`*^9}, {
   3.638612154478011*^9, 3.6386121598061357`*^9}, 3.638771498875*^9, 
   3.6387722884375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kCVypZap", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindMinimum", "::", "\"\<fmmp\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataPminPmax", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "625"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "500"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"75", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "300"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataAcka", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"500", ",", "8", ",", "0.004"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"400", ",", "6.4", ",", "0.0048"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"600", ",", "7.9", ",", "0.005"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"400", ",", "7.5", ",", "0.0055"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataCinCout", "=", 
   RowBox[{"kCVypZap", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3000", ",", "1500"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "1500"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "1000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "800"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "dataAcka", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vykony", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "#"], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"rn", "=", 
      RowBox[{"Range", "[", "n", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   SuperscriptBox["x", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pen", "[", 
    RowBox[{
    "x_", ",", "a_", ",", "b_", ",", "\[Delta]a_", ",", "\[Delta]b_"}], "]"}],
    ":=", 
   RowBox[{
    SuperscriptBox["10", "3"], 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"res", ",", "vyr", ",", "xx", ",", "k", ",", "ka", ",", "kb"}],
        "}"}], ",", 
      RowBox[{
       RowBox[{"k", "=", 
        RowBox[{
         SuperscriptBox["10", "4"], 
         RowBox[{"Min", "[", 
          RowBox[{"Abs", "[", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", "a"], ",", 
             FractionBox["1", "b"]}], "}"}], "]"}], "]"}]}]}], ";", 
       RowBox[{
        RowBox[{"vyr", "[", "xx_", "]"}], ":=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ka", "*", 
            RowBox[{"f", "[", 
             RowBox[{"(", 
              RowBox[{"xx", "-", "a"}], ")"}], "]"}]}], "+", 
           RowBox[{"kb", "*", 
            RowBox[{"f", "[", 
             RowBox[{"(", 
              RowBox[{"xx", "-", "b"}], ")"}], "]"}]}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Tanh", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"xx", "-", "b"}], ")"}], "*", "k"}], "]"}], "-", 
           RowBox[{"Tanh", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"xx", "-", "a"}], ")"}], "*", "k"}], "]"}]}], ")"}]}]}],
        ";", 
       RowBox[{"res", "=", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"vyr", "[", 
               RowBox[{"a", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  RowBox[{"0.01", "\[Delta]a"}]}], ")"}]}], "]"}], "\[Equal]",
               "100"}], ",", 
             RowBox[{
              RowBox[{"vyr", "[", 
               RowBox[{"b", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"0.01", "\[Delta]b"}]}], ")"}]}], "]"}], "\[Equal]",
               "100"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ka", ",", "kb"}], "}"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"vyr", "[", "x", "]"}], "/.", "res"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ukpen", "[", "x_", "]"}], "=", 
   RowBox[{"pen", "[", 
    RowBox[{"x", ",", "20", ",", "30", ",", "5", ",", "5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plPenale", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ukpen", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<P [MW]\>\"", ",", "\"\<penale\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "[", "plPenale", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.56473827603125*^9, 3.56473827778125*^9}, {
   3.564738580984375*^9, 3.5647385834375*^9}, {3.564738883953125*^9, 
   3.56473888428125*^9}, {3.564739039375*^9, 3.564739043*^9}, {
   3.638609134853011*^9, 3.638609166540511*^9}, 3.6386091967748857`*^9, {
   3.6386092415873857`*^9, 3.638609282165511*^9}, {3.6386093574936357`*^9, 
   3.638609424478011*^9}, {3.638609457884261*^9, 3.638609481728011*^9}, {
   3.6386098099311357`*^9, 3.6386098476186357`*^9}, {3.6386124054623857`*^9, 
   3.6386124062748857`*^9}, 3.6386127153998857`*^9, 3.638613690196761*^9, {
   3.6387731205625*^9, 3.638773120921875*^9}, {3.638775841625*^9, 
   3.63877584421875*^9}, {3.638775978296875*^9, 3.63877602328125*^9}, 
   3.638776681625*^9, 3.638776718890625*^9, {3.638776767*^9, 
   3.63877676784375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"penale", "[", "i_", "]"}], ":=", 
     RowBox[{"pen", "[", 
      RowBox[{
       RowBox[{"vykony", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "5", ",", "5"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"penale", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["P", "1"], ",", "0", ",", "750"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<P [MW]\>\"", ",", "\"\<penale\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6386095181186357`*^9, 3.6386097899311357`*^9}, 
   3.6386098593373857`*^9, 3.638612868009261*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cena", "[", "i_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Pi", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Pi", "=", 
       RowBox[{"vykony", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "Pi", ",", 
         SuperscriptBox["Pi", "2"]}], "}"}], ".", 
       RowBox[{"dataAcka", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaleVykony", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"penale", "/@", "rn"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cenaVari", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"cena", "/@", "rn"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"penaleDodavka", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"200", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Plus", "@@", "vykony"}], ")"}], "-", "Pdodavka"}], ")"}], 
     "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"proFindMinimum", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"penaleVykony", "+", 
    RowBox[{"penaleDodavka", "[", "Pdodavka", "]"}], "+", "cenaVari"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6386098647123857`*^9, 3.638609938509261*^9}, 
   3.6386101308998857`*^9, 3.6386103283686357`*^9, {3.638612301884261*^9, 
   3.638612313415511*^9}, {3.638613120665511*^9, 3.6386132972748857`*^9}, 
   3.6386133479623857`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"obor", "[", "i_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vykony", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "//", "N"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obory", "=", 
   RowBox[{"obor", "/@", "rn"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.638613386853011*^9, 3.6386133888998857`*^9}, {
  3.638613419665511*^9, 3.6386134229311357`*^9}, {3.638613461290511*^9, 
  3.6386135291186357`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"min", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"proFindMinimum", "[", "Pdodavka", "]"}], ",", "obory"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cenaHodina", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"cenaVari", "/.", 
    RowBox[{
     RowBox[{"min", "[", "Pdodavka", "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datazatizeni", "=", 
   RowBox[{"{", 
    RowBox[{
    "600", ",", "800", ",", "1100", ",", "1400", ",", "1000", ",", "1200", 
     ",", "1000", ",", "1400", ",", "1600", ",", "1600", ",", "1400", ",", 
     "800", ",", "400", ",", "200", ",", "1400", ",", "1200", ",", "450", ",",
      "300", ",", "400"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom1", "=", 
   RowBox[{
    RowBox[{"min", "/@", "datazatizeni"}], "//", "Quiet"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nakladyDen", "=", 
   RowBox[{"cenaVari", "/.", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "pom1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<celkem naklady= \>\"", ",", 
   RowBox[{"Plus", "@@", "nakladyDen"}], ",", "\"\< -\>\""}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6386134275561357`*^9, 3.638613433290511*^9}, {
  3.638613533446761*^9, 3.6386135815248857`*^9}, {3.6386136177436357`*^9, 
  3.6386136622436357`*^9}, {3.638770457734375*^9, 3.638770639671875*^9}, {
  3.638770699796875*^9, 3.638770722421875*^9}, {3.63877569565625*^9, 
  3.63877573796875*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "optimalizace", " ", "denniho", " ", "provozu", " ", "pres", " ", "cely", 
   " ", "den"}], "*)"}]], "Input",
 CellChangeTimes->{{3.63877075921875*^9, 3.638770777078125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nk", "=", 
   RowBox[{
    SuperscriptBox["2", "n"], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"komb", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"#", ",", 
          RowBox[{"-", "4"}]}], "]"}], "&"}], ")"}], "/@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IntegerDigits", "[", 
         RowBox[{
          RowBox[{"Range", "[", "nk", "]"}], ",", "2"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", "q__Integer", "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "q"}], "}"}]}]}], ")"}]}], 
     ")"}], "//", "Union"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.638770831546875*^9, 3.63877085625*^9}, 
   3.638771351734375*^9, 3.638772405796875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"nakladyHodina", "[", 
     RowBox[{"Pzadany_", ",", "kombinace_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"penMinMax", ",", "penDodavka", ",", 
        RowBox[{"kpd", "=", "100"}], ",", 
        RowBox[{"kpmn", "=", "10"}], ",", "obors", ",", "cen", ",", "promin", 
        ",", "min", ",", "m", ",", "ps"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"penMinMax", "=", 
        RowBox[{"kpmn", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"penale", "/@", "rn"}], ")"}], ".", "kombinace"}]}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"penDodavka", "=", 
        RowBox[{"kpd", "*", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"vykony", ".", "kombinace"}], ")"}], "-", "Pzadany"}], 
           ")"}], "2"]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"obors", "=", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"obory", ",", 
            RowBox[{"kombinace", "*", "rn"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"_", ",", "_"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cen", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"cena", "/@", "rn"}], ")"}], ".", "kombinace"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"promin", "=", 
        RowBox[{"cen", "+", "penDodavka", "+", "penMinMax"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"min", "=", 
        RowBox[{
         RowBox[{"FindMinimum", "[", 
          RowBox[{"promin", ",", "obors"}], "]"}], "//", "Quiet"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cen", "/.", 
          RowBox[{"(", 
           RowBox[{"m", "=", 
            RowBox[{"min", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ",", "kombinace", ",",
          "m", ",", 
         RowBox[{"ps", "=", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"penMinMax", ",", "penDodavka"}], "}"}], "/.", "m"}]}], 
         ",", 
         RowBox[{"Plus", "@@", "ps"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.638771367875*^9, 3.638771412546875*^9}, {
   3.638771548171875*^9, 3.6387715684375*^9}, {3.6387716386875*^9, 
   3.638771683140625*^9}, {3.638771728765625*^9, 3.638771807328125*^9}, {
   3.638771950734375*^9, 3.63877197425*^9}, 3.6387720411875*^9, {
   3.63877219471875*^9, 3.63877222509375*^9}, {3.638772272375*^9, 
   3.63877263778125*^9}, {3.638772770609375*^9, 3.6387727914375*^9}, {
   3.6387728909375*^9, 3.63877289384375*^9}, {3.63877604803125*^9, 
   3.6387760489375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejHodina", "[", "Pzadany_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "dats", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dats", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"nakladyHodina", "[", 
           RowBox[{"Pzadany", ",", "#"}], "]"}], "&"}], "/@", "komb"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "3"}], "]"}], "&"}], "/@", 
        RowBox[{"Sort", "@", 
         RowBox[{"Select", "[", 
          RowBox[{"dats", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "<", "1"}], "&"}]}], 
          "]"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.63877281059375*^9, 3.638772870875*^9}, {
   3.638772912203125*^9, 3.638772936015625*^9}, {3.638772991375*^9, 
   3.63877299996875*^9}, {3.6387735595625*^9, 3.63877356075*^9}, {
   3.638774884671875*^9, 3.638774902875*^9}, {3.638774970796875*^9, 
   3.638775002921875*^9}, 3.63877579321875*^9, 3.638776051921875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cenaprepnuti", "[", 
    RowBox[{"v1_", ",", "v2_"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sign", "[", 
          RowBox[{"(", 
           RowBox[{"v1", "-", "v2"}], ")"}], "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "<", "0"}], ",", 
       RowBox[{"dataCinCout", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Sign", "[", 
            RowBox[{"(", 
             RowBox[{"v1", "-", "v2"}], ")"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], ">", "0"}], ",", 
         RowBox[{"dataCinCout", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6387731759375*^9, 3.638773233609375*^9}, {
   3.638773263953125*^9, 3.63877326496875*^9}, 3.63877538196875*^9, 
   3.6387757956875*^9, {3.638776056671875*^9, 3.63877605703125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"start", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vydejHodina", "[", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "1"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.638773675203125*^9, 3.63877367775*^9}, {
   3.638774753515625*^9, 3.638774775828125*^9}, {3.63877481053125*^9, 
   3.638774813828125*^9}, {3.63877513228125*^9, 3.638775140625*^9}, 
   3.638776060703125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c_", ",", "komb_", ",", "dosP_"}], "}"}], ",", "n_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"zatizeni", ",", "mozne", ",", "sprepnutim"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"zatizeni", "=", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", 
         RowBox[{"n", "+", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"vydejHodina", "[", "zatizeni", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sprepnutim", "=", 
       RowBox[{
        RowBox[{"Sort", "[", 
         RowBox[{"mozne", "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ci_Real", ",", "kombi_List", ",", "dosPi_"}], "}"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ci", "+", 
              RowBox[{"1", "*", 
               RowBox[{"cenaprepnuti", "[", 
                RowBox[{"komb", ",", "kombi"}], "]"}]}]}], ",", "kombi", ",", 
             "dosPi"}], "}"}]}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"sprepnutim", ",", 
        RowBox[{"n", "+", "1"}]}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.638775076*^9, 3.638775112546875*^9}, {
  3.638775143859375*^9, 3.638775185*^9}, {3.638775218484375*^9, 
  3.63877547321875*^9}, {3.638775511921875*^9, 3.6387755666875*^9}, {
  3.638775672078125*^9, 3.638775674890625*^9}, {3.63877606640625*^9, 
  3.63877606678125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "start", ",", 
     RowBox[{
      RowBox[{"Length", "[", "datazatizeni", "]"}], "-", "1"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"cenaDenSVypZap", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "&"}], "/@", "dats"}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<celkem denni naklady= \>\"", ",", "cenaDenSVypZap", ",", 
   "\"\< -\>\""}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.63877558603125*^9, 3.638775619375*^9}, {
   3.638775883375*^9, 3.6387758883125*^9}, 3.638776080875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"dats", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ci_Real", ",", "kombi_List", ",", "dosPi_"}], "}"}], ",", 
       "nh_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"nh", ",", "ci", ",", "kombi", ",", "dosPi", ",", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", "nh", "]"}], "]"}], ",", 
       FractionBox["ci", 
        RowBox[{"datazatizeni", "[", 
         RowBox[{"[", "nh", "]"}], "]"}]]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p1", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<hodina\>\"", ",", "\"\<c [Kc]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p2", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "5", "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<hodina\>\"", ",", "\"\<P [MW]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p3", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<hodina\>\"", ",", 
       "\"\<ch [\!\(\*FractionBox[\(Kc\), \(MWh\)]\)]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "[", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.638776294578125*^9, 3.638776381875*^9}, {
  3.6387764495625*^9, 3.638776650171875*^9}, {3.63877724953125*^9, 
  3.638777269859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"proexp", "=", 
   RowBox[{
    RowBox[{"pom", "/.", 
     RowBox[{
      SubscriptBox["P", "a_"], "\[RuleDelayed]", 
      RowBox[{"\"\<P\>\"", "<>", 
       RowBox[{"ToString", "[", "a", "]"}]}]}]}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "\[Rule]", "b_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"ToString", "[", "a", "]"}], "<>", "\"\<=\>\"", "<>", 
      RowBox[{"ToString", "[", "b", "]"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<vysledky.xls\>\"", ",", "proexp"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.638776874921875*^9, 3.638776875234375*^9}, {
  3.6387769324375*^9, 3.638777101609375*^9}, {3.63877722046875*^9, 
  3.638777228296875*^9}, {3.638777292484375*^9, 3.63877734153125*^9}}]
},
WindowSize->{1146, 811},
WindowMargins->{{7, Automatic}, {Automatic, 17}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1300, 37, 167, "Input"],
Cell[1848, 59, 5985, 171, 463, "Input"],
Cell[7836, 232, 1248, 34, 117, "Input"],
Cell[9087, 268, 576, 17, 127, "Input"],
Cell[9666, 287, 1114, 30, 145, "Input"],
Cell[10783, 319, 624, 18, 97, "Input"],
Cell[11410, 339, 1722, 45, 278, "Input"],
Cell[13135, 386, 217, 5, 59, "Input"],
Cell[13355, 393, 866, 26, 97, "Input"],
Cell[14224, 421, 2855, 72, 439, "Input"],
Cell[17082, 495, 1250, 33, 205, "Input"],
Cell[18335, 530, 1209, 34, 133, "Input"],
Cell[19547, 566, 522, 13, 59, "Input"],
Cell[20072, 581, 1736, 46, 314, "Input"],
Cell[21811, 629, 793, 23, 169, "Input"],
Cell[22607, 654, 2006, 61, 437, "Input"],
Cell[24616, 717, 834, 21, 137, "Input"]
}
]
*)

(* End of internal cache information *)
