(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      4805,        164]
NotebookOptionsPosition[      4487,        149]
NotebookOutlinePosition[      4867,        165]
CellTagsIndexPosition[      4824,        162]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fi", "[", "i_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", "i", "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.003", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1.", 
          SuperscriptBox["i", "2"]}], ")"}], "2.73"]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"fi", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"fi", "[", "i", "]"}], ",", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"10", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"2.", "*", "Pi", "*", "50", "*", "t"}], "+", "0.234"}], 
      "]"}]}], "+", 
    RowBox[{"5", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3", "*", "2.", "*", "Pi", "*", "50", "*", "t"}], "+", 
       "0.234"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"R", "*", 
        RowBox[{"i", "[", "t", "]"}]}], "+", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"fi", "[", 
          RowBox[{"i", "[", "t", "]"}], "]"}], ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"i", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", "i", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "[", "t", "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"tmax", "-", "0.04"}], ",", "tmax"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["1.", 
    RowBox[{"50", "*", "400"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"u", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"i", "[", "#", "]"}], "/.", "sol"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"tmax", "-", "0.04"}], ",", "tmax", ",", "\[CapitalDelta]t"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"data", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "i"}], "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<datatui.csv\>\"", ",", "data"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.720415405890625*^9, 3.720415829890625*^9}, {
  3.72041591090625*^9, 3.72041596359375*^9}, {3.720415995421875*^9, 
  3.720416066140625*^9}}]
},
WindowSize->{1108, 783},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 333, 10, 103, "Input"],
Cell[893, 32, 3590, 115, 420, "Input"]
}
]
*)

(* End of internal cache information *)
