(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7055,        222]
NotebookOptionsPosition[      6489,        200]
NotebookOutlinePosition[      7037,        221]
CellTagsIndexPosition[      6994,        218]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fimm", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"i", "[", "fi_", "]"}], ":=", 
   RowBox[{"1", "*", 
    FractionBox["fi", "fimm"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.03", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1.", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["fi", "fimm"], ")"}], "2"]}], ")"}], "2.73"]}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fim", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"i", "[", "fi", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fi", ",", 
     RowBox[{"-", "fim"}], ",", "fim"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i", "[", "fi", "]"}], ",", "fi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"fi", ",", 
      RowBox[{"-", "fim"}], ",", "fim"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.720415405890625*^9, 3.720415829890625*^9}, {
  3.72041591090625*^9, 3.72041596359375*^9}, {3.720415995421875*^9, 
  3.720416066140625*^9}, {3.7204255821875*^9, 3.720425748125*^9}, {
  3.720516717640625*^9, 3.720516758578125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{"60", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"2.", "*", "Pi", "*", "50", "*", "t"}], "+", "0.234"}], "]"}],
       "+", 
      RowBox[{"0.5", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"3", "*", "2.", "*", "Pi", "*", "50", "*", "t"}], "+", 
         "0.234"}], "]"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rce", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"R", "*", 
       RowBox[{"i", "[", 
        RowBox[{"fi", "[", "t", "]"}], "]"}]}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"fi", "[", "t", "]"}], ",", "t"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"fi", "[", "0", "]"}], "\[Equal]", "0"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "1.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{"rce", ",", "fi", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.720415405890625*^9, 3.720415829890625*^9}, {
   3.72041591090625*^9, 3.72041596359375*^9}, {3.720415995421875*^9, 
   3.720416066140625*^9}, {3.7204255821875*^9, 3.720425607234375*^9}, {
   3.720425764484375*^9, 3.7204258428125*^9}, {3.720426092796875*^9, 
   3.720426237875*^9}, 3.720516694671875*^9, 3.72051677678125*^9, 
   3.720516811875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "[", 
      RowBox[{"fi", "[", "t", "]"}], "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"tmax", "-", "0.04"}], ",", "tmax"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mean", "=", 
   RowBox[{
    FractionBox["1", "0.04"], 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "[", 
        RowBox[{"fi", "[", "t", "]"}], "]"}], "/.", "sol"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"tmax", "-", "0.04"}], ",", "tmax"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"proud", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "[", 
       RowBox[{"fi", "[", "t", "]"}], "]"}], "/.", "sol"}], ")"}], "-", 
    "mean"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"proud", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"tmax", "-", "0.04"}], ",", "tmax"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["1.", 
    RowBox[{"50", "*", "400"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"u", "[", "#", "]"}], ",", 
       RowBox[{"proud", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"tmax", "-", "0.04"}], ",", "tmax", ",", "\[CapitalDelta]t"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"data", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "i"}], "}"}]}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<datatui.csv\>\"", ",", "data"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.720415405890625*^9, 3.720415829890625*^9}, {
  3.72041591090625*^9, 3.72041596359375*^9}, {3.720415995421875*^9, 
  3.720416066140625*^9}, {3.7204255821875*^9, 3.720425607234375*^9}, {
  3.720425764484375*^9, 3.720425768328125*^9}, {3.72042586840625*^9, 
  3.720425876046875*^9}, {3.720425919984375*^9, 3.720426100390625*^9}, {
  3.720426144984375*^9, 3.7204262108125*^9}, {3.720516790140625*^9, 
  3.72051679821875*^9}}]
},
WindowSize->{1108, 783},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 333, 10, 103, "Input"],
Cell[893, 32, 1430, 42, 218, "Input"],
Cell[2326, 76, 1602, 45, 131, "Input"],
Cell[3931, 123, 2554, 75, 303, "Input"]
}
]
*)

(* End of internal cache information *)
