(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35342,        876]
NotebookOptionsPosition[     34790,        854]
NotebookOutlinePosition[     35191,        871]
CellTagsIndexPosition[     35148,        868]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.638255496078125*^9, 3.638255503171875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", "listDat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
       RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
       "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
       ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
       "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Accumulate", "[", "listDat", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"Prepend", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"aclist", "[", 
                  RowBox[{"[", 
                   RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                 RowBox[{"aclist", "[", 
                  RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
              ")"}], ",", 
             RowBox[{"aclist", "[", 
              RowBox[{"[", "nOkno", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", 
             SuperscriptBox["nOkno", "2"]], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "y1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", "y2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       FractionBox[
        RowBox[{"y1", "+", 
         RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
         RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
         RowBox[{"2", " ", "x2", " ", "y3"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"y1", "-", 
           RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       RowBox[{"Total", "[", 
        SuperscriptBox[
         RowBox[{"Take", "[", 
          RowBox[{"listDat", ",", 
           RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["y1", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "y1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox[
          RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["10", "6"], 
         SuperscriptBox["sr", "2"], 
         FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejNx5", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"listDat_", ",", "sr_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ksr2_", ",", "ksr1_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", "mozne", ",", "start", ",",
        "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", ",", "sd2", 
       ",", "nSampl", ",", "ykvref", ",", "varmin", ",", "pomer", ",", "fix", 
       ",", "sortFix", ",", "ndat"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Accumulate", "[", "listDat", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"Prepend", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"aclist", "[", 
                  RowBox[{"[", 
                   RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                 RowBox[{"aclist", "[", 
                  RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
              ")"}], ",", 
             RowBox[{"aclist", "[", 
              RowBox[{"[", "nOkno", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", "nOkno"], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"zde", " ", "zmena"}], ",", " ", 
            RowBox[{"bylo", " ", 
             FractionBox["1.", 
              SuperscriptBox["nOkno", "2"]]}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           SuperscriptBox["ksr1", 
            RowBox[{"-", "1"}]], "*", "sr"}], "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           SuperscriptBox["ksr2", 
            RowBox[{"-", "1"}]], "*", "sr"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"fix", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"krok", ",", "start"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sortFix", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"fix", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "<", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"y1", ">", "y2"}], "&&", 
          RowBox[{"y3", ">", "y2"}]}], ",", 
         FractionBox[
          RowBox[{"y1", "+", 
           RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
           RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
           RowBox[{"2", " ", "x2", " ", "y3"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"y1", "-", 
             RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]], ",", 
         RowBox[{"sortFix", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"y1", ">", "y2"}], "&&", 
          RowBox[{"y3", ">", "y2"}]}], ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["y1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], 
            "-", 
            RowBox[{"2", " ", "y1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"y1", "-", 
              RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ",", 
         RowBox[{"sortFix", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ndat", "=", 
       RowBox[{"1.", "*", 
        RowBox[{"Length", "[", "listDat", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "nx"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["ndat", "3"]}], "+", 
           RowBox[{"3", " ", "nx"}], "+", 
           SuperscriptBox["nx", "2"], "+", 
           RowBox[{
            SuperscriptBox["ndat", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{"3", " ", "nx"}]}], ")"}]}], "+", 
           RowBox[{"ndat", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"4", " ", "nx"}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"12", " ", 
         SuperscriptBox["nx", "2"]}]]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["10", "7"], 
          RowBox[{"Abs", "[", "varmin", "]"}]}], 
         RowBox[{
          RowBox[{"Abs", "[", "ykvref", "]"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "3"}]]}]], ",", 
        RowBox[{"N", "@", "pomer"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}, {3.6385444074375*^9, 
   3.6385444106875*^9}, {3.63854447640625*^9, 3.638544486703125*^9}, 
   3.638544813265625*^9, {3.638545399640625*^9, 3.638545411046875*^9}, {
   3.638545604296875*^9, 3.63854564234375*^9}, {3.638545819921875*^9, 
   3.63854582409375*^9}, {3.6385463191875*^9, 3.638546329828125*^9}, {
   3.638546859625*^9, 3.638546868*^9}, {3.638546911921875*^9, 
   3.638546916203125*^9}, {3.64386655996875*^9, 3.643866666078125*^9}, {
   3.643866709984375*^9, 3.643866737765625*^9}, {3.643866809421875*^9, 
   3.6438668958125*^9}, {3.64386693225*^9, 3.6438669958125*^9}, {
   3.643868896703125*^9, 3.643868903859375*^9}, {3.643869569359375*^9, 
   3.643869570609375*^9}, {3.643869603625*^9, 3.643869628765625*^9}, 
   3.6438696996875*^9, {3.643870231578125*^9, 3.6438702908125*^9}, 
   3.643870321421875*^9, {3.643870376796875*^9, 3.64387037740625*^9}, {
   3.643870436671875*^9, 3.643870445171875*^9}, {3.643870483203125*^9, 
   3.64387048790625*^9}, {3.643878834078125*^9, 3.643878837265625*^9}, {
   3.643879901546875*^9, 3.6438799103125*^9}, {3.643879946671875*^9, 
   3.64388000353125*^9}, {3.643881072703125*^9, 3.643881073734375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "nos", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nos", "[", 
      RowBox[{"listDat_", ",", "nOkn_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sd2", ",", "aclist", ",", "nSampl", ",", "fce", ",", "meansoknas"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"sd2", "[", "list_", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
           RowBox[{
            RowBox[{"mean", "=", 
             RowBox[{"Mean", "[", "list", "]"}]}], ";", 
            RowBox[{"mean2", "=", 
             RowBox[{"Mean", "[", 
              RowBox[{"list", "*", "list"}], "]"}]}], ";", 
            RowBox[{"mean2", "-", 
             SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aclist", "=", 
         RowBox[{"Accumulate", "[", "listDat", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nSampl", "=", 
         RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"rn", "=", 
             RowBox[{"Range", "[", 
              RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"soucty", "=", 
             RowBox[{"Prepend", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"aclist", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                   RowBox[{"aclist", "[", 
                    RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
                ")"}], ",", 
               RowBox[{"aclist", "[", 
                RowBox[{"[", "nOkno", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"sigma", "=", 
             RowBox[{
              FractionBox["1.", 
               SuperscriptBox[
                RowBox[{"(", "nOkno", ")"}], "2"]], 
              RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"meansoknas", "=", 
             RowBox[{"Mean", "/@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Take", "[", 
                  RowBox[{"listDat", ",", 
                   RowBox[{"{", 
                    RowBox[{"#", ",", 
                    RowBox[{"#", "+", "nOkn"}]}], "}"}]}], "]"}], "&"}], "/@", 
                RowBox[{"Range", "[", 
                 RowBox[{"nSampl", "-", "nOkn"}], "]"}]}], ")"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"nOkno", ",", "sigma", ",", 
              RowBox[{"Variance", "[", "meansoknas", "]"}], ",", 
              FractionBox[
               RowBox[{"Variance", "[", "soucty", "]"}], 
               SuperscriptBox[
                RowBox[{"(", "nOkno", ")"}], "2"]]}], "}"}]}]}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"fce", "[", "nOkn", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pomdat", "=", 
     RowBox[{
      RowBox[{"Range", "[", "10", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"nos", "[", 
    RowBox[{"pomdat", ",", "2"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6557971163125*^9, 3.655797226671875*^9}, {
   3.65579725915625*^9, 3.655797333484375*^9}, 3.65579742884375*^9, {
   3.65579746465625*^9, 3.65579753409375*^9}, {3.65579758675*^9, 
   3.65579768203125*^9}, {3.655797722765625*^9, 3.655797724609375*^9}, {
   3.65579778515625*^9, 3.655797826046875*^9}, {3.65579785653125*^9, 
   3.65579785884375*^9}, {3.6557979045*^9, 3.655797928453125*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6.666666666666664`", ",", "6.`", ",", "7.5`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.65579731571875*^9, 3.655797333703125*^9}, 
   3.655797521078125*^9, 3.65579759475*^9, {3.655797627671875*^9, 
   3.655797682296875*^9}, 3.655797725296875*^9, {3.655797786203125*^9, 
   3.65579782678125*^9}, 3.655797859109375*^9, 3.655797929125*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.655797261015625*^9}]
},
WindowSize->{1113, 767},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 511, 12, 98, "Input"],
Cell[1059, 34, 12778, 308, 1171, "Input"],
Cell[13840, 344, 16031, 384, 1379, "Input"],
Cell[CellGroupData[{
Cell[29896, 732, 4396, 107, 701, "Input"],
Cell[34295, 841, 389, 7, 42, "Output"]
}, Open  ]],
Cell[34699, 851, 87, 1, 71, "Input"]
}
]
*)

(* End of internal cache information *)
