(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5544,        176]
NotebookOptionsPosition[      5079,        157]
NotebookOutlinePosition[      5480,        174]
CellTagsIndexPosition[      5437,        171]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", "pom"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{3.640412956954171*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<data.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.63974994203125*^9, 3.639750066390625*^9}, 
   3.63975082021875*^9, {3.639751736421875*^9, 3.639751933046875*^9}, {
   3.639752055140625*^9, 3.63975205540625*^9}, {3.640412960813546*^9, 
   3.640412980282296*^9}, {3.640413089313546*^9, 3.640413093079171*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"imp", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "*", "R"}], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "+", "R"}]]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "R_", ",", "X_"}], "}"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"R", "-", 
       RowBox[{"Re", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"X", "-", 
       RowBox[{"Im", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"forFindMin", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"err", "/@", "dat"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"{", "forFindMin", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"R", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.640413204469796*^9, 3.640413306110421*^9}, {
  3.640413365407296*^9, 3.640413508016671*^9}, {3.640413539141671*^9, 
  3.640413579876046*^9}, {3.640413866485421*^9, 3.640413889313546*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{
    RowBox[{"imp", "[", "f", "]"}], "/.", "min"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.640413583579171*^9, 3.640413610126046*^9}, 
   3.640413899438546*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fmin", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmax", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "vys", "]"}], ",", 
       RowBox[{"Im", "[", "vys", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "fmin", ",", "fmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dat", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}]}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<ReZ[\[CapitalOmega]]\>\"", ",", "\"\<ImZ[\[CapitalOmega]]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.009", "]"}], ",", "Red"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pict.png\>\"", ",", "%", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.640413615172921*^9, 3.640413681001046*^9}, {
  3.640413754829171*^9, 3.640413758188546*^9}, {3.640413799172921*^9, 
  3.640413812782296*^9}, {3.640414121501046*^9, 3.640414141922921*^9}}]
},
WindowSize->{1080, 617},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 422, 11, 152, "Input"],
Cell[970, 33, 454, 9, 43, "Input"],
Cell[1427, 44, 1579, 48, 191, "Input"],
Cell[3009, 94, 220, 6, 43, "Input"],
Cell[3232, 102, 1843, 53, 233, "Input"]
}
]
*)

(* End of internal cache information *)
