(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7771,        232]
NotebookOptionsPosition[      7102,        205]
NotebookOutlinePosition[      7502,        222]
CellTagsIndexPosition[      7459,        219]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pocatek", ",", "konec"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Vt", ",", "Nt"}], "}"}], ",", "VenkovniTeplota", ",", 
    "PokrytiOblohy"}], "}"}], "*)"}]], "Input",
 CellChangeTimes->{3.668317702453125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fileNames", "=", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", "]"}], ",", 
     RowBox[{"FileNames", "[", "\"\<*.nb\>\"", "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.668317735734375*^9, 3.668317764765625*^9}, {
   3.66831780396875*^9, 3.668317890046875*^9}, {3.66831829965625*^9, 
   3.66831831915625*^9}, {3.668318432625*^9, 3.668318434765625*^9}, 
   3.726215430015625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zprac1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zprac1", "[", "fileName_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "pocatek", ",", "konec", ",", "Vt", ",", "Nt", ",", "VenkovniTeplota", 
       ",", "PokrytiOblohy", ",", "nDni", ",", "teploty", ",", "teploty1"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pocatek", ",", "konec"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Vt", ",", "Nt"}], "}"}], ",", "VenkovniTeplota", ",", 
         "PokrytiOblohy"}], "}"}], "=", 
       RowBox[{"Get", "[", "fileName", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nDni", "=", 
       RowBox[{"DaysBetween", "[", 
        RowBox[{"pocatek", ",", "konec"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"teploty1", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Split", "[", 
          RowBox[{
           RowBox[{"Last", "/@", "VenkovniTeplota"}], ",", 
           RowBox[{
            RowBox[{"#", "==", " ", 
             RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}]}], "&"}]}],
           "]"}], ",", "3", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"teploty", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"First", "/@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"DeleteCases", "[", 
            RowBox[{
             RowBox[{"DeleteCases", "[", 
              RowBox[{"teploty1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"b_List", "?", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}], 
                   ")"}]}], ",", "_", ",", "_"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"_", ",", "_", ",", 
               RowBox[{"b_List", "?", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}], 
                 ")"}]}]}], "}"}]}], "]"}], "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "a_Real", "}"}], ",", 
              RowBox[{"b_List", "?", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}], 
                ")"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"c_", "?", "NumericQ"}], "}"}]}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"Partition", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"{", "#", "}"}], "&"}], "/@", 
               RowBox[{"Range", "[", 
                RowBox[{"a", ",", "c", ",", 
                 FractionBox[
                  RowBox[{"c", "-", "a"}], 
                  RowBox[{"Length", "[", "b", "]"}]]}], "]"}]}], ",", "3", 
              ",", "1"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pocatek", ",", "konec"}], "}"}], ",", "teploty", ",", 
        "fileName"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6683200990625*^9, 3.6683201079375*^9}, {
   3.66832015253125*^9, 3.668320176546875*^9}, {3.668320264109375*^9, 
   3.668320267453125*^9}, {3.668321708265625*^9, 3.66832171540625*^9}, {
   3.66832181425*^9, 3.66832184025*^9}, {3.668322171390625*^9, 
   3.668322174671875*^9}, {3.668322423984375*^9, 3.668322488890625*^9}, {
   3.668322972015625*^9, 3.66832298275*^9}, 3.668323055484375*^9, {
   3.670583133875*^9, 3.670583135703125*^9}, {3.6705836538125*^9, 
   3.670583667421875*^9}, 3.67118597759375*^9, {3.726215323625*^9, 
   3.726215343*^9}, {3.7262153756875*^9, 3.726215422078125*^9}, {
   3.72621547696875*^9, 3.726215478296875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"zprac1", "/@", "fileNames"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.66832257053125*^9, 3.668322573625*^9}, {
   3.6683230325625*^9, 3.6683230333125*^9}, 3.726215314578125*^9, 
   3.726215408390625*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dats", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.726215442703125*^9, 3.72621544534375*^9}, 
   3.726215531640625*^9, 3.750651224625*^9, {3.750651315421875*^9, 
   3.7506513266875*^9}}],

Cell[BoxData["6171"], "Output",
 CellChangeTimes->{
  3.750651225375*^9, {3.75065131990625*^9, 3.750651327296875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dats", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.750651341671875*^9, 3.7506513424375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2010", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2010", ",", "9", ",", "18"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7506513426875*^9}]
}, Open  ]]
},
WindowSize->{918, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 330, 9, 98, "Input"],
Cell[890, 31, 305, 9, 43, "Input"],
Cell[1198, 42, 555, 14, 71, "Input"],
Cell[1756, 58, 4149, 102, 674, "Input"],
Cell[5908, 162, 264, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[6197, 172, 322, 8, 43, "Input"],
Cell[6522, 182, 118, 2, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6677, 189, 168, 4, 43, "Input"],
Cell[6848, 195, 238, 7, 42, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

