(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60073,       1665]
NotebookOptionsPosition[     57696,       1592]
NotebookOutlinePosition[     58160,       1611]
CellTagsIndexPosition[     58117,       1608]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Metoda Runge-Kutta", "Title",
 CellChangeTimes->{{3.562076342328125*^9, 3.56207634825*^9}, {
  3.562077339375*^9, 3.562077340265625*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell["Taylor\:016fv rozvoj", "Subtitle",
 CellChangeTimes->{{3.562076371890625*^9, 3.562076378203125*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "... U mnoha funkc\[IAcute] plat\[IAcute], \:017ee v\[IAcute]ce \[CHacek]len\
\:016f Taylorova rozvoje poskytne lep\[SHacek]\[IAcute] p\:0159esnost n\
\[AAcute]hrady funkce. Uk\[AAcute]zka zp\:0159es\:0148ov\[AAcute]n\[IAcute] n\
\[AAcute]hrady je v notebooku ",
 StyleBox["CAO-RungeKutta.nb.", "Program",
  FontWeight->"Bold"],
 " ..."
}], "Text",
 CellChangeTimes->{{3.562076561859375*^9, 3.562076651765625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Pi]", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[ExponentialE]", "*", "x"}], "]"}]}], "+", 
    RowBox[{"\[ExponentialE]", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "*", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTaylor", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"N", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nmax", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rozvoje", "=", 
   RowBox[{"fTaylor", "/@", 
    RowBox[{"Range", "[", "nmax", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pl", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"rozvoje", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\< f[x]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "0.63", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0045", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "0.", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0045", "]"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"pl", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "nmax", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.552967405921875*^9, 3.55296769175*^9}, {
   3.55296772334375*^9, 3.55296772625*^9}, {3.552967757234375*^9, 
   3.552967928640625*^9}, {3.552967984421875*^9, 3.552968003609375*^9}, {
   3.552968037140625*^9, 3.55296807040625*^9}, 3.5529684814375*^9, 
   3.561815859269237*^9, {3.5620763978125*^9, 3.56207641446875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Odvozen\[IAcute] metody Runge-Kutta", "Subtitle",
 CellChangeTimes->{{3.562076937484375*^9, 3.562076943171875*^9}, {
  3.56207734503125*^9, 3.56207734571875*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "... V notebooku ",
 StyleBox["CAO-RungeKutta.nb", "Program",
  FontWeight->"Bold"],
 " je uk\[AAcute]z\[AAcute]n postup, jak odvodit itera\[CHacek]n\[IAcute] \
krok Eulerovy metody vyu\:017e\[IAcute]vaj\[IAcute]c\[IAcute] prvn\[IAcute] t\
\:0159i \[CHacek]leny Taylorova rozvoje. Pou\:017eijeme ale trik: budeme \
hledat vyj\[AAcute]d\:0159en\[IAcute] tohoto rozvoje tak, abychom nemuseli vy\
\[CHacek]\[IAcute]slovat vy\[SHacek]\[SHacek]\[IAcute] derivace ne\:017e ",
 StyleBox["y",
  FontSlant->"Italic"],
 "'(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") =",
 StyleBox["f",
  FontSlant->"Italic"],
 " (",
 StyleBox["t",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")).\nHledejme n\[AAcute]hradu ve tvaru:\n\t\t\t",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "0 + \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 ") \[TildeTilde] ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "0) + ",
 StyleBox["v",
  FontSlant->"Italic"],
 "1 \[CenterDot] ",
 StyleBox["p",
  FontSlant->"Italic"],
 "1 + ",
 StyleBox["v",
  FontSlant->"Italic"],
 "2 \[CenterDot] ",
 StyleBox["p",
  FontSlant->"Italic"],
 "2,\nkde ",
 StyleBox["v",
  FontSlant->"Italic"],
 "1 a ",
 StyleBox["v",
  FontSlant->"Italic"],
 "2 jsou v\[AAcute]hy p\:0159\[IAcute]r\:016fstku ",
 StyleBox["p",
  FontSlant->"Italic"],
 "1 a ",
 StyleBox["p",
  FontSlant->"Italic"],
 "2:\n\t\t\t",
 StyleBox["p",
  FontSlant->"Italic"],
 "1 = \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 " \[CenterDot] ",
 StyleBox["f",
  FontSlant->"Italic"],
 " (",
 StyleBox["t",
  FontSlant->"Italic"],
 "0, ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "0)) ,\n\t\t\t",
 StyleBox["p",
  FontSlant->"Italic"],
 "2 = \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 " \[CenterDot] ",
 StyleBox["f",
  FontSlant->"Italic"],
 " (",
 StyleBox["t",
  FontSlant->"Italic"],
 "0 + ",
 StyleBox["a",
  FontSlant->"Italic"],
 " \[CenterDot] \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "0) + ",
 StyleBox["b",
  FontSlant->"Italic"],
 " \[CenterDot] ",
 StyleBox["p",
  FontSlant->"Italic"],
 "1)"
}], "Text",
 CellChangeTimes->{{3.562076561859375*^9, 3.562076651765625*^9}, {
  3.562076696*^9, 3.562076807734375*^9}, {3.562076838546875*^9, 
  3.562076911640625*^9}, {3.56209474690625*^9, 3.5620947475*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"\[CapitalDelta]t", "*", 
    RowBox[{"f", "[", 
     RowBox[{"t0", ",", 
      RowBox[{"y", "[", "t0", "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"\[CapitalDelta]t", "*", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"t0", "+", 
       RowBox[{"a", "*", "\[CapitalDelta]t"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "t0", "]"}], "+", 
       RowBox[{"b", "*", "p1"}]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yDalRunge", "=", 
   RowBox[{
    RowBox[{"y", "[", "t0", "]"}], "+", 
    RowBox[{"v1", "*", "p1"}], "+", 
    RowBox[{"v2", "*", "p2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yDalTaylorPom", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "2"}], "}"}]}], "]"}], "]"}], "/.", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"\[CapitalDelta]t", "+", "t0"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosders", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t0", "]"}], "->", 
        RowBox[{"f", "[", 
         RowBox[{"t0", ",", 
          RowBox[{"y", "[", "t0", "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t0", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yDalTaylor", "=", 
   RowBox[{"yDalTaylorPom", "//.", "dosders"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"yDalRunge", ",", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]t", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"%", "-", "yDalTaylor"}], ",", 
        SuperscriptBox["\[CapitalDelta]t", "#"]}], "]"}], "\[Equal]", "0"}], 
     "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "2"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.552922970171875*^9, 3.552923290328125*^9}, {
   3.552923322609375*^9, 3.552923388609375*^9}, {3.55292354259375*^9, 
   3.55292357525*^9}, {3.552923818328125*^9, 3.5529239391875*^9}, {
   3.552924549265625*^9, 3.552924558625*^9}, 3.552924605671875*^9, {
   3.552924791625*^9, 3.552924794828125*^9}, {3.552925468234375*^9, 
   3.55292549478125*^9}, 3.552926230296875*^9, {3.55292627003125*^9, 
   3.552926300046875*^9}, {3.552926357234375*^9, 3.55292641159375*^9}, {
   3.552926535453125*^9, 3.552926542140625*^9}, {3.552926844375*^9, 
   3.552926876203125*^9}, {3.552926907265625*^9, 3.552926939109375*^9}, {
   3.552926992984375*^9, 3.552927036390625*^9}, {3.552927081078125*^9, 
   3.55292712959375*^9}, {3.552927490796875*^9, 3.552927491921875*^9}, {
   3.552927522046875*^9, 3.552927621828125*^9}, {3.55292767515625*^9, 
   3.55292769459375*^9}, {3.552927741078125*^9, 3.55292775421875*^9}, {
   3.552927787546875*^9, 3.552927923390625*^9}, {3.5529280273125*^9, 
   3.552928053*^9}, {3.55292810640625*^9, 3.55292816328125*^9}, {
   3.55292820578125*^9, 3.552928208375*^9}, {3.55292830278125*^9, 
   3.552928304078125*^9}, {3.55292833575*^9, 3.552928337875*^9}, {
   3.55292919703125*^9, 3.5529293543125*^9}, {3.552929488265625*^9, 
   3.55292949675*^9}, {3.552929634046875*^9, 3.552929773921875*^9}, 
   3.552930950171875*^9, {3.552962129703125*^9, 3.55296219565625*^9}, 
   3.5529673981875*^9, {3.55296808053125*^9, 3.5529680818125*^9}, {
   3.552982036515625*^9, 3.552982073359375*^9}, {3.552982258765625*^9, 
   3.552982344078125*^9}, {3.56207245509375*^9, 3.562072457875*^9}, {
   3.56207295903125*^9, 3.56207295984375*^9}, {3.562076690296875*^9, 
   3.56207669184375*^9}}],

Cell[TextData[{
 "... V notebooku ",
 StyleBox["CAO-RungeKutta.nb", "Program",
  FontWeight->"Bold"],
 " je uk\[AAcute]z\[AAcute]n numerick\[YAcute] postup vy\:0159e\[SHacek]en\
\[IAcute] rovnosti koeficient\:016f: Za hodnoty funkce ",
 StyleBox["f",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a jej\[IAcute]ch derivac\[IAcute] jsou dosazov\[AAcute]na n\[AAcute]hodn\
\[AAcute] \[CHacek]\[IAcute]sla, vytvo\:0159eny rozd\[IAcute]ly \
prav\[YAcute]ch a lev\[YAcute]ch stran a se\[CHacek]teny p\:0159es \
v\[SHacek]echny rovnice a hled\[AAcute]no minimum v\[YAcute]sledn\[EAcute]ho \
v\[YAcute]razu. Je-li bl\[IAcute]zk\[EAcute] nule, jsou rovnice vy\:0159e\
\[SHacek]eny dob\:0159e. Je jedno, jak k v\[YAcute]sledku dosp\:011bjeme, \
tohle se autor\:016fm zd\[AAcute]lo rychlej\[SHacek]\[IAcute] naprogramovat. \
..."
}], "Text",
 CellChangeTimes->{{3.562076561859375*^9, 3.562076651765625*^9}, {
  3.562076696*^9, 3.562076807734375*^9}, {3.562076838546875*^9, 
  3.562076911640625*^9}, {3.562080789140625*^9, 3.56208089346875*^9}, {
  3.562094750859375*^9, 3.562094754484375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"trya", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tryn", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numRce", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"rce", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"_", ",", "_"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"_", ",", "_"}], "]"}], "->", 
          RowBox[{"Random", "[", "]"}]}], ",", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"_", ",", "_"}], "]"}], "->", 
          RowBox[{"Random", "[", "]"}]}]}], "}"}]}], "&"}], "/@", 
     RowBox[{"Range", "[", "tryn", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norm", ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", "#", "]"}], "2"], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"promin", "=", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"numRce", "/.", 
        RowBox[{
         RowBox[{"lhs_", "\[Equal]", "rhs_"}], "\[RuleDelayed]", 
         RowBox[{"norm", "[", 
          RowBox[{"lhs", "-", "rhs"}], "]"}]}]}], ")"}]}], "]"}], "/.", 
    RowBox[{"a", "\[Rule]", "trya"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proms", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Random", "[", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"promin", ",", "_Symbol", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dos", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"min", "=", 
        RowBox[{"FindMinimum", "[", 
         RowBox[{"promin", ",", "proms"}], "]"}]}], ")"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "trya"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Pro hodnoty neznamych \>\"", ",", "dos"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<je soucet normovanych odchylek splneni rovnic roven \>\"", ",", 
   RowBox[{"min", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", "]"}]}], "Input",
 CellChangeTimes->{
  3.552962206765625*^9, {3.552981953859375*^9, 3.552982002125*^9}, {
   3.552982062140625*^9, 3.5529820633125*^9}, {3.5529820969375*^9, 
   3.55298223659375*^9}, {3.552982323109375*^9, 3.5529823503125*^9}, {
   3.5620724973125*^9, 3.562072498875*^9}, {3.562072548234375*^9, 
   3.562072548546875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Porovn\[AAcute]n\[IAcute] odvozen\[EAcute] metody Runge-Kutta s metodou \
NDSolve\
\>", "Subtitle",
 CellChangeTimes->{{3.562077249546875*^9, 3.56207725534375*^9}, {
  3.562077315140625*^9, 3.562077331890625*^9}, {3.56208060075*^9, 
  3.562080635859375*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "... V dal\[SHacek]\[IAcute] \[CHacek]\[AAcute]sti notebooku ",
 StyleBox["CAO-RungeKutta.nb", "Program",
  FontWeight->"Bold"],
 " je uk\[AAcute]z\[AAcute]no porovn\[AAcute]n\[IAcute] v\[YAcute]sledk\:016f \
odvozen\[EAcute] metody s NDSolve. Doporu\[CHacek]ujeme pohr\[AAcute]t si s r\
\:016fzn\[YAcute]mi hodnotami po\[CHacek]tu krok\:016f ",
 StyleBox["n", "Program",
  FontWeight->"Bold"],
 ", p\:0159\[IAcute]padn\:011b m\:011bnit zadanou funkci ",
 StyleBox["f",
  FontSlant->"Italic"],
 " (v notebooku se jmenuje ",
 StyleBox["myf", "Program",
  FontWeight->"Bold"],
 "). V\[SHacek]imn\:011bte si zejm\[EAcute]na, jak \:201ezlob\[IAcute]\
\[OpenCurlyDoubleQuote] skok v derivaci (proto je ",
 StyleBox["myf", "Program",
  FontWeight->"Bold"],
 " zad\[AAcute]na pomoc\[IAcute] ",
 StyleBox["If", "Program",
  FontWeight->"Bold"],
 "). Tam, kde hroz\[IAcute] nespojitost ",
 StyleBox["f",
  FontSlant->"Italic"],
 ", hroz\[IAcute] nespolehlivost numerick\[YAcute]ch re\[SHacek]en\[IAcute] \
diferenci\[AAcute]ln\[IAcute]ch rovnic. Nejen tam ... \
Na\[SHacek]test\[IAcute] v oblasti elektrick\[YAcute]ch obvod\:016f \
n\[AAcute]m p\:0159\[IAcute]roda takov\[EAcute] funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 " v n\[AAcute]mi zvolen\[EAcute]m spojit\[EAcute]m popisu sv\:011bta \
zakazuje. ..."
}], "Text",
 CellChangeTimes->{{3.562076561859375*^9, 3.562076651765625*^9}, {
  3.562076696*^9, 3.562076807734375*^9}, {3.562076838546875*^9, 
  3.562076911640625*^9}, {3.562080789140625*^9, 3.56208089346875*^9}, {
  3.56208093784375*^9, 3.562081028890625*^9}, {3.562094758421875*^9, 
  3.56209477746875*^9}, {3.562095512140625*^9, 3.56209551303125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tStart", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tEnd", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yStart", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myf", "[", 
    RowBox[{"t_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"t", "<", 
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"tStart", "+", "tEnd"}], ")"}]}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3", "t"}], "-", 
       RowBox[{".5", "y"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"-", "y"}], "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"t", "+", 
        SuperscriptBox["y", "2"]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "250"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox[
    RowBox[{"tEnd", "-", "tStart"}], "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dal", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"yDalRunge", "/.", "dos"}], ")"}], "/.", 
        RowBox[{"f", "\[RuleDelayed]", "myf"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t0", "\[Rule]", "t"}], ",", 
        RowBox[{
         RowBox[{"y", "[", "t0", "]"}], "\[Rule]", "y"}]}], "}"}]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"dal", ",", 
     RowBox[{"{", 
      RowBox[{"tStart", ",", "yStart"}], "}"}], ",", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resNDS", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"myf", "[", 
          RowBox[{"t", ",", 
           RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "yStart"}]}], "}"}], 
      ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", "tEnd"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "resNDS"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", "tEnd"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.005", "]"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t[s]\>\"", ",", "\"\<y\>\""}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"res", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.55292980559375*^9, 3.5529298076875*^9}, {
   3.55292996203125*^9, 3.5529299785*^9}, {3.5529300131875*^9, 
   3.5529301323125*^9}, {3.55293017409375*^9, 3.552930177359375*^9}, {
   3.55293028134375*^9, 3.552930445421875*^9}, {3.552930481125*^9, 
   3.55293058234375*^9}, {3.552930614765625*^9, 3.5529309408125*^9}, {
   3.55296327921875*^9, 3.55296339821875*^9}, {3.55298340809375*^9, 
   3.552983433125*^9}, 3.5604062688125*^9, 3.56207258509375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Pou\:017eit\[IAcute] obl\[IAcute]ben\[EAcute] metody Runge-Kutta 4. \:0159\
\[AAcute]du\
\>", "Subtitle",
 CellChangeTimes->{{3.562077249546875*^9, 3.56207725534375*^9}, {
  3.562077315140625*^9, 3.562077331890625*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "... V p\:0159edposledn\[IAcute] \[CHacek]\[AAcute]sti je uk\[AAcute]z\
\[AAcute]no pou\:017eit\[IAcute] obl\[IAcute]ben\[EAcute] metody Runge-Kutta \
\[CHacek]tvrt\[EAcute]ho \:0159\[AAcute]du (shodovalo by se p\:011bt \
\[CHacek]len\:016f Taylorova rozvoje, tedy a\:017e do \[CHacek]tvrt\[EAcute] \
mocniny ",
 StyleBox["t",
  FontSlant->"Italic"],
 " v\[CHacek]etne). ..."
}], "Text",
 CellChangeTimes->{{3.56208117315625*^9, 3.56208120415625*^9}, {
  3.562095148875*^9, 3.562095152078125*^9}, {3.5620955071875*^9, 
  3.56209550784375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"derivace", "[", 
      RowBox[{"t_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"myf", "[", 
      RowBox[{"t", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaKrok", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{
           RowBox[{"t", "+", 
            FractionBox["\[CapitalDelta]t", "2"]}], ",", 
           RowBox[{"y", "+", 
            RowBox[{
             FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{
           RowBox[{"t", "+", 
            FractionBox["\[CapitalDelta]t", "2"]}], ",", 
           RowBox[{"y", "+", 
            RowBox[{
             FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{
           RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
           RowBox[{"y", "+", 
            RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res2", "=", 
     RowBox[{"NestList", "[", 
      RowBox[{"RungeKuttaKrok", ",", 
       RowBox[{"{", 
        RowBox[{"tStart", ",", "yStart"}], "}"}], ",", "n"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "/.", "resNDS"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tStart", ",", "tEnd"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<y\>\""}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"res2", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.55298328475*^9, 3.55298331590625*^9}, {
   3.55298335371875*^9, 3.552983425421875*^9}, 3.56040626346875*^9, {
   3.562072611203125*^9, 3.56207265903125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Grafick\[AAcute] demonstrace metody Runge-Kutta 4. \:0159\[AAcute]du\
\>", "Subtitle",
 CellChangeTimes->{{3.562077249546875*^9, 3.56207725534375*^9}, {
   3.562077315140625*^9, 3.562077331890625*^9}, 3.562080686359375*^9, {
   3.562084743421875*^9, 3.562084758015625*^9}},
 Background->GrayLevel[0.85]],

Cell["\<\
Zkouman\[AAcute] funkce bude definovan\[AAcute] svoj\[IAcute] \
derivac\[IAcute] a po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute]m bodem.\
\>", "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208521171875*^9, 3.562085226921875*^9}, {3.562092229421875*^9, 
  3.562092311984375*^9}, {3.56209435059375*^9, 3.56209451784375*^9}, {
  3.562094925984375*^9, 3.562094960296875*^9}, {3.56209516053125*^9, 
  3.5620951615625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"der", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", 
       RowBox[{
        SuperscriptBox["t", "2"], "+", 
        SuperscriptBox["y", "3"], "-", "6"}], "]"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"der", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", 
       RowBox[{
        SuperscriptBox["t", "3"], "+", "y", "+", "0.8"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yStart", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", "0.35"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.56040647671875*^9, 3.560406523625*^9}, {
   3.56040656846875*^9, 3.56040686175*^9}, {3.560406993703125*^9, 
   3.56040725221875*^9}, 3.56040728459375*^9, {3.560407318703125*^9, 
   3.560407417828125*^9}, 3.560407488703125*^9, {3.5604076575625*^9, 
   3.560407668921875*^9}, 3.560408765234375*^9, 3.562072608078125*^9, {
   3.562080674171875*^9, 3.562080675953125*^9}, 3.56208473196875*^9, {
   3.562085994*^9, 3.562085995515625*^9}, {3.56208603546875*^9, 
   3.5620860365625*^9}, {3.562086200140625*^9, 3.56208620215625*^9}, {
   3.56208626215625*^9, 3.562086290328125*^9}, {3.5620863248125*^9, 
   3.562086325265625*^9}, {3.562086380765625*^9, 3.562086382046875*^9}, {
   3.562086425296875*^9, 3.562086427484375*^9}, {3.5620866136875*^9, 
   3.56208674321875*^9}, {3.562086778640625*^9, 3.5620867791875*^9}, {
   3.562087542375*^9, 3.562087562171875*^9}, {3.562087594109375*^9, 
   3.562087600125*^9}, {3.562087641328125*^9, 3.56208767625*^9}, {
   3.562087740984375*^9, 3.56208777534375*^9}, {3.562087844171875*^9, 
   3.5620878443125*^9}, {3.562088014421875*^9, 3.562088014515625*^9}, {
   3.5620880538125*^9, 3.562088114546875*^9}, {3.5620948966875*^9, 
   3.562094909515625*^9}}],

Cell[TextData[{
 "Nejprve si zobrazme pr\:016fb\:011bh zkouman\[EAcute] funkce \"p\:0159esn\
\:011b\" spo\[CHacek]\[IAcute]tan\[YAcute] pomoc\[IAcute] metody ",
 StyleBox["NDSolve", "Program",
  FontWeight->"Bold"],
 " (ka\:017edop\[AAcute]dn\:011b spo\[CHacek]\[IAcute]tan\[YAcute] s krokem \
mnohem men\[SHacek]\[IAcute]m ne\:017eli \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 "):"
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208521171875*^9, 3.562085226921875*^9}, {3.562092229421875*^9, 
  3.562092311984375*^9}, {3.56209435059375*^9, 3.56209451784375*^9}, {
  3.5620949673125*^9, 3.562094968890625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rNDS", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"der", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"y", "[", "t", "]"}]}], "}"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "yStart"}]}], "}"}], 
      ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"tStart", "+", "\[CapitalDelta]t"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plNDS", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "rNDS"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tStart", ",", 
      RowBox[{"tStart", "+", "\[CapitalDelta]t"}]}], "}"}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"tStart", ",", "\"\<t\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"tStart", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          "\"\<t+\!\(\*FractionBox[\(\[CapitalDelta]t\), \(2\)]\)\>\""}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"tStart", "+", "\[CapitalDelta]t"}], ",", 
          "\"\<t+\[CapitalDelta]t\>\""}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tStart", "-", 
        RowBox[{"0.2", "*", "\[CapitalDelta]t"}]}], ",", "0.4"}], "}"}]}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tStart", "-", 
          RowBox[{"0.2", "*", "\[CapitalDelta]t"}]}], ",", 
         RowBox[{"tStart", "+", 
          RowBox[{"1.2", "*", "\[CapitalDelta]t"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", "0.8"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0055", "]"}], ",", "Black"}], "}"}]}]}], 
   "]"}]}]}], "Input"],

Cell[TextData[{
 "Tento pr\:016fb\:011bh budeme aproximovat metodou Runge-Kutta. Z bodu ",
 StyleBox["t",
  FontSlant->"Italic"],
 " do bodu ",
 StyleBox["t",
  FontSlant->"Italic"],
 "+\[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 " sko\[CHacek]\[IAcute]me na jeden krok \[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208521171875*^9, 3.562085226921875*^9}, {3.562092229421875*^9, 
  3.562092311984375*^9}, {3.56209435059375*^9, 3.56209459065625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[TextData[{
 "Spo\[CHacek]\[IAcute]t\[AAcute]me derivaci ",
 StyleBox["k",
  FontSlant->"Italic"],
 "1 v po\[CHacek]\[AAcute]tku (\[CHacek]erven\[YAcute] bod), tedy v bod\:011b \
[",
 StyleBox["t",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")]. Derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "1 v po\[CHacek]\[AAcute]tku m\[AAcute] sm\:011br podle \[CHacek]erven\
\[EAcute] \[CHacek]\[AAcute]rkovan\[EAcute] \[UAcute]se\[CHacek]ky."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208521171875*^9, 3.562085226921875*^9}, {3.562092229421875*^9, 
  3.562092311984375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodStart", "=", 
   RowBox[{"{", 
    RowBox[{"tStart", ",", "yStart"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"znackaBodStart", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
      RowBox[{"Point", "[", "bodStart", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k1", "=", 
   RowBox[{"der", "[", "bodStart", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"yStart", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart"}], ")"}], "*", "k1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"tStart", "-", 
        RowBox[{"0.2", "\[CapitalDelta]t"}]}], ",", 
       RowBox[{"tStart", "+", "\[CapitalDelta]t"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed", ",", 
        RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNDS", ",", "znackaBodStart", ",", "plk1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5620813455625*^9, 3.562081346609375*^9}, {
   3.562091073203125*^9, 3.562091075640625*^9}, {3.56209121153125*^9, 
   3.562091224984375*^9}, {3.5620912573125*^9, 3.562091264265625*^9}, {
   3.56209162828125*^9, 3.562091639859375*^9}, {3.56209176265625*^9, 
   3.56209176459375*^9}, 3.562091885921875*^9, {3.5620923573125*^9, 
   3.562092409453125*^9}, {3.562093497578125*^9, 3.562093529640625*^9}}],

Cell[TextData[{
 "Vyraz\[IAcute]me z po\[CHacek]\[AAcute]tku (\[CHacek]erven\[YAcute] bod) ve \
sm\:011bru derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "1 (\[CHacek]erven\[AAcute] \[SHacek]ipka).\nPopojdeme o ",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 ", tedy dojdeme do bodu [t+",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") + ",
 StyleBox["k",
  FontSlant->"Italic"],
 "1 ",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 "] (modr\[YAcute] bod)."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562086822359375*^9, 3.562086841953125*^9}, {3.562086933703125*^9, 
  3.5620869346875*^9}, {3.56208706040625*^9, 3.562087060953125*^9}, {
  3.56209243290625*^9, 3.562092434515625*^9}, {3.562092464984375*^9, 
  3.562092468640625*^9}, {3.5620925815625*^9, 3.5620925826875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodProk2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"tStart", "+", 
      FractionBox["\[CapitalDelta]t", "2"]}], ",", 
     RowBox[{"yStart", "+", 
      RowBox[{"k1", "*", 
       FractionBox["\[CapitalDelta]t", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk1krok", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"bodStart", ",", "bodProk2"}], "}"}], "]"}]}], "}"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"znackaBodProk2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
      RowBox[{"Point", "[", "bodProk2", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.56209261271875*^9, 3.56209261309375*^9}, {
  3.56209267328125*^9, 3.562092709625*^9}, {3.562093538625*^9, 
  3.562093540296875*^9}}],

Cell[TextData[{
 " V modr\[EAcute]m bod\:011b spo\[CHacek]\[IAcute]t\[AAcute]me novou \
derivaci ",
 StyleBox["k",
  FontSlant->"Italic"],
 "2. Derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "2 v modr\[EAcute]m bod\:011b m\[AAcute] sm\:011br podle modr\[EAcute] \
\[CHacek]\[AAcute]rkovan\[EAcute] \[UAcute]se\[CHacek]ky."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562086822359375*^9, 3.562086841953125*^9}, {3.562086933703125*^9, 
  3.5620869346875*^9}, {3.56208706040625*^9, 3.562087060953125*^9}, {
  3.56209243290625*^9, 3.562092434515625*^9}, {3.562092464984375*^9, 
  3.562092468640625*^9}, {3.562092509390625*^9, 3.562092510109375*^9}, {
  3.562092729828125*^9, 3.562092731453125*^9}, {3.5620927816875*^9, 
  3.5620927829375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"k2", "=", 
   RowBox[{"der", "[", "bodProk2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bodProk2", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart", "-", 
         FractionBox["\[CapitalDelta]t", "2"]}], ")"}], "*", "k2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"tStart", "+", "\[CapitalDelta]t"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Dashed", ",", 
        RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2", ",", "plk2"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.562081355875*^9, {3.562090012359375*^9, 3.562090032359375*^9}, {
   3.562090115015625*^9, 3.56209013315625*^9}, {3.5620901745625*^9, 
   3.562090180921875*^9}, 3.562090231328125*^9, {3.562090286546875*^9, 
   3.562090319375*^9}, {3.562090366484375*^9, 3.562090372640625*^9}, {
   3.56209048109375*^9, 3.56209054928125*^9}, {3.56209066203125*^9, 
   3.562090685265625*^9}, {3.56209072575*^9, 3.56209077621875*^9}, {
   3.562090807765625*^9, 3.562090846828125*^9}, {3.56209106390625*^9, 
   3.5620910680625*^9}, 3.562091667140625*^9, {3.562091712421875*^9, 
   3.56209175575*^9}, 3.5620918684375*^9, 3.56209190009375*^9, {
   3.562092499453125*^9, 3.562092513546875*^9}, {3.562092742328125*^9, 
   3.562092750328125*^9}, {3.562093545265625*^9, 3.56209354684375*^9}}],

Cell[TextData[{
 "Op\:011bt vyraz\[IAcute]me z po\[CHacek]\[AAcute]tku, ale tentokr\[AAcute]t \
ve sm\:011bru derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "2, tedy po rovnob\:011b\:017ece s modrou \[UAcute]se\[CHacek]kou (modr\
\[AAcute] \[SHacek]ipka). \nOp\:011bt popojdeme o ",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 ", tedy dojdeme do bodu [t+",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") + ",
 StyleBox["k",
  FontSlant->"Italic"],
 "2 ",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 "] (zelen\[YAcute] bod). "
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
  3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
  3.5620870590625*^9, 3.56208711525*^9}, {3.562092774875*^9, 
  3.562092814328125*^9}, {3.562092863640625*^9, 3.56209286734375*^9}, {
  3.562095063703125*^9, 3.562095070484375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodProk3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"tStart", "+", 
      FractionBox["\[CapitalDelta]t", "2"]}], ",", 
     RowBox[{"yStart", "+", 
      RowBox[{"k2", "*", 
       FractionBox["\[CapitalDelta]t", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk2krok", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"bodStart", ",", "bodProk3"}], "}"}], "]"}]}], "}"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"znackaBodProk3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
      RowBox[{"Point", "[", "bodProk3", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.562092877453125*^9, 3.562092921625*^9}, {
  3.562093555203125*^9, 3.56209355696875*^9}}],

Cell[TextData[{
 "V zelen\[EAcute]m bod\:011b spo\[CHacek]\[IAcute]t\[AAcute]me novou \
derivaci ",
 StyleBox["k",
  FontSlant->"Italic"],
 "3. Derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "3 v zelen\[EAcute]m bod\:011b m\[AAcute] sm\:011br podle zelen\[EAcute] \
\[CHacek]\[AAcute]rkovan\[EAcute] \[UAcute]se\[CHacek]ky."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
  3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
  3.5620870590625*^9, 3.56208711525*^9}, {3.562092774875*^9, 
  3.562092814328125*^9}, {3.562092872109375*^9, 3.5620928730625*^9}, {
  3.562092962359375*^9, 3.562092983765625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"k3", "=", 
   RowBox[{"der", "[", "bodProk3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bodProk3", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart", "-", 
         FractionBox["\[CapitalDelta]t", "2"]}], ")"}], "*", "k3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"tStart", "+", "\[CapitalDelta]t"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Green", ",", "Dashed", ",", 
        RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3", ",",
    "plk3"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.56208136690625*^9, {3.562089966796875*^9, 3.562089974890625*^9}, 
   3.562090011015625*^9, {3.562090886859375*^9, 3.5620908995*^9}, {
   3.5620909508125*^9, 3.5620909646875*^9}, {3.562091294859375*^9, 
   3.56209129596875*^9}, {3.562091903859375*^9, 3.562091929953125*^9}, 
   3.562091971296875*^9, {3.56209282990625*^9, 3.5620928508125*^9}, {
   3.562092969640625*^9, 3.562092991734375*^9}, {3.56209356134375*^9, 
   3.562093562953125*^9}}],

Cell[TextData[{
 "Op\:011bt vyraz\[IAcute]me z po\[CHacek]\[AAcute]tku, ale tentokr\[AAcute]t \
ve sm\:011bru derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "3, tedy po rovnob\:011b\:017ece se zelenou \[UAcute]se\[CHacek]kou (zelen\
\[AAcute] \[SHacek]ipka). \nTentokr\[AAcute]t v\[SHacek]ak popojdeme o \
\[CapitalDelta]t, tedy dojdeme do bodu [t+",
 Cell[BoxData[
  FractionBox["\[CapitalDelta]t", "2"]],
  CellChangeTimes->{3.562081355875*^9}],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") + ",
 StyleBox["k",
  FontSlant->"Italic"],
 "3 \[CapitalDelta]t] (oran\:017eov\[YAcute] bod). "
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
  3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
  3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
  3.5620873965*^9}, {3.562093010109375*^9, 3.562093015703125*^9}, {
  3.56209313640625*^9, 3.56209313690625*^9}, {3.562093685328125*^9, 
  3.56209369425*^9}, {3.562095092703125*^9, 3.562095101578125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodProk4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"tStart", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{"yStart", "+", 
      RowBox[{"k3", "*", "\[CapitalDelta]t"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk3krok", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"bodStart", ",", "bodProk4"}], "}"}], "]"}]}], "}"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"znackaBodProk4", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
      RowBox[{"Point", "[", "bodProk4", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3", ",",
    "plk3", ",", "plk3krok", ",", "znackaBodProk4"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.562081377828125*^9, {3.56208609859375*^9, 3.562086099890625*^9}, {
   3.562087244296875*^9, 3.562087367140625*^9}, {3.562091281703125*^9, 
   3.56209128259375*^9}, {3.562091967359375*^9, 3.56209199528125*^9}, {
   3.5620930534375*^9, 3.56209312815625*^9}, {3.562093568875*^9, 
   3.56209357053125*^9}}],

Cell[TextData[{
 "V oran\:017eov\[EAcute]m bod\:011b spo\[CHacek]\[IAcute]t\[AAcute]me novou \
derivaci ",
 StyleBox["k",
  FontSlant->"Italic"],
 "4. Derivace ",
 StyleBox["k",
  FontSlant->"Italic"],
 "4",
 " v oran\:017eov\[EAcute]m bod\:011b m\[AAcute] sm\:011br podle oran\:017eov\
\[EAcute] \[CHacek]\[AAcute]rkovan\[EAcute] \[UAcute]se\[CHacek]ky."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
  3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
  3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
  3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
  3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
  3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
  3.5620873965*^9}, {3.562093010109375*^9, 3.562093015703125*^9}, {
  3.562093142296875*^9, 3.5620931749375*^9}, {3.562093221953125*^9, 
  3.56209322353125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"k4", "=", 
   RowBox[{"der", "[", "bodProk4", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plk4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bodProk4", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart", "-", "\[CapitalDelta]t"}], ")"}], "*", 
       "k4"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"tStart", "+", 
        RowBox[{"1.2", "\[CapitalDelta]t"}]}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Orange", ",", "Dashed", ",", 
        RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
   "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3", ",",
    "plk3", ",", "plk3krok", ",", "znackaBodProk4", ",", "plk4"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.562081377828125*^9, {3.56208609859375*^9, 3.562086099890625*^9}, {
   3.562087244296875*^9, 3.562087367140625*^9}, {3.562091281703125*^9, 
   3.56209128259375*^9}, {3.562091967359375*^9, 3.56209199528125*^9}, {
   3.562093058828125*^9, 3.56209305921875*^9}, {3.56209319115625*^9, 
   3.562093198671875*^9}, {3.56209357503125*^9, 3.56209357746875*^9}}],

Cell[TextData[{
 "V\[YAcute]slednou derivaci ",
 StyleBox["kVys",
  FontSlant->"Italic"],
 " spo\[CHacek]\[IAcute]t\[AAcute]me jako v\[AAcute]\:017een\[YAcute] \
pr\:016fm\:011br derivac\[IAcute] ",
 StyleBox["k",
  FontSlant->"Italic"],
 "1, ",
 StyleBox["k",
  FontSlant->"Italic"],
 "2, ",
 StyleBox["k",
  FontSlant->"Italic"],
 "3 a ",
 StyleBox["k",
  FontSlant->"Italic"],
 "4. "
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
   3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
   3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
   3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
   3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
   3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
   3.5620873965*^9}, {3.562087440609375*^9, 3.5620875256875*^9}, {
   3.562088259171875*^9, 3.56208825959375*^9}, 3.562093272*^9, {
   3.5620936279375*^9, 3.5620936283125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"kVys", "=", 
   RowBox[{
    FractionBox["1", "6"], "*", 
    RowBox[{"(", 
     RowBox[{"k1", "+", 
      RowBox[{"2", "k2"}], "+", 
      RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}], ";"}]], "Input"],

Cell[TextData[{
 "Podle t\[EAcute]to derivace vyraz\[IAcute]me z po\[CHacek]\[AAcute]tku, \
tedy ve sm\:011bru \[CHacek]ern\[EAcute] \[SHacek]ipky. Popojdeme o \
\[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 " a doraz\[IAcute]me do \[CHacek]ern\[EAcute]ho bodu."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
   3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
   3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
   3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
   3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
   3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
   3.5620873965*^9}, {3.562087440609375*^9, 3.5620875256875*^9}, {
   3.562088259171875*^9, 3.56208825959375*^9}, 3.562093272*^9, {
   3.562093631703125*^9, 3.5620936320625*^9}, {3.562093735515625*^9, 
   3.562093755375*^9}, {3.56209400234375*^9, 3.5620940198125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodVys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"tStart", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{"yStart", "+", 
      RowBox[{"kVys", "*", "\[CapitalDelta]t"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"znackaBodVys", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
      RowBox[{"Point", "[", "bodVys", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plkVyskrok", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"bodStart", ",", "bodVys"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
   "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
    "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3", 
    ",", "plk3", ",", "plk3krok", ",", "znackaBodProk4", ",", "plk4", ",", 
    "plkVyskrok", ",", "znackaBodVys"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.560407524734375*^9, 3.560407632625*^9}, {
   3.560407680203125*^9, 3.560407705875*^9}, {3.560407759671875*^9, 
   3.560407898328125*^9}, {3.56040810228125*^9, 3.560408140796875*^9}, {
   3.56040823278125*^9, 3.560408465140625*^9}, {3.560408520140625*^9, 
   3.560408597953125*^9}, {3.560408633109375*^9, 3.5604087415625*^9}, {
   3.560408779875*^9, 3.56040878034375*^9}, {3.560408826546875*^9, 
   3.560408904203125*^9}, {3.560409186609375*^9, 3.560409234*^9}, {
   3.56040930971875*^9, 3.560409344*^9}, {3.560409377328125*^9, 
   3.560409485609375*^9}, {3.5604095961875*^9, 3.56040963884375*^9}, {
   3.560409683953125*^9, 3.560409707890625*^9}, 3.56040974446875*^9, {
   3.56207271284375*^9, 3.562072721453125*^9}, {3.5620813421875*^9, 
   3.56208137290625*^9}, {3.56208608934375*^9, 3.56208609025*^9}, {
   3.562086537171875*^9, 3.562086538015625*^9}, {3.56208657703125*^9, 
   3.562086577359375*^9}, {3.562087238046875*^9, 3.562087239265625*^9}, {
   3.562087353484375*^9, 3.562087362234375*^9}, {3.56209004240625*^9, 
   3.562090045328125*^9}, {3.562090905421875*^9, 3.562090937125*^9}, {
   3.562091316453125*^9, 3.56209131990625*^9}, {3.56209140190625*^9, 
   3.56209143003125*^9}, {3.56209202425*^9, 3.562092039765625*^9}, {
   3.562093338296875*^9, 3.562093350984375*^9}, {3.562093384734375*^9, 
   3.56209338734375*^9}, {3.562093420796875*^9, 3.56209345834375*^9}, {
   3.562093581515625*^9, 3.562093583390625*^9}, {3.562093616234375*^9, 
   3.562093620890625*^9}, {3.5620938215625*^9, 3.562093824421875*^9}, {
   3.562762272859375*^9, 3.562762275375*^9}}],

Cell[TextData[{
 "P\:0159esto\:017ee jsme zvolili pom\:011brn\:011b velk\[YAcute] krok \
\[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 ", spo\[CHacek]\[IAcute]tali jsme hodnotu funkce v bod\:011b ",
 StyleBox["t",
  FontSlant->"Italic"],
 "+\[CapitalDelta]",
 StyleBox["t",
  FontSlant->"Italic"],
 " pom\:011brn\:011b p\:0159esn\:011b."
}], "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
   3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
   3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
   3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
   3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
   3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
   3.5620873965*^9}, {3.562087440609375*^9, 3.5620875256875*^9}, {
   3.562088259171875*^9, 3.56208825959375*^9}, 3.562093272*^9, {
   3.562093631703125*^9, 3.5620936320625*^9}, {3.562093735515625*^9, 
   3.562093755375*^9}, {3.562093853078125*^9, 3.562093907671875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell["\<\
Jednotliv\[EAcute] kroky si m\:016f\:017eete proj\[IAcute]t \
je\[SHacek]t\:011b jednou postupn\[YAcute]m p\:0159ep\[IAcute]n\[AAcute]n\
\[IAcute]m tla\[CHacek]\[IAcute]tek nad grafem n\[IAcute]\:017ee.\
\>", "Text",
 CellChangeTimes->{{3.562084923328125*^9, 3.562084968375*^9}, {
   3.56208500228125*^9, 3.562085202734375*^9}, {3.562085235828125*^9, 
   3.562085262046875*^9}, {3.56208581903125*^9, 3.562085820125*^9}, {
   3.562085858640625*^9, 3.562085909578125*^9}, {3.56208685575*^9, 
   3.562086917671875*^9}, {3.562086956703125*^9, 3.562087026578125*^9}, {
   3.5620870590625*^9, 3.56208722778125*^9}, {3.562087380640625*^9, 
   3.5620873965*^9}, {3.562087440609375*^9, 3.5620875256875*^9}, {
   3.562088259171875*^9, 3.56208825959375*^9}, 3.562093272*^9, {
   3.562093631703125*^9, 3.5620936320625*^9}, {3.562093735515625*^9, 
   3.562093755375*^9}, {3.562093853078125*^9, 3.562093907671875*^9}, {
   3.562763168484375*^9, 3.56276326134375*^9}, {3.56276338865625*^9, 
   3.562763389796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"grafy", "=", 
   RowBox[{"{", 
    RowBox[{
    "plNDS", ",", "znackaBodStart", ",", "plk1", ",", "plk1krok", ",", 
     "znackaBodProk2", ",", "plk2", ",", "plk2krok", ",", "znackaBodProk3", 
     ",", "plk3", ",", "plk3krok", ",", "znackaBodProk4", ",", "plk4", ",", 
     "plkVyskrok", ",", "znackaBodVys"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.562762334359375*^9, 3.562762349375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"kroky", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"grafy", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "14"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.56276235521875*^9, 3.5627624848125*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"kroky", "[", 
     RowBox[{"[", "krok", "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"krok", ",", 
     RowBox[{"Range", "[", "14", "]"}], ",", "Setter"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.562762492171875*^9, 3.5627626374375*^9}, {
  3.5627626835*^9, 3.56276268540625*^9}, {3.562762770171875*^9, 
  3.56276277084375*^9}, {3.56276297296875*^9, 3.562763036921875*^9}, {
  3.56276306790625*^9, 3.562763071703125*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 702},
WindowMargins->{{-4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 179, 3, 156, "Title"],
Cell[749, 27, 94, 2, 46, "Input"],
Cell[CellGroupData[{
Cell[868, 33, 136, 2, 103, "Subtitle"],
Cell[1007, 37, 469, 10, 96, "Text"],
Cell[1479, 49, 2583, 71, 243, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4099, 125, 198, 3, 103, "Subtitle"],
Cell[4300, 130, 2624, 118, 225, "Text"],
Cell[6927, 250, 4041, 100, 246, "Input"],
Cell[10971, 352, 1124, 22, 122, "Text"],
Cell[12098, 376, 2954, 87, 306, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15089, 468, 298, 7, 103, "Subtitle"],
Cell[15390, 477, 1717, 39, 150, "Text"],
Cell[17110, 518, 3639, 106, 361, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20786, 629, 259, 6, 103, "Subtitle"],
Cell[21048, 637, 598, 13, 95, "Text"],
Cell[21649, 652, 3321, 89, 497, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25007, 746, 313, 6, 103, "Subtitle"],
Cell[25323, 754, 493, 9, 69, "Text"],
Cell[25819, 765, 2138, 48, 196, "Input"],
Cell[27960, 815, 698, 15, 96, "Text"],
Cell[28661, 832, 2392, 70, 212, "Input"],
Cell[31056, 904, 599, 18, 69, "Text"],
Cell[31658, 924, 725, 23, 69, "Text"],
Cell[32386, 949, 1648, 41, 187, "Input"],
Cell[34037, 992, 1244, 35, 103, "Text"],
Cell[35284, 1029, 1157, 34, 160, "Input"],
Cell[36444, 1065, 957, 20, 69, "Text"],
Cell[37404, 1087, 1720, 38, 173, "Input"],
Cell[39127, 1127, 1358, 37, 103, "Text"],
Cell[40488, 1166, 1171, 34, 160, "Input"],
Cell[41662, 1202, 903, 19, 69, "Text"],
Cell[42568, 1223, 1478, 35, 201, "Input"],
Cell[44049, 1260, 1310, 31, 103, "Text"],
Cell[45362, 1293, 1392, 36, 159, "Input"],
Cell[46757, 1331, 978, 21, 69, "Text"],
Cell[47738, 1354, 1428, 35, 159, "Input"],
Cell[49169, 1391, 1029, 28, 69, "Text"],
Cell[50201, 1421, 236, 8, 73, "Input"],
Cell[50440, 1431, 1009, 18, 69, "Text"],
Cell[51452, 1451, 2773, 56, 215, "Input"],
Cell[54228, 1509, 1087, 23, 69, "Text"],
Cell[55318, 1534, 1050, 17, 69, "Text"],
Cell[56371, 1553, 435, 9, 75, "Input"],
Cell[56809, 1564, 321, 9, 46, "Input"],
Cell[57133, 1575, 535, 13, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
