(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     45979,       1282]
NotebookOptionsPosition[     44952,       1250]
NotebookOutlinePosition[     45332,       1266]
CellTagsIndexPosition[     45289,       1263]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"derivace", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", 
      RowBox[{"{", 
       RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "x1"}], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"Pi", "*", "t"}], "]"}], "40"], "+", 
      RowBox[{"0.1", "x2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "x2"}], "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"E", "*", "t"}], "]"}], "41"], "+", 
      RowBox[{"0.1", "x1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"derivace", "[", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"x2", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "==", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"x2", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"derVect", ",", "matrix"}], "}"}], "=", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{
      RowBox[{"eqns", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "\[RuleDelayed]", "0"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], "\[RuleDelayed]", "0"}]}], "}"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1", "[", "t", "]"}], ",", 
        RowBox[{"x2", "[", "t", "]"}]}], "}"}]}], "]"}], "//", "Normal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1", "[", "t", "]"}], ",", 
       RowBox[{"x2", "[", "t", "]"}]}], "}"}], ".", "matrix"}], "\[Equal]", 
    RowBox[{"-", "derVect"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigVal", "=", 
   RowBox[{"Eigenvalues", "[", "matrix", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Union", "[", 
   RowBox[{"Negative", "/@", 
    RowBox[{"(", 
     RowBox[{"Re", "/@", "eigVal"}], ")"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "%", "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"Print", "[", "\"\<sytem is stable\>\"", "]"}], ",", 
   RowBox[{"Print", "[", "\"\<sytem is'nt stable\>\"", "]"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6893162414375*^9, 3.68931625128125*^9}, {
   3.689316281890625*^9, 3.6893163511875*^9}, {3.689316645671875*^9, 
   3.689316698609375*^9}, {3.68931676365625*^9, 3.689316767703125*^9}, {
   3.68931709484375*^9, 3.68931729590625*^9}, {3.689407260802955*^9, 
   3.6894072791310797`*^9}, 3.689407329927955*^9, {3.689407435615455*^9, 
   3.6894074649435797`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Runge", " ", "Kutta", " ", "fixed", " ", "Step"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmax", "=", "5."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nSteps", "=", "60"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tFixed", "=", 
     FractionBox["tmax", "nSteps"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startPoint", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaFixedStep", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "k1", ",", "k2", ",", "k3", ",", "k4", ",", "\[CapitalDelta]t"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[CapitalDelta]t", "=", "\[CapitalDelta]tFixed"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"NestList", "[", 
      RowBox[{"RungeKuttaFixedStep", ",", "startPoint", ",", "nSteps"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1Sol", "=", 
     RowBox[{"sol", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "x1"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"x1Sol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Opacity", "[", "0.5", "]"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"sol", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2"}], "}"}]}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"solNDSolve", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqns", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"t0", ",", 
              RowBox[{"{", 
               RowBox[{"x10", ",", "x20"}], "}"}]}], "}"}], "=", 
            "startPoint"}], ";", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x1", "[", "t0", "]"}], "\[Equal]", "x10"}], ",", 
             RowBox[{
              RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "x20"}]}], "}"}]}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x1", "[", "t", "]"}], "/.", "solNDSolve"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"PlotStyle", "->", "Red"}]}], "]"}], ",", "pl1"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], "/.", "solNDSolve"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.68931622440625*^9, 3.689316234125*^9}, {
   3.68931656225*^9, 3.6893165855625*^9}, 3.689316648640625*^9, {
   3.689402601771705*^9, 3.689402809490455*^9}, {3.689405509709205*^9, 
   3.689405560396705*^9}, {3.6894066292248297`*^9, 3.689406668959205*^9}, {
   3.6894071995998297`*^9, 3.6894072124123297`*^9}, 3.6894072685373297`*^9, 
   3.689407306052955*^9, {3.6894073372873297`*^9, 3.689407410677955*^9}, {
   3.689407478709205*^9, 3.689407504865455*^9}, {3.689407567271705*^9, 
   3.689407686052955*^9}, {3.6894087479435797`*^9, 3.6894087567560797`*^9}, {
   3.6894087915373297`*^9, 3.6894087997873297`*^9}, {3.689409015865455*^9, 
   3.6894090270060797`*^9}, {3.6894095950998297`*^9, 3.6894096065060797`*^9}, 
   3.6894103571310797`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Runge", " ", "Kutta", " ", "Adaptive", " ", "Step"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaAdaptiveStep", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "k1", ",", "k2", ",", "k3", ",", "k4", ",", "\[CapitalDelta]t", ",", 
         RowBox[{"kDer", "=", "0.5"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[CapitalDelta]t", "=", 
         RowBox[{"\[CapitalDelta]tFixed", "*", 
          RowBox[{"Min", "[", 
           RowBox[{
            FractionBox["kDer", 
             RowBox[{"Max", "[", 
              RowBox[{"Abs", "/@", "k1"}], "]"}]], ",", "1"}], "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solAdaptive", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"RungeKuttaAdaptiveStep", ",", "startPoint", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "tmax"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1SolAdaptive", "=", 
     RowBox[{"solAdaptive", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "x1"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl3", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"x1SolAdaptive", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.008", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "pl3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.689408915240455*^9, 3.689408917927955*^9}, {
   3.689408983490455*^9, 3.689409072584205*^9}, {3.689409114584205*^9, 
   3.6894091736310797`*^9}, {3.689409205896705*^9, 3.689409238584205*^9}, {
   3.689409401115455*^9, 3.689409474177955*^9}, 3.689409518396705*^9, {
   3.6894095727560797`*^9, 3.689409586552955*^9}, {3.689410062834205*^9, 
   3.689410101802955*^9}, {3.6894101865685797`*^9, 3.689410192521705*^9}, {
   3.689410249084205*^9, 3.6894102995373297`*^9}, {3.6894103620060797`*^9, 
   3.6894103773185797`*^9}, {3.689415607209205*^9, 3.689415610459205*^9}, 
   3.6894208198498297`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "desired", " ", "angular", " ", 
    "frequency"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"\[Omega]desired", ",", "step"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"steepness", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tsol", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"step", "=", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"steepness", "#"}], "]"}]}], ")"}]}], "&"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Omega]1", "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "0"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Omega]2", "-", "\[Omega]1"}], ")"}], "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", 
      RowBox[{"2.5", "*", 
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart"}], ")"}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"yDesired", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Omega]desired", "[", "t", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6894176868498297`*^9, 3.6894177216935797`*^9}, 
   3.6894183103498297`*^9, 3.689435420890625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Linear", " ", "system", " ", "control"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"transferFunction", "=", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"\[Tau]", "*", "p"}], "+", "1"}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"laplaceEqn", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Denominator", "[", "transferFunction", "]"}], "*", 
        RowBox[{"y", "[", "p", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{"Numerator", "[", "transferFunction", "]"}], "*", 
        RowBox[{"u", "[", "p", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"systemEqn", "=", 
     RowBox[{"laplaceEqn", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "*", 
          RowBox[{"f_", "[", "p", "]"}]}], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"f", "[", "t", "]"}], ",", "t"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"f_", "[", "p", "]"}], "\[RuleDelayed]", 
         RowBox[{"f", "[", "t", "]"}]}], ",", 
        RowBox[{
         TagBox[
          StyleBox[
           RowBox[{"Times", "[", 
            RowBox[{
             RowBox[{"Power", "[", 
              RowBox[{"p", ",", "pow_"}], "]"}], ",", 
             RowBox[{"f_", "[", "t", "]"}]}], "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"f", "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "pow"}], "}"}]}], "]"}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"controllerEqn", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"kp", "*", 
          RowBox[{"e", "[", "t", "]"}]}], "+", 
         RowBox[{"kI", "*", 
          RowBox[{"Integrate", "[", 
           RowBox[{
            RowBox[{"e", "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}]}]}], ",", 
       "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"connectionEqn", "=", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"yDesired", "[", "t", "]"}], "-", 
       RowBox[{"y", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"sole", "=", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"connectionEqn", ",", 
         RowBox[{"D", "[", 
          RowBox[{"connectionEqn", ",", "t"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"e", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"e", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6894157571623297`*^9, 3.6894159569435797`*^9}, {
   3.689416054271705*^9, 3.6894161164748297`*^9}, {3.689416149927955*^9, 
   3.689416169115455*^9}, {3.689416226865455*^9, 3.689416277334205*^9}, 
   3.6894163211310797`*^9, 3.6894163621310797`*^9, {3.6894165096623297`*^9, 
   3.689416533959205*^9}, {3.689416570552955*^9, 3.6894166050685797`*^9}, {
   3.6894166536935797`*^9, 3.689416824146705*^9}, {3.6894169933498297`*^9, 
   3.6894170009435797`*^9}, {3.689417102490455*^9, 3.689417151834205*^9}, 
   3.689417462052955*^9, {3.689439417671875*^9, 3.689439419015625*^9}}],

Cell[BoxData[{
 RowBox[{"solDers", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"systemEqn", ",", "controllerEqn"}], "}"}], "/.", "sole"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"dery", ",", "deru"}], "}"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}], "}"}], "/.", "solDers"}], 
    ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u_", "[", "t", "]"}], "\[RuleDelayed]", "u"}], 
    "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.6894168621623297`*^9, 3.6894168968810797`*^9}, {
  3.6894171591935797`*^9, 3.689417380209205*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"solNDS", ",", "giveGraf"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"solNDS", "[", 
     RowBox[{"kpp_", ",", "kII_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "eqns", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eqns", "=", 
        RowBox[{
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"solDers", "/.", 
            RowBox[{"Rule", "\[Rule]", "Equal"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"u", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
             RowBox[{
              RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "0"}]}], "}"}]}],
           "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"kp", "\[Rule]", "kpp"}], ",", 
           RowBox[{"kI", "\[Rule]", "kII"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NDSolve", "[", 
         RowBox[{"eqns", ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "tStart", ",", 
            RowBox[{"2", "tsol"}]}], "}"}], ",", 
          RowBox[{"MaxSteps", "\[Rule]", 
           SuperscriptBox["10", "6"]}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"giveGraf", "[", 
    RowBox[{"kp_", ",", "kI_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sol", ",", "pl1", ",", "pl2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"solNDS", "[", 
        RowBox[{"kp", ",", "kI"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
          RowBox[{"yDesired", "[", "t", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<t [s]\>\"", ",", "\"\<yDesired  \!\(\*
StyleBox[\"yReal\",
FontColor->RGBColor[1, 0, 0]]\)\>\""}], "}"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"giveGraf", "[", 
  RowBox[{"6", ",", "10"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894179060373297`*^9, 3.689418095959205*^9}, {
   3.6894181264123297`*^9, 3.689418140365455*^9}, {3.689418182209205*^9, 
   3.6894183036310797`*^9}, {3.689418345802955*^9, 3.6894185395373297`*^9}, {
   3.6894185859435797`*^9, 3.6894186144748297`*^9}, {3.6894191843185797`*^9, 
   3.689419192802955*^9}, 3.6894208503810797`*^9, {3.6894396130625*^9, 
   3.689439622046875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"previous", " ", "plus", " ", "control", " ", "criteria"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"solNDS", ",", "giveGraf"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"solNDS", "[", 
      RowBox[{"kpp_", ",", "kII_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "eqns", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"eqns", "=", 
         RowBox[{
          RowBox[{"Union", "[", 
           RowBox[{
            RowBox[{"solDers", "/.", 
             RowBox[{"Rule", "\[Rule]", "Equal"}]}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"area", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"uSqr", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"area", "'"}], "[", "t", "]"}], "\[Equal]", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"y", "[", "t", "]"}], "-", 
                 RowBox[{"yDesired", "[", "t", "]"}]}], "]"}]}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"uSqr", "'"}], "[", "t", "]"}], "\[Equal]", 
               SuperscriptBox[
                RowBox[{"u", "[", "t", "]"}], "2"]}]}], "}"}]}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "\[Rule]", "kpp"}], ",", 
            RowBox[{"kI", "\[Rule]", "kII"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NDSolve", "[", 
          RowBox[{"eqns", ",", 
           RowBox[{"{", 
            RowBox[{"u", ",", "y", ",", "area", ",", "uSqr"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "tStart", ",", 
             RowBox[{"2", "tsol"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", 
            SuperscriptBox["10", "6"]}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"giveGraf", "[", 
      RowBox[{"kp_", ",", "kI_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sol", ",", "pl1", ",", "pl2", ",", "controlArea", ",", "intUsqare"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{"solNDS", "[", 
          RowBox[{"kp", ",", "kI"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"controlArea", ",", "intUsqare"}], "}"}], "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"area", "[", 
             RowBox[{"2", "tsol"}], "]"}], ",", 
            RowBox[{"uSqr", "[", 
             RowBox[{"2", "tsol"}], "]"}]}], "}"}], "/.", "sol"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
            RowBox[{"yDesired", "[", "t", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "tStart", ",", 
            RowBox[{"2", "tsol"}]}], "}"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<t [s]\>\"", ",", "\"\<yDesired  \!\(\*
StyleBox[\"yReal\",
FontColor->RGBColor[1, 0, 0]]\)\>\""}], "}"}]}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Column", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<controlArea= \>\"", "<>", 
               RowBox[{"ToString", "[", "controlArea", "]"}]}], ",", 
              RowBox[{
              "\"\<\!\(\*SubsuperscriptBox[\(\[Integral]\), \(t1\), \
\(t2\)]\)u(t\!\(\*SuperscriptBox[\()\), \(2\)]\)\[DifferentialD]t= \>\"", "<>", 
               RowBox[{"ToString", "[", "intUsqare", "]"}]}]}], "}"}], 
            "]"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.689418628896705*^9, 3.689418631802955*^9}, {
   3.6894189071935797`*^9, 3.689419132427955*^9}, {3.6894191647560797`*^9, 
   3.689419464052955*^9}, 3.68943950025*^9, {3.6894396755*^9, 
   3.68943968146875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"weightOfArea", "=", "60"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"weightOfUSquareIntegral", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"forMinimum", "[", 
     RowBox[{
      RowBox[{"kp_", "?", "NumericQ"}], ",", 
      RowBox[{"kI_", "?", "NumericQ"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"weightOfArea", "*", 
        RowBox[{"area", "[", 
         RowBox[{"2", "tsol"}], "]"}]}], "+", 
       RowBox[{"weightOfUSquareIntegral", "*", 
        RowBox[{"uSqr", "[", 
         RowBox[{"2", "tsol"}], "]"}]}]}], ")"}], "/.", 
     RowBox[{"solNDS", "[", 
      RowBox[{"kp", ",", "kI"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"solMin", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"forMinimum", "[", 
      RowBox[{"kp", ",", "kI"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"kp", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"kI", ",", "1"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"giveGraf", "[", 
  RowBox[{
   RowBox[{"kp", "/.", "solMin"}], ",", 
   RowBox[{"kI", "/.", "solMin"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.689419630927955*^9, 3.689419904302955*^9}, 
   3.68943946671875*^9, {3.68943950796875*^9, 3.68943959015625*^9}, 
   3.6894396576875*^9, {3.689439751453125*^9, 3.6894397916875*^9}, 
   3.689473882328125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dery", ",", "deru"}], "}"}]], "Input"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "derivative", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"derivative", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tt_", ",", "state_"}], "}"}], ",", "params_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dery", ",", "deru", ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"y", "-", 
       RowBox[{"yDesired", "[", "t", "]"}]}], "]"}], ",", 
     SuperscriptBox["u", "2"]}], "}"}], "/.", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", "u", ",", "area", ",", "uSqr"}], "}"}], "\[Rule]", 
       "state"}], "]"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kp", ",", "kI"}], "}"}], "\[Rule]", "params"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", "\[Rule]", "tt"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"derivative", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tsol", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.689420126677955*^9, 3.6894201381310797`*^9}, {
  3.689420203740455*^9, 3.6894204096935797`*^9}, {3.6894204448498297`*^9, 
  3.689420468802955*^9}, {3.6894205541935797`*^9, 3.689420571896705*^9}, {
  3.689420603677955*^9, 3.6894207452248297`*^9}, {3.68943545296875*^9, 
  3.689435576609375*^9}, {3.689435610765625*^9, 3.689435651515625*^9}, {
  3.68943572640625*^9, 3.68943580015625*^9}, {3.689435831984375*^9, 
  3.689435843609375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "solRungeKutta", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solRungeKutta", "[", 
    RowBox[{"params", ":", 
     RowBox[{"{", 
      RowBox[{"kpp_", ",", "kII_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"derivace", ",", 
       RowBox[{"\[CapitalDelta]t", "=", 
        RowBox[{"0.05", "\[Tau]"}]}], ",", "RungeKuttaFixedStep", ",", "sol", 
       ",", "plot", ",", "y", ",", "u", ",", "area", ",", "uSqr", ",", 
       "endState"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"time_", ",", "state_"}], "}"}], "]"}], ":=", 
       RowBox[{"derivative", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"time", ",", "state"}], "}"}], ",", "params"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RungeKuttaFixedStep", "[", 
        RowBox[{"{", 
         RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
       RowBox[{"Module", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"k1", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"k2", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", 
               FractionBox["\[CapitalDelta]t", "2"]}], ",", 
              RowBox[{"y", "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"k3", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", 
               FractionBox["\[CapitalDelta]t", "2"]}], ",", 
              RowBox[{"y", "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"k4", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
              RowBox[{"y", "+", 
               RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "6"], "*", 
              RowBox[{"(", 
               RowBox[{"k1", "+", 
                RowBox[{"2", "k2"}], "+", 
                RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"NestWhileList", "[", 
        RowBox[{"RungeKuttaFixedStep", ",", 
         RowBox[{"{", 
          RowBox[{"tStart", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
           RowBox[{"2", "tsol"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"endState", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"y", ",", "u", ",", "area", ",", "uSqr"}], "}"}], "=", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"sol", ",", "endState"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{
    RowBox[{"solRungeKutta", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kp", "/.", "solMin"}], ",", 
       RowBox[{"kI", "/.", "solMin"}]}], "}"}], "]"}], "//", "Timing"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<trvalo to \>\"", ",", 
    RowBox[{"pom", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ypsilon", "=", 
   RowBox[{
    RowBox[{"pom", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", 
       RowBox[{"{", 
        RowBox[{"y_", ",", "u_", ",", "area_", ",", "uSqr_"}], "}"}]}], "}"}],
      "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "y"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "ypsilon", "]"}]}], "Input",
 CellChangeTimes->{{3.689420126677955*^9, 3.6894201381310797`*^9}, {
   3.689420203740455*^9, 3.6894204096935797`*^9}, {3.6894204448498297`*^9, 
   3.689420468802955*^9}, {3.6894205541935797`*^9, 3.689420571896705*^9}, {
   3.689420603677955*^9, 3.6894207452248297`*^9}, {3.68943545296875*^9, 
   3.689435576609375*^9}, {3.689435610765625*^9, 3.689435651515625*^9}, {
   3.68943572640625*^9, 3.68943580015625*^9}, {3.689435831984375*^9, 
   3.689435843609375*^9}, {3.689435879359375*^9, 3.6894358948125*^9}, {
   3.689435967609375*^9, 3.68943599940625*^9}, {3.689436029765625*^9, 
   3.68943639159375*^9}, {3.68943647171875*^9, 3.689436753375*^9}, 
   3.689437044203125*^9, {3.689439145375*^9, 3.68943921825*^9}, {
   3.689439267453125*^9, 3.68943932828125*^9}, 3.68943971696875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"weightOfArea", "=", "10"}], ";", "\[IndentingNewLine]", 
    RowBox[{"weightOfUSquareIntegral", "=", "1"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "forMinimumRunge", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"forMinimumRunge", "[", 
      RowBox[{"params", ":", 
       RowBox[{"{", 
        RowBox[{"kpp_", ",", "kII_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"solRungeKutta", "[", "params", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "0", ",", "weightOfArea", ",", "weightOfUSquareIntegral"}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"forMinimumRunge", "[", 
       RowBox[{"{", 
        RowBox[{"kp", ",", "kI"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"kp", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kI", ",", "1"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"forMinimumRunge", "[", 
     RowBox[{"{", 
      RowBox[{"11", ",", "2.22"}], "}"}], "]"}], "//", "Timing"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.689436838421875*^9, 3.689436877703125*^9}, {
   3.689436912640625*^9, 3.689437010703125*^9}, {3.6894387485*^9, 
   3.689438780296875*^9}, {3.68943912746875*^9, 3.68943912959375*^9}, 
   3.68943944375*^9, {3.689473819375*^9, 3.68947381953125*^9}, {
   3.689473851265625*^9, 3.689473855328125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "grad", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", 
    RowBox[{"{", 
     RowBox[{"kp_", ",", "kI_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalDelta]kp", "=", "0.01"}], ",", 
       RowBox[{"\[CapitalDelta]kI", "=", "0.01"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "+", "\[CapitalDelta]kp"}], ",", "kI"}], "}"}], 
          "]"}], "-", 
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "-", "\[CapitalDelta]kp"}], ",", "kI"}], "}"}], 
          "]"}]}], 
        RowBox[{"2", "\[CapitalDelta]kp"}]], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{"kp", ",", 
            RowBox[{"kI", "+", "\[CapitalDelta]kI"}]}], "}"}], "]"}], "-", 
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{"kp", ",", 
            RowBox[{"kI", "-", "\[CapitalDelta]kI"}]}], "}"}], "]"}]}], 
        RowBox[{"2", "\[CapitalDelta]kI"}]]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grad", "[", 
   RowBox[{"tryPoint", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kp", ",", "kI"}], "}"}], "/.", "solMin"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.689473924578125*^9, 3.689474135125*^9}, {
  3.6894741810625*^9, 3.689474257078125*^9}, {3.689474540453125*^9, 
  3.6894745443125*^9}, {3.68947457775*^9, 3.68947458840625*^9}, {
  3.68947468078125*^9, 3.6894746834375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"stepGrad", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"point", ":", 
       RowBox[{"{", 
        RowBox[{"kp_", ",", "kI_"}], "}"}]}], ",", "absgr_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normgrad", ",", "gr", ",", "absgrad", ",", 
       RowBox[{"\[CapitalDelta]", "=", "0.05"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gr", "=", 
       RowBox[{"grad", "[", 
        RowBox[{"{", 
         RowBox[{"kp", ",", "kI"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"normgrad", "=", 
       FractionBox["gr", 
        RowBox[{"absgrad", "=", 
         SqrtBox[
          RowBox[{"gr", ".", "gr"}]]}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"point", "-", 
         RowBox[{"\[CapitalDelta]", "*", "normgrad", "*", 
          RowBox[{"Tanh", "[", "absgrad", "]"}]}]}], ",", "absgrad"}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"stepGrad", "[", 
  RowBox[{"{", 
   RowBox[{"tryPoint", ",", "10"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.68947427340625*^9, 3.6894742968125*^9}, 
   3.689474369390625*^9, {3.6894744223125*^9, 3.689474535125*^9}, 
   3.689474726640625*^9, {3.6894747669375*^9, 3.68947496025*^9}, 
   3.689475024859375*^9, 3.689475092359375*^9, 3.689475294671875*^9}],

Cell[BoxData[
 RowBox[{"aux", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"stepGrad", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6.12", ",", "1.287"}], "}"}], ",", "15.79"}], "}"}], ",", 
    "20"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.68947497678125*^9, 3.68947500275*^9}, {
   3.68947505971875*^9, 3.6894750671875*^9}, {3.68947510696875*^9, 
   3.689475118046875*^9}, 3.6894752120625*^9, 3.689475276796875*^9, {
   3.689475343421875*^9, 3.68947537278125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"kpg", ",", "kpI"}], "}"}], "=", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"aux", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "<", 
       RowBox[{"#2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.689475411703125*^9, 3.68947547071875*^9}}],

Cell[BoxData[
 RowBox[{"giveGraf", "[", 
  RowBox[{"kpg", ",", "kpI"}], "]"}]], "Input",
 CellChangeTimes->{{3.689475495578125*^9, 3.689475500265625*^9}}]
},
WindowSize->{1146, 630},
WindowMargins->{{4, Automatic}, {Automatic, 3}},
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 330, 9, 92, "Input"],
Cell[890, 31, 3125, 96, 197, "Input"],
Cell[4018, 129, 6268, 167, 762, "Input"],
Cell[10289, 298, 4246, 108, 512, "Input"],
Cell[14538, 408, 2212, 65, 317, "Input"],
Cell[16753, 475, 3717, 101, 275, "Input"],
Cell[20473, 578, 1062, 35, 67, "Input"],
Cell[21538, 615, 3272, 86, 354, "Input"],
Cell[24813, 703, 4927, 124, 536, "Input"],
Cell[29743, 829, 1581, 43, 192, "Input"],
Cell[31327, 874, 78, 2, 41, "Input"],
Cell[31408, 878, 1647, 42, 172, "Input"],
Cell[33058, 922, 5731, 147, 655, "Input"],
Cell[38792, 1071, 1715, 46, 217, "Input"],
Cell[40510, 1119, 1846, 52, 217, "Input"],
Cell[42359, 1173, 1453, 39, 228, "Input"],
Cell[43815, 1214, 498, 12, 41, "Input"],
Cell[44316, 1228, 475, 15, 41, "Input"],
Cell[44794, 1245, 154, 3, 41, "Input"]
}
]
*)

(* End of internal cache information *)
