(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    149924,       2942]
NotebookOptionsPosition[    148637,       2896]
NotebookOutlinePosition[    149185,       2917]
CellTagsIndexPosition[    149142,       2914]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "znatelny", " ", "vliv", " ", "vnitrniho", " ", "odporu", " ", "zdroje"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.714292269294443*^9, 3.7142922817788177`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Uz0", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ri", "=", "0.15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]F", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cz", "=", 
   RowBox[{"2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1.8", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2.", "*", 
    FractionBox["Pi", "T"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ns", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"i", "[", "t_", "]"}], ":=", 
   RowBox[{"1.5", "*", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"ns", "*", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"\[Omega]", "*", "t"}], "+", 
           RowBox[{"0.48", "*", 
            FractionBox["E", "Pi"]}]}], "]"}], "132"]}], "]"}], 
      RowBox[{"Cosh", "[", 
       RowBox[{"1.00", "*", "ns"}], "]"}]], ")"}], "*", 
    RowBox[{"Tanh", "[", 
     FractionBox["t", 
      RowBox[{"0.1", "T"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"i", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"0.5", "T"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.71419371778125*^9, 3.714193959359375*^9}, {
   3.714194227921875*^9, 3.71419424175*^9}, {3.714195117390625*^9, 
   3.714195119125*^9}, {3.7141953094375*^9, 3.71419530975*^9}, 
   3.71419556215625*^9, {3.714195902703125*^9, 3.7141959211875*^9}, {
   3.714202467109375*^9, 3.714202500234375*^9}, {3.7142028041875*^9, 
   3.714202804515625*^9}, {3.714204518578125*^9, 3.714204518734375*^9}, {
   3.714208001390625*^9, 3.7142080286875*^9}, 3.71420809446875*^9, {
   3.71421047840625*^9, 3.714210493296875*^9}, 3.714210540234375*^9, {
   3.7142917179975677`*^9, 3.714291718263193*^9}, 3.714292075825693*^9, {
   3.714292112731943*^9, 3.714292200825693*^9}, 3.714292258106943*^9, {
   3.71437291753125*^9, 3.7143729894375*^9}, 3.7143732435625*^9, {
   3.714373284265625*^9, 3.7143733266875*^9}, {3.714373367296875*^9, 
   3.714373367765625*^9}, 3.71437343965625*^9, {3.714373469890625*^9, 
   3.714373531859375*^9}, {3.71437356265625*^9, 3.714373563015625*^9}, 
   3.71437360778125*^9, 3.714373665828125*^9, {3.714373711890625*^9, 
   3.71437375653125*^9}, 3.714373800515625*^9, {3.714374033390625*^9, 
   3.714374033609375*^9}, {3.714374223234375*^9, 3.714374237359375*^9}, 
   3.7143793808125*^9, 3.714379507078125*^9, {3.71437961603125*^9, 
   3.714379616859375*^9}, 3.714379700625*^9, {3.714721128234375*^9, 
   3.714721151421875*^9}, 3.71472321021875*^9, 3.71472324396875*^9, {
   3.714724874109375*^9, 3.714724892265625*^9}, 3.714725077*^9, 
   3.714725226578125*^9, {3.714725329171875*^9, 3.714725451234375*^9}, 
   3.714725575171875*^9, {3.71472596515625*^9, 3.714725965375*^9}, {
   3.714726121453125*^9, 3.7147261215625*^9}, {3.714727565421875*^9, 
   3.714727565828125*^9}, {3.714727694921875*^9, 3.7147276955*^9}, {
   3.714727778765625*^9, 3.71472777896875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8Vf8fx42sErJXVu4UKZnXOW9Rkk1CJVL4UpRVIXtkhLKjRYTsUZkh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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"i [A]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7147275668125*^9, 3.714727569203125*^9}, 
   3.714727607765625*^9, 3.7147276990625*^9, {3.714727780359375*^9, 
   3.714727792546875*^9}, 3.714727895296875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", "3000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"10.2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"u", ",", "e", ",", "uz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Uz0", "-", 
        RowBox[{"uz", "[", "t", "]"}]}], "Ri"], "\[Equal]", 
      RowBox[{
       RowBox[{"cz", "*", 
        RowBox[{
         RowBox[{"uz", "'"}], "[", "t", "]"}]}], "+", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"uz", "[", "0", "]"}], "==", "Uz0"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"k", "*", 
         RowBox[{"i", "[", "t", "]"}]}], "-", 
        RowBox[{"u", "[", "t", "]"}]}], "R1"], "\[Equal]", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"u", "'"}], "[", "t", "]"}]}], "+", 
       FractionBox[
        RowBox[{"u", "[", "t", "]"}], "R2"]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "*", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "e", ",", 
        RowBox[{"u", "'"}], ",", "uz"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]], "T"}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"e", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"uz", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<u [V]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<E [J]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<uz [V]\>\""}], "}"}]}]}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"i", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}]}], "}"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etrue", "=", 
   RowBox[{
    RowBox[{"e", "[", "tmax", "]"}], "-", 
    RowBox[{"e", "[", "0", "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.714193973140625*^9, 3.714194434171875*^9}, {
   3.714194477015625*^9, 3.714194488546875*^9}, {3.714194560890625*^9, 
   3.714194862015625*^9}, {3.714194893765625*^9, 3.71419489890625*^9}, {
   3.71419494371875*^9, 3.71419509759375*^9}, {3.714195129390625*^9, 
   3.714195178625*^9}, 3.714195211671875*^9, 3.7141952571875*^9, 
   3.714195517265625*^9, {3.71419669915625*^9, 3.714196700015625*^9}, 
   3.71419709803125*^9, 3.714202535109375*^9, {3.71420262665625*^9, 
   3.714202643171875*^9}, {3.714204559234375*^9, 3.714204559484375*^9}, {
   3.71420509434375*^9, 3.7142050945*^9}, 3.714206417359375*^9, 
   3.714207988*^9, {3.714210401453125*^9, 3.714210455359375*^9}, {
   3.7142105194375*^9, 3.714210519890625*^9}, {3.71421060253125*^9, 
   3.714210613484375*^9}, {3.71421066359375*^9, 3.7142106650625*^9}, {
   3.714210711078125*^9, 3.7142107330625*^9}, {3.71421252984375*^9, 
   3.71421254378125*^9}, {3.7142913657475677`*^9, 3.7142913676225677`*^9}, 
   3.7142915904975677`*^9, {3.714291633919443*^9, 3.714291634075693*^9}, {
   3.714291702513193*^9, 3.714291702825693*^9}, 3.714291736481943*^9, {
   3.714291768325693*^9, 3.714291768544443*^9}, {3.7142920923100677`*^9, 
   3.714292092450693*^9}, {3.714292242856943*^9, 3.714292243075693*^9}, {
   3.7142923021850677`*^9, 3.714292302325693*^9}, {3.714372936625*^9, 
   3.71437293859375*^9}, {3.714372974859375*^9, 3.714373115453125*^9}, {
   3.71437315396875*^9, 3.714373164765625*^9}, 3.714373258078125*^9, {
   3.714373337171875*^9, 3.714373383234375*^9}, {3.71437341990625*^9, 
   3.71437342203125*^9}, 3.714373454921875*^9, 3.714373540984375*^9, 
   3.714373578390625*^9, 3.7143736266875*^9, {3.714373678109375*^9, 
   3.7143736879375*^9}, {3.714373776734375*^9, 3.714373782703125*^9}, {
   3.71437390203125*^9, 3.71437391184375*^9}, {3.71437405009375*^9, 
   3.714374103359375*^9}, {3.71437425453125*^9, 3.714374255265625*^9}, {
   3.714374316796875*^9, 3.714374318765625*^9}, {3.714379623109375*^9, 
   3.7143796499375*^9}, {3.714379685078125*^9, 3.714379691765625*^9}, 
   3.7147233005625*^9, 3.7147239073125*^9, 3.71472408765625*^9, 
   3.714724964515625*^9, 3.714725020125*^9, {3.71472622471875*^9, 
   3.714726272421875*^9}, 3.714726402328125*^9, 3.714726446875*^9, {
   3.71472649671875*^9, 3.714726496921875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VG8bB/AoKaVoT5uyT2ayZp35EnOsI82IOEZCyJZsoZIiIoSihUra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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"u [V]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1mk4lF0YB3CUEi0MSossw2wNMSGGmTvhsYbmKcpjS5KIJFuKEiEVWZJI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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"E [J]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN23lcjN/7P/C0koQQES2TZkYqFCVxpu1WScmkbVoI7YlCtKiUdiUt2iWi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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"uz [V]\"", TraditionalForm]},
    AxesOrigin->{0, 9.78},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU13c8Ve8fAHBkJdmUFIo77RnuPecj3GtUSFZmRoUUKUl8jYyIsgqhQpSU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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"i [A]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.71472757078125*^9, 3.714727609328125*^9, 3.71472770021875*^9, {
   3.7147277849375*^9, 3.714727794171875*^9}, 3.714727896875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      FractionBox["1", "k"], "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["R1", "R2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     FractionBox[
      RowBox[{"R1", "*", "c"}], "k"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", "123.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{"N", "@", 
      FractionBox["T", "sr"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}], ",", "3", 
       ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i1", "[", 
      RowBox[{"{", 
       RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}], "]"}], ":=", 
     RowBox[{
      FractionBox["\[CapitalDelta]t", "3."], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f1", "[", "t1", "]"}], "+", 
        RowBox[{"4", 
         RowBox[{"f1", "[", "t2", "]"}]}], "+", 
        RowBox[{"f1", "[", "t3", "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i2", "[", 
      RowBox[{"{", 
       RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"f1", "[", "t3", "]"}], "-", 
      RowBox[{"f1", "[", "t1", "]"}], "-", 
      RowBox[{
       RowBox[{"u", "[", "t2", "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"uz", "[", "t3", "]"}], "-", 
         RowBox[{"uz", "[", "t1", "]"}]}], ")"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i2b", "[", 
      RowBox[{"{", 
       RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"uz", "[", "t2", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "[", "t3", "]"}], "-", 
        RowBox[{"u", "[", "t1", "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ecast", "[", 
      RowBox[{"p", ":", 
       RowBox[{"{", 
        RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"i1", "[", "p", "]"}]}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"i2", "[", "p", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ecastb", "[", 
      RowBox[{"p", ":", 
       RowBox[{"{", 
        RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"i1", "[", "p", "]"}]}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"i2b", "[", "p", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ecelk", "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"Ecast", "/@", "data"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ecelkb", "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"Ecastb", "/@", "data"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Enint", "=", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"uz", "[", "t", "]"}], "*", 
         RowBox[{"i", "[", "t", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<chyba=\>\"", ",", 
     RowBox[{"100", 
      RowBox[{"Abs", "[", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["Etrue", "Ecelk"], ")"}], 
         RowBox[{"-", "1"}]]}], "]"}]}], ",", "\"\< %\>\"", ",", 
     "\"\<   chyba(b)=\>\"", ",", 
     RowBox[{"100", 
      RowBox[{"Abs", "[", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["Etrue", "Ecelkb"], ")"}], 
         RowBox[{"-", "1"}]]}], "]"}]}], ",", "\"\< %\>\""}], "]"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"dataRaw", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"uz", "[", "#", "]"}], "*", 
          RowBox[{"i", "[", "#", "]"}]}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}]}], ",", 
       "3", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i3", "[", 
      RowBox[{"{", 
       RowBox[{"p1_", ",", "p2_", ",", "p3_"}], "}"}], "]"}], ":=", 
     RowBox[{
      FractionBox["\[CapitalDelta]t", "3."], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "p1"}], "+", 
        RowBox[{"4", "p2"}], "+", 
        RowBox[{"1", "p3"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Eraw", "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"i3", "/@", "dataRaw"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<chybaRaw=\>\"", ",", 
     RowBox[{"100", 
      RowBox[{"Abs", "[", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["Etrue", "Eraw"], ")"}], 
         RowBox[{"-", "1"}]]}], "]"}]}], ",", "\"\< %\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.714193973140625*^9, 3.714194434171875*^9}, {
   3.714194477015625*^9, 3.714194488546875*^9}, {3.714194560890625*^9, 
   3.714194862015625*^9}, {3.714194893765625*^9, 3.71419489890625*^9}, {
   3.71419494371875*^9, 3.71419509759375*^9}, {3.714195129390625*^9, 
   3.714195178625*^9}, 3.714195211671875*^9, 3.7141952571875*^9, 
   3.714195517265625*^9, {3.71419669915625*^9, 3.714196700015625*^9}, 
   3.71419709803125*^9, 3.714202535109375*^9, {3.71420262665625*^9, 
   3.714202643171875*^9}, {3.714204559234375*^9, 3.714204559484375*^9}, {
   3.71420509434375*^9, 3.7142050945*^9}, 3.714206417359375*^9, 
   3.714207988*^9, {3.714210401453125*^9, 3.714210455359375*^9}, {
   3.7142105194375*^9, 3.714210519890625*^9}, {3.71421060253125*^9, 
   3.714210613484375*^9}, {3.71421066359375*^9, 3.7142106650625*^9}, {
   3.714210711078125*^9, 3.7142107330625*^9}, {3.71421252984375*^9, 
   3.71421254378125*^9}, {3.7142913657475677`*^9, 3.7142913676225677`*^9}, 
   3.7142915904975677`*^9, {3.714291633919443*^9, 3.714291634075693*^9}, {
   3.714291702513193*^9, 3.714291702825693*^9}, 3.714291736481943*^9, {
   3.714291768325693*^9, 3.714291768544443*^9}, {3.7142920923100677`*^9, 
   3.714292092450693*^9}, {3.714292242856943*^9, 3.714292243075693*^9}, {
   3.7142923021850677`*^9, 3.714292302325693*^9}, {3.714372936625*^9, 
   3.71437293859375*^9}, {3.714372974859375*^9, 3.7143729808125*^9}, {
   3.7143743256875*^9, 3.714374326859375*^9}, {3.7143794205*^9, 
   3.714379488640625*^9}, {3.71472095834375*^9, 3.714720963296875*^9}, {
   3.71472100109375*^9, 3.714721099109375*^9}, {3.714721412546875*^9, 
   3.714721412890625*^9}, {3.71472317921875*^9, 3.714723179453125*^9}, 
   3.714723365734375*^9, 3.71472343325*^9, 3.714723471265625*^9, 
   3.71472383990625*^9, 3.714723876265625*^9, {3.714723942765625*^9, 
   3.714723943109375*^9}, {3.714724001796875*^9, 3.714724001953125*^9}, {
   3.714724759890625*^9, 3.714724760875*^9}, 3.71472514896875*^9, 
   3.714725518484375*^9, 3.714726072*^9, 3.71472760290625*^9, 
   3.7147278890625*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"chyba=\"\>", "\[InvisibleSpace]", "0.5865986726855787`", 
   "\[InvisibleSpace]", "\<\" %\"\>", 
   "\[InvisibleSpace]", "\<\"   chyba(b)=\"\>", "\[InvisibleSpace]", 
   "1.1954497424240262`", "\[InvisibleSpace]", "\<\" %\"\>"}],
  SequenceForm[
  "chyba=", 0.5865986726855787, " %", "   chyba(b)=", 1.1954497424240262`, 
   " %"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.714727570875*^9, {3.714727603515625*^9, 3.714727609453125*^9}, 
   3.714727700375*^9, {3.714727789453125*^9, 3.71472779428125*^9}, {
   3.714727889328125*^9, 3.714727897*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"chybaRaw=\"\>", "\[InvisibleSpace]", "17.4380997037926`", 
   "\[InvisibleSpace]", "\<\" %\"\>"}],
  SequenceForm["chybaRaw=", 17.4380997037926, " %"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.714727570875*^9, {3.714727603515625*^9, 3.714727609453125*^9}, 
   3.714727700375*^9, {3.714727789453125*^9, 3.71472779428125*^9}, {
   3.714727889328125*^9, 3.71472789703125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "vydejKoeficienty", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejKoeficienty", "[", "n_Integer", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "vyr", ",", "x", ",", "eqns", ",", "decka", ",", "dosd", ",", 
         "integrand", ",", "integral", ",", "koefky", ",", "d", ",", "x1", 
         ",", "f", ",", "\[CapitalDelta]x", ",", "t"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vyr", "=", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["d", "i"], "*", 
             SuperscriptBox["#", 
              RowBox[{"i", "-", "1"}]]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "&"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"x", "[", "i_", "]"}], ":=", 
         RowBox[{"x1", "+", 
          RowBox[{"\[CapitalDelta]x", "*", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"eqns", "=", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "#", "]"}], "\[Equal]", 
            RowBox[{"vyr", "[", 
             RowBox[{"x", "[", "#", "]"}], "]"}]}], "&"}], "/@", 
          RowBox[{"Range", "[", "n", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"decka", "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["d", "#"], "&"}], "/@", 
          RowBox[{"Range", "[", "n", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dosd", "=", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{"eqns", ",", "decka"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"integrand", "=", 
         RowBox[{
          RowBox[{"vyr", "[", "t", "]"}], "/.", "dosd"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"integral", "=", 
         RowBox[{"Integrate", "[", 
          RowBox[{"integrand", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "x1", ",", 
             RowBox[{"x", "[", "n", "]"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"koefky", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"Simplify", "[", 
              FractionBox["integral", "\[CapitalDelta]x"], "]"}], ",", 
             RowBox[{"f", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "n", "]"}]}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"koeficienty", "=", 
      RowBox[{"vydejKoeficienty", "/@", 
       RowBox[{"Range", "[", "7", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"koeficienty", ">>", "\"\<koeficienty\>\""}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koeficienty", "=", 
     RowBox[{"N", "[", 
      RowBox[{"<<", "\"\<koeficienty\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<nmax= \>\"", ",", 
     RowBox[{"Length", "[", "koeficienty", "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.71471274675*^9, 3.714712822671875*^9}, {
   3.7147129624375*^9, 3.7147132725625*^9}, {3.714713310203125*^9, 
   3.71471334959375*^9}, {3.714713379890625*^9, 3.714713408625*^9}, {
   3.7147134394375*^9, 3.714713486296875*^9}, {3.714713545734375*^9, 
   3.714713586796875*^9}, {3.714713622625*^9, 3.71471371046875*^9}, {
   3.714713793140625*^9, 3.714713948390625*^9}, {3.714713988453125*^9, 
   3.714714034921875*^9}, {3.71471406609375*^9, 3.714714108578125*^9}, {
   3.71471413971875*^9, 3.714714140078125*^9}, 3.714718631734375*^9, 
   3.71471883009375*^9, 3.714719314109375*^9, 3.714719398453125*^9, {
   3.714721184625*^9, 3.71472120525*^9}, {3.714721302671875*^9, 
   3.71472135078125*^9}, 3.71472315190625*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"nmax= \"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["nmax= ", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.714727570921875*^9, 3.7147276095*^9, 3.7147277004375*^9, 
  3.71472779434375*^9, 3.7147278970625*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "casy", ",", "vahy", ",", "g", ",", "i1", ",", "i2", ",", "ftKsi", ",", 
       "h", ",", "Ecelk", ",", "i2b", ",", "hb", ",", "Ecelkb", ",", "p", ",",
        "Eraw"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"casy", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}], ",", 
         "n", ",", 
         RowBox[{"n", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vahy", "=", 
       RowBox[{"koeficienty", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"uz", "[", "#", "]"}], "*", 
         RowBox[{"i", "[", "#", "]"}]}], "&"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eraw", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"h", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f1", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"g", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", 
         RowBox[{"list_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"EvenQ", "[", 
             RowBox[{"Length", "[", "#", "]"}], "]"}], "&"}], ")"}]}]}], 
        "]"}], ":=", 
       RowBox[{"0.5", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"list", "[", 
            RowBox[{"[", 
             FractionBox[
              RowBox[{"Length", "[", "list", "]"}], "2"], "]"}], "]"}], "]"}],
           "+", 
          RowBox[{"f", "[", 
           RowBox[{"list", "[", 
            RowBox[{"[", 
             RowBox[{
              FractionBox[
               RowBox[{"Length", "[", "list", "]"}], "2"], "+", "1"}], "]"}], 
            "]"}], "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", 
         RowBox[{"list_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"OddQ", "[", 
             RowBox[{"Length", "[", "#", "]"}], "]"}], "&"}], ")"}]}]}], 
        "]"}], ":=", 
       RowBox[{"f", "[", 
        RowBox[{"list", "[", 
         RowBox[{"[", 
          FractionBox[
           RowBox[{
            RowBox[{"Length", "[", "list", "]"}], "+", "1"}], "2"], "]"}], 
         "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
        RowBox[{"f1", "[", 
         RowBox[{"First", "[", "list", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"ftKsi", "[", 
          RowBox[{"u", ",", "list"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"uz", "[", 
            RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
           RowBox[{"uz", "[", 
            RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"h", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelk", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"hb", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"ftKsi", "[", 
         RowBox[{"uz", ",", "list"}], "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
          RowBox[{"u", "[", 
           RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2b", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"hb", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelkb", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2b"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Eraw"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelk"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelkb"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"vydej", "[", "3", "]"}], "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"vydej", "[", "#", "]"}]}], "}"}]}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"2", ",", "7", ",", "1"}], "]"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.714721233890625*^9, 3.71472126696875*^9}, {
   3.71472136746875*^9, 3.714721435203125*^9}, {3.714721487265625*^9, 
   3.714721516296875*^9}, {3.7147215596875*^9, 3.714721665796875*^9}, {
   3.714721703125*^9, 3.714721732171875*^9}, {3.7147221045625*^9, 
   3.714722144671875*^9}, {3.7147224009375*^9, 3.714722410703125*^9}, {
   3.714722457125*^9, 3.714722497625*^9}, {3.714722533859375*^9, 
   3.71472272728125*^9}, {3.7147227644375*^9, 3.714722812875*^9}, {
   3.714722865078125*^9, 3.714723053125*^9}, {3.71472359590625*^9, 
   3.71472371175*^9}, {3.71472451265625*^9, 3.714724527515625*^9}, 
   3.7147250401875*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.714723103140625*^9, 3.714723121296875*^9}, 
   3.714724524984375*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejb", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejb", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "casy", ",", "vahy", ",", "g", ",", "i1", ",", "i2", ",", "ftKsi", ",", 
       "h", ",", "Ecelk", ",", "i2b", ",", "hb", ",", "Ecelkb", ",", "p", ",",
        "Eraw"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"casy", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}], ",", 
         "n", ",", 
         RowBox[{"n", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vahy", "=", 
       RowBox[{"koeficienty", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"uz", "[", "#", "]"}], "*", 
         RowBox[{"i", "[", "#", "]"}]}], "&"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eraw", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"h", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f1", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"g", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", "list_"}], "]"}], ":=", 
       RowBox[{"Mean", "[", 
        RowBox[{"f", "/@", "list"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
        RowBox[{"f1", "[", 
         RowBox[{"First", "[", "list", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"ftKsi", "[", 
          RowBox[{"u", ",", "list"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"uz", "[", 
            RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
           RowBox[{"uz", "[", 
            RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"h", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelk", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"hb", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"ftKsi", "[", 
         RowBox[{"uz", ",", "list"}], "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
          RowBox[{"u", "[", 
           RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2b", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"hb", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelkb", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2b"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Eraw"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelk"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelkb"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"vydejb", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"2", ",", "7", ",", "1"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"vydej", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"2", ",", "7", ",", "1"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.714721233890625*^9, 3.71472126696875*^9}, {
  3.71472136746875*^9, 3.714721435203125*^9}, {3.714721487265625*^9, 
  3.714721516296875*^9}, {3.7147215596875*^9, 3.714721665796875*^9}, {
  3.714721703125*^9, 3.714721732171875*^9}, {3.7147221045625*^9, 
  3.714722144671875*^9}, {3.7147224009375*^9, 3.714722410703125*^9}, {
  3.714722457125*^9, 3.714722497625*^9}, {3.714722533859375*^9, 
  3.71472272728125*^9}, {3.7147227644375*^9, 3.714722812875*^9}, {
  3.714722865078125*^9, 3.714723053125*^9}, {3.71472359590625*^9, 
  3.71472371175*^9}, {3.71472451265625*^9, 3.714724549234375*^9}, {
  3.7147246680625*^9, 3.714724688984375*^9}, {3.714724728984375*^9, 
  3.7147247386875*^9}, {3.714725047140625*^9, 3.714725047515625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
      "0.23924805547075323`", ",", "0.8853093359224573`", ",", 
       "0.8853093359224573`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
      "17.4380997037926`", ",", "0.9170190705811265`", ",", 
       "1.1199694271606164`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
      "10.022426651233074`", ",", "1.5116876374520416`", ",", 
       "1.2285445920976912`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
      "21.32314487370085`", ",", "1.0659610921878837`", ",", 
       "1.3049918233305036`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
      "1.595621048298601`", ",", "1.5083125889413074`", ",", 
       "1.3402044710815186`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
      "45.92360921260359`", ",", "1.518217673244937`", ",", 
       "1.386170815782295`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.714727490578125*^9, 3.71472757096875*^9, 
  3.714727609578125*^9, 3.7147277005*^9, 3.71472779440625*^9, 
  3.71472789725*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
      "0.23924805547075323`", ",", "0.8853093359224573`", ",", 
       "0.8853093359224573`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
      "17.4380997037926`", ",", "0.5865986726855565`", ",", 
       "1.1954497424240262`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
      "10.022426651233074`", ",", "1.4919532808315816`", ",", 
       "0.9256671901229474`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
      "21.32314487370085`", ",", "0.9363972640421103`", ",", 
       "1.2315387971017167`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
      "1.595621048298601`", ",", "1.4957184342828223`", ",", 
       "1.1264850221168743`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
      "45.92360921260359`", ",", "1.507393644531252`", ",", 
       "1.575037700141202`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.714727490578125*^9, 3.71472757096875*^9, 
  3.714727609578125*^9, 3.7147277005*^9, 3.71472779440625*^9, 
  3.714727897390625*^9}]
}, Open  ]]
},
WindowSize->{1041, 796},
WindowMargins->{{1, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 307, 9, 103, "Input"],
Cell[867, 31, 206, 5, 46, "Input"],
Cell[CellGroupData[{
Cell[1098, 40, 3591, 81, 462, "Input"],
Cell[4692, 123, 29499, 489, 414, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34228, 617, 6810, 168, 676, "Input"],
Cell[41041, 787, 78713, 1315, 461, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119791, 2107, 7752, 207, 930, "Input"],
Cell[CellGroupData[{
Cell[127568, 2318, 610, 13, 33, "Print"],
Cell[128181, 2333, 435, 9, 33, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128665, 2348, 4124, 100, 582, "Input"],
Cell[132792, 2450, 271, 6, 33, "Print"]
}, Open  ]],
Cell[133078, 2459, 6839, 186, 834, "Input"],
Cell[139920, 2647, 118, 2, 46, "Input"],
Cell[CellGroupData[{
Cell[140063, 2653, 5868, 154, 718, "Input"],
Cell[145934, 2809, 1340, 41, 120, "Output"],
Cell[147277, 2852, 1344, 41, 120, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
