(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     55289,       1639]
NotebookOptionsPosition[     53958,       1590]
NotebookOutlinePosition[     54338,       1606]
CellTagsIndexPosition[     54295,       1603]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"v", " ", "souboru", " ", 
     RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", 
     " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"cas", ",", 
       RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
       RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
    RowBox[{
     RowBox[{"predpokladame", " ", "out"}], "=", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"in", "[", "t", "]"}]}], "+", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
      RowBox[{"i", "*", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", "t"], 
        RowBox[{
         RowBox[{"in", "[", "\[Tau]", "]"}], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
         "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
    RowBox[{"d", " ", "a", " ", "napiste", " ", 
     RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali",
      " ", "svoji", " ", 
     RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
     "naprogramujete"}], ",", " ", 
    RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"10.", "*", 
       RowBox[{"Sin", "[", "t", "]"}]}], "+", 
      RowBox[{"5", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", "t"}], "]"}]}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i", "=", "7"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"int", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"f", "[", "t", "]"}]}], ",", 
          RowBox[{
           RowBox[{"int", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
        "int", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iSlozka", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"i", "*", 
       RowBox[{"int", "[", "t", "]"}]}], "/.", "sol"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dSlozka", "[", "t_", "]"}], "=", 
     RowBox[{"d", "*", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pSlozka", "[", "t_", "]"}], "=", 
     RowBox[{"p", "*", 
      RowBox[{"f", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"dSlozka", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vystup", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"pSlozka", "[", "t", "]"}], "+", 
      RowBox[{"iSlozka", "[", "t", "]"}], "+", 
      RowBox[{"dSlozka", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"f", "[", "#", "]"}], ",", 
         RowBox[{"vystup", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataPID.csv\>\"", ",", "data"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", "\"\<dataPID.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vystup", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"data", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "out"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vstup", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"data", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "in"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"vystup", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"casy", "=", 
     RowBox[{"data", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
       "t"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{
      RowBox[{"casy", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "-", 
      RowBox[{"casy", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hodnotyIntegralu", "=", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "*", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Accumulate", "[", 
          RowBox[{"data", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]",
             "in"}]}], "]"}], ",", "0"}], "]"}]}], "//", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{"#", ",", 
         RowBox[{"-", "1"}]}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intIntegral", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"casy", ",", "hodnotyIntegralu"}], "}"}], "\[Transpose]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datproFit", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"vstup", "[", "#", "]"}], ",", 
         RowBox[{"intIntegral", "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"vstup", "'"}], "[", "#", "]"}], ",", 
         RowBox[{"vystup", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"tmin", ",", "tmax", ",", 
        FractionBox[
         RowBox[{"tmax", "-", "tmin"}], "100"]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Fit", "[", 
    RowBox[{"datproFit", ",", 
     RowBox[{"{", 
      RowBox[{"pp", ",", "ii", ",", "dd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"pp", ",", "ii", ",", "dd"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.724320734265625*^9, 3.72432103215625*^9}, {
   3.724321083875*^9, 3.7243213455625*^9}, {3.724321385390625*^9, 
   3.724321564390625*^9}, {3.724321663765625*^9, 3.724321840953125*^9}, {
   3.72432187428125*^9, 3.72432190003125*^9}, {3.724321931390625*^9, 
   3.72432199065625*^9}, {3.7243220345625*^9, 3.72432210821875*^9}, {
   3.724322387859375*^9, 3.724322530484375*^9}, {3.7243225699375*^9, 
   3.7243226161875*^9}, {3.72432265234375*^9, 3.724322662265625*^9}, 
   3.724325867546875*^9, {3.7244821895733504`*^9, 3.724482191838975*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.499914752169933`", " ", "dd"}], "+", 
  RowBox[{"7.000597723771407`", " ", "ii"}], "+", 
  RowBox[{"10.070083041472644`", " ", "pp"}]}]], "Output",
 CellChangeTimes->{3.754273886890625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "V", " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", 
      "data", " ", "ve", " ", "tvaru", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
      "motor"}], "-", 
     RowBox[{
      RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
      "je"}], " ", "-", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "*", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
      "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
    RowBox[{"konstantu", " ", "treni"}], ",", " ", 
    RowBox[{
    "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
     "soustroji", " ", "rozebehne", " ", "pri", " ", "hancim", " ", "momentu",
      " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
     "dobu", " ", "dosahne", " ", "ulova", " ", "rychlost", " ", "poloviny", 
     " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
     RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"J", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", "0.012"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kv", "=", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]0", "=", 
     RowBox[{"0.45", "*", "314"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"2", "*", "60"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"J", "*", 
            RowBox[{
             RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "B"}], "*", 
             RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
            RowBox[{"kv", "*", 
             SuperscriptBox[
              RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}], ",", 
          RowBox[{
           RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "\[Omega]0"}]}], 
         "}"}], ",", "\[Omega]", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"\[Omega]", "/.", "sol"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"\[Omega]", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "100"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataDobeh.csv\>\"", ",", "data"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", "\"\<dataDobeh.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"int\[Omega]", "=", 
     RowBox[{"Interpolation", "[", "data", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"int\[Omega]", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datproFit", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"int\[Omega]", "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"int\[Omega]", "'"}], "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"-", "kv"}], "*", 
          SuperscriptBox[
           RowBox[{"int\[Omega]", "[", "#", "]"}], "2"]}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{"datproFit", ",", 
       RowBox[{"{", 
        RowBox[{"omega", ",", "deromega"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"omega", ",", "deromega"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Bmer", "=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"fit", ",", "omega"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Jmer", "=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"fit", ",", "deromega"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Mrozbeh", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmaxRozbeh", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Omega]r", "'"}], "[", "t", "]"}], "*", "Jmer"}], 
           "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Bmer"}], "*", 
             RowBox[{"\[Omega]r", "[", "t", "]"}]}], "-", 
            RowBox[{"kv", "*", 
             SuperscriptBox[
              RowBox[{"\[Omega]r", "[", "t", "]"}], "2"]}], "+", 
            "Mrozbeh"}]}], ",", 
          RowBox[{
           RowBox[{"\[Omega]r", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", "\[Omega]r", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmaxRozbeh"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]rr", "[", "t_", "]"}], ":=", " ", 
     RowBox[{
      RowBox[{"\[Omega]r", "[", "t", "]"}], "/.", "sol"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]rr", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmaxRozbeh"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]inf", "=", 
     RowBox[{"\[Omega]rr", "[", "tmaxRozbeh", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]Pul", "=", 
     RowBox[{"0.5", "\[Omega]inf"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tPul", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Omega]rr", "[", "t", "]"}], "\[Equal]", "\[Omega]Pul"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"0.01", "tmax"}]}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<J= \>\"", ",", "Jmer", ",", "\"\<  B= \>\"", ",", "Bmer", ",", 
     "\"\<  \[Omega]inf= \>\"", ",", "\[Omega]inf", ",", "\"\<  tPul= \>\"", 
     ",", "tPul"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.724322683546875*^9, {3.724322714953125*^9, 3.724323322953125*^9}, {
   3.724324213453125*^9, 3.724324228296875*^9}, {3.72432429309375*^9, 
   3.72432430578125*^9}, {3.724324360203125*^9, 3.724324361046875*^9}, {
   3.7243243940625*^9, 3.7243244180625*^9}, {3.724324932359375*^9, 
   3.72432563309375*^9}, 3.724325827984375*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"J= \"\>", "\[InvisibleSpace]", "0.3000071930724017`", 
   "\[InvisibleSpace]", "\<\"  B= \"\>", "\[InvisibleSpace]", 
   "0.012000267110831095`", "\[InvisibleSpace]", "\<\"  \[Omega]inf= \"\>", 
   "\[InvisibleSpace]", "27.464341325570793`", 
   "\[InvisibleSpace]", "\<\"  tPul= \"\>", "\[InvisibleSpace]", 
   "4.502139866069219`"}],
  SequenceForm[
  "J= ", 0.3000071930724017, "  B= ", 0.012000267110831095`, 
   "  \[Omega]inf= ", 27.464341325570793`, "  tPul= ", 4.502139866069219],
  Editable->False]], "Print",
 CellChangeTimes->{3.75427388709375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataRC.csv\>\"", " ", "jsou", " ", "data", 
     " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"frekvence", ",", " ", 
       RowBox[{"Re", "[", "z", "]"}], ",", 
       RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "paralelni", " ", 
     "kombinace", " ", "rezistoru", " ", "a", " ", "kondenzatoru"}], ",", " ", 
    RowBox[{"najdete", " ", "jejich", " ", "kapacitu", " ", "a", " ", 
     RowBox[{"odpor", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]F", "=", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "120.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"470.", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "f_", "]"}], ":=", 
     RowBox[{
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}], "+", 
      FractionBox["1", "R"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "[", "f_", "]"}], ":=", 
     FractionBox["1", 
      RowBox[{"y", "[", "f", "]"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fmin", ",", "fmax"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"50.", ",", "1500."}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{"Re", "[", 
           RowBox[{"z", "[", "#", "]"}], "]"}], "+", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "k"}], ",", "k"}], "}"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"z", "[", "#", "]"}], "]"}], "+", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "k"}], ",", "k"}], "}"}], "]"}]}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"fmin", ",", "fmax", ",", "100"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataRC.csv\>\"", ",", "data"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", "\"\<dataRC.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zNahr", "[", "f_", "]"}], ":=", 
     FractionBox["1", 
      RowBox[{
       FractionBox["1", "Rmer"], "+", 
       RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "cmer"}]}]]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"err", "[", 
      RowBox[{"{", 
       RowBox[{"f_", ",", "re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"re", "-", 
         RowBox[{"Re", "[", 
          RowBox[{"zNahr", "[", "f", "]"}], "]"}]}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"im", "-", 
         RowBox[{"Im", "[", 
          RowBox[{"zNahr", "[", "f", "]"}], "]"}]}], ")"}], "2"]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"promin", "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"err", "/@", "data"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"promin", ",", 
     RowBox[{"{", 
      RowBox[{"cmer", ",", 
       RowBox[{"20.", "\[Mu]F"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Rmer", ",", "20"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.72432601265625*^9, {3.7243260908125*^9, 3.72432638728125*^9}, {
   3.7243264326875*^9, 3.724326615640625*^9}, {3.72432664828125*^9, 
   3.724326822625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0008145056996461686`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cmer", "\[Rule]", "0.00046994950234394346`"}], ",", 
     RowBox[{"Rmer", "\[Rule]", "122.36925928091992`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7542738873125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Mate", " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", 
    " ", 
    RowBox[{
     RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
      RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
    RowBox[{"IRR", " ", "takove"}], ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       RowBox[{
        FractionBox["rocniUspora", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
        "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
        "dobou", " ", "navratnosti", " ", "definovanou", " ", "ta"}]}]}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "Treal"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"INV", "=", 
     RowBox[{"50.5", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diskont", "=", "3.4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rocniUspora", "=", 
     RowBox[{"4.1", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zivotnost", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NPV", "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"IRR", "=", 
     RowBox[{"irr", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"0", "==", 
         RowBox[{
          RowBox[{"-", "INV"}], "+", 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"i", "=", "1"}], "zivotnost"], 
           FractionBox["rocniUspora", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"irr", ",", "diskont"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datinv", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Reverse", "@", 
        RowBox[{"{", 
         RowBox[{"T", ",", 
          RowBox[{
           RowBox[{"-", "INV"}], "+", 
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"i", "=", "1"}], "T"], 
            FractionBox["rocniUspora", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], 
         "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "0", ",", "zivotnost"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Treal", "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{"datinv", ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "0", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<NPV= \>\"", ",", "NPV", ",", "\"\<  IRR= \>\"", ",", "IRR", ",", 
     "\"\<  Treal= \>\"", ",", "Treal"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7243269765625*^9, 3.724327253921875*^9}, {
  3.72432778575*^9, 3.72432797796875*^9}, {3.724328076125*^9, 
  3.724328231671875*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"NPV= \"\>", "\[InvisibleSpace]", "8.301654208383031`*^6", 
   "\[InvisibleSpace]", "\<\"  IRR= \"\>", "\[InvisibleSpace]", 
   "5.138575573576343`", "\[InvisibleSpace]", "\<\"  Treal= \"\>", 
   "\[InvisibleSpace]", "16.232376783314237`"}],
  SequenceForm[
  "NPV= ", 8.301654208383031*^6, "  IRR= ", 5.138575573576343, "  Treal= ", 
   16.232376783314237`],
  Editable->False]], "Print",
 CellChangeTimes->{3.75427388734375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"V", " ", "souboru", " ", 
     RowBox[{"dataFrekvence", ".", "csv"}], " ", "jsou", " ", "dvojice", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cas", ",", "napeti"}], "}"}], ".", " ", "Najdete"}], " ", 
     "frekvenci", " ", "signalu", " ", "a", " ", "amplitudy", " ", 
     "harmonickych"}], ",", " ", 
    RowBox[{"vite", "-", 
     RowBox[{
     "li", " ", "ze", " ", "vyssi", " ", "nez", " ", "sesta", " ", "se", " ", 
      "v", " ", "signalu", " ", "nevyskytuje"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", 
     RowBox[{"0.945", "*", "fnom"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2.", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"10.", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"\[Omega]", "*", "t"}], "+", "0.45"}], "]"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", "*", "\[Omega]", "*", "t"}], "]"}]}], "+", 
      RowBox[{"1", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"5", "*", "\[Omega]", "*", "t"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"u", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", 
        RowBox[{"3", "T"}], ",", 
        FractionBox["T", "50"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", "data", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataFrekvence.csv\>\"", ",", "data"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", "\"\<dataFrekvence.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intData", "=", 
     RowBox[{"Interpolation", "[", "data", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"intData", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"intData", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t1", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"intData", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0.01"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"intData", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0.03"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tmer", "=", 
     RowBox[{"t2", "-", "t1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<f= \>\"", ",", 
      FractionBox["1", "Tmer"], ",", "\"\< Hz\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Quiet", "@", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"i", "*", 
            FractionBox[
             RowBox[{"2.", "Pi"}], "Tmer"], "*", "t"}], "]"}], "*", 
          RowBox[{"intData", "[", "t", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}]}], "]"}]}], "*", 
      FractionBox["2", "Tmer"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Quiet", "@", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"i", "*", 
            FractionBox[
             RowBox[{"2.", "Pi"}], "Tmer"], "*", "t"}], "]"}], "*", 
          RowBox[{"intData", "[", "t", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}]}], "]"}]}], 
      FractionBox["2", "Tmer"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataHarm", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"a", "[", "#", "]"}], ",", 
         RowBox[{"b", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", "7", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"dataHarm", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n_", ",", "a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]}], "}"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.7243282599375*^9, 3.724328347421875*^9}, {
   3.724482286307725*^9, 3.7244829149171004`*^9}, {3.7244829575108504`*^9, 
   3.724482990620225*^9}, {3.7244830217296004`*^9, 3.7244830238233504`*^9}, 
   3.724483063276475*^9, {3.724483118526475*^9, 3.7244831984171004`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"f= \"\>", "\[InvisibleSpace]", "47.249999999999275`", 
   "\[InvisibleSpace]", "\<\" Hz\"\>"}],
  SequenceForm["f= ", 47.249999999999275`, " Hz"],
  Editable->False]], "Print",
 CellChangeTimes->{3.754273887484375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "10.000044422495034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0.00016912770705984132`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1.999421036388883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.0001683452722840138`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.9977591389680949`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.00016704705980792557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.0001662071273683946`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7542738895625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
    RowBox[{
     RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
     RowBox[{
      RowBox[{
      "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
       " ", "o", " ", "U"}], "=", 
      RowBox[{
      "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
       RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
       " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
       "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"U", "=", 
     RowBox[{"750", "*", 
      SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R1", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R2", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pcelk", "=", 
     RowBox[{"1000", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1", "=", 
     RowBox[{"U", "-", 
      RowBox[{"R1", "*", "i1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u2", "=", 
     RowBox[{"U", "-", 
      RowBox[{"R2", "*", "i2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P1", "=", 
     RowBox[{"u1", "*", "i1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P2", "=", 
     RowBox[{"u2", "*", "i2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"min", "=", 
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"R1", "*", 
          SuperscriptBox["i1", "2"]}], "+", 
         RowBox[{"R2", "*", 
          SuperscriptBox["i2", "2"]}]}], ",", 
        RowBox[{"Pcelk", "\[Equal]", 
         RowBox[{"P1", "+", "P2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i1", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i2", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"min", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "Pcelk"], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "P2"}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"R1", "*", 
         SuperscriptBox["i1", "2"]}], ",", 
        RowBox[{"R2", "*", 
         SuperscriptBox["i2", "2"]}]}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2"}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7244875491983504`*^9, 3.7244879638546004`*^9}, {
  3.724488021870225*^9, 3.724488034838975*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.090047760667053`*^7", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i1", "\[Rule]", "808.7203820853284`"}], ",", 
     RowBox[{"i2", "\[Rule]", "539.146921390211`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.75427388996875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010900477606670532`", ",", 
   RowBox[{"{", 
    RowBox[{"5.999999999999939`*^8", ",", "3.999999999999901`*^8"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"6.540286564002396`*^6", ",", "4.360191042668135`*^6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"741912.7961791467`", ",", "741912.7961791469`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.75427388996875*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Tepelna", " ", "vodivost", " ", "cihlove", " ", "zdi", " ", "s", " ", 
      "izolaci", " ", "je", " ", 
      RowBox[{"\[Lambda]", "[", "x", "]"}]}], "=", 
     RowBox[{"0.4", "*", 
      RowBox[{"(", 
       RowBox[{"1.1", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"500", 
          RowBox[{"(", 
           RowBox[{"x", "-", "0.1"}], ")"}]}], "]"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"prislusna", " ", "rovnice", " ", "je", " ", "0"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "x", "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
         "]"}], ".", " ", "Okrajove"}], " ", "podminky", " ", "jsou", " ", 
       RowBox[{"T", "[", "0", "]"}]}]}], "=", 
     RowBox[{"-", "15"}]}], ",", " ", 
    RowBox[{
     RowBox[{"T", "[", "0.455", "]"}], "=", 
     RowBox[{"18.", " ", "Vyreste", " ", 
      RowBox[{"dif", ".", " ", "rovnici"}], " ", "a", " ", "zobrazte", " ", 
      "graf", " ", "reseni"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", "0.455"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Lambda]", "[", "x_", "]"}], ":=", 
     RowBox[{"0.4", "*", 
      RowBox[{"(", 
       RowBox[{"1.1", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"500", 
          RowBox[{"(", 
           RowBox[{"x", "-", "0.1"}], ")"}]}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Lambda]", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "0.4"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rce", "[", 
      RowBox[{"der_", "?", "NumericQ"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "[", "0", "]"}], "\[Equal]", 
        RowBox[{"-", "15"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "der"}], ",", 
       RowBox[{"0", "==", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "x", "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
         "]"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol", "[", 
      RowBox[{"der_", "?", "NumericQ"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"rce", "[", "der", "]"}], ",", "T", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Td", "[", 
      RowBox[{"der_", "?", "NumericQ"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"T", "[", "d", "]"}], "/.", 
      RowBox[{"sol", "[", "der", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dd", "=", 
     RowBox[{"dder", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Td", "[", "dder", "]"}], "\[Equal]", "18"}], ",", 
        RowBox[{"{", 
         RowBox[{"dder", ",", "100"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vys", "=", 
     RowBox[{"T", "/.", 
      RowBox[{"sol", "[", "dd", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"vys", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "d"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.724488251932725*^9, {3.724488301463975*^9, 3.7244883028546004`*^9}, {
   3.724488366088975*^9, 3.7244886432608504`*^9}, {3.7244886757608504`*^9, 
   3.7244888733233504`*^9}, {3.724489061463975*^9, 3.7244891644171004`*^9}, 
   3.7542738933125*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataVaristor.csv\>\"", " ", "jsou", " ", 
     "data", " ", "ve", " ", "tvaru", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cas", ",", " ", 
        RowBox[{
        "napeti", " ", "na", " ", "varistoru", " ", "s", " ", 
         "kondenzatorem"}], ",", 
        RowBox[{"proud", " ", "varistorem"}]}], "}"}], ".", " ", "Kapacita"}],
      " ", "kondenzatoru", " ", "je", " ", "4.7", 
     RowBox[{"\[Mu]F", ".", " ", "Naleznete"}], " ", "charakteristiku", " ", 
     "varistoru", " ", "a", " ", "teplo"}], ",", " ", 
    RowBox[{
    "ktere", " ", "se", " ", "za", " ", "jednu", " ", "periodu", " ", "na", 
     " ", "varistoru", " ", "vygeneruje"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"4.7", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uOmez", "=", 
     RowBox[{"1.2", "*", 
      SqrtBox["2"], "*", "230."}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"proudR", "[", "u_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]], "*", 
      SuperscriptBox["u", "3"], 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"u", "-", "uOmez"}], ")"}], "*", "k"}], "]"}], "-", 
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"u", "+", "uOmez"}], ")"}], "*", "k"}], "]"}]}], ")"}]}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"proudR", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"-", "1.5"}], "uOmez"}], ",", 
        RowBox[{"1.5", "uOmez"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<u [V]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{"500.", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"314.", "t"}], "]"}], "+", 
        RowBox[{"0.05", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", "*", "314.", "t"}], "]"}]}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"proudC", "[", "t_", "]"}], ":=", 
     RowBox[{"c", "*", 
      RowBox[{
       RowBox[{"u", "'"}], "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"proudR", "[", 
         RowBox[{"u", "[", "t", "]"}], "]"}], ",", 
        RowBox[{"proudC", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0.04"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataVaristor", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"u", "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"proudR", "[", 
           RowBox[{"u", "[", "#", "]"}], "]"}], "+", 
          RowBox[{"proudC", "[", "#", "]"}]}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "0.04", ",", 
        FractionBox["0.02", "1000"]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<dataVaristor.csv\>\"", ",", "dataVaristor"}], "]"}], ";"}],
     "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intU", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"dataVaristor", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "u"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intI", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"dataVaristor", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "i"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"intU", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0.03"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<teplo= \>\"", ",", 
     RowBox[{
      FractionBox["1", "0.02"], "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"intU", "[", "t", "]"}], "*", 
         RowBox[{"intI", "[", "t", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "0.02"}], "}"}]}], "]"}]}], ",", 
     "\"\< J\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.75427390540625*^9, 3.75427421646875*^9}, {
  3.754274254671875*^9, 3.754274258578125*^9}, {3.754274297*^9, 
  3.7542745573125*^9}, {3.754274590828125*^9, 3.754274602515625*^9}, {
  3.754274637921875*^9, 3.754274834984375*^9}, {3.754274882140625*^9, 
  3.754275072*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"teplo= \"\>", "\[InvisibleSpace]", "1734.8528225325392`", 
   "\[InvisibleSpace]", "\<\" J\"\>"}],
  SequenceForm["teplo= ", 1734.8528225325392`, " J"],
  Editable->False]], "Print",
 CellChangeTimes->{3.754275033453125*^9, 3.75427507540625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataUcinik.csv\>\"", " ", "jsou", " ", 
     "dvojice", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"napeti", ",", " ", "proud"}], "}"}], ".", " ", "Najdete"}], 
     " ", "P"}], ",", " ", 
    RowBox[{"Q", " ", "a", " ", 
     RowBox[{"cos", "[", "fi", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rn", ":=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"230.", "*", 
       SqrtBox["2"], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"100", "Pi", "*", "t"}], "]"}]}], "+", "rn"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"1.", "*", 
       SqrtBox["2"], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"100", "Pi", "*", "t"}], "-", 
         FractionBox["Pi", "6"]}], "]"}]}], "+", 
      RowBox[{"0.005", "rn"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataUcinik", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "#", "]"}], ",", 
         RowBox[{"i", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "0.02", ",", 
        FractionBox["1", 
         SuperscriptBox["10", "5"]]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", "dataUcinik", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<dataUcinik.csv\>\"", ",", "dataUcinik"}], "]"}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"err", "[", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "*", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"b", "*", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"c", "*", "x", "*", "y"}], "-", "1"}], ")"}], "2"]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"errcelk", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{"err", "/@", "dataUcinik"}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0", "==", 
       RowBox[{"D", "[", 
        RowBox[{"errcelk", ",", "#"}], "]"}]}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av", ",", "bv", ",", "cv"}], "}"}], "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"Solve", "[", "%", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"err2", "[", "t_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"av", "*", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"bv", "*", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"cv", "*", "x", "*", "y"}], "-", "1"}], ")"}], "2"], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", 
         RowBox[{"um", "*", 
          RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
        RowBox[{"y", "\[Rule]", 
         RowBox[{"im", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"t", "+", "fi"}], "]"}]}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"erreli", "=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"err2", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", 
          RowBox[{"2.", "Pi"}], ",", "0.05"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"erreli", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"um", ",", "300"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"im", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"fi", ",", "0.3"}], "}"}]}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.754275117671875*^9, 3.754275438875*^9}, {
  3.754275497078125*^9, 3.75427564396875*^9}, {3.754275676671875*^9, 
  3.754276136796875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.025565966891782`*^-20", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"um", "\[Rule]", "324.88359227027814`"}], ",", 
     RowBox[{"im", "\[Rule]", "1.415598542912157`"}], ",", 
     RowBox[{"fi", "\[Rule]", "0.5291008883349102`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.75427602196875*^9, 3.754276078265625*^9}}]
}, Open  ]]
},
WindowSize->{1091, 646},
WindowMargins->{{6, Automatic}, {Automatic, 5}},
Magnification->1.7000001668930054`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 330, 9, 107, "Input"],
Cell[CellGroupData[{
Cell[913, 33, 8030, 227, 1013, "Input"],
Cell[8946, 262, 226, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9209, 272, 8330, 228, 1164, "Input"],
Cell[17542, 502, 608, 12, 35, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18187, 519, 4351, 124, 747, "Input"],
Cell[22541, 645, 296, 8, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22874, 658, 4467, 131, 679, "Input"],
Cell[27344, 791, 478, 10, 37, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27859, 806, 5765, 167, 888, "Input"],
Cell[33627, 975, 267, 6, 35, "Print"],
Cell[33897, 983, 645, 17, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34579, 1005, 3055, 88, 534, "Input"],
Cell[37637, 1095, 285, 8, 53, "Output"],
Cell[37925, 1105, 426, 12, 86, "Output"]
}, Open  ]],
Cell[38366, 1120, 4296, 123, 397, "Input"],
Cell[CellGroupData[{
Cell[42687, 1247, 5771, 166, 746, "Input"],
Cell[48461, 1415, 294, 6, 35, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48792, 1426, 4773, 150, 597, "Input"],
Cell[53568, 1578, 374, 9, 53, "Output"]
}, Open  ]]
}
]
*)

