(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11604,        317]
NotebookOptionsPosition[     10967,        294]
NotebookOutlinePosition[     11347,        310]
CellTagsIndexPosition[     11304,        307]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"v", " ", "souboru", " ", 
    RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", " ",
     "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"cas", ",", 
      RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
      RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
   RowBox[{
    RowBox[{"predpokladame", " ", "out"}], "=", 
    RowBox[{
     RowBox[{"p", "*", 
      RowBox[{"in", "[", "t", "]"}]}], "+", 
     RowBox[{"d", "*", 
      RowBox[{
       RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
     RowBox[{"i", "*", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", "t"], 
       RowBox[{
        RowBox[{"in", "[", "\[Tau]", "]"}], 
        RowBox[{
         RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
        "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
   RowBox[{"d", " ", "a", " ", "napiste", " ", 
    RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali", 
    " ", "svoji", " ", 
    RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
    "naprogramujete"}], ",", " ", 
   RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456078390625*^9, 3.72456080115625*^9}, {
  3.7542738243125*^9, 3.7542738261875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", 
     "data", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
     "motor"}], "-", 
    RowBox[{
     RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
     "je"}], " ", "-", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]], "*", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
     "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
   RowBox[{"konstantu", " ", "treni"}], ",", " ", 
   RowBox[{
   "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
    "soustroji", " ", "rozebehne", " ", "pri", " ", "hancim", " ", "momentu", 
    " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
    "dobu", " ", "dosahne", " ", "ulova", " ", "rychlost", " ", "poloviny", 
    " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
    RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
   RowBox[{
   "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ", 
    "algoritmu", " ", "pro", " ", "zasumela", " ", 
    RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
   ",", " ", 
   RowBox[{"extra", " ", 
    RowBox[{"body", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.724560806765625*^9, 3.72456080821875*^9}, {
  3.75427383015625*^9, 3.754273831078125*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "V", " ", "souboru", " ", "\"\<dataRC.csv\>\"", " ", "jsou", " ", "data", 
    " ", "ve", " ", "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"frekvence", ",", " ", 
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "paralelni", " ", 
    "kombinace", " ", "rezistoru", " ", "a", " ", "kondenzatoru"}], ",", " ", 
   RowBox[{"najdete", " ", "jejich", " ", "kapacitu", " ", "a", " ", 
    RowBox[{"odpor", ".", " ", "Popiste"}]}], ",", " ", 
   RowBox[{
   "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ", 
    "algoritmu", " ", "pro", " ", "zasumela", " ", 
    RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
   ",", " ", 
   RowBox[{"extra", " ", 
    RowBox[{"body", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456083340625*^9, 3.724560834765625*^9}, {
  3.754273834609375*^9, 3.754273835453125*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Mate", " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", " ", 
   RowBox[{
    RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
     RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "zivotnost"], 
      FractionBox["rocniUspora", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
   RowBox[{"IRR", " ", "takove"}], ",", " ", 
   RowBox[{
    RowBox[{"ze", " ", "0"}], "==", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "zivotnost"], 
      RowBox[{
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
       "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
       "dobou", " ", "navratnosti", " ", "definovanou", " ", "ta"}]}]}]}], 
   ",", " ", 
   RowBox[{
    RowBox[{"ze", " ", "0"}], "==", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "Treal"], 
      FractionBox["rocniUspora", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"INV", "=", 
     RowBox[{"50.5", "*", 
      SuperscriptBox["10", "6"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"diskont", "=", "3.4"}], ";", "\[IndentingNewLine]", 
    RowBox[{"rocniUspora", "=", 
     RowBox[{"4.1", "*", 
      SuperscriptBox["10", "6"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"zivotnost", "=", "20"}], ";"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456084278125*^9, 3.724560848796875*^9}, {
  3.7542738406875*^9, 3.7542738416875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"V", " ", "souboru", " ", 
    RowBox[{"dataFrekvence", ".", "csv"}], " ", "jsou", " ", "dvojice", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cas", ",", "napeti"}], "}"}], ".", " ", "Najdete"}], " ", 
    "frekvenci", " ", "signalu", " ", "a", " ", "amplitudy", " ", 
    "harmonickych"}], ",", " ", 
   RowBox[{"vite", "-", 
    RowBox[{
    "li", " ", "ze", " ", "vyssi", " ", "nez", " ", "sesta", " ", "se", " ", 
     "v", " ", "signalu", " ", "nevyskytuje"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456089015625*^9, 3.7245609069375*^9}, {
  3.75427384571875*^9, 3.754273846796875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
   RowBox[{
    RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
    RowBox[{
     RowBox[{
     "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
      " ", "o", " ", "U"}], "=", 
     RowBox[{
     "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
      RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
      " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
      "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.7245608820625*^9, 3.7245608866875*^9}, {
  3.754273850125*^9, 3.754273851953125*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Tepelna", " ", "vodivost", " ", "cihlove", " ", "zdi", " ", "s", " ", 
     "izolaci", " ", "je", " ", 
     RowBox[{"\[Lambda]", "[", "x", "]"}]}], "=", 
    RowBox[{"0.4", "*", 
     RowBox[{"(", 
      RowBox[{"1.1", "+", 
       RowBox[{"Tanh", "[", 
        RowBox[{"500", 
         RowBox[{"(", 
          RowBox[{"x", "-", "0.1"}], ")"}]}], "]"}]}], ")"}]}]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"prislusna", " ", "rovnice", " ", "je", " ", "0"}], "==", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Lambda]", "[", "x", "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
        "]"}], ".", " ", "Okrajove"}], " ", "podminky", " ", "jsou", " ", 
      RowBox[{"T", "[", "0", "]"}]}]}], "=", 
    RowBox[{"-", "15"}]}], ",", " ", 
   RowBox[{
    RowBox[{"T", "[", "0.455", "]"}], "=", 
    RowBox[{"18.", " ", "Vyreste", " ", 
     RowBox[{"dif", ".", " ", "rovnici"}], " ", "a", " ", "zobrazte", " ", 
     "graf", " ", "reseni"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456086015625*^9, 3.724560863046875*^9}, {
  3.754273855828125*^9, 3.754273856734375*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "V", " ", "souboru", " ", "\"\<dataVaristor.csv\>\"", " ", "jsou", " ", 
    "data", " ", "ve", " ", "tvaru", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cas", ",", " ", 
       RowBox[{
       "napeti", " ", "na", " ", "varistoru", " ", "s", " ", 
        "kondenzatorem"}], ",", 
       RowBox[{"proud", " ", "varistorem"}]}], "}"}], ".", " ", "Kapacita"}], 
    " ", "kondenzatoru", " ", "je", " ", "4.7", 
    RowBox[{"\[Mu]F", ".", " ", "Naleznete"}], " ", "charakteristiku", " ", 
    "varistoru", " ", "a", " ", "teplo"}], ",", " ", 
   RowBox[{
   "kter0", " ", "se", " ", "za", " ", "jednu", " ", "periodu", " ", "na", 
    " ", "varistoru", " ", "vygeneruje"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "V", " ", "souboru", " ", "\"\<dataUcinik.csv\>\"", " ", "jsou", " ", 
    "dvojice", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"napeti", ",", " ", "proud"}], "}"}], ".", " ", "Najdete"}], 
    " ", "P"}], ",", " ", 
   RowBox[{"Q", " ", "a", " ", 
    RowBox[{"cos", "[", "fi", "]"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.75427615003125*^9, 3.754276155078125*^9}}]
},
WindowSize->{1091, 646},
WindowMargins->{{6, Automatic}, {Automatic, 5}},
Magnification->1.7000001668930054`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 330, 9, 107, "Input"],
Cell[891, 31, 1358, 33, 229, "Input"],
Cell[2252, 66, 1635, 37, 310, "Input"],
Cell[3890, 105, 986, 21, 223, "Input"],
Cell[4879, 128, 2074, 56, 357, "Input"],
Cell[6956, 186, 682, 15, 136, "Input"],
Cell[7641, 203, 783, 17, 165, "Input"],
Cell[8427, 222, 1336, 36, 136, "Input"],
Cell[9766, 260, 756, 18, 136, "Input"],
Cell[10525, 280, 438, 12, 78, "Input"]
}
]
*)

