(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16099,        518]
NotebookOptionsPosition[     15281,        489]
NotebookOutlinePosition[     15729,        508]
CellTagsIndexPosition[     15686,        505]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"<<", "Statistics`NonlinearFit`"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mocnina", "=", "9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{"{", 
    RowBox[{"fi", ",", 
     SuperscriptBox["fi", "mocnina"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fceu", "=", 
   RowBox[{"%", "/.", 
    RowBox[{"fi", "\[Rule]", "ueff"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prubehproudu", "=."}], ";", 
  RowBox[{"effhodnota", "=."}], ";", 
  RowBox[{"vyrint", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50."}], ";", 
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2", "*", "\[Pi]", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"umax", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosfi", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{"u", ",", "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"linfce", "[", "x_", "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.26"}], "}"}]}], "}"}], ",", "x", ",", "x"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lincast", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "%"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "0.75", ",", "0.002"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"un", "=", 
   RowBox[{
    FractionBox["420", 
     SqrtBox["3"]], "*", 
    SuperscriptBox["10", "3"]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"in", "=", "1650"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"linfce", "[", "x_", "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.26"}], "}"}]}], "}"}], ",", "x", ",", "x"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lincast", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"un", "*", "x"}], ",", 
       RowBox[{"in", "*", "%"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "0.75", ",", "0.02"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"koleno", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.8", ",", "0.34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "0.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.95", ",", "0.75"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.001", ",", "1.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.05", ",", "1.45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.15", ",", "2.75"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.25", ",", "5.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3", ",", "7.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.35", ",", "10"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"koleno2", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"un", "*", 
         RowBox[{"koleno", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}]}], ",", 
        RowBox[{"in", "*", 
         RowBox[{"koleno", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", 
        RowBox[{"Length", "[", "koleno", "]"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]"}], 
  RowBox[{"(*", 
   RowBox[{"koleno2", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"magChakaEf", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"lincast", ",", "koleno2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"magChakaEf", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", "magChakaEf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"charaka", "[", "napeti_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"%", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], "[", "napeti", 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"napeti", ",", 
       RowBox[{
        RowBox[{"First", "[", "%%", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"Last", "[", "%%", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<u[V]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}]}], "]"}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{"vyrproud", "=", 
  RowBox[{"Dot", "[", 
   RowBox[{"params", ",", "fce"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prubehproudu", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"vyrproud", "/.", 
      RowBox[{"fi", "\[Rule]", "dosfi"}]}], "/.", 
     RowBox[{"umax", "\[Rule]", 
      RowBox[{"ueff", "*", 
       SqrtBox["2"]}]}]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"effhodnota", "=", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "T"], "*", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       SuperscriptBox["prubehproudu", "2"], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{
          RowBox[{"-", "T"}], "/", "2"}], ",", 
         RowBox[{"T", "/", "2"}]}], "}"}]}], "]"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Maxhod", "=", 
  RowBox[{
   RowBox[{"Last", "[", "data", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"umaxfit", "=", "Maxhod"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataFit", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"charaka", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0.", ",", "umaxfit", ",", 
       FractionBox["umaxfit", "500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"fitcharaky", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"dataFit", ",", "fceu", ",", "ueff"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{"charaka", "[", "ueff", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ueff", ",", "0", ",", "Maxhod"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataFit2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       FractionBox[
        RowBox[{"charaka", "[", "u", "]"}], "u"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "1", ",", "umaxfit", ",", 
       FractionBox["umaxfit", "500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model2", "=", 
   RowBox[{"effhodnota", "/.", 
    RowBox[{
     SuperscriptBox["ueff", "k_"], "\[Rule]", 
     SuperscriptBox["ueff", 
      RowBox[{"k", "-", "2"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ftrans", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ftrans", "[", "hh_List", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"hh", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0", ",", 
       RowBox[{"1.", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "hh", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obor", "=", 
   RowBox[{"ftrans", "[", "params", "]"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"nahrada", "=", 
  RowBox[{"NonlinearFit", "[", 
   RowBox[{"dataFit2", ",", "model2", ",", "ueff", ",", "obor"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"dosab", "=", 
  RowBox[{"BestFitParameters", "/.", 
   RowBox[{"NonlinearRegress", "[", 
    RowBox[{"dataFit2", ",", "model2", ",", "ueff", ",", "obor", ",", 
     RowBox[{"RegressionReport", "\[Rule]", "BestFitParameters"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vyslednanahrada", "=", 
   RowBox[{"ueff", "*", "nahrada"}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"charaka", "[", "ueff", "]"}], ",", "vyslednanahrada"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"ueff", ",", "0", ",", "Maxhod"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Ueff[V]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"charaka", "[", "ueff", "]"}], "-", "vyslednanahrada"}], ",", 
   RowBox[{"{", 
    RowBox[{"ueff", ",", "0", ",", "Maxhod"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Ueff[V]\>\"", ",", "\"\<\[CapitalDelta]i[A]\>\""}], 
     "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"100", 
    FractionBox[
     RowBox[{
      RowBox[{"charaka", "[", "ueff", "]"}], "-", "vyslednanahrada"}], 
     RowBox[{"charaka", "[", "ueff", "]"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"ueff", ",", "0", ",", "Maxhod"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ueff\>\"", ",", "\"\<\[Delta][%]\>\""}], "}"}]}]}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"proud", "=", 
  RowBox[{"vyrproud", "/.", "dosab"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"u", ",", "umax", ",", "fi", ",", "imag"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"umax", "=", 
   RowBox[{"400", "*", 
    RowBox[{
     SuperscriptBox["10", "3"], "/", 
     SqrtBox["3"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2", "*", "\[Pi]", "*", "50"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{"umax", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fi", "[", "t_", "]"}], "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], 
    RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"imag", "[", "t_", "]"}], "=", 
  RowBox[{"proud", "/.", 
   RowBox[{"fi", "\[Rule]", 
    RowBox[{"fi", "[", "t", "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"imag", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0.02"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"imag", "[", "t", "]"}], ",", 
     RowBox[{"fi", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.001", ",", "0.02"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["umax", 
     SqrtBox["2"]], ",", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "T"], "*", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"imag", "[", "t", "]"}], "2"], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "T"}], "/", "2"}], ",", 
          RowBox[{"T", "/", "2"}]}], "}"}]}], "]"}]}]]}], "}"}], "//", 
  "N"}]}], "Input"],

Cell[BoxData[{"fitcharaky", "\[IndentingNewLine]", 
 RowBox[{"proud", "/.", 
  RowBox[{"fi", "->", 
   FractionBox[
    RowBox[{"ueff", "*", 
     SqrtBox["2"]}], "\[Omega]"]}]}], "\[IndentingNewLine]", 
 RowBox[{"fitcharaky", "-", "%"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"ueff", ",", "0", ",", "960"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ueff[V]\>\"", ",", "\"\<rozdil\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"pomdata", "=", 
  RowBox[{
   RowBox[{"Drop", "[", 
    RowBox[{"magChakaEf", ",", "1"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"napeti_", ",", "proudek_"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"napeti", ",", 
      RowBox[{"proudek", "/", "napeti"}]}], 
     "}"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"NonlinearFit", "[", 
  RowBox[{"pomdata", ",", 
   RowBox[{"c1", "+", 
    RowBox[{"c2", "*", 
     SuperscriptBox["uuuu", "k"]}]}], ",", "uuuu", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "0.01", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "0.01", ",", "0.001"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "5", ",", "20"}], "}"}]}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "1000"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"?", "Drop"}]], "Input"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"magChakaEf", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"magChakaEf", ">>", "\"\<dataTrafo\>\""}]], "Input",
 CellChangeTimes->{{3.68775367859375*^9, 3.687753687796875*^9}}]
},
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 304, 8, 80, "Input"],
Cell[864, 30, 68, 1, 35, "Input"],
Cell[935, 33, 7161, 228, 839, "Input"],
Cell[8099, 263, 1247, 40, 145, "Input"],
Cell[9349, 305, 556, 13, 102, "Input"],
Cell[9908, 320, 1563, 44, 176, "Input"],
Cell[11474, 366, 88, 2, 35, "Input"],
Cell[11565, 370, 1947, 62, 269, "Input"],
Cell[13515, 434, 570, 14, 126, "Input"],
Cell[14088, 450, 860, 25, 84, "Input"],
Cell[14951, 477, 47, 1, 35, "Input"],
Cell[15001, 480, 133, 3, 35, "Input"],
Cell[15137, 485, 140, 2, 35, "Input"]
}
]
*)

(* End of internal cache information *)

