(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28854,        874]
NotebookOptionsPosition[     28247,        852]
NotebookOutlinePosition[     28627,        868]
CellTagsIndexPosition[     28584,        865]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"randomMatrix", "[", "rnm_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "&"}], "[", "i", 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.685842236140625*^9, 3.685842236484375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"kfe", ".", "fjfi", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "limpouch"}]}], "/", "numet"}], "/", "nr"}], "/", 
     RowBox[{"node14", ".", "html"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"kfe", ".", "fjfi", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "limpouch"}]}], "/", "numet"}], "/", "nr"}], "/", 
     RowBox[{"node15", ".", "html"}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.6857809848125*^9, 3.685780987765625*^9}, {
  3.685781059265625*^9, 3.685781061765625*^9}}],

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"randomMatrix", "[", "n", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      RowBox[{"Random", "[", "]"}]}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"a", ".", "xvect"}], ")"}]}], "+", "p1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"b", ".", "xvect"}], ")"}]}], "+", "p2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f3", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"c", ".", "xvect"}], ")"}]}], "+", "p3"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectfces", "=", 
   RowBox[{"Through", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}], "[", "vars", "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"origEqns", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"vectfces", "\[Equal]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "&"}], "/@", 
       RowBox[{"Range", "[", "n", "]"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jacobian", "=", 
   RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xStart", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Random", "[", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
   RowBox[{"xPrevious", "-", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"jacobian", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"vectfces", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"xNext", "[", "xStart", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "origEqns", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "for", " ", "linear", " ", "equations", " ", "one", " ", "step", " ", "is",
     " ", "enough"}], "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.68584352715625*^9, {3.685843762765625*^9, 3.6858437718125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"nonlinear", " ", "example"}], ",", " ", 
    RowBox[{"quadratic", " ", "forms", " ", "zeros"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"randomMatrix", "[", "n", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], 
        RowBox[{"Random", "[", "]"}]}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f2", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f3", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p3"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "#"], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vectfces", "=", 
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}], "[", "vars", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origEqns", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{"vectfces", "\[Equal]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"0", "&"}], "/@", 
         RowBox[{"Range", "[", "n", "]"}]}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"grad", "[", "expr_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"jacobian", "=", 
     RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Random", "[", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"xPrevious", "-", 
      RowBox[{
       RowBox[{"Inverse", "[", 
        RowBox[{"jacobian", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
       RowBox[{"(", 
        RowBox[{"vectfces", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xNext", "[", "xStart", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"xNext", ",", "xStart", ",", "50"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{"origEqns", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"List", "[", 
         RowBox[{"vars", ",", "xStart"}], "]"}], "]"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", "origEqns", "]"}]}], "\[IndentingNewLine]", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.68584374725*^9, 3.685843840265625*^9}, {
   3.68584390375*^9, 3.685843921375*^9}, 3.686319570890625*^9, {
   3.686369638140625*^9, 3.6863696604375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"load", " ", "flow", " ", "problem"}], ",", " ", 
    RowBox[{
    "cartesian", " ", "form", " ", "of", " ", "complex", " ", "numbers"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simplify", "=", 
     RowBox[{"#", "&"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "\"\<lower\>\"", " ", "programing", " ", "languages", " ", "have", " ", 
      "no", " ", "Mathematica", " ", 
      RowBox[{"Simplify", "[", "#", "]"}]}], "&"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"simplify", "=", "Simplify"}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"conjugate", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"re", ",", 
       RowBox[{"-", "im"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"times", "[", 
      RowBox[{
       RowBox[{"ua", ":", 
        RowBox[{"{", 
         RowBox[{"uare_", ",", "uaim_"}], "}"}]}], ",", 
       RowBox[{"ub", ":", 
        RowBox[{"{", 
         RowBox[{"ubre_", ",", "ubim_"}], "}"}]}]}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"uare", "*", "ubre"}], "-", 
        RowBox[{"uaim", "*", "ubim"}]}], ",", 
       RowBox[{
        RowBox[{"uare", "*", "ubim"}], "+", 
        RowBox[{"ubre", "*", "uaim"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"re", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"re", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"im", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"im", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqabs", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["re", "2"], "+", 
        SuperscriptBox["im", "2"]}], ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"powerMinus1", "[", 
      RowBox[{"z", ":", 
       RowBox[{"{", 
        RowBox[{"re_", ",", "im_"}], "}"}]}], "]"}], ":=", 
     FractionBox[
      RowBox[{"{", 
       RowBox[{"re", ",", 
        RowBox[{"-", "im"}]}], "}"}], 
      RowBox[{
       SuperscriptBox["re", "2"], "+", 
       SuperscriptBox["im", "2"]}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ratio", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"times", "[", 
     RowBox[{
      RowBox[{"powerMinus1", "[", "b", "]"}], ",", "a"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"times", "[", 
      RowBox[{"u", ",", 
       RowBox[{"conjugate", "[", "i", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"activePower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"re", "[", 
      RowBox[{"apparentPower", "[", 
       RowBox[{"u", ",", "i"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"reactivePower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"im", "[", 
      RowBox[{"apparentPower", "[", 
       RowBox[{"u", ",", "i"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"current", "[", 
      RowBox[{"u1_", ",", "u2_", ",", "z_"}], "]"}], ":=", 
     RowBox[{"ratio", "[", 
      RowBox[{
       RowBox[{"u1", "-", "u2"}], ",", "z"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"toMyForm", "[", "z_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "z", "]"}], ",", 
       RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fromMyForm", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rearrangeRealEqn", "[", "eqn_Equal", "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"simplify", "[", "eqn", "]"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Equal", "[", 
        RowBox[{
         RowBox[{"a", "-", "b"}], ",", "0"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rearrangeComplexEqn", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rea_", ",", "ima_"}], "}"}], "\[Equal]", 
       RowBox[{"{", 
        RowBox[{"reb_", ",", "imb_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"DeleteCases", "[", 
        RowBox[{"#", ",", 
         RowBox[{"rearrangeRealEqn", "[", "True", "]"}]}], "]"}], "&"}], "@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"rearrangeRealEqn", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"simplify", "[", 
           RowBox[{"rea", "\[Equal]", "reb"}], "]"}], ",", 
          RowBox[{"simplify", "[", 
           RowBox[{"ima", "\[Equal]", "imb"}], "]"}]}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rearrangeComplexEqn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "\[Equal]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rearrangeRealEqn", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", 
      RowBox[{"y", "-", "x"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.686319588328125*^9, 3.6863196456875*^9}, {
   3.68631968075*^9, 3.686319865125*^9}, {3.6863199070625*^9, 
   3.6863201508125*^9}, {3.686320465609375*^9, 3.6863205451875*^9}, {
   3.686320598609375*^9, 3.68632071009375*^9}, {3.6863207813125*^9, 
   3.6863208234375*^9}, {3.686320899*^9, 3.686320913984375*^9}, {
   3.686320966625*^9, 3.68632110234375*^9}, {3.686321198015625*^9, 
   3.686321317671875*^9}, 3.68632140603125*^9, {3.686321932796875*^9, 
   3.686321933671875*^9}, {3.6863220218125*^9, 3.68632206846875*^9}, {
   3.68632216965625*^9, 3.686322249765625*^9}, {3.686322281375*^9, 
   3.68632252790625*^9}, {3.686322631125*^9, 3.686322729171875*^9}, {
   3.68632295625*^9, 3.6863229804375*^9}, {3.686323030578125*^9, 
   3.686323037125*^9}, {3.68632313046875*^9, 3.686323177765625*^9}, {
   3.686323819609375*^9, 3.686323852984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kz", "=", "2.5"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"respects", " ", "length", " ", "of", " ", "lines"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kReg", "=", "2.5"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"ratio", " ", "of", " ", "powers", " ", "of", " ", "sources"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["z", "1"], ",", 
     SubscriptBox["z", "2"], ",", 
     SubscriptBox["z", "3"]}], "}"}], "=", 
   RowBox[{"kz", "*", 
    RowBox[{"(", 
     RowBox[{"toMyForm", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{".01", "+", 
         RowBox[{"0.05", "I"}]}], ",", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"01", "+", 
           RowBox[{"0.05", "I"}]}], ")"}]}], ",", 
        RowBox[{"0.01", "+", 
         RowBox[{"0.02", "I"}]}]}], "}"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"powerFactor4", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"powerFactor5", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S4", "=", 
   RowBox[{
    SuperscriptBox["10", "3"], "*", 
    RowBox[{"{", 
     RowBox[{"powerFactor4", ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", "powerFactor4", "]"}], "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S5", "=", 
   RowBox[{"500", "*", 
    RowBox[{"{", 
     RowBox[{"powerFactor5", ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", "powerFactor5", "]"}], "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["u", "#"], "=", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ure", "#"], ",", 
         SubscriptBox["uim", "#"]}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["i", "#"], "=", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ire", "#"], ",", 
         SubscriptBox["iim", "#"]}], "}"}]}]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", "5", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unom", "=", "230."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnVoltage3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"sqabs", "[", 
      SubscriptBox["u", "3"], "]"}], "==", 
     RowBox[{"toMyForm", "[", 
      SuperscriptBox["Unom", "2"], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ1", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "1"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["z", "1"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ2", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "2"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "2"], ",", 
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["z", "2"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "3"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["z", "3"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnNod3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], "+", 
      SubscriptBox["i", "2"]}], "==", 
     SubscriptBox["i", "3"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnNod4", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "4"], "+", 
      SubscriptBox["i", "5"]}], "==", 
     SubscriptBox["i", "3"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSourceActivePowerRatio", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"activePower", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["i", "1"]}], "]"}], "\[Equal]", 
     RowBox[{
      StyleBox["kReg",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"activePower", "[", 
       RowBox[{
        SubscriptBox["u", "2"], ",", 
        SubscriptBox["i", "2"]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSourcReactivePowerRatio", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"reactivePower", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["i", "1"]}], "]"}], "\[Equal]", 
     RowBox[{
      StyleBox["kReg",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"reactivePower", "[", 
       RowBox[{
        SubscriptBox["u", "2"], ",", 
        SubscriptBox["i", "2"]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnApparentPower4", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["i", "4"]}], "]"}], "\[Equal]", "S4"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnApparentPower5", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["i", "5"]}], "]"}], "\[Equal]", "S5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSettingAbsoluteTime", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["ure", "3"], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnsTogether", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
    "eqnVoltage3", ",", "eqnZ1", ",", "eqnZ2", ",", "eqnZ3", ",", "eqnNod3", 
     ",", "eqnNod4", ",", "eqnSourceActivePowerRatio", ",", 
     "eqnSourcReactivePowerRatio", ",", "eqnApparentPower4", ",", 
     "eqnApparentPower5", ",", "eqnSettingAbsoluteTime"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"unknownVariables", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"eqnsTogether", ",", 
      RowBox[{"Subscript", "[", 
       RowBox[{"_", ",", "_"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{"eqnsTogether", ",", "unknownVariables"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.686323252125*^9, 3.686323311484375*^9}, {
   3.686323384921875*^9, 3.68632340784375*^9}, {3.686323539125*^9, 
   3.686323660265625*^9}, {3.6863237423125*^9, 3.686323768453125*^9}, {
   3.686323838484375*^9, 3.686323858984375*^9}, 3.686324372234375*^9, {
   3.6863244051875*^9, 3.686324473171875*^9}, {3.686324504296875*^9, 
   3.68632457775*^9}, {3.686324611359375*^9, 3.686324635125*^9}, {
   3.686324671375*^9, 3.686324693328125*^9}, {3.686324741578125*^9, 
   3.686324789015625*^9}, {3.68632497278125*^9, 3.68632501803125*^9}, {
   3.686325060625*^9, 3.68632506421875*^9}, {3.686325146*^9, 
   3.686325231015625*^9}, {3.686325261109375*^9, 3.686325518875*^9}, {
   3.68632555503125*^9, 3.6863257609375*^9}, {3.686325887453125*^9, 
   3.686325922265625*^9}, {3.68632598828125*^9, 3.686325994640625*^9}, 
   3.686326092484375*^9, {3.686326561*^9, 3.68632662028125*^9}, {
   3.68632667290625*^9, 3.686326698015625*^9}, {3.686326728625*^9, 
   3.686326743703125*^9}, 3.68632820165625*^9, {3.68632934275*^9, 
   3.686329403734375*^9}, {3.686369759734375*^9, 3.686369759921875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"secondParamteterOfFindRoot", "=", 
   RowBox[{"unknownVariables", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["iim", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["iim", "index"], ",", "1"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["ire", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ire", "index"], ",", "1"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["ure", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ure", "index"], ",", "Unom"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["uim", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["uim", "index"], ",", "Unom"}], "}"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"solFindRoot", "=", 
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{"eqnsTogether", ",", "secondParamteterOfFindRoot"}], "]"}], "//", 
   "Chop"}]}]}], "Input",
 CellChangeTimes->{{3.686327757328125*^9, 3.686327926953125*^9}, {
  3.686327958671875*^9, 3.6863280118125*^9}, {3.68632822096875*^9, 
  3.68632822284375*^9}, {3.686328878609375*^9, 3.68632888253125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectfces", "=", 
   RowBox[{"First", "/@", "eqnsTogether"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", "unknownVariables"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jacobian", "=", 
   RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xStart", "=", 
   RowBox[{"unknownVariables", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["iim", "index_"], "\[RuleDelayed]", "1"}], ",", 
      RowBox[{
       SubscriptBox["ire", "index_"], "\[RuleDelayed]", "1"}], ",", 
      RowBox[{
       SubscriptBox["ure", "index_"], "\[RuleDelayed]", "Unom"}], ",", 
      RowBox[{
       SubscriptBox["uim", "index_"], "\[RuleDelayed]", "Unom"}]}], "}"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
   RowBox[{"xPrevious", "-", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"jacobian", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"vectfces", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"xNext", ",", "xStart", ",", "50"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Thread", "[", 
  RowBox[{"vars", "\[Rule]", "aux"}], 
  "]"}], "\[IndentingNewLine]", "solFindRoot"}], "Input",
 CellChangeTimes->{{3.686328502015625*^9, 3.68632853075*^9}, {
  3.6863285624375*^9, 3.686328610890625*^9}, {3.68632872553125*^9, 
  3.686328893890625*^9}}],

Cell[BoxData[
 RowBox[{"mf", "@", 
  RowBox[{"(", 
   RowBox[{"Chop", "@", "jacobian"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.6863292439375*^9, 3.686329247578125*^9}, 
   3.68632932628125*^9, {3.68632945040625*^9, 3.686329468078125*^9}, {
   3.686369802109375*^9, 3.686369832921875*^9}}]
},
WindowSize->{1072, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.4000000953674316`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 954, 29, 142, "Input"],
Cell[1514, 51, 794, 23, 67, "Input"],
Cell[2311, 76, 3347, 107, 492, "Input"],
Cell[5661, 185, 4152, 125, 567, "Input"],
Cell[9816, 312, 6976, 203, 654, "Input"],
Cell[16795, 517, 7720, 226, 700, "Input"],
Cell[24518, 745, 1271, 34, 124, "Input"],
Cell[25792, 781, 2157, 61, 346, "Input"],
Cell[27952, 844, 291, 6, 41, "Input"]
}
]
*)

(* End of internal cache information *)
