(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     24356,        526]
NotebookOptionsPosition[     23682,        501]
NotebookOutlinePosition[     24062,        517]
CellTagsIndexPosition[     24019,        514]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Priklad", " ", "za", " ", "15", " ", "bodu", "\[IndentingNewLine]", "v", 
    " ", "souboru", " ", 
    RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", " ",
     "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"cas", ",", 
      RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
      RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
   RowBox[{
    RowBox[{"predpokladame", " ", "out"}], "=", 
    RowBox[{
     RowBox[{"p", "*", 
      RowBox[{"in", "[", "t", "]"}]}], "+", 
     RowBox[{"d", "*", 
      RowBox[{
       RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
     RowBox[{"i", "*", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", "t"], 
       RowBox[{
        RowBox[{"in", "[", "\[Tau]", "]"}], 
        RowBox[{
         RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
        "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
   RowBox[{"d", " ", "a", " ", "napiste", " ", 
    RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali", 
    " ", "svoji", " ", 
    RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
    "naprogramujete"}], ",", " ", 
   RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456078390625*^9, 3.72456080115625*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Priklad", " ", "za", " ", "15", " ", "bodu", "\[IndentingNewLine]", "V", 
     " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", "data", 
     " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
     "motor"}], "-", 
    RowBox[{
     RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
     "je"}], " ", "-", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]], "*", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
     "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
   RowBox[{"konstantu", " ", "treni"}], ",", " ", 
   RowBox[{
   "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
    "soustroji", " ", "rozebehne", " ", "pri", " ", "hancim", " ", "momentu", 
    " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
    "dobu", " ", "dosahne", " ", "ulova", " ", "rychlost", " ", "poloviny", 
    " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
    RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
   RowBox[{
   "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ", 
    "algoritmu", " ", "pro", " ", "zasumela", " ", 
    RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
   ",", " ", 
   RowBox[{"extra", " ", 
    RowBox[{"body", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.724560806765625*^9, 3.72456080821875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Priklad", " ", "za", " ", "15", " ", "bodu", "\[IndentingNewLine]", "V", 
    " ", "souboru", " ", "\"\<dataRC.csv\>\"", " ", "jsou", " ", "data", " ", 
    "ve", " ", "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"frekvence", ",", " ", 
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "paralelni", " ", 
    "kombinace", " ", "rezistoru", " ", "a", " ", "kondenzatoru"}], ",", " ", 
   RowBox[{"najdete", " ", "jejich", " ", "kapacitu", " ", "a", " ", 
    RowBox[{"odpor", ".", " ", "Popiste"}]}], ",", " ", 
   RowBox[{
   "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ", 
    "algoritmu", " ", "pro", " ", "zasumela", " ", 
    RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
   ",", " ", 
   RowBox[{"extra", " ", 
    RowBox[{"body", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456083340625*^9, 3.724560834765625*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Priklad", " ", "za", " ", "8", " ", "bodu", "\[IndentingNewLine]", "Mate",
     " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", " ", 
   RowBox[{
    RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
     RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "zivotnost"], 
      FractionBox["rocniUspora", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
   RowBox[{"IRR", " ", "takove"}], ",", " ", 
   RowBox[{
    RowBox[{"ze", " ", "0"}], "==", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "zivotnost"], 
      RowBox[{
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
       "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
       "dobou", " ", "navratnosti", " ", "definovanou", " ", "ta"}]}]}]}], 
   ",", " ", 
   RowBox[{
    RowBox[{"ze", " ", "0"}], "==", 
    RowBox[{
     RowBox[{"-", "INV"}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "Treal"], 
      FractionBox["rocniUspora", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"INV", "=", 
     RowBox[{"50.5", "*", 
      SuperscriptBox["10", "6"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"diskont", "=", "3.4"}], ";", "\[IndentingNewLine]", 
    RowBox[{"rocniUspora", "=", 
     RowBox[{"4.1", "*", 
      SuperscriptBox["10", "6"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"zivotnost", "=", "20"}], ";"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456084278125*^9, 3.724560848796875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Priklad", " ", "za", " ", "10", " ", "bodu", "\[IndentingNewLine]", "V", 
    " ", "souboru", " ", 
    RowBox[{"dataFrekvence", ".", "csv"}], " ", "jsou", " ", "dvojice", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cas", ",", "napeti"}], "}"}], ".", " ", "Najdete"}], " ", 
    "frekvenci", " ", "signalu", " ", "a", " ", "amplitudy", " ", 
    "harmonickych"}], ",", " ", 
   RowBox[{"vite", "-", 
    RowBox[{
    "li", " ", "ze", " ", "vyssi", " ", "nez", " ", "sesta", " ", "se", " ", 
     "v", " ", "signalu", " ", "nevyskytuje"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456089015625*^9, 3.7245609069375*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Priklad", " ", "za", " ", "10", " ", "bodu", "\[IndentingNewLine]", 
    "Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
   RowBox[{
    RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
    RowBox[{
     RowBox[{
     "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
      " ", "o", " ", "U"}], "=", 
     RowBox[{
     "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
      RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
      " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
      "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.7245608820625*^9, 3.7245608866875*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Priklad", " ", "za", " ", "8", " ", "bodu", "\[IndentingNewLine]", 
     "Tepelna", " ", "vodivost", " ", "cihlove", " ", "zdi", " ", "s", " ", 
     "izolaci", " ", "je", " ", 
     RowBox[{"\[Lambda]", "[", "x", "]"}]}], "=", 
    RowBox[{"0.4", "*", 
     RowBox[{"(", 
      RowBox[{"1.1", "+", 
       RowBox[{"Tanh", "[", 
        RowBox[{"500", 
         RowBox[{"(", 
          RowBox[{"x", "-", "0.1"}], ")"}]}], "]"}]}], ")"}]}]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"prislusna", " ", "rovnice", " ", "je", " ", "0"}], "==", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Lambda]", "[", "x", "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
        "]"}], ".", " ", "Okrajove"}], " ", "podminky", " ", "jsou", " ", 
      RowBox[{"T", "[", "0", "]"}]}]}], "=", 
    RowBox[{"-", "15"}]}], ",", " ", 
   RowBox[{
    RowBox[{"T", "[", "0.455", "]"}], "=", 
    RowBox[{"18.", " ", "Vyreste", " ", 
     RowBox[{"dif", ".", " ", "rovnici"}], " ", "a", " ", "zobrazte", " ", 
     "graf", " ", "reseni"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.72456086015625*^9, 3.724560863046875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Priklad", " ", "za", " ", "10", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Import", "[", "\"\<Agros 10.1.2018.png\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.724489746120225*^9, 3.7244897641046004`*^9}, {
  3.724560867796875*^9, 3.72456087509375*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3Tur7cqBJ/A9D4b5EE4G/ClONhM6Mj2B426YnQ6cGc7Q8w0mO8bJBX8B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    "], {{0, 393}, {774, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{774, 393},
  PlotRange->{{0, 774}, {0, 393}}]], "Output",
 CellChangeTimes->{{3.724489753338975*^9, 3.724489765182725*^9}}]
}, Open  ]]
},
WindowSize->{1091, 646},
WindowMargins->{{6, Automatic}, {Automatic, 5}},
Magnification->1.7000001668930054`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 330, 9, 107, "Input"],
Cell[891, 31, 1391, 34, 258, "Input"],
Cell[2285, 67, 1662, 37, 339, "Input"],
Cell[3950, 106, 1011, 21, 252, "Input"],
Cell[4964, 129, 2106, 57, 386, "Input"],
Cell[7073, 188, 712, 16, 165, "Input"],
Cell[7788, 206, 815, 18, 194, "Input"],
Cell[8606, 226, 1361, 36, 165, "Input"],
Cell[CellGroupData[{
Cell[9992, 266, 325, 7, 78, "Input"],
Cell[10320, 275, 13346, 223, 447, "Output"]
}, Open  ]]
}
]
*)

